/******************************************************************************
 * $Revision: 425 $
 * $Date:: 2017-05-19 10:28:09 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file adc_generated.c
 **
 ** Generated file for adc.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in adc.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by adc.c automatically!
 **
 ** History:
 **   - 2014-11-27  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __ADC_GENERATED_C__
#define __ADC_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "common_include.h"

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/
/** Macro to return the number of enabled ADC instances */
#define ADC_INSTANCE_COUNT (uint32_t)(sizeof(m_astcAdcInstanceDataLut) / sizeof(m_astcAdcInstanceDataLut[0]))


/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/** Look-up table for all enabled ADC instances and their internal data */
static stc_adc12b_instance_data_t m_astcAdcInstanceDataLut[] =
{
    #if (PDL_PERIPHERAL_ENABLE_ADC12B0 == PDL_ON)
    {
        &ADC12B0,       /* pstcInstance */
        {NULL},         /* stcInternData */
        0               /* u8UnitIndex */
    },
    #endif
};


/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 ******************************************************************************
 ** \brief Return the internal data for a certain ADC instance.
 **
 ** \param pstcAdc Pointer to ADC instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 ******************************************************************************/
stc_adc12b_intern_data_t* Adc12bGetInternDataPtr(volatile stc_adc12b0_t* pstcAdc)
{
    uint32_t u32Instance;

    for (u32Instance = 0; u32Instance < Adc12bInstanceIndexMax; u32Instance++)
    {
        if (pstcAdc == m_astcAdcInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcAdcInstanceDataLut[u32Instance].stcInternData;
        }
    }

    return NULL;
}


/*
 * Definition of all individual ISRs for each enabled ADC instance.
 * The individual ISR calls the generic IRQ handler with
 * the instance pointer and its internal data to handle the interrupt.
 */
FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b0_EndOfConversion(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_194;
    Adc12bIrqHandlerEndOfConversion(&ADC12B0, &(m_astcAdcInstanceDataLut[Adc12bInstanceIndexAdc0].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b0_GroupInt(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_195;
    Adc12bIrqHandlerGroupInt(&ADC12B0, &(m_astcAdcInstanceDataLut[Adc12bInstanceIndexAdc0].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b0_PulseDetection(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_196;
    Adc12bIrqHandlerPulseDetection(&ADC12B0, &(m_astcAdcInstanceDataLut[Adc12bInstanceIndexAdc0].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b0_RangeCompare(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_197;
    Adc12bIrqHandlerRangeComparator(&ADC12B0, &(m_astcAdcInstanceDataLut[Adc12bInstanceIndexAdc0].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

volatile uint16_t AdcValList[64] = {0};
static void SampleAdEofConversionCallBack(stc_adc12b_channel_list_t stcDetectList)
{
    // stcDetectList.stcChannel[0].stc_ch.AD_CH_14 = 1;
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_0 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 0, (uint16_t*)&AdcValList[0])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_1 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 1, (uint16_t*)&AdcValList[1])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_2 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 2, (uint16_t*)&AdcValList[2])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_3 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 3, (uint16_t*)&AdcValList[3])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_4 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 4, (uint16_t*)&AdcValList[4])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_5 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 5, (uint16_t*)&AdcValList[5])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_6 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 6, (uint16_t*)&AdcValList[6])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_7 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 7, (uint16_t*)&AdcValList[7])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_8 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 8, (uint16_t*)&AdcValList[8])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_9 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 9, (uint16_t*)&AdcValList[9])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_10 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 10, (uint16_t*)&AdcValList[10])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_11 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 11, (uint16_t*)&AdcValList[11])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_12 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 12, (uint16_t*)&AdcValList[12])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_13 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 13, (uint16_t*)&AdcValList[13])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_14 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 14, (uint16_t*)&AdcValList[14])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_15 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 15, (uint16_t*)&AdcValList[15])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_16 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 16, (uint16_t*)&AdcValList[16])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_17 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 17, (uint16_t*)&AdcValList[17])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_18 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 18, (uint16_t*)&AdcValList[18])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_19 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 19, (uint16_t*)&AdcValList[19])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_20 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 20, (uint16_t*)&AdcValList[20])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_21 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 21, (uint16_t*)&AdcValList[21])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_22 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 22, (uint16_t*)&AdcValList[22])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_23 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 23, (uint16_t*)&AdcValList[23])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_24 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 24, (uint16_t*)&AdcValList[24])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_25 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 25, (uint16_t*)&AdcValList[25])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_26 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 26, (uint16_t*)&AdcValList[26])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_27 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 27, (uint16_t*)&AdcValList[27])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_28 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 28, (uint16_t*)&AdcValList[28])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_29 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 29, (uint16_t*)&AdcValList[29])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_30 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 30, (uint16_t*)&AdcValList[30])) : (0);
    (stcDetectList.stcChannel[0].stc_ch.AD_CH_31 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 31, (uint16_t*)&AdcValList[31])) : (0);
    
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_0 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 32, (uint16_t*)&AdcValList[32])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_1 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 33, (uint16_t*)&AdcValList[33])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_2 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 34, (uint16_t*)&AdcValList[34])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_3 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 35, (uint16_t*)&AdcValList[35])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_4 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 36, (uint16_t*)&AdcValList[36])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_5 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 37, (uint16_t*)&AdcValList[37])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_6 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 38, (uint16_t*)&AdcValList[38])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_7 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 39, (uint16_t*)&AdcValList[39])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_8 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 40, (uint16_t*)&AdcValList[40])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_9 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 41, (uint16_t*)&AdcValList[41])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_10 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 42, (uint16_t*)&AdcValList[42])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_11 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 43, (uint16_t*)&AdcValList[43])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_12 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 44, (uint16_t*)&AdcValList[44])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_13 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 45, (uint16_t*)&AdcValList[45])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_14 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 46, (uint16_t*)&AdcValList[46])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_15 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 47, (uint16_t*)&AdcValList[47])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_16 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 48, (uint16_t*)&AdcValList[48])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_17 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 49, (uint16_t*)&AdcValList[49])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_18 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 50, (uint16_t*)&AdcValList[50])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_19 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 51, (uint16_t*)&AdcValList[51])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_20 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 52, (uint16_t*)&AdcValList[52])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_21 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 53, (uint16_t*)&AdcValList[53])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_22 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 54, (uint16_t*)&AdcValList[54])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_23 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 55, (uint16_t*)&AdcValList[55])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_24 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 56, (uint16_t*)&AdcValList[56])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_25 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 57, (uint16_t*)&AdcValList[57])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_26 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 58, (uint16_t*)&AdcValList[58])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_27 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 59, (uint16_t*)&AdcValList[59])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_28 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 60, (uint16_t*)&AdcValList[60])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_29 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 61, (uint16_t*)&AdcValList[61])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_30 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 62, (uint16_t*)&AdcValList[62])) : (0);
    (stcDetectList.stcChannel[1].stc_ch.AD_CH_31 != 0) ? (Adc12b_GetConversionData(&ADC12B0, 63, (uint16_t*)&AdcValList[63])) : (0);
    
    Adc12b_ClearGroupIntInterruptFlag(&ADC12B0, stcDetectList);
}

void InitADCch(uint8_t ch)
{
    stc_adc12b_channel_config_t ch_config;
    ch_config.u8PhysicalCh = ch;
    ch_config.u8Priority = 0;
    ch_config.enResumeMode = Adc12bResumeModeRestart;
    ch_config.bDataProtection = TRUE;
    ch_config.u8SamplingTimeRegNum = 0;
    ch_config.bUseConversionDoneInterrupt = TRUE;
    ch_config.bUseGroupInterruptedInterrupt = FALSE;
    ch_config.enTriggerType = Adc12bSoftTrigger;
    Adc12b_SetChannelConfig(&ADC12B0, ch, &ch_config);

    
    Adc12b_SetComparisonTime(&ADC12B0, 4);
    Adc12b_SetResumptionTime(&ADC12B0, 63);
    Adc12b_SetSamplingTime(&ADC12B0, 0, 20);
    //Adc12b_TriggerConversion(&ADC12B0, ch);   
}

void InitADC(void)
{
    stc_adc12b_config_t adc_config;
    adc_config.bPowerDownDisable = TRUE;
    adc_config.enRangeComparatorMode = Adc12bRangeComparatorMode12bit;
    adc_config.bEnableForcedStop = FALSE;
    adc_config.enAchMode = Adc12bAchModeDirect;
    adc_config.bEnableDebugMode = TRUE;
    adc_config.enResolution = Adc12bResolution12bit;
    adc_config.pfnEofConversionCallback = SampleAdEofConversionCallBack;
    adc_config.pfnGprIntCallback = NULL;
    adc_config.pfnPulseDetectionCallback = NULL;
    adc_config.pfnRangeComparatorCallback = NULL;
    Adc12b_Init(&ADC12B0, &adc_config);       
}

#endif  // __ADC_GENERATED_C__

