/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file bt_pwm_generated.c
 **
 ** Generated file for bt_pwm.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in bt_pwm.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by bt_pwm.c automatically!
 **
 ** History:
 **   - 2014-06-26  0.01  HS  Initial version for Traveo
 *****************************************************************************/

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "common_include.h"

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/* Macro to return the number of enabled PWM instances */
#define PWM_INSTANCE_COUNT (uint32_t)(sizeof(m_astcPwmInstanceDataLut) / sizeof(m_astcPwmInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/* Enumeration to define an index for each enabled PWM instance */
typedef enum en_pwm_instance_index
{
    PwmInstanceIndexPwm0,
    PwmInstanceIndexPwm1,
    PwmInstanceIndexPwm2,
    PwmInstanceIndexPwm3,
    PwmInstanceIndexPwm4,
    PwmInstanceIndexPwm5,
    PwmInstanceIndexPwm6,
    PwmInstanceIndexPwm7,
    PwmInstanceIndexPwm8,
    PwmInstanceIndexPwm9,
    PwmInstanceIndexPwm10,
    PwmInstanceIndexPwm11,
    PwmInstanceIndexPwm12,
    PwmInstanceIndexPwm13,
    PwmInstanceIndexPwm14,
    PwmInstanceIndexPwm15,
    PwmInstanceIndexPwm16,
    PwmInstanceIndexPwm17,
    PwmInstanceIndexPwm18,
    PwmInstanceIndexPwm19,
    PwmInstanceIndexPwm20,
    PwmInstanceIndexPwm21,
    PwmInstanceIndexPwm22,
    PwmInstanceIndexPwm23,
    PwmInstanceIndexPwm24,
    PwmInstanceIndexPwm25,
    PwmInstanceIndexPwm26,
    PwmInstanceIndexPwm27,
    PwmInstanceIndexPwm28,
    PwmInstanceIndexPwm29,
    PwmInstanceIndexPwm30,
    PwmInstanceIndexPwm31,
    PwmInstanceIndexMax
} en_pwm_instance_index_t;
    
/* PWM instance data type */
typedef struct stc_pwm_instance_data
{
    volatile stc_btn_pwm_t* pstcInstance;   /*!< pointer to registers of an instance */
    stc_pwm_intern_data_t stcInternData;    /*!< module internal data of instance */
} stc_pwm_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/* Look-up table for all enabled PWM instances and their internal data */
static stc_pwm_instance_data_t m_astcPwmInstanceDataLut[] =
{
    {&BT00_PWM, {NULL}},
    {&BT01_PWM, {NULL}},
    {&BT02_PWM, {NULL}},
    {&BT03_PWM, {NULL}},
    {&BT04_PWM, {NULL}},
    {&BT05_PWM, {NULL}},
    {&BT06_PWM, {NULL}},
    {&BT07_PWM, {NULL}},
    {&BT08_PWM, {NULL}},
    {&BT09_PWM, {NULL}},
    {&BT10_PWM, {NULL}},
    {&BT11_PWM, {NULL}},
    {&BT12_PWM, {NULL}},
    {&BT13_PWM, {NULL}},
    {&BT14_PWM, {NULL}},
    {&BT15_PWM, {NULL}},
    {&BT16_PWM, {NULL}},
    {&BT17_PWM, {NULL}},
    {&BT18_PWM, {NULL}},
    {&BT19_PWM, {NULL}},
    {&BT20_PWM, {NULL}},
    {&BT21_PWM, {NULL}},
    {&BT22_PWM, {NULL}},
    {&BT23_PWM, {NULL}},
    {&BT24_PWM, {NULL}},
    {&BT25_PWM, {NULL}},
    {&BT26_PWM, {NULL}},
    {&BT27_PWM, {NULL}},
    {&BT28_PWM, {NULL}},
    {&BT29_PWM, {NULL}},
    {&BT30_PWM, {NULL}},
    {&BT31_PWM, {NULL}},
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 *****************************************************************************
 ** \brief Return the internal data for a certain PWM instance.
 **
 ** \param pstcPwm Pointer to PWM instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 *****************************************************************************/
stc_pwm_intern_data_t* BtPwmGetInternDataPtr(volatile stc_btn_pwm_t* pstcPwm) 
{
    uint32_t u32Instance;
   
    for (u32Instance = 0; u32Instance < PWM_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcPwm == m_astcPwmInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcPwmInstanceDataLut[u32Instance].stcInternData;
        }
    }

    return NULL;
}

/**
 *****************************************************************************
 ** Definition of all individual ISRs for each enabled PWM instance.
 **
 ** The individual ISR calls the generic IRQ handler with
 ** the instance pointer and its internal data to handle the interrupt.
 *****************************************************************************/
FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm0(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_100;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT00_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm0].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT08_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm8].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT09_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm9].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT10_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm10].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT11_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm11].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm1(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_101;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT01_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm1].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm2(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_102;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT02_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm2].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm3(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_103;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT03_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm3].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm4(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_104;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT04_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm4].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm5(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_105;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT05_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm5].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm6(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_106;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT06_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm6].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm7(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_107;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT07_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm7].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm12(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_108;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT12_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm12].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT20_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm20].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT21_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm21].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT22_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm22].stcInternData));
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT23_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm23].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm13(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_109;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT13_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm13].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm14(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_110;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT14_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm14].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm15(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_111;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT15_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm15].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm16(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_112;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT16_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm16].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm17(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_113;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT17_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm17].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm18(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_114;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT18_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm18].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm19(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_115;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT19_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm19].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm24(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_116;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT24_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm24].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm25(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_117;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT25_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm25].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm26(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_118;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT26_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm26].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm27(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_119;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT27_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm27].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm28(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_120;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT28_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm28].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm29(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_121;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT29_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm29].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm30(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_122;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT30_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm30].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Pwm_Isr_Pwm31(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_123;
    BtPwmIrqHandler((stc_btn_pwm_t*)&BT31_PWM, &(m_astcPwmInstanceDataLut[PwmInstanceIndexPwm31].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

en_result_t Pwm_Init(uint8_t ch, stc_pwm_config_t* pstcConfig)
{
  return Bt_Pwm_Init(m_astcPwmInstanceDataLut[ch].pstcInstance, pstcConfig);
}

en_result_t Pwm_Start(uint8_t ch, stc_pwm_cycle_config_t *cycle)
{
  return Bt_Pwm_Start(m_astcPwmInstanceDataLut[ch].pstcInstance, cycle, TRUE);
}

en_result_t Pwm_Stop(uint8_t ch)
{
  return Bt_Pwm_Stop(m_astcPwmInstanceDataLut[ch].pstcInstance);
}


void Pwm_Config(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
      stc_pwm_config_t pwmConfig;
      stc_pwm_cycle_config_t pwmDutyConfig;
        
      pwmConfig.enPrescaler = PwmDiv1;
      pwmConfig.bRestartEnable = TRUE;
      pwmConfig.bPulseOutputMaskEnable = FALSE;
      pwmConfig.enTriggerInputEdgeSelection = PwmSoftwareOnly;
      pwmConfig.bOutputPolarityInverse = FALSE;
      pwmConfig.bOneShotOperation = FALSE;
      pwmConfig.pfnTriggerCallback = NULL;
      pwmConfig.pfnDutyMatchCallback = NULL;
      pwmConfig.pfnUnderflowCallback = NULL;
      Pwm_Init(ch, &pwmConfig);
      
      if (Duty != 0) {
          pwmDutyConfig.u16Cycle = Cycle;
          pwmDutyConfig.u16Duty = Duty;
          pwmDutyConfig.u16StartDelay = 0;
          pwmDutyConfig.u16AdcTriggerValue = 0;    
          Pwm_Start(ch, &pwmDutyConfig);
      } else {
          Pwm_Stop(ch);
      }
}

void Speed_Output_Pwm_Config(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    stc_pwm_config_t pwmConfig;
    stc_pwm_cycle_config_t pwmDutyConfig;

    pwmConfig.enPrescaler = PwmDiv1024;
    pwmConfig.bRestartEnable = TRUE;
    pwmConfig.bPulseOutputMaskEnable = FALSE;
    pwmConfig.enTriggerInputEdgeSelection = PwmSoftwareOnly;
    pwmConfig.bOutputPolarityInverse = FALSE;
    pwmConfig.bOneShotOperation = FALSE;
    pwmConfig.pfnTriggerCallback = NULL;
    pwmConfig.pfnDutyMatchCallback = NULL;
    pwmConfig.pfnUnderflowCallback = NULL;
    Pwm_Init(ch, &pwmConfig);

    pwmDutyConfig.u16Cycle = Cycle;
    pwmDutyConfig.u16Duty = Duty;
    pwmDutyConfig.u16StartDelay = 0;
    pwmDutyConfig.u16AdcTriggerValue = 0;    
    Pwm_Start(ch, &pwmDutyConfig);
}

void Speed_Output_Update(uint16_t Cycle, uint16_t Duty)
{
    m_astcPwmInstanceDataLut[3].pstcInstance->unPCSR.u16Register = Cycle;
    m_astcPwmInstanceDataLut[3].pstcInstance->unPDUT.u16Register = Duty;

    //stc_pwm_cycle_config_t pwmDutyConfig;
    //pwmDutyConfig.u16Cycle = Cycle;
    //pwmDutyConfig.u16Duty = Duty;
    //pwmDutyConfig.u16StartDelay = 0;
    //pwmDutyConfig.u16AdcTriggerValue = 0;    
    //Pwm_Start(3, &pwmDutyConfig);
}

void ILL_Output_PwmConfig(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    stc_pwm_config_t pwmConfig;
    stc_pwm_cycle_config_t pwmDutyConfig;

    pwmConfig.enPrescaler = PwmDiv128;
    pwmConfig.bRestartEnable = TRUE;
    pwmConfig.bPulseOutputMaskEnable = FALSE;
    pwmConfig.enTriggerInputEdgeSelection = PwmSoftwareOnly;
    pwmConfig.bOutputPolarityInverse = FALSE;
    pwmConfig.bOneShotOperation = FALSE;
    pwmConfig.pfnTriggerCallback = NULL;
    pwmConfig.pfnDutyMatchCallback = NULL;
    pwmConfig.pfnUnderflowCallback = NULL;
    Pwm_Init(ch, &pwmConfig);

    pwmDutyConfig.u16Cycle = Cycle;
    pwmDutyConfig.u16Duty = Duty;
    pwmDutyConfig.u16StartDelay = 0;
    pwmDutyConfig.u16AdcTriggerValue = 0;    
    Pwm_Start(ch, &pwmDutyConfig);
}

void ILL_Output_Update(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    m_astcPwmInstanceDataLut[ch].pstcInstance->unPCSR.u16Register = Cycle;
    m_astcPwmInstanceDataLut[ch].pstcInstance->unPDUT.u16Register = Duty;
}


void VEH_Output_PwmConfig(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    stc_pwm_config_t pwmConfig;
    stc_pwm_cycle_config_t pwmDutyConfig;

    pwmConfig.enPrescaler = PwmDiv256;
    pwmConfig.bRestartEnable = TRUE;
    pwmConfig.bPulseOutputMaskEnable = FALSE;
    pwmConfig.enTriggerInputEdgeSelection = PwmSoftwareOnly;
    pwmConfig.bOutputPolarityInverse = FALSE;
    pwmConfig.bOneShotOperation = FALSE;
    pwmConfig.pfnTriggerCallback = NULL;
    pwmConfig.pfnDutyMatchCallback = NULL;
    pwmConfig.pfnUnderflowCallback = NULL;
    Pwm_Init(ch, &pwmConfig);

    pwmDutyConfig.u16Cycle = Cycle;
    pwmDutyConfig.u16Duty = Duty;
    pwmDutyConfig.u16StartDelay = 0;
    pwmDutyConfig.u16AdcTriggerValue = 0;    
    Pwm_Start(ch, &pwmDutyConfig);
}

void VEH_Output_Update(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    uint32_t temp = 0;
    if(Cycle){
        temp = (33000000u/256u) / Cycle;
    }
    m_astcPwmInstanceDataLut[ch].pstcInstance->unPCSR.u16Register = temp;
    m_astcPwmInstanceDataLut[ch].pstcInstance->unPDUT.u16Register = (temp*Duty)/100u;
}
void REV_Output_PwmConfig(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    stc_pwm_config_t pwmConfig;
    stc_pwm_cycle_config_t pwmDutyConfig;

    pwmConfig.enPrescaler = PwmDiv256;
    pwmConfig.bRestartEnable = TRUE;
    pwmConfig.bPulseOutputMaskEnable = FALSE;
    pwmConfig.enTriggerInputEdgeSelection = PwmSoftwareOnly;
    pwmConfig.bOutputPolarityInverse = FALSE;
    pwmConfig.bOneShotOperation = FALSE;
    pwmConfig.pfnTriggerCallback = NULL;
    pwmConfig.pfnDutyMatchCallback = NULL;
    pwmConfig.pfnUnderflowCallback = NULL;
    Pwm_Init(ch, &pwmConfig);

    pwmDutyConfig.u16Cycle = Cycle;
    pwmDutyConfig.u16Duty = Duty;
    pwmDutyConfig.u16StartDelay = 0;
    pwmDutyConfig.u16AdcTriggerValue = 0;    
    Pwm_Start(ch, &pwmDutyConfig);
}
void REV_Output_Update(uint8_t ch, uint16_t Cycle, uint16_t Duty)
{
    uint32_t temp = 0;
    if(Cycle){
        temp = (33000000u/256u) / Cycle;
    }
    m_astcPwmInstanceDataLut[ch].pstcInstance->unPCSR.u16Register = temp;
    m_astcPwmInstanceDataLut[ch].pstcInstance->unPDUT.u16Register = (temp*Duty)/100u;
}


