/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_BT_PWM_H
#define __S6J3360_BT_PWM_H

#include "s6j3360io_basetypes.h"

/* BT[00-31]_PWM base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT00_PWM	stcBT_PWM[0]
#define BT01_PWM	stcBT_PWM[1]
#define BT02_PWM	stcBT_PWM[2]
#define BT03_PWM	stcBT_PWM[3]
#define BT04_PWM	stcBT_PWM[4]
#define BT05_PWM	stcBT_PWM[5]
#define BT06_PWM	stcBT_PWM[6]
#define BT07_PWM	stcBT_PWM[7]
#define BT08_PWM	stcBT_PWM[8]
#define BT09_PWM	stcBT_PWM[9]
#define BT10_PWM	stcBT_PWM[10]
#define BT11_PWM	stcBT_PWM[11]
#define BT12_PWM	stcBT_PWM[12]
#define BT13_PWM	stcBT_PWM[13]
#define BT14_PWM	stcBT_PWM[14]
#define BT15_PWM	stcBT_PWM[15]
#define BT16_PWM	stcBT_PWM[16]
#define BT17_PWM	stcBT_PWM[17]
#define BT18_PWM	stcBT_PWM[18]
#define BT19_PWM	stcBT_PWM[19]
#define BT20_PWM	stcBT_PWM[20]
#define BT21_PWM	stcBT_PWM[21]
#define BT22_PWM	stcBT_PWM[22]
#define BT23_PWM	stcBT_PWM[23]
#define BT24_PWM	stcBT_PWM[24]
#define BT25_PWM	stcBT_PWM[25]
#define BT26_PWM	stcBT_PWM[26]
#define BT27_PWM	stcBT_PWM[27]
#define BT28_PWM	stcBT_PWM[28]
#define BT29_PWM	stcBT_PWM[29]
#define BT30_PWM	stcBT_PWM[30]
#define BT31_PWM	stcBT_PWM[31]
#else /* __IO_DEFINE */
#define BT00_PWM	(*((volatile stc_btn_pwm_t*)0xB4808000))
#define BT01_PWM	(*((volatile stc_btn_pwm_t*)0xB4808400))
#define BT02_PWM	(*((volatile stc_btn_pwm_t*)0xB4808800))
#define BT03_PWM	(*((volatile stc_btn_pwm_t*)0xB4808C00))
#define BT04_PWM	(*((volatile stc_btn_pwm_t*)0xB4809000))
#define BT05_PWM	(*((volatile stc_btn_pwm_t*)0xB4809400))
#define BT06_PWM	(*((volatile stc_btn_pwm_t*)0xB4809800))
#define BT07_PWM	(*((volatile stc_btn_pwm_t*)0xB4809C00))
#define BT08_PWM	(*((volatile stc_btn_pwm_t*)0xB480A000))
#define BT09_PWM	(*((volatile stc_btn_pwm_t*)0xB480A400))
#define BT10_PWM	(*((volatile stc_btn_pwm_t*)0xB480A800))
#define BT11_PWM	(*((volatile stc_btn_pwm_t*)0xB480AC00))
#define BT12_PWM	(*((volatile stc_btn_pwm_t*)0xB4888000))
#define BT13_PWM	(*((volatile stc_btn_pwm_t*)0xB4888400))
#define BT14_PWM	(*((volatile stc_btn_pwm_t*)0xB4888800))
#define BT15_PWM	(*((volatile stc_btn_pwm_t*)0xB4888C00))
#define BT16_PWM	(*((volatile stc_btn_pwm_t*)0xB4889000))
#define BT17_PWM	(*((volatile stc_btn_pwm_t*)0xB4889400))
#define BT18_PWM	(*((volatile stc_btn_pwm_t*)0xB4889800))
#define BT19_PWM	(*((volatile stc_btn_pwm_t*)0xB4889C00))
#define BT20_PWM	(*((volatile stc_btn_pwm_t*)0xB488A000))
#define BT21_PWM	(*((volatile stc_btn_pwm_t*)0xB488A400))
#define BT22_PWM	(*((volatile stc_btn_pwm_t*)0xB488A800))
#define BT23_PWM	(*((volatile stc_btn_pwm_t*)0xB488AC00))
#define BT24_PWM	(*((volatile stc_btn_pwm_t*)0xB4846000))
#define BT25_PWM	(*((volatile stc_btn_pwm_t*)0xB4846400))
#define BT26_PWM	(*((volatile stc_btn_pwm_t*)0xB4846800))
#define BT27_PWM	(*((volatile stc_btn_pwm_t*)0xB4846C00))
#define BT28_PWM	(*((volatile stc_btn_pwm_t*)0xB4847000))
#define BT29_PWM	(*((volatile stc_btn_pwm_t*)0xB4847400))
#define BT30_PWM	(*((volatile stc_btn_pwm_t*)0xB4847800))
#define BT31_PWM	(*((volatile stc_btn_pwm_t*)0xB4847C00))
#endif /* __IO_DEFINE */

/* PCSR */
#define BT00_PWM_PCSR	(BT00_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT00_PWM_PCSR_PCSR	BT00_PWM_PCSR  /*@bfrg@*/

#define BT01_PWM_PCSR	(BT01_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT01_PWM_PCSR_PCSR	BT01_PWM_PCSR  /*@bfrg@*/

#define BT02_PWM_PCSR	(BT02_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT02_PWM_PCSR_PCSR	BT02_PWM_PCSR  /*@bfrg@*/

#define BT03_PWM_PCSR	(BT03_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT03_PWM_PCSR_PCSR	BT03_PWM_PCSR  /*@bfrg@*/

#define BT04_PWM_PCSR	(BT04_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT04_PWM_PCSR_PCSR	BT04_PWM_PCSR  /*@bfrg@*/

#define BT05_PWM_PCSR	(BT05_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT05_PWM_PCSR_PCSR	BT05_PWM_PCSR  /*@bfrg@*/

#define BT06_PWM_PCSR	(BT06_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT06_PWM_PCSR_PCSR	BT06_PWM_PCSR  /*@bfrg@*/

#define BT07_PWM_PCSR	(BT07_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT07_PWM_PCSR_PCSR	BT07_PWM_PCSR  /*@bfrg@*/

#define BT08_PWM_PCSR	(BT08_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT08_PWM_PCSR_PCSR	BT08_PWM_PCSR  /*@bfrg@*/

#define BT09_PWM_PCSR	(BT09_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT09_PWM_PCSR_PCSR	BT09_PWM_PCSR  /*@bfrg@*/

#define BT10_PWM_PCSR	(BT10_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT10_PWM_PCSR_PCSR	BT10_PWM_PCSR  /*@bfrg@*/

#define BT11_PWM_PCSR	(BT11_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT11_PWM_PCSR_PCSR	BT11_PWM_PCSR  /*@bfrg@*/

#define BT12_PWM_PCSR	(BT12_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT12_PWM_PCSR_PCSR	BT12_PWM_PCSR  /*@bfrg@*/

#define BT13_PWM_PCSR	(BT13_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT13_PWM_PCSR_PCSR	BT13_PWM_PCSR  /*@bfrg@*/

#define BT14_PWM_PCSR	(BT14_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT14_PWM_PCSR_PCSR	BT14_PWM_PCSR  /*@bfrg@*/

#define BT15_PWM_PCSR	(BT15_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT15_PWM_PCSR_PCSR	BT15_PWM_PCSR  /*@bfrg@*/

#define BT16_PWM_PCSR	(BT16_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT16_PWM_PCSR_PCSR	BT16_PWM_PCSR  /*@bfrg@*/

#define BT17_PWM_PCSR	(BT17_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT17_PWM_PCSR_PCSR	BT17_PWM_PCSR  /*@bfrg@*/

#define BT18_PWM_PCSR	(BT18_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT18_PWM_PCSR_PCSR	BT18_PWM_PCSR  /*@bfrg@*/

#define BT19_PWM_PCSR	(BT19_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT19_PWM_PCSR_PCSR	BT19_PWM_PCSR  /*@bfrg@*/

#define BT20_PWM_PCSR	(BT20_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT20_PWM_PCSR_PCSR	BT20_PWM_PCSR  /*@bfrg@*/

#define BT21_PWM_PCSR	(BT21_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT21_PWM_PCSR_PCSR	BT21_PWM_PCSR  /*@bfrg@*/

#define BT22_PWM_PCSR	(BT22_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT22_PWM_PCSR_PCSR	BT22_PWM_PCSR  /*@bfrg@*/

#define BT23_PWM_PCSR	(BT23_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT23_PWM_PCSR_PCSR	BT23_PWM_PCSR  /*@bfrg@*/

#define BT24_PWM_PCSR	(BT24_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT24_PWM_PCSR_PCSR	BT24_PWM_PCSR  /*@bfrg@*/

#define BT25_PWM_PCSR	(BT25_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT25_PWM_PCSR_PCSR	BT25_PWM_PCSR  /*@bfrg@*/

#define BT26_PWM_PCSR	(BT26_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT26_PWM_PCSR_PCSR	BT26_PWM_PCSR  /*@bfrg@*/

#define BT27_PWM_PCSR	(BT27_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT27_PWM_PCSR_PCSR	BT27_PWM_PCSR  /*@bfrg@*/

#define BT28_PWM_PCSR	(BT28_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT28_PWM_PCSR_PCSR	BT28_PWM_PCSR  /*@bfrg@*/

#define BT29_PWM_PCSR	(BT29_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT29_PWM_PCSR_PCSR	BT29_PWM_PCSR  /*@bfrg@*/

#define BT30_PWM_PCSR	(BT30_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT30_PWM_PCSR_PCSR	BT30_PWM_PCSR  /*@bfrg@*/

#define BT31_PWM_PCSR	(BT31_PWM.unPCSR.u16Register)  /*@rg@*/
#define BT31_PWM_PCSR_PCSR	BT31_PWM_PCSR  /*@bfrg@*/

typedef union un_btn_pwm_pcsr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_pcsr_t;

/* PDUT */
#define BT00_PWM_PDUT	(BT00_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT00_PWM_PDUT_PDUT	BT00_PWM_PDUT  /*@bfrg@*/

#define BT01_PWM_PDUT	(BT01_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT01_PWM_PDUT_PDUT	BT01_PWM_PDUT  /*@bfrg@*/

#define BT02_PWM_PDUT	(BT02_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT02_PWM_PDUT_PDUT	BT02_PWM_PDUT  /*@bfrg@*/

#define BT03_PWM_PDUT	(BT03_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT03_PWM_PDUT_PDUT	BT03_PWM_PDUT  /*@bfrg@*/

#define BT04_PWM_PDUT	(BT04_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT04_PWM_PDUT_PDUT	BT04_PWM_PDUT  /*@bfrg@*/

#define BT05_PWM_PDUT	(BT05_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT05_PWM_PDUT_PDUT	BT05_PWM_PDUT  /*@bfrg@*/

#define BT06_PWM_PDUT	(BT06_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT06_PWM_PDUT_PDUT	BT06_PWM_PDUT  /*@bfrg@*/

#define BT07_PWM_PDUT	(BT07_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT07_PWM_PDUT_PDUT	BT07_PWM_PDUT  /*@bfrg@*/

#define BT08_PWM_PDUT	(BT08_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT08_PWM_PDUT_PDUT	BT08_PWM_PDUT  /*@bfrg@*/

#define BT09_PWM_PDUT	(BT09_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT09_PWM_PDUT_PDUT	BT09_PWM_PDUT  /*@bfrg@*/

#define BT10_PWM_PDUT	(BT10_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT10_PWM_PDUT_PDUT	BT10_PWM_PDUT  /*@bfrg@*/

#define BT11_PWM_PDUT	(BT11_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT11_PWM_PDUT_PDUT	BT11_PWM_PDUT  /*@bfrg@*/

#define BT12_PWM_PDUT	(BT12_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT12_PWM_PDUT_PDUT	BT12_PWM_PDUT  /*@bfrg@*/

#define BT13_PWM_PDUT	(BT13_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT13_PWM_PDUT_PDUT	BT13_PWM_PDUT  /*@bfrg@*/

#define BT14_PWM_PDUT	(BT14_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT14_PWM_PDUT_PDUT	BT14_PWM_PDUT  /*@bfrg@*/

#define BT15_PWM_PDUT	(BT15_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT15_PWM_PDUT_PDUT	BT15_PWM_PDUT  /*@bfrg@*/

#define BT16_PWM_PDUT	(BT16_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT16_PWM_PDUT_PDUT	BT16_PWM_PDUT  /*@bfrg@*/

#define BT17_PWM_PDUT	(BT17_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT17_PWM_PDUT_PDUT	BT17_PWM_PDUT  /*@bfrg@*/

#define BT18_PWM_PDUT	(BT18_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT18_PWM_PDUT_PDUT	BT18_PWM_PDUT  /*@bfrg@*/

#define BT19_PWM_PDUT	(BT19_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT19_PWM_PDUT_PDUT	BT19_PWM_PDUT  /*@bfrg@*/

#define BT20_PWM_PDUT	(BT20_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT20_PWM_PDUT_PDUT	BT20_PWM_PDUT  /*@bfrg@*/

#define BT21_PWM_PDUT	(BT21_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT21_PWM_PDUT_PDUT	BT21_PWM_PDUT  /*@bfrg@*/

#define BT22_PWM_PDUT	(BT22_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT22_PWM_PDUT_PDUT	BT22_PWM_PDUT  /*@bfrg@*/

#define BT23_PWM_PDUT	(BT23_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT23_PWM_PDUT_PDUT	BT23_PWM_PDUT  /*@bfrg@*/

#define BT24_PWM_PDUT	(BT24_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT24_PWM_PDUT_PDUT	BT24_PWM_PDUT  /*@bfrg@*/

#define BT25_PWM_PDUT	(BT25_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT25_PWM_PDUT_PDUT	BT25_PWM_PDUT  /*@bfrg@*/

#define BT26_PWM_PDUT	(BT26_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT26_PWM_PDUT_PDUT	BT26_PWM_PDUT  /*@bfrg@*/

#define BT27_PWM_PDUT	(BT27_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT27_PWM_PDUT_PDUT	BT27_PWM_PDUT  /*@bfrg@*/

#define BT28_PWM_PDUT	(BT28_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT28_PWM_PDUT_PDUT	BT28_PWM_PDUT  /*@bfrg@*/

#define BT29_PWM_PDUT	(BT29_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT29_PWM_PDUT_PDUT	BT29_PWM_PDUT  /*@bfrg@*/

#define BT30_PWM_PDUT	(BT30_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT30_PWM_PDUT_PDUT	BT30_PWM_PDUT  /*@bfrg@*/

#define BT31_PWM_PDUT	(BT31_PWM.unPDUT.u16Register)  /*@rg@*/
#define BT31_PWM_PDUT_PDUT	BT31_PWM_PDUT  /*@bfrg@*/

typedef union un_btn_pwm_pdut{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_pdut_t;

/* TMR */
#define BT00_PWM_TMR	(BT00_PWM.unTMR.u32Register)  /*@rg@*/
#define BT00_PWM_TMR_TMR	(BT00_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT01_PWM_TMR	(BT01_PWM.unTMR.u32Register)  /*@rg@*/
#define BT01_PWM_TMR_TMR	(BT01_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT02_PWM_TMR	(BT02_PWM.unTMR.u32Register)  /*@rg@*/
#define BT02_PWM_TMR_TMR	(BT02_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT03_PWM_TMR	(BT03_PWM.unTMR.u32Register)  /*@rg@*/
#define BT03_PWM_TMR_TMR	(BT03_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT04_PWM_TMR	(BT04_PWM.unTMR.u32Register)  /*@rg@*/
#define BT04_PWM_TMR_TMR	(BT04_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT05_PWM_TMR	(BT05_PWM.unTMR.u32Register)  /*@rg@*/
#define BT05_PWM_TMR_TMR	(BT05_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT06_PWM_TMR	(BT06_PWM.unTMR.u32Register)  /*@rg@*/
#define BT06_PWM_TMR_TMR	(BT06_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT07_PWM_TMR	(BT07_PWM.unTMR.u32Register)  /*@rg@*/
#define BT07_PWM_TMR_TMR	(BT07_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT08_PWM_TMR	(BT08_PWM.unTMR.u32Register)  /*@rg@*/
#define BT08_PWM_TMR_TMR	(BT08_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT09_PWM_TMR	(BT09_PWM.unTMR.u32Register)  /*@rg@*/
#define BT09_PWM_TMR_TMR	(BT09_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT10_PWM_TMR	(BT10_PWM.unTMR.u32Register)  /*@rg@*/
#define BT10_PWM_TMR_TMR	(BT10_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT11_PWM_TMR	(BT11_PWM.unTMR.u32Register)  /*@rg@*/
#define BT11_PWM_TMR_TMR	(BT11_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT12_PWM_TMR	(BT12_PWM.unTMR.u32Register)  /*@rg@*/
#define BT12_PWM_TMR_TMR	(BT12_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT13_PWM_TMR	(BT13_PWM.unTMR.u32Register)  /*@rg@*/
#define BT13_PWM_TMR_TMR	(BT13_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT14_PWM_TMR	(BT14_PWM.unTMR.u32Register)  /*@rg@*/
#define BT14_PWM_TMR_TMR	(BT14_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT15_PWM_TMR	(BT15_PWM.unTMR.u32Register)  /*@rg@*/
#define BT15_PWM_TMR_TMR	(BT15_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT16_PWM_TMR	(BT16_PWM.unTMR.u32Register)  /*@rg@*/
#define BT16_PWM_TMR_TMR	(BT16_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT17_PWM_TMR	(BT17_PWM.unTMR.u32Register)  /*@rg@*/
#define BT17_PWM_TMR_TMR	(BT17_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT18_PWM_TMR	(BT18_PWM.unTMR.u32Register)  /*@rg@*/
#define BT18_PWM_TMR_TMR	(BT18_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT19_PWM_TMR	(BT19_PWM.unTMR.u32Register)  /*@rg@*/
#define BT19_PWM_TMR_TMR	(BT19_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT20_PWM_TMR	(BT20_PWM.unTMR.u32Register)  /*@rg@*/
#define BT20_PWM_TMR_TMR	(BT20_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT21_PWM_TMR	(BT21_PWM.unTMR.u32Register)  /*@rg@*/
#define BT21_PWM_TMR_TMR	(BT21_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT22_PWM_TMR	(BT22_PWM.unTMR.u32Register)  /*@rg@*/
#define BT22_PWM_TMR_TMR	(BT22_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT23_PWM_TMR	(BT23_PWM.unTMR.u32Register)  /*@rg@*/
#define BT23_PWM_TMR_TMR	(BT23_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT24_PWM_TMR	(BT24_PWM.unTMR.u32Register)  /*@rg@*/
#define BT24_PWM_TMR_TMR	(BT24_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT25_PWM_TMR	(BT25_PWM.unTMR.u32Register)  /*@rg@*/
#define BT25_PWM_TMR_TMR	(BT25_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT26_PWM_TMR	(BT26_PWM.unTMR.u32Register)  /*@rg@*/
#define BT26_PWM_TMR_TMR	(BT26_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT27_PWM_TMR	(BT27_PWM.unTMR.u32Register)  /*@rg@*/
#define BT27_PWM_TMR_TMR	(BT27_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT28_PWM_TMR	(BT28_PWM.unTMR.u32Register)  /*@rg@*/
#define BT28_PWM_TMR_TMR	(BT28_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT29_PWM_TMR	(BT29_PWM.unTMR.u32Register)  /*@rg@*/
#define BT29_PWM_TMR_TMR	(BT29_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT30_PWM_TMR	(BT30_PWM.unTMR.u32Register)  /*@rg@*/
#define BT30_PWM_TMR_TMR	(BT30_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

#define BT31_PWM_TMR	(BT31_PWM.unTMR.u32Register)  /*@rg@*/
#define BT31_PWM_TMR_TMR	(BT31_PWM.unTMR.stcField.u17TMR)  /*@bf@*/

typedef struct stc_btn_pwm_tmr_field{
    uint_io32_t		u17TMR:17;
    uint_io32_t		:15;
}stc_btn_pwm_tmr_field_t;

typedef union un_btn_pwm_tmr{
    uint_io32_t		u32Register;
    stc_btn_pwm_tmr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_btn_pwm_tmr_t;

/* TMCR */
#define BT00_PWM_TMCR	(BT00_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT00_PWM_TMCR_STRG	(BT00_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT00_PWM_TMCR_CTEN	(BT00_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT00_PWM_TMCR_MDSE	(BT00_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT00_PWM_TMCR_OSEL	(BT00_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT00_PWM_TMCR_FMD	(BT00_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT00_PWM_TMCR_EGS	(BT00_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT00_PWM_TMCR_PMSK	(BT00_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT00_PWM_TMCR_RTGEN	(BT00_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT00_PWM_TMCR_CKS2_0	(BT00_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT01_PWM_TMCR	(BT01_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT01_PWM_TMCR_STRG	(BT01_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT01_PWM_TMCR_CTEN	(BT01_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT01_PWM_TMCR_MDSE	(BT01_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT01_PWM_TMCR_OSEL	(BT01_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT01_PWM_TMCR_FMD	(BT01_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT01_PWM_TMCR_EGS	(BT01_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT01_PWM_TMCR_PMSK	(BT01_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT01_PWM_TMCR_RTGEN	(BT01_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT01_PWM_TMCR_CKS2_0	(BT01_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT02_PWM_TMCR	(BT02_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT02_PWM_TMCR_STRG	(BT02_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT02_PWM_TMCR_CTEN	(BT02_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT02_PWM_TMCR_MDSE	(BT02_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT02_PWM_TMCR_OSEL	(BT02_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT02_PWM_TMCR_FMD	(BT02_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT02_PWM_TMCR_EGS	(BT02_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT02_PWM_TMCR_PMSK	(BT02_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT02_PWM_TMCR_RTGEN	(BT02_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT02_PWM_TMCR_CKS2_0	(BT02_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT03_PWM_TMCR	(BT03_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT03_PWM_TMCR_STRG	(BT03_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT03_PWM_TMCR_CTEN	(BT03_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT03_PWM_TMCR_MDSE	(BT03_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT03_PWM_TMCR_OSEL	(BT03_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT03_PWM_TMCR_FMD	(BT03_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT03_PWM_TMCR_EGS	(BT03_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT03_PWM_TMCR_PMSK	(BT03_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT03_PWM_TMCR_RTGEN	(BT03_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT03_PWM_TMCR_CKS2_0	(BT03_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT04_PWM_TMCR	(BT04_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT04_PWM_TMCR_STRG	(BT04_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT04_PWM_TMCR_CTEN	(BT04_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT04_PWM_TMCR_MDSE	(BT04_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT04_PWM_TMCR_OSEL	(BT04_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT04_PWM_TMCR_FMD	(BT04_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT04_PWM_TMCR_EGS	(BT04_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT04_PWM_TMCR_PMSK	(BT04_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT04_PWM_TMCR_RTGEN	(BT04_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT04_PWM_TMCR_CKS2_0	(BT04_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT05_PWM_TMCR	(BT05_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT05_PWM_TMCR_STRG	(BT05_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT05_PWM_TMCR_CTEN	(BT05_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT05_PWM_TMCR_MDSE	(BT05_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT05_PWM_TMCR_OSEL	(BT05_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT05_PWM_TMCR_FMD	(BT05_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT05_PWM_TMCR_EGS	(BT05_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT05_PWM_TMCR_PMSK	(BT05_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT05_PWM_TMCR_RTGEN	(BT05_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT05_PWM_TMCR_CKS2_0	(BT05_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT06_PWM_TMCR	(BT06_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT06_PWM_TMCR_STRG	(BT06_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT06_PWM_TMCR_CTEN	(BT06_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT06_PWM_TMCR_MDSE	(BT06_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT06_PWM_TMCR_OSEL	(BT06_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT06_PWM_TMCR_FMD	(BT06_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT06_PWM_TMCR_EGS	(BT06_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT06_PWM_TMCR_PMSK	(BT06_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT06_PWM_TMCR_RTGEN	(BT06_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT06_PWM_TMCR_CKS2_0	(BT06_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT07_PWM_TMCR	(BT07_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT07_PWM_TMCR_STRG	(BT07_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT07_PWM_TMCR_CTEN	(BT07_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT07_PWM_TMCR_MDSE	(BT07_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT07_PWM_TMCR_OSEL	(BT07_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT07_PWM_TMCR_FMD	(BT07_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT07_PWM_TMCR_EGS	(BT07_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT07_PWM_TMCR_PMSK	(BT07_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT07_PWM_TMCR_RTGEN	(BT07_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT07_PWM_TMCR_CKS2_0	(BT07_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT08_PWM_TMCR	(BT08_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT08_PWM_TMCR_STRG	(BT08_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT08_PWM_TMCR_CTEN	(BT08_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT08_PWM_TMCR_MDSE	(BT08_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT08_PWM_TMCR_OSEL	(BT08_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT08_PWM_TMCR_FMD	(BT08_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT08_PWM_TMCR_EGS	(BT08_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT08_PWM_TMCR_PMSK	(BT08_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT08_PWM_TMCR_RTGEN	(BT08_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT08_PWM_TMCR_CKS2_0	(BT08_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT09_PWM_TMCR	(BT09_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT09_PWM_TMCR_STRG	(BT09_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT09_PWM_TMCR_CTEN	(BT09_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT09_PWM_TMCR_MDSE	(BT09_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT09_PWM_TMCR_OSEL	(BT09_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT09_PWM_TMCR_FMD	(BT09_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT09_PWM_TMCR_EGS	(BT09_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT09_PWM_TMCR_PMSK	(BT09_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT09_PWM_TMCR_RTGEN	(BT09_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT09_PWM_TMCR_CKS2_0	(BT09_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT10_PWM_TMCR	(BT10_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT10_PWM_TMCR_STRG	(BT10_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT10_PWM_TMCR_CTEN	(BT10_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT10_PWM_TMCR_MDSE	(BT10_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT10_PWM_TMCR_OSEL	(BT10_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT10_PWM_TMCR_FMD	(BT10_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT10_PWM_TMCR_EGS	(BT10_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT10_PWM_TMCR_PMSK	(BT10_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT10_PWM_TMCR_RTGEN	(BT10_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT10_PWM_TMCR_CKS2_0	(BT10_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT11_PWM_TMCR	(BT11_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT11_PWM_TMCR_STRG	(BT11_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT11_PWM_TMCR_CTEN	(BT11_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT11_PWM_TMCR_MDSE	(BT11_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT11_PWM_TMCR_OSEL	(BT11_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT11_PWM_TMCR_FMD	(BT11_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT11_PWM_TMCR_EGS	(BT11_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT11_PWM_TMCR_PMSK	(BT11_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT11_PWM_TMCR_RTGEN	(BT11_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT11_PWM_TMCR_CKS2_0	(BT11_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT12_PWM_TMCR	(BT12_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT12_PWM_TMCR_STRG	(BT12_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT12_PWM_TMCR_CTEN	(BT12_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT12_PWM_TMCR_MDSE	(BT12_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT12_PWM_TMCR_OSEL	(BT12_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT12_PWM_TMCR_FMD	(BT12_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT12_PWM_TMCR_EGS	(BT12_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT12_PWM_TMCR_PMSK	(BT12_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT12_PWM_TMCR_RTGEN	(BT12_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT12_PWM_TMCR_CKS2_0	(BT12_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT13_PWM_TMCR	(BT13_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT13_PWM_TMCR_STRG	(BT13_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT13_PWM_TMCR_CTEN	(BT13_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT13_PWM_TMCR_MDSE	(BT13_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT13_PWM_TMCR_OSEL	(BT13_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT13_PWM_TMCR_FMD	(BT13_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT13_PWM_TMCR_EGS	(BT13_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT13_PWM_TMCR_PMSK	(BT13_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT13_PWM_TMCR_RTGEN	(BT13_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT13_PWM_TMCR_CKS2_0	(BT13_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT14_PWM_TMCR	(BT14_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT14_PWM_TMCR_STRG	(BT14_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT14_PWM_TMCR_CTEN	(BT14_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT14_PWM_TMCR_MDSE	(BT14_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT14_PWM_TMCR_OSEL	(BT14_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT14_PWM_TMCR_FMD	(BT14_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT14_PWM_TMCR_EGS	(BT14_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT14_PWM_TMCR_PMSK	(BT14_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT14_PWM_TMCR_RTGEN	(BT14_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT14_PWM_TMCR_CKS2_0	(BT14_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT15_PWM_TMCR	(BT15_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT15_PWM_TMCR_STRG	(BT15_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT15_PWM_TMCR_CTEN	(BT15_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT15_PWM_TMCR_MDSE	(BT15_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT15_PWM_TMCR_OSEL	(BT15_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT15_PWM_TMCR_FMD	(BT15_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT15_PWM_TMCR_EGS	(BT15_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT15_PWM_TMCR_PMSK	(BT15_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT15_PWM_TMCR_RTGEN	(BT15_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT15_PWM_TMCR_CKS2_0	(BT15_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT16_PWM_TMCR	(BT16_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT16_PWM_TMCR_STRG	(BT16_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT16_PWM_TMCR_CTEN	(BT16_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT16_PWM_TMCR_MDSE	(BT16_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT16_PWM_TMCR_OSEL	(BT16_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT16_PWM_TMCR_FMD	(BT16_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT16_PWM_TMCR_EGS	(BT16_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT16_PWM_TMCR_PMSK	(BT16_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT16_PWM_TMCR_RTGEN	(BT16_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT16_PWM_TMCR_CKS2_0	(BT16_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT17_PWM_TMCR	(BT17_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT17_PWM_TMCR_STRG	(BT17_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT17_PWM_TMCR_CTEN	(BT17_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT17_PWM_TMCR_MDSE	(BT17_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT17_PWM_TMCR_OSEL	(BT17_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT17_PWM_TMCR_FMD	(BT17_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT17_PWM_TMCR_EGS	(BT17_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT17_PWM_TMCR_PMSK	(BT17_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT17_PWM_TMCR_RTGEN	(BT17_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT17_PWM_TMCR_CKS2_0	(BT17_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT18_PWM_TMCR	(BT18_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT18_PWM_TMCR_STRG	(BT18_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT18_PWM_TMCR_CTEN	(BT18_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT18_PWM_TMCR_MDSE	(BT18_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT18_PWM_TMCR_OSEL	(BT18_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT18_PWM_TMCR_FMD	(BT18_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT18_PWM_TMCR_EGS	(BT18_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT18_PWM_TMCR_PMSK	(BT18_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT18_PWM_TMCR_RTGEN	(BT18_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT18_PWM_TMCR_CKS2_0	(BT18_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT19_PWM_TMCR	(BT19_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT19_PWM_TMCR_STRG	(BT19_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT19_PWM_TMCR_CTEN	(BT19_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT19_PWM_TMCR_MDSE	(BT19_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT19_PWM_TMCR_OSEL	(BT19_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT19_PWM_TMCR_FMD	(BT19_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT19_PWM_TMCR_EGS	(BT19_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT19_PWM_TMCR_PMSK	(BT19_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT19_PWM_TMCR_RTGEN	(BT19_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT19_PWM_TMCR_CKS2_0	(BT19_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT20_PWM_TMCR	(BT20_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT20_PWM_TMCR_STRG	(BT20_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT20_PWM_TMCR_CTEN	(BT20_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT20_PWM_TMCR_MDSE	(BT20_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT20_PWM_TMCR_OSEL	(BT20_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT20_PWM_TMCR_FMD	(BT20_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT20_PWM_TMCR_EGS	(BT20_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT20_PWM_TMCR_PMSK	(BT20_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT20_PWM_TMCR_RTGEN	(BT20_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT20_PWM_TMCR_CKS2_0	(BT20_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT21_PWM_TMCR	(BT21_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT21_PWM_TMCR_STRG	(BT21_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT21_PWM_TMCR_CTEN	(BT21_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT21_PWM_TMCR_MDSE	(BT21_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT21_PWM_TMCR_OSEL	(BT21_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT21_PWM_TMCR_FMD	(BT21_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT21_PWM_TMCR_EGS	(BT21_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT21_PWM_TMCR_PMSK	(BT21_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT21_PWM_TMCR_RTGEN	(BT21_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT21_PWM_TMCR_CKS2_0	(BT21_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT22_PWM_TMCR	(BT22_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT22_PWM_TMCR_STRG	(BT22_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT22_PWM_TMCR_CTEN	(BT22_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT22_PWM_TMCR_MDSE	(BT22_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT22_PWM_TMCR_OSEL	(BT22_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT22_PWM_TMCR_FMD	(BT22_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT22_PWM_TMCR_EGS	(BT22_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT22_PWM_TMCR_PMSK	(BT22_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT22_PWM_TMCR_RTGEN	(BT22_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT22_PWM_TMCR_CKS2_0	(BT22_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT23_PWM_TMCR	(BT23_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT23_PWM_TMCR_STRG	(BT23_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT23_PWM_TMCR_CTEN	(BT23_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT23_PWM_TMCR_MDSE	(BT23_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT23_PWM_TMCR_OSEL	(BT23_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT23_PWM_TMCR_FMD	(BT23_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT23_PWM_TMCR_EGS	(BT23_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT23_PWM_TMCR_PMSK	(BT23_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT23_PWM_TMCR_RTGEN	(BT23_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT23_PWM_TMCR_CKS2_0	(BT23_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT24_PWM_TMCR	(BT24_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT24_PWM_TMCR_STRG	(BT24_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT24_PWM_TMCR_CTEN	(BT24_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT24_PWM_TMCR_MDSE	(BT24_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT24_PWM_TMCR_OSEL	(BT24_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT24_PWM_TMCR_FMD	(BT24_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT24_PWM_TMCR_EGS	(BT24_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT24_PWM_TMCR_PMSK	(BT24_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT24_PWM_TMCR_RTGEN	(BT24_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT24_PWM_TMCR_CKS2_0	(BT24_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT25_PWM_TMCR	(BT25_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT25_PWM_TMCR_STRG	(BT25_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT25_PWM_TMCR_CTEN	(BT25_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT25_PWM_TMCR_MDSE	(BT25_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT25_PWM_TMCR_OSEL	(BT25_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT25_PWM_TMCR_FMD	(BT25_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT25_PWM_TMCR_EGS	(BT25_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT25_PWM_TMCR_PMSK	(BT25_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT25_PWM_TMCR_RTGEN	(BT25_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT25_PWM_TMCR_CKS2_0	(BT25_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT26_PWM_TMCR	(BT26_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT26_PWM_TMCR_STRG	(BT26_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT26_PWM_TMCR_CTEN	(BT26_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT26_PWM_TMCR_MDSE	(BT26_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT26_PWM_TMCR_OSEL	(BT26_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT26_PWM_TMCR_FMD	(BT26_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT26_PWM_TMCR_EGS	(BT26_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT26_PWM_TMCR_PMSK	(BT26_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT26_PWM_TMCR_RTGEN	(BT26_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT26_PWM_TMCR_CKS2_0	(BT26_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT27_PWM_TMCR	(BT27_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT27_PWM_TMCR_STRG	(BT27_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT27_PWM_TMCR_CTEN	(BT27_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT27_PWM_TMCR_MDSE	(BT27_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT27_PWM_TMCR_OSEL	(BT27_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT27_PWM_TMCR_FMD	(BT27_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT27_PWM_TMCR_EGS	(BT27_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT27_PWM_TMCR_PMSK	(BT27_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT27_PWM_TMCR_RTGEN	(BT27_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT27_PWM_TMCR_CKS2_0	(BT27_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT28_PWM_TMCR	(BT28_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT28_PWM_TMCR_STRG	(BT28_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT28_PWM_TMCR_CTEN	(BT28_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT28_PWM_TMCR_MDSE	(BT28_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT28_PWM_TMCR_OSEL	(BT28_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT28_PWM_TMCR_FMD	(BT28_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT28_PWM_TMCR_EGS	(BT28_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT28_PWM_TMCR_PMSK	(BT28_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT28_PWM_TMCR_RTGEN	(BT28_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT28_PWM_TMCR_CKS2_0	(BT28_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT29_PWM_TMCR	(BT29_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT29_PWM_TMCR_STRG	(BT29_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT29_PWM_TMCR_CTEN	(BT29_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT29_PWM_TMCR_MDSE	(BT29_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT29_PWM_TMCR_OSEL	(BT29_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT29_PWM_TMCR_FMD	(BT29_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT29_PWM_TMCR_EGS	(BT29_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT29_PWM_TMCR_PMSK	(BT29_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT29_PWM_TMCR_RTGEN	(BT29_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT29_PWM_TMCR_CKS2_0	(BT29_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT30_PWM_TMCR	(BT30_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT30_PWM_TMCR_STRG	(BT30_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT30_PWM_TMCR_CTEN	(BT30_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT30_PWM_TMCR_MDSE	(BT30_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT30_PWM_TMCR_OSEL	(BT30_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT30_PWM_TMCR_FMD	(BT30_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT30_PWM_TMCR_EGS	(BT30_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT30_PWM_TMCR_PMSK	(BT30_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT30_PWM_TMCR_RTGEN	(BT30_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT30_PWM_TMCR_CKS2_0	(BT30_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT31_PWM_TMCR	(BT31_PWM.unTMCR.u16Register)  /*@rg@*/
#define BT31_PWM_TMCR_STRG	(BT31_PWM.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT31_PWM_TMCR_CTEN	(BT31_PWM.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT31_PWM_TMCR_MDSE	(BT31_PWM.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT31_PWM_TMCR_OSEL	(BT31_PWM.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT31_PWM_TMCR_FMD	(BT31_PWM.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT31_PWM_TMCR_EGS	(BT31_PWM.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT31_PWM_TMCR_PMSK	(BT31_PWM.unTMCR.stcField.u1PMSK)  /*@bf@*/
#define BT31_PWM_TMCR_RTGEN	(BT31_PWM.unTMCR.stcField.u1RTGEN)  /*@bf@*/
#define BT31_PWM_TMCR_CKS2_0	(BT31_PWM.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

typedef struct stc_btn_pwm_tmcr_field{
    uint_io16_t		u1STRG:1;
    uint_io16_t		u1CTEN:1;
    uint_io16_t		u1MDSE:1;
    uint_io16_t		u1OSEL:1;
    uint_io16_t		u3FMD:3;
    uint_io16_t		:1;
    uint_io16_t		u2EGS:2;
    uint_io16_t		u1PMSK:1;
    uint_io16_t		u1RTGEN:1;
    uint_io16_t		u3CKS2_0:3;
    uint_io16_t		:1;
}stc_btn_pwm_tmcr_field_t;

typedef union un_btn_pwm_tmcr{
    uint_io16_t		u16Register;
    stc_btn_pwm_tmcr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_tmcr_t;

/* STC */
#define BT00_PWM_STC	(BT00_PWM.unSTC.u8Register)  /*@rg@*/
#define BT00_PWM_STC_UDIR	(BT00_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT00_PWM_STC_DTIR	(BT00_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT00_PWM_STC_TGIR	(BT00_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT00_PWM_STC_UDIE	(BT00_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT00_PWM_STC_DTIE	(BT00_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT00_PWM_STC_TGIE	(BT00_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT01_PWM_STC	(BT01_PWM.unSTC.u8Register)  /*@rg@*/
#define BT01_PWM_STC_UDIR	(BT01_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT01_PWM_STC_DTIR	(BT01_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT01_PWM_STC_TGIR	(BT01_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT01_PWM_STC_UDIE	(BT01_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT01_PWM_STC_DTIE	(BT01_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT01_PWM_STC_TGIE	(BT01_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT02_PWM_STC	(BT02_PWM.unSTC.u8Register)  /*@rg@*/
#define BT02_PWM_STC_UDIR	(BT02_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT02_PWM_STC_DTIR	(BT02_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT02_PWM_STC_TGIR	(BT02_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT02_PWM_STC_UDIE	(BT02_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT02_PWM_STC_DTIE	(BT02_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT02_PWM_STC_TGIE	(BT02_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT03_PWM_STC	(BT03_PWM.unSTC.u8Register)  /*@rg@*/
#define BT03_PWM_STC_UDIR	(BT03_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT03_PWM_STC_DTIR	(BT03_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT03_PWM_STC_TGIR	(BT03_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT03_PWM_STC_UDIE	(BT03_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT03_PWM_STC_DTIE	(BT03_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT03_PWM_STC_TGIE	(BT03_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT04_PWM_STC	(BT04_PWM.unSTC.u8Register)  /*@rg@*/
#define BT04_PWM_STC_UDIR	(BT04_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT04_PWM_STC_DTIR	(BT04_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT04_PWM_STC_TGIR	(BT04_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT04_PWM_STC_UDIE	(BT04_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT04_PWM_STC_DTIE	(BT04_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT04_PWM_STC_TGIE	(BT04_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT05_PWM_STC	(BT05_PWM.unSTC.u8Register)  /*@rg@*/
#define BT05_PWM_STC_UDIR	(BT05_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT05_PWM_STC_DTIR	(BT05_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT05_PWM_STC_TGIR	(BT05_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT05_PWM_STC_UDIE	(BT05_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT05_PWM_STC_DTIE	(BT05_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT05_PWM_STC_TGIE	(BT05_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT06_PWM_STC	(BT06_PWM.unSTC.u8Register)  /*@rg@*/
#define BT06_PWM_STC_UDIR	(BT06_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT06_PWM_STC_DTIR	(BT06_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT06_PWM_STC_TGIR	(BT06_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT06_PWM_STC_UDIE	(BT06_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT06_PWM_STC_DTIE	(BT06_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT06_PWM_STC_TGIE	(BT06_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT07_PWM_STC	(BT07_PWM.unSTC.u8Register)  /*@rg@*/
#define BT07_PWM_STC_UDIR	(BT07_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT07_PWM_STC_DTIR	(BT07_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT07_PWM_STC_TGIR	(BT07_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT07_PWM_STC_UDIE	(BT07_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT07_PWM_STC_DTIE	(BT07_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT07_PWM_STC_TGIE	(BT07_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT08_PWM_STC	(BT08_PWM.unSTC.u8Register)  /*@rg@*/
#define BT08_PWM_STC_UDIR	(BT08_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT08_PWM_STC_DTIR	(BT08_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT08_PWM_STC_TGIR	(BT08_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT08_PWM_STC_UDIE	(BT08_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT08_PWM_STC_DTIE	(BT08_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT08_PWM_STC_TGIE	(BT08_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT09_PWM_STC	(BT09_PWM.unSTC.u8Register)  /*@rg@*/
#define BT09_PWM_STC_UDIR	(BT09_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT09_PWM_STC_DTIR	(BT09_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT09_PWM_STC_TGIR	(BT09_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT09_PWM_STC_UDIE	(BT09_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT09_PWM_STC_DTIE	(BT09_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT09_PWM_STC_TGIE	(BT09_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT10_PWM_STC	(BT10_PWM.unSTC.u8Register)  /*@rg@*/
#define BT10_PWM_STC_UDIR	(BT10_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT10_PWM_STC_DTIR	(BT10_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT10_PWM_STC_TGIR	(BT10_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT10_PWM_STC_UDIE	(BT10_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT10_PWM_STC_DTIE	(BT10_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT10_PWM_STC_TGIE	(BT10_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT11_PWM_STC	(BT11_PWM.unSTC.u8Register)  /*@rg@*/
#define BT11_PWM_STC_UDIR	(BT11_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT11_PWM_STC_DTIR	(BT11_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT11_PWM_STC_TGIR	(BT11_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT11_PWM_STC_UDIE	(BT11_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT11_PWM_STC_DTIE	(BT11_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT11_PWM_STC_TGIE	(BT11_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT12_PWM_STC	(BT12_PWM.unSTC.u8Register)  /*@rg@*/
#define BT12_PWM_STC_UDIR	(BT12_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT12_PWM_STC_DTIR	(BT12_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT12_PWM_STC_TGIR	(BT12_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT12_PWM_STC_UDIE	(BT12_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT12_PWM_STC_DTIE	(BT12_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT12_PWM_STC_TGIE	(BT12_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT13_PWM_STC	(BT13_PWM.unSTC.u8Register)  /*@rg@*/
#define BT13_PWM_STC_UDIR	(BT13_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT13_PWM_STC_DTIR	(BT13_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT13_PWM_STC_TGIR	(BT13_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT13_PWM_STC_UDIE	(BT13_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT13_PWM_STC_DTIE	(BT13_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT13_PWM_STC_TGIE	(BT13_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT14_PWM_STC	(BT14_PWM.unSTC.u8Register)  /*@rg@*/
#define BT14_PWM_STC_UDIR	(BT14_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT14_PWM_STC_DTIR	(BT14_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT14_PWM_STC_TGIR	(BT14_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT14_PWM_STC_UDIE	(BT14_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT14_PWM_STC_DTIE	(BT14_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT14_PWM_STC_TGIE	(BT14_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT15_PWM_STC	(BT15_PWM.unSTC.u8Register)  /*@rg@*/
#define BT15_PWM_STC_UDIR	(BT15_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT15_PWM_STC_DTIR	(BT15_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT15_PWM_STC_TGIR	(BT15_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT15_PWM_STC_UDIE	(BT15_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT15_PWM_STC_DTIE	(BT15_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT15_PWM_STC_TGIE	(BT15_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT16_PWM_STC	(BT16_PWM.unSTC.u8Register)  /*@rg@*/
#define BT16_PWM_STC_UDIR	(BT16_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT16_PWM_STC_DTIR	(BT16_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT16_PWM_STC_TGIR	(BT16_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT16_PWM_STC_UDIE	(BT16_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT16_PWM_STC_DTIE	(BT16_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT16_PWM_STC_TGIE	(BT16_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT17_PWM_STC	(BT17_PWM.unSTC.u8Register)  /*@rg@*/
#define BT17_PWM_STC_UDIR	(BT17_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT17_PWM_STC_DTIR	(BT17_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT17_PWM_STC_TGIR	(BT17_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT17_PWM_STC_UDIE	(BT17_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT17_PWM_STC_DTIE	(BT17_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT17_PWM_STC_TGIE	(BT17_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT18_PWM_STC	(BT18_PWM.unSTC.u8Register)  /*@rg@*/
#define BT18_PWM_STC_UDIR	(BT18_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT18_PWM_STC_DTIR	(BT18_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT18_PWM_STC_TGIR	(BT18_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT18_PWM_STC_UDIE	(BT18_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT18_PWM_STC_DTIE	(BT18_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT18_PWM_STC_TGIE	(BT18_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT19_PWM_STC	(BT19_PWM.unSTC.u8Register)  /*@rg@*/
#define BT19_PWM_STC_UDIR	(BT19_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT19_PWM_STC_DTIR	(BT19_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT19_PWM_STC_TGIR	(BT19_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT19_PWM_STC_UDIE	(BT19_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT19_PWM_STC_DTIE	(BT19_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT19_PWM_STC_TGIE	(BT19_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT20_PWM_STC	(BT20_PWM.unSTC.u8Register)  /*@rg@*/
#define BT20_PWM_STC_UDIR	(BT20_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT20_PWM_STC_DTIR	(BT20_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT20_PWM_STC_TGIR	(BT20_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT20_PWM_STC_UDIE	(BT20_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT20_PWM_STC_DTIE	(BT20_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT20_PWM_STC_TGIE	(BT20_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT21_PWM_STC	(BT21_PWM.unSTC.u8Register)  /*@rg@*/
#define BT21_PWM_STC_UDIR	(BT21_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT21_PWM_STC_DTIR	(BT21_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT21_PWM_STC_TGIR	(BT21_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT21_PWM_STC_UDIE	(BT21_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT21_PWM_STC_DTIE	(BT21_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT21_PWM_STC_TGIE	(BT21_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT22_PWM_STC	(BT22_PWM.unSTC.u8Register)  /*@rg@*/
#define BT22_PWM_STC_UDIR	(BT22_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT22_PWM_STC_DTIR	(BT22_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT22_PWM_STC_TGIR	(BT22_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT22_PWM_STC_UDIE	(BT22_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT22_PWM_STC_DTIE	(BT22_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT22_PWM_STC_TGIE	(BT22_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT23_PWM_STC	(BT23_PWM.unSTC.u8Register)  /*@rg@*/
#define BT23_PWM_STC_UDIR	(BT23_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT23_PWM_STC_DTIR	(BT23_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT23_PWM_STC_TGIR	(BT23_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT23_PWM_STC_UDIE	(BT23_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT23_PWM_STC_DTIE	(BT23_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT23_PWM_STC_TGIE	(BT23_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT24_PWM_STC	(BT24_PWM.unSTC.u8Register)  /*@rg@*/
#define BT24_PWM_STC_UDIR	(BT24_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT24_PWM_STC_DTIR	(BT24_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT24_PWM_STC_TGIR	(BT24_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT24_PWM_STC_UDIE	(BT24_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT24_PWM_STC_DTIE	(BT24_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT24_PWM_STC_TGIE	(BT24_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT25_PWM_STC	(BT25_PWM.unSTC.u8Register)  /*@rg@*/
#define BT25_PWM_STC_UDIR	(BT25_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT25_PWM_STC_DTIR	(BT25_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT25_PWM_STC_TGIR	(BT25_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT25_PWM_STC_UDIE	(BT25_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT25_PWM_STC_DTIE	(BT25_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT25_PWM_STC_TGIE	(BT25_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT26_PWM_STC	(BT26_PWM.unSTC.u8Register)  /*@rg@*/
#define BT26_PWM_STC_UDIR	(BT26_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT26_PWM_STC_DTIR	(BT26_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT26_PWM_STC_TGIR	(BT26_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT26_PWM_STC_UDIE	(BT26_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT26_PWM_STC_DTIE	(BT26_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT26_PWM_STC_TGIE	(BT26_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT27_PWM_STC	(BT27_PWM.unSTC.u8Register)  /*@rg@*/
#define BT27_PWM_STC_UDIR	(BT27_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT27_PWM_STC_DTIR	(BT27_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT27_PWM_STC_TGIR	(BT27_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT27_PWM_STC_UDIE	(BT27_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT27_PWM_STC_DTIE	(BT27_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT27_PWM_STC_TGIE	(BT27_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT28_PWM_STC	(BT28_PWM.unSTC.u8Register)  /*@rg@*/
#define BT28_PWM_STC_UDIR	(BT28_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT28_PWM_STC_DTIR	(BT28_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT28_PWM_STC_TGIR	(BT28_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT28_PWM_STC_UDIE	(BT28_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT28_PWM_STC_DTIE	(BT28_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT28_PWM_STC_TGIE	(BT28_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT29_PWM_STC	(BT29_PWM.unSTC.u8Register)  /*@rg@*/
#define BT29_PWM_STC_UDIR	(BT29_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT29_PWM_STC_DTIR	(BT29_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT29_PWM_STC_TGIR	(BT29_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT29_PWM_STC_UDIE	(BT29_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT29_PWM_STC_DTIE	(BT29_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT29_PWM_STC_TGIE	(BT29_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT30_PWM_STC	(BT30_PWM.unSTC.u8Register)  /*@rg@*/
#define BT30_PWM_STC_UDIR	(BT30_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT30_PWM_STC_DTIR	(BT30_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT30_PWM_STC_TGIR	(BT30_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT30_PWM_STC_UDIE	(BT30_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT30_PWM_STC_DTIE	(BT30_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT30_PWM_STC_TGIE	(BT30_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT31_PWM_STC	(BT31_PWM.unSTC.u8Register)  /*@rg@*/
#define BT31_PWM_STC_UDIR	(BT31_PWM.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT31_PWM_STC_DTIR	(BT31_PWM.unSTC.stcField.u1DTIR)  /*@bf@*/
#define BT31_PWM_STC_TGIR	(BT31_PWM.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT31_PWM_STC_UDIE	(BT31_PWM.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT31_PWM_STC_DTIE	(BT31_PWM.unSTC.stcField.u1DTIE)  /*@bf@*/
#define BT31_PWM_STC_TGIE	(BT31_PWM.unSTC.stcField.u1TGIE)  /*@bf@*/

typedef struct stc_btn_pwm_stc_field{
    uint_io8_t		u1UDIR:1;
    uint_io8_t		u1DTIR:1;
    uint_io8_t		u1TGIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1UDIE:1;
    uint_io8_t		u1DTIE:1;
    uint_io8_t		u1TGIE:1;
    uint_io8_t		:1;
}stc_btn_pwm_stc_field_t;

typedef union un_btn_pwm_stc{
    uint_io8_t		u8Register;
    stc_btn_pwm_stc_field_t		stcField;
}un_btn_pwm_stc_t;

/* TMCR2 */
#define BT00_PWM_TMCR2	(BT00_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT00_PWM_TMCR2_CKS3	(BT00_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT00_PWM_TMCR2_ETCEN	(BT00_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT01_PWM_TMCR2	(BT01_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT01_PWM_TMCR2_CKS3	(BT01_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT01_PWM_TMCR2_ETCEN	(BT01_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT02_PWM_TMCR2	(BT02_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT02_PWM_TMCR2_CKS3	(BT02_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT02_PWM_TMCR2_ETCEN	(BT02_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT03_PWM_TMCR2	(BT03_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT03_PWM_TMCR2_CKS3	(BT03_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT03_PWM_TMCR2_ETCEN	(BT03_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT04_PWM_TMCR2	(BT04_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT04_PWM_TMCR2_CKS3	(BT04_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT04_PWM_TMCR2_ETCEN	(BT04_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT05_PWM_TMCR2	(BT05_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT05_PWM_TMCR2_CKS3	(BT05_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT05_PWM_TMCR2_ETCEN	(BT05_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT06_PWM_TMCR2	(BT06_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT06_PWM_TMCR2_CKS3	(BT06_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT06_PWM_TMCR2_ETCEN	(BT06_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT07_PWM_TMCR2	(BT07_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT07_PWM_TMCR2_CKS3	(BT07_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT07_PWM_TMCR2_ETCEN	(BT07_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT08_PWM_TMCR2	(BT08_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT08_PWM_TMCR2_CKS3	(BT08_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT08_PWM_TMCR2_ETCEN	(BT08_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT09_PWM_TMCR2	(BT09_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT09_PWM_TMCR2_CKS3	(BT09_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT09_PWM_TMCR2_ETCEN	(BT09_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT10_PWM_TMCR2	(BT10_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT10_PWM_TMCR2_CKS3	(BT10_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT10_PWM_TMCR2_ETCEN	(BT10_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT11_PWM_TMCR2	(BT11_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT11_PWM_TMCR2_CKS3	(BT11_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT11_PWM_TMCR2_ETCEN	(BT11_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT12_PWM_TMCR2	(BT12_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT12_PWM_TMCR2_CKS3	(BT12_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT12_PWM_TMCR2_ETCEN	(BT12_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT13_PWM_TMCR2	(BT13_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT13_PWM_TMCR2_CKS3	(BT13_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT13_PWM_TMCR2_ETCEN	(BT13_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT14_PWM_TMCR2	(BT14_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT14_PWM_TMCR2_CKS3	(BT14_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT14_PWM_TMCR2_ETCEN	(BT14_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT15_PWM_TMCR2	(BT15_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT15_PWM_TMCR2_CKS3	(BT15_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT15_PWM_TMCR2_ETCEN	(BT15_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT16_PWM_TMCR2	(BT16_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT16_PWM_TMCR2_CKS3	(BT16_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT16_PWM_TMCR2_ETCEN	(BT16_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT17_PWM_TMCR2	(BT17_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT17_PWM_TMCR2_CKS3	(BT17_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT17_PWM_TMCR2_ETCEN	(BT17_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT18_PWM_TMCR2	(BT18_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT18_PWM_TMCR2_CKS3	(BT18_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT18_PWM_TMCR2_ETCEN	(BT18_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT19_PWM_TMCR2	(BT19_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT19_PWM_TMCR2_CKS3	(BT19_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT19_PWM_TMCR2_ETCEN	(BT19_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT20_PWM_TMCR2	(BT20_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT20_PWM_TMCR2_CKS3	(BT20_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT20_PWM_TMCR2_ETCEN	(BT20_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT21_PWM_TMCR2	(BT21_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT21_PWM_TMCR2_CKS3	(BT21_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT21_PWM_TMCR2_ETCEN	(BT21_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT22_PWM_TMCR2	(BT22_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT22_PWM_TMCR2_CKS3	(BT22_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT22_PWM_TMCR2_ETCEN	(BT22_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT23_PWM_TMCR2	(BT23_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT23_PWM_TMCR2_CKS3	(BT23_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT23_PWM_TMCR2_ETCEN	(BT23_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT24_PWM_TMCR2	(BT24_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT24_PWM_TMCR2_CKS3	(BT24_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT24_PWM_TMCR2_ETCEN	(BT24_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT25_PWM_TMCR2	(BT25_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT25_PWM_TMCR2_CKS3	(BT25_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT25_PWM_TMCR2_ETCEN	(BT25_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT26_PWM_TMCR2	(BT26_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT26_PWM_TMCR2_CKS3	(BT26_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT26_PWM_TMCR2_ETCEN	(BT26_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT27_PWM_TMCR2	(BT27_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT27_PWM_TMCR2_CKS3	(BT27_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT27_PWM_TMCR2_ETCEN	(BT27_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT28_PWM_TMCR2	(BT28_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT28_PWM_TMCR2_CKS3	(BT28_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT28_PWM_TMCR2_ETCEN	(BT28_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT29_PWM_TMCR2	(BT29_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT29_PWM_TMCR2_CKS3	(BT29_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT29_PWM_TMCR2_ETCEN	(BT29_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT30_PWM_TMCR2	(BT30_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT30_PWM_TMCR2_CKS3	(BT30_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT30_PWM_TMCR2_ETCEN	(BT30_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

#define BT31_PWM_TMCR2	(BT31_PWM.unTMCR2.u8Register)  /*@rg@*/
#define BT31_PWM_TMCR2_CKS3	(BT31_PWM.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT31_PWM_TMCR2_ETCEN	(BT31_PWM.unTMCR2.stcField.u1ETCEN)  /*@bf@*/

typedef struct stc_btn_pwm_tmcr2_field{
    uint_io8_t		u1CKS3:1;
    uint_io8_t		u1ETCEN:1;
    uint_io8_t		:6;
}stc_btn_pwm_tmcr2_field_t;

typedef union un_btn_pwm_tmcr2{
    uint_io8_t		u8Register;
    stc_btn_pwm_tmcr2_field_t		stcField;
}un_btn_pwm_tmcr2_t;

/* STCC */
#define BT00_PWM_STCC	(BT00_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT00_PWM_STCC_UDIRC	(BT00_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT00_PWM_STCC_DTIRC	(BT00_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT00_PWM_STCC_TGIRC	(BT00_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT00_PWM_STCC_UDIEC	(BT00_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT00_PWM_STCC_DTIEC	(BT00_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT00_PWM_STCC_TGIEC	(BT00_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT01_PWM_STCC	(BT01_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT01_PWM_STCC_UDIRC	(BT01_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT01_PWM_STCC_DTIRC	(BT01_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT01_PWM_STCC_TGIRC	(BT01_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT01_PWM_STCC_UDIEC	(BT01_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT01_PWM_STCC_DTIEC	(BT01_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT01_PWM_STCC_TGIEC	(BT01_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT02_PWM_STCC	(BT02_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT02_PWM_STCC_UDIRC	(BT02_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT02_PWM_STCC_DTIRC	(BT02_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT02_PWM_STCC_TGIRC	(BT02_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT02_PWM_STCC_UDIEC	(BT02_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT02_PWM_STCC_DTIEC	(BT02_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT02_PWM_STCC_TGIEC	(BT02_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT03_PWM_STCC	(BT03_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT03_PWM_STCC_UDIRC	(BT03_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT03_PWM_STCC_DTIRC	(BT03_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT03_PWM_STCC_TGIRC	(BT03_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT03_PWM_STCC_UDIEC	(BT03_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT03_PWM_STCC_DTIEC	(BT03_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT03_PWM_STCC_TGIEC	(BT03_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT04_PWM_STCC	(BT04_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT04_PWM_STCC_UDIRC	(BT04_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT04_PWM_STCC_DTIRC	(BT04_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT04_PWM_STCC_TGIRC	(BT04_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT04_PWM_STCC_UDIEC	(BT04_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT04_PWM_STCC_DTIEC	(BT04_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT04_PWM_STCC_TGIEC	(BT04_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT05_PWM_STCC	(BT05_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT05_PWM_STCC_UDIRC	(BT05_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT05_PWM_STCC_DTIRC	(BT05_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT05_PWM_STCC_TGIRC	(BT05_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT05_PWM_STCC_UDIEC	(BT05_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT05_PWM_STCC_DTIEC	(BT05_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT05_PWM_STCC_TGIEC	(BT05_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT06_PWM_STCC	(BT06_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT06_PWM_STCC_UDIRC	(BT06_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT06_PWM_STCC_DTIRC	(BT06_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT06_PWM_STCC_TGIRC	(BT06_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT06_PWM_STCC_UDIEC	(BT06_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT06_PWM_STCC_DTIEC	(BT06_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT06_PWM_STCC_TGIEC	(BT06_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT07_PWM_STCC	(BT07_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT07_PWM_STCC_UDIRC	(BT07_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT07_PWM_STCC_DTIRC	(BT07_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT07_PWM_STCC_TGIRC	(BT07_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT07_PWM_STCC_UDIEC	(BT07_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT07_PWM_STCC_DTIEC	(BT07_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT07_PWM_STCC_TGIEC	(BT07_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT08_PWM_STCC	(BT08_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT08_PWM_STCC_UDIRC	(BT08_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT08_PWM_STCC_DTIRC	(BT08_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT08_PWM_STCC_TGIRC	(BT08_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT08_PWM_STCC_UDIEC	(BT08_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT08_PWM_STCC_DTIEC	(BT08_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT08_PWM_STCC_TGIEC	(BT08_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT09_PWM_STCC	(BT09_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT09_PWM_STCC_UDIRC	(BT09_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT09_PWM_STCC_DTIRC	(BT09_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT09_PWM_STCC_TGIRC	(BT09_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT09_PWM_STCC_UDIEC	(BT09_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT09_PWM_STCC_DTIEC	(BT09_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT09_PWM_STCC_TGIEC	(BT09_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT10_PWM_STCC	(BT10_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT10_PWM_STCC_UDIRC	(BT10_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT10_PWM_STCC_DTIRC	(BT10_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT10_PWM_STCC_TGIRC	(BT10_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT10_PWM_STCC_UDIEC	(BT10_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT10_PWM_STCC_DTIEC	(BT10_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT10_PWM_STCC_TGIEC	(BT10_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT11_PWM_STCC	(BT11_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT11_PWM_STCC_UDIRC	(BT11_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT11_PWM_STCC_DTIRC	(BT11_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT11_PWM_STCC_TGIRC	(BT11_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT11_PWM_STCC_UDIEC	(BT11_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT11_PWM_STCC_DTIEC	(BT11_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT11_PWM_STCC_TGIEC	(BT11_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT12_PWM_STCC	(BT12_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT12_PWM_STCC_UDIRC	(BT12_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT12_PWM_STCC_DTIRC	(BT12_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT12_PWM_STCC_TGIRC	(BT12_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT12_PWM_STCC_UDIEC	(BT12_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT12_PWM_STCC_DTIEC	(BT12_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT12_PWM_STCC_TGIEC	(BT12_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT13_PWM_STCC	(BT13_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT13_PWM_STCC_UDIRC	(BT13_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT13_PWM_STCC_DTIRC	(BT13_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT13_PWM_STCC_TGIRC	(BT13_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT13_PWM_STCC_UDIEC	(BT13_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT13_PWM_STCC_DTIEC	(BT13_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT13_PWM_STCC_TGIEC	(BT13_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT14_PWM_STCC	(BT14_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT14_PWM_STCC_UDIRC	(BT14_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT14_PWM_STCC_DTIRC	(BT14_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT14_PWM_STCC_TGIRC	(BT14_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT14_PWM_STCC_UDIEC	(BT14_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT14_PWM_STCC_DTIEC	(BT14_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT14_PWM_STCC_TGIEC	(BT14_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT15_PWM_STCC	(BT15_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT15_PWM_STCC_UDIRC	(BT15_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT15_PWM_STCC_DTIRC	(BT15_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT15_PWM_STCC_TGIRC	(BT15_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT15_PWM_STCC_UDIEC	(BT15_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT15_PWM_STCC_DTIEC	(BT15_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT15_PWM_STCC_TGIEC	(BT15_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT16_PWM_STCC	(BT16_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT16_PWM_STCC_UDIRC	(BT16_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT16_PWM_STCC_DTIRC	(BT16_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT16_PWM_STCC_TGIRC	(BT16_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT16_PWM_STCC_UDIEC	(BT16_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT16_PWM_STCC_DTIEC	(BT16_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT16_PWM_STCC_TGIEC	(BT16_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT17_PWM_STCC	(BT17_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT17_PWM_STCC_UDIRC	(BT17_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT17_PWM_STCC_DTIRC	(BT17_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT17_PWM_STCC_TGIRC	(BT17_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT17_PWM_STCC_UDIEC	(BT17_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT17_PWM_STCC_DTIEC	(BT17_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT17_PWM_STCC_TGIEC	(BT17_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT18_PWM_STCC	(BT18_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT18_PWM_STCC_UDIRC	(BT18_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT18_PWM_STCC_DTIRC	(BT18_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT18_PWM_STCC_TGIRC	(BT18_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT18_PWM_STCC_UDIEC	(BT18_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT18_PWM_STCC_DTIEC	(BT18_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT18_PWM_STCC_TGIEC	(BT18_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT19_PWM_STCC	(BT19_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT19_PWM_STCC_UDIRC	(BT19_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT19_PWM_STCC_DTIRC	(BT19_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT19_PWM_STCC_TGIRC	(BT19_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT19_PWM_STCC_UDIEC	(BT19_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT19_PWM_STCC_DTIEC	(BT19_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT19_PWM_STCC_TGIEC	(BT19_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT20_PWM_STCC	(BT20_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT20_PWM_STCC_UDIRC	(BT20_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT20_PWM_STCC_DTIRC	(BT20_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT20_PWM_STCC_TGIRC	(BT20_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT20_PWM_STCC_UDIEC	(BT20_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT20_PWM_STCC_DTIEC	(BT20_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT20_PWM_STCC_TGIEC	(BT20_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT21_PWM_STCC	(BT21_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT21_PWM_STCC_UDIRC	(BT21_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT21_PWM_STCC_DTIRC	(BT21_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT21_PWM_STCC_TGIRC	(BT21_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT21_PWM_STCC_UDIEC	(BT21_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT21_PWM_STCC_DTIEC	(BT21_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT21_PWM_STCC_TGIEC	(BT21_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT22_PWM_STCC	(BT22_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT22_PWM_STCC_UDIRC	(BT22_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT22_PWM_STCC_DTIRC	(BT22_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT22_PWM_STCC_TGIRC	(BT22_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT22_PWM_STCC_UDIEC	(BT22_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT22_PWM_STCC_DTIEC	(BT22_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT22_PWM_STCC_TGIEC	(BT22_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT23_PWM_STCC	(BT23_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT23_PWM_STCC_UDIRC	(BT23_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT23_PWM_STCC_DTIRC	(BT23_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT23_PWM_STCC_TGIRC	(BT23_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT23_PWM_STCC_UDIEC	(BT23_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT23_PWM_STCC_DTIEC	(BT23_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT23_PWM_STCC_TGIEC	(BT23_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT24_PWM_STCC	(BT24_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT24_PWM_STCC_UDIRC	(BT24_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT24_PWM_STCC_DTIRC	(BT24_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT24_PWM_STCC_TGIRC	(BT24_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT24_PWM_STCC_UDIEC	(BT24_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT24_PWM_STCC_DTIEC	(BT24_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT24_PWM_STCC_TGIEC	(BT24_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT25_PWM_STCC	(BT25_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT25_PWM_STCC_UDIRC	(BT25_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT25_PWM_STCC_DTIRC	(BT25_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT25_PWM_STCC_TGIRC	(BT25_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT25_PWM_STCC_UDIEC	(BT25_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT25_PWM_STCC_DTIEC	(BT25_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT25_PWM_STCC_TGIEC	(BT25_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT26_PWM_STCC	(BT26_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT26_PWM_STCC_UDIRC	(BT26_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT26_PWM_STCC_DTIRC	(BT26_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT26_PWM_STCC_TGIRC	(BT26_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT26_PWM_STCC_UDIEC	(BT26_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT26_PWM_STCC_DTIEC	(BT26_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT26_PWM_STCC_TGIEC	(BT26_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT27_PWM_STCC	(BT27_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT27_PWM_STCC_UDIRC	(BT27_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT27_PWM_STCC_DTIRC	(BT27_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT27_PWM_STCC_TGIRC	(BT27_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT27_PWM_STCC_UDIEC	(BT27_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT27_PWM_STCC_DTIEC	(BT27_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT27_PWM_STCC_TGIEC	(BT27_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT28_PWM_STCC	(BT28_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT28_PWM_STCC_UDIRC	(BT28_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT28_PWM_STCC_DTIRC	(BT28_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT28_PWM_STCC_TGIRC	(BT28_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT28_PWM_STCC_UDIEC	(BT28_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT28_PWM_STCC_DTIEC	(BT28_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT28_PWM_STCC_TGIEC	(BT28_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT29_PWM_STCC	(BT29_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT29_PWM_STCC_UDIRC	(BT29_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT29_PWM_STCC_DTIRC	(BT29_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT29_PWM_STCC_TGIRC	(BT29_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT29_PWM_STCC_UDIEC	(BT29_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT29_PWM_STCC_DTIEC	(BT29_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT29_PWM_STCC_TGIEC	(BT29_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT30_PWM_STCC	(BT30_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT30_PWM_STCC_UDIRC	(BT30_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT30_PWM_STCC_DTIRC	(BT30_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT30_PWM_STCC_TGIRC	(BT30_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT30_PWM_STCC_UDIEC	(BT30_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT30_PWM_STCC_DTIEC	(BT30_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT30_PWM_STCC_TGIEC	(BT30_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT31_PWM_STCC	(BT31_PWM.unSTCC.u8Register)  /*@rg@*/
#define BT31_PWM_STCC_UDIRC	(BT31_PWM.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT31_PWM_STCC_DTIRC	(BT31_PWM.unSTCC.stcField.u1DTIRC)  /*@bf@*/
#define BT31_PWM_STCC_TGIRC	(BT31_PWM.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT31_PWM_STCC_UDIEC	(BT31_PWM.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT31_PWM_STCC_DTIEC	(BT31_PWM.unSTCC.stcField.u1DTIEC)  /*@bf@*/
#define BT31_PWM_STCC_TGIEC	(BT31_PWM.unSTCC.stcField.u1TGIEC)  /*@bf@*/

typedef struct stc_btn_pwm_stcc_field{
    uint_io8_t		u1UDIRC:1;
    uint_io8_t		u1DTIRC:1;
    uint_io8_t		u1TGIRC:1;
    uint_io8_t		:1;
    uint_io8_t		u1UDIEC:1;
    uint_io8_t		u1DTIEC:1;
    uint_io8_t		u1TGIEC:1;
    uint_io8_t		:1;
}stc_btn_pwm_stcc_field_t;

typedef union un_btn_pwm_stcc{
    uint_io8_t		u8Register;
    stc_btn_pwm_stcc_field_t		stcField;
}un_btn_pwm_stcc_t;

/* STCS */
#define BT00_PWM_STCS	(BT00_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT00_PWM_STCS_UDIES	(BT00_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT00_PWM_STCS_DTIES	(BT00_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT00_PWM_STCS_TGIES	(BT00_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT01_PWM_STCS	(BT01_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT01_PWM_STCS_UDIES	(BT01_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT01_PWM_STCS_DTIES	(BT01_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT01_PWM_STCS_TGIES	(BT01_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT02_PWM_STCS	(BT02_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT02_PWM_STCS_UDIES	(BT02_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT02_PWM_STCS_DTIES	(BT02_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT02_PWM_STCS_TGIES	(BT02_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT03_PWM_STCS	(BT03_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT03_PWM_STCS_UDIES	(BT03_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT03_PWM_STCS_DTIES	(BT03_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT03_PWM_STCS_TGIES	(BT03_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT04_PWM_STCS	(BT04_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT04_PWM_STCS_UDIES	(BT04_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT04_PWM_STCS_DTIES	(BT04_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT04_PWM_STCS_TGIES	(BT04_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT05_PWM_STCS	(BT05_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT05_PWM_STCS_UDIES	(BT05_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT05_PWM_STCS_DTIES	(BT05_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT05_PWM_STCS_TGIES	(BT05_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT06_PWM_STCS	(BT06_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT06_PWM_STCS_UDIES	(BT06_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT06_PWM_STCS_DTIES	(BT06_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT06_PWM_STCS_TGIES	(BT06_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT07_PWM_STCS	(BT07_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT07_PWM_STCS_UDIES	(BT07_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT07_PWM_STCS_DTIES	(BT07_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT07_PWM_STCS_TGIES	(BT07_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT08_PWM_STCS	(BT08_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT08_PWM_STCS_UDIES	(BT08_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT08_PWM_STCS_DTIES	(BT08_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT08_PWM_STCS_TGIES	(BT08_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT09_PWM_STCS	(BT09_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT09_PWM_STCS_UDIES	(BT09_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT09_PWM_STCS_DTIES	(BT09_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT09_PWM_STCS_TGIES	(BT09_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT10_PWM_STCS	(BT10_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT10_PWM_STCS_UDIES	(BT10_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT10_PWM_STCS_DTIES	(BT10_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT10_PWM_STCS_TGIES	(BT10_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT11_PWM_STCS	(BT11_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT11_PWM_STCS_UDIES	(BT11_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT11_PWM_STCS_DTIES	(BT11_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT11_PWM_STCS_TGIES	(BT11_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT12_PWM_STCS	(BT12_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT12_PWM_STCS_UDIES	(BT12_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT12_PWM_STCS_DTIES	(BT12_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT12_PWM_STCS_TGIES	(BT12_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT13_PWM_STCS	(BT13_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT13_PWM_STCS_UDIES	(BT13_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT13_PWM_STCS_DTIES	(BT13_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT13_PWM_STCS_TGIES	(BT13_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT14_PWM_STCS	(BT14_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT14_PWM_STCS_UDIES	(BT14_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT14_PWM_STCS_DTIES	(BT14_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT14_PWM_STCS_TGIES	(BT14_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT15_PWM_STCS	(BT15_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT15_PWM_STCS_UDIES	(BT15_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT15_PWM_STCS_DTIES	(BT15_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT15_PWM_STCS_TGIES	(BT15_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT16_PWM_STCS	(BT16_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT16_PWM_STCS_UDIES	(BT16_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT16_PWM_STCS_DTIES	(BT16_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT16_PWM_STCS_TGIES	(BT16_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT17_PWM_STCS	(BT17_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT17_PWM_STCS_UDIES	(BT17_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT17_PWM_STCS_DTIES	(BT17_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT17_PWM_STCS_TGIES	(BT17_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT18_PWM_STCS	(BT18_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT18_PWM_STCS_UDIES	(BT18_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT18_PWM_STCS_DTIES	(BT18_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT18_PWM_STCS_TGIES	(BT18_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT19_PWM_STCS	(BT19_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT19_PWM_STCS_UDIES	(BT19_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT19_PWM_STCS_DTIES	(BT19_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT19_PWM_STCS_TGIES	(BT19_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT20_PWM_STCS	(BT20_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT20_PWM_STCS_UDIES	(BT20_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT20_PWM_STCS_DTIES	(BT20_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT20_PWM_STCS_TGIES	(BT20_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT21_PWM_STCS	(BT21_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT21_PWM_STCS_UDIES	(BT21_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT21_PWM_STCS_DTIES	(BT21_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT21_PWM_STCS_TGIES	(BT21_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT22_PWM_STCS	(BT22_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT22_PWM_STCS_UDIES	(BT22_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT22_PWM_STCS_DTIES	(BT22_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT22_PWM_STCS_TGIES	(BT22_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT23_PWM_STCS	(BT23_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT23_PWM_STCS_UDIES	(BT23_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT23_PWM_STCS_DTIES	(BT23_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT23_PWM_STCS_TGIES	(BT23_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT24_PWM_STCS	(BT24_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT24_PWM_STCS_UDIES	(BT24_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT24_PWM_STCS_DTIES	(BT24_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT24_PWM_STCS_TGIES	(BT24_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT25_PWM_STCS	(BT25_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT25_PWM_STCS_UDIES	(BT25_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT25_PWM_STCS_DTIES	(BT25_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT25_PWM_STCS_TGIES	(BT25_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT26_PWM_STCS	(BT26_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT26_PWM_STCS_UDIES	(BT26_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT26_PWM_STCS_DTIES	(BT26_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT26_PWM_STCS_TGIES	(BT26_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT27_PWM_STCS	(BT27_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT27_PWM_STCS_UDIES	(BT27_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT27_PWM_STCS_DTIES	(BT27_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT27_PWM_STCS_TGIES	(BT27_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT28_PWM_STCS	(BT28_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT28_PWM_STCS_UDIES	(BT28_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT28_PWM_STCS_DTIES	(BT28_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT28_PWM_STCS_TGIES	(BT28_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT29_PWM_STCS	(BT29_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT29_PWM_STCS_UDIES	(BT29_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT29_PWM_STCS_DTIES	(BT29_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT29_PWM_STCS_TGIES	(BT29_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT30_PWM_STCS	(BT30_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT30_PWM_STCS_UDIES	(BT30_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT30_PWM_STCS_DTIES	(BT30_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT30_PWM_STCS_TGIES	(BT30_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT31_PWM_STCS	(BT31_PWM.unSTCS.u8Register)  /*@rg@*/
#define BT31_PWM_STCS_UDIES	(BT31_PWM.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT31_PWM_STCS_DTIES	(BT31_PWM.unSTCS.stcField.u1DTIES)  /*@bf@*/
#define BT31_PWM_STCS_TGIES	(BT31_PWM.unSTCS.stcField.u1TGIES)  /*@bf@*/

typedef struct stc_btn_pwm_stcs_field{
    uint_io8_t		:4;
    uint_io8_t		u1UDIES:1;
    uint_io8_t		u1DTIES:1;
    uint_io8_t		u1TGIES:1;
    uint_io8_t		:1;
}stc_btn_pwm_stcs_field_t;

typedef union un_btn_pwm_stcs{
    uint_io8_t		u8Register;
    stc_btn_pwm_stcs_field_t		stcField;
}un_btn_pwm_stcs_t;

/* PSDR */
#define BT00_PWM_PSDR	(BT00_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT00_PWM_PSDR_PSDR	BT00_PWM_PSDR  /*@bfrg@*/

#define BT01_PWM_PSDR	(BT01_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT01_PWM_PSDR_PSDR	BT01_PWM_PSDR  /*@bfrg@*/

#define BT02_PWM_PSDR	(BT02_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT02_PWM_PSDR_PSDR	BT02_PWM_PSDR  /*@bfrg@*/

#define BT03_PWM_PSDR	(BT03_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT03_PWM_PSDR_PSDR	BT03_PWM_PSDR  /*@bfrg@*/

#define BT04_PWM_PSDR	(BT04_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT04_PWM_PSDR_PSDR	BT04_PWM_PSDR  /*@bfrg@*/

#define BT05_PWM_PSDR	(BT05_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT05_PWM_PSDR_PSDR	BT05_PWM_PSDR  /*@bfrg@*/

#define BT06_PWM_PSDR	(BT06_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT06_PWM_PSDR_PSDR	BT06_PWM_PSDR  /*@bfrg@*/

#define BT07_PWM_PSDR	(BT07_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT07_PWM_PSDR_PSDR	BT07_PWM_PSDR  /*@bfrg@*/

#define BT08_PWM_PSDR	(BT08_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT08_PWM_PSDR_PSDR	BT08_PWM_PSDR  /*@bfrg@*/

#define BT09_PWM_PSDR	(BT09_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT09_PWM_PSDR_PSDR	BT09_PWM_PSDR  /*@bfrg@*/

#define BT10_PWM_PSDR	(BT10_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT10_PWM_PSDR_PSDR	BT10_PWM_PSDR  /*@bfrg@*/

#define BT11_PWM_PSDR	(BT11_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT11_PWM_PSDR_PSDR	BT11_PWM_PSDR  /*@bfrg@*/

#define BT12_PWM_PSDR	(BT12_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT12_PWM_PSDR_PSDR	BT12_PWM_PSDR  /*@bfrg@*/

#define BT13_PWM_PSDR	(BT13_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT13_PWM_PSDR_PSDR	BT13_PWM_PSDR  /*@bfrg@*/

#define BT14_PWM_PSDR	(BT14_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT14_PWM_PSDR_PSDR	BT14_PWM_PSDR  /*@bfrg@*/

#define BT15_PWM_PSDR	(BT15_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT15_PWM_PSDR_PSDR	BT15_PWM_PSDR  /*@bfrg@*/

#define BT16_PWM_PSDR	(BT16_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT16_PWM_PSDR_PSDR	BT16_PWM_PSDR  /*@bfrg@*/

#define BT17_PWM_PSDR	(BT17_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT17_PWM_PSDR_PSDR	BT17_PWM_PSDR  /*@bfrg@*/

#define BT18_PWM_PSDR	(BT18_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT18_PWM_PSDR_PSDR	BT18_PWM_PSDR  /*@bfrg@*/

#define BT19_PWM_PSDR	(BT19_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT19_PWM_PSDR_PSDR	BT19_PWM_PSDR  /*@bfrg@*/

#define BT20_PWM_PSDR	(BT20_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT20_PWM_PSDR_PSDR	BT20_PWM_PSDR  /*@bfrg@*/

#define BT21_PWM_PSDR	(BT21_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT21_PWM_PSDR_PSDR	BT21_PWM_PSDR  /*@bfrg@*/

#define BT22_PWM_PSDR	(BT22_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT22_PWM_PSDR_PSDR	BT22_PWM_PSDR  /*@bfrg@*/

#define BT23_PWM_PSDR	(BT23_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT23_PWM_PSDR_PSDR	BT23_PWM_PSDR  /*@bfrg@*/

#define BT24_PWM_PSDR	(BT24_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT24_PWM_PSDR_PSDR	BT24_PWM_PSDR  /*@bfrg@*/

#define BT25_PWM_PSDR	(BT25_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT25_PWM_PSDR_PSDR	BT25_PWM_PSDR  /*@bfrg@*/

#define BT26_PWM_PSDR	(BT26_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT26_PWM_PSDR_PSDR	BT26_PWM_PSDR  /*@bfrg@*/

#define BT27_PWM_PSDR	(BT27_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT27_PWM_PSDR_PSDR	BT27_PWM_PSDR  /*@bfrg@*/

#define BT28_PWM_PSDR	(BT28_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT28_PWM_PSDR_PSDR	BT28_PWM_PSDR  /*@bfrg@*/

#define BT29_PWM_PSDR	(BT29_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT29_PWM_PSDR_PSDR	BT29_PWM_PSDR  /*@bfrg@*/

#define BT30_PWM_PSDR	(BT30_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT30_PWM_PSDR_PSDR	BT30_PWM_PSDR  /*@bfrg@*/

#define BT31_PWM_PSDR	(BT31_PWM.unPSDR.u16Register)  /*@rg@*/
#define BT31_PWM_PSDR_PSDR	BT31_PWM_PSDR  /*@bfrg@*/

typedef union un_btn_pwm_psdr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_psdr_t;

/* ADTR */
#define BT00_PWM_ADTR	(BT00_PWM.unADTR.u16Register)  /*@rg@*/
#define BT00_PWM_ADTR_ADTR	BT00_PWM_ADTR  /*@bfrg@*/

#define BT01_PWM_ADTR	(BT01_PWM.unADTR.u16Register)  /*@rg@*/
#define BT01_PWM_ADTR_ADTR	BT01_PWM_ADTR  /*@bfrg@*/

#define BT02_PWM_ADTR	(BT02_PWM.unADTR.u16Register)  /*@rg@*/
#define BT02_PWM_ADTR_ADTR	BT02_PWM_ADTR  /*@bfrg@*/

#define BT03_PWM_ADTR	(BT03_PWM.unADTR.u16Register)  /*@rg@*/
#define BT03_PWM_ADTR_ADTR	BT03_PWM_ADTR  /*@bfrg@*/

#define BT04_PWM_ADTR	(BT04_PWM.unADTR.u16Register)  /*@rg@*/
#define BT04_PWM_ADTR_ADTR	BT04_PWM_ADTR  /*@bfrg@*/

#define BT05_PWM_ADTR	(BT05_PWM.unADTR.u16Register)  /*@rg@*/
#define BT05_PWM_ADTR_ADTR	BT05_PWM_ADTR  /*@bfrg@*/

#define BT06_PWM_ADTR	(BT06_PWM.unADTR.u16Register)  /*@rg@*/
#define BT06_PWM_ADTR_ADTR	BT06_PWM_ADTR  /*@bfrg@*/

#define BT07_PWM_ADTR	(BT07_PWM.unADTR.u16Register)  /*@rg@*/
#define BT07_PWM_ADTR_ADTR	BT07_PWM_ADTR  /*@bfrg@*/

#define BT08_PWM_ADTR	(BT08_PWM.unADTR.u16Register)  /*@rg@*/
#define BT08_PWM_ADTR_ADTR	BT08_PWM_ADTR  /*@bfrg@*/

#define BT09_PWM_ADTR	(BT09_PWM.unADTR.u16Register)  /*@rg@*/
#define BT09_PWM_ADTR_ADTR	BT09_PWM_ADTR  /*@bfrg@*/

#define BT10_PWM_ADTR	(BT10_PWM.unADTR.u16Register)  /*@rg@*/
#define BT10_PWM_ADTR_ADTR	BT10_PWM_ADTR  /*@bfrg@*/

#define BT11_PWM_ADTR	(BT11_PWM.unADTR.u16Register)  /*@rg@*/
#define BT11_PWM_ADTR_ADTR	BT11_PWM_ADTR  /*@bfrg@*/

#define BT12_PWM_ADTR	(BT12_PWM.unADTR.u16Register)  /*@rg@*/
#define BT12_PWM_ADTR_ADTR	BT12_PWM_ADTR  /*@bfrg@*/

#define BT13_PWM_ADTR	(BT13_PWM.unADTR.u16Register)  /*@rg@*/
#define BT13_PWM_ADTR_ADTR	BT13_PWM_ADTR  /*@bfrg@*/

#define BT14_PWM_ADTR	(BT14_PWM.unADTR.u16Register)  /*@rg@*/
#define BT14_PWM_ADTR_ADTR	BT14_PWM_ADTR  /*@bfrg@*/

#define BT15_PWM_ADTR	(BT15_PWM.unADTR.u16Register)  /*@rg@*/
#define BT15_PWM_ADTR_ADTR	BT15_PWM_ADTR  /*@bfrg@*/

#define BT16_PWM_ADTR	(BT16_PWM.unADTR.u16Register)  /*@rg@*/
#define BT16_PWM_ADTR_ADTR	BT16_PWM_ADTR  /*@bfrg@*/

#define BT17_PWM_ADTR	(BT17_PWM.unADTR.u16Register)  /*@rg@*/
#define BT17_PWM_ADTR_ADTR	BT17_PWM_ADTR  /*@bfrg@*/

#define BT18_PWM_ADTR	(BT18_PWM.unADTR.u16Register)  /*@rg@*/
#define BT18_PWM_ADTR_ADTR	BT18_PWM_ADTR  /*@bfrg@*/

#define BT19_PWM_ADTR	(BT19_PWM.unADTR.u16Register)  /*@rg@*/
#define BT19_PWM_ADTR_ADTR	BT19_PWM_ADTR  /*@bfrg@*/

#define BT20_PWM_ADTR	(BT20_PWM.unADTR.u16Register)  /*@rg@*/
#define BT20_PWM_ADTR_ADTR	BT20_PWM_ADTR  /*@bfrg@*/

#define BT21_PWM_ADTR	(BT21_PWM.unADTR.u16Register)  /*@rg@*/
#define BT21_PWM_ADTR_ADTR	BT21_PWM_ADTR  /*@bfrg@*/

#define BT22_PWM_ADTR	(BT22_PWM.unADTR.u16Register)  /*@rg@*/
#define BT22_PWM_ADTR_ADTR	BT22_PWM_ADTR  /*@bfrg@*/

#define BT23_PWM_ADTR	(BT23_PWM.unADTR.u16Register)  /*@rg@*/
#define BT23_PWM_ADTR_ADTR	BT23_PWM_ADTR  /*@bfrg@*/

#define BT24_PWM_ADTR	(BT24_PWM.unADTR.u16Register)  /*@rg@*/
#define BT24_PWM_ADTR_ADTR	BT24_PWM_ADTR  /*@bfrg@*/

#define BT25_PWM_ADTR	(BT25_PWM.unADTR.u16Register)  /*@rg@*/
#define BT25_PWM_ADTR_ADTR	BT25_PWM_ADTR  /*@bfrg@*/

#define BT26_PWM_ADTR	(BT26_PWM.unADTR.u16Register)  /*@rg@*/
#define BT26_PWM_ADTR_ADTR	BT26_PWM_ADTR  /*@bfrg@*/

#define BT27_PWM_ADTR	(BT27_PWM.unADTR.u16Register)  /*@rg@*/
#define BT27_PWM_ADTR_ADTR	BT27_PWM_ADTR  /*@bfrg@*/

#define BT28_PWM_ADTR	(BT28_PWM.unADTR.u16Register)  /*@rg@*/
#define BT28_PWM_ADTR_ADTR	BT28_PWM_ADTR  /*@bfrg@*/

#define BT29_PWM_ADTR	(BT29_PWM.unADTR.u16Register)  /*@rg@*/
#define BT29_PWM_ADTR_ADTR	BT29_PWM_ADTR  /*@bfrg@*/

#define BT30_PWM_ADTR	(BT30_PWM.unADTR.u16Register)  /*@rg@*/
#define BT30_PWM_ADTR_ADTR	BT30_PWM_ADTR  /*@bfrg@*/

#define BT31_PWM_ADTR	(BT31_PWM.unADTR.u16Register)  /*@rg@*/
#define BT31_PWM_ADTR_ADTR	BT31_PWM_ADTR  /*@bfrg@*/

typedef union un_btn_pwm_adtr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_adtr_t;

/* BT_DEBUG */
#define BT00_PWM_BT_DEBUG	(BT00_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT00_PWM_BT_DEBUG_DBGEN	(BT00_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT01_PWM_BT_DEBUG	(BT01_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT01_PWM_BT_DEBUG_DBGEN	(BT01_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT02_PWM_BT_DEBUG	(BT02_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT02_PWM_BT_DEBUG_DBGEN	(BT02_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT03_PWM_BT_DEBUG	(BT03_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT03_PWM_BT_DEBUG_DBGEN	(BT03_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT04_PWM_BT_DEBUG	(BT04_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT04_PWM_BT_DEBUG_DBGEN	(BT04_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT05_PWM_BT_DEBUG	(BT05_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT05_PWM_BT_DEBUG_DBGEN	(BT05_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT06_PWM_BT_DEBUG	(BT06_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT06_PWM_BT_DEBUG_DBGEN	(BT06_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT07_PWM_BT_DEBUG	(BT07_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT07_PWM_BT_DEBUG_DBGEN	(BT07_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT08_PWM_BT_DEBUG	(BT08_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT08_PWM_BT_DEBUG_DBGEN	(BT08_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT09_PWM_BT_DEBUG	(BT09_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT09_PWM_BT_DEBUG_DBGEN	(BT09_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT10_PWM_BT_DEBUG	(BT10_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT10_PWM_BT_DEBUG_DBGEN	(BT10_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT11_PWM_BT_DEBUG	(BT11_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT11_PWM_BT_DEBUG_DBGEN	(BT11_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT12_PWM_BT_DEBUG	(BT12_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT12_PWM_BT_DEBUG_DBGEN	(BT12_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT13_PWM_BT_DEBUG	(BT13_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT13_PWM_BT_DEBUG_DBGEN	(BT13_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT14_PWM_BT_DEBUG	(BT14_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT14_PWM_BT_DEBUG_DBGEN	(BT14_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT15_PWM_BT_DEBUG	(BT15_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT15_PWM_BT_DEBUG_DBGEN	(BT15_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT16_PWM_BT_DEBUG	(BT16_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT16_PWM_BT_DEBUG_DBGEN	(BT16_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT17_PWM_BT_DEBUG	(BT17_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT17_PWM_BT_DEBUG_DBGEN	(BT17_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT18_PWM_BT_DEBUG	(BT18_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT18_PWM_BT_DEBUG_DBGEN	(BT18_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT19_PWM_BT_DEBUG	(BT19_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT19_PWM_BT_DEBUG_DBGEN	(BT19_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT20_PWM_BT_DEBUG	(BT20_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT20_PWM_BT_DEBUG_DBGEN	(BT20_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT21_PWM_BT_DEBUG	(BT21_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT21_PWM_BT_DEBUG_DBGEN	(BT21_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT22_PWM_BT_DEBUG	(BT22_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT22_PWM_BT_DEBUG_DBGEN	(BT22_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT23_PWM_BT_DEBUG	(BT23_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT23_PWM_BT_DEBUG_DBGEN	(BT23_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT24_PWM_BT_DEBUG	(BT24_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT24_PWM_BT_DEBUG_DBGEN	(BT24_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT25_PWM_BT_DEBUG	(BT25_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT25_PWM_BT_DEBUG_DBGEN	(BT25_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT26_PWM_BT_DEBUG	(BT26_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT26_PWM_BT_DEBUG_DBGEN	(BT26_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT27_PWM_BT_DEBUG	(BT27_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT27_PWM_BT_DEBUG_DBGEN	(BT27_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT28_PWM_BT_DEBUG	(BT28_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT28_PWM_BT_DEBUG_DBGEN	(BT28_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT29_PWM_BT_DEBUG	(BT29_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT29_PWM_BT_DEBUG_DBGEN	(BT29_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT30_PWM_BT_DEBUG	(BT30_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT30_PWM_BT_DEBUG_DBGEN	(BT30_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT31_PWM_BT_DEBUG	(BT31_PWM.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT31_PWM_BT_DEBUG_DBGEN	(BT31_PWM.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

typedef struct stc_btn_pwm_bt_debug_field{
    uint_io16_t		u1DBGEN:1;
    uint_io16_t		:15;
}stc_btn_pwm_bt_debug_field_t;

typedef union un_btn_pwm_bt_debug{
    uint_io16_t		u16Register;
    stc_btn_pwm_bt_debug_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_bt_debug_t;

/* ETCDR */
#define BT00_PWM_ETCDR	(BT00_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT00_PWM_ETCDR_ETCDR	BT00_PWM_ETCDR  /*@bfrg@*/

#define BT01_PWM_ETCDR	(BT01_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT01_PWM_ETCDR_ETCDR	BT01_PWM_ETCDR  /*@bfrg@*/

#define BT02_PWM_ETCDR	(BT02_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT02_PWM_ETCDR_ETCDR	BT02_PWM_ETCDR  /*@bfrg@*/

#define BT03_PWM_ETCDR	(BT03_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT03_PWM_ETCDR_ETCDR	BT03_PWM_ETCDR  /*@bfrg@*/

#define BT04_PWM_ETCDR	(BT04_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT04_PWM_ETCDR_ETCDR	BT04_PWM_ETCDR  /*@bfrg@*/

#define BT05_PWM_ETCDR	(BT05_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT05_PWM_ETCDR_ETCDR	BT05_PWM_ETCDR  /*@bfrg@*/

#define BT06_PWM_ETCDR	(BT06_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT06_PWM_ETCDR_ETCDR	BT06_PWM_ETCDR  /*@bfrg@*/

#define BT07_PWM_ETCDR	(BT07_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT07_PWM_ETCDR_ETCDR	BT07_PWM_ETCDR  /*@bfrg@*/

#define BT08_PWM_ETCDR	(BT08_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT08_PWM_ETCDR_ETCDR	BT08_PWM_ETCDR  /*@bfrg@*/

#define BT09_PWM_ETCDR	(BT09_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT09_PWM_ETCDR_ETCDR	BT09_PWM_ETCDR  /*@bfrg@*/

#define BT10_PWM_ETCDR	(BT10_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT10_PWM_ETCDR_ETCDR	BT10_PWM_ETCDR  /*@bfrg@*/

#define BT11_PWM_ETCDR	(BT11_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT11_PWM_ETCDR_ETCDR	BT11_PWM_ETCDR  /*@bfrg@*/

#define BT12_PWM_ETCDR	(BT12_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT12_PWM_ETCDR_ETCDR	BT12_PWM_ETCDR  /*@bfrg@*/

#define BT13_PWM_ETCDR	(BT13_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT13_PWM_ETCDR_ETCDR	BT13_PWM_ETCDR  /*@bfrg@*/

#define BT14_PWM_ETCDR	(BT14_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT14_PWM_ETCDR_ETCDR	BT14_PWM_ETCDR  /*@bfrg@*/

#define BT15_PWM_ETCDR	(BT15_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT15_PWM_ETCDR_ETCDR	BT15_PWM_ETCDR  /*@bfrg@*/

#define BT16_PWM_ETCDR	(BT16_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT16_PWM_ETCDR_ETCDR	BT16_PWM_ETCDR  /*@bfrg@*/

#define BT17_PWM_ETCDR	(BT17_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT17_PWM_ETCDR_ETCDR	BT17_PWM_ETCDR  /*@bfrg@*/

#define BT18_PWM_ETCDR	(BT18_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT18_PWM_ETCDR_ETCDR	BT18_PWM_ETCDR  /*@bfrg@*/

#define BT19_PWM_ETCDR	(BT19_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT19_PWM_ETCDR_ETCDR	BT19_PWM_ETCDR  /*@bfrg@*/

#define BT20_PWM_ETCDR	(BT20_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT20_PWM_ETCDR_ETCDR	BT20_PWM_ETCDR  /*@bfrg@*/

#define BT21_PWM_ETCDR	(BT21_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT21_PWM_ETCDR_ETCDR	BT21_PWM_ETCDR  /*@bfrg@*/

#define BT22_PWM_ETCDR	(BT22_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT22_PWM_ETCDR_ETCDR	BT22_PWM_ETCDR  /*@bfrg@*/

#define BT23_PWM_ETCDR	(BT23_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT23_PWM_ETCDR_ETCDR	BT23_PWM_ETCDR  /*@bfrg@*/

#define BT24_PWM_ETCDR	(BT24_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT24_PWM_ETCDR_ETCDR	BT24_PWM_ETCDR  /*@bfrg@*/

#define BT25_PWM_ETCDR	(BT25_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT25_PWM_ETCDR_ETCDR	BT25_PWM_ETCDR  /*@bfrg@*/

#define BT26_PWM_ETCDR	(BT26_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT26_PWM_ETCDR_ETCDR	BT26_PWM_ETCDR  /*@bfrg@*/

#define BT27_PWM_ETCDR	(BT27_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT27_PWM_ETCDR_ETCDR	BT27_PWM_ETCDR  /*@bfrg@*/

#define BT28_PWM_ETCDR	(BT28_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT28_PWM_ETCDR_ETCDR	BT28_PWM_ETCDR  /*@bfrg@*/

#define BT29_PWM_ETCDR	(BT29_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT29_PWM_ETCDR_ETCDR	BT29_PWM_ETCDR  /*@bfrg@*/

#define BT30_PWM_ETCDR	(BT30_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT30_PWM_ETCDR_ETCDR	BT30_PWM_ETCDR  /*@bfrg@*/

#define BT31_PWM_ETCDR	(BT31_PWM.unETCDR.u16Register)  /*@rg@*/
#define BT31_PWM_ETCDR_ETCDR	BT31_PWM_ETCDR  /*@bfrg@*/

typedef union un_btn_pwm_etcdr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwm_etcdr_t;


typedef struct stc_btn_pwm{
    un_btn_pwm_pcsr_t	unPCSR;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[2];	/* 0x00000002 */
    un_btn_pwm_pdut_t	unPDUT;	/* 0x00000004 */
    uint_io8_t	au8Reserved1[2];	/* 0x00000006 */
    un_btn_pwm_tmr_t	unTMR;	/* 0x00000008 */
    un_btn_pwm_tmcr_t	unTMCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved2[2];	/* 0x0000000E */
    un_btn_pwm_stc_t	unSTC;	/* 0x00000010 */
    un_btn_pwm_tmcr2_t	unTMCR2;	/* 0x00000011 */
    uint_io8_t	au8Reserved3[2];	/* 0x00000012 */
    un_btn_pwm_stcc_t	unSTCC;	/* 0x00000014 */
    uint_io8_t	au8Reserved4[3];	/* 0x00000015 */
    un_btn_pwm_stcs_t	unSTCS;	/* 0x00000018 */
    uint_io8_t	au8Reserved5[3];	/* 0x00000019 */
    un_btn_pwm_psdr_t	unPSDR;	/* 0x0000001C */
    uint_io8_t	au8Reserved6[2];	/* 0x0000001E */
    un_btn_pwm_adtr_t	unADTR;	/* 0x00000020 */
    uint_io8_t	au8Reserved7[2];	/* 0x00000022 */
    un_btn_pwm_bt_debug_t	unBT_DEBUG;	/* 0x00000024 */
    uint_io8_t	au8Reserved8[6];	/* 0x00000026 */
    un_btn_pwm_etcdr_t	unETCDR;	/* 0x0000002C */
    uint_io8_t	au8Reserved9[2];	/* 0x0000002E */
}stc_btn_pwm_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_btn_pwm_t	stcBT_PWM[32];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 48(0x30) bytes */


#endif /* __S6J3360_BT_PWM_H */
