/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_SG_H
#define __S6J3360_SG_H

#include "s6j3360io_basetypes.h"

/* SG[0-4] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define SG0	stcSG[0]
#define SG1	stcSG[1]
#define SG2	stcSG[2]
#define SG3	stcSG[3]
#define SG4	stcSG[4]
#else /* __IO_DEFINE */
#define SG0	(*((volatile stc_sgn_t*)0xB4840000))
#define SG1	(*((volatile stc_sgn_t*)0xB4840400))
#define SG2	(*((volatile stc_sgn_t*)0xB4840800))
#define SG3	(*((volatile stc_sgn_t*)0xB4840C00))
#define SG4	(*((volatile stc_sgn_t*)0xB4841000))
#endif /* __IO_DEFINE */

/* SGCR */
#define SG0_SGCR	(SG0.unSGCR.u16Register)  /*@rg@*/
#define SG0_SGCR_ST	(SG0.unSGCR.stcField.u1ST)  /*@bf@*/
#define SG0_SGCR_INT	(SG0.unSGCR.stcField.u1INT)  /*@bf@*/
#define SG0_SGCR_INTE	(SG0.unSGCR.stcField.u1INTE)  /*@bf@*/
#define SG0_SGCR_SGAOE	(SG0.unSGCR.stcField.u1SGAOE)  /*@bf@*/
#define SG0_SGCR_SGOOE	(SG0.unSGCR.stcField.u1SGOOE)  /*@bf@*/
#define SG0_SGCR_TONE	(SG0.unSGCR.stcField.u1TONE)  /*@bf@*/
#define SG0_SGCR_S	(SG0.unSGCR.stcField.u2S)  /*@bf@*/
#define SG0_SGCR_TMS	(SG0.unSGCR.stcField.u1TMS)  /*@bf@*/
#define SG0_SGCR_BUSY	(SG0.unSGCR.stcField.u1BUSY)  /*@bf@*/
#define SG0_SGCR_GEN	(SG0.unSGCR.stcField.u1GEN)  /*@bf@*/
#define SG0_SGCR_GID	(SG0.unSGCR.stcField.u1GID)  /*@bf@*/
#define SG0_SGCR_DMA	(SG0.unSGCR.stcField.u1DMA)  /*@bf@*/
#define SG0_SGCR_SRST	(SG0.unSGCR.stcField.u1SRST)  /*@bf@*/

#define SG1_SGCR	(SG1.unSGCR.u16Register)  /*@rg@*/
#define SG1_SGCR_ST	(SG1.unSGCR.stcField.u1ST)  /*@bf@*/
#define SG1_SGCR_INT	(SG1.unSGCR.stcField.u1INT)  /*@bf@*/
#define SG1_SGCR_INTE	(SG1.unSGCR.stcField.u1INTE)  /*@bf@*/
#define SG1_SGCR_SGAOE	(SG1.unSGCR.stcField.u1SGAOE)  /*@bf@*/
#define SG1_SGCR_SGOOE	(SG1.unSGCR.stcField.u1SGOOE)  /*@bf@*/
#define SG1_SGCR_TONE	(SG1.unSGCR.stcField.u1TONE)  /*@bf@*/
#define SG1_SGCR_S	(SG1.unSGCR.stcField.u2S)  /*@bf@*/
#define SG1_SGCR_TMS	(SG1.unSGCR.stcField.u1TMS)  /*@bf@*/
#define SG1_SGCR_BUSY	(SG1.unSGCR.stcField.u1BUSY)  /*@bf@*/
#define SG1_SGCR_GEN	(SG1.unSGCR.stcField.u1GEN)  /*@bf@*/
#define SG1_SGCR_GID	(SG1.unSGCR.stcField.u1GID)  /*@bf@*/
#define SG1_SGCR_DMA	(SG1.unSGCR.stcField.u1DMA)  /*@bf@*/
#define SG1_SGCR_SRST	(SG1.unSGCR.stcField.u1SRST)  /*@bf@*/

#define SG2_SGCR	(SG2.unSGCR.u16Register)  /*@rg@*/
#define SG2_SGCR_ST	(SG2.unSGCR.stcField.u1ST)  /*@bf@*/
#define SG2_SGCR_INT	(SG2.unSGCR.stcField.u1INT)  /*@bf@*/
#define SG2_SGCR_INTE	(SG2.unSGCR.stcField.u1INTE)  /*@bf@*/
#define SG2_SGCR_SGAOE	(SG2.unSGCR.stcField.u1SGAOE)  /*@bf@*/
#define SG2_SGCR_SGOOE	(SG2.unSGCR.stcField.u1SGOOE)  /*@bf@*/
#define SG2_SGCR_TONE	(SG2.unSGCR.stcField.u1TONE)  /*@bf@*/
#define SG2_SGCR_S	(SG2.unSGCR.stcField.u2S)  /*@bf@*/
#define SG2_SGCR_TMS	(SG2.unSGCR.stcField.u1TMS)  /*@bf@*/
#define SG2_SGCR_BUSY	(SG2.unSGCR.stcField.u1BUSY)  /*@bf@*/
#define SG2_SGCR_GEN	(SG2.unSGCR.stcField.u1GEN)  /*@bf@*/
#define SG2_SGCR_GID	(SG2.unSGCR.stcField.u1GID)  /*@bf@*/
#define SG2_SGCR_DMA	(SG2.unSGCR.stcField.u1DMA)  /*@bf@*/
#define SG2_SGCR_SRST	(SG2.unSGCR.stcField.u1SRST)  /*@bf@*/

#define SG3_SGCR	(SG3.unSGCR.u16Register)  /*@rg@*/
#define SG3_SGCR_ST	(SG3.unSGCR.stcField.u1ST)  /*@bf@*/
#define SG3_SGCR_INT	(SG3.unSGCR.stcField.u1INT)  /*@bf@*/
#define SG3_SGCR_INTE	(SG3.unSGCR.stcField.u1INTE)  /*@bf@*/
#define SG3_SGCR_SGAOE	(SG3.unSGCR.stcField.u1SGAOE)  /*@bf@*/
#define SG3_SGCR_SGOOE	(SG3.unSGCR.stcField.u1SGOOE)  /*@bf@*/
#define SG3_SGCR_TONE	(SG3.unSGCR.stcField.u1TONE)  /*@bf@*/
#define SG3_SGCR_S	(SG3.unSGCR.stcField.u2S)  /*@bf@*/
#define SG3_SGCR_TMS	(SG3.unSGCR.stcField.u1TMS)  /*@bf@*/
#define SG3_SGCR_BUSY	(SG3.unSGCR.stcField.u1BUSY)  /*@bf@*/
#define SG3_SGCR_GEN	(SG3.unSGCR.stcField.u1GEN)  /*@bf@*/
#define SG3_SGCR_GID	(SG3.unSGCR.stcField.u1GID)  /*@bf@*/
#define SG3_SGCR_DMA	(SG3.unSGCR.stcField.u1DMA)  /*@bf@*/
#define SG3_SGCR_SRST	(SG3.unSGCR.stcField.u1SRST)  /*@bf@*/

#define SG4_SGCR	(SG4.unSGCR.u16Register)  /*@rg@*/
#define SG4_SGCR_ST	(SG4.unSGCR.stcField.u1ST)  /*@bf@*/
#define SG4_SGCR_INT	(SG4.unSGCR.stcField.u1INT)  /*@bf@*/
#define SG4_SGCR_INTE	(SG4.unSGCR.stcField.u1INTE)  /*@bf@*/
#define SG4_SGCR_SGAOE	(SG4.unSGCR.stcField.u1SGAOE)  /*@bf@*/
#define SG4_SGCR_SGOOE	(SG4.unSGCR.stcField.u1SGOOE)  /*@bf@*/
#define SG4_SGCR_TONE	(SG4.unSGCR.stcField.u1TONE)  /*@bf@*/
#define SG4_SGCR_S	(SG4.unSGCR.stcField.u2S)  /*@bf@*/
#define SG4_SGCR_TMS	(SG4.unSGCR.stcField.u1TMS)  /*@bf@*/
#define SG4_SGCR_BUSY	(SG4.unSGCR.stcField.u1BUSY)  /*@bf@*/
#define SG4_SGCR_GEN	(SG4.unSGCR.stcField.u1GEN)  /*@bf@*/
#define SG4_SGCR_GID	(SG4.unSGCR.stcField.u1GID)  /*@bf@*/
#define SG4_SGCR_DMA	(SG4.unSGCR.stcField.u1DMA)  /*@bf@*/
#define SG4_SGCR_SRST	(SG4.unSGCR.stcField.u1SRST)  /*@bf@*/

typedef struct stc_sgn_sgcr_field{
    uint_io16_t		u1ST:1;
    uint_io16_t		u1INT:1;
    uint_io16_t		u1INTE:1;
    uint_io16_t		u1SGAOE:1;
    uint_io16_t		u1SGOOE:1;
    uint_io16_t		u1TONE:1;
    uint_io16_t		u2S:2;
    uint_io16_t		u1TMS:1;
    uint_io16_t		u1BUSY:1;
    uint_io16_t		:1;
    uint_io16_t		u1GEN:1;
    uint_io16_t		u1GID:1;
    uint_io16_t		u1DMA:1;
    uint_io16_t		u1SRST:1;
    uint_io16_t		:1;
}stc_sgn_sgcr_field_t;

typedef union un_sgn_sgcr{
    uint_io16_t		u16Register;
    stc_sgn_sgcr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_sgn_sgcr_t;

/* SGDER */
#define SG0_SGDER	(SG0.unSGDER.u16Register)  /*@rg@*/
#define SG0_SGDER_PCRE0	(SG0.unSGDER.stcField.u1PCRE0)  /*@bf@*/
#define SG0_SGDER_PCRE1	(SG0.unSGDER.stcField.u1PCRE1)  /*@bf@*/
#define SG0_SGDER_IDRE	(SG0.unSGDER.stcField.u1IDRE)  /*@bf@*/
#define SG0_SGDER_TCRE	(SG0.unSGDER.stcField.u1TCRE)  /*@bf@*/
#define SG0_SGDER_NRE	(SG0.unSGDER.stcField.u1NRE)  /*@bf@*/
#define SG0_SGDER_FRE	(SG0.unSGDER.stcField.u1FRE)  /*@bf@*/
#define SG0_SGDER_ARE0	(SG0.unSGDER.stcField.u1ARE0)  /*@bf@*/
#define SG0_SGDER_ARE1	(SG0.unSGDER.stcField.u1ARE1)  /*@bf@*/
#define SG0_SGDER_EFRE	(SG0.unSGDER.stcField.u1EFRE)  /*@bf@*/

#define SG1_SGDER	(SG1.unSGDER.u16Register)  /*@rg@*/
#define SG1_SGDER_PCRE0	(SG1.unSGDER.stcField.u1PCRE0)  /*@bf@*/
#define SG1_SGDER_PCRE1	(SG1.unSGDER.stcField.u1PCRE1)  /*@bf@*/
#define SG1_SGDER_IDRE	(SG1.unSGDER.stcField.u1IDRE)  /*@bf@*/
#define SG1_SGDER_TCRE	(SG1.unSGDER.stcField.u1TCRE)  /*@bf@*/
#define SG1_SGDER_NRE	(SG1.unSGDER.stcField.u1NRE)  /*@bf@*/
#define SG1_SGDER_FRE	(SG1.unSGDER.stcField.u1FRE)  /*@bf@*/
#define SG1_SGDER_ARE0	(SG1.unSGDER.stcField.u1ARE0)  /*@bf@*/
#define SG1_SGDER_ARE1	(SG1.unSGDER.stcField.u1ARE1)  /*@bf@*/
#define SG1_SGDER_EFRE	(SG1.unSGDER.stcField.u1EFRE)  /*@bf@*/

#define SG2_SGDER	(SG2.unSGDER.u16Register)  /*@rg@*/
#define SG2_SGDER_PCRE0	(SG2.unSGDER.stcField.u1PCRE0)  /*@bf@*/
#define SG2_SGDER_PCRE1	(SG2.unSGDER.stcField.u1PCRE1)  /*@bf@*/
#define SG2_SGDER_IDRE	(SG2.unSGDER.stcField.u1IDRE)  /*@bf@*/
#define SG2_SGDER_TCRE	(SG2.unSGDER.stcField.u1TCRE)  /*@bf@*/
#define SG2_SGDER_NRE	(SG2.unSGDER.stcField.u1NRE)  /*@bf@*/
#define SG2_SGDER_FRE	(SG2.unSGDER.stcField.u1FRE)  /*@bf@*/
#define SG2_SGDER_ARE0	(SG2.unSGDER.stcField.u1ARE0)  /*@bf@*/
#define SG2_SGDER_ARE1	(SG2.unSGDER.stcField.u1ARE1)  /*@bf@*/
#define SG2_SGDER_EFRE	(SG2.unSGDER.stcField.u1EFRE)  /*@bf@*/

#define SG3_SGDER	(SG3.unSGDER.u16Register)  /*@rg@*/
#define SG3_SGDER_PCRE0	(SG3.unSGDER.stcField.u1PCRE0)  /*@bf@*/
#define SG3_SGDER_PCRE1	(SG3.unSGDER.stcField.u1PCRE1)  /*@bf@*/
#define SG3_SGDER_IDRE	(SG3.unSGDER.stcField.u1IDRE)  /*@bf@*/
#define SG3_SGDER_TCRE	(SG3.unSGDER.stcField.u1TCRE)  /*@bf@*/
#define SG3_SGDER_NRE	(SG3.unSGDER.stcField.u1NRE)  /*@bf@*/
#define SG3_SGDER_FRE	(SG3.unSGDER.stcField.u1FRE)  /*@bf@*/
#define SG3_SGDER_ARE0	(SG3.unSGDER.stcField.u1ARE0)  /*@bf@*/
#define SG3_SGDER_ARE1	(SG3.unSGDER.stcField.u1ARE1)  /*@bf@*/
#define SG3_SGDER_EFRE	(SG3.unSGDER.stcField.u1EFRE)  /*@bf@*/

#define SG4_SGDER	(SG4.unSGDER.u16Register)  /*@rg@*/
#define SG4_SGDER_PCRE0	(SG4.unSGDER.stcField.u1PCRE0)  /*@bf@*/
#define SG4_SGDER_PCRE1	(SG4.unSGDER.stcField.u1PCRE1)  /*@bf@*/
#define SG4_SGDER_IDRE	(SG4.unSGDER.stcField.u1IDRE)  /*@bf@*/
#define SG4_SGDER_TCRE	(SG4.unSGDER.stcField.u1TCRE)  /*@bf@*/
#define SG4_SGDER_NRE	(SG4.unSGDER.stcField.u1NRE)  /*@bf@*/
#define SG4_SGDER_FRE	(SG4.unSGDER.stcField.u1FRE)  /*@bf@*/
#define SG4_SGDER_ARE0	(SG4.unSGDER.stcField.u1ARE0)  /*@bf@*/
#define SG4_SGDER_ARE1	(SG4.unSGDER.stcField.u1ARE1)  /*@bf@*/
#define SG4_SGDER_EFRE	(SG4.unSGDER.stcField.u1EFRE)  /*@bf@*/

typedef struct stc_sgn_sgder_field{
    uint_io16_t		u1PCRE0:1;
    uint_io16_t		u1PCRE1:1;
    uint_io16_t		u1IDRE:1;
    uint_io16_t		u1TCRE:1;
    uint_io16_t		u1NRE:1;
    uint_io16_t		u1FRE:1;
    uint_io16_t		u1ARE0:1;
    uint_io16_t		u1ARE1:1;
    uint_io16_t		u1EFRE:1;
    uint_io16_t		:7;
}stc_sgn_sgder_field_t;

typedef union un_sgn_sgder{
    uint_io16_t		u16Register;
    stc_sgn_sgder_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_sgn_sgder_t;

/* SGNR */
#define SG0_SGNR	(SG0.unSGNR.u8Register)  /*@rg@*/
#define SG0_SGNR_SGNR	SG0_SGNR  /*@bfrg@*/

#define SG1_SGNR	(SG1.unSGNR.u8Register)  /*@rg@*/
#define SG1_SGNR_SGNR	SG1_SGNR  /*@bfrg@*/

#define SG2_SGNR	(SG2.unSGNR.u8Register)  /*@rg@*/
#define SG2_SGNR_SGNR	SG2_SGNR  /*@bfrg@*/

#define SG3_SGNR	(SG3.unSGNR.u8Register)  /*@rg@*/
#define SG3_SGNR_SGNR	SG3_SGNR  /*@bfrg@*/

#define SG4_SGNR	(SG4.unSGNR.u8Register)  /*@rg@*/
#define SG4_SGNR_SGNR	SG4_SGNR  /*@bfrg@*/

typedef union un_sgn_sgnr{
    uint_io8_t		u8Register;
}un_sgn_sgnr_t;

/* SGFR */
#define SG0_SGFR	(SG0.unSGFR.u8Register)  /*@rg@*/
#define SG0_SGFR_SGFR	SG0_SGFR  /*@bfrg@*/

#define SG1_SGFR	(SG1.unSGFR.u8Register)  /*@rg@*/
#define SG1_SGFR_SGFR	SG1_SGFR  /*@bfrg@*/

#define SG2_SGFR	(SG2.unSGFR.u8Register)  /*@rg@*/
#define SG2_SGFR_SGFR	SG2_SGFR  /*@bfrg@*/

#define SG3_SGFR	(SG3.unSGFR.u8Register)  /*@rg@*/
#define SG3_SGFR_SGFR	SG3_SGFR  /*@bfrg@*/

#define SG4_SGFR	(SG4.unSGFR.u8Register)  /*@rg@*/
#define SG4_SGFR_SGFR	SG4_SGFR  /*@bfrg@*/

typedef union un_sgn_sgfr{
    uint_io8_t		u8Register;
}un_sgn_sgfr_t;

/* SGAR */
#define SG0_SGAR	(SG0.unSGAR.u16Register)  /*@rg@*/
#define SG0_SGAR_SGAR	SG0_SGAR  /*@bfrg@*/

#define SG1_SGAR	(SG1.unSGAR.u16Register)  /*@rg@*/
#define SG1_SGAR_SGAR	SG1_SGAR  /*@bfrg@*/

#define SG2_SGAR	(SG2.unSGAR.u16Register)  /*@rg@*/
#define SG2_SGAR_SGAR	SG2_SGAR  /*@bfrg@*/

#define SG3_SGAR	(SG3.unSGAR.u16Register)  /*@rg@*/
#define SG3_SGAR_SGAR	SG3_SGAR  /*@bfrg@*/

#define SG4_SGAR	(SG4.unSGAR.u16Register)  /*@rg@*/
#define SG4_SGAR_SGAR	SG4_SGAR  /*@bfrg@*/

typedef union un_sgn_sgar{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_sgn_sgar_t;

/* SGPCR */
#define SG0_SGPCR	(SG0.unSGPCR.u16Register)  /*@rg@*/
#define SG0_SGPCR_SGPCR	SG0_SGPCR  /*@bfrg@*/

#define SG1_SGPCR	(SG1.unSGPCR.u16Register)  /*@rg@*/
#define SG1_SGPCR_SGPCR	SG1_SGPCR  /*@bfrg@*/

#define SG2_SGPCR	(SG2.unSGPCR.u16Register)  /*@rg@*/
#define SG2_SGPCR_SGPCR	SG2_SGPCR  /*@bfrg@*/

#define SG3_SGPCR	(SG3.unSGPCR.u16Register)  /*@rg@*/
#define SG3_SGPCR_SGPCR	SG3_SGPCR  /*@bfrg@*/

#define SG4_SGPCR	(SG4.unSGPCR.u16Register)  /*@rg@*/
#define SG4_SGPCR_SGPCR	SG4_SGPCR  /*@bfrg@*/

typedef union un_sgn_sgpcr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_sgn_sgpcr_t;

/* SGIDR */
#define SG0_SGIDR	(SG0.unSGIDR.u8Register)  /*@rg@*/
#define SG0_SGIDR_SGIDR	SG0_SGIDR  /*@bfrg@*/

#define SG1_SGIDR	(SG1.unSGIDR.u8Register)  /*@rg@*/
#define SG1_SGIDR_SGIDR	SG1_SGIDR  /*@bfrg@*/

#define SG2_SGIDR	(SG2.unSGIDR.u8Register)  /*@rg@*/
#define SG2_SGIDR_SGIDR	SG2_SGIDR  /*@bfrg@*/

#define SG3_SGIDR	(SG3.unSGIDR.u8Register)  /*@rg@*/
#define SG3_SGIDR_SGIDR	SG3_SGIDR  /*@bfrg@*/

#define SG4_SGIDR	(SG4.unSGIDR.u8Register)  /*@rg@*/
#define SG4_SGIDR_SGIDR	SG4_SGIDR  /*@bfrg@*/

typedef union un_sgn_sgidr{
    uint_io8_t		u8Register;
}un_sgn_sgidr_t;

/* SGTCR */
#define SG0_SGTCR	(SG0.unSGTCR.u8Register)  /*@rg@*/
#define SG0_SGTCR_SGTCR	SG0_SGTCR  /*@bfrg@*/

#define SG1_SGTCR	(SG1.unSGTCR.u8Register)  /*@rg@*/
#define SG1_SGTCR_SGTCR	SG1_SGTCR  /*@bfrg@*/

#define SG2_SGTCR	(SG2.unSGTCR.u8Register)  /*@rg@*/
#define SG2_SGTCR_SGTCR	SG2_SGTCR  /*@bfrg@*/

#define SG3_SGTCR	(SG3.unSGTCR.u8Register)  /*@rg@*/
#define SG3_SGTCR_SGTCR	SG3_SGTCR  /*@bfrg@*/

#define SG4_SGTCR	(SG4.unSGTCR.u8Register)  /*@rg@*/
#define SG4_SGTCR_SGTCR	SG4_SGTCR  /*@bfrg@*/

typedef union un_sgn_sgtcr{
    uint_io8_t		u8Register;
}un_sgn_sgtcr_t;

/* SGEFR */
#define SG0_SGEFR	(SG0.unSGEFR.u8Register)  /*@rg@*/
#define SG0_SGEFR_SGEFR	SG0_SGEFR  /*@bfrg@*/

#define SG1_SGEFR	(SG1.unSGEFR.u8Register)  /*@rg@*/
#define SG1_SGEFR_SGEFR	SG1_SGEFR  /*@bfrg@*/

#define SG2_SGEFR	(SG2.unSGEFR.u8Register)  /*@rg@*/
#define SG2_SGEFR_SGEFR	SG2_SGEFR  /*@bfrg@*/

#define SG3_SGEFR	(SG3.unSGEFR.u8Register)  /*@rg@*/
#define SG3_SGEFR_SGEFR	SG3_SGEFR  /*@bfrg@*/

#define SG4_SGEFR	(SG4.unSGEFR.u8Register)  /*@rg@*/
#define SG4_SGEFR_SGEFR	SG4_SGEFR  /*@bfrg@*/

typedef union un_sgn_sgefr{
    uint_io8_t		u8Register;
}un_sgn_sgefr_t;

/* SGDMAR */
#define SG0_SGDMAR	(SG0.unSGDMAR.u32Register)  /*@rg@*/
#define SG0_SGDMAR_SGDMAR	SG0_SGDMAR  /*@bfrg@*/

#define SG1_SGDMAR	(SG1.unSGDMAR.u32Register)  /*@rg@*/
#define SG1_SGDMAR_SGDMAR	SG1_SGDMAR  /*@bfrg@*/

#define SG2_SGDMAR	(SG2.unSGDMAR.u32Register)  /*@rg@*/
#define SG2_SGDMAR_SGDMAR	SG2_SGDMAR  /*@bfrg@*/

#define SG3_SGDMAR	(SG3.unSGDMAR.u32Register)  /*@rg@*/
#define SG3_SGDMAR_SGDMAR	SG3_SGDMAR  /*@bfrg@*/

#define SG4_SGDMAR	(SG4.unSGDMAR.u32Register)  /*@rg@*/
#define SG4_SGDMAR_SGDMAR	SG4_SGDMAR  /*@bfrg@*/

typedef union un_sgn_sgdmar{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_sgn_sgdmar_t;

/* SGCCR */
#define SG0_SGCCR	(SG0.unSGCCR.u16Register)  /*@rg@*/
#define SG0_SGCCR_INTC	(SG0.unSGCCR.stcField.u1INTC)  /*@bf@*/

#define SG1_SGCCR	(SG1.unSGCCR.u16Register)  /*@rg@*/
#define SG1_SGCCR_INTC	(SG1.unSGCCR.stcField.u1INTC)  /*@bf@*/

#define SG2_SGCCR	(SG2.unSGCCR.u16Register)  /*@rg@*/
#define SG2_SGCCR_INTC	(SG2.unSGCCR.stcField.u1INTC)  /*@bf@*/

#define SG3_SGCCR	(SG3.unSGCCR.u16Register)  /*@rg@*/
#define SG3_SGCCR_INTC	(SG3.unSGCCR.stcField.u1INTC)  /*@bf@*/

#define SG4_SGCCR	(SG4.unSGCCR.u16Register)  /*@rg@*/
#define SG4_SGCCR_INTC	(SG4.unSGCCR.stcField.u1INTC)  /*@bf@*/

typedef struct stc_sgn_sgccr_field{
    uint_io16_t		:1;
    uint_io16_t		u1INTC:1;
    uint_io16_t		:14;
}stc_sgn_sgccr_field_t;

typedef union un_sgn_sgccr{
    uint_io16_t		u16Register;
    stc_sgn_sgccr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_sgn_sgccr_t;


typedef struct stc_sgn{
    un_sgn_sgcr_t	unSGCR;	/* 0x00000000 */
    un_sgn_sgder_t	unSGDER;	/* 0x00000002 */
    un_sgn_sgnr_t	unSGNR;	/* 0x00000004 */
    un_sgn_sgfr_t	unSGFR;	/* 0x00000005 */
    un_sgn_sgar_t	unSGAR;	/* 0x00000006 */
    un_sgn_sgpcr_t	unSGPCR;	/* 0x00000008 */
    un_sgn_sgidr_t	unSGIDR;	/* 0x0000000A */
    un_sgn_sgtcr_t	unSGTCR;	/* 0x0000000B */
    un_sgn_sgefr_t	unSGEFR;	/* 0x0000000C */
    uint_io8_t	au8Reserved0[3];	/* 0x0000000D */
    un_sgn_sgdmar_t	unSGDMAR;	/* 0x00000010 */
    un_sgn_sgccr_t	unSGCCR;	/* 0x00000014 */
    uint_io8_t	au8Reserved1[1002];	/* 0x00000016 */
}stc_sgn_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_sgn_t	stcSG[5];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_SG_H */
