
#ifndef API_EE_H_
    #define API_EE_H_


    typedef struct
    {
        unsigned int        ODO;
        unsigned char       Reserved[10];
        unsigned char       Checkflag;
        unsigned char       CRC_8;
    }_Register;

    typedef struct
    {
        unsigned char       PAGE_ID;
        unsigned char       ODO_START;
        unsigned char       ODO_END;
        unsigned char       ODO_BAK;
        unsigned int        ODO_MAX_LIMIT;
        unsigned int        ODO_STEP;
    }_ODO_Infomation;
    
    typedef struct
    {
        unsigned short      CurAddr;
    }_odoAddr;

    extern             _Register                  reg_odo;
    extern             _ODO_Infomation            odoInfo;
    
    extern        void         api_ODO_StoreInfo_Init(void);
    
    extern        void         api_ClearODOArea(unsigned char* ClearState);
    
    extern        void         api_WriteODO(unsigned char* str);
    extern        void         api_ReadODO(unsigned char* reg);
    extern        void         ClearODODog(void);
    extern        void         ODO_NOP(void);
    
    extern        void                   pIIC_WritePage(unsigned char  pageID,unsigned char  addr, unsigned char *Data,unsigned char len);
    extern        unsigned char          pIIC_SequentialRead(unsigned char  pageID,unsigned char  addr, unsigned char *Data,unsigned char len);
      
        
    
#endif /* API_EE_H_ */

