#ifndef _UDS_PARAMETER_H_
#define _UDS_PARAMETER_H_      

#include <string.h>
#include "UDS_Common.h"
#include "uds_service.h"
#include "MM_Can_TP.h"
//#include "Graphics_NAVI.h"

static const UDS_ServiceType UDS_ServiceTable[] =
{
    {SID_DIAGNOSTIC_SESSION_CONTROL,         UdsAllSession,                          UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_SessionControlFunc, UDS_SetResp_0x10},//10
    {SID_STOP_DIAGNOSITC_SESSION,            UdsAllSession,                          UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_StopDiagnositcSessionFunc, UDS_SetResp_0x20},//20
    {SID_ECU_RESET,                          UdsAllSession,                          UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_EcuResetFunc, UDS_SetResp_0x11},//11
    {SID_SECURITY_ACCESS,                    UdsProgramSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_SecurityAccessFunc, UDS_SetResp_0x27},//27
    {SID_COMMUNICATION_CONTROL,              UdsProgramSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_CommunicationControlFunc, UDS_SetResp_0x28},//28
    {SID_ENABLE_NORMAL_MESSAGE_TRANSMISSION, UdsProgramSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_EnableNormalMessageTransmissionFunc, UDS_SetResp_0x29},//29
    {SID_TESTER_PRESENT,                     UdsAllSession,                          UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_TesterPresentFunc, NULL},//3e    nonsupport resp
    {SID_CONTROL_DTC_SETTING,                UdsProgramSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_ControlDtcSettingFunc, UDS_SetResp_0x85},//85
    {SID_CLEAR_DIAGNOSTIC_INFORMATION,       UdsDefaultSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_ClearDiagnosticInformation, UDS_SetResp_0x14},//14
    {SID_READ_DTC_INFORMATION,               UdsDefaultSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_ReadDtcInformation, UDS_SetResp_0x19},//19
    {SID_READ_DATA_BY_IDENTIFIER,            UdsDefaultSession | UdsExtendedSession, UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_ReadDIDFunc, NULL},//22  nonsupport resp
    {SID_WRITE_DATA_BY_IDENTIFIER,           UdsAllSession,                          UdsSecurityLevel1,  UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_WriteDIDFunc, NULL},//2e  nonsupport resp
    {SID_INPUT_OUTPUT_CONTROL_BY_IDENTIFIER, UdsExtendedSession,                     UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_InputOutputControlByIdentifierFunc, NULL},//2f  nonsupport resp
    {SID_ROUTINE_CONTROL,                    UdsAllSession,                          UdsUnSecurityLevel, UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_RoutineControlFunc, NULL},//31  nonsupport resp
    {SID_REQUEST_DOWNLOAD,                   UdsProgramSession,                      UdsSecurityLevel1,  UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_RequestDownload, UDS_SetResp_0x34},//34
    {SID_TRANSFER_DATA,                      UdsProgramSession,                      UdsSecurityLevel1,  UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_TransferData, UDS_SetResp_0x36},//36
    {SID_REQUEST_TRANSFER_EXIT,              UdsProgramSession,                      UdsSecurityLevel1,  UdsFuncOrPhyValidPhy | UdsFuncOrPhyValidFunc, UDS_RequestTransferExit, UDS_SetResp_0x37}//37
    //{SID_READ_STATUS_OF_DTC,                 UdsDefaultSession | UdsExtendedSession, UdsUnSecurityLevel, }//17
    //{SID_READ_DTC_BY_STATUS,                 UdsDefaultSession | UdsExtendedSession, UdsUnSecurityLevel, }//18
    //{SID_READ_ECU_ID,                        UdsAllSession,                          UdsUnSecurityLevel, }//1a
    //{SID_INPUT_OUTPUT_CONTROL_BY_LOCAL_ID,   UdsExtendedSession,                     UdsUnSecurityLevel, }//30
};

static const UDS_DIDType UDS_ReadDIDTable[] =
{
    {0xF180, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F180},  //Boot Software Identification Data Identifier
    {0xF181, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F181},  //Application Software Identification Data Identifier
    {0xF182, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F182},  //Application DataIdentification Data Identifier
    {0xF183, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F183},  //Boot Software Fingerprint Data Identifier
    {0xF184, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F184},  //Application Software Fingerprint Data Identifier
    {0xF185, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F185},  //Application DataFingerprint Data Identifier
    {0xF186, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F186},  //Active Diagnostic Session Data Identifier     //test
    {0xF187, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F187},  //Vehicle Manufacturer SparePart Number Data Identifier
    {0xF188, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F188},  //Vehicle Manufacturer ECU Software Number Data Identifier
    {0xF189, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F189},  //Vehicle Manufacturer ECU Software Version Number Data Identifier
    {0xF18A, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F18A},  //System Supplier Identifier Data Identifier
    {0xF18B, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F18B},  //ECU Manufacturing Date Data Identifier
    {0xF18C, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F18C},  //ECU Serial Number Data Identifier
    {0xF18D, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F18D},  //Supported Functional Units Data Identifier
    {0xF18E, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F18E},  //Vehicle Manufacturer Kit Assembly Part Number Data Identifier
    {0xF190, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F190},  //VIN Data Identifier   //test
    {0xF191, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F191},  //Vehicle Manufacturer ECU Hardware Number Data Identifier
    {0xF192, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F192},  //System Supplier ECU Hardware Number Data Identifier
    {0xF193, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F193},  //System Supplier ECU Hardware VersionNumber Data Identifier
    {0xF194, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F194},  //System Supplier ECU Software Number Data Identifier
    {0xF195, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F195},  //System Supplier ECU Software Version Number Data Identifier
    {0xF196, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F196},  //Exhaust Regulation Or Type Approval Number Data Identifier
    {0xF197, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F197},  //System Name Or Engine Type Data Identifier
    {0xF198, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F198},  //Repair Shop Code Or Tester Serial Number Data Identifier
    {0xF199, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F199},  //Programming Date Data Identifier
    {0xF19A, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F19A},  //Calibration Repair Shop Code Or Calibration Equipment Serial Number Data Identifier
    {0xF19B, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F19B},  //Calibration Date Data Identifier
    {0xF19C, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F19C},  //Calibration Equipment Software Number Data Identifier
    {0xF19D, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F19D},  //ECU Installation Date Data Identifier
    {0xF19E, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F19E},  //ODX File Data Identifier
    {0xF19F, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F19F},  //Entity Data Identifier
    {0xF1A0, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F1A0},  //Software Version for HKMC Vehicle Manufacture Data Identifier
    {0xF100, UdsAllSession, UdsUnSecurityLevel, UdsRDID_F100},  //Software Version for HKMC Vehicle Manufacture Data Identifier
    {0xB001, UdsAllSession, UdsUnSecurityLevel, UdsRDID_B001},  
    {0xB002, UdsAllSession, UdsUnSecurityLevel, UdsRDID_B002},  
    {0xB003, UdsAllSession, UdsUnSecurityLevel, UdsRDID_B003},  
    {0x0060, UdsAllSession, UdsUnSecurityLevel, UdsRDID_0060},
    {0x0070, UdsAllSession, UdsUnSecurityLevel, UdsRDID_0070},  
    {0x0072, UdsAllSession, UdsUnSecurityLevel, UdsRDID_0072},  
    {0x0073, UdsAllSession, UdsUnSecurityLevel, UdsRDID_0073},  
};

static const UDS_DIDType UDS_WriteDIDTable[] =
{
    //{0xF190, UdsAllSession, UdsSecurityLevel1, UdsWDID_F190},   //test
    {0x0060, UdsAllSession, UdsSecurityLevel1, UdsWDID_0060},
    {0x0070, UdsAllSession, UdsSecurityLevel1, UdsWDID_0070},
    {0x0071, UdsAllSession, UdsSecurityLevel1, UdsWDID_0071},
    {0x0072, UdsAllSession, UdsSecurityLevel1, UdsWDID_0072},
    {0x0073, UdsAllSession, UdsSecurityLevel1, UdsWDID_0073},
};

static const UDS_RCType UDS_RoutineContrlTable[] =
{
    {0xFF00, UdsProgramSession, UdsSecurityLevel1, UdsStartRC_FF00, UdsStopRC_FF00, UdsRequestResultRC_FF00},
    {0xFF01, UdsProgramSession, UdsSecurityLevel1, UdsStartRC_FF01, UdsStopRC_FF01, UdsRequestResultRC_FF01}
};

static const UDS_IOCTLType UDS_InputOutputControlByIdentifierDIDTable[] =
{
    {0xB000, UdsAllSession, UdsUnSecurityLevel, UdsIOCtlDID_B000},
    {0xB001, UdsAllSession, UdsUnSecurityLevel, UdsIOCtlDID_B001},
    {0xB002, UdsAllSession, UdsUnSecurityLevel, UdsIOCtlDID_B002},
};

#endif
