#ifndef API_ADC_H_
#define API_ADC_H_

#include "common_include.h"

extern uint8_t CurIgnSt;
extern uint8_t LastCurIgnSt; 
extern uint16_t ThermistorValue;
extern volatile uint32_t AdcTimerCnts;

#define     KL15_AD_CH               24
#define     KL30_AD_CH               27
#define     KL5V_AD_CH               18
#define     Quiescent_Current        14
#define     ADC_FUEL_SAMPLE_CHANNEL  02
#define     TRIP_SW1_AD_CH           17
#define     TRIP_SW2_AD_CH           16

#define     DMS_DOWN_AD_CH           44
#define     AIR_BAG_AD_CH            25
#define     NTC_AD_CH                32
#define     KL5V_GEAR_AD_CH          13
#define     KL5V_N_AD_CH             12

enum {
    ABNORMAL_POWER_CONDITION_NORMAL,
    ABNORMAL_POWER_CONDITION_UNDER,
    ABNORMAL_POWER_CONDITION_OVER,
};
extern uint8_t AbnormalPowerCondition;

enum {
    EVENT_IGN_OFF,
    EVENT_IGN_ON,
    EVENT_BAT_ON,
};

enum {
    TRIP_SW1_PADD_DN,
    TRIP_SW1_MENU,
    TRIP_SW1_UP,
    TRIP_SW1_DOWN,
    TRIP_SW1_OK,
    TRIP_SW1_LFA,
    TRIP_SW1_TOTAL,
};

enum {
    TRIP_SW1_CUR_PADD_DN = 1,
    TRIP_SW1_CUR_MENU,
    TRIP_SW1_CUR_MENU_LONG,
    TRIP_SW1_CUR_UP,
    TRIP_SW1_CUR_DOWN,
    TRIP_SW1_CUR_OK,
    TRIP_SW1_CUR_OK_LONG,
    TRIP_SW1_CUR_OK_LONG_3S,
    TRIP_SW1_CUR_LFA,
};

enum {
    TRIP_SW2_PADD_UP,
    TRIP_SW2_CANCEL,
    TRIP_SW2_SET_MINUS,
    TRIP_SW2_RES_PLUS,
    TRIP_SW2_CRUISE_ON_OR_OFF,
    TRIP_SW2_CRUISE_SLD,
    TRIP_SW2_VEHICLE_DISTANCE,
    TRIP_SW2_TOTAL,
};

enum {
    TRIP_SW2_CUR_PADD_UP = 1,
    TRIP_SW2_CUR_CANCEL,
    TRIP_SW2_CUR_SET_MINUS,
    TRIP_SW2_CUR_RES_PLUS,
    TRIP_SW2_CUR_CRUISE_ON_OR_OFF,
    TRIP_SW2_CUR_CRUISE_SLD,
    TRIP_SW2_SCC_VEHICLE_DISTANCE,
};

#define GRIB_CONTROL_SW_AD_CH 34
enum {
    GRIB_UP_CONTROL_SW,
    GRIB_DOWN_CONTROL_SW,
    GRIB_CONTROL_SW_TOTAL,
};

enum {
    GRIB_CONTROL_SW_CUR_DMS_UP = 1,
    GRIB_CONTROL_SW_CUR_DMS_DOWN,
};


typedef struct {
    uint16_t DisplayVehicleSpeed;
    uint16_t CalcODOVehicleSpeed;
    uint16_t RPM;
    uint8_t ISGIsActive;
    uint32_t DA_DAW_Timer;
    uint8_t StartUpActive;
    uint8_t HardLineOilPressLv;
    uint8_t HardLineOilPressCnt;
    uint8_t HardLineUsbStateCnt;
    uint8_t HardLineUsbStateLv;
    uint8_t HardLineAltibitLv;
    uint8_t HardLineAltibitCnt;
}INTPUT_OUTPUT_SETS;


typedef struct {
    uint32_t CurFuelR;
    uint32_t TripSW1R;
    uint8_t AirBagV;
    uint8_t TripSW1Val;
    uint16_t TripSW1Cnt[TRIP_SW1_TOTAL];
    uint8_t TripSW1Exec[TRIP_SW1_TOTAL];
    uint32_t TripSW2R;
    uint8_t TripSW2Val;
    uint16_t TripSW2Cnt[TRIP_SW2_TOTAL];
    uint8_t TripSW2Exec[TRIP_SW2_TOTAL];
    uint8_t GribControlSwVal;
    uint16_t GribControlSwCnt[GRIB_CONTROL_SW_TOTAL];
    uint8_t GribControlSwExec[GRIB_CONTROL_SW_TOTAL];
}ADC_PARA;

extern ADC_PARA AdcPara;


enum {
    KEY_MENU = 1,
    KEY_UP,
    KEY_DOWN,
    KEY_OK,
};

typedef struct {
    uint8_t    keyState;
    uint8_t    OldkeyState;
    uint8_t    keyPushPValid;
    uint8_t    keyPushNValid;
    uint8_t    keyPushPTime;
    uint8_t    keyPushPKeepTime;
    uint8_t    keyPushNTime;
    uint8_t    keyPushNKeepTime;
    uint16_t   SpeedPWMCycle;
    uint16_t   SpeedPWMDuty;
    uint16_t   SpeedPWMDutyOld;
    uint8_t    BuzzerEn;
}_KEY;

extern uint8_t SaveODOValid;
extern uint8_t SaveAFCValid;
extern uint8_t SaveMiscValid;
extern uint8_t SaveServiceRemainderValid;
extern uint32_t ServiceRemainderTimer;
extern uint16_t CurIgnVoltage;
extern uint16_t CurBatteryVoltage;

extern uint16_t CurIgnVoltage;

extern uint16_t CanTimeoutTimerDelta;

extern volatile uint32_t IgnOnKeepSeconds;
extern volatile uint32_t IgnOffKeepSeconds;
extern volatile uint32_t IgnKeepTimerCnts;

//extern INTPUT_OUTPUT_SETS InputOutputSingal;
extern void ADCInit(void);
extern void GetADCVolue(void);
extern void InputSingalHardLine(void);
extern uint16_t Calculate_Thermistor(uint16_t AdValue); /*qitiancun 2018-9-10*/
#endif /* API_ADC_H_ */
