    #ifndef _LCD_BUS_INTERFACE_H_
    #define _LCD_BUS_INTERFACE_H_
    
    #include "common_include.h"
    
    /*******************************************************************************
    
    *******************************************************************************/
    //ӳ
    #define   LCD_BUS_DELAY_1ms_INTERVAL        255
    
    
    /*** ڲ ***/
    #define   LCD_BUS_CMD_NOP                   ((uint32_t)0x00000000)
    #define   LCD_BUS_CMD_IR_SET                ((uint32_t)0x10000000)
    #define   LCD_BUS_CMD_IR_GET                ((uint32_t)0x11000000)
    #define   LCD_BUS_CMD_DR_SET                ((uint32_t)0x12000000)
    #define   LCD_BUS_CMD_DR_GET                ((uint32_t)0x13000000)
    #define   LCD_BUS_CMD_DUMMY_GET             ((uint32_t)0x14000000)
    #define   LCD_BUS_CMD_WAIT_TE               ((uint32_t)0x15000000)
    #define   LCD_BUS_CMD_WAIT_IF               ((uint32_t)0x16000000)
    #define   LCD_BUS_CMD_SET_RESET             ((uint32_t)0x1F000000)
    #define   LCD_BUS_CMD_SEND_IRQ              ((uint32_t)0x20000000)
    #define   LCD_BUS_CMD_WAIT_ACK              ((uint32_t)0x21000000)
    #define   LCD_BUS_CMD_IRIS_KICK             ((uint32_t)0x40000000)
    #define   LCD_BUS_CMD_WAIT_CMD              ((uint32_t)0x41000000)
    #define   LCD_BUS_CMD_IRIS_FRAME            ((uint32_t)0x42000000)
    #define   LCD_BUS_CMD_WR_PIXEL              ((uint32_t)0x80000000)
    #define   LCD_BUS_CMD_CLUT_CFG              ((uint32_t)0xC0000000)
    #define   LCD_BUS_CMD_END                   ((uint32_t)0xFF000000)
    
    
    
    
    extern  volatile INT8U     UP_VSYNC;
    extern  volatile INT32U    UpScreenTime;
    extern  volatile INT8U     UpScreenStep;
    extern  volatile INT8U     LcdBusState;
    
    void   LCD_BUS_Init(void);
    
    void   LCD_BUS_Panel_Reset_Ctrl(uint8_t Level);
    void   LCD_BUS_Write_Cmd(uint8_t Cmd, uint8_t *pPara, uint8_t ParaLen);
    
    uint8_t  LCD_BUS_Get_Status(void);
    void    LCD_BUS_Write_Bus_Cmd(uint32_t Opcode, uint8_t Para);
    void    LCD_BUS_Write_Bus_Fifo(uint32_t Data);
    void    VsyncDetectionInit(void);
    
    static void   VsyncDetectCallBack(uint8_t channel);
    __irq __arm  void   LcdBus_InstrFifo_isr(void);
    extern void LcdBus_Check(void);
    
    #endif
