#include "common_include.h"
#include "app_tft_TripC.h"

uint8_t InstantFuel = 0;
#pragma location="BACKUP_RAM_CONTENT"
TRIP_C_STRUCT TripCPara;
uint8_t SaveODOValid = 0;
uint8_t SaveAFCValid = 0;
uint8_t SaveServiceRemainderValid = 0;

#pragma location="BACKUP_RAM_CONTENT"
SOFTWARE_VARIANT_CODING_STRUCT SoftwareVariantCoding;
#pragma location="BACKUP_RAM_CONTENT"
EOL_STRUCT EolStruct;

const INT8U _Bottom_Theme1_Pointer02_X291_Y26_R[] = {
0XC8,0X00,0X16,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0X90,0XB0,0XB0,0XB0,0XB0,
0XB0,0XB0,0XD0,0XF0,0XF0,0XF0,0XF4,0XF4,0XF7,0XC1,0X10,0X00,0X00,0X00,0X00,0X00,
0X10,0XF1,0XB0,0X00,0X00,0X00,0X00,0X00,0X11,0XE6,0XD4,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0XB6,0XF7,0X00,0X00,0X00,0X00,0X00,0X20,0XF7,0XE6,0X01,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X50,0XF4,0XC1,0X30,0X00,0XB0,0XB0,0XB0,0XB0,
0XB0,0XB0,0X80,0X00,0X00,0X00,0X00,0XF7,0X74,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X08,0X0B,0X0B,0X0B,0X5B,0XFE,0XBC,0X17,0X07,0X07,0X16,0X54,0X04,
0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XD7,0XDF,0X06,0X00,0X00,0XF0,0XF0,0XF0,
0XF0,0XF7,0XFF,0XF4,0XF0,0XF0,0XF0,0XB0,0X00,0X00,0X00,0X00,0X00,0XBB,0XFF,0X00,
0X00,0X00,0X00,0X70,0XFB,0X8F,0X6F,0XF9,0XC1,0X10,0X00,0X00,0X00,0X00,0X00,0X01,
0X09,0X7F,0X9E,0X01,0XFF,0X7B,0X07,0X07,0X07,0XBD,0XBB,0X00,0XFB,0XB8,0X00,0XFF,
0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X70,0XF4,0XEE,
0X3D,0X01,0X00,0X60,0XE3,0XEE,0X3E,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0XE7,
0XBF,0X06,0X10,0XD4,0XE4,0X17,0X07,0X17,0XD9,0XD7,0X17,0X17,0X77,0X17,0X07,0X06,
0X00,0X00,0X33,0XBB,0XBB,0XEE,0XFF,0XBB,0XBB,0X63,0XE5,0XEF,0X2C,0X01,0X00,0X07,
0X6F,0XFD,0XF3,0X70,0X10,0X00,0X00,0X10,0X30,0X00,0X00,0X00,0XFF,0X77,0X76,0XFB,
0X00,0XBB,0XBB,0X00,0XFF,0XBB,0X00,0XFF,0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X42,0XFB,0XFF,0XFE,0XC9,0XD7,0XF8,0XFC,0XAF,0X1C,0X02,0X70,0X90,
0X00,0X00,0X00,0X00,0X00,0X00,0XFC,0XFF,0XD8,0XD7,0XFA,0XCF,0X07,0X00,0X60,0XF9,
0X9F,0X07,0X00,0X03,0X6E,0XFC,0X81,0X00,0X00,0X00,0X00,0X00,0X30,0XFD,0XFF,0X30,
0X75,0XEE,0X3E,0XB8,0XF7,0XF7,0XF7,0XF7,0XF7,0X77,0X1E,0X9F,0X18,0X00,0X00,0X49,
0XEF,0XF8,0XB0,0X00,0XFF,0X77,0X77,0XFF,0X00,0XBB,0XBB,0X00,0XFF,0XBB,0X00,0XFF,
0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X14,0X70,0XE1,0XF8,
0X9F,0X1E,0X07,0X00,0X00,0X01,0X5C,0XEF,0XF7,0X60,0X00,0X00,0X00,0X00,0X00,0X00,
0XB1,0XFD,0X6E,0X03,0X00,0XF6,0XFF,0XFA,0XF4,0XF4,0XF5,0XF7,0XD7,0X9F,0XEF,0XD4,
0X00,0X00,0X00,0X00,0XD8,0XFF,0XFF,0XDE,0XE3,0X23,0X70,0X40,0X30,0XC0,0X60,0X00,
0X00,0X70,0XB0,0X30,0X00,0X00,0X00,0X00,0X01,0X0C,0X05,0X00,0XFF,0X77,0X77,0XFF,
0X00,0XBB,0XBB,0X00,0XFF,0XBB,0X00,0XFF,0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X77,0XFE,0XFF,0XFF,0XFC,0XBB,0XBB,0XFB,0XDE,0X7F,0X4F,0X4F,0X1F,
0X5F,0XFE,0XC3,0X00,0X00,0X00,0X90,0XF9,0XAF,0X76,0XA0,0XC0,0XA0,0X06,0X07,0X79,
0XFF,0X47,0X45,0XFF,0X77,0X00,0X07,0X05,0X00,0X00,0X10,0XD6,0XCF,0XBE,0XFF,0X03,
0X08,0X00,0XAF,0XFA,0X00,0XAE,0XFA,0X00,0X10,0XFA,0XCF,0X02,0X00,0X00,0X00,0X00,
0X00,0XC7,0XE7,0X00,0XFF,0X77,0XB8,0XCF,0X00,0XBB,0XBB,0X00,0XFF,0XBB,0X00,0XFF,
0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X50,0XE3,0X80,
0X00,0X00,0XFF,0XBB,0X00,0X50,0XF2,0XA0,0X10,0X0A,0X06,0X00,0X00,0X00,0X4E,0X4F,
0X2F,0X0F,0X0B,0X08,0X05,0X00,0X00,0XD9,0XCF,0X00,0X44,0XFF,0X77,0X00,0X00,0X00,
0X00,0X00,0X38,0XAF,0X05,0XBB,0XFF,0X00,0X00,0X00,0X47,0XFF,0X74,0X47,0XFF,0X54,
0XB6,0XEF,0X16,0X00,0X00,0X00,0X00,0X00,0X82,0XFF,0X59,0X00,0X7F,0X77,0XFE,0X7B,
0X00,0X6B,0X6B,0X00,0XFF,0XBB,0X00,0XFF,0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X40,0XC0,0XF7,0XCF,0X3E,0X03,0X00,0X00,0XFF,0XBB,0X00,0X00,0X09,0X9F,
0XFC,0X91,0X00,0X00,0X00,0X00,0X70,0X90,0XC0,0XF0,0XF4,0XF7,0XA7,0X10,0XD6,0XEF,
0X17,0X00,0X44,0XFF,0X77,0X00,0X42,0XF8,0X61,0X00,0X00,0X00,0X00,0XBB,0XFF,0X00,
0X00,0X00,0X04,0X0B,0X04,0X01,0X00,0X92,0XFF,0X29,0X00,0X00,0X00,0X00,0X00,0X71,
0XFE,0X7D,0X00,0X00,0X40,0XF9,0XBF,0X54,0XEB,0XE2,0X60,0X00,0X04,0X03,0X00,0XFF,
0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X02,0X6E,0X3F,0X08,0X01,0X00,0X73,
0XF4,0XF4,0XFF,0XAB,0X00,0X00,0X00,0X00,0X1B,0X9F,0X27,0X00,0X00,0X00,0X1A,0X0F,
0X0B,0X08,0X05,0X00,0X61,0XFC,0X9F,0X05,0X00,0X00,0X04,0XBF,0XFC,0XF7,0XFB,0XAF,
0X04,0X00,0X00,0X00,0X00,0XBB,0XFF,0X00,0X6B,0X7F,0X7F,0X7F,0X7F,0X7F,0X7F,0X7F,
0X7F,0X7F,0X7F,0X7F,0X24,0X00,0X31,0XCE,0X7E,0X01,0X10,0XD3,0XEE,0X3E,0X02,0X00,
0X02,0X1C,0X8F,0X04,0X00,0XD2,0XF0,0XFF,0X77,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X07,0X07,0X07,0X01,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X04,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X06,0X07,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,
0X01,0X00,0X00,0X05,0X03,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X06,0X07,0X07,
0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
};

void CalcODO(void)
{
    TripCPara.TotalODOTemp += InputOutputSingal.CalcODOVehicleSpeed * 10 / 18;  //20ms cycle
    if (TripCPara.TotalODOTemp > 10000) {
        TripCPara.TotalODOTemp -= 10000;
        TripCPara.TotalODO += 10;
        if ((TripCPara.TotalODO % 1000) == 0) {
            SaveODOValid = 1;
            SaveAFCValid = 1;
            if (ServicePara.ServiceValid & SERVICE_REMAINDER_VALID_KM) 
            {
                ServicePara.RemainKm -= 1;
            }
            if (ServicePara.ServiceValid & SERVICE_REMAINDER_VALID_KM) 
            {
                SaveServiceRemainderValid = 1;
            }
        }
        if (TripCPara.TotalODO > 1599999999) {      //1,599,999km999m
            TripCPara.TotalODO = 1599999999;
        }
        TripCPara.AccumulatedInfoODO += 10;
        if (TripCPara.AccumulatedInfoODO > 9999999) {  //9,999km999m
            TripCPara.AccumulatedInfoODO -= 9999999;
        }
        TripCPara.DriveInfoODO += 10;
        if (TripCPara.DriveInfoODO > 9999999) {  //9,999km999m
            TripCPara.DriveInfoODO -= 9999999;
        }
    }
}

uint16_t CalcIFC(void)
{
    uint16_t speed = 0;
    uint32_t Recent600msODO = 0;
    uint32_t Recent600msFCO = 0;
    for (uint8_t i = 0; i < 30; i++) {
        if (((TripCPara.Recent600msSpeed[i][0] == 0) || (TripCPara.Recent600msSpeed[i][0] == 0x3fff)) 
            && ((TripCPara.Recent600msSpeed[i][1] == 0) || (TripCPara.Recent600msSpeed[i][1] == 0x3fff)) 
            && ((TripCPara.Recent600msSpeed[i][2] == 0) || (TripCPara.Recent600msSpeed[i][2] == 0x3fff)) 
            && ((TripCPara.Recent600msSpeed[i][3] == 0) || (TripCPara.Recent600msSpeed[i][3] == 0x3fff))) {
            speed = 0;
        } else {
            uint8_t n = 0;
            uint16_t tmp = 0;
            if ((TripCPara.Recent600msSpeed[i][0] != 0) && (TripCPara.Recent600msSpeed[i][0] != 0x3fff)) {
                n++;
                tmp += TripCPara.Recent600msSpeed[i][0];
            }
            if ((TripCPara.Recent600msSpeed[i][1] != 0) && (TripCPara.Recent600msSpeed[i][1] != 0x3fff)) {
                n++;
                tmp += TripCPara.Recent600msSpeed[i][1];
            }
            if ((TripCPara.Recent600msSpeed[i][2] != 0) && (TripCPara.Recent600msSpeed[i][2] != 0x3fff)) {
                n++;
                tmp += TripCPara.Recent600msSpeed[i][2];
            }
            if ((TripCPara.Recent600msSpeed[i][3] != 0) && (TripCPara.Recent600msSpeed[i][3] != 0x3fff)) {
                n++;
                tmp += TripCPara.Recent600msSpeed[i][3];
            }
            speed = (tmp * 10 / n / 32);
            if (speed > 2500) {
                speed = 2500;
            }
            Recent600msODO += speed;
        }
    }
    Recent600msODO = Recent600msODO * 60 / 3600 / 3;   // recent 600ms odo, unit:0.1m
    
    for (uint8_t i = 0; i < 60; i++) {
        Recent600msFCO += TripCPara.Recent600msFCO[i];
    }
    Recent600msFCO = Recent600msFCO * 128 / 100;
    if (UsmSelfPara.Language == ENGLISH) {
        return Recent600msODO * 10000 / Recent600msFCO;
    } else {
        return Recent600msFCO / Recent600msODO;
    } 
    return 0x0;
}

uint32_t CartoonIFC_Timer = 0;
int32_t LastDestFuelEconomyIFC = 0;
int32_t LastIFC_Setp = 0;
int32_t IFC_step = 0;
int32_t IFC_OutputRange = 0;
uint8_t Flag_FirstFuelEconomy = 0;
void UpdateCenterTripC(void)
{
    uint8_t i = 0;
    uint32_t AccumulatedInfoODO_Temp = 0;
    uint32_t DriveInfoODO_Temp = 0;
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    int32_t TempDestFuelEconomyIFC = 0;
    uint32_t tmp = 0;
    static uint32_t Timer1msCnts_Old = 0;
    
    if (Timer1msCnts >= Timer1msCnts_Old) 
    {
        tmp = Timer1msCnts - Timer1msCnts_Old;
    } 
    else 
    {
        tmp = (0xffffffff - Timer1msCnts_Old) + Timer1msCnts;
    }
    Timer1msCnts_Old = Timer1msCnts;
    
    if(TripCPara.CurTripCItem == TRIP_C_FUEL_ECONOMY)
    {
        CartoonIFC_Timer += tmp;
        if(Flag_FirstFuelEconomy == 0)
        {
            CartoonIFC_Timer = 0;
            Flag_FirstFuelEconomy = 1;
        }
    }
    else
    {
        CartoonIFC_Timer = 0;
        Flag_FirstFuelEconomy = 0;
    }
    
    
    
    switch(TripCPara.CurTripCItem)
    {
    case TRIP_C_FUEL_ECONOMY:
        //̬ͼ,Ȼ̬
        switch(UsmSelfPara.Language)
        {
        case CHINESE:
          
           // SET_DISPLAY_STATIC_ITEM(0, _Bottom_Theme1_Pointer02_X291_Y26_R, 79, 85, DRAW_ICON);
          
          /*
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page1_Title_Word0_X79_Y85, 79, 85, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page1_Word0_X79_Y133, 79, 133, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, ECU_Unit_L100km_X124_Y167, 124, 167, DRAW_ICON);
            for(i = 0; i <= 2; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {
                SET_DRAW_INFO(61, 222, ECU_Reset_X61_Y222, 0, 0);
                
            } */
          g_DrawInfo.x_point = 65;
          g_DrawInfo.y_point = 120;
          
          g_DrawInfo.VRAM = VRAM_BUF[ g_DrawInfo.VramSelectBuf ];
          
          g_DrawInfo.IMG = (INT8U*)(_Bottom_Theme1_Pointer02_X291_Y26_R);
          
          g_DrawInfo.Radius = 0;
          g_DrawInfo.Alpha  = 0;
          GUI_DrawDispFunc(0, 0, 239, 0, 319);
           
            break;
        case ENGLISH:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page1_Title_Word2_X32_Y85, 32, 85, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page1_Word2_X79_Y132, 79, 132, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, ECU_Unit_kmL_X132_Y167, 132, 167, DRAW_ICON);
            for(i = 0; i <= 2; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {
                SET_DRAW_INFO(61, 225, ECU_Reset_Word2_X61_Y225, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, DOWN_TOP_Y);
            }
            break;
        case KOREAN:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page1_Title_Word1_X79_Y85, 79, 85, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page1_Word1_X79_Y132, 79, 132, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, ECU_Unit_L100km_X124_Y167, 124, 167, DRAW_ICON);
            for(i = 0; i <= 2; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {
                SET_DRAW_INFO(61, 225, ECU_Reset_Word1_X61_Y225, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, DOWN_TOP_Y);
            }
            break;
        default:
            break;
        }
        SET_DISPLAY_STATIC_ITEM(4, ECU_Page1_image_X24_Y205, 24, 205, DRAW_ICON);   //ƶĵλ 
        SET_DISPLAY_STATIC_ITEM_WINDOW(4, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        
        //̬ͼ󻭶̬
        
        if (TripCPara.FuelEconomyAFC != 0) 
        {
            SET_DISPLAY_DYNC_ITEM(0, Num20List[TripCPara.FuelEconomyAFC % 10], 113, 159, DRAW_ICON);//Сһλ
            SET_DISPLAY_DYNC_ITEM(1, Num20List[11], 107, 159, DRAW_ICON);   //С
            SET_DISPLAY_DYNC_ITEM(2, Num20List[TripCPara.FuelEconomyAFC % 100 / 10], 89, 159, DRAW_ICON);   //λ
            if (TripCPara.FuelEconomyAFC >= 100) 
            {
                SET_DISPLAY_DYNC_ITEM(3, Num20List[TripCPara.FuelEconomyAFC / 100], 71, 159, DRAW_ICON); //ʮλ
            }
        } 
        else if (TripCPara.FuelEconomyAFC == 0) 
        {
            SET_DISPLAY_DYNC_ITEM(0, Num20List[10], 113, 159, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(1, Num20List[10], 71, 159, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(2, Num20List[11], 107, 159, DRAW_ICON);  
            SET_DISPLAY_DYNC_ITEM(3, Num20List[10], 89, 159, DRAW_ICON);
        }
        
        if(CartoonIFC_Timer > 0 && CartoonIFC_Timer < 500)
        {
            IFC_step = CartoonLinearCalculate(450, IFC_OutputRange, CartoonIFC_Timer);
            IFC_step = LastIFC_Setp + IFC_step;
            if(IFC_step < 0)
            {
                IFC_step = 0;
            }
            if(IFC_step > 166)
            {
                IFC_step = 166;
            }
        }
        else
        {
            TempDestFuelEconomyIFC = (int32_t)TripCPara.DestFuelEconomyIFC;
            if(TempDestFuelEconomyIFC >= 300)
            {
                TempDestFuelEconomyIFC= 299;
            }
            IFC_OutputRange = CartoonLinearCalculate(299, 166, TempDestFuelEconomyIFC);
            LastIFC_Setp = IFC_step;
            IFC_OutputRange = IFC_OutputRange - LastIFC_Setp;
            CartoonIFC_Timer = 0;
            LastDestFuelEconomyIFC = TempDestFuelEconomyIFC;
        }
        
        SET_DISPLAY_DYNC_ITEM(4, ECU_Page1_Animation_000 + IFC_step * (ECU_Page1_Animation_001 - ECU_Page1_Animation_000), 24, 191, DRAW_MIM_ALPHA_ICON_WINDOW);
        for(i = 0; i <= 4; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        SetCenterAreaDisplayList(&DisplayItem, 0);
        break;
    case TRIP_C_ACCUMULATED_INFO:
        //̬
        switch(UsmSelfPara.Language)
        {
        case CHINESE:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page2_Title_Word0_X79_Y85, 79, 85, DRAW_ICON);   //
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page2_01_Word0_X32_Y130, 32, 130, DRAW_ICON);    //
            SET_DISPLAY_STATIC_ITEM(2, ECU_Page2_02_Word0_X32_Y165, 32, 165, DRAW_ICON);    //ͺ
            SET_DISPLAY_STATIC_ITEM(3, ECU_Page2_03_Word0_X32_Y200, 32, 200, DRAW_ICON);    //ʱ
            SET_DISPLAY_STATIC_ITEM(4, ECU_Unit_km_X178_Y137, 178, 137, DRAW_ICON);         //̵λ
            SET_DISPLAY_STATIC_ITEM(5, ECU_Unit_L100Km_X147_Y172, 147, 172, DRAW_ICON);     //ͺĵλ
            SET_DISPLAY_STATIC_ITEM(6, ECU_Unit_h_X191_Y207, 191, 207, DRAW_ICON);          //ʱ䵥λ
            for(i = 0; i <= 6; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {//OK
                SET_DRAW_INFO(61, 222, ECU_Reset_X61_Y222, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            break;
        case ENGLISH:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page2_Title_Word2_X32_Y85, 32, 85, DRAW_ICON);   //
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page2_01_Word2_X32_Y126, 32, 126, DRAW_ICON);    //
            SET_DISPLAY_STATIC_ITEM(2, ECU_Page2_02_Word2_X32_Y160, 32, 160, DRAW_ICON);    //ͺ
            SET_DISPLAY_STATIC_ITEM(3, ECU_Page2_03_Word2_X32_Y160, 32, 195, DRAW_ICON);    //ʱ
            SET_DISPLAY_STATIC_ITEM(4, ECU_Unit_km_X178_Y137, 178, 137, DRAW_ICON);         //̵λ
            SET_DISPLAY_STATIC_ITEM(5, ECU_Unit_kmL_X132_Y167, 161, 167, DRAW_ICON);     //ͺĵλ
            SET_DISPLAY_STATIC_ITEM(6, ECU_Unit_h_X191_Y207, 191, 207, DRAW_ICON);          //ʱ䵥λ
            for(i = 0; i <= 6; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {//OK
                SET_DRAW_INFO(61, 225, ECU_Reset_Word2_X61_Y225, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, DOWN_TOP_Y);
            }
            break;
        case KOREAN:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page2_Title_Word1_X79_Y85, 79, 85, DRAW_ICON);   //
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page2_01_Word1_X32_Y130, 32, 130, DRAW_ICON);    //
            SET_DISPLAY_STATIC_ITEM(2, ECU_Page2_02_Word1_X32_Y165, 32, 165, DRAW_ICON);    //ͺ
            SET_DISPLAY_STATIC_ITEM(3, ECU_Page2_03_Word1_X32_Y200, 32, 200, DRAW_ICON);    //ʱ
            SET_DISPLAY_STATIC_ITEM(4, ECU_Unit_km_X178_Y137, 178, 137, DRAW_ICON);         //̵λ
            SET_DISPLAY_STATIC_ITEM(5, ECU_Unit_L100Km_X147_Y172, 147, 172, DRAW_ICON);     //ͺĵλ
            SET_DISPLAY_STATIC_ITEM(6, ECU_Unit_h_X191_Y207, 191, 207, DRAW_ICON);          //ʱ䵥λ
            for(i = 0; i <= 6; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {//OK
                SET_DRAW_INFO(61, 225, ECU_Reset_Word1_X61_Y225, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, DOWN_TOP_Y);
            }
            break;
        default:
            break;
        }
        
        //̬
        //
        AccumulatedInfoODO_Temp = TripCPara.AccumulatedInfoODO / 100;
        SET_DISPLAY_DYNC_ITEM(0, Num20List[AccumulatedInfoODO_Temp % 10], 160, 129, DRAW_ICON); //Сһλ
        SET_DISPLAY_DYNC_ITEM(1, Num20List[11], 152, 129, DRAW_ICON); // С
        SET_DISPLAY_DYNC_ITEM(2, Num20List[AccumulatedInfoODO_Temp % 100 / 10 % 10], 134, 129, DRAW_ICON); //λ
        if ((AccumulatedInfoODO_Temp) >= 100)   
        {
            SET_DISPLAY_DYNC_ITEM(3, Num20List[(AccumulatedInfoODO_Temp) % 1000 / 100 % 10], 117, 129, DRAW_ICON); //ʮλ
        }
        if ((AccumulatedInfoODO_Temp) >= 1000) 
        {
            SET_DISPLAY_DYNC_ITEM(4, Num20List[(AccumulatedInfoODO_Temp) % 10000 / 1000 % 10], 100, 129, DRAW_ICON);   //λ
        }
        if ((AccumulatedInfoODO_Temp) >= 10000) 
        {
            SET_DISPLAY_DYNC_ITEM(5, Num20List[(AccumulatedInfoODO_Temp) / 10000 % 10], 83, 129, DRAW_ICON);  //ǧλ
        }
        for(i = 0; i <= 5; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        //ͺ
        if (TripCPara.AccumulatedInfoAFC != 0) 
        {
            if (TripCPara.AccumulatedInfoAFC >= 100) 
            {
                SET_DISPLAY_DYNC_ITEM(6, Num20List[TripCPara.AccumulatedInfoAFC / 100 % 10], 100, 164, DRAW_ICON);
            }
            SET_DISPLAY_DYNC_ITEM(7, Num20List[TripCPara.AccumulatedInfoAFC % 100 / 10 % 10], 117, 164, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(8, Num20List[11], 135, 164, DRAW_ICON);   //.
            SET_DISPLAY_DYNC_ITEM(9, Num20List[TripCPara.AccumulatedInfoAFC % 10], 143, 164, DRAW_ICON);
        } 
        else if (TripCPara.AccumulatedInfoAFC == 0) 
        {
            SET_DISPLAY_DYNC_ITEM(6, Num20List[10], 100, 163, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(7, Num20List[10], 117, 163, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(8, Num20List[11], 135, 163, DRAW_ICON);   //.
            SET_DISPLAY_DYNC_ITEM(9, Num20List[10], 143, 163, DRAW_ICON);
        }

        
        for(i = 6; i <= 9; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }                      
        //ʱ
        SET_DISPLAY_DYNC_ITEM(10, Num20List[(TripCPara.AccumulatedInfoTimerSeconds / 3600) / 10 % 10], 111, 199, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(11, Num20List[(TripCPara.AccumulatedInfoTimerSeconds / 3600) % 10], 128, 199, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(12, Num20List[12], 147, 199, DRAW_ICON);  //:
        SET_DISPLAY_DYNC_ITEM(13, Num20List[(TripCPara.AccumulatedInfoTimerSeconds / 60 % 60) / 10 % 10], 156, 199, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(14, Num20List[(TripCPara.AccumulatedInfoTimerSeconds / 60 % 60) % 10], 173, 199, DRAW_ICON);       
        for(i = 10; i <= 14; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        SetCenterAreaDisplayList(&DisplayItem, 0);
        break;
    case TRIP_C_DRIVE_INFO:
        //̬
        switch(UsmSelfPara.Language)
        {
        case CHINESE:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page3_Title_Word0_X79_Y85, 79, 85, DRAW_ICON);   //
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page2_01_Word0_X32_Y130, 32, 130, DRAW_ICON);    //
            SET_DISPLAY_STATIC_ITEM(2, ECU_Page2_02_Word0_X32_Y165, 32, 165, DRAW_ICON);    //ͺ
            SET_DISPLAY_STATIC_ITEM(3, ECU_Page2_03_Word0_X32_Y200, 32, 200, DRAW_ICON);    //ʱ
            SET_DISPLAY_STATIC_ITEM(4, ECU_Unit_km_X178_Y137, 178, 137, DRAW_ICON);         //̵λ
            SET_DISPLAY_STATIC_ITEM(5, ECU_Unit_L100Km_X147_Y172, 147, 172, DRAW_ICON);     //ͺĵλ
            SET_DISPLAY_STATIC_ITEM(6, ECU_Unit_h_X191_Y207, 191, 207, DRAW_ICON);          //ʱ䵥λ
            for(i = 0; i <= 6; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {//OK
                SET_DRAW_INFO(61, 222, ECU_Reset_X61_Y222, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            break;
        case ENGLISH:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page3_Title_Word2_X32_Y85, 32, 85, DRAW_ICON);   //
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page2_01_Word2_X32_Y126, 32, 126, DRAW_ICON);    //
            SET_DISPLAY_STATIC_ITEM(2, ECU_Page2_02_Word2_X32_Y160, 32, 160, DRAW_ICON);    //ͺ
            SET_DISPLAY_STATIC_ITEM(3, ECU_Page2_03_Word2_X32_Y160, 32, 195, DRAW_ICON);    //ʱ
            SET_DISPLAY_STATIC_ITEM(4, ECU_Unit_km_X178_Y137, 178, 137, DRAW_ICON);         //̵λ
            SET_DISPLAY_STATIC_ITEM(5, ECU_Unit_kmL_X132_Y167, 161, 167, DRAW_ICON);     //ͺĵλ
            SET_DISPLAY_STATIC_ITEM(6, ECU_Unit_h_X191_Y207, 191, 207, DRAW_ICON);          //ʱ䵥λ
            for(i = 0; i <= 6; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {//OK
                SET_DRAW_INFO(61, 225, ECU_Reset_Word2_X61_Y225, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, DOWN_TOP_Y);
            }
            break;
        case KOREAN:
            SET_DISPLAY_STATIC_ITEM(0, ECU_Page3_Title_Word1_X79_Y85, 79, 85, DRAW_ICON);   //
            SET_DISPLAY_STATIC_ITEM(1, ECU_Page2_01_Word1_X32_Y130, 32, 130, DRAW_ICON);    //
            SET_DISPLAY_STATIC_ITEM(2, ECU_Page2_02_Word1_X32_Y165, 32, 165, DRAW_ICON);    //ͺ
            SET_DISPLAY_STATIC_ITEM(3, ECU_Page2_03_Word1_X32_Y200, 32, 200, DRAW_ICON);    //ʱ
            SET_DISPLAY_STATIC_ITEM(4, ECU_Unit_km_X178_Y137, 178, 137, DRAW_ICON);         //̵λ
            SET_DISPLAY_STATIC_ITEM(5, ECU_Unit_L100Km_X147_Y172, 147, 172, DRAW_ICON);     //ͺĵλ
            SET_DISPLAY_STATIC_ITEM(6, ECU_Unit_h_X191_Y207, 191, 207, DRAW_ICON);          //ʱ䵥λ
            for(i = 0; i <= 6; i++)
            {
                SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
            if(PressOkClrRemainTime > 0 && PressOkClrRemainTime <= 10000)
            {//OK
                SET_DRAW_INFO(61, 225, ECU_Reset_Word1_X61_Y225, 0, 0);
                GUI_DrawDispFunc(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, DOWN_TOP_Y);
            }
            break;
        default:
            break;
        }
        
        //̬
        //
        DriveInfoODO_Temp = TripCPara.DriveInfoODO / 100;
        SET_DISPLAY_DYNC_ITEM(0, Num20List[DriveInfoODO_Temp % 10], 160, 129, DRAW_ICON); //Сһλ
        SET_DISPLAY_DYNC_ITEM(1, Num20List[11], 152, 129, DRAW_ICON); // С
        SET_DISPLAY_DYNC_ITEM(2, Num20List[DriveInfoODO_Temp % 100 / 10 % 10], 134, 129, DRAW_ICON); //λ
        if ((DriveInfoODO_Temp) >= 100)   
        {
            SET_DISPLAY_DYNC_ITEM(3, Num20List[(DriveInfoODO_Temp) % 1000 / 100 % 10], 117, 129, DRAW_ICON); //ʮλ
        }
        if ((DriveInfoODO_Temp) >= 1000) 
        {
            SET_DISPLAY_DYNC_ITEM(4, Num20List[(DriveInfoODO_Temp) % 10000 / 1000 % 10], 100, 129, DRAW_ICON);   //λ
        }
        if ((DriveInfoODO_Temp) >= 10000) 
        {
            SET_DISPLAY_DYNC_ITEM(5, Num20List[(DriveInfoODO_Temp) / 10000 % 10], 83, 129, DRAW_ICON);  //ǧλ
        }
        for(i = 0; i <= 5; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        //ͺ
        if (TripCPara.DriveInfoAFC != 0) 
        {
            if (TripCPara.DriveInfoAFC >= 100) 
            {
                SET_DISPLAY_DYNC_ITEM(6, Num20List[TripCPara.DriveInfoAFC / 100 % 10], 100, 164, DRAW_ICON);
            }
            SET_DISPLAY_DYNC_ITEM(7, Num20List[TripCPara.DriveInfoAFC % 100 / 10 % 10], 117, 164, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(8, Num20List[11], 135, 164, DRAW_ICON);   //.
            SET_DISPLAY_DYNC_ITEM(9, Num20List[TripCPara.DriveInfoAFC % 10], 143, 164, DRAW_ICON);
        } 
        else if (TripCPara.DriveInfoAFC == 0) 
        {
            SET_DISPLAY_DYNC_ITEM(6, Num20List[10], 100, 163, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(7, Num20List[10], 117, 163, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(8, Num20List[11], 135, 163, DRAW_ICON);   //.
            SET_DISPLAY_DYNC_ITEM(9, Num20List[10], 143, 163, DRAW_ICON);
        }

        for(i = 6; i <= 9; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }                 
        //ʱ
        SET_DISPLAY_DYNC_ITEM(10, Num20List[(TripCPara.DriveInfoTimerSeconds / 3600) / 10 % 10], 111, 199, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(11, Num20List[(TripCPara.DriveInfoTimerSeconds / 3600) % 10], 128, 199, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(12, Num20List[12], 147, 199, DRAW_ICON);  //:
        SET_DISPLAY_DYNC_ITEM(13, Num20List[(TripCPara.DriveInfoTimerSeconds / 60 % 60) / 10 % 10], 156, 199, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(14, Num20List[(TripCPara.DriveInfoTimerSeconds / 60 % 60) % 10], 173, 199, DRAW_ICON);       
        for(i = 10; i <= 14; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        SetCenterAreaDisplayList(&DisplayItem, 0);
        break;
    case TRIP_C_DIGITAL_SPEEDOMETER:
        SET_DISPLAY_STATIC_ITEM(0, ECU_Unit_kmh_X161_Y172, 160, 172, DRAW_ICON);
        SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y , MID_BOTTOM_Y);
        if (TripCPara.Speed >= 100) 
        {
            SET_DISPLAY_DYNC_ITEM(0, Num47List[TripCPara.Speed / 100 % 10], 43, 139, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(1, Num47List[TripCPara.Speed % 100 / 10 % 10], 82, 139, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(2, Num47List[TripCPara.Speed % 10], 121, 139, DRAW_ICON);
            for(i = 0; i <= 2; i++)
            {
                SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
        } 
        else if (TripCPara.Speed >= 10) 
        {
            SET_DISPLAY_DYNC_ITEM(0, Num47List[TripCPara.Speed % 100 / 10 % 10], 82, 139, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM(1, Num47List[TripCPara.Speed % 10], 121, 139, DRAW_ICON);
            for(i = 0; i <= 1; i++)
            {
                SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
            }
        } 
        else 
        {
            SET_DISPLAY_DYNC_ITEM(0, Num47List[TripCPara.Speed % 10], 121, 139, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        SetCenterAreaDisplayList(&DisplayItem, 0);
        break;
    default:
        break;
    }
}

uint32_t LKATimerCnts = 0;
uint32_t LKACnts = 0;
uint8_t LKA400msLevel = 0;
uint8_t LKA400msEN = 0;
void UpdateLKA(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    uint32_t tmp = 0;
    if (Timer1msCnts >= LKATimerCnts) 
    {
        tmp = Timer1msCnts - LKATimerCnts;
    } 
    else 
    {
        tmp = (0xffffffff - LKATimerCnts) + Timer1msCnts;
    }
    LKATimerCnts = Timer1msCnts;
    
    LKACnts += tmp;
    if(LKACnts >= 400)
    {
        LKACnts -= 400;
        LKA400msLevel = !LKA400msLevel;
    }
    LKA400msEN = 0;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK;
   
    if((Can0DataStruct.CF_LKA_SymbolState == 0 && Can0DataStruct.CF_LKA_LaneRecogState == 0) || (Can0Frame[CAN0_FRAME_0x340].AliveTime == 0))
    {//3.2.1
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_01_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_01_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_01_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_000_X42_Y121, 42, 121, DRAW_ICON);
    }
    else if(Can0DataStruct.CF_LKA_SymbolState != 0 && Can0DataStruct.CF_LKA_LaneRecogState == 0)
    {//3.2.2
        if (UsmSelfPara.Language == CHINESE) 
        {
             if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
             else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 1 && Can0DataStruct.CF_LKA_LHWarning == 0)
    {//3.2.4
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_002_X42_Y121, 42, 121, DRAW_ICON);
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 1 && (Can0DataStruct.CF_LKA_LHWarning == 1 || Can0DataStruct.CF_LKA_LHWarning == 2))
    {//3.2.24
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK) == 1)
        {
            LKA400msEN = TRUE;
            if(LKA400msLevel == 1)
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_002_X42_Y121, 42, 121, DRAW_ICON);
            }
            else
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
            }
        }
        else
        {
            SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
        }
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 2 && Can0DataStruct.CF_LKA_RHWarning == 0)
    {//3.2.3
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_03_X42_Y121, 42, 121, DRAW_ICON);
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 2 && (Can0DataStruct.CF_LKA_RHWarning == 1 || Can0DataStruct.CF_LKA_RHWarning == 2))
    {//3.2.26
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK) == 1)
        {
            LKA400msEN = TRUE;
            if(LKA400msLevel == 1)
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_03_X42_Y121, 42, 121, DRAW_ICON);
            }
            else
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
            }
        }
        else
        {
            SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
        }
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 3 && Can0DataStruct.CF_LKA_LHWarning == 0 && Can0DataStruct.CF_LKA_RHWarning == 0)
    {//3.2.21
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_004_X42_Y121, 42, 121, DRAW_ICON);
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 3 && (Can0DataStruct.CF_LKA_LHWarning == 1 || Can0DataStruct.CF_LKA_LHWarning == 2) && Can0DataStruct.CF_LKA_RHWarning == 0)
    {//3.2.6
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK) == 1)
        {
            LKA400msEN = TRUE;
            if(LKA400msLevel == 1)
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_002_X42_Y121, 42, 121, DRAW_ICON);
            }
            else
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
            }
        }
        else
        {
            SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
        }
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 3 && Can0DataStruct.CF_LKA_LHWarning == 0 && (Can0DataStruct.CF_LKA_RHWarning == 1 || Can0DataStruct.CF_LKA_RHWarning == 2))
    {//3.2.5
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK) == 1)
        {
            LKA400msEN = TRUE;
            if(LKA400msLevel == 1)
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_03_X42_Y121, 42, 121, DRAW_ICON);
            }
            else
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
            }
        }
        else
        {
            SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
        }
    }
    else if(Can0DataStruct.CF_LKA_LaneRecogState == 3 && (Can0DataStruct.CF_LKA_LHWarning == 1 || Can0DataStruct.CF_LKA_LHWarning == 2) && (Can0DataStruct.CF_LKA_RHWarning == 1 || Can0DataStruct.CF_LKA_RHWarning == 2))
    {//3.2.63
        if (UsmSelfPara.Language == CHINESE) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word2_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            if(Can0DataStruct.CF_LKA_Opt_USM == 2 || Can0DataStruct.CF_LKA_Opt_USM == 6)//LKA
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_02_Word1_X24_Y84, 24, 84, DRAW_ICON);
            else //LDW
                SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_03_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK) == 1)
        {
            LKA400msEN = TRUE;
            if(LKA400msLevel == 1)
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_004_X42_Y121, 42, 121, DRAW_ICON);
            }
            else
            {
                SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
            }
        }
        else
        {
            SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_001_X42_Y121, 42, 121, DRAW_ICON);
        }
    }
    else
    {
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_01_Word0_X38_Y84, 38, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_01_Word2_X24_Y84, 24, 84, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, ADAS_LDW_SCC_01_Word1_X24_Y84, 24, 84, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, ADAS_LDW_SCC_image_000_X42_Y121, 42, 121, DRAW_ICON);
    }
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, UP_BOTTOM_Y, DOWN_TOP_Y);
    SET_DISPLAY_STATIC_ITEM_WINDOW(1, LEFT_X_START, MID_X_RIGHT, UP_BOTTOM_Y, DOWN_TOP_Y);
    if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK) == 0)
    {
        SetCenterAreaDisplayList(&DisplayItem, 0);
    }
    else
    {
        SetCenterAreaDisplayList(&DisplayItem, 400);
    }
    if(LKA400msEN == 0)
    {
        LKA400msLevel = 1;
        LKACnts = 0;
    }
}

void UpdateDaw(void)
{
    uint8_t i = 0;
    
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_ASSIST_DAW;
    
    if((Can0DataStruct.CF_DAW_Status == 0) || (Can0DataStruct.CF_DAW_Status >= 0x06 && Can0DataStruct.CF_DAW_Status <= 0x0D))
    {
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_01_Word0_X38_Y84, 38, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_04_Word0_X38_Y152, 38, 152, DRAW_ICON);
            if(Can0DataStruct.CF_DAW_Status == 0)
            {
                SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word0_X42_Y216, 42, 216, DRAW_ICON);
            }
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_01_Word2_X30_Y84, 30, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_04_Word2_X38_Y152, 38, 152, DRAW_ICON);
            if(Can0DataStruct.CF_DAW_Status == 0)
            {
                SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word2_X42_Y216, 42, 216, DRAW_ICON);
            }
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_01_Word1_X38_Y84, 38, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_04_Word1_X38_Y152, 38, 152, DRAW_ICON);
            if(Can0DataStruct.CF_DAW_Status == 0)
            {
                SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word1_X28Y216, 28, 216, DRAW_ICON);
            }
        }
        if(Can0DataStruct.CF_DAW_Status == 0)
        {
            SET_DISPLAY_STATIC_ITEM(3, Number_25_White_Line, 140, 219, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(4, Number_25_White_Line, 152, 219, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(5, Number_25_White_Point2, 166, 219, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(6, Number_25_White_Line, 171, 219, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(7, Number_25_White_Line, 183, 219, DRAW_ICON);
        }    
        for(i = 0; i <= 7; i++)
        {
            SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        
    }
    else if((Can0DataStruct.CF_DAW_Status >= 1) && (Can0DataStruct.CF_DAW_Status <= 5))
    {
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_02_Word0_X38_Y84, 38, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_05_Word0_X30_Y178, 30, 178, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word0_X42_Y216, 42, 216, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_02_Word2_X14_Y84, 14, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_05_Word2_X30_Y178, 30, 178, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word2_X42_Y216, 42, 216, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_02_Word1_X38_Y84, 38, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_05_Word1_X30_Y178, 30, 178, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word1_X28Y216, 28, 216, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(3, DAW_Line_X22_Y210, 22, 210, DRAW_ICON);
        SET_DISPLAY_STATIC_ITEM(4, Number_25_White_Point2, 182, 219, DRAW_ICON);
        for(i = 0; i <= 4; i++)
        {
            SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        switch(Can0DataStruct.CF_DAW_Status )
        {
        case 0x01:
            SET_DISPLAY_DYNC_ITEM(0, DAW_image_01_X33_Y145, 33, 145, DRAW_ICON);
            break;
        case 0x02:
            SET_DISPLAY_DYNC_ITEM(0, DAW_image_02_X33_Y145, 33, 145, DRAW_ICON);
            break;
        case 0x03:
            SET_DISPLAY_DYNC_ITEM(0, DAW_image_03_X33_Y145, 33, 145, DRAW_ICON);
            break;
        case 0x04:
            SET_DISPLAY_DYNC_ITEM(0, DAW_image_04_X33_Y145, 33, 145, DRAW_ICON);
            break;
        case 0x05:
            SET_DISPLAY_DYNC_ITEM(0, DAW_image_05_X33_Y145, 33, 145, DRAW_ICON);
            break;
        default:
            break;
        }
        SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        
        SET_DISPLAY_DYNC_ITEM(1, Number25List[InputOutputSingal.DA_DAW_Timer / 3600 % 100 / 10], 156, 219, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(2, Number25List[InputOutputSingal.DA_DAW_Timer / 3600 % 100 % 10], 168, 219, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(3, Number25List[InputOutputSingal.DA_DAW_Timer / 60 % 60 / 10], 187, 219, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(4, Number25List[InputOutputSingal.DA_DAW_Timer / 60 % 60 % 10], 199, 219, DRAW_ICON);
        
        for(i = 1; i <= 4; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
    }
    else if(Can0DataStruct.CF_DAW_Status == 0x0E)
    {
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_01_Word0_X38_Y84, 38, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_03_Word0_X38_Y152, 38, 152, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word0_X42_Y216, 42, 216, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_01_Word2_X30_Y84, 30, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_03_Word2_X38_Y152, 38, 152, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word2_X42_Y216, 42, 216, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, DAW_01_Word1_X38_Y84, 38, 84, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, DAW_03_Word1_X38_Y152, 38, 152, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, DAW_06_Word1_X28Y216, 28, 216, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(3, Number_25_White_Point2, 182, 219, DRAW_ICON);
        for(i = 0; i <= 3; i++)
        {
            SET_DISPLAY_STATIC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
        SET_DISPLAY_DYNC_ITEM(1, Number25List[InputOutputSingal.DA_DAW_Timer / 3600 % 100 / 10], 156, 219, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(2, Number25List[InputOutputSingal.DA_DAW_Timer / 3600 % 100 % 10], 168, 219, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(3, Number25List[InputOutputSingal.DA_DAW_Timer / 60 % 60 / 10], 187, 219, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM(4, Number25List[InputOutputSingal.DA_DAW_Timer / 60 % 60 % 10], 199, 219, DRAW_ICON);
        
        for(i = 0; i <= 4; i++)
        {
            SET_DISPLAY_DYNC_ITEM_WINDOW(i, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
        }
    }
    else if(Can0DataStruct.CF_DAW_Status == 0x0F)
    {
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, Alarm_A_46_Word0_X14_Y77, 14, 77, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, Alarm_A_46_Word2_X14_Y77, 14, 77, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, Alarm_A_46_Word1_X14_Y92, 14, 92, DRAW_ICON);
        }
        SET_DISPLAY_STATIC_ITEM(1, Alarm_A_46_image_X85_Y172, 85, 172, DRAW_ICON);
        SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, UP_BOTTOM_Y, MID_BOTTOM_Y);
        SET_DISPLAY_STATIC_ITEM_WINDOW(1, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, MID_BOTTOM_Y);
    }
    
    if(CheckAlreadyDisplayed(CENTER_AREA_DISPLAY_TYPE_ASSIST_DAW) == 0)
    {
        SetCenterAreaDisplayList(&DisplayItem, 0);
    }
    else
    {
        
        SetCenterAreaDisplayList(&DisplayItem, 400);
    }
}