
#ifndef _LCD_C035QAN02_H_
    #define _LCD_C035QAN02_H_

#include "common_include.h"

//Reset
    #define   LCD_BUS_RESET_HOLD                100       //Һλźűʱ,λms
    #define   LCD_BUS_AFTER_RESET_WAIT          150       //Һλȴʱ,λms









    #define   LCD_PANEL_WIDTH                   240
    #define   LCD_PANEL_HEIGHT                  320
    #define   LCD_PANEL_BPP                     4




    #define   LCD_PANEL_GRAM_SIZE               (LCD_PANEL_WIDTH * LCD_PANEL_HEIGHT * LCD_PANEL_BPP / 8)




    #define   LCD_PANEL_REQ_APPROVED            0x00
    #define   LCD_PANEL_REQ_REJECTED            0x01




    #define   LCD_CMD_NOP                       0x00
    #define   LCD_CMD_DISPOFF                   0x11
    #define   LCD_CMD_DISPON                    0x12
    #define   LCD_CMD_SLPOUT                    0x13
    #define   LCD_CMD_SLPIN                     0x14
    #define   LCD_CMD_DISINOFF                  0x15
    #define   LCD_CMD_DISINV                    0x16
    #define   LCD_CMD_MADCTL                    0x21
    #define   LCD_CMD_PASET                     0x22
    #define   LCD_CMD_CASET                     0x23
    #define   LCD_CMD_BPPSEL                    0x25
    #define   LCD_CMD_TE                        0x35
    #define   LCD_CMD_RDRAM                     0x39
    #define   LCD_CMD_WRRAM                     0x3A
    #define   LCD_CMD_SERESET                   0x5E
    #define   LCD_CMD_DISAR                     0x91
    #define   LCD_CMD_FEQ                       0x92
    #define   LCD_CMD_RELOAD                    0xCD


    typedef struct
    {
        uint8_t   Request;
        uint8_t   Cmd;
        
        uint16_t  StartPage;
        uint16_t  Len;
        uint32_t  *pData;
    }LCDPanelUpdtCtrlStruct;
    
    extern    uint32_t*          LCDPanelGraphicRAM;
    extern    volatile         LCDPanelUpdtCtrlStruct      LCDPanelUpdtCtrl;
    
    void      LCD_Panel_Start_Up(void);
    void      LCD_Panel_Shut_Down(void);
    
    void      LCD_Panel_Update_Req(uint16_t starPage,uint16_t endPage);
    uint8_t    LCD_Panel_Get_Update_Enable(void);
    
    void      LCD_Panel_Update_ISR(uint8_t step);
    void      LCD_ClearFullScreen(uint8_t FullPixel);
    
#endif
