#ifdef        GLOBALS_BSP_MOTOR
    #define   EXTERN_BSP_MOTOR
#else
    #define   EXTERN_BSP_MOTOR    extern
#endif

#ifndef __SMC_DRIVER_H__
    #define __SMC_DRIVER_H__

typedef struct
{
    uint16_t      BoardVal;
    uint16_t      PWMBoardVal;
    uint16_t      CurBoardVal;
    uint16_t      DestBoardVal;
    uint16_t      CurPosition;
    uint16_t      DestPosition;
    uint16_t      OldBoardVal;
    uint16_t      OldPosition;
    uint16_t      DispPosition;
    uint16_t      WHL_SPD_FL;
    uint16_t      WHL_SPD_FR;
    uint16_t      WHL_SPD_RL;
    uint16_t      WHL_SPD_RR;
    uint16_t      SpeedPWMMVar;
    uint16_t      SpeedPWMMVarOld;
    uint16_t      SpeedPWMMin;
    uint16_t      SpeedPWMMax;
    uint32_t      Time;
    uint16_t      CalTime;
    uint16_t      ChangeTime;
    uint8_t       Dir;//0:½ 1
    uint8_t       TireValidCount;
} _MeterPos;

/**
*****************************************************************************
** ҪCANʼ˲
**
**
*****************************************************************************/
    typedef struct stc_motor
    {
        uint8_t motor_sel;
    }stc_motor_t;
    
    typedef struct
    {
        uint8_t       MotorReset;
        uint8_t       Dir;
        uint8_t       bPhase;
        uint16_t      Time;
        uint16_t      ChangeTime;
        uint16_t      CurPosition;
        uint16_t      DestPosition;
    }stc_Meter_t;


    static const  uint16_t SinTalbe[24]=
    {
        0,66,128,181,222,247,255,247,222,181,128,66,
        0,66,128,181,222,247,255,247,222,181,128,66
    };
    static const  uint16_t CosTalbe[24]=
    {
        255,247,222,181,128,66,0,66,128,181,222,247,
        255,247,222,181,128,66,0,66,128,181,222,247
    };


    #define             Duty_8bits      0
    #define             Duty_10bits     1

    EXTERN_BSP_MOTOR volatile uint8_t m_motor_sel;
    EXTERN_BSP_MOTOR void     SMC_Drive_Init(stc_motor_t *motorConfig,uint8_t cycle_width,uint8_t clkdiv);
    EXTERN_BSP_MOTOR void     Motor_Move(_MeterPos *meter);
    EXTERN_BSP_MOTOR void     BSP_MOTOR_Init(void);

#endif /*__SMC_DRIVER_H__*/
