/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file cpu.h
 **
 ** Headerfile for Traveo CPU functions
 **
 ** History:
 **   - 2014-06-02  0.01  HS  Initial version for Traveo
 **   - 2014-11-21  0.02  CEy Added Cpu_InvalidateDCacheArea()
 *****************************************************************************/

#ifndef __CPU_H__
#define __CPU_H__


/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "base_types.h"
#include "abstract.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern "C"
{
#endif

/*****************************************************************************/
/* Global pre-processor symbols/macros ('define')                            */
/*****************************************************************************/


/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/


/*****************************************************************************
 * Global function prototypes
 *****************************************************************************/

/**
 *****************************************************************************
 ** \defgroup CpuGroup CPU Mode Functions (CPU)
 **
 ** \brief This section describes the interface for the CPU Mode functions.
 **
 ** Provided functions of CPU module:
 **
 ** - Cpu_CpuIsInPrivilegedMode()
 ** - Cpu_GetSystemMode()
 ** - CPU_SET_SYSTEMCONTROL()
 ** - CPU_GET_SYSTEMCONTROL()
 ** - CPU_GET_MPU_TYPE()
 ** - CPU_SET_MPU_REGIONNUMBER()
 ** - CPU_SET_MPU_REGIONBASE()
 ** - CPU_GET_MPU_REGIONBASE()
 ** - CPU_SET_MPU_REGIONSIZE_ENABLE()
 ** - CPU_GET_MPU_REGIONSIZE_ENABLE()
 ** - CPU_SET_MPU_REGIONACCESS()
 ** - CPU_GET_MPU_REGIONACCESS()
 **
 ** Cpu_CpuIsInPrivilegedMode() is used to check whether CPU is in privileged mode.
 ** Cpu_GetSystemMode() is used to get current CPU mode.
 ** On the CR5, cpu modes are follows:
 ** - User mode (unprivileged)
 ** - System mode
 ** - Supvervisor mode
 ** - IRQ mode
 ** - FIQ mode
 ** - Abort mode
 ** - Undefined mode
 **
 ** Other functions can be used to set/get a coprocesser registers.
 **
 *****************************************************************************/
/* @{ */

/** Macro for setting CP15 System Control Register */
#define CPU_SET_SYSTEMCONTROL(u32Value)         MCR(15, 0, u32Value, 1, 0, 0)

/** Macro for getting CP15 System Control Register */
#define CPU_GET_SYSTEMCONTROL()                 MRC(15, 0, 1, 0, 0)

/** Macro for getting CP15 MPU Type Register */
#define CPU_GET_MPU_TYPE()                      MRC(15, 0, 0, 0, 4)

/** Macro for setting CP15 Memory Region Number Register */
#define CPU_SET_MPU_REGIONNUMBER(u32Value)      MCR(15, 0, u32Value, 6, 2, 0)

/** Macro for setting CP15 Region Base Register */
#define CPU_SET_MPU_REGIONBASE(u32Value)        MCR(15, 0, u32Value, 6, 1, 0)

/** Macro for getting CP15 Region Base Register */
#define CPU_GET_MPU_REGIONBASE()                MRC(15, 0, 6, 1, 0)

/** Macro for setting CP15 Region Size and Enable Register */
#define CPU_SET_MPU_REGIONSIZE_ENABLE(u32Value) MCR(15, 0, u32Value, 6, 1, 2)

/** Macro for getting CP15 Region Size and Enable Register */
#define CPU_GET_MPU_REGIONSIZE_ENABLE()         MRC(15, 0, 6, 1, 2)

/** Macro for setting CP15 Region Access Control Register */
#define CPU_SET_MPU_REGIONACCESS(u32Value)      MCR(15, 0, u32Value, 6, 1, 4)

/** Macro for getting CP15 Region Access Control Register */
#define CPU_GET_MPU_REGIONACCESS()              MRC(15, 0, 6, 1, 4)


/**
 *****************************************************************************
 ** \brief CPU mode
 *****************************************************************************/
typedef enum en_cpu_mode
{
    CpuUserMode     = 0x10,     /*!< User mode */
    /* Privileged modes start here */
    CpuSystemMode   = 0x1F,     /*!< System mode */
    CpuFiqMode      = 0x11,     /*!< Fast interrupt mode */
    CpuIrqMode      = 0x12,     /*!< Interrupt mode */
    CpuSvcMode      = 0x13,     /*!< Supervisor mode */
    CpuAbtMode      = 0x17,     /*!< Data abort mode */
    CpuUndefMode    = 0x1B      /*!< Undefined mode */
} en_cpu_mode_t;

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/
extern boolean_t     Cpu_CpuIsInPrivilegedMode(void);
extern uint32_t      Cpu_GetSystemMode(void);
extern en_result_t   Cpu_InvalidateDCacheArea(uint32_t u32StartAddress, uint32_t u32ByteSize);

/* @} */

#ifdef __cplusplus
}
#endif


#endif /* __CPU_H__ */
/*****************************************************************************/
/* EOF (not truncated)                                                       */
/*****************************************************************************/
