/*****************************************************************************
 * $Revision: 423 $
 * $Date: 2015-09-10 17:33:56 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/******************************************************************************/
/** \file i2s_generated.c
 **
 ** Generated file for i2s.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in i2s.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by i2s.c automatically!
 **
 ** History:
 ** - 2015-03-31  1.0   MAs  First version 
 ******************************************************************************/

#ifndef __I2S_GENERATED_C__
#define __I2S_GENERATED_C__


/******************************************************************************/
/* Include files                                                              */
/******************************************************************************/
#include "common_include.h"
/******************************************************************************/
/* Local pre-processor symbols/macros ('#define')                             */
/******************************************************************************/

/** Macro to return the number of enabled I2S instances */
#define I2S_INSTANCE_COUNT (uint32_t)(sizeof(m_astcI2sInstanceDataLut) / sizeof(m_astcI2sInstanceDataLut[0]))

/******************************************************************************/
/* Global variable definitions (declared in header file with 'extern')        */
/******************************************************************************/


/******************************************************************************/
/* Local type definitions ('typedef')                                         */
/******************************************************************************/

/// Enumeration to define an index for each enabled I2S instance
typedef enum en_i2s_instance_index
{
    I2sInstanceIndexI2s0,
    I2sInstanceIndexI2s1,
    I2sInstanceIndexMax
} en_i2s_instance_index_t;
    

/** I2S instance data type */
typedef struct stc_i2s_instance_data
{
    volatile stc_i2sn_t* pstcInstance;   ///< pointer to registers of an instance
    stc_i2s_intern_data_t stcInternData; ///< module internal data of instance
} stc_i2s_instance_data_t;

/******************************************************************************/
/* Local variable definitions ('static')                                      */
/******************************************************************************/

/// Look-up table for all enabled I2S instances and their internal data
static stc_i2s_instance_data_t m_astcI2sInstanceDataLut[] =
{
    { .pstcInstance = &I2S0 },
    { .pstcInstance = &I2S1 },
};

/******************************************************************************/
/* Local function prototypes ('static')                                       */
/******************************************************************************/

/******************************************************************************/
/* Function implementation - global ('extern') and local ('static')           */
/******************************************************************************/

/**
 ******************************************************************************
 ** \brief Return the internal data for a certain I2S instance.
 **
 ** \param pstcI2s Pointer to I2S instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 ******************************************************************************/
static stc_i2s_intern_data_t* I2sGetInternDataPtr(volatile stc_i2sn_t* pstcI2s) 
{
    uint32_t u32Instance;
   
    for (u32Instance = 0; u32Instance < I2S_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcI2s == m_astcI2sInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcI2sInstanceDataLut[u32Instance].stcInternData;
        }
    }

    return NULL;
}

// -------------------------------------------------------------------
// Definition of all individual ISRs for each enabled I2S instance.
//
// The individual ISR calls the generic IRQ handler with
// the instance pointer and its internal data to handle the interrupt.
// -------------------------------------------------------------------

//FN_IRQ_DEFINE_BEGIN(I2s_Isr_I2s0, INTERRUPTS_IRQ_NUMBER_236)
//{
//   I2sIrqHandler((stc_i2sn_t*)&I2S0, &(m_astcI2sInstanceDataLut[I2sInstanceIndexI2s0].stcInternData));
//}
//FN_IRQ_DEFINE_END()
//
//
//FN_IRQ_DEFINE_BEGIN(I2s_Isr_I2s1, INTERRUPTS_IRQ_NUMBER_237)
//{
//   I2sIrqHandler((stc_i2sn_t*)&I2S1, &(m_astcI2sInstanceDataLut[I2sInstanceIndexI2s1].stcInternData));
//}
//FN_IRQ_DEFINE_END()

#endif  // __I2S_GENERATED_C__

