/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file icu_generated.c
 **
 ** Generated file for icu.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in icu.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by icu.c automatically!
 **
 ** History:
 **   - 2014-06-26  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __ICU_GENERATED_C__
#define __ICU_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/* Macro to return the number of enabled ICU instances */
#define ICU_INSTANCE_COUNT (uint32_t)(sizeof(m_astcIcuInstanceDataLut) / sizeof(m_astcIcuInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/* Enumeration to define an index for each enabled ICU instance */
typedef enum en_icu_instance_index
{
    #if (PDL_PERIPHERAL_ENABLE_ICU0 == PDL_ON)
    IcuInstanceIndexIcu0,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU1 == PDL_ON)
    IcuInstanceIndexIcu1,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU2 == PDL_ON)
    IcuInstanceIndexIcu2,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU8 == PDL_ON)
    IcuInstanceIndexIcu8,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU9 == PDL_ON)
    IcuInstanceIndexIcu9,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU10 == PDL_ON)
    IcuInstanceIndexIcu10,
    #endif
    IcuInstanceIndexMax
} en_icu_instance_index_t;

/* ICU instance data type */
typedef struct stc_icu_instance_data
{
    volatile stc_icun_t* pstcInstance;   /* pointer to registers of an instance */
    stc_icu_intern_data_t stcInternData; /* module internal data of instance */
} stc_icu_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/* Look-up table for all enabled ICU instances and their internal data */
static stc_icu_instance_data_t m_astcIcuInstanceDataLut[] =
{
    #if (PDL_PERIPHERAL_ENABLE_ICU0 == PDL_ON)
    {
        &ICU00,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU1 == PDL_ON)
    {
        &ICU01,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU2 == PDL_ON)
    {
        &ICU02,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU8 == PDL_ON)
    {
        &ICU08,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU9 == PDL_ON)
    {
        &ICU09,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_ICU10 == PDL_ON)
    {
        &ICU10,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 *****************************************************************************
 ** \brief Return the internal data for a certain ICU instance.
 **
 ** \param pstcIcu Pointer to ICU instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 *****************************************************************************/
static stc_icu_intern_data_t* IcuGetInternDataPtr(volatile stc_icun_t* pstcIcu) 
{
    uint32_t u32Instance;
   
    for (u32Instance = 0; u32Instance < ICU_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcIcu == m_astcIcuInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcIcuInstanceDataLut[u32Instance].stcInternData;
        }
    }

    return NULL;
}

/**
 *****************************************************************************
 ** Definition of all individual ISRs for each enabled FRT instance.
 **
 ** The individual ISR calls the generic IRQ handler with
 ** the instance pointer and its internal data to handle the interrupt.
 *****************************************************************************/
#if (PDL_PERIPHERAL_ENABLE_ICU0 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu0Channel0, INTERRUPTS_IRQ_NUMBER_162)
{
    IcuIrqHandlerChannel0((stc_icun_t*)&ICU00, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu0].stcInternData));
}
FN_IRQ_DEFINE_END()
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu0Channel1, INTERRUPTS_IRQ_NUMBER_168)
{
    IcuIrqHandlerChannel1((stc_icun_t*)&ICU00, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu0].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_ICU1 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu1Channel0, INTERRUPTS_IRQ_NUMBER_163)
{
    IcuIrqHandlerChannel0((stc_icun_t*)&ICU01, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu1].stcInternData));
}
FN_IRQ_DEFINE_END()
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu1Channel1, INTERRUPTS_IRQ_NUMBER_169)
{
    IcuIrqHandlerChannel1((stc_icun_t*)&ICU01, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu1].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_ICU2 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu2Channel0, INTERRUPTS_IRQ_NUMBER_164)
{
    IcuIrqHandlerChannel0((stc_icun_t*)&ICU02, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu2].stcInternData));
}
FN_IRQ_DEFINE_END()
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu2Channel1, INTERRUPTS_IRQ_NUMBER_170)
{
    IcuIrqHandlerChannel1((stc_icun_t*)&ICU02, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu2].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_ICU8 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu8Channel0, INTERRUPTS_IRQ_NUMBER_165)
{
    IcuIrqHandlerChannel0((stc_icun_t*)&ICU08, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu8].stcInternData));
}
FN_IRQ_DEFINE_END()
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu8Channel1, INTERRUPTS_IRQ_NUMBER_171)
{
    IcuIrqHandlerChannel1((stc_icun_t*)&ICU08, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu8].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_ICU9 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu9Channel0, INTERRUPTS_IRQ_NUMBER_166)
{
    IcuIrqHandlerChannel0((stc_icun_t*)&ICU09, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu9].stcInternData));
}
FN_IRQ_DEFINE_END()
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu9Channel1, INTERRUPTS_IRQ_NUMBER_172)
{
    IcuIrqHandlerChannel1((stc_icun_t*)&ICU09, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu9].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_ICU10 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu10Channel0, INTERRUPTS_IRQ_NUMBER_167)
{
    IcuIrqHandlerChannel0((stc_icun_t*)&ICU10, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu10].stcInternData));
}
FN_IRQ_DEFINE_END()
FN_IRQ_DEFINE_BEGIN(Icu_Isr_Icu10Channel1, INTERRUPTS_IRQ_NUMBER_173)
{
    IcuIrqHandlerChannel1((stc_icun_t*)&ICU10, &(m_astcIcuInstanceDataLut[IcuInstanceIndexIcu10].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#endif  // __ICU_GENERATED_C__

