/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file mfs_lin_generated.c
 **
 ** Generated file for mfs_lin.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in mfs_lin.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by mfs_lin.c automatically!
 **
 ** History:
 **   - 2014-06-26  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __MFS_LIN_GENERATED_C__
#define __MFS_LIN_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/* Macro to return the number of enabled LIN instances */
#define LIN_INSTANCE_COUNT (uint32_t)(sizeof(m_astcLinInstanceDataLut) / sizeof(m_astcLinInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/** Enumeration to define an index for each enabled LIN instance */
typedef enum en_lin_instance_index
{
    #if (PDL_PERIPHERAL_ENABLE_LIN0 == PDL_ON)
    LinInstanceIndexLin0,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN1 == PDL_ON)
    LinInstanceIndexLin1,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN2 == PDL_ON)
    LinInstanceIndexLin2,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN3 == PDL_ON)
    LinInstanceIndexLin3,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN4 == PDL_ON)
    LinInstanceIndexLin4,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN5 == PDL_ON)
    LinInstanceIndexLin5,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN6 == PDL_ON)
    LinInstanceIndexLin6,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN7 == PDL_ON)
    LinInstanceIndexLin7,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN8 == PDL_ON)
    LinInstanceIndexLin8,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN9 == PDL_ON)
    LinInstanceIndexLin9,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN10 == PDL_ON)
    LinInstanceIndexLin10,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN11 == PDL_ON)
    LinInstanceIndexLin11,
    #endif
    LinInstanceIndexMax
} en_lin_instance_index_t;

/** LIN instance data type */
typedef struct stc_lin_instance_data
{
    pstc_lin_type_t              pstcInstance;   /*!< pointer to registers of an instance */
    stc_lin_intern_data_t        stcInternData;  /*!< module internal data of instance */
} stc_lin_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/** Look-up table for all enabled LIN instances and their internal data */
static stc_lin_instance_data_t m_astcLinInstanceDataLut[LinInstanceIndexMax] =
{
    #if (PDL_PERIPHERAL_ENABLE_LIN0 == PDL_ON)
    {
         LIN0_Type,       /* pstcInstance */
         {NULL}            /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN1 == PDL_ON)
    {
         LIN1_Type,       /* pstcInstance */
         {NULL}            /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN2 == PDL_ON)
    {
         LIN2_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN3 == PDL_ON)
    {
         LIN3_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN4 == PDL_ON)
    {
         LIN4_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN5 == PDL_ON)
    {
         LIN5_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN6 == PDL_ON)
    {
         LIN6_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN7 == PDL_ON)
    {
         LIN7_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN8 == PDL_ON)
    {
         LIN8_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN9 == PDL_ON)
    {
         LIN9_Type,       /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN10 == PDL_ON)
    {
         LIN10_Type,      /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_LIN11 == PDL_ON)
    {
         LIN11_Type,      /* pstcInstance */
         {NULL}           /* stc_lin_intern_data_t */
    },
    #endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 ******************************************************************************
 ** \brief Return the internal data for a certain LIN instance.
 **
 ** \param pstcUart Pointer to LIN instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 ******************************************************************************/
static stc_lin_intern_data_t* MfsLinGetInternDataPtr(pstc_lin_type_t pstcLin)
{
    stc_lin_intern_data_t *pstcInternData = NULL;
    uint32_t               u32Instance;

    if (pstcLin != NULL)
    {
        for (u32Instance = 0; u32Instance < (uint32_t)LinInstanceIndexMax; u32Instance++)
        {
            if (pstcLin == m_astcLinInstanceDataLut[u32Instance].pstcInstance)
            {
                pstcInternData = &m_astcLinInstanceDataLut[u32Instance].stcInternData;
                break;
            }
        }
    }
    return pstcInternData;
}

/*
 * Definition of ISR for each enabled LIN instance.
 * The individual ISR calls the generic IRQ handler with
 * the instance pointer and its internal data to handle the interrupt.
 */
#if (PDL_PERIPHERAL_ENABLE_LIN0 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin0_Status, INTERRUPTS_IRQ_NUMBER_222)
{
    MfsLinIrqHandlerStatus(LIN0_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin0].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN1 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin1_Status, INTERRUPTS_IRQ_NUMBER_223)
{
    MfsLinIrqHandlerStatus(LIN1_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin1].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN2 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin2_Status, INTERRUPTS_IRQ_NUMBER_224)
{
    MfsLinIrqHandlerStatus(LIN2_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin2].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN3 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin3_Status, INTERRUPTS_IRQ_NUMBER_225)
{
    MfsLinIrqHandlerStatus(LIN3_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin3].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN4 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin4_Status, INTERRUPTS_IRQ_NUMBER_226)
{
    MfsLinIrqHandlerStatus(LIN4_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin4].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN5 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin5_Status, INTERRUPTS_IRQ_NUMBER_227)
{
    MfsLinIrqHandlerStatus(LIN5_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin5].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN6 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin6_Status, INTERRUPTS_IRQ_NUMBER_228)
{
    MfsLinIrqHandlerStatus(LIN6_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin6].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN7 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin7_Status, INTERRUPTS_IRQ_NUMBER_229)
{
    MfsLinIrqHandlerStatus(LIN7_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin7].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN8 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin8_Status, INTERRUPTS_IRQ_NUMBER_230)
{
    MfsLinIrqHandlerStatus(LIN8_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin8].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN9 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin9_Status, INTERRUPTS_IRQ_NUMBER_231)
{
    MfsLinIrqHandlerStatus(LIN9_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin9].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN10 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin10_Status, INTERRUPTS_IRQ_NUMBER_232)
{
    MfsLinIrqHandlerStatus(LIN10_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin10].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_LIN11 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Lin_Isr_Lin11_Status, INTERRUPTS_IRQ_NUMBER_233)
{
    MfsLinIrqHandlerStatus(LIN11_Type, &(m_astcLinInstanceDataLut[LinInstanceIndexLin11].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#endif  // __MFS_LIN_GENERATED_C__

