/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_BT_PWC_H
#define __S6J3360_BT_PWC_H

#include "s6j3360io_basetypes.h"

/* BT[00-31]_PWC base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT00_PWC	stcBT_PWC[0]
#define BT01_PWC	stcBT_PWC[1]
#define BT02_PWC	stcBT_PWC[2]
#define BT03_PWC	stcBT_PWC[3]
#define BT04_PWC	stcBT_PWC[4]
#define BT05_PWC	stcBT_PWC[5]
#define BT06_PWC	stcBT_PWC[6]
#define BT07_PWC	stcBT_PWC[7]
#define BT08_PWC	stcBT_PWC[8]
#define BT09_PWC	stcBT_PWC[9]
#define BT10_PWC	stcBT_PWC[10]
#define BT11_PWC	stcBT_PWC[11]
#define BT12_PWC	stcBT_PWC[12]
#define BT13_PWC	stcBT_PWC[13]
#define BT14_PWC	stcBT_PWC[14]
#define BT15_PWC	stcBT_PWC[15]
#define BT16_PWC	stcBT_PWC[16]
#define BT17_PWC	stcBT_PWC[17]
#define BT18_PWC	stcBT_PWC[18]
#define BT19_PWC	stcBT_PWC[19]
#define BT20_PWC	stcBT_PWC[20]
#define BT21_PWC	stcBT_PWC[21]
#define BT22_PWC	stcBT_PWC[22]
#define BT23_PWC	stcBT_PWC[23]
#define BT24_PWC	stcBT_PWC[24]
#define BT25_PWC	stcBT_PWC[25]
#define BT26_PWC	stcBT_PWC[26]
#define BT27_PWC	stcBT_PWC[27]
#define BT28_PWC	stcBT_PWC[28]
#define BT29_PWC	stcBT_PWC[29]
#define BT30_PWC	stcBT_PWC[30]
#define BT31_PWC	stcBT_PWC[31]
#else /* __IO_DEFINE */
#define BT00_PWC	(*((volatile stc_btn_pwc_t*)0xB4808000))
#define BT01_PWC	(*((volatile stc_btn_pwc_t*)0xB4808400))
#define BT02_PWC	(*((volatile stc_btn_pwc_t*)0xB4808800))
#define BT03_PWC	(*((volatile stc_btn_pwc_t*)0xB4808C00))
#define BT04_PWC	(*((volatile stc_btn_pwc_t*)0xB4809000))
#define BT05_PWC	(*((volatile stc_btn_pwc_t*)0xB4809400))
#define BT06_PWC	(*((volatile stc_btn_pwc_t*)0xB4809800))
#define BT07_PWC	(*((volatile stc_btn_pwc_t*)0xB4809C00))
#define BT08_PWC	(*((volatile stc_btn_pwc_t*)0xB480A000))
#define BT09_PWC	(*((volatile stc_btn_pwc_t*)0xB480A400))
#define BT10_PWC	(*((volatile stc_btn_pwc_t*)0xB480A800))
#define BT11_PWC	(*((volatile stc_btn_pwc_t*)0xB480AC00))
#define BT12_PWC	(*((volatile stc_btn_pwc_t*)0xB4888000))
#define BT13_PWC	(*((volatile stc_btn_pwc_t*)0xB4888400))
#define BT14_PWC	(*((volatile stc_btn_pwc_t*)0xB4888800))
#define BT15_PWC	(*((volatile stc_btn_pwc_t*)0xB4888C00))
#define BT16_PWC	(*((volatile stc_btn_pwc_t*)0xB4889000))
#define BT17_PWC	(*((volatile stc_btn_pwc_t*)0xB4889400))
#define BT18_PWC	(*((volatile stc_btn_pwc_t*)0xB4889800))
#define BT19_PWC	(*((volatile stc_btn_pwc_t*)0xB4889C00))
#define BT20_PWC	(*((volatile stc_btn_pwc_t*)0xB488A000))
#define BT21_PWC	(*((volatile stc_btn_pwc_t*)0xB488A400))
#define BT22_PWC	(*((volatile stc_btn_pwc_t*)0xB488A800))
#define BT23_PWC	(*((volatile stc_btn_pwc_t*)0xB488AC00))
#define BT24_PWC	(*((volatile stc_btn_pwc_t*)0xB4846000))
#define BT25_PWC	(*((volatile stc_btn_pwc_t*)0xB4846400))
#define BT26_PWC	(*((volatile stc_btn_pwc_t*)0xB4846800))
#define BT27_PWC	(*((volatile stc_btn_pwc_t*)0xB4846C00))
#define BT28_PWC	(*((volatile stc_btn_pwc_t*)0xB4847000))
#define BT29_PWC	(*((volatile stc_btn_pwc_t*)0xB4847400))
#define BT30_PWC	(*((volatile stc_btn_pwc_t*)0xB4847800))
#define BT31_PWC	(*((volatile stc_btn_pwc_t*)0xB4847C00))
#endif /* __IO_DEFINE */

/* DTBF */
#define BT00_PWC_DTBF	(BT00_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT00_PWC_DTBF_DTBF	BT00_PWC_DTBF  /*@bfrg@*/

#define BT01_PWC_DTBF	(BT01_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT01_PWC_DTBF_DTBF	BT01_PWC_DTBF  /*@bfrg@*/

#define BT02_PWC_DTBF	(BT02_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT02_PWC_DTBF_DTBF	BT02_PWC_DTBF  /*@bfrg@*/

#define BT03_PWC_DTBF	(BT03_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT03_PWC_DTBF_DTBF	BT03_PWC_DTBF  /*@bfrg@*/

#define BT04_PWC_DTBF	(BT04_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT04_PWC_DTBF_DTBF	BT04_PWC_DTBF  /*@bfrg@*/

#define BT05_PWC_DTBF	(BT05_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT05_PWC_DTBF_DTBF	BT05_PWC_DTBF  /*@bfrg@*/

#define BT06_PWC_DTBF	(BT06_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT06_PWC_DTBF_DTBF	BT06_PWC_DTBF  /*@bfrg@*/

#define BT07_PWC_DTBF	(BT07_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT07_PWC_DTBF_DTBF	BT07_PWC_DTBF  /*@bfrg@*/

#define BT08_PWC_DTBF	(BT08_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT08_PWC_DTBF_DTBF	BT08_PWC_DTBF  /*@bfrg@*/

#define BT09_PWC_DTBF	(BT09_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT09_PWC_DTBF_DTBF	BT09_PWC_DTBF  /*@bfrg@*/

#define BT10_PWC_DTBF	(BT10_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT10_PWC_DTBF_DTBF	BT10_PWC_DTBF  /*@bfrg@*/

#define BT11_PWC_DTBF	(BT11_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT11_PWC_DTBF_DTBF	BT11_PWC_DTBF  /*@bfrg@*/

#define BT12_PWC_DTBF	(BT12_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT12_PWC_DTBF_DTBF	BT12_PWC_DTBF  /*@bfrg@*/

#define BT13_PWC_DTBF	(BT13_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT13_PWC_DTBF_DTBF	BT13_PWC_DTBF  /*@bfrg@*/

#define BT14_PWC_DTBF	(BT14_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT14_PWC_DTBF_DTBF	BT14_PWC_DTBF  /*@bfrg@*/

#define BT15_PWC_DTBF	(BT15_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT15_PWC_DTBF_DTBF	BT15_PWC_DTBF  /*@bfrg@*/

#define BT16_PWC_DTBF	(BT16_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT16_PWC_DTBF_DTBF	BT16_PWC_DTBF  /*@bfrg@*/

#define BT17_PWC_DTBF	(BT17_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT17_PWC_DTBF_DTBF	BT17_PWC_DTBF  /*@bfrg@*/

#define BT18_PWC_DTBF	(BT18_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT18_PWC_DTBF_DTBF	BT18_PWC_DTBF  /*@bfrg@*/

#define BT19_PWC_DTBF	(BT19_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT19_PWC_DTBF_DTBF	BT19_PWC_DTBF  /*@bfrg@*/

#define BT20_PWC_DTBF	(BT20_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT20_PWC_DTBF_DTBF	BT20_PWC_DTBF  /*@bfrg@*/

#define BT21_PWC_DTBF	(BT21_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT21_PWC_DTBF_DTBF	BT21_PWC_DTBF  /*@bfrg@*/

#define BT22_PWC_DTBF	(BT22_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT22_PWC_DTBF_DTBF	BT22_PWC_DTBF  /*@bfrg@*/

#define BT23_PWC_DTBF	(BT23_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT23_PWC_DTBF_DTBF	BT23_PWC_DTBF  /*@bfrg@*/

#define BT24_PWC_DTBF	(BT24_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT24_PWC_DTBF_DTBF	BT24_PWC_DTBF  /*@bfrg@*/

#define BT25_PWC_DTBF	(BT25_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT25_PWC_DTBF_DTBF	BT25_PWC_DTBF  /*@bfrg@*/

#define BT26_PWC_DTBF	(BT26_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT26_PWC_DTBF_DTBF	BT26_PWC_DTBF  /*@bfrg@*/

#define BT27_PWC_DTBF	(BT27_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT27_PWC_DTBF_DTBF	BT27_PWC_DTBF  /*@bfrg@*/

#define BT28_PWC_DTBF	(BT28_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT28_PWC_DTBF_DTBF	BT28_PWC_DTBF  /*@bfrg@*/

#define BT29_PWC_DTBF	(BT29_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT29_PWC_DTBF_DTBF	BT29_PWC_DTBF  /*@bfrg@*/

#define BT30_PWC_DTBF	(BT30_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT30_PWC_DTBF_DTBF	BT30_PWC_DTBF  /*@bfrg@*/

#define BT31_PWC_DTBF	(BT31_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT31_PWC_DTBF_DTBF	BT31_PWC_DTBF  /*@bfrg@*/

typedef union un_btn_pwc_dtbf{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwc_dtbf_t;

/* TMCR */
#define BT00_PWC_TMCR	(BT00_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT00_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7840061)  /*@bfbba@*/
#define BT00_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7840062)  /*@bfbba@*/
#define BT00_PWC_TMCR_FMD	(BT00_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT00_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7840067)  /*@bfbba@*/
#define BT00_PWC_TMCR_EGS	(BT00_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT00_PWC_TMCR_CKS2_0	(BT00_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT01_PWC_TMCR	(BT01_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT01_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7842061)  /*@bfbba@*/
#define BT01_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7842062)  /*@bfbba@*/
#define BT01_PWC_TMCR_FMD	(BT01_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT01_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7842067)  /*@bfbba@*/
#define BT01_PWC_TMCR_EGS	(BT01_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT01_PWC_TMCR_CKS2_0	(BT01_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT02_PWC_TMCR	(BT02_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT02_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7844061)  /*@bfbba@*/
#define BT02_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7844062)  /*@bfbba@*/
#define BT02_PWC_TMCR_FMD	(BT02_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT02_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7844067)  /*@bfbba@*/
#define BT02_PWC_TMCR_EGS	(BT02_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT02_PWC_TMCR_CKS2_0	(BT02_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT03_PWC_TMCR	(BT03_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT03_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7846061)  /*@bfbba@*/
#define BT03_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7846062)  /*@bfbba@*/
#define BT03_PWC_TMCR_FMD	(BT03_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT03_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7846067)  /*@bfbba@*/
#define BT03_PWC_TMCR_EGS	(BT03_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT03_PWC_TMCR_CKS2_0	(BT03_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT04_PWC_TMCR	(BT04_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT04_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7848061)  /*@bfbba@*/
#define BT04_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7848062)  /*@bfbba@*/
#define BT04_PWC_TMCR_FMD	(BT04_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT04_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7848067)  /*@bfbba@*/
#define BT04_PWC_TMCR_EGS	(BT04_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT04_PWC_TMCR_CKS2_0	(BT04_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT05_PWC_TMCR	(BT05_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT05_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB784A061)  /*@bfbba@*/
#define BT05_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB784A062)  /*@bfbba@*/
#define BT05_PWC_TMCR_FMD	(BT05_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT05_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB784A067)  /*@bfbba@*/
#define BT05_PWC_TMCR_EGS	(BT05_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT05_PWC_TMCR_CKS2_0	(BT05_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT06_PWC_TMCR	(BT06_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT06_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB784C061)  /*@bfbba@*/
#define BT06_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB784C062)  /*@bfbba@*/
#define BT06_PWC_TMCR_FMD	(BT06_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT06_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB784C067)  /*@bfbba@*/
#define BT06_PWC_TMCR_EGS	(BT06_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT06_PWC_TMCR_CKS2_0	(BT06_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT07_PWC_TMCR	(BT07_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT07_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB784E061)  /*@bfbba@*/
#define BT07_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB784E062)  /*@bfbba@*/
#define BT07_PWC_TMCR_FMD	(BT07_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT07_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB784E067)  /*@bfbba@*/
#define BT07_PWC_TMCR_EGS	(BT07_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT07_PWC_TMCR_CKS2_0	(BT07_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT08_PWC_TMCR	(BT08_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT08_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7850061)  /*@bfbba@*/
#define BT08_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7850062)  /*@bfbba@*/
#define BT08_PWC_TMCR_FMD	(BT08_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT08_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7850067)  /*@bfbba@*/
#define BT08_PWC_TMCR_EGS	(BT08_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT08_PWC_TMCR_CKS2_0	(BT08_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT09_PWC_TMCR	(BT09_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT09_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7852061)  /*@bfbba@*/
#define BT09_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7852062)  /*@bfbba@*/
#define BT09_PWC_TMCR_FMD	(BT09_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT09_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7852067)  /*@bfbba@*/
#define BT09_PWC_TMCR_EGS	(BT09_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT09_PWC_TMCR_CKS2_0	(BT09_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT10_PWC_TMCR	(BT10_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT10_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7854061)  /*@bfbba@*/
#define BT10_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7854062)  /*@bfbba@*/
#define BT10_PWC_TMCR_FMD	(BT10_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT10_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7854067)  /*@bfbba@*/
#define BT10_PWC_TMCR_EGS	(BT10_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT10_PWC_TMCR_CKS2_0	(BT10_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT11_PWC_TMCR	(BT11_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT11_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7856061)  /*@bfbba@*/
#define BT11_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7856062)  /*@bfbba@*/
#define BT11_PWC_TMCR_FMD	(BT11_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT11_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7856067)  /*@bfbba@*/
#define BT11_PWC_TMCR_EGS	(BT11_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT11_PWC_TMCR_CKS2_0	(BT11_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT12_PWC_TMCR	(BT12_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT12_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C40061)  /*@bfbba@*/
#define BT12_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C40062)  /*@bfbba@*/
#define BT12_PWC_TMCR_FMD	(BT12_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT12_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C40067)  /*@bfbba@*/
#define BT12_PWC_TMCR_EGS	(BT12_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT12_PWC_TMCR_CKS2_0	(BT12_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT13_PWC_TMCR	(BT13_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT13_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C42061)  /*@bfbba@*/
#define BT13_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C42062)  /*@bfbba@*/
#define BT13_PWC_TMCR_FMD	(BT13_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT13_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C42067)  /*@bfbba@*/
#define BT13_PWC_TMCR_EGS	(BT13_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT13_PWC_TMCR_CKS2_0	(BT13_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT14_PWC_TMCR	(BT14_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT14_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C44061)  /*@bfbba@*/
#define BT14_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C44062)  /*@bfbba@*/
#define BT14_PWC_TMCR_FMD	(BT14_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT14_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C44067)  /*@bfbba@*/
#define BT14_PWC_TMCR_EGS	(BT14_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT14_PWC_TMCR_CKS2_0	(BT14_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT15_PWC_TMCR	(BT15_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT15_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C46061)  /*@bfbba@*/
#define BT15_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C46062)  /*@bfbba@*/
#define BT15_PWC_TMCR_FMD	(BT15_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT15_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C46067)  /*@bfbba@*/
#define BT15_PWC_TMCR_EGS	(BT15_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT15_PWC_TMCR_CKS2_0	(BT15_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT16_PWC_TMCR	(BT16_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT16_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C48061)  /*@bfbba@*/
#define BT16_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C48062)  /*@bfbba@*/
#define BT16_PWC_TMCR_FMD	(BT16_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT16_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C48067)  /*@bfbba@*/
#define BT16_PWC_TMCR_EGS	(BT16_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT16_PWC_TMCR_CKS2_0	(BT16_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT17_PWC_TMCR	(BT17_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT17_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C4A061)  /*@bfbba@*/
#define BT17_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C4A062)  /*@bfbba@*/
#define BT17_PWC_TMCR_FMD	(BT17_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT17_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C4A067)  /*@bfbba@*/
#define BT17_PWC_TMCR_EGS	(BT17_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT17_PWC_TMCR_CKS2_0	(BT17_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT18_PWC_TMCR	(BT18_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT18_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C4C061)  /*@bfbba@*/
#define BT18_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C4C062)  /*@bfbba@*/
#define BT18_PWC_TMCR_FMD	(BT18_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT18_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C4C067)  /*@bfbba@*/
#define BT18_PWC_TMCR_EGS	(BT18_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT18_PWC_TMCR_CKS2_0	(BT18_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT19_PWC_TMCR	(BT19_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT19_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C4E061)  /*@bfbba@*/
#define BT19_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C4E062)  /*@bfbba@*/
#define BT19_PWC_TMCR_FMD	(BT19_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT19_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C4E067)  /*@bfbba@*/
#define BT19_PWC_TMCR_EGS	(BT19_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT19_PWC_TMCR_CKS2_0	(BT19_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT20_PWC_TMCR	(BT20_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT20_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C50061)  /*@bfbba@*/
#define BT20_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C50062)  /*@bfbba@*/
#define BT20_PWC_TMCR_FMD	(BT20_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT20_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C50067)  /*@bfbba@*/
#define BT20_PWC_TMCR_EGS	(BT20_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT20_PWC_TMCR_CKS2_0	(BT20_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT21_PWC_TMCR	(BT21_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT21_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C52061)  /*@bfbba@*/
#define BT21_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C52062)  /*@bfbba@*/
#define BT21_PWC_TMCR_FMD	(BT21_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT21_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C52067)  /*@bfbba@*/
#define BT21_PWC_TMCR_EGS	(BT21_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT21_PWC_TMCR_CKS2_0	(BT21_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT22_PWC_TMCR	(BT22_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT22_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C54061)  /*@bfbba@*/
#define BT22_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C54062)  /*@bfbba@*/
#define BT22_PWC_TMCR_FMD	(BT22_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT22_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C54067)  /*@bfbba@*/
#define BT22_PWC_TMCR_EGS	(BT22_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT22_PWC_TMCR_CKS2_0	(BT22_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT23_PWC_TMCR	(BT23_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT23_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7C56061)  /*@bfbba@*/
#define BT23_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7C56062)  /*@bfbba@*/
#define BT23_PWC_TMCR_FMD	(BT23_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT23_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7C56067)  /*@bfbba@*/
#define BT23_PWC_TMCR_EGS	(BT23_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT23_PWC_TMCR_CKS2_0	(BT23_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT24_PWC_TMCR	(BT24_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT24_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A30061)  /*@bfbba@*/
#define BT24_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A30062)  /*@bfbba@*/
#define BT24_PWC_TMCR_FMD	(BT24_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT24_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A30067)  /*@bfbba@*/
#define BT24_PWC_TMCR_EGS	(BT24_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT24_PWC_TMCR_CKS2_0	(BT24_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT25_PWC_TMCR	(BT25_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT25_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A32061)  /*@bfbba@*/
#define BT25_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A32062)  /*@bfbba@*/
#define BT25_PWC_TMCR_FMD	(BT25_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT25_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A32067)  /*@bfbba@*/
#define BT25_PWC_TMCR_EGS	(BT25_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT25_PWC_TMCR_CKS2_0	(BT25_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT26_PWC_TMCR	(BT26_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT26_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A34061)  /*@bfbba@*/
#define BT26_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A34062)  /*@bfbba@*/
#define BT26_PWC_TMCR_FMD	(BT26_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT26_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A34067)  /*@bfbba@*/
#define BT26_PWC_TMCR_EGS	(BT26_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT26_PWC_TMCR_CKS2_0	(BT26_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT27_PWC_TMCR	(BT27_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT27_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A36061)  /*@bfbba@*/
#define BT27_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A36062)  /*@bfbba@*/
#define BT27_PWC_TMCR_FMD	(BT27_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT27_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A36067)  /*@bfbba@*/
#define BT27_PWC_TMCR_EGS	(BT27_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT27_PWC_TMCR_CKS2_0	(BT27_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT28_PWC_TMCR	(BT28_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT28_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A38061)  /*@bfbba@*/
#define BT28_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A38062)  /*@bfbba@*/
#define BT28_PWC_TMCR_FMD	(BT28_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT28_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A38067)  /*@bfbba@*/
#define BT28_PWC_TMCR_EGS	(BT28_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT28_PWC_TMCR_CKS2_0	(BT28_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT29_PWC_TMCR	(BT29_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT29_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A3A061)  /*@bfbba@*/
#define BT29_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A3A062)  /*@bfbba@*/
#define BT29_PWC_TMCR_FMD	(BT29_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT29_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A3A067)  /*@bfbba@*/
#define BT29_PWC_TMCR_EGS	(BT29_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT29_PWC_TMCR_CKS2_0	(BT29_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT30_PWC_TMCR	(BT30_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT30_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A3C061)  /*@bfbba@*/
#define BT30_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A3C062)  /*@bfbba@*/
#define BT30_PWC_TMCR_FMD	(BT30_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT30_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A3C067)  /*@bfbba@*/
#define BT30_PWC_TMCR_EGS	(BT30_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT30_PWC_TMCR_CKS2_0	(BT30_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT31_PWC_TMCR	(BT31_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT31_PWC_TMCR_CTEN	(*(volatile uint_io8_t*)0xB7A3E061)  /*@bfbba@*/
#define BT31_PWC_TMCR_MDSE	(*(volatile uint_io8_t*)0xB7A3E062)  /*@bfbba@*/
#define BT31_PWC_TMCR_FMD	(BT31_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT31_PWC_TMCR_T32	(*(volatile uint_io8_t*)0xB7A3E067)  /*@bfbba@*/
#define BT31_PWC_TMCR_EGS	(BT31_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT31_PWC_TMCR_CKS2_0	(BT31_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

typedef struct stc_btn_pwc_tmcr_field{
    uint_io16_t		:1;
    uint_io16_t		u1CTEN:1;
    uint_io16_t		u1MDSE:1;
    uint_io16_t		:1;
    uint_io16_t		u3FMD:3;
    uint_io16_t		u1T32:1;
    uint_io16_t		u3EGS:3;
    uint_io16_t		:1;
    uint_io16_t		u3CKS2_0:3;
    uint_io16_t		:1;
}stc_btn_pwc_tmcr_field_t;

typedef union un_btn_pwc_tmcr{
    uint_io16_t		u16Register;
    stc_btn_pwc_tmcr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_pwc_tmcr_t;

/* STC */
#define BT00_PWC_STC	(BT00_PWC.unSTC.u8Register)  /*@rg@*/
#define BT00_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7840080)  /*@bfbba@*/
#define BT00_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7840082)  /*@bfbba@*/
#define BT00_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7840084)  /*@bfbba@*/
#define BT00_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7840086)  /*@bfbba@*/
#define BT00_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7840087)  /*@bfbba@*/

#define BT01_PWC_STC	(BT01_PWC.unSTC.u8Register)  /*@rg@*/
#define BT01_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7842080)  /*@bfbba@*/
#define BT01_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7842082)  /*@bfbba@*/
#define BT01_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7842084)  /*@bfbba@*/
#define BT01_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7842086)  /*@bfbba@*/
#define BT01_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7842087)  /*@bfbba@*/

#define BT02_PWC_STC	(BT02_PWC.unSTC.u8Register)  /*@rg@*/
#define BT02_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7844080)  /*@bfbba@*/
#define BT02_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7844082)  /*@bfbba@*/
#define BT02_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7844084)  /*@bfbba@*/
#define BT02_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7844086)  /*@bfbba@*/
#define BT02_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7844087)  /*@bfbba@*/

#define BT03_PWC_STC	(BT03_PWC.unSTC.u8Register)  /*@rg@*/
#define BT03_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7846080)  /*@bfbba@*/
#define BT03_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7846082)  /*@bfbba@*/
#define BT03_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7846084)  /*@bfbba@*/
#define BT03_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7846086)  /*@bfbba@*/
#define BT03_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7846087)  /*@bfbba@*/

#define BT04_PWC_STC	(BT04_PWC.unSTC.u8Register)  /*@rg@*/
#define BT04_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7848080)  /*@bfbba@*/
#define BT04_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7848082)  /*@bfbba@*/
#define BT04_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7848084)  /*@bfbba@*/
#define BT04_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7848086)  /*@bfbba@*/
#define BT04_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7848087)  /*@bfbba@*/

#define BT05_PWC_STC	(BT05_PWC.unSTC.u8Register)  /*@rg@*/
#define BT05_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB784A080)  /*@bfbba@*/
#define BT05_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB784A082)  /*@bfbba@*/
#define BT05_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB784A084)  /*@bfbba@*/
#define BT05_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB784A086)  /*@bfbba@*/
#define BT05_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB784A087)  /*@bfbba@*/

#define BT06_PWC_STC	(BT06_PWC.unSTC.u8Register)  /*@rg@*/
#define BT06_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB784C080)  /*@bfbba@*/
#define BT06_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB784C082)  /*@bfbba@*/
#define BT06_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB784C084)  /*@bfbba@*/
#define BT06_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB784C086)  /*@bfbba@*/
#define BT06_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB784C087)  /*@bfbba@*/

#define BT07_PWC_STC	(BT07_PWC.unSTC.u8Register)  /*@rg@*/
#define BT07_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB784E080)  /*@bfbba@*/
#define BT07_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB784E082)  /*@bfbba@*/
#define BT07_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB784E084)  /*@bfbba@*/
#define BT07_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB784E086)  /*@bfbba@*/
#define BT07_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB784E087)  /*@bfbba@*/

#define BT08_PWC_STC	(BT08_PWC.unSTC.u8Register)  /*@rg@*/
#define BT08_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7850080)  /*@bfbba@*/
#define BT08_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7850082)  /*@bfbba@*/
#define BT08_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7850084)  /*@bfbba@*/
#define BT08_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7850086)  /*@bfbba@*/
#define BT08_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7850087)  /*@bfbba@*/

#define BT09_PWC_STC	(BT09_PWC.unSTC.u8Register)  /*@rg@*/
#define BT09_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7852080)  /*@bfbba@*/
#define BT09_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7852082)  /*@bfbba@*/
#define BT09_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7852084)  /*@bfbba@*/
#define BT09_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7852086)  /*@bfbba@*/
#define BT09_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7852087)  /*@bfbba@*/

#define BT10_PWC_STC	(BT10_PWC.unSTC.u8Register)  /*@rg@*/
#define BT10_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7854080)  /*@bfbba@*/
#define BT10_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7854082)  /*@bfbba@*/
#define BT10_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7854084)  /*@bfbba@*/
#define BT10_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7854086)  /*@bfbba@*/
#define BT10_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7854087)  /*@bfbba@*/

#define BT11_PWC_STC	(BT11_PWC.unSTC.u8Register)  /*@rg@*/
#define BT11_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7856080)  /*@bfbba@*/
#define BT11_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7856082)  /*@bfbba@*/
#define BT11_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7856084)  /*@bfbba@*/
#define BT11_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7856086)  /*@bfbba@*/
#define BT11_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7856087)  /*@bfbba@*/

#define BT12_PWC_STC	(BT12_PWC.unSTC.u8Register)  /*@rg@*/
#define BT12_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C40080)  /*@bfbba@*/
#define BT12_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C40082)  /*@bfbba@*/
#define BT12_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C40084)  /*@bfbba@*/
#define BT12_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C40086)  /*@bfbba@*/
#define BT12_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C40087)  /*@bfbba@*/

#define BT13_PWC_STC	(BT13_PWC.unSTC.u8Register)  /*@rg@*/
#define BT13_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C42080)  /*@bfbba@*/
#define BT13_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C42082)  /*@bfbba@*/
#define BT13_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C42084)  /*@bfbba@*/
#define BT13_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C42086)  /*@bfbba@*/
#define BT13_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C42087)  /*@bfbba@*/

#define BT14_PWC_STC	(BT14_PWC.unSTC.u8Register)  /*@rg@*/
#define BT14_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C44080)  /*@bfbba@*/
#define BT14_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C44082)  /*@bfbba@*/
#define BT14_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C44084)  /*@bfbba@*/
#define BT14_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C44086)  /*@bfbba@*/
#define BT14_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C44087)  /*@bfbba@*/

#define BT15_PWC_STC	(BT15_PWC.unSTC.u8Register)  /*@rg@*/
#define BT15_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C46080)  /*@bfbba@*/
#define BT15_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C46082)  /*@bfbba@*/
#define BT15_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C46084)  /*@bfbba@*/
#define BT15_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C46086)  /*@bfbba@*/
#define BT15_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C46087)  /*@bfbba@*/

#define BT16_PWC_STC	(BT16_PWC.unSTC.u8Register)  /*@rg@*/
#define BT16_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C48080)  /*@bfbba@*/
#define BT16_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C48082)  /*@bfbba@*/
#define BT16_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C48084)  /*@bfbba@*/
#define BT16_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C48086)  /*@bfbba@*/
#define BT16_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C48087)  /*@bfbba@*/

#define BT17_PWC_STC	(BT17_PWC.unSTC.u8Register)  /*@rg@*/
#define BT17_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C4A080)  /*@bfbba@*/
#define BT17_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C4A082)  /*@bfbba@*/
#define BT17_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C4A084)  /*@bfbba@*/
#define BT17_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C4A086)  /*@bfbba@*/
#define BT17_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C4A087)  /*@bfbba@*/

#define BT18_PWC_STC	(BT18_PWC.unSTC.u8Register)  /*@rg@*/
#define BT18_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C4C080)  /*@bfbba@*/
#define BT18_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C4C082)  /*@bfbba@*/
#define BT18_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C4C084)  /*@bfbba@*/
#define BT18_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C4C086)  /*@bfbba@*/
#define BT18_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C4C087)  /*@bfbba@*/

#define BT19_PWC_STC	(BT19_PWC.unSTC.u8Register)  /*@rg@*/
#define BT19_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C4E080)  /*@bfbba@*/
#define BT19_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C4E082)  /*@bfbba@*/
#define BT19_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C4E084)  /*@bfbba@*/
#define BT19_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C4E086)  /*@bfbba@*/
#define BT19_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C4E087)  /*@bfbba@*/

#define BT20_PWC_STC	(BT20_PWC.unSTC.u8Register)  /*@rg@*/
#define BT20_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C50080)  /*@bfbba@*/
#define BT20_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C50082)  /*@bfbba@*/
#define BT20_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C50084)  /*@bfbba@*/
#define BT20_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C50086)  /*@bfbba@*/
#define BT20_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C50087)  /*@bfbba@*/

#define BT21_PWC_STC	(BT21_PWC.unSTC.u8Register)  /*@rg@*/
#define BT21_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C52080)  /*@bfbba@*/
#define BT21_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C52082)  /*@bfbba@*/
#define BT21_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C52084)  /*@bfbba@*/
#define BT21_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C52086)  /*@bfbba@*/
#define BT21_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C52087)  /*@bfbba@*/

#define BT22_PWC_STC	(BT22_PWC.unSTC.u8Register)  /*@rg@*/
#define BT22_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C54080)  /*@bfbba@*/
#define BT22_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C54082)  /*@bfbba@*/
#define BT22_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C54084)  /*@bfbba@*/
#define BT22_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C54086)  /*@bfbba@*/
#define BT22_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C54087)  /*@bfbba@*/

#define BT23_PWC_STC	(BT23_PWC.unSTC.u8Register)  /*@rg@*/
#define BT23_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7C56080)  /*@bfbba@*/
#define BT23_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7C56082)  /*@bfbba@*/
#define BT23_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7C56084)  /*@bfbba@*/
#define BT23_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7C56086)  /*@bfbba@*/
#define BT23_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7C56087)  /*@bfbba@*/

#define BT24_PWC_STC	(BT24_PWC.unSTC.u8Register)  /*@rg@*/
#define BT24_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A30080)  /*@bfbba@*/
#define BT24_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A30082)  /*@bfbba@*/
#define BT24_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A30084)  /*@bfbba@*/
#define BT24_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A30086)  /*@bfbba@*/
#define BT24_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A30087)  /*@bfbba@*/

#define BT25_PWC_STC	(BT25_PWC.unSTC.u8Register)  /*@rg@*/
#define BT25_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A32080)  /*@bfbba@*/
#define BT25_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A32082)  /*@bfbba@*/
#define BT25_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A32084)  /*@bfbba@*/
#define BT25_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A32086)  /*@bfbba@*/
#define BT25_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A32087)  /*@bfbba@*/

#define BT26_PWC_STC	(BT26_PWC.unSTC.u8Register)  /*@rg@*/
#define BT26_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A34080)  /*@bfbba@*/
#define BT26_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A34082)  /*@bfbba@*/
#define BT26_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A34084)  /*@bfbba@*/
#define BT26_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A34086)  /*@bfbba@*/
#define BT26_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A34087)  /*@bfbba@*/

#define BT27_PWC_STC	(BT27_PWC.unSTC.u8Register)  /*@rg@*/
#define BT27_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A36080)  /*@bfbba@*/
#define BT27_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A36082)  /*@bfbba@*/
#define BT27_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A36084)  /*@bfbba@*/
#define BT27_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A36086)  /*@bfbba@*/
#define BT27_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A36087)  /*@bfbba@*/

#define BT28_PWC_STC	(BT28_PWC.unSTC.u8Register)  /*@rg@*/
#define BT28_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A38080)  /*@bfbba@*/
#define BT28_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A38082)  /*@bfbba@*/
#define BT28_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A38084)  /*@bfbba@*/
#define BT28_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A38086)  /*@bfbba@*/
#define BT28_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A38087)  /*@bfbba@*/

#define BT29_PWC_STC	(BT29_PWC.unSTC.u8Register)  /*@rg@*/
#define BT29_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A3A080)  /*@bfbba@*/
#define BT29_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A3A082)  /*@bfbba@*/
#define BT29_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A3A084)  /*@bfbba@*/
#define BT29_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A3A086)  /*@bfbba@*/
#define BT29_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A3A087)  /*@bfbba@*/

#define BT30_PWC_STC	(BT30_PWC.unSTC.u8Register)  /*@rg@*/
#define BT30_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A3C080)  /*@bfbba@*/
#define BT30_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A3C082)  /*@bfbba@*/
#define BT30_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A3C084)  /*@bfbba@*/
#define BT30_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A3C086)  /*@bfbba@*/
#define BT30_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A3C087)  /*@bfbba@*/

#define BT31_PWC_STC	(BT31_PWC.unSTC.u8Register)  /*@rg@*/
#define BT31_PWC_STC_OVIR	(*(volatile uint_io8_t*)0xB7A3E080)  /*@bfbba@*/
#define BT31_PWC_STC_EDIR	(*(volatile uint_io8_t*)0xB7A3E082)  /*@bfbba@*/
#define BT31_PWC_STC_OVIE	(*(volatile uint_io8_t*)0xB7A3E084)  /*@bfbba@*/
#define BT31_PWC_STC_EDIE	(*(volatile uint_io8_t*)0xB7A3E086)  /*@bfbba@*/
#define BT31_PWC_STC_ERR	(*(volatile uint_io8_t*)0xB7A3E087)  /*@bfbba@*/

typedef struct stc_btn_pwc_stc_field{
    uint_io8_t		u1OVIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1OVIE:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIE:1;
    uint_io8_t		u1ERR:1;
}stc_btn_pwc_stc_field_t;

typedef union un_btn_pwc_stc{
    uint_io8_t		u8Register;
    stc_btn_pwc_stc_field_t		stcField;
}un_btn_pwc_stc_t;

/* TMCR2 */
#define BT00_PWC_TMCR2	(BT00_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT00_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7840088)  /*@bfbba@*/

#define BT01_PWC_TMCR2	(BT01_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT01_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7842088)  /*@bfbba@*/

#define BT02_PWC_TMCR2	(BT02_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT02_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7844088)  /*@bfbba@*/

#define BT03_PWC_TMCR2	(BT03_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT03_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7846088)  /*@bfbba@*/

#define BT04_PWC_TMCR2	(BT04_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT04_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7848088)  /*@bfbba@*/

#define BT05_PWC_TMCR2	(BT05_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT05_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB784A088)  /*@bfbba@*/

#define BT06_PWC_TMCR2	(BT06_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT06_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB784C088)  /*@bfbba@*/

#define BT07_PWC_TMCR2	(BT07_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT07_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB784E088)  /*@bfbba@*/

#define BT08_PWC_TMCR2	(BT08_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT08_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7850088)  /*@bfbba@*/

#define BT09_PWC_TMCR2	(BT09_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT09_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7852088)  /*@bfbba@*/

#define BT10_PWC_TMCR2	(BT10_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT10_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7854088)  /*@bfbba@*/

#define BT11_PWC_TMCR2	(BT11_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT11_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7856088)  /*@bfbba@*/

#define BT12_PWC_TMCR2	(BT12_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT12_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C40088)  /*@bfbba@*/

#define BT13_PWC_TMCR2	(BT13_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT13_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C42088)  /*@bfbba@*/

#define BT14_PWC_TMCR2	(BT14_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT14_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C44088)  /*@bfbba@*/

#define BT15_PWC_TMCR2	(BT15_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT15_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C46088)  /*@bfbba@*/

#define BT16_PWC_TMCR2	(BT16_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT16_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C48088)  /*@bfbba@*/

#define BT17_PWC_TMCR2	(BT17_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT17_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C4A088)  /*@bfbba@*/

#define BT18_PWC_TMCR2	(BT18_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT18_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C4C088)  /*@bfbba@*/

#define BT19_PWC_TMCR2	(BT19_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT19_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C4E088)  /*@bfbba@*/

#define BT20_PWC_TMCR2	(BT20_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT20_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C50088)  /*@bfbba@*/

#define BT21_PWC_TMCR2	(BT21_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT21_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C52088)  /*@bfbba@*/

#define BT22_PWC_TMCR2	(BT22_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT22_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C54088)  /*@bfbba@*/

#define BT23_PWC_TMCR2	(BT23_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT23_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7C56088)  /*@bfbba@*/

#define BT24_PWC_TMCR2	(BT24_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT24_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A30088)  /*@bfbba@*/

#define BT25_PWC_TMCR2	(BT25_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT25_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A32088)  /*@bfbba@*/

#define BT26_PWC_TMCR2	(BT26_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT26_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A34088)  /*@bfbba@*/

#define BT27_PWC_TMCR2	(BT27_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT27_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A36088)  /*@bfbba@*/

#define BT28_PWC_TMCR2	(BT28_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT28_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A38088)  /*@bfbba@*/

#define BT29_PWC_TMCR2	(BT29_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT29_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A3A088)  /*@bfbba@*/

#define BT30_PWC_TMCR2	(BT30_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT30_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A3C088)  /*@bfbba@*/

#define BT31_PWC_TMCR2	(BT31_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT31_PWC_TMCR2_CKS3	(*(volatile uint_io8_t*)0xB7A3E088)  /*@bfbba@*/

typedef struct stc_btn_pwc_tmcr2_field{
    uint_io8_t		u1CKS3:1;
    uint_io8_t		:7;
}stc_btn_pwc_tmcr2_field_t;

typedef union un_btn_pwc_tmcr2{
    uint_io8_t		u8Register;
    stc_btn_pwc_tmcr2_field_t		stcField;
}un_btn_pwc_tmcr2_t;

/* STCC */
#define BT00_PWC_STCC	(BT00_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT00_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78400A0)  /*@bfbba@*/
#define BT00_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78400A4)  /*@bfbba@*/
#define BT00_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78400A6)  /*@bfbba@*/

#define BT01_PWC_STCC	(BT01_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT01_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78420A0)  /*@bfbba@*/
#define BT01_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78420A4)  /*@bfbba@*/
#define BT01_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78420A6)  /*@bfbba@*/

#define BT02_PWC_STCC	(BT02_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT02_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78440A0)  /*@bfbba@*/
#define BT02_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78440A4)  /*@bfbba@*/
#define BT02_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78440A6)  /*@bfbba@*/

#define BT03_PWC_STCC	(BT03_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT03_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78460A0)  /*@bfbba@*/
#define BT03_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78460A4)  /*@bfbba@*/
#define BT03_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78460A6)  /*@bfbba@*/

#define BT04_PWC_STCC	(BT04_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT04_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78480A0)  /*@bfbba@*/
#define BT04_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78480A4)  /*@bfbba@*/
#define BT04_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78480A6)  /*@bfbba@*/

#define BT05_PWC_STCC	(BT05_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT05_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB784A0A0)  /*@bfbba@*/
#define BT05_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB784A0A4)  /*@bfbba@*/
#define BT05_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB784A0A6)  /*@bfbba@*/

#define BT06_PWC_STCC	(BT06_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT06_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB784C0A0)  /*@bfbba@*/
#define BT06_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB784C0A4)  /*@bfbba@*/
#define BT06_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB784C0A6)  /*@bfbba@*/

#define BT07_PWC_STCC	(BT07_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT07_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB784E0A0)  /*@bfbba@*/
#define BT07_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB784E0A4)  /*@bfbba@*/
#define BT07_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB784E0A6)  /*@bfbba@*/

#define BT08_PWC_STCC	(BT08_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT08_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78500A0)  /*@bfbba@*/
#define BT08_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78500A4)  /*@bfbba@*/
#define BT08_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78500A6)  /*@bfbba@*/

#define BT09_PWC_STCC	(BT09_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT09_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78520A0)  /*@bfbba@*/
#define BT09_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78520A4)  /*@bfbba@*/
#define BT09_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78520A6)  /*@bfbba@*/

#define BT10_PWC_STCC	(BT10_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT10_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78540A0)  /*@bfbba@*/
#define BT10_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78540A4)  /*@bfbba@*/
#define BT10_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78540A6)  /*@bfbba@*/

#define BT11_PWC_STCC	(BT11_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT11_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB78560A0)  /*@bfbba@*/
#define BT11_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB78560A4)  /*@bfbba@*/
#define BT11_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB78560A6)  /*@bfbba@*/

#define BT12_PWC_STCC	(BT12_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT12_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C400A0)  /*@bfbba@*/
#define BT12_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C400A4)  /*@bfbba@*/
#define BT12_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C400A6)  /*@bfbba@*/

#define BT13_PWC_STCC	(BT13_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT13_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C420A0)  /*@bfbba@*/
#define BT13_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C420A4)  /*@bfbba@*/
#define BT13_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C420A6)  /*@bfbba@*/

#define BT14_PWC_STCC	(BT14_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT14_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C440A0)  /*@bfbba@*/
#define BT14_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C440A4)  /*@bfbba@*/
#define BT14_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C440A6)  /*@bfbba@*/

#define BT15_PWC_STCC	(BT15_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT15_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C460A0)  /*@bfbba@*/
#define BT15_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C460A4)  /*@bfbba@*/
#define BT15_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C460A6)  /*@bfbba@*/

#define BT16_PWC_STCC	(BT16_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT16_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C480A0)  /*@bfbba@*/
#define BT16_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C480A4)  /*@bfbba@*/
#define BT16_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C480A6)  /*@bfbba@*/

#define BT17_PWC_STCC	(BT17_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT17_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C4A0A0)  /*@bfbba@*/
#define BT17_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C4A0A4)  /*@bfbba@*/
#define BT17_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C4A0A6)  /*@bfbba@*/

#define BT18_PWC_STCC	(BT18_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT18_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C4C0A0)  /*@bfbba@*/
#define BT18_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C4C0A4)  /*@bfbba@*/
#define BT18_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C4C0A6)  /*@bfbba@*/

#define BT19_PWC_STCC	(BT19_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT19_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C4E0A0)  /*@bfbba@*/
#define BT19_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C4E0A4)  /*@bfbba@*/
#define BT19_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C4E0A6)  /*@bfbba@*/

#define BT20_PWC_STCC	(BT20_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT20_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C500A0)  /*@bfbba@*/
#define BT20_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C500A4)  /*@bfbba@*/
#define BT20_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C500A6)  /*@bfbba@*/

#define BT21_PWC_STCC	(BT21_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT21_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C520A0)  /*@bfbba@*/
#define BT21_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C520A4)  /*@bfbba@*/
#define BT21_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C520A6)  /*@bfbba@*/

#define BT22_PWC_STCC	(BT22_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT22_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C540A0)  /*@bfbba@*/
#define BT22_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C540A4)  /*@bfbba@*/
#define BT22_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C540A6)  /*@bfbba@*/

#define BT23_PWC_STCC	(BT23_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT23_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7C560A0)  /*@bfbba@*/
#define BT23_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7C560A4)  /*@bfbba@*/
#define BT23_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7C560A6)  /*@bfbba@*/

#define BT24_PWC_STCC	(BT24_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT24_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A300A0)  /*@bfbba@*/
#define BT24_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A300A4)  /*@bfbba@*/
#define BT24_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A300A6)  /*@bfbba@*/

#define BT25_PWC_STCC	(BT25_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT25_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A320A0)  /*@bfbba@*/
#define BT25_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A320A4)  /*@bfbba@*/
#define BT25_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A320A6)  /*@bfbba@*/

#define BT26_PWC_STCC	(BT26_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT26_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A340A0)  /*@bfbba@*/
#define BT26_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A340A4)  /*@bfbba@*/
#define BT26_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A340A6)  /*@bfbba@*/

#define BT27_PWC_STCC	(BT27_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT27_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A360A0)  /*@bfbba@*/
#define BT27_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A360A4)  /*@bfbba@*/
#define BT27_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A360A6)  /*@bfbba@*/

#define BT28_PWC_STCC	(BT28_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT28_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A380A0)  /*@bfbba@*/
#define BT28_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A380A4)  /*@bfbba@*/
#define BT28_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A380A6)  /*@bfbba@*/

#define BT29_PWC_STCC	(BT29_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT29_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A3A0A0)  /*@bfbba@*/
#define BT29_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A3A0A4)  /*@bfbba@*/
#define BT29_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A3A0A6)  /*@bfbba@*/

#define BT30_PWC_STCC	(BT30_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT30_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A3C0A0)  /*@bfbba@*/
#define BT30_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A3C0A4)  /*@bfbba@*/
#define BT30_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A3C0A6)  /*@bfbba@*/

#define BT31_PWC_STCC	(BT31_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT31_PWC_STCC_OVIRC	(*(volatile uint_io8_t*)0xB7A3E0A0)  /*@bfbba@*/
#define BT31_PWC_STCC_OVIEC	(*(volatile uint_io8_t*)0xB7A3E0A4)  /*@bfbba@*/
#define BT31_PWC_STCC_EDIEC	(*(volatile uint_io8_t*)0xB7A3E0A6)  /*@bfbba@*/

typedef struct stc_btn_pwc_stcc_field{
    uint_io8_t		u1OVIRC:1;
    uint_io8_t		:3;
    uint_io8_t		u1OVIEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIEC:1;
    uint_io8_t		:1;
}stc_btn_pwc_stcc_field_t;

typedef union un_btn_pwc_stcc{
    uint_io8_t		u8Register;
    stc_btn_pwc_stcc_field_t		stcField;
}un_btn_pwc_stcc_t;

/* STCS */
#define BT00_PWC_STCS	(BT00_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT00_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78400C4)  /*@bfbba@*/
#define BT00_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78400C6)  /*@bfbba@*/

#define BT01_PWC_STCS	(BT01_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT01_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78420C4)  /*@bfbba@*/
#define BT01_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78420C6)  /*@bfbba@*/

#define BT02_PWC_STCS	(BT02_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT02_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78440C4)  /*@bfbba@*/
#define BT02_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78440C6)  /*@bfbba@*/

#define BT03_PWC_STCS	(BT03_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT03_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78460C4)  /*@bfbba@*/
#define BT03_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78460C6)  /*@bfbba@*/

#define BT04_PWC_STCS	(BT04_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT04_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78480C4)  /*@bfbba@*/
#define BT04_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78480C6)  /*@bfbba@*/

#define BT05_PWC_STCS	(BT05_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT05_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB784A0C4)  /*@bfbba@*/
#define BT05_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB784A0C6)  /*@bfbba@*/

#define BT06_PWC_STCS	(BT06_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT06_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB784C0C4)  /*@bfbba@*/
#define BT06_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB784C0C6)  /*@bfbba@*/

#define BT07_PWC_STCS	(BT07_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT07_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB784E0C4)  /*@bfbba@*/
#define BT07_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB784E0C6)  /*@bfbba@*/

#define BT08_PWC_STCS	(BT08_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT08_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78500C4)  /*@bfbba@*/
#define BT08_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78500C6)  /*@bfbba@*/

#define BT09_PWC_STCS	(BT09_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT09_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78520C4)  /*@bfbba@*/
#define BT09_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78520C6)  /*@bfbba@*/

#define BT10_PWC_STCS	(BT10_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT10_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78540C4)  /*@bfbba@*/
#define BT10_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78540C6)  /*@bfbba@*/

#define BT11_PWC_STCS	(BT11_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT11_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB78560C4)  /*@bfbba@*/
#define BT11_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB78560C6)  /*@bfbba@*/

#define BT12_PWC_STCS	(BT12_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT12_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C400C4)  /*@bfbba@*/
#define BT12_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C400C6)  /*@bfbba@*/

#define BT13_PWC_STCS	(BT13_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT13_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C420C4)  /*@bfbba@*/
#define BT13_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C420C6)  /*@bfbba@*/

#define BT14_PWC_STCS	(BT14_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT14_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C440C4)  /*@bfbba@*/
#define BT14_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C440C6)  /*@bfbba@*/

#define BT15_PWC_STCS	(BT15_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT15_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C460C4)  /*@bfbba@*/
#define BT15_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C460C6)  /*@bfbba@*/

#define BT16_PWC_STCS	(BT16_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT16_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C480C4)  /*@bfbba@*/
#define BT16_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C480C6)  /*@bfbba@*/

#define BT17_PWC_STCS	(BT17_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT17_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C4A0C4)  /*@bfbba@*/
#define BT17_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C4A0C6)  /*@bfbba@*/

#define BT18_PWC_STCS	(BT18_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT18_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C4C0C4)  /*@bfbba@*/
#define BT18_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C4C0C6)  /*@bfbba@*/

#define BT19_PWC_STCS	(BT19_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT19_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C4E0C4)  /*@bfbba@*/
#define BT19_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C4E0C6)  /*@bfbba@*/

#define BT20_PWC_STCS	(BT20_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT20_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C500C4)  /*@bfbba@*/
#define BT20_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C500C6)  /*@bfbba@*/

#define BT21_PWC_STCS	(BT21_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT21_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C520C4)  /*@bfbba@*/
#define BT21_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C520C6)  /*@bfbba@*/

#define BT22_PWC_STCS	(BT22_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT22_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C540C4)  /*@bfbba@*/
#define BT22_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C540C6)  /*@bfbba@*/

#define BT23_PWC_STCS	(BT23_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT23_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7C560C4)  /*@bfbba@*/
#define BT23_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7C560C6)  /*@bfbba@*/

#define BT24_PWC_STCS	(BT24_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT24_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A300C4)  /*@bfbba@*/
#define BT24_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A300C6)  /*@bfbba@*/

#define BT25_PWC_STCS	(BT25_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT25_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A320C4)  /*@bfbba@*/
#define BT25_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A320C6)  /*@bfbba@*/

#define BT26_PWC_STCS	(BT26_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT26_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A340C4)  /*@bfbba@*/
#define BT26_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A340C6)  /*@bfbba@*/

#define BT27_PWC_STCS	(BT27_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT27_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A360C4)  /*@bfbba@*/
#define BT27_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A360C6)  /*@bfbba@*/

#define BT28_PWC_STCS	(BT28_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT28_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A380C4)  /*@bfbba@*/
#define BT28_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A380C6)  /*@bfbba@*/

#define BT29_PWC_STCS	(BT29_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT29_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A3A0C4)  /*@bfbba@*/
#define BT29_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A3A0C6)  /*@bfbba@*/

#define BT30_PWC_STCS	(BT30_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT30_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A3C0C4)  /*@bfbba@*/
#define BT30_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A3C0C6)  /*@bfbba@*/

#define BT31_PWC_STCS	(BT31_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT31_PWC_STCS_OVIES	(*(volatile uint_io8_t*)0xB7A3E0C4)  /*@bfbba@*/
#define BT31_PWC_STCS_EDIES	(*(volatile uint_io8_t*)0xB7A3E0C6)  /*@bfbba@*/

typedef struct stc_btn_pwc_stcs_field{
    uint_io8_t		:4;
    uint_io8_t		u1OVIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIES:1;
    uint_io8_t		:1;
}stc_btn_pwc_stcs_field_t;

typedef union un_btn_pwc_stcs{
    uint_io8_t		u8Register;
    stc_btn_pwc_stcs_field_t		stcField;
}un_btn_pwc_stcs_t;

/* BT_DEBUG */
#define BT00_PWC_BT_DEBUG	(BT00_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT00_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7840120)  /*@bfbba@*/

#define BT01_PWC_BT_DEBUG	(BT01_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT01_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7842120)  /*@bfbba@*/

#define BT02_PWC_BT_DEBUG	(BT02_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT02_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7844120)  /*@bfbba@*/

#define BT03_PWC_BT_DEBUG	(BT03_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT03_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7846120)  /*@bfbba@*/

#define BT04_PWC_BT_DEBUG	(BT04_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT04_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7848120)  /*@bfbba@*/

#define BT05_PWC_BT_DEBUG	(BT05_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT05_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB784A120)  /*@bfbba@*/

#define BT06_PWC_BT_DEBUG	(BT06_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT06_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB784C120)  /*@bfbba@*/

#define BT07_PWC_BT_DEBUG	(BT07_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT07_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB784E120)  /*@bfbba@*/

#define BT08_PWC_BT_DEBUG	(BT08_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT08_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7850120)  /*@bfbba@*/

#define BT09_PWC_BT_DEBUG	(BT09_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT09_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7852120)  /*@bfbba@*/

#define BT10_PWC_BT_DEBUG	(BT10_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT10_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7854120)  /*@bfbba@*/

#define BT11_PWC_BT_DEBUG	(BT11_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT11_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7856120)  /*@bfbba@*/

#define BT12_PWC_BT_DEBUG	(BT12_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT12_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C40120)  /*@bfbba@*/

#define BT13_PWC_BT_DEBUG	(BT13_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT13_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C42120)  /*@bfbba@*/

#define BT14_PWC_BT_DEBUG	(BT14_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT14_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C44120)  /*@bfbba@*/

#define BT15_PWC_BT_DEBUG	(BT15_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT15_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C46120)  /*@bfbba@*/

#define BT16_PWC_BT_DEBUG	(BT16_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT16_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C48120)  /*@bfbba@*/

#define BT17_PWC_BT_DEBUG	(BT17_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT17_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C4A120)  /*@bfbba@*/

#define BT18_PWC_BT_DEBUG	(BT18_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT18_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C4C120)  /*@bfbba@*/

#define BT19_PWC_BT_DEBUG	(BT19_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT19_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C4E120)  /*@bfbba@*/

#define BT20_PWC_BT_DEBUG	(BT20_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT20_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C50120)  /*@bfbba@*/

#define BT21_PWC_BT_DEBUG	(BT21_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT21_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C52120)  /*@bfbba@*/

#define BT22_PWC_BT_DEBUG	(BT22_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT22_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C54120)  /*@bfbba@*/

#define BT23_PWC_BT_DEBUG	(BT23_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT23_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7C56120)  /*@bfbba@*/

#define BT24_PWC_BT_DEBUG	(BT24_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT24_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A30120)  /*@bfbba@*/

#define BT25_PWC_BT_DEBUG	(BT25_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT25_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A32120)  /*@bfbba@*/

#define BT26_PWC_BT_DEBUG	(BT26_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT26_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A34120)  /*@bfbba@*/

#define BT27_PWC_BT_DEBUG	(BT27_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT27_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A36120)  /*@bfbba@*/

#define BT28_PWC_BT_DEBUG	(BT28_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT28_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A38120)  /*@bfbba@*/

#define BT29_PWC_BT_DEBUG	(BT29_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT29_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A3A120)  /*@bfbba@*/

#define BT30_PWC_BT_DEBUG	(BT30_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT30_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A3C120)  /*@bfbba@*/

#define BT31_PWC_BT_DEBUG	(BT31_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT31_PWC_BT_DEBUG_DBGEN	(*(volatile uint_io8_t*)0xB7A3E120)  /*@bfbba@*/

typedef struct stc_btn_pwc_bt_debug_field{
    uint_io16_t		u1DBGEN:1;
    uint_io16_t		:15;
}stc_btn_pwc_bt_debug_field_t;

typedef union un_btn_pwc_bt_debug{
    uint_io16_t		u16Register;
    stc_btn_pwc_bt_debug_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_pwc_bt_debug_t;


typedef struct stc_btn_pwc{
    uint_io8_t	au8Reserved0[4];	/* 0x00000000 */
    un_btn_pwc_dtbf_t	unDTBF;	/* 0x00000004 */
    uint_io8_t	au8Reserved1[6];	/* 0x00000006 */
    un_btn_pwc_tmcr_t	unTMCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved2[2];	/* 0x0000000E */
    un_btn_pwc_stc_t	unSTC;	/* 0x00000010 */
    un_btn_pwc_tmcr2_t	unTMCR2;	/* 0x00000011 */
    uint_io8_t	au8Reserved3[2];	/* 0x00000012 */
    un_btn_pwc_stcc_t	unSTCC;	/* 0x00000014 */
    uint_io8_t	au8Reserved4[3];	/* 0x00000015 */
    un_btn_pwc_stcs_t	unSTCS;	/* 0x00000018 */
    uint_io8_t	au8Reserved5[11];	/* 0x00000019 */
    un_btn_pwc_bt_debug_t	unBT_DEBUG;	/* 0x00000024 */
    uint_io8_t	au8Reserved6[10];	/* 0x00000026 */
}stc_btn_pwc_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_btn_pwc_t	stcBT_PWC[32];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 48(0x30) bytes */


#endif /* __S6J3360_BT_PWC_H */
