/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_SWFG_H
#define __S6J3360_SWFG_H

#include "s6j3360io_basetypes.h"

/* SWFG base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define SWFG	stcSWFG
#else /* __IO_DEFINE */
#define SWFG	(*((volatile stc_swfg_t*)0xB8028000))
#endif /* __IO_DEFINE */

/* WGCHEN */
#define SWFG_WGCHEN	(SWFG.unWGCHEN.u32Register)  /*@rg@*/
#define SWFG_WGCHEN_CH0EN	(SWFG.unWGCHEN.stcField.u1CH0EN)  /*@bf@*/
#define SWFG_WGCHEN_CH1EN	(SWFG.unWGCHEN.stcField.u1CH1EN)  /*@bf@*/
#define SWFG_WGCHEN_CH2EN	(SWFG.unWGCHEN.stcField.u1CH2EN)  /*@bf@*/
#define SWFG_WGCHEN_CH3EN	(SWFG.unWGCHEN.stcField.u1CH3EN)  /*@bf@*/
#define SWFG_WGCHEN_CH4EN	(SWFG.unWGCHEN.stcField.u1CH4EN)  /*@bf@*/

typedef struct stc_swfg_wgchen_field{
    uint_io32_t		u1CH0EN:1;
    uint_io32_t		u1CH1EN:1;
    uint_io32_t		u1CH2EN:1;
    uint_io32_t		u1CH3EN:1;
    uint_io32_t		u1CH4EN:1;
    uint_io32_t		:27;
}stc_swfg_wgchen_field_t;

typedef union un_swfg_wgchen{
    uint_io32_t		u32Register;
    stc_swfg_wgchen_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchen_t;

/* WGCHSTART */
#define SWFG_WGCHSTART	(SWFG.unWGCHSTART.u32Register)  /*@rg@*/
#define SWFG_WGCHSTART_CH0START	(SWFG.unWGCHSTART.stcField.u1CH0START)  /*@bf@*/
#define SWFG_WGCHSTART_CH1START	(SWFG.unWGCHSTART.stcField.u1CH1START)  /*@bf@*/
#define SWFG_WGCHSTART_CH2START	(SWFG.unWGCHSTART.stcField.u1CH2START)  /*@bf@*/
#define SWFG_WGCHSTART_CH3START	(SWFG.unWGCHSTART.stcField.u1CH3START)  /*@bf@*/
#define SWFG_WGCHSTART_CH4START	(SWFG.unWGCHSTART.stcField.u1CH4START)  /*@bf@*/

typedef struct stc_swfg_wgchstart_field{
    uint_io32_t		u1CH0START:1;
    uint_io32_t		u1CH1START:1;
    uint_io32_t		u1CH2START:1;
    uint_io32_t		u1CH3START:1;
    uint_io32_t		u1CH4START:1;
    uint_io32_t		:27;
}stc_swfg_wgchstart_field_t;

typedef union un_swfg_wgchstart{
    uint_io32_t		u32Register;
    stc_swfg_wgchstart_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchstart_t;

/* WGCHBUSY */
#define SWFG_WGCHBUSY	(SWFG.unWGCHBUSY.u32Register)  /*@rg@*/
#define SWFG_WGCHBUSY_CH0BUSY	(SWFG.unWGCHBUSY.stcField.u1CH0BUSY)  /*@bf@*/
#define SWFG_WGCHBUSY_CH1BUSY	(SWFG.unWGCHBUSY.stcField.u1CH1BUSY)  /*@bf@*/
#define SWFG_WGCHBUSY_CH2BUSY	(SWFG.unWGCHBUSY.stcField.u1CH2BUSY)  /*@bf@*/
#define SWFG_WGCHBUSY_CH3BUSY	(SWFG.unWGCHBUSY.stcField.u1CH3BUSY)  /*@bf@*/
#define SWFG_WGCHBUSY_CH4BUSY	(SWFG.unWGCHBUSY.stcField.u1CH4BUSY)  /*@bf@*/

typedef struct stc_swfg_wgchbusy_field{
    uint_io32_t		u1CH0BUSY:1;
    uint_io32_t		u1CH1BUSY:1;
    uint_io32_t		u1CH2BUSY:1;
    uint_io32_t		u1CH3BUSY:1;
    uint_io32_t		u1CH4BUSY:1;
    uint_io32_t		:27;
}stc_swfg_wgchbusy_field_t;

typedef union un_swfg_wgchbusy{
    uint_io32_t		u32Register;
    stc_swfg_wgchbusy_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchbusy_t;

/* WGCHSTOP */
#define SWFG_WGCHSTOP	(SWFG.unWGCHSTOP.u32Register)  /*@rg@*/
#define SWFG_WGCHSTOP_CH0STOP	(SWFG.unWGCHSTOP.stcField.u1CH0STOP)  /*@bf@*/
#define SWFG_WGCHSTOP_CH1STOP	(SWFG.unWGCHSTOP.stcField.u1CH1STOP)  /*@bf@*/
#define SWFG_WGCHSTOP_CH2STOP	(SWFG.unWGCHSTOP.stcField.u1CH2STOP)  /*@bf@*/
#define SWFG_WGCHSTOP_CH3STOP	(SWFG.unWGCHSTOP.stcField.u1CH3STOP)  /*@bf@*/
#define SWFG_WGCHSTOP_CH4STOP	(SWFG.unWGCHSTOP.stcField.u1CH4STOP)  /*@bf@*/

typedef struct stc_swfg_wgchstop_field{
    uint_io32_t		u1CH0STOP:1;
    uint_io32_t		u1CH1STOP:1;
    uint_io32_t		u1CH2STOP:1;
    uint_io32_t		u1CH3STOP:1;
    uint_io32_t		u1CH4STOP:1;
    uint_io32_t		:27;
}stc_swfg_wgchstop_field_t;

typedef union un_swfg_wgchstop{
    uint_io32_t		u32Register;
    stc_swfg_wgchstop_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchstop_t;

/* WGCHDMAEN */
#define SWFG_WGCHDMAEN	(SWFG.unWGCHDMAEN.u32Register)  /*@rg@*/
#define SWFG_WGCHDMAEN_CH0DMAEN	(SWFG.unWGCHDMAEN.stcField.u1CH0DMAEN)  /*@bf@*/
#define SWFG_WGCHDMAEN_CH1DMAEN	(SWFG.unWGCHDMAEN.stcField.u1CH1DMAEN)  /*@bf@*/
#define SWFG_WGCHDMAEN_CH2DMAEN	(SWFG.unWGCHDMAEN.stcField.u1CH2DMAEN)  /*@bf@*/
#define SWFG_WGCHDMAEN_CH3DMAEN	(SWFG.unWGCHDMAEN.stcField.u1CH3DMAEN)  /*@bf@*/
#define SWFG_WGCHDMAEN_CH4DMAEN	(SWFG.unWGCHDMAEN.stcField.u1CH4DMAEN)  /*@bf@*/

typedef struct stc_swfg_wgchdmaen_field{
    uint_io32_t		u1CH0DMAEN:1;
    uint_io32_t		u1CH1DMAEN:1;
    uint_io32_t		u1CH2DMAEN:1;
    uint_io32_t		u1CH3DMAEN:1;
    uint_io32_t		u1CH4DMAEN:1;
    uint_io32_t		:27;
}stc_swfg_wgchdmaen_field_t;

typedef union un_swfg_wgchdmaen{
    uint_io32_t		u32Register;
    stc_swfg_wgchdmaen_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchdmaen_t;

/* WGINTREN */
#define SWFG_WGINTREN	(SWFG.unWGINTREN.u32Register)  /*@rg@*/
#define SWFG_WGINTREN_CH0END	(SWFG.unWGINTREN.stcField.u1CH0END)  /*@bf@*/
#define SWFG_WGINTREN_CH1END	(SWFG.unWGINTREN.stcField.u1CH1END)  /*@bf@*/
#define SWFG_WGINTREN_CH2END	(SWFG.unWGINTREN.stcField.u1CH2END)  /*@bf@*/
#define SWFG_WGINTREN_CH3END	(SWFG.unWGINTREN.stcField.u1CH3END)  /*@bf@*/
#define SWFG_WGINTREN_CH4END	(SWFG.unWGINTREN.stcField.u1CH4END)  /*@bf@*/
#define SWFG_WGINTREN_AHBERR	(SWFG.unWGINTREN.stcField.u1AHBERR)  /*@bf@*/

typedef struct stc_swfg_wgintren_field{
    uint_io32_t		u1CH0END:1;
    uint_io32_t		u1CH1END:1;
    uint_io32_t		u1CH2END:1;
    uint_io32_t		u1CH3END:1;
    uint_io32_t		u1CH4END:1;
    uint_io32_t		:11;
    uint_io32_t		u1AHBERR:1;
    uint_io32_t		:15;
}stc_swfg_wgintren_field_t;

typedef union un_swfg_wgintren{
    uint_io32_t		u32Register;
    stc_swfg_wgintren_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgintren_t;

/* WGINTRSTATE */
#define SWFG_WGINTRSTATE	(SWFG.unWGINTRSTATE.u32Register)  /*@rg@*/
#define SWFG_WGINTRSTATE_CH0END	(SWFG.unWGINTRSTATE.stcField.u1CH0END)  /*@bf@*/
#define SWFG_WGINTRSTATE_CH1END	(SWFG.unWGINTRSTATE.stcField.u1CH1END)  /*@bf@*/
#define SWFG_WGINTRSTATE_CH2END	(SWFG.unWGINTRSTATE.stcField.u1CH2END)  /*@bf@*/
#define SWFG_WGINTRSTATE_CH3END	(SWFG.unWGINTRSTATE.stcField.u1CH3END)  /*@bf@*/
#define SWFG_WGINTRSTATE_CH4END	(SWFG.unWGINTRSTATE.stcField.u1CH4END)  /*@bf@*/
#define SWFG_WGINTRSTATE_AHBERR	(SWFG.unWGINTRSTATE.stcField.u1AHBERR)  /*@bf@*/

typedef struct stc_swfg_wgintrstate_field{
    uint_io32_t		u1CH0END:1;
    uint_io32_t		u1CH1END:1;
    uint_io32_t		u1CH2END:1;
    uint_io32_t		u1CH3END:1;
    uint_io32_t		u1CH4END:1;
    uint_io32_t		:11;
    uint_io32_t		u1AHBERR:1;
    uint_io32_t		:15;
}stc_swfg_wgintrstate_field_t;

typedef union un_swfg_wgintrstate{
    uint_io32_t		u32Register;
    stc_swfg_wgintrstate_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgintrstate_t;

/* WGINTRCLR */
#define SWFG_WGINTRCLR	(SWFG.unWGINTRCLR.u32Register)  /*@rg@*/
#define SWFG_WGINTRCLR_CH0END	(SWFG.unWGINTRCLR.stcField.u1CH0END)  /*@bf@*/
#define SWFG_WGINTRCLR_CH1END	(SWFG.unWGINTRCLR.stcField.u1CH1END)  /*@bf@*/
#define SWFG_WGINTRCLR_CH2END	(SWFG.unWGINTRCLR.stcField.u1CH2END)  /*@bf@*/
#define SWFG_WGINTRCLR_CH3END	(SWFG.unWGINTRCLR.stcField.u1CH3END)  /*@bf@*/
#define SWFG_WGINTRCLR_CH4END	(SWFG.unWGINTRCLR.stcField.u1CH4END)  /*@bf@*/
#define SWFG_WGINTRCLR_AHBERR	(SWFG.unWGINTRCLR.stcField.u1AHBERR)  /*@bf@*/

typedef struct stc_swfg_wgintrclr_field{
    uint_io32_t		u1CH0END:1;
    uint_io32_t		u1CH1END:1;
    uint_io32_t		u1CH2END:1;
    uint_io32_t		u1CH3END:1;
    uint_io32_t		u1CH4END:1;
    uint_io32_t		:11;
    uint_io32_t		u1AHBERR:1;
    uint_io32_t		:15;
}stc_swfg_wgintrclr_field_t;

typedef union un_swfg_wgintrclr{
    uint_io32_t		u32Register;
    stc_swfg_wgintrclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgintrclr_t;

/* WGAHBERR */
#define SWFG_WGAHBERR	(SWFG.unWGAHBERR.u32Register)  /*@rg@*/
#define SWFG_WGAHBERR_AHBSERR	(SWFG.unWGAHBERR.stcField.u2AHBSERR)  /*@bf@*/

typedef struct stc_swfg_wgahberr_field{
    uint_io32_t		u2AHBSERR:2;
    uint_io32_t		:30;
}stc_swfg_wgahberr_field_t;

typedef union un_swfg_wgahberr{
    uint_io32_t		u32Register;
    stc_swfg_wgahberr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgahberr_t;

/* WGCHADD0 */
#define SWFG_WGCHADD0	(SWFG.unWGCHADD0.u32Register)  /*@rg@*/
#define SWFG_WGCHADD0_CH0ADD	(SWFG.unWGCHADD0.stcField.u13CH0ADD)  /*@bf@*/
#define SWFG_WGCHADD0_CH1ADD	(SWFG.unWGCHADD0.stcField.u13CH1ADD)  /*@bf@*/

typedef struct stc_swfg_wgchadd0_field{
    uint_io32_t		u13CH0ADD:13;
    uint_io32_t		:3;
    uint_io32_t		u13CH1ADD:13;
    uint_io32_t		:3;
}stc_swfg_wgchadd0_field_t;

typedef union un_swfg_wgchadd0{
    uint_io32_t		u32Register;
    stc_swfg_wgchadd0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchadd0_t;

/* WGCHADD1 */
#define SWFG_WGCHADD1	(SWFG.unWGCHADD1.u32Register)  /*@rg@*/
#define SWFG_WGCHADD1_CH2ADD	(SWFG.unWGCHADD1.stcField.u13CH2ADD)  /*@bf@*/
#define SWFG_WGCHADD1_CH3ADD	(SWFG.unWGCHADD1.stcField.u13CH3ADD)  /*@bf@*/

typedef struct stc_swfg_wgchadd1_field{
    uint_io32_t		u13CH2ADD:13;
    uint_io32_t		:3;
    uint_io32_t		u13CH3ADD:13;
    uint_io32_t		:3;
}stc_swfg_wgchadd1_field_t;

typedef union un_swfg_wgchadd1{
    uint_io32_t		u32Register;
    stc_swfg_wgchadd1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchadd1_t;

/* WGCHADD2 */
#define SWFG_WGCHADD2	(SWFG.unWGCHADD2.u32Register)  /*@rg@*/
#define SWFG_WGCHADD2_CH4ADD	(SWFG.unWGCHADD2.stcField.u13CH4ADD)  /*@bf@*/

typedef struct stc_swfg_wgchadd2_field{
    uint_io32_t		u13CH4ADD:13;
    uint_io32_t		:19;
}stc_swfg_wgchadd2_field_t;

typedef union un_swfg_wgchadd2{
    uint_io32_t		u32Register;
    stc_swfg_wgchadd2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgchadd2_t;

/* WGCH0FILCOEF0 */
#define SWFG_WGCH0FILCOEF0	(SWFG.unWGCH0FILCOEF0.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF0_FILCOEF0	(SWFG.unWGCH0FILCOEF0.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF0_FILCOEF1	(SWFG.unWGCH0FILCOEF0.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef0_field{
    uint_io32_t		u16FILCOEF0:16;
    uint_io32_t		u16FILCOEF1:16;
}stc_swfg_wgch0filcoef0_field_t;

typedef union un_swfg_wgch0filcoef0{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef0_t;

/* WGCH0FILCOEF1 */
#define SWFG_WGCH0FILCOEF1	(SWFG.unWGCH0FILCOEF1.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF1_FILCOEF2	(SWFG.unWGCH0FILCOEF1.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF1_FILCOEF3	(SWFG.unWGCH0FILCOEF1.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef1_field{
    uint_io32_t		u16FILCOEF2:16;
    uint_io32_t		u16FILCOEF3:16;
}stc_swfg_wgch0filcoef1_field_t;

typedef union un_swfg_wgch0filcoef1{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef1_t;

/* WGCH0FILCOEF2 */
#define SWFG_WGCH0FILCOEF2	(SWFG.unWGCH0FILCOEF2.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF2_FILCOEF4	(SWFG.unWGCH0FILCOEF2.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF2_FILCOEF5	(SWFG.unWGCH0FILCOEF2.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef2_field{
    uint_io32_t		u16FILCOEF4:16;
    uint_io32_t		u16FILCOEF5:16;
}stc_swfg_wgch0filcoef2_field_t;

typedef union un_swfg_wgch0filcoef2{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef2_t;

/* WGCH0FILCOEF3 */
#define SWFG_WGCH0FILCOEF3	(SWFG.unWGCH0FILCOEF3.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF3_FILCOEF6	(SWFG.unWGCH0FILCOEF3.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF3_FILCOEF7	(SWFG.unWGCH0FILCOEF3.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef3_field{
    uint_io32_t		u16FILCOEF6:16;
    uint_io32_t		u16FILCOEF7:16;
}stc_swfg_wgch0filcoef3_field_t;

typedef union un_swfg_wgch0filcoef3{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef3_t;

/* WGCH0FILCOEF4 */
#define SWFG_WGCH0FILCOEF4	(SWFG.unWGCH0FILCOEF4.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF4_FILCOEF8	(SWFG.unWGCH0FILCOEF4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF4_FILCOEF9	(SWFG.unWGCH0FILCOEF4.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef4_field{
    uint_io32_t		u16FILCOEF8:16;
    uint_io32_t		u16FILCOEF9:16;
}stc_swfg_wgch0filcoef4_field_t;

typedef union un_swfg_wgch0filcoef4{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef4_t;

/* WGCH0FILCOEF5 */
#define SWFG_WGCH0FILCOEF5	(SWFG.unWGCH0FILCOEF5.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF5_FILCOEF10	(SWFG.unWGCH0FILCOEF5.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF5_FILCOEF11	(SWFG.unWGCH0FILCOEF5.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef5_field{
    uint_io32_t		u16FILCOEF10:16;
    uint_io32_t		u16FILCOEF11:16;
}stc_swfg_wgch0filcoef5_field_t;

typedef union un_swfg_wgch0filcoef5{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef5_t;

/* WGCH0FILCOEF6 */
#define SWFG_WGCH0FILCOEF6	(SWFG.unWGCH0FILCOEF6.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF6_FILCOEF12	(SWFG.unWGCH0FILCOEF6.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF6_FILCOEF13	(SWFG.unWGCH0FILCOEF6.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef6_field{
    uint_io32_t		u16FILCOEF12:16;
    uint_io32_t		u16FILCOEF13:16;
}stc_swfg_wgch0filcoef6_field_t;

typedef union un_swfg_wgch0filcoef6{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef6_t;

/* WGCH0FILCOEF7 */
#define SWFG_WGCH0FILCOEF7	(SWFG.unWGCH0FILCOEF7.u32Register)  /*@rg@*/
#define SWFG_WGCH0FILCOEF7_FILCOEF14	(SWFG.unWGCH0FILCOEF7.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0FILCOEF7_FILCOEF15	(SWFG.unWGCH0FILCOEF7.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch0filcoef7_field{
    uint_io32_t		u16FILCOEF14:16;
    uint_io32_t		u16FILCOEF15:16;
}stc_swfg_wgch0filcoef7_field_t;

typedef union un_swfg_wgch0filcoef7{
    uint_io32_t		u32Register;
    stc_swfg_wgch0filcoef7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0filcoef7_t;

/* WGCH0CTRL0 */
#define SWFG_WGCH0CTRL0	(SWFG.unWGCH0CTRL0.u32Register)  /*@rg@*/
#define SWFG_WGCH0CTRL0_ADPHASECH	(SWFG.unWGCH0CTRL0.stcField.u3ADPHASECH)  /*@bf@*/
#define SWFG_WGCH0CTRL0_ADPHASEEN	(SWFG.unWGCH0CTRL0.stcField.u1ADPHASEEN)  /*@bf@*/
#define SWFG_WGCH0CTRL0_PCMZEROEN	(SWFG.unWGCH0CTRL0.stcField.u1PCMZEROEN)  /*@bf@*/
#define SWFG_WGCH0CTRL0_CONTNUM	(SWFG.unWGCH0CTRL0.stcField.u4CONTNUM)  /*@bf@*/
#define SWFG_WGCH0CTRL0_STOPREL	(SWFG.unWGCH0CTRL0.stcField.u3STOPREL)  /*@bf@*/
#define SWFG_WGCH0CTRL0_FILEN	(SWFG.unWGCH0CTRL0.stcField.u1FILEN)  /*@bf@*/

typedef struct stc_swfg_wgch0ctrl0_field{
    uint_io32_t		u3ADPHASECH:3;
    uint_io32_t		u1ADPHASEEN:1;
    uint_io32_t		:4;
    uint_io32_t		u1PCMZEROEN:1;
    uint_io32_t		:7;
    uint_io32_t		u4CONTNUM:4;
    uint_io32_t		:4;
    uint_io32_t		u3STOPREL:3;
    uint_io32_t		:4;
    uint_io32_t		u1FILEN:1;
}stc_swfg_wgch0ctrl0_field_t;

typedef union un_swfg_wgch0ctrl0{
    uint_io32_t		u32Register;
    stc_swfg_wgch0ctrl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0ctrl0_t;

/* WGCH0CTRL1 */
#define SWFG_WGCH0CTRL1	(SWFG.unWGCH0CTRL1.u32Register)  /*@rg@*/
#define SWFG_WGCH0CTRL1_INITGAIN	(SWFG.unWGCH0CTRL1.stcField.u10INITGAIN)  /*@bf@*/
#define SWFG_WGCH0CTRL1_GAINSUCEN	(SWFG.unWGCH0CTRL1.stcField.u1GAINSUCEN)  /*@bf@*/
#define SWFG_WGCH0CTRL1_GAINFLUCT	(SWFG.unWGCH0CTRL1.stcField.u17GAINFLUCT)  /*@bf@*/
#define SWFG_WGCH0CTRL1_GAINUDSEL	(SWFG.unWGCH0CTRL1.stcField.u1GAINUDSEL)  /*@bf@*/
#define SWFG_WGCH0CTRL1_DBEN	(SWFG.unWGCH0CTRL1.stcField.u1DBEN)  /*@bf@*/

typedef struct stc_swfg_wgch0ctrl1_field{
    uint_io32_t		u10INITGAIN:10;
    uint_io32_t		u1GAINSUCEN:1;
    uint_io32_t		:1;
    uint_io32_t		u17GAINFLUCT:17;
    uint_io32_t		u1GAINUDSEL:1;
    uint_io32_t		:1;
    uint_io32_t		u1DBEN:1;
}stc_swfg_wgch0ctrl1_field_t;

typedef union un_swfg_wgch0ctrl1{
    uint_io32_t		u32Register;
    stc_swfg_wgch0ctrl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0ctrl1_t;

/* WGCH0CTRL2 */
#define SWFG_WGCH0CTRL2	(SWFG.unWGCH0CTRL2.u32Register)  /*@rg@*/
#define SWFG_WGCH0CTRL2_MONO	(SWFG.unWGCH0CTRL2.stcField.u2MONO)  /*@bf@*/
#define SWFG_WGCH0CTRL2_FSINF	(SWFG.unWGCH0CTRL2.stcField.u2FSINF)  /*@bf@*/
#define SWFG_WGCH0CTRL2_DUTY	(SWFG.unWGCH0CTRL2.stcField.u7DUTY)  /*@bf@*/
#define SWFG_WGCH0CTRL2_ATTACK	(SWFG.unWGCH0CTRL2.stcField.u5ATTACK)  /*@bf@*/
#define SWFG_WGCH0CTRL2_ATTCVSEL	(SWFG.unWGCH0CTRL2.stcField.u1ATTCVSEL)  /*@bf@*/
#define SWFG_WGCH0CTRL2_RELEASE	(SWFG.unWGCH0CTRL2.stcField.u5RELEASE)  /*@bf@*/
#define SWFG_WGCH0CTRL2_RELCVSEL	(SWFG.unWGCH0CTRL2.stcField.u1RELCVSEL)  /*@bf@*/

typedef struct stc_swfg_wgch0ctrl2_field{
    uint_io32_t		u2MONO:2;
    uint_io32_t		:2;
    uint_io32_t		u2FSINF:2;
    uint_io32_t		:2;
    uint_io32_t		u7DUTY:7;
    uint_io32_t		:1;
    uint_io32_t		u5ATTACK:5;
    uint_io32_t		:2;
    uint_io32_t		u1ATTCVSEL:1;
    uint_io32_t		u5RELEASE:5;
    uint_io32_t		:2;
    uint_io32_t		u1RELCVSEL:1;
}stc_swfg_wgch0ctrl2_field_t;

typedef union un_swfg_wgch0ctrl2{
    uint_io32_t		u32Register;
    stc_swfg_wgch0ctrl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0ctrl2_t;

/* WGCH0CTRL3 */
#define SWFG_WGCH0CTRL3	(SWFG.unWGCH0CTRL3.u32Register)  /*@rg@*/
#define SWFG_WGCH0CTRL3_ITVAL1	(SWFG.unWGCH0CTRL3.stcField.u14ITVAL1)  /*@bf@*/
#define SWFG_WGCH0CTRL3_ITVAL2	(SWFG.unWGCH0CTRL3.stcField.u14ITVAL2)  /*@bf@*/

typedef struct stc_swfg_wgch0ctrl3_field{
    uint_io32_t		u14ITVAL1:14;
    uint_io32_t		:2;
    uint_io32_t		u14ITVAL2:14;
    uint_io32_t		:2;
}stc_swfg_wgch0ctrl3_field_t;

typedef union un_swfg_wgch0ctrl3{
    uint_io32_t		u32Register;
    stc_swfg_wgch0ctrl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0ctrl3_t;

/* WGCH0CTRL4 */
#define SWFG_WGCH0CTRL4	(SWFG.unWGCH0CTRL4.u32Register)  /*@rg@*/
#define SWFG_WGCH0CTRL4_FSFREQ	(SWFG.unWGCH0CTRL4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH0CTRL4_FSLEN	(SWFG.unWGCH0CTRL4.stcField.u14FSLEN)  /*@bf@*/
#define SWFG_WGCH0CTRL4_CH0START	(SWFG.unWGCH0CTRL4.stcField.u1CH0START)  /*@bf@*/

typedef struct stc_swfg_wgch0ctrl4_field{
    uint_io32_t		u16FSFREQ:16;
    uint_io32_t		u14FSLEN:14;
    uint_io32_t		:1;
    uint_io32_t		u1CH0START:1;
}stc_swfg_wgch0ctrl4_field_t;

typedef union un_swfg_wgch0ctrl4{
    uint_io32_t		u32Register;
    stc_swfg_wgch0ctrl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0ctrl4_t;

/* WGCH0STATUS */
#define SWFG_WGCH0STATUS	(SWFG.unWGCH0STATUS.u32Register)  /*@rg@*/
#define SWFG_WGCH0STATUS_ENDGAIN	(SWFG.unWGCH0STATUS.stcField.u10ENDGAIN)  /*@bf@*/
#define SWFG_WGCH0STATUS_ENDGAINV	(SWFG.unWGCH0STATUS.stcField.u1ENDGAINV)  /*@bf@*/
#define SWFG_WGCH0STATUS_CONTNUMR	(SWFG.unWGCH0STATUS.stcField.u4CONTNUMR)  /*@bf@*/

typedef struct stc_swfg_wgch0status_field{
    uint_io32_t		u10ENDGAIN:10;
    uint_io32_t		:5;
    uint_io32_t		u1ENDGAINV:1;
    uint_io32_t		u4CONTNUMR:4;
    uint_io32_t		:12;
}stc_swfg_wgch0status_field_t;

typedef union un_swfg_wgch0status{
    uint_io32_t		u32Register;
    stc_swfg_wgch0status_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch0status_t;

/* WGCH1FILCOEF0 */
#define SWFG_WGCH1FILCOEF0	(SWFG.unWGCH1FILCOEF0.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF0_FILCOEF0	(SWFG.unWGCH1FILCOEF0.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF0_FILCOEF1	(SWFG.unWGCH1FILCOEF0.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef0_field{
    uint_io32_t		u16FILCOEF0:16;
    uint_io32_t		u16FILCOEF1:16;
}stc_swfg_wgch1filcoef0_field_t;

typedef union un_swfg_wgch1filcoef0{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef0_t;

/* WGCH1FILCOEF1 */
#define SWFG_WGCH1FILCOEF1	(SWFG.unWGCH1FILCOEF1.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF1_FILCOEF2	(SWFG.unWGCH1FILCOEF1.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF1_FILCOEF3	(SWFG.unWGCH1FILCOEF1.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef1_field{
    uint_io32_t		u16FILCOEF2:16;
    uint_io32_t		u16FILCOEF3:16;
}stc_swfg_wgch1filcoef1_field_t;

typedef union un_swfg_wgch1filcoef1{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef1_t;

/* WGCH1FILCOEF2 */
#define SWFG_WGCH1FILCOEF2	(SWFG.unWGCH1FILCOEF2.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF2_FILCOEF4	(SWFG.unWGCH1FILCOEF2.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF2_FILCOEF5	(SWFG.unWGCH1FILCOEF2.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef2_field{
    uint_io32_t		u16FILCOEF4:16;
    uint_io32_t		u16FILCOEF5:16;
}stc_swfg_wgch1filcoef2_field_t;

typedef union un_swfg_wgch1filcoef2{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef2_t;

/* WGCH1FILCOEF3 */
#define SWFG_WGCH1FILCOEF3	(SWFG.unWGCH1FILCOEF3.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF3_FILCOEF6	(SWFG.unWGCH1FILCOEF3.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF3_FILCOEF7	(SWFG.unWGCH1FILCOEF3.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef3_field{
    uint_io32_t		u16FILCOEF6:16;
    uint_io32_t		u16FILCOEF7:16;
}stc_swfg_wgch1filcoef3_field_t;

typedef union un_swfg_wgch1filcoef3{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef3_t;

/* WGCH1FILCOEF4 */
#define SWFG_WGCH1FILCOEF4	(SWFG.unWGCH1FILCOEF4.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF4_FILCOEF8	(SWFG.unWGCH1FILCOEF4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF4_FILCOEF9	(SWFG.unWGCH1FILCOEF4.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef4_field{
    uint_io32_t		u16FILCOEF8:16;
    uint_io32_t		u16FILCOEF9:16;
}stc_swfg_wgch1filcoef4_field_t;

typedef union un_swfg_wgch1filcoef4{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef4_t;

/* WGCH1FILCOEF5 */
#define SWFG_WGCH1FILCOEF5	(SWFG.unWGCH1FILCOEF5.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF5_FILCOEF10	(SWFG.unWGCH1FILCOEF5.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF5_FILCOEF11	(SWFG.unWGCH1FILCOEF5.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef5_field{
    uint_io32_t		u16FILCOEF10:16;
    uint_io32_t		u16FILCOEF11:16;
}stc_swfg_wgch1filcoef5_field_t;

typedef union un_swfg_wgch1filcoef5{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef5_t;

/* WGCH1FILCOEF6 */
#define SWFG_WGCH1FILCOEF6	(SWFG.unWGCH1FILCOEF6.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF6_FILCOEF12	(SWFG.unWGCH1FILCOEF6.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF6_FILCOEF13	(SWFG.unWGCH1FILCOEF6.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef6_field{
    uint_io32_t		u16FILCOEF12:16;
    uint_io32_t		u16FILCOEF13:16;
}stc_swfg_wgch1filcoef6_field_t;

typedef union un_swfg_wgch1filcoef6{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef6_t;

/* WGCH1FILCOEF7 */
#define SWFG_WGCH1FILCOEF7	(SWFG.unWGCH1FILCOEF7.u32Register)  /*@rg@*/
#define SWFG_WGCH1FILCOEF7_FILCOEF14	(SWFG.unWGCH1FILCOEF7.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1FILCOEF7_FILCOEF15	(SWFG.unWGCH1FILCOEF7.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch1filcoef7_field{
    uint_io32_t		u16FILCOEF14:16;
    uint_io32_t		u16FILCOEF15:16;
}stc_swfg_wgch1filcoef7_field_t;

typedef union un_swfg_wgch1filcoef7{
    uint_io32_t		u32Register;
    stc_swfg_wgch1filcoef7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1filcoef7_t;

/* WGCH1CTRL0 */
#define SWFG_WGCH1CTRL0	(SWFG.unWGCH1CTRL0.u32Register)  /*@rg@*/
#define SWFG_WGCH1CTRL0_ADPHASECH	(SWFG.unWGCH1CTRL0.stcField.u3ADPHASECH)  /*@bf@*/
#define SWFG_WGCH1CTRL0_ADPHASEEN	(SWFG.unWGCH1CTRL0.stcField.u1ADPHASEEN)  /*@bf@*/
#define SWFG_WGCH1CTRL0_PCMZEROEN	(SWFG.unWGCH1CTRL0.stcField.u1PCMZEROEN)  /*@bf@*/
#define SWFG_WGCH1CTRL0_CONTNUM	(SWFG.unWGCH1CTRL0.stcField.u4CONTNUM)  /*@bf@*/
#define SWFG_WGCH1CTRL0_STOPREL	(SWFG.unWGCH1CTRL0.stcField.u3STOPREL)  /*@bf@*/
#define SWFG_WGCH1CTRL0_FILEN	(SWFG.unWGCH1CTRL0.stcField.u1FILEN)  /*@bf@*/

typedef struct stc_swfg_wgch1ctrl0_field{
    uint_io32_t		u3ADPHASECH:3;
    uint_io32_t		u1ADPHASEEN:1;
    uint_io32_t		:4;
    uint_io32_t		u1PCMZEROEN:1;
    uint_io32_t		:7;
    uint_io32_t		u4CONTNUM:4;
    uint_io32_t		:4;
    uint_io32_t		u3STOPREL:3;
    uint_io32_t		:4;
    uint_io32_t		u1FILEN:1;
}stc_swfg_wgch1ctrl0_field_t;

typedef union un_swfg_wgch1ctrl0{
    uint_io32_t		u32Register;
    stc_swfg_wgch1ctrl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1ctrl0_t;

/* WGCH1CTRL1 */
#define SWFG_WGCH1CTRL1	(SWFG.unWGCH1CTRL1.u32Register)  /*@rg@*/
#define SWFG_WGCH1CTRL1_INITGAIN	(SWFG.unWGCH1CTRL1.stcField.u10INITGAIN)  /*@bf@*/
#define SWFG_WGCH1CTRL1_GAINSUCEN	(SWFG.unWGCH1CTRL1.stcField.u1GAINSUCEN)  /*@bf@*/
#define SWFG_WGCH1CTRL1_GAINFLUCT	(SWFG.unWGCH1CTRL1.stcField.u17GAINFLUCT)  /*@bf@*/
#define SWFG_WGCH1CTRL1_GAINUDSEL	(SWFG.unWGCH1CTRL1.stcField.u1GAINUDSEL)  /*@bf@*/
#define SWFG_WGCH1CTRL1_DBEN	(SWFG.unWGCH1CTRL1.stcField.u1DBEN)  /*@bf@*/

typedef struct stc_swfg_wgch1ctrl1_field{
    uint_io32_t		u10INITGAIN:10;
    uint_io32_t		u1GAINSUCEN:1;
    uint_io32_t		:1;
    uint_io32_t		u17GAINFLUCT:17;
    uint_io32_t		u1GAINUDSEL:1;
    uint_io32_t		:1;
    uint_io32_t		u1DBEN:1;
}stc_swfg_wgch1ctrl1_field_t;

typedef union un_swfg_wgch1ctrl1{
    uint_io32_t		u32Register;
    stc_swfg_wgch1ctrl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1ctrl1_t;

/* WGCH1CTRL2 */
#define SWFG_WGCH1CTRL2	(SWFG.unWGCH1CTRL2.u32Register)  /*@rg@*/
#define SWFG_WGCH1CTRL2_MONO	(SWFG.unWGCH1CTRL2.stcField.u2MONO)  /*@bf@*/
#define SWFG_WGCH1CTRL2_FSINF	(SWFG.unWGCH1CTRL2.stcField.u2FSINF)  /*@bf@*/
#define SWFG_WGCH1CTRL2_DUTY	(SWFG.unWGCH1CTRL2.stcField.u7DUTY)  /*@bf@*/
#define SWFG_WGCH1CTRL2_ATTACK	(SWFG.unWGCH1CTRL2.stcField.u5ATTACK)  /*@bf@*/
#define SWFG_WGCH1CTRL2_ATTCVSEL	(SWFG.unWGCH1CTRL2.stcField.u1ATTCVSEL)  /*@bf@*/
#define SWFG_WGCH1CTRL2_RELEASE	(SWFG.unWGCH1CTRL2.stcField.u5RELEASE)  /*@bf@*/
#define SWFG_WGCH1CTRL2_RELCVSEL	(SWFG.unWGCH1CTRL2.stcField.u1RELCVSEL)  /*@bf@*/

typedef struct stc_swfg_wgch1ctrl2_field{
    uint_io32_t		u2MONO:2;
    uint_io32_t		:2;
    uint_io32_t		u2FSINF:2;
    uint_io32_t		:2;
    uint_io32_t		u7DUTY:7;
    uint_io32_t		:1;
    uint_io32_t		u5ATTACK:5;
    uint_io32_t		:2;
    uint_io32_t		u1ATTCVSEL:1;
    uint_io32_t		u5RELEASE:5;
    uint_io32_t		:2;
    uint_io32_t		u1RELCVSEL:1;
}stc_swfg_wgch1ctrl2_field_t;

typedef union un_swfg_wgch1ctrl2{
    uint_io32_t		u32Register;
    stc_swfg_wgch1ctrl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1ctrl2_t;

/* WGCH1CTRL3 */
#define SWFG_WGCH1CTRL3	(SWFG.unWGCH1CTRL3.u32Register)  /*@rg@*/
#define SWFG_WGCH1CTRL3_ITVAL1	(SWFG.unWGCH1CTRL3.stcField.u14ITVAL1)  /*@bf@*/
#define SWFG_WGCH1CTRL3_ITVAL2	(SWFG.unWGCH1CTRL3.stcField.u14ITVAL2)  /*@bf@*/

typedef struct stc_swfg_wgch1ctrl3_field{
    uint_io32_t		u14ITVAL1:14;
    uint_io32_t		:2;
    uint_io32_t		u14ITVAL2:14;
    uint_io32_t		:2;
}stc_swfg_wgch1ctrl3_field_t;

typedef union un_swfg_wgch1ctrl3{
    uint_io32_t		u32Register;
    stc_swfg_wgch1ctrl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1ctrl3_t;

/* WGCH1CTRL4 */
#define SWFG_WGCH1CTRL4	(SWFG.unWGCH1CTRL4.u32Register)  /*@rg@*/
#define SWFG_WGCH1CTRL4_FSFREQ	(SWFG.unWGCH1CTRL4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH1CTRL4_FSLEN	(SWFG.unWGCH1CTRL4.stcField.u14FSLEN)  /*@bf@*/
#define SWFG_WGCH1CTRL4_CH0START	(SWFG.unWGCH1CTRL4.stcField.u1CH0START)  /*@bf@*/

typedef struct stc_swfg_wgch1ctrl4_field{
    uint_io32_t		u16FSFREQ:16;
    uint_io32_t		u14FSLEN:14;
    uint_io32_t		:1;
    uint_io32_t		u1CH0START:1;
}stc_swfg_wgch1ctrl4_field_t;

typedef union un_swfg_wgch1ctrl4{
    uint_io32_t		u32Register;
    stc_swfg_wgch1ctrl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1ctrl4_t;

/* WGCH1STATUS */
#define SWFG_WGCH1STATUS	(SWFG.unWGCH1STATUS.u32Register)  /*@rg@*/
#define SWFG_WGCH1STATUS_ENDGAIN	(SWFG.unWGCH1STATUS.stcField.u10ENDGAIN)  /*@bf@*/
#define SWFG_WGCH1STATUS_ENDGAINV	(SWFG.unWGCH1STATUS.stcField.u1ENDGAINV)  /*@bf@*/
#define SWFG_WGCH1STATUS_CONTNUMR	(SWFG.unWGCH1STATUS.stcField.u4CONTNUMR)  /*@bf@*/

typedef struct stc_swfg_wgch1status_field{
    uint_io32_t		u10ENDGAIN:10;
    uint_io32_t		:5;
    uint_io32_t		u1ENDGAINV:1;
    uint_io32_t		u4CONTNUMR:4;
    uint_io32_t		:12;
}stc_swfg_wgch1status_field_t;

typedef union un_swfg_wgch1status{
    uint_io32_t		u32Register;
    stc_swfg_wgch1status_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch1status_t;

/* WGCH2FILCOEF0 */
#define SWFG_WGCH2FILCOEF0	(SWFG.unWGCH2FILCOEF0.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF0_FILCOEF0	(SWFG.unWGCH2FILCOEF0.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF0_FILCOEF1	(SWFG.unWGCH2FILCOEF0.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef0_field{
    uint_io32_t		u16FILCOEF0:16;
    uint_io32_t		u16FILCOEF1:16;
}stc_swfg_wgch2filcoef0_field_t;

typedef union un_swfg_wgch2filcoef0{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef0_t;

/* WGCH2FILCOEF1 */
#define SWFG_WGCH2FILCOEF1	(SWFG.unWGCH2FILCOEF1.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF1_FILCOEF2	(SWFG.unWGCH2FILCOEF1.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF1_FILCOEF3	(SWFG.unWGCH2FILCOEF1.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef1_field{
    uint_io32_t		u16FILCOEF2:16;
    uint_io32_t		u16FILCOEF3:16;
}stc_swfg_wgch2filcoef1_field_t;

typedef union un_swfg_wgch2filcoef1{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef1_t;

/* WGCH2FILCOEF2 */
#define SWFG_WGCH2FILCOEF2	(SWFG.unWGCH2FILCOEF2.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF2_FILCOEF4	(SWFG.unWGCH2FILCOEF2.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF2_FILCOEF5	(SWFG.unWGCH2FILCOEF2.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef2_field{
    uint_io32_t		u16FILCOEF4:16;
    uint_io32_t		u16FILCOEF5:16;
}stc_swfg_wgch2filcoef2_field_t;

typedef union un_swfg_wgch2filcoef2{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef2_t;

/* WGCH2FILCOEF3 */
#define SWFG_WGCH2FILCOEF3	(SWFG.unWGCH2FILCOEF3.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF3_FILCOEF6	(SWFG.unWGCH2FILCOEF3.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF3_FILCOEF7	(SWFG.unWGCH2FILCOEF3.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef3_field{
    uint_io32_t		u16FILCOEF6:16;
    uint_io32_t		u16FILCOEF7:16;
}stc_swfg_wgch2filcoef3_field_t;

typedef union un_swfg_wgch2filcoef3{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef3_t;

/* WGCH2FILCOEF4 */
#define SWFG_WGCH2FILCOEF4	(SWFG.unWGCH2FILCOEF4.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF4_FILCOEF8	(SWFG.unWGCH2FILCOEF4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF4_FILCOEF9	(SWFG.unWGCH2FILCOEF4.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef4_field{
    uint_io32_t		u16FILCOEF8:16;
    uint_io32_t		u16FILCOEF9:16;
}stc_swfg_wgch2filcoef4_field_t;

typedef union un_swfg_wgch2filcoef4{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef4_t;

/* WGCH2FILCOEF5 */
#define SWFG_WGCH2FILCOEF5	(SWFG.unWGCH2FILCOEF5.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF5_FILCOEF10	(SWFG.unWGCH2FILCOEF5.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF5_FILCOEF11	(SWFG.unWGCH2FILCOEF5.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef5_field{
    uint_io32_t		u16FILCOEF10:16;
    uint_io32_t		u16FILCOEF11:16;
}stc_swfg_wgch2filcoef5_field_t;

typedef union un_swfg_wgch2filcoef5{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef5_t;

/* WGCH2FILCOEF6 */
#define SWFG_WGCH2FILCOEF6	(SWFG.unWGCH2FILCOEF6.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF6_FILCOEF12	(SWFG.unWGCH2FILCOEF6.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF6_FILCOEF13	(SWFG.unWGCH2FILCOEF6.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef6_field{
    uint_io32_t		u16FILCOEF12:16;
    uint_io32_t		u16FILCOEF13:16;
}stc_swfg_wgch2filcoef6_field_t;

typedef union un_swfg_wgch2filcoef6{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef6_t;

/* WGCH2FILCOEF7 */
#define SWFG_WGCH2FILCOEF7	(SWFG.unWGCH2FILCOEF7.u32Register)  /*@rg@*/
#define SWFG_WGCH2FILCOEF7_FILCOEF14	(SWFG.unWGCH2FILCOEF7.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2FILCOEF7_FILCOEF15	(SWFG.unWGCH2FILCOEF7.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch2filcoef7_field{
    uint_io32_t		u16FILCOEF14:16;
    uint_io32_t		u16FILCOEF15:16;
}stc_swfg_wgch2filcoef7_field_t;

typedef union un_swfg_wgch2filcoef7{
    uint_io32_t		u32Register;
    stc_swfg_wgch2filcoef7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2filcoef7_t;

/* WGCH2CTRL0 */
#define SWFG_WGCH2CTRL0	(SWFG.unWGCH2CTRL0.u32Register)  /*@rg@*/
#define SWFG_WGCH2CTRL0_ADPHASECH	(SWFG.unWGCH2CTRL0.stcField.u3ADPHASECH)  /*@bf@*/
#define SWFG_WGCH2CTRL0_ADPHASEEN	(SWFG.unWGCH2CTRL0.stcField.u1ADPHASEEN)  /*@bf@*/
#define SWFG_WGCH2CTRL0_PCMZEROEN	(SWFG.unWGCH2CTRL0.stcField.u1PCMZEROEN)  /*@bf@*/
#define SWFG_WGCH2CTRL0_CONTNUM	(SWFG.unWGCH2CTRL0.stcField.u4CONTNUM)  /*@bf@*/
#define SWFG_WGCH2CTRL0_STOPREL	(SWFG.unWGCH2CTRL0.stcField.u3STOPREL)  /*@bf@*/
#define SWFG_WGCH2CTRL0_FILEN	(SWFG.unWGCH2CTRL0.stcField.u1FILEN)  /*@bf@*/

typedef struct stc_swfg_wgch2ctrl0_field{
    uint_io32_t		u3ADPHASECH:3;
    uint_io32_t		u1ADPHASEEN:1;
    uint_io32_t		:4;
    uint_io32_t		u1PCMZEROEN:1;
    uint_io32_t		:7;
    uint_io32_t		u4CONTNUM:4;
    uint_io32_t		:4;
    uint_io32_t		u3STOPREL:3;
    uint_io32_t		:4;
    uint_io32_t		u1FILEN:1;
}stc_swfg_wgch2ctrl0_field_t;

typedef union un_swfg_wgch2ctrl0{
    uint_io32_t		u32Register;
    stc_swfg_wgch2ctrl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2ctrl0_t;

/* WGCH2CTRL1 */
#define SWFG_WGCH2CTRL1	(SWFG.unWGCH2CTRL1.u32Register)  /*@rg@*/
#define SWFG_WGCH2CTRL1_INITGAIN	(SWFG.unWGCH2CTRL1.stcField.u10INITGAIN)  /*@bf@*/
#define SWFG_WGCH2CTRL1_GAINSUCEN	(SWFG.unWGCH2CTRL1.stcField.u1GAINSUCEN)  /*@bf@*/
#define SWFG_WGCH2CTRL1_GAINFLUCT	(SWFG.unWGCH2CTRL1.stcField.u17GAINFLUCT)  /*@bf@*/
#define SWFG_WGCH2CTRL1_GAINUDSEL	(SWFG.unWGCH2CTRL1.stcField.u1GAINUDSEL)  /*@bf@*/
#define SWFG_WGCH2CTRL1_DBEN	(SWFG.unWGCH2CTRL1.stcField.u1DBEN)  /*@bf@*/

typedef struct stc_swfg_wgch2ctrl1_field{
    uint_io32_t		u10INITGAIN:10;
    uint_io32_t		u1GAINSUCEN:1;
    uint_io32_t		:1;
    uint_io32_t		u17GAINFLUCT:17;
    uint_io32_t		u1GAINUDSEL:1;
    uint_io32_t		:1;
    uint_io32_t		u1DBEN:1;
}stc_swfg_wgch2ctrl1_field_t;

typedef union un_swfg_wgch2ctrl1{
    uint_io32_t		u32Register;
    stc_swfg_wgch2ctrl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2ctrl1_t;

/* WGCH2CTRL2 */
#define SWFG_WGCH2CTRL2	(SWFG.unWGCH2CTRL2.u32Register)  /*@rg@*/
#define SWFG_WGCH2CTRL2_MONO	(SWFG.unWGCH2CTRL2.stcField.u2MONO)  /*@bf@*/
#define SWFG_WGCH2CTRL2_FSINF	(SWFG.unWGCH2CTRL2.stcField.u2FSINF)  /*@bf@*/
#define SWFG_WGCH2CTRL2_DUTY	(SWFG.unWGCH2CTRL2.stcField.u7DUTY)  /*@bf@*/
#define SWFG_WGCH2CTRL2_ATTACK	(SWFG.unWGCH2CTRL2.stcField.u5ATTACK)  /*@bf@*/
#define SWFG_WGCH2CTRL2_ATTCVSEL	(SWFG.unWGCH2CTRL2.stcField.u1ATTCVSEL)  /*@bf@*/
#define SWFG_WGCH2CTRL2_RELEASE	(SWFG.unWGCH2CTRL2.stcField.u5RELEASE)  /*@bf@*/
#define SWFG_WGCH2CTRL2_RELCVSEL	(SWFG.unWGCH2CTRL2.stcField.u1RELCVSEL)  /*@bf@*/

typedef struct stc_swfg_wgch2ctrl2_field{
    uint_io32_t		u2MONO:2;
    uint_io32_t		:2;
    uint_io32_t		u2FSINF:2;
    uint_io32_t		:2;
    uint_io32_t		u7DUTY:7;
    uint_io32_t		:1;
    uint_io32_t		u5ATTACK:5;
    uint_io32_t		:2;
    uint_io32_t		u1ATTCVSEL:1;
    uint_io32_t		u5RELEASE:5;
    uint_io32_t		:2;
    uint_io32_t		u1RELCVSEL:1;
}stc_swfg_wgch2ctrl2_field_t;

typedef union un_swfg_wgch2ctrl2{
    uint_io32_t		u32Register;
    stc_swfg_wgch2ctrl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2ctrl2_t;

/* WGCH2CTRL3 */
#define SWFG_WGCH2CTRL3	(SWFG.unWGCH2CTRL3.u32Register)  /*@rg@*/
#define SWFG_WGCH2CTRL3_ITVAL1	(SWFG.unWGCH2CTRL3.stcField.u14ITVAL1)  /*@bf@*/
#define SWFG_WGCH2CTRL3_ITVAL2	(SWFG.unWGCH2CTRL3.stcField.u14ITVAL2)  /*@bf@*/

typedef struct stc_swfg_wgch2ctrl3_field{
    uint_io32_t		u14ITVAL1:14;
    uint_io32_t		:2;
    uint_io32_t		u14ITVAL2:14;
    uint_io32_t		:2;
}stc_swfg_wgch2ctrl3_field_t;

typedef union un_swfg_wgch2ctrl3{
    uint_io32_t		u32Register;
    stc_swfg_wgch2ctrl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2ctrl3_t;

/* WGCH2CTRL4 */
#define SWFG_WGCH2CTRL4	(SWFG.unWGCH2CTRL4.u32Register)  /*@rg@*/
#define SWFG_WGCH2CTRL4_FSFREQ	(SWFG.unWGCH2CTRL4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH2CTRL4_FSLEN	(SWFG.unWGCH2CTRL4.stcField.u14FSLEN)  /*@bf@*/
#define SWFG_WGCH2CTRL4_CH0START	(SWFG.unWGCH2CTRL4.stcField.u1CH0START)  /*@bf@*/

typedef struct stc_swfg_wgch2ctrl4_field{
    uint_io32_t		u16FSFREQ:16;
    uint_io32_t		u14FSLEN:14;
    uint_io32_t		:1;
    uint_io32_t		u1CH0START:1;
}stc_swfg_wgch2ctrl4_field_t;

typedef union un_swfg_wgch2ctrl4{
    uint_io32_t		u32Register;
    stc_swfg_wgch2ctrl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2ctrl4_t;

/* WGCH2STATUS */
#define SWFG_WGCH2STATUS	(SWFG.unWGCH2STATUS.u32Register)  /*@rg@*/
#define SWFG_WGCH2STATUS_ENDGAIN	(SWFG.unWGCH2STATUS.stcField.u10ENDGAIN)  /*@bf@*/
#define SWFG_WGCH2STATUS_ENDGAINV	(SWFG.unWGCH2STATUS.stcField.u1ENDGAINV)  /*@bf@*/
#define SWFG_WGCH2STATUS_CONTNUMR	(SWFG.unWGCH2STATUS.stcField.u4CONTNUMR)  /*@bf@*/

typedef struct stc_swfg_wgch2status_field{
    uint_io32_t		u10ENDGAIN:10;
    uint_io32_t		:5;
    uint_io32_t		u1ENDGAINV:1;
    uint_io32_t		u4CONTNUMR:4;
    uint_io32_t		:12;
}stc_swfg_wgch2status_field_t;

typedef union un_swfg_wgch2status{
    uint_io32_t		u32Register;
    stc_swfg_wgch2status_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch2status_t;

/* WGCH3FILCOEF0 */
#define SWFG_WGCH3FILCOEF0	(SWFG.unWGCH3FILCOEF0.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF0_FILCOEF0	(SWFG.unWGCH3FILCOEF0.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF0_FILCOEF1	(SWFG.unWGCH3FILCOEF0.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef0_field{
    uint_io32_t		u16FILCOEF0:16;
    uint_io32_t		u16FILCOEF1:16;
}stc_swfg_wgch3filcoef0_field_t;

typedef union un_swfg_wgch3filcoef0{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef0_t;

/* WGCH3FILCOEF1 */
#define SWFG_WGCH3FILCOEF1	(SWFG.unWGCH3FILCOEF1.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF1_FILCOEF2	(SWFG.unWGCH3FILCOEF1.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF1_FILCOEF3	(SWFG.unWGCH3FILCOEF1.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef1_field{
    uint_io32_t		u16FILCOEF2:16;
    uint_io32_t		u16FILCOEF3:16;
}stc_swfg_wgch3filcoef1_field_t;

typedef union un_swfg_wgch3filcoef1{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef1_t;

/* WGCH3FILCOEF2 */
#define SWFG_WGCH3FILCOEF2	(SWFG.unWGCH3FILCOEF2.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF2_FILCOEF4	(SWFG.unWGCH3FILCOEF2.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF2_FILCOEF5	(SWFG.unWGCH3FILCOEF2.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef2_field{
    uint_io32_t		u16FILCOEF4:16;
    uint_io32_t		u16FILCOEF5:16;
}stc_swfg_wgch3filcoef2_field_t;

typedef union un_swfg_wgch3filcoef2{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef2_t;

/* WGCH3FILCOEF3 */
#define SWFG_WGCH3FILCOEF3	(SWFG.unWGCH3FILCOEF3.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF3_FILCOEF6	(SWFG.unWGCH3FILCOEF3.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF3_FILCOEF7	(SWFG.unWGCH3FILCOEF3.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef3_field{
    uint_io32_t		u16FILCOEF6:16;
    uint_io32_t		u16FILCOEF7:16;
}stc_swfg_wgch3filcoef3_field_t;

typedef union un_swfg_wgch3filcoef3{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef3_t;

/* WGCH3FILCOEF4 */
#define SWFG_WGCH3FILCOEF4	(SWFG.unWGCH3FILCOEF4.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF4_FILCOEF8	(SWFG.unWGCH3FILCOEF4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF4_FILCOEF9	(SWFG.unWGCH3FILCOEF4.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef4_field{
    uint_io32_t		u16FILCOEF8:16;
    uint_io32_t		u16FILCOEF9:16;
}stc_swfg_wgch3filcoef4_field_t;

typedef union un_swfg_wgch3filcoef4{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef4_t;

/* WGCH3FILCOEF5 */
#define SWFG_WGCH3FILCOEF5	(SWFG.unWGCH3FILCOEF5.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF5_FILCOEF10	(SWFG.unWGCH3FILCOEF5.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF5_FILCOEF11	(SWFG.unWGCH3FILCOEF5.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef5_field{
    uint_io32_t		u16FILCOEF10:16;
    uint_io32_t		u16FILCOEF11:16;
}stc_swfg_wgch3filcoef5_field_t;

typedef union un_swfg_wgch3filcoef5{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef5_t;

/* WGCH3FILCOEF6 */
#define SWFG_WGCH3FILCOEF6	(SWFG.unWGCH3FILCOEF6.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF6_FILCOEF12	(SWFG.unWGCH3FILCOEF6.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF6_FILCOEF13	(SWFG.unWGCH3FILCOEF6.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef6_field{
    uint_io32_t		u16FILCOEF12:16;
    uint_io32_t		u16FILCOEF13:16;
}stc_swfg_wgch3filcoef6_field_t;

typedef union un_swfg_wgch3filcoef6{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef6_t;

/* WGCH3FILCOEF7 */
#define SWFG_WGCH3FILCOEF7	(SWFG.unWGCH3FILCOEF7.u32Register)  /*@rg@*/
#define SWFG_WGCH3FILCOEF7_FILCOEF14	(SWFG.unWGCH3FILCOEF7.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3FILCOEF7_FILCOEF15	(SWFG.unWGCH3FILCOEF7.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch3filcoef7_field{
    uint_io32_t		u16FILCOEF14:16;
    uint_io32_t		u16FILCOEF15:16;
}stc_swfg_wgch3filcoef7_field_t;

typedef union un_swfg_wgch3filcoef7{
    uint_io32_t		u32Register;
    stc_swfg_wgch3filcoef7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3filcoef7_t;

/* WGCH3CTRL0 */
#define SWFG_WGCH3CTRL0	(SWFG.unWGCH3CTRL0.u32Register)  /*@rg@*/
#define SWFG_WGCH3CTRL0_ADPHASECH	(SWFG.unWGCH3CTRL0.stcField.u3ADPHASECH)  /*@bf@*/
#define SWFG_WGCH3CTRL0_ADPHASEEN	(SWFG.unWGCH3CTRL0.stcField.u1ADPHASEEN)  /*@bf@*/
#define SWFG_WGCH3CTRL0_PCMZEROEN	(SWFG.unWGCH3CTRL0.stcField.u1PCMZEROEN)  /*@bf@*/
#define SWFG_WGCH3CTRL0_CONTNUM	(SWFG.unWGCH3CTRL0.stcField.u4CONTNUM)  /*@bf@*/
#define SWFG_WGCH3CTRL0_STOPREL	(SWFG.unWGCH3CTRL0.stcField.u3STOPREL)  /*@bf@*/
#define SWFG_WGCH3CTRL0_FILEN	(SWFG.unWGCH3CTRL0.stcField.u1FILEN)  /*@bf@*/

typedef struct stc_swfg_wgch3ctrl0_field{
    uint_io32_t		u3ADPHASECH:3;
    uint_io32_t		u1ADPHASEEN:1;
    uint_io32_t		:4;
    uint_io32_t		u1PCMZEROEN:1;
    uint_io32_t		:7;
    uint_io32_t		u4CONTNUM:4;
    uint_io32_t		:4;
    uint_io32_t		u3STOPREL:3;
    uint_io32_t		:4;
    uint_io32_t		u1FILEN:1;
}stc_swfg_wgch3ctrl0_field_t;

typedef union un_swfg_wgch3ctrl0{
    uint_io32_t		u32Register;
    stc_swfg_wgch3ctrl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3ctrl0_t;

/* WGCH3CTRL1 */
#define SWFG_WGCH3CTRL1	(SWFG.unWGCH3CTRL1.u32Register)  /*@rg@*/
#define SWFG_WGCH3CTRL1_INITGAIN	(SWFG.unWGCH3CTRL1.stcField.u10INITGAIN)  /*@bf@*/
#define SWFG_WGCH3CTRL1_GAINSUCEN	(SWFG.unWGCH3CTRL1.stcField.u1GAINSUCEN)  /*@bf@*/
#define SWFG_WGCH3CTRL1_GAINFLUCT	(SWFG.unWGCH3CTRL1.stcField.u17GAINFLUCT)  /*@bf@*/
#define SWFG_WGCH3CTRL1_GAINUDSEL	(SWFG.unWGCH3CTRL1.stcField.u1GAINUDSEL)  /*@bf@*/
#define SWFG_WGCH3CTRL1_DBEN	(SWFG.unWGCH3CTRL1.stcField.u1DBEN)  /*@bf@*/

typedef struct stc_swfg_wgch3ctrl1_field{
    uint_io32_t		u10INITGAIN:10;
    uint_io32_t		u1GAINSUCEN:1;
    uint_io32_t		:1;
    uint_io32_t		u17GAINFLUCT:17;
    uint_io32_t		u1GAINUDSEL:1;
    uint_io32_t		:1;
    uint_io32_t		u1DBEN:1;
}stc_swfg_wgch3ctrl1_field_t;

typedef union un_swfg_wgch3ctrl1{
    uint_io32_t		u32Register;
    stc_swfg_wgch3ctrl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3ctrl1_t;

/* WGCH3CTRL2 */
#define SWFG_WGCH3CTRL2	(SWFG.unWGCH3CTRL2.u32Register)  /*@rg@*/
#define SWFG_WGCH3CTRL2_MONO	(SWFG.unWGCH3CTRL2.stcField.u2MONO)  /*@bf@*/
#define SWFG_WGCH3CTRL2_FSINF	(SWFG.unWGCH3CTRL2.stcField.u2FSINF)  /*@bf@*/
#define SWFG_WGCH3CTRL2_DUTY	(SWFG.unWGCH3CTRL2.stcField.u7DUTY)  /*@bf@*/
#define SWFG_WGCH3CTRL2_ATTACK	(SWFG.unWGCH3CTRL2.stcField.u5ATTACK)  /*@bf@*/
#define SWFG_WGCH3CTRL2_ATTCVSEL	(SWFG.unWGCH3CTRL2.stcField.u1ATTCVSEL)  /*@bf@*/
#define SWFG_WGCH3CTRL2_RELEASE	(SWFG.unWGCH3CTRL2.stcField.u5RELEASE)  /*@bf@*/
#define SWFG_WGCH3CTRL2_RELCVSEL	(SWFG.unWGCH3CTRL2.stcField.u1RELCVSEL)  /*@bf@*/

typedef struct stc_swfg_wgch3ctrl2_field{
    uint_io32_t		u2MONO:2;
    uint_io32_t		:2;
    uint_io32_t		u2FSINF:2;
    uint_io32_t		:2;
    uint_io32_t		u7DUTY:7;
    uint_io32_t		:1;
    uint_io32_t		u5ATTACK:5;
    uint_io32_t		:2;
    uint_io32_t		u1ATTCVSEL:1;
    uint_io32_t		u5RELEASE:5;
    uint_io32_t		:2;
    uint_io32_t		u1RELCVSEL:1;
}stc_swfg_wgch3ctrl2_field_t;

typedef union un_swfg_wgch3ctrl2{
    uint_io32_t		u32Register;
    stc_swfg_wgch3ctrl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3ctrl2_t;

/* WGCH3CTRL3 */
#define SWFG_WGCH3CTRL3	(SWFG.unWGCH3CTRL3.u32Register)  /*@rg@*/
#define SWFG_WGCH3CTRL3_ITVAL1	(SWFG.unWGCH3CTRL3.stcField.u14ITVAL1)  /*@bf@*/
#define SWFG_WGCH3CTRL3_ITVAL2	(SWFG.unWGCH3CTRL3.stcField.u14ITVAL2)  /*@bf@*/

typedef struct stc_swfg_wgch3ctrl3_field{
    uint_io32_t		u14ITVAL1:14;
    uint_io32_t		:2;
    uint_io32_t		u14ITVAL2:14;
    uint_io32_t		:2;
}stc_swfg_wgch3ctrl3_field_t;

typedef union un_swfg_wgch3ctrl3{
    uint_io32_t		u32Register;
    stc_swfg_wgch3ctrl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3ctrl3_t;

/* WGCH3CTRL4 */
#define SWFG_WGCH3CTRL4	(SWFG.unWGCH3CTRL4.u32Register)  /*@rg@*/
#define SWFG_WGCH3CTRL4_FSFREQ	(SWFG.unWGCH3CTRL4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH3CTRL4_FSLEN	(SWFG.unWGCH3CTRL4.stcField.u14FSLEN)  /*@bf@*/
#define SWFG_WGCH3CTRL4_CH0START	(SWFG.unWGCH3CTRL4.stcField.u1CH0START)  /*@bf@*/

typedef struct stc_swfg_wgch3ctrl4_field{
    uint_io32_t		u16FSFREQ:16;
    uint_io32_t		u14FSLEN:14;
    uint_io32_t		:1;
    uint_io32_t		u1CH0START:1;
}stc_swfg_wgch3ctrl4_field_t;

typedef union un_swfg_wgch3ctrl4{
    uint_io32_t		u32Register;
    stc_swfg_wgch3ctrl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3ctrl4_t;

/* WGCH3STATUS */
#define SWFG_WGCH3STATUS	(SWFG.unWGCH3STATUS.u32Register)  /*@rg@*/
#define SWFG_WGCH3STATUS_ENDGAIN	(SWFG.unWGCH3STATUS.stcField.u10ENDGAIN)  /*@bf@*/
#define SWFG_WGCH3STATUS_ENDGAINV	(SWFG.unWGCH3STATUS.stcField.u1ENDGAINV)  /*@bf@*/
#define SWFG_WGCH3STATUS_CONTNUMR	(SWFG.unWGCH3STATUS.stcField.u4CONTNUMR)  /*@bf@*/

typedef struct stc_swfg_wgch3status_field{
    uint_io32_t		u10ENDGAIN:10;
    uint_io32_t		:5;
    uint_io32_t		u1ENDGAINV:1;
    uint_io32_t		u4CONTNUMR:4;
    uint_io32_t		:12;
}stc_swfg_wgch3status_field_t;

typedef union un_swfg_wgch3status{
    uint_io32_t		u32Register;
    stc_swfg_wgch3status_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch3status_t;

/* WGCH4FILCOEF0 */
#define SWFG_WGCH4FILCOEF0	(SWFG.unWGCH4FILCOEF0.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF0_FILCOEF0	(SWFG.unWGCH4FILCOEF0.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF0_FILCOEF1	(SWFG.unWGCH4FILCOEF0.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef0_field{
    uint_io32_t		u16FILCOEF0:16;
    uint_io32_t		u16FILCOEF1:16;
}stc_swfg_wgch4filcoef0_field_t;

typedef union un_swfg_wgch4filcoef0{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef0_t;

/* WGCH4FILCOEF1 */
#define SWFG_WGCH4FILCOEF1	(SWFG.unWGCH4FILCOEF1.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF1_FILCOEF2	(SWFG.unWGCH4FILCOEF1.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF1_FILCOEF3	(SWFG.unWGCH4FILCOEF1.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef1_field{
    uint_io32_t		u16FILCOEF2:16;
    uint_io32_t		u16FILCOEF3:16;
}stc_swfg_wgch4filcoef1_field_t;

typedef union un_swfg_wgch4filcoef1{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef1_t;

/* WGCH4FILCOEF2 */
#define SWFG_WGCH4FILCOEF2	(SWFG.unWGCH4FILCOEF2.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF2_FILCOEF4	(SWFG.unWGCH4FILCOEF2.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF2_FILCOEF5	(SWFG.unWGCH4FILCOEF2.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef2_field{
    uint_io32_t		u16FILCOEF4:16;
    uint_io32_t		u16FILCOEF5:16;
}stc_swfg_wgch4filcoef2_field_t;

typedef union un_swfg_wgch4filcoef2{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef2_t;

/* WGCH4FILCOEF3 */
#define SWFG_WGCH4FILCOEF3	(SWFG.unWGCH4FILCOEF3.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF3_FILCOEF6	(SWFG.unWGCH4FILCOEF3.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF3_FILCOEF7	(SWFG.unWGCH4FILCOEF3.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef3_field{
    uint_io32_t		u16FILCOEF6:16;
    uint_io32_t		u16FILCOEF7:16;
}stc_swfg_wgch4filcoef3_field_t;

typedef union un_swfg_wgch4filcoef3{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef3_t;

/* WGCH4FILCOEF4 */
#define SWFG_WGCH4FILCOEF4	(SWFG.unWGCH4FILCOEF4.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF4_FILCOEF8	(SWFG.unWGCH4FILCOEF4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF4_FILCOEF9	(SWFG.unWGCH4FILCOEF4.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef4_field{
    uint_io32_t		u16FILCOEF8:16;
    uint_io32_t		u16FILCOEF9:16;
}stc_swfg_wgch4filcoef4_field_t;

typedef union un_swfg_wgch4filcoef4{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef4_t;

/* WGCH4FILCOEF5 */
#define SWFG_WGCH4FILCOEF5	(SWFG.unWGCH4FILCOEF5.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF5_FILCOEF10	(SWFG.unWGCH4FILCOEF5.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF5_FILCOEF11	(SWFG.unWGCH4FILCOEF5.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef5_field{
    uint_io32_t		u16FILCOEF10:16;
    uint_io32_t		u16FILCOEF11:16;
}stc_swfg_wgch4filcoef5_field_t;

typedef union un_swfg_wgch4filcoef5{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef5_t;

/* WGCH4FILCOEF6 */
#define SWFG_WGCH4FILCOEF6	(SWFG.unWGCH4FILCOEF6.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF6_FILCOEF12	(SWFG.unWGCH4FILCOEF6.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF6_FILCOEF13	(SWFG.unWGCH4FILCOEF6.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef6_field{
    uint_io32_t		u16FILCOEF12:16;
    uint_io32_t		u16FILCOEF13:16;
}stc_swfg_wgch4filcoef6_field_t;

typedef union un_swfg_wgch4filcoef6{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef6_t;

/* WGCH4FILCOEF7 */
#define SWFG_WGCH4FILCOEF7	(SWFG.unWGCH4FILCOEF7.u32Register)  /*@rg@*/
#define SWFG_WGCH4FILCOEF7_FILCOEF14	(SWFG.unWGCH4FILCOEF7.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4FILCOEF7_FILCOEF15	(SWFG.unWGCH4FILCOEF7.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_swfg_wgch4filcoef7_field{
    uint_io32_t		u16FILCOEF14:16;
    uint_io32_t		u16FILCOEF15:16;
}stc_swfg_wgch4filcoef7_field_t;

typedef union un_swfg_wgch4filcoef7{
    uint_io32_t		u32Register;
    stc_swfg_wgch4filcoef7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4filcoef7_t;

/* WGCH4CTRL0 */
#define SWFG_WGCH4CTRL0	(SWFG.unWGCH4CTRL0.u32Register)  /*@rg@*/
#define SWFG_WGCH4CTRL0_ADPHASECH	(SWFG.unWGCH4CTRL0.stcField.u3ADPHASECH)  /*@bf@*/
#define SWFG_WGCH4CTRL0_ADPHASEEN	(SWFG.unWGCH4CTRL0.stcField.u1ADPHASEEN)  /*@bf@*/
#define SWFG_WGCH4CTRL0_PCMZEROEN	(SWFG.unWGCH4CTRL0.stcField.u1PCMZEROEN)  /*@bf@*/
#define SWFG_WGCH4CTRL0_CONTNUM	(SWFG.unWGCH4CTRL0.stcField.u4CONTNUM)  /*@bf@*/
#define SWFG_WGCH4CTRL0_STOPREL	(SWFG.unWGCH4CTRL0.stcField.u3STOPREL)  /*@bf@*/
#define SWFG_WGCH4CTRL0_FILEN	(SWFG.unWGCH4CTRL0.stcField.u1FILEN)  /*@bf@*/

typedef struct stc_swfg_wgch4ctrl0_field{
    uint_io32_t		u3ADPHASECH:3;
    uint_io32_t		u1ADPHASEEN:1;
    uint_io32_t		:4;
    uint_io32_t		u1PCMZEROEN:1;
    uint_io32_t		:7;
    uint_io32_t		u4CONTNUM:4;
    uint_io32_t		:4;
    uint_io32_t		u3STOPREL:3;
    uint_io32_t		:4;
    uint_io32_t		u1FILEN:1;
}stc_swfg_wgch4ctrl0_field_t;

typedef union un_swfg_wgch4ctrl0{
    uint_io32_t		u32Register;
    stc_swfg_wgch4ctrl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4ctrl0_t;

/* WGCH4CTRL1 */
#define SWFG_WGCH4CTRL1	(SWFG.unWGCH4CTRL1.u32Register)  /*@rg@*/
#define SWFG_WGCH4CTRL1_INITGAIN	(SWFG.unWGCH4CTRL1.stcField.u10INITGAIN)  /*@bf@*/
#define SWFG_WGCH4CTRL1_GAINSUCEN	(SWFG.unWGCH4CTRL1.stcField.u1GAINSUCEN)  /*@bf@*/
#define SWFG_WGCH4CTRL1_GAINFLUCT	(SWFG.unWGCH4CTRL1.stcField.u17GAINFLUCT)  /*@bf@*/
#define SWFG_WGCH4CTRL1_GAINUDSEL	(SWFG.unWGCH4CTRL1.stcField.u1GAINUDSEL)  /*@bf@*/
#define SWFG_WGCH4CTRL1_DBEN	(SWFG.unWGCH4CTRL1.stcField.u1DBEN)  /*@bf@*/

typedef struct stc_swfg_wgch4ctrl1_field{
    uint_io32_t		u10INITGAIN:10;
    uint_io32_t		u1GAINSUCEN:1;
    uint_io32_t		:1;
    uint_io32_t		u17GAINFLUCT:17;
    uint_io32_t		u1GAINUDSEL:1;
    uint_io32_t		:1;
    uint_io32_t		u1DBEN:1;
}stc_swfg_wgch4ctrl1_field_t;

typedef union un_swfg_wgch4ctrl1{
    uint_io32_t		u32Register;
    stc_swfg_wgch4ctrl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4ctrl1_t;

/* WGCH4CTRL2 */
#define SWFG_WGCH4CTRL2	(SWFG.unWGCH4CTRL2.u32Register)  /*@rg@*/
#define SWFG_WGCH4CTRL2_MONO	(SWFG.unWGCH4CTRL2.stcField.u2MONO)  /*@bf@*/
#define SWFG_WGCH4CTRL2_FSINF	(SWFG.unWGCH4CTRL2.stcField.u2FSINF)  /*@bf@*/
#define SWFG_WGCH4CTRL2_DUTY	(SWFG.unWGCH4CTRL2.stcField.u7DUTY)  /*@bf@*/
#define SWFG_WGCH4CTRL2_ATTACK	(SWFG.unWGCH4CTRL2.stcField.u5ATTACK)  /*@bf@*/
#define SWFG_WGCH4CTRL2_ATTCVSEL	(SWFG.unWGCH4CTRL2.stcField.u1ATTCVSEL)  /*@bf@*/
#define SWFG_WGCH4CTRL2_RELEASE	(SWFG.unWGCH4CTRL2.stcField.u5RELEASE)  /*@bf@*/
#define SWFG_WGCH4CTRL2_RELCVSEL	(SWFG.unWGCH4CTRL2.stcField.u1RELCVSEL)  /*@bf@*/

typedef struct stc_swfg_wgch4ctrl2_field{
    uint_io32_t		u2MONO:2;
    uint_io32_t		:2;
    uint_io32_t		u2FSINF:2;
    uint_io32_t		:2;
    uint_io32_t		u7DUTY:7;
    uint_io32_t		:1;
    uint_io32_t		u5ATTACK:5;
    uint_io32_t		:2;
    uint_io32_t		u1ATTCVSEL:1;
    uint_io32_t		u5RELEASE:5;
    uint_io32_t		:2;
    uint_io32_t		u1RELCVSEL:1;
}stc_swfg_wgch4ctrl2_field_t;

typedef union un_swfg_wgch4ctrl2{
    uint_io32_t		u32Register;
    stc_swfg_wgch4ctrl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4ctrl2_t;

/* WGCH4CTRL3 */
#define SWFG_WGCH4CTRL3	(SWFG.unWGCH4CTRL3.u32Register)  /*@rg@*/
#define SWFG_WGCH4CTRL3_ITVAL1	(SWFG.unWGCH4CTRL3.stcField.u14ITVAL1)  /*@bf@*/
#define SWFG_WGCH4CTRL3_ITVAL2	(SWFG.unWGCH4CTRL3.stcField.u14ITVAL2)  /*@bf@*/

typedef struct stc_swfg_wgch4ctrl3_field{
    uint_io32_t		u14ITVAL1:14;
    uint_io32_t		:2;
    uint_io32_t		u14ITVAL2:14;
    uint_io32_t		:2;
}stc_swfg_wgch4ctrl3_field_t;

typedef union un_swfg_wgch4ctrl3{
    uint_io32_t		u32Register;
    stc_swfg_wgch4ctrl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4ctrl3_t;

/* WGCH4CTRL4 */
#define SWFG_WGCH4CTRL4	(SWFG.unWGCH4CTRL4.u32Register)  /*@rg@*/
#define SWFG_WGCH4CTRL4_FSFREQ	(SWFG.unWGCH4CTRL4.au16Halfword[0])  /*@bfhword@*/
#define SWFG_WGCH4CTRL4_FSLEN	(SWFG.unWGCH4CTRL4.stcField.u14FSLEN)  /*@bf@*/
#define SWFG_WGCH4CTRL4_CH0START	(SWFG.unWGCH4CTRL4.stcField.u1CH0START)  /*@bf@*/

typedef struct stc_swfg_wgch4ctrl4_field{
    uint_io32_t		u16FSFREQ:16;
    uint_io32_t		u14FSLEN:14;
    uint_io32_t		:1;
    uint_io32_t		u1CH0START:1;
}stc_swfg_wgch4ctrl4_field_t;

typedef union un_swfg_wgch4ctrl4{
    uint_io32_t		u32Register;
    stc_swfg_wgch4ctrl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4ctrl4_t;

/* WGCH4STATUS */
#define SWFG_WGCH4STATUS	(SWFG.unWGCH4STATUS.u32Register)  /*@rg@*/
#define SWFG_WGCH4STATUS_ENDGAIN	(SWFG.unWGCH4STATUS.stcField.u10ENDGAIN)  /*@bf@*/
#define SWFG_WGCH4STATUS_ENDGAINV	(SWFG.unWGCH4STATUS.stcField.u1ENDGAINV)  /*@bf@*/
#define SWFG_WGCH4STATUS_CONTNUMR	(SWFG.unWGCH4STATUS.stcField.u4CONTNUMR)  /*@bf@*/

typedef struct stc_swfg_wgch4status_field{
    uint_io32_t		u10ENDGAIN:10;
    uint_io32_t		:5;
    uint_io32_t		u1ENDGAINV:1;
    uint_io32_t		u4CONTNUMR:4;
    uint_io32_t		:12;
}stc_swfg_wgch4status_field_t;

typedef union un_swfg_wgch4status{
    uint_io32_t		u32Register;
    stc_swfg_wgch4status_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_swfg_wgch4status_t;


typedef struct stc_swfg{
    un_swfg_wgchen_t	unWGCHEN;	/* 0x00000000 */
    un_swfg_wgchstart_t	unWGCHSTART;	/* 0x00000004 */
    un_swfg_wgchbusy_t	unWGCHBUSY;	/* 0x00000008 */
    un_swfg_wgchstop_t	unWGCHSTOP;	/* 0x0000000C */
    un_swfg_wgchdmaen_t	unWGCHDMAEN;	/* 0x00000010 */
    un_swfg_wgintren_t	unWGINTREN;	/* 0x00000014 */
    un_swfg_wgintrstate_t	unWGINTRSTATE;	/* 0x00000018 */
    un_swfg_wgintrclr_t	unWGINTRCLR;	/* 0x0000001C */
    un_swfg_wgahberr_t	unWGAHBERR;	/* 0x00000020 */
    un_swfg_wgchadd0_t	unWGCHADD0;	/* 0x00000024 */
    un_swfg_wgchadd1_t	unWGCHADD1;	/* 0x00000028 */
    un_swfg_wgchadd2_t	unWGCHADD2;	/* 0x0000002C */
    uint_io8_t	au8Reserved0[80];	/* 0x00000030 */
    un_swfg_wgch0filcoef0_t	unWGCH0FILCOEF0;	/* 0x00000080 */
    un_swfg_wgch0filcoef1_t	unWGCH0FILCOEF1;	/* 0x00000084 */
    un_swfg_wgch0filcoef2_t	unWGCH0FILCOEF2;	/* 0x00000088 */
    un_swfg_wgch0filcoef3_t	unWGCH0FILCOEF3;	/* 0x0000008C */
    un_swfg_wgch0filcoef4_t	unWGCH0FILCOEF4;	/* 0x00000090 */
    un_swfg_wgch0filcoef5_t	unWGCH0FILCOEF5;	/* 0x00000094 */
    un_swfg_wgch0filcoef6_t	unWGCH0FILCOEF6;	/* 0x00000098 */
    un_swfg_wgch0filcoef7_t	unWGCH0FILCOEF7;	/* 0x0000009C */
    un_swfg_wgch0ctrl0_t	unWGCH0CTRL0;	/* 0x000000A0 */
    un_swfg_wgch0ctrl1_t	unWGCH0CTRL1;	/* 0x000000A4 */
    un_swfg_wgch0ctrl2_t	unWGCH0CTRL2;	/* 0x000000A8 */
    un_swfg_wgch0ctrl3_t	unWGCH0CTRL3;	/* 0x000000AC */
    un_swfg_wgch0ctrl4_t	unWGCH0CTRL4;	/* 0x000000B0 */
    un_swfg_wgch0status_t	unWGCH0STATUS;	/* 0x000000B4 */
    uint_io8_t	au8Reserved1[8];	/* 0x000000B8 */
    un_swfg_wgch1filcoef0_t	unWGCH1FILCOEF0;	/* 0x000000C0 */
    un_swfg_wgch1filcoef1_t	unWGCH1FILCOEF1;	/* 0x000000C4 */
    un_swfg_wgch1filcoef2_t	unWGCH1FILCOEF2;	/* 0x000000C8 */
    un_swfg_wgch1filcoef3_t	unWGCH1FILCOEF3;	/* 0x000000CC */
    un_swfg_wgch1filcoef4_t	unWGCH1FILCOEF4;	/* 0x000000D0 */
    un_swfg_wgch1filcoef5_t	unWGCH1FILCOEF5;	/* 0x000000D4 */
    un_swfg_wgch1filcoef6_t	unWGCH1FILCOEF6;	/* 0x000000D8 */
    un_swfg_wgch1filcoef7_t	unWGCH1FILCOEF7;	/* 0x000000DC */
    un_swfg_wgch1ctrl0_t	unWGCH1CTRL0;	/* 0x000000E0 */
    un_swfg_wgch1ctrl1_t	unWGCH1CTRL1;	/* 0x000000E4 */
    un_swfg_wgch1ctrl2_t	unWGCH1CTRL2;	/* 0x000000E8 */
    un_swfg_wgch1ctrl3_t	unWGCH1CTRL3;	/* 0x000000EC */
    un_swfg_wgch1ctrl4_t	unWGCH1CTRL4;	/* 0x000000F0 */
    un_swfg_wgch1status_t	unWGCH1STATUS;	/* 0x000000F4 */
    uint_io8_t	au8Reserved2[8];	/* 0x000000F8 */
    un_swfg_wgch2filcoef0_t	unWGCH2FILCOEF0;	/* 0x00000100 */
    un_swfg_wgch2filcoef1_t	unWGCH2FILCOEF1;	/* 0x00000104 */
    un_swfg_wgch2filcoef2_t	unWGCH2FILCOEF2;	/* 0x00000108 */
    un_swfg_wgch2filcoef3_t	unWGCH2FILCOEF3;	/* 0x0000010C */
    un_swfg_wgch2filcoef4_t	unWGCH2FILCOEF4;	/* 0x00000110 */
    un_swfg_wgch2filcoef5_t	unWGCH2FILCOEF5;	/* 0x00000114 */
    un_swfg_wgch2filcoef6_t	unWGCH2FILCOEF6;	/* 0x00000118 */
    un_swfg_wgch2filcoef7_t	unWGCH2FILCOEF7;	/* 0x0000011C */
    un_swfg_wgch2ctrl0_t	unWGCH2CTRL0;	/* 0x00000120 */
    un_swfg_wgch2ctrl1_t	unWGCH2CTRL1;	/* 0x00000124 */
    un_swfg_wgch2ctrl2_t	unWGCH2CTRL2;	/* 0x00000128 */
    un_swfg_wgch2ctrl3_t	unWGCH2CTRL3;	/* 0x0000012C */
    un_swfg_wgch2ctrl4_t	unWGCH2CTRL4;	/* 0x00000130 */
    un_swfg_wgch2status_t	unWGCH2STATUS;	/* 0x00000134 */
    uint_io8_t	au8Reserved3[8];	/* 0x00000138 */
    un_swfg_wgch3filcoef0_t	unWGCH3FILCOEF0;	/* 0x00000140 */
    un_swfg_wgch3filcoef1_t	unWGCH3FILCOEF1;	/* 0x00000144 */
    un_swfg_wgch3filcoef2_t	unWGCH3FILCOEF2;	/* 0x00000148 */
    un_swfg_wgch3filcoef3_t	unWGCH3FILCOEF3;	/* 0x0000014C */
    un_swfg_wgch3filcoef4_t	unWGCH3FILCOEF4;	/* 0x00000150 */
    un_swfg_wgch3filcoef5_t	unWGCH3FILCOEF5;	/* 0x00000154 */
    un_swfg_wgch3filcoef6_t	unWGCH3FILCOEF6;	/* 0x00000158 */
    un_swfg_wgch3filcoef7_t	unWGCH3FILCOEF7;	/* 0x0000015C */
    un_swfg_wgch3ctrl0_t	unWGCH3CTRL0;	/* 0x00000160 */
    un_swfg_wgch3ctrl1_t	unWGCH3CTRL1;	/* 0x00000164 */
    un_swfg_wgch3ctrl2_t	unWGCH3CTRL2;	/* 0x00000168 */
    un_swfg_wgch3ctrl3_t	unWGCH3CTRL3;	/* 0x0000016C */
    un_swfg_wgch3ctrl4_t	unWGCH3CTRL4;	/* 0x00000170 */
    un_swfg_wgch3status_t	unWGCH3STATUS;	/* 0x00000174 */
    uint_io8_t	au8Reserved4[8];	/* 0x00000178 */
    un_swfg_wgch4filcoef0_t	unWGCH4FILCOEF0;	/* 0x00000180 */
    un_swfg_wgch4filcoef1_t	unWGCH4FILCOEF1;	/* 0x00000184 */
    un_swfg_wgch4filcoef2_t	unWGCH4FILCOEF2;	/* 0x00000188 */
    un_swfg_wgch4filcoef3_t	unWGCH4FILCOEF3;	/* 0x0000018C */
    un_swfg_wgch4filcoef4_t	unWGCH4FILCOEF4;	/* 0x00000190 */
    un_swfg_wgch4filcoef5_t	unWGCH4FILCOEF5;	/* 0x00000194 */
    un_swfg_wgch4filcoef6_t	unWGCH4FILCOEF6;	/* 0x00000198 */
    un_swfg_wgch4filcoef7_t	unWGCH4FILCOEF7;	/* 0x0000019C */
    un_swfg_wgch4ctrl0_t	unWGCH4CTRL0;	/* 0x000001A0 */
    un_swfg_wgch4ctrl1_t	unWGCH4CTRL1;	/* 0x000001A4 */
    un_swfg_wgch4ctrl2_t	unWGCH4CTRL2;	/* 0x000001A8 */
    un_swfg_wgch4ctrl3_t	unWGCH4CTRL3;	/* 0x000001AC */
    un_swfg_wgch4ctrl4_t	unWGCH4CTRL4;	/* 0x000001B0 */
    un_swfg_wgch4status_t	unWGCH4STATUS;	/* 0x000001B4 */
    uint_io8_t	au8Reserved5[584];	/* 0x000001B8 */
}stc_swfg_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_swfg_t	stcSWFG;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_SWFG_H */
