/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_EIC_H
#define __S6J3360_EIC_H

#include "s6j3360io_basetypes.h"

/* EIC00 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define EIC00	stcEIC00
#else /* __IO_DEFINE */
#define EIC00	(*((volatile stc_eic00_t*)0xB0620000))
#endif /* __IO_DEFINE */

/* ENIR */
#define EIC00_ENIR	(EIC00.unENIR.u32Register)  /*@rg@*/
#define EIC00_ENIR_EN0	(EIC00.unENIR.stcField.u1EN0)  /*@bf@*/
#define EIC00_ENIR_EN1	(EIC00.unENIR.stcField.u1EN1)  /*@bf@*/
#define EIC00_ENIR_EN2	(EIC00.unENIR.stcField.u1EN2)  /*@bf@*/
#define EIC00_ENIR_EN3	(EIC00.unENIR.stcField.u1EN3)  /*@bf@*/
#define EIC00_ENIR_EN4	(EIC00.unENIR.stcField.u1EN4)  /*@bf@*/
#define EIC00_ENIR_EN5	(EIC00.unENIR.stcField.u1EN5)  /*@bf@*/
#define EIC00_ENIR_EN6	(EIC00.unENIR.stcField.u1EN6)  /*@bf@*/
#define EIC00_ENIR_EN7	(EIC00.unENIR.stcField.u1EN7)  /*@bf@*/
#define EIC00_ENIR_EN8	(EIC00.unENIR.stcField.u1EN8)  /*@bf@*/
#define EIC00_ENIR_EN9	(EIC00.unENIR.stcField.u1EN9)  /*@bf@*/
#define EIC00_ENIR_EN10	(EIC00.unENIR.stcField.u1EN10)  /*@bf@*/
#define EIC00_ENIR_EN11	(EIC00.unENIR.stcField.u1EN11)  /*@bf@*/
#define EIC00_ENIR_EN12	(EIC00.unENIR.stcField.u1EN12)  /*@bf@*/
#define EIC00_ENIR_EN13	(EIC00.unENIR.stcField.u1EN13)  /*@bf@*/
#define EIC00_ENIR_EN14	(EIC00.unENIR.stcField.u1EN14)  /*@bf@*/
#define EIC00_ENIR_EN15	(EIC00.unENIR.stcField.u1EN15)  /*@bf@*/
#define EIC00_ENIR_EN16	(EIC00.unENIR.stcField.u1EN16)  /*@bf@*/
#define EIC00_ENIR_EN17	(EIC00.unENIR.stcField.u1EN17)  /*@bf@*/
#define EIC00_ENIR_EN18	(EIC00.unENIR.stcField.u1EN18)  /*@bf@*/
#define EIC00_ENIR_EN19	(EIC00.unENIR.stcField.u1EN19)  /*@bf@*/
#define EIC00_ENIR_EN20	(EIC00.unENIR.stcField.u1EN20)  /*@bf@*/
#define EIC00_ENIR_EN21	(EIC00.unENIR.stcField.u1EN21)  /*@bf@*/
#define EIC00_ENIR_EN22	(EIC00.unENIR.stcField.u1EN22)  /*@bf@*/
#define EIC00_ENIR_EN23	(EIC00.unENIR.stcField.u1EN23)  /*@bf@*/
#define EIC00_ENIR_EN24	(EIC00.unENIR.stcField.u1EN24)  /*@bf@*/
#define EIC00_ENIR_EN25	(EIC00.unENIR.stcField.u1EN25)  /*@bf@*/
#define EIC00_ENIR_EN26	(EIC00.unENIR.stcField.u1EN26)  /*@bf@*/
#define EIC00_ENIR_EN27	(EIC00.unENIR.stcField.u1EN27)  /*@bf@*/
#define EIC00_ENIR_EN28	(EIC00.unENIR.stcField.u1EN28)  /*@bf@*/
#define EIC00_ENIR_EN29	(EIC00.unENIR.stcField.u1EN29)  /*@bf@*/
#define EIC00_ENIR_EN30	(EIC00.unENIR.stcField.u1EN30)  /*@bf@*/
#define EIC00_ENIR_EN31	(EIC00.unENIR.stcField.u1EN31)  /*@bf@*/

typedef struct stc_eic00_enir_field{
    uint_io32_t		u1EN0:1;
    uint_io32_t		u1EN1:1;
    uint_io32_t		u1EN2:1;
    uint_io32_t		u1EN3:1;
    uint_io32_t		u1EN4:1;
    uint_io32_t		u1EN5:1;
    uint_io32_t		u1EN6:1;
    uint_io32_t		u1EN7:1;
    uint_io32_t		u1EN8:1;
    uint_io32_t		u1EN9:1;
    uint_io32_t		u1EN10:1;
    uint_io32_t		u1EN11:1;
    uint_io32_t		u1EN12:1;
    uint_io32_t		u1EN13:1;
    uint_io32_t		u1EN14:1;
    uint_io32_t		u1EN15:1;
    uint_io32_t		u1EN16:1;
    uint_io32_t		u1EN17:1;
    uint_io32_t		u1EN18:1;
    uint_io32_t		u1EN19:1;
    uint_io32_t		u1EN20:1;
    uint_io32_t		u1EN21:1;
    uint_io32_t		u1EN22:1;
    uint_io32_t		u1EN23:1;
    uint_io32_t		u1EN24:1;
    uint_io32_t		u1EN25:1;
    uint_io32_t		u1EN26:1;
    uint_io32_t		u1EN27:1;
    uint_io32_t		u1EN28:1;
    uint_io32_t		u1EN29:1;
    uint_io32_t		u1EN30:1;
    uint_io32_t		u1EN31:1;
}stc_eic00_enir_field_t;

typedef union un_eic00_enir{
    uint_io32_t		u32Register;
    stc_eic00_enir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_enir_t;

/* ENISR */
#define EIC00_ENISR	(EIC00.unENISR.u32Register)  /*@rg@*/
#define EIC00_ENISR_ENS0	(EIC00.unENISR.stcField.u1ENS0)  /*@bf@*/
#define EIC00_ENISR_ENS1	(EIC00.unENISR.stcField.u1ENS1)  /*@bf@*/
#define EIC00_ENISR_ENS2	(EIC00.unENISR.stcField.u1ENS2)  /*@bf@*/
#define EIC00_ENISR_ENS3	(EIC00.unENISR.stcField.u1ENS3)  /*@bf@*/
#define EIC00_ENISR_ENS4	(EIC00.unENISR.stcField.u1ENS4)  /*@bf@*/
#define EIC00_ENISR_ENS5	(EIC00.unENISR.stcField.u1ENS5)  /*@bf@*/
#define EIC00_ENISR_ENS6	(EIC00.unENISR.stcField.u1ENS6)  /*@bf@*/
#define EIC00_ENISR_ENS7	(EIC00.unENISR.stcField.u1ENS7)  /*@bf@*/
#define EIC00_ENISR_ENS8	(EIC00.unENISR.stcField.u1ENS8)  /*@bf@*/
#define EIC00_ENISR_ENS9	(EIC00.unENISR.stcField.u1ENS9)  /*@bf@*/
#define EIC00_ENISR_ENS10	(EIC00.unENISR.stcField.u1ENS10)  /*@bf@*/
#define EIC00_ENISR_ENS11	(EIC00.unENISR.stcField.u1ENS11)  /*@bf@*/
#define EIC00_ENISR_ENS12	(EIC00.unENISR.stcField.u1ENS12)  /*@bf@*/
#define EIC00_ENISR_ENS13	(EIC00.unENISR.stcField.u1ENS13)  /*@bf@*/
#define EIC00_ENISR_ENS14	(EIC00.unENISR.stcField.u1ENS14)  /*@bf@*/
#define EIC00_ENISR_ENS15	(EIC00.unENISR.stcField.u1ENS15)  /*@bf@*/
#define EIC00_ENISR_ENS16	(EIC00.unENISR.stcField.u1ENS16)  /*@bf@*/
#define EIC00_ENISR_ENS17	(EIC00.unENISR.stcField.u1ENS17)  /*@bf@*/
#define EIC00_ENISR_ENS18	(EIC00.unENISR.stcField.u1ENS18)  /*@bf@*/
#define EIC00_ENISR_ENS19	(EIC00.unENISR.stcField.u1ENS19)  /*@bf@*/
#define EIC00_ENISR_ENS20	(EIC00.unENISR.stcField.u1ENS20)  /*@bf@*/
#define EIC00_ENISR_ENS21	(EIC00.unENISR.stcField.u1ENS21)  /*@bf@*/
#define EIC00_ENISR_ENS22	(EIC00.unENISR.stcField.u1ENS22)  /*@bf@*/
#define EIC00_ENISR_ENS23	(EIC00.unENISR.stcField.u1ENS23)  /*@bf@*/
#define EIC00_ENISR_ENS24	(EIC00.unENISR.stcField.u1ENS24)  /*@bf@*/
#define EIC00_ENISR_ENS25	(EIC00.unENISR.stcField.u1ENS25)  /*@bf@*/
#define EIC00_ENISR_ENS26	(EIC00.unENISR.stcField.u1ENS26)  /*@bf@*/
#define EIC00_ENISR_ENS27	(EIC00.unENISR.stcField.u1ENS27)  /*@bf@*/
#define EIC00_ENISR_ENS28	(EIC00.unENISR.stcField.u1ENS28)  /*@bf@*/
#define EIC00_ENISR_ENS29	(EIC00.unENISR.stcField.u1ENS29)  /*@bf@*/
#define EIC00_ENISR_ENS30	(EIC00.unENISR.stcField.u1ENS30)  /*@bf@*/
#define EIC00_ENISR_ENS31	(EIC00.unENISR.stcField.u1ENS31)  /*@bf@*/

typedef struct stc_eic00_enisr_field{
    uint_io32_t		u1ENS0:1;
    uint_io32_t		u1ENS1:1;
    uint_io32_t		u1ENS2:1;
    uint_io32_t		u1ENS3:1;
    uint_io32_t		u1ENS4:1;
    uint_io32_t		u1ENS5:1;
    uint_io32_t		u1ENS6:1;
    uint_io32_t		u1ENS7:1;
    uint_io32_t		u1ENS8:1;
    uint_io32_t		u1ENS9:1;
    uint_io32_t		u1ENS10:1;
    uint_io32_t		u1ENS11:1;
    uint_io32_t		u1ENS12:1;
    uint_io32_t		u1ENS13:1;
    uint_io32_t		u1ENS14:1;
    uint_io32_t		u1ENS15:1;
    uint_io32_t		u1ENS16:1;
    uint_io32_t		u1ENS17:1;
    uint_io32_t		u1ENS18:1;
    uint_io32_t		u1ENS19:1;
    uint_io32_t		u1ENS20:1;
    uint_io32_t		u1ENS21:1;
    uint_io32_t		u1ENS22:1;
    uint_io32_t		u1ENS23:1;
    uint_io32_t		u1ENS24:1;
    uint_io32_t		u1ENS25:1;
    uint_io32_t		u1ENS26:1;
    uint_io32_t		u1ENS27:1;
    uint_io32_t		u1ENS28:1;
    uint_io32_t		u1ENS29:1;
    uint_io32_t		u1ENS30:1;
    uint_io32_t		u1ENS31:1;
}stc_eic00_enisr_field_t;

typedef union un_eic00_enisr{
    uint_io32_t		u32Register;
    stc_eic00_enisr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_enisr_t;

/* ENICR */
#define EIC00_ENICR	(EIC00.unENICR.u32Register)  /*@rg@*/
#define EIC00_ENICR_ENC0	(EIC00.unENICR.stcField.u1ENC0)  /*@bf@*/
#define EIC00_ENICR_ENC1	(EIC00.unENICR.stcField.u1ENC1)  /*@bf@*/
#define EIC00_ENICR_ENC2	(EIC00.unENICR.stcField.u1ENC2)  /*@bf@*/
#define EIC00_ENICR_ENC3	(EIC00.unENICR.stcField.u1ENC3)  /*@bf@*/
#define EIC00_ENICR_ENC4	(EIC00.unENICR.stcField.u1ENC4)  /*@bf@*/
#define EIC00_ENICR_ENC5	(EIC00.unENICR.stcField.u1ENC5)  /*@bf@*/
#define EIC00_ENICR_ENC6	(EIC00.unENICR.stcField.u1ENC6)  /*@bf@*/
#define EIC00_ENICR_ENC7	(EIC00.unENICR.stcField.u1ENC7)  /*@bf@*/
#define EIC00_ENICR_ENC8	(EIC00.unENICR.stcField.u1ENC8)  /*@bf@*/
#define EIC00_ENICR_ENC9	(EIC00.unENICR.stcField.u1ENC9)  /*@bf@*/
#define EIC00_ENICR_ENC10	(EIC00.unENICR.stcField.u1ENC10)  /*@bf@*/
#define EIC00_ENICR_ENC11	(EIC00.unENICR.stcField.u1ENC11)  /*@bf@*/
#define EIC00_ENICR_ENC12	(EIC00.unENICR.stcField.u1ENC12)  /*@bf@*/
#define EIC00_ENICR_ENC13	(EIC00.unENICR.stcField.u1ENC13)  /*@bf@*/
#define EIC00_ENICR_ENC14	(EIC00.unENICR.stcField.u1ENC14)  /*@bf@*/
#define EIC00_ENICR_ENC15	(EIC00.unENICR.stcField.u1ENC15)  /*@bf@*/
#define EIC00_ENICR_ENC16	(EIC00.unENICR.stcField.u1ENC16)  /*@bf@*/
#define EIC00_ENICR_ENC17	(EIC00.unENICR.stcField.u1ENC17)  /*@bf@*/
#define EIC00_ENICR_ENC18	(EIC00.unENICR.stcField.u1ENC18)  /*@bf@*/
#define EIC00_ENICR_ENC19	(EIC00.unENICR.stcField.u1ENC19)  /*@bf@*/
#define EIC00_ENICR_ENC20	(EIC00.unENICR.stcField.u1ENC20)  /*@bf@*/
#define EIC00_ENICR_ENC21	(EIC00.unENICR.stcField.u1ENC21)  /*@bf@*/
#define EIC00_ENICR_ENC22	(EIC00.unENICR.stcField.u1ENC22)  /*@bf@*/
#define EIC00_ENICR_ENC23	(EIC00.unENICR.stcField.u1ENC23)  /*@bf@*/
#define EIC00_ENICR_ENC24	(EIC00.unENICR.stcField.u1ENC24)  /*@bf@*/
#define EIC00_ENICR_ENC25	(EIC00.unENICR.stcField.u1ENC25)  /*@bf@*/
#define EIC00_ENICR_ENC26	(EIC00.unENICR.stcField.u1ENC26)  /*@bf@*/
#define EIC00_ENICR_ENC27	(EIC00.unENICR.stcField.u1ENC27)  /*@bf@*/
#define EIC00_ENICR_ENC28	(EIC00.unENICR.stcField.u1ENC28)  /*@bf@*/
#define EIC00_ENICR_ENC29	(EIC00.unENICR.stcField.u1ENC29)  /*@bf@*/
#define EIC00_ENICR_ENC30	(EIC00.unENICR.stcField.u1ENC30)  /*@bf@*/
#define EIC00_ENICR_ENC31	(EIC00.unENICR.stcField.u1ENC31)  /*@bf@*/

typedef struct stc_eic00_enicr_field{
    uint_io32_t		u1ENC0:1;
    uint_io32_t		u1ENC1:1;
    uint_io32_t		u1ENC2:1;
    uint_io32_t		u1ENC3:1;
    uint_io32_t		u1ENC4:1;
    uint_io32_t		u1ENC5:1;
    uint_io32_t		u1ENC6:1;
    uint_io32_t		u1ENC7:1;
    uint_io32_t		u1ENC8:1;
    uint_io32_t		u1ENC9:1;
    uint_io32_t		u1ENC10:1;
    uint_io32_t		u1ENC11:1;
    uint_io32_t		u1ENC12:1;
    uint_io32_t		u1ENC13:1;
    uint_io32_t		u1ENC14:1;
    uint_io32_t		u1ENC15:1;
    uint_io32_t		u1ENC16:1;
    uint_io32_t		u1ENC17:1;
    uint_io32_t		u1ENC18:1;
    uint_io32_t		u1ENC19:1;
    uint_io32_t		u1ENC20:1;
    uint_io32_t		u1ENC21:1;
    uint_io32_t		u1ENC22:1;
    uint_io32_t		u1ENC23:1;
    uint_io32_t		u1ENC24:1;
    uint_io32_t		u1ENC25:1;
    uint_io32_t		u1ENC26:1;
    uint_io32_t		u1ENC27:1;
    uint_io32_t		u1ENC28:1;
    uint_io32_t		u1ENC29:1;
    uint_io32_t		u1ENC30:1;
    uint_io32_t		u1ENC31:1;
}stc_eic00_enicr_field_t;

typedef union un_eic00_enicr{
    uint_io32_t		u32Register;
    stc_eic00_enicr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_enicr_t;

/* EIRR */
#define EIC00_EIRR	(EIC00.unEIRR.u32Register)  /*@rg@*/
#define EIC00_EIRR_ER0	(EIC00.unEIRR.stcField.u1ER0)  /*@bf@*/
#define EIC00_EIRR_ER1	(EIC00.unEIRR.stcField.u1ER1)  /*@bf@*/
#define EIC00_EIRR_ER2	(EIC00.unEIRR.stcField.u1ER2)  /*@bf@*/
#define EIC00_EIRR_ER3	(EIC00.unEIRR.stcField.u1ER3)  /*@bf@*/
#define EIC00_EIRR_ER4	(EIC00.unEIRR.stcField.u1ER4)  /*@bf@*/
#define EIC00_EIRR_ER5	(EIC00.unEIRR.stcField.u1ER5)  /*@bf@*/
#define EIC00_EIRR_ER6	(EIC00.unEIRR.stcField.u1ER6)  /*@bf@*/
#define EIC00_EIRR_ER7	(EIC00.unEIRR.stcField.u1ER7)  /*@bf@*/
#define EIC00_EIRR_ER8	(EIC00.unEIRR.stcField.u1ER8)  /*@bf@*/
#define EIC00_EIRR_ER9	(EIC00.unEIRR.stcField.u1ER9)  /*@bf@*/
#define EIC00_EIRR_ER10	(EIC00.unEIRR.stcField.u1ER10)  /*@bf@*/
#define EIC00_EIRR_ER11	(EIC00.unEIRR.stcField.u1ER11)  /*@bf@*/
#define EIC00_EIRR_ER12	(EIC00.unEIRR.stcField.u1ER12)  /*@bf@*/
#define EIC00_EIRR_ER13	(EIC00.unEIRR.stcField.u1ER13)  /*@bf@*/
#define EIC00_EIRR_ER14	(EIC00.unEIRR.stcField.u1ER14)  /*@bf@*/
#define EIC00_EIRR_ER15	(EIC00.unEIRR.stcField.u1ER15)  /*@bf@*/
#define EIC00_EIRR_ER16	(EIC00.unEIRR.stcField.u1ER16)  /*@bf@*/
#define EIC00_EIRR_ER17	(EIC00.unEIRR.stcField.u1ER17)  /*@bf@*/
#define EIC00_EIRR_ER18	(EIC00.unEIRR.stcField.u1ER18)  /*@bf@*/
#define EIC00_EIRR_ER19	(EIC00.unEIRR.stcField.u1ER19)  /*@bf@*/
#define EIC00_EIRR_ER20	(EIC00.unEIRR.stcField.u1ER20)  /*@bf@*/
#define EIC00_EIRR_ER21	(EIC00.unEIRR.stcField.u1ER21)  /*@bf@*/
#define EIC00_EIRR_ER22	(EIC00.unEIRR.stcField.u1ER22)  /*@bf@*/
#define EIC00_EIRR_ER23	(EIC00.unEIRR.stcField.u1ER23)  /*@bf@*/
#define EIC00_EIRR_ER24	(EIC00.unEIRR.stcField.u1ER24)  /*@bf@*/
#define EIC00_EIRR_ER25	(EIC00.unEIRR.stcField.u1ER25)  /*@bf@*/
#define EIC00_EIRR_ER26	(EIC00.unEIRR.stcField.u1ER26)  /*@bf@*/
#define EIC00_EIRR_ER27	(EIC00.unEIRR.stcField.u1ER27)  /*@bf@*/
#define EIC00_EIRR_ER28	(EIC00.unEIRR.stcField.u1ER28)  /*@bf@*/
#define EIC00_EIRR_ER29	(EIC00.unEIRR.stcField.u1ER29)  /*@bf@*/
#define EIC00_EIRR_ER30	(EIC00.unEIRR.stcField.u1ER30)  /*@bf@*/
#define EIC00_EIRR_ER31	(EIC00.unEIRR.stcField.u1ER31)  /*@bf@*/

typedef struct stc_eic00_eirr_field{
    uint_io32_t		u1ER0:1;
    uint_io32_t		u1ER1:1;
    uint_io32_t		u1ER2:1;
    uint_io32_t		u1ER3:1;
    uint_io32_t		u1ER4:1;
    uint_io32_t		u1ER5:1;
    uint_io32_t		u1ER6:1;
    uint_io32_t		u1ER7:1;
    uint_io32_t		u1ER8:1;
    uint_io32_t		u1ER9:1;
    uint_io32_t		u1ER10:1;
    uint_io32_t		u1ER11:1;
    uint_io32_t		u1ER12:1;
    uint_io32_t		u1ER13:1;
    uint_io32_t		u1ER14:1;
    uint_io32_t		u1ER15:1;
    uint_io32_t		u1ER16:1;
    uint_io32_t		u1ER17:1;
    uint_io32_t		u1ER18:1;
    uint_io32_t		u1ER19:1;
    uint_io32_t		u1ER20:1;
    uint_io32_t		u1ER21:1;
    uint_io32_t		u1ER22:1;
    uint_io32_t		u1ER23:1;
    uint_io32_t		u1ER24:1;
    uint_io32_t		u1ER25:1;
    uint_io32_t		u1ER26:1;
    uint_io32_t		u1ER27:1;
    uint_io32_t		u1ER28:1;
    uint_io32_t		u1ER29:1;
    uint_io32_t		u1ER30:1;
    uint_io32_t		u1ER31:1;
}stc_eic00_eirr_field_t;

typedef union un_eic00_eirr{
    uint_io32_t		u32Register;
    stc_eic00_eirr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_eirr_t;

/* EIRCR */
#define EIC00_EIRCR	(EIC00.unEIRCR.u32Register)  /*@rg@*/
#define EIC00_EIRCR_ERC0	(EIC00.unEIRCR.stcField.u1ERC0)  /*@bf@*/
#define EIC00_EIRCR_ERC1	(EIC00.unEIRCR.stcField.u1ERC1)  /*@bf@*/
#define EIC00_EIRCR_ERC2	(EIC00.unEIRCR.stcField.u1ERC2)  /*@bf@*/
#define EIC00_EIRCR_ERC3	(EIC00.unEIRCR.stcField.u1ERC3)  /*@bf@*/
#define EIC00_EIRCR_ERC4	(EIC00.unEIRCR.stcField.u1ERC4)  /*@bf@*/
#define EIC00_EIRCR_ERC5	(EIC00.unEIRCR.stcField.u1ERC5)  /*@bf@*/
#define EIC00_EIRCR_ERC6	(EIC00.unEIRCR.stcField.u1ERC6)  /*@bf@*/
#define EIC00_EIRCR_ERC7	(EIC00.unEIRCR.stcField.u1ERC7)  /*@bf@*/
#define EIC00_EIRCR_ERC8	(EIC00.unEIRCR.stcField.u1ERC8)  /*@bf@*/
#define EIC00_EIRCR_ERC9	(EIC00.unEIRCR.stcField.u1ERC9)  /*@bf@*/
#define EIC00_EIRCR_ERC10	(EIC00.unEIRCR.stcField.u1ERC10)  /*@bf@*/
#define EIC00_EIRCR_ERC11	(EIC00.unEIRCR.stcField.u1ERC11)  /*@bf@*/
#define EIC00_EIRCR_ERC12	(EIC00.unEIRCR.stcField.u1ERC12)  /*@bf@*/
#define EIC00_EIRCR_ERC13	(EIC00.unEIRCR.stcField.u1ERC13)  /*@bf@*/
#define EIC00_EIRCR_ERC14	(EIC00.unEIRCR.stcField.u1ERC14)  /*@bf@*/
#define EIC00_EIRCR_ERC15	(EIC00.unEIRCR.stcField.u1ERC15)  /*@bf@*/
#define EIC00_EIRCR_ERC16	(EIC00.unEIRCR.stcField.u1ERC16)  /*@bf@*/
#define EIC00_EIRCR_ERC17	(EIC00.unEIRCR.stcField.u1ERC17)  /*@bf@*/
#define EIC00_EIRCR_ERC18	(EIC00.unEIRCR.stcField.u1ERC18)  /*@bf@*/
#define EIC00_EIRCR_ERC19	(EIC00.unEIRCR.stcField.u1ERC19)  /*@bf@*/
#define EIC00_EIRCR_ERC20	(EIC00.unEIRCR.stcField.u1ERC20)  /*@bf@*/
#define EIC00_EIRCR_ERC21	(EIC00.unEIRCR.stcField.u1ERC21)  /*@bf@*/
#define EIC00_EIRCR_ERC22	(EIC00.unEIRCR.stcField.u1ERC22)  /*@bf@*/
#define EIC00_EIRCR_ERC23	(EIC00.unEIRCR.stcField.u1ERC23)  /*@bf@*/
#define EIC00_EIRCR_ERC24	(EIC00.unEIRCR.stcField.u1ERC24)  /*@bf@*/
#define EIC00_EIRCR_ERC25	(EIC00.unEIRCR.stcField.u1ERC25)  /*@bf@*/
#define EIC00_EIRCR_ERC26	(EIC00.unEIRCR.stcField.u1ERC26)  /*@bf@*/
#define EIC00_EIRCR_ERC27	(EIC00.unEIRCR.stcField.u1ERC27)  /*@bf@*/
#define EIC00_EIRCR_ERC28	(EIC00.unEIRCR.stcField.u1ERC28)  /*@bf@*/
#define EIC00_EIRCR_ERC29	(EIC00.unEIRCR.stcField.u1ERC29)  /*@bf@*/
#define EIC00_EIRCR_ERC30	(EIC00.unEIRCR.stcField.u1ERC30)  /*@bf@*/
#define EIC00_EIRCR_ERC31	(EIC00.unEIRCR.stcField.u1ERC31)  /*@bf@*/

typedef struct stc_eic00_eircr_field{
    uint_io32_t		u1ERC0:1;
    uint_io32_t		u1ERC1:1;
    uint_io32_t		u1ERC2:1;
    uint_io32_t		u1ERC3:1;
    uint_io32_t		u1ERC4:1;
    uint_io32_t		u1ERC5:1;
    uint_io32_t		u1ERC6:1;
    uint_io32_t		u1ERC7:1;
    uint_io32_t		u1ERC8:1;
    uint_io32_t		u1ERC9:1;
    uint_io32_t		u1ERC10:1;
    uint_io32_t		u1ERC11:1;
    uint_io32_t		u1ERC12:1;
    uint_io32_t		u1ERC13:1;
    uint_io32_t		u1ERC14:1;
    uint_io32_t		u1ERC15:1;
    uint_io32_t		u1ERC16:1;
    uint_io32_t		u1ERC17:1;
    uint_io32_t		u1ERC18:1;
    uint_io32_t		u1ERC19:1;
    uint_io32_t		u1ERC20:1;
    uint_io32_t		u1ERC21:1;
    uint_io32_t		u1ERC22:1;
    uint_io32_t		u1ERC23:1;
    uint_io32_t		u1ERC24:1;
    uint_io32_t		u1ERC25:1;
    uint_io32_t		u1ERC26:1;
    uint_io32_t		u1ERC27:1;
    uint_io32_t		u1ERC28:1;
    uint_io32_t		u1ERC29:1;
    uint_io32_t		u1ERC30:1;
    uint_io32_t		u1ERC31:1;
}stc_eic00_eircr_field_t;

typedef union un_eic00_eircr{
    uint_io32_t		u32Register;
    stc_eic00_eircr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_eircr_t;

/* NFER */
#define EIC00_NFER	(EIC00.unNFER.u32Register)  /*@rg@*/
#define EIC00_NFER_NFE0	(EIC00.unNFER.stcField.u1NFE0)  /*@bf@*/
#define EIC00_NFER_NFE1	(EIC00.unNFER.stcField.u1NFE1)  /*@bf@*/
#define EIC00_NFER_NFE2	(EIC00.unNFER.stcField.u1NFE2)  /*@bf@*/
#define EIC00_NFER_NFE3	(EIC00.unNFER.stcField.u1NFE3)  /*@bf@*/
#define EIC00_NFER_NFE4	(EIC00.unNFER.stcField.u1NFE4)  /*@bf@*/
#define EIC00_NFER_NFE5	(EIC00.unNFER.stcField.u1NFE5)  /*@bf@*/
#define EIC00_NFER_NFE6	(EIC00.unNFER.stcField.u1NFE6)  /*@bf@*/
#define EIC00_NFER_NFE7	(EIC00.unNFER.stcField.u1NFE7)  /*@bf@*/
#define EIC00_NFER_NFE8	(EIC00.unNFER.stcField.u1NFE8)  /*@bf@*/
#define EIC00_NFER_NFE9	(EIC00.unNFER.stcField.u1NFE9)  /*@bf@*/
#define EIC00_NFER_NFE10	(EIC00.unNFER.stcField.u1NFE10)  /*@bf@*/
#define EIC00_NFER_NFE11	(EIC00.unNFER.stcField.u1NFE11)  /*@bf@*/
#define EIC00_NFER_NFE12	(EIC00.unNFER.stcField.u1NFE12)  /*@bf@*/
#define EIC00_NFER_NFE13	(EIC00.unNFER.stcField.u1NFE13)  /*@bf@*/
#define EIC00_NFER_NFE14	(EIC00.unNFER.stcField.u1NFE14)  /*@bf@*/
#define EIC00_NFER_NFE15	(EIC00.unNFER.stcField.u1NFE15)  /*@bf@*/
#define EIC00_NFER_NFE16	(EIC00.unNFER.stcField.u1NFE16)  /*@bf@*/
#define EIC00_NFER_NFE17	(EIC00.unNFER.stcField.u1NFE17)  /*@bf@*/
#define EIC00_NFER_NFE18	(EIC00.unNFER.stcField.u1NFE18)  /*@bf@*/
#define EIC00_NFER_NFE19	(EIC00.unNFER.stcField.u1NFE19)  /*@bf@*/
#define EIC00_NFER_NFE20	(EIC00.unNFER.stcField.u1NFE20)  /*@bf@*/
#define EIC00_NFER_NFE21	(EIC00.unNFER.stcField.u1NFE21)  /*@bf@*/
#define EIC00_NFER_NFE22	(EIC00.unNFER.stcField.u1NFE22)  /*@bf@*/
#define EIC00_NFER_NFE23	(EIC00.unNFER.stcField.u1NFE23)  /*@bf@*/
#define EIC00_NFER_NFE24	(EIC00.unNFER.stcField.u1NFE24)  /*@bf@*/
#define EIC00_NFER_NFE25	(EIC00.unNFER.stcField.u1NFE25)  /*@bf@*/
#define EIC00_NFER_NFE26	(EIC00.unNFER.stcField.u1NFE26)  /*@bf@*/
#define EIC00_NFER_NFE27	(EIC00.unNFER.stcField.u1NFE27)  /*@bf@*/
#define EIC00_NFER_NFE28	(EIC00.unNFER.stcField.u1NFE28)  /*@bf@*/
#define EIC00_NFER_NFE29	(EIC00.unNFER.stcField.u1NFE29)  /*@bf@*/
#define EIC00_NFER_NFE30	(EIC00.unNFER.stcField.u1NFE30)  /*@bf@*/
#define EIC00_NFER_NFE31	(EIC00.unNFER.stcField.u1NFE31)  /*@bf@*/

typedef struct stc_eic00_nfer_field{
    uint_io32_t		u1NFE0:1;
    uint_io32_t		u1NFE1:1;
    uint_io32_t		u1NFE2:1;
    uint_io32_t		u1NFE3:1;
    uint_io32_t		u1NFE4:1;
    uint_io32_t		u1NFE5:1;
    uint_io32_t		u1NFE6:1;
    uint_io32_t		u1NFE7:1;
    uint_io32_t		u1NFE8:1;
    uint_io32_t		u1NFE9:1;
    uint_io32_t		u1NFE10:1;
    uint_io32_t		u1NFE11:1;
    uint_io32_t		u1NFE12:1;
    uint_io32_t		u1NFE13:1;
    uint_io32_t		u1NFE14:1;
    uint_io32_t		u1NFE15:1;
    uint_io32_t		u1NFE16:1;
    uint_io32_t		u1NFE17:1;
    uint_io32_t		u1NFE18:1;
    uint_io32_t		u1NFE19:1;
    uint_io32_t		u1NFE20:1;
    uint_io32_t		u1NFE21:1;
    uint_io32_t		u1NFE22:1;
    uint_io32_t		u1NFE23:1;
    uint_io32_t		u1NFE24:1;
    uint_io32_t		u1NFE25:1;
    uint_io32_t		u1NFE26:1;
    uint_io32_t		u1NFE27:1;
    uint_io32_t		u1NFE28:1;
    uint_io32_t		u1NFE29:1;
    uint_io32_t		u1NFE30:1;
    uint_io32_t		u1NFE31:1;
}stc_eic00_nfer_field_t;

typedef union un_eic00_nfer{
    uint_io32_t		u32Register;
    stc_eic00_nfer_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nfer_t;

/* NFESR */
#define EIC00_NFESR	(EIC00.unNFESR.u32Register)  /*@rg@*/
#define EIC00_NFESR_NFES0	(EIC00.unNFESR.stcField.u1NFES0)  /*@bf@*/
#define EIC00_NFESR_NFES1	(EIC00.unNFESR.stcField.u1NFES1)  /*@bf@*/
#define EIC00_NFESR_NFES2	(EIC00.unNFESR.stcField.u1NFES2)  /*@bf@*/
#define EIC00_NFESR_NFES3	(EIC00.unNFESR.stcField.u1NFES3)  /*@bf@*/
#define EIC00_NFESR_NFES4	(EIC00.unNFESR.stcField.u1NFES4)  /*@bf@*/
#define EIC00_NFESR_NFES5	(EIC00.unNFESR.stcField.u1NFES5)  /*@bf@*/
#define EIC00_NFESR_NFES6	(EIC00.unNFESR.stcField.u1NFES6)  /*@bf@*/
#define EIC00_NFESR_NFES7	(EIC00.unNFESR.stcField.u1NFES7)  /*@bf@*/
#define EIC00_NFESR_NFES8	(EIC00.unNFESR.stcField.u1NFES8)  /*@bf@*/
#define EIC00_NFESR_NFES9	(EIC00.unNFESR.stcField.u1NFES9)  /*@bf@*/
#define EIC00_NFESR_NFES10	(EIC00.unNFESR.stcField.u1NFES10)  /*@bf@*/
#define EIC00_NFESR_NFES11	(EIC00.unNFESR.stcField.u1NFES11)  /*@bf@*/
#define EIC00_NFESR_NFES12	(EIC00.unNFESR.stcField.u1NFES12)  /*@bf@*/
#define EIC00_NFESR_NFES13	(EIC00.unNFESR.stcField.u1NFES13)  /*@bf@*/
#define EIC00_NFESR_NFES14	(EIC00.unNFESR.stcField.u1NFES14)  /*@bf@*/
#define EIC00_NFESR_NFES15	(EIC00.unNFESR.stcField.u1NFES15)  /*@bf@*/
#define EIC00_NFESR_NFES16	(EIC00.unNFESR.stcField.u1NFES16)  /*@bf@*/
#define EIC00_NFESR_NFES17	(EIC00.unNFESR.stcField.u1NFES17)  /*@bf@*/
#define EIC00_NFESR_NFES18	(EIC00.unNFESR.stcField.u1NFES18)  /*@bf@*/
#define EIC00_NFESR_NFES19	(EIC00.unNFESR.stcField.u1NFES19)  /*@bf@*/
#define EIC00_NFESR_NFES20	(EIC00.unNFESR.stcField.u1NFES20)  /*@bf@*/
#define EIC00_NFESR_NFES21	(EIC00.unNFESR.stcField.u1NFES21)  /*@bf@*/
#define EIC00_NFESR_NFES22	(EIC00.unNFESR.stcField.u1NFES22)  /*@bf@*/
#define EIC00_NFESR_NFES23	(EIC00.unNFESR.stcField.u1NFES23)  /*@bf@*/
#define EIC00_NFESR_NFES24	(EIC00.unNFESR.stcField.u1NFES24)  /*@bf@*/
#define EIC00_NFESR_NFES25	(EIC00.unNFESR.stcField.u1NFES25)  /*@bf@*/
#define EIC00_NFESR_NFES26	(EIC00.unNFESR.stcField.u1NFES26)  /*@bf@*/
#define EIC00_NFESR_NFES27	(EIC00.unNFESR.stcField.u1NFES27)  /*@bf@*/
#define EIC00_NFESR_NFES28	(EIC00.unNFESR.stcField.u1NFES28)  /*@bf@*/
#define EIC00_NFESR_NFES29	(EIC00.unNFESR.stcField.u1NFES29)  /*@bf@*/
#define EIC00_NFESR_NFES30	(EIC00.unNFESR.stcField.u1NFES30)  /*@bf@*/
#define EIC00_NFESR_NFES31	(EIC00.unNFESR.stcField.u1NFES31)  /*@bf@*/

typedef struct stc_eic00_nfesr_field{
    uint_io32_t		u1NFES0:1;
    uint_io32_t		u1NFES1:1;
    uint_io32_t		u1NFES2:1;
    uint_io32_t		u1NFES3:1;
    uint_io32_t		u1NFES4:1;
    uint_io32_t		u1NFES5:1;
    uint_io32_t		u1NFES6:1;
    uint_io32_t		u1NFES7:1;
    uint_io32_t		u1NFES8:1;
    uint_io32_t		u1NFES9:1;
    uint_io32_t		u1NFES10:1;
    uint_io32_t		u1NFES11:1;
    uint_io32_t		u1NFES12:1;
    uint_io32_t		u1NFES13:1;
    uint_io32_t		u1NFES14:1;
    uint_io32_t		u1NFES15:1;
    uint_io32_t		u1NFES16:1;
    uint_io32_t		u1NFES17:1;
    uint_io32_t		u1NFES18:1;
    uint_io32_t		u1NFES19:1;
    uint_io32_t		u1NFES20:1;
    uint_io32_t		u1NFES21:1;
    uint_io32_t		u1NFES22:1;
    uint_io32_t		u1NFES23:1;
    uint_io32_t		u1NFES24:1;
    uint_io32_t		u1NFES25:1;
    uint_io32_t		u1NFES26:1;
    uint_io32_t		u1NFES27:1;
    uint_io32_t		u1NFES28:1;
    uint_io32_t		u1NFES29:1;
    uint_io32_t		u1NFES30:1;
    uint_io32_t		u1NFES31:1;
}stc_eic00_nfesr_field_t;

typedef union un_eic00_nfesr{
    uint_io32_t		u32Register;
    stc_eic00_nfesr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nfesr_t;

/* NFECR */
#define EIC00_NFECR	(EIC00.unNFECR.u32Register)  /*@rg@*/
#define EIC00_NFECR_NFEC0	(EIC00.unNFECR.stcField.u1NFEC0)  /*@bf@*/
#define EIC00_NFECR_NFEC1	(EIC00.unNFECR.stcField.u1NFEC1)  /*@bf@*/
#define EIC00_NFECR_NFEC2	(EIC00.unNFECR.stcField.u1NFEC2)  /*@bf@*/
#define EIC00_NFECR_NFEC3	(EIC00.unNFECR.stcField.u1NFEC3)  /*@bf@*/
#define EIC00_NFECR_NFEC4	(EIC00.unNFECR.stcField.u1NFEC4)  /*@bf@*/
#define EIC00_NFECR_NFEC5	(EIC00.unNFECR.stcField.u1NFEC5)  /*@bf@*/
#define EIC00_NFECR_NFEC6	(EIC00.unNFECR.stcField.u1NFEC6)  /*@bf@*/
#define EIC00_NFECR_NFEC7	(EIC00.unNFECR.stcField.u1NFEC7)  /*@bf@*/
#define EIC00_NFECR_NFEC8	(EIC00.unNFECR.stcField.u1NFEC8)  /*@bf@*/
#define EIC00_NFECR_NFEC9	(EIC00.unNFECR.stcField.u1NFEC9)  /*@bf@*/
#define EIC00_NFECR_NFEC10	(EIC00.unNFECR.stcField.u1NFEC10)  /*@bf@*/
#define EIC00_NFECR_NFEC11	(EIC00.unNFECR.stcField.u1NFEC11)  /*@bf@*/
#define EIC00_NFECR_NFEC12	(EIC00.unNFECR.stcField.u1NFEC12)  /*@bf@*/
#define EIC00_NFECR_NFEC13	(EIC00.unNFECR.stcField.u1NFEC13)  /*@bf@*/
#define EIC00_NFECR_NFEC14	(EIC00.unNFECR.stcField.u1NFEC14)  /*@bf@*/
#define EIC00_NFECR_NFEC15	(EIC00.unNFECR.stcField.u1NFEC15)  /*@bf@*/
#define EIC00_NFECR_NFEC16	(EIC00.unNFECR.stcField.u1NFEC16)  /*@bf@*/
#define EIC00_NFECR_NFEC17	(EIC00.unNFECR.stcField.u1NFEC17)  /*@bf@*/
#define EIC00_NFECR_NFEC18	(EIC00.unNFECR.stcField.u1NFEC18)  /*@bf@*/
#define EIC00_NFECR_NFEC19	(EIC00.unNFECR.stcField.u1NFEC19)  /*@bf@*/
#define EIC00_NFECR_NFEC20	(EIC00.unNFECR.stcField.u1NFEC20)  /*@bf@*/
#define EIC00_NFECR_NFEC21	(EIC00.unNFECR.stcField.u1NFEC21)  /*@bf@*/
#define EIC00_NFECR_NFEC22	(EIC00.unNFECR.stcField.u1NFEC22)  /*@bf@*/
#define EIC00_NFECR_NFEC23	(EIC00.unNFECR.stcField.u1NFEC23)  /*@bf@*/
#define EIC00_NFECR_NFEC24	(EIC00.unNFECR.stcField.u1NFEC24)  /*@bf@*/
#define EIC00_NFECR_NFEC25	(EIC00.unNFECR.stcField.u1NFEC25)  /*@bf@*/
#define EIC00_NFECR_NFEC26	(EIC00.unNFECR.stcField.u1NFEC26)  /*@bf@*/
#define EIC00_NFECR_NFEC27	(EIC00.unNFECR.stcField.u1NFEC27)  /*@bf@*/
#define EIC00_NFECR_NFEC28	(EIC00.unNFECR.stcField.u1NFEC28)  /*@bf@*/
#define EIC00_NFECR_NFEC29	(EIC00.unNFECR.stcField.u1NFEC29)  /*@bf@*/
#define EIC00_NFECR_NFEC30	(EIC00.unNFECR.stcField.u1NFEC30)  /*@bf@*/
#define EIC00_NFECR_NFEC31	(EIC00.unNFECR.stcField.u1NFEC31)  /*@bf@*/

typedef struct stc_eic00_nfecr_field{
    uint_io32_t		u1NFEC0:1;
    uint_io32_t		u1NFEC1:1;
    uint_io32_t		u1NFEC2:1;
    uint_io32_t		u1NFEC3:1;
    uint_io32_t		u1NFEC4:1;
    uint_io32_t		u1NFEC5:1;
    uint_io32_t		u1NFEC6:1;
    uint_io32_t		u1NFEC7:1;
    uint_io32_t		u1NFEC8:1;
    uint_io32_t		u1NFEC9:1;
    uint_io32_t		u1NFEC10:1;
    uint_io32_t		u1NFEC11:1;
    uint_io32_t		u1NFEC12:1;
    uint_io32_t		u1NFEC13:1;
    uint_io32_t		u1NFEC14:1;
    uint_io32_t		u1NFEC15:1;
    uint_io32_t		u1NFEC16:1;
    uint_io32_t		u1NFEC17:1;
    uint_io32_t		u1NFEC18:1;
    uint_io32_t		u1NFEC19:1;
    uint_io32_t		u1NFEC20:1;
    uint_io32_t		u1NFEC21:1;
    uint_io32_t		u1NFEC22:1;
    uint_io32_t		u1NFEC23:1;
    uint_io32_t		u1NFEC24:1;
    uint_io32_t		u1NFEC25:1;
    uint_io32_t		u1NFEC26:1;
    uint_io32_t		u1NFEC27:1;
    uint_io32_t		u1NFEC28:1;
    uint_io32_t		u1NFEC29:1;
    uint_io32_t		u1NFEC30:1;
    uint_io32_t		u1NFEC31:1;
}stc_eic00_nfecr_field_t;

typedef union un_eic00_nfecr{
    uint_io32_t		u32Register;
    stc_eic00_nfecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nfecr_t;

/* ELVR[0-3] */
#define EIC00_ELVR0	(EIC00.unELVR0.u32Register)  /*@rg@*/
#define EIC00_ELVR0_LA0	(EIC00.unELVR0.stcField.u1LA0)  /*@bf@*/
#define EIC00_ELVR0_LB0	(EIC00.unELVR0.stcField.u1LB0)  /*@bf@*/
#define EIC00_ELVR0_LC0	(EIC00.unELVR0.stcField.u1LC0)  /*@bf@*/
#define EIC00_ELVR0_LA1	(EIC00.unELVR0.stcField.u1LA1)  /*@bf@*/
#define EIC00_ELVR0_LB1	(EIC00.unELVR0.stcField.u1LB1)  /*@bf@*/
#define EIC00_ELVR0_LC1	(EIC00.unELVR0.stcField.u1LC1)  /*@bf@*/
#define EIC00_ELVR0_LA2	(EIC00.unELVR0.stcField.u1LA2)  /*@bf@*/
#define EIC00_ELVR0_LB2	(EIC00.unELVR0.stcField.u1LB2)  /*@bf@*/
#define EIC00_ELVR0_LC2	(EIC00.unELVR0.stcField.u1LC2)  /*@bf@*/
#define EIC00_ELVR0_LA3	(EIC00.unELVR0.stcField.u1LA3)  /*@bf@*/
#define EIC00_ELVR0_LB3	(EIC00.unELVR0.stcField.u1LB3)  /*@bf@*/
#define EIC00_ELVR0_LC3	(EIC00.unELVR0.stcField.u1LC3)  /*@bf@*/
#define EIC00_ELVR0_LA4	(EIC00.unELVR0.stcField.u1LA4)  /*@bf@*/
#define EIC00_ELVR0_LB4	(EIC00.unELVR0.stcField.u1LB4)  /*@bf@*/
#define EIC00_ELVR0_LC4	(EIC00.unELVR0.stcField.u1LC4)  /*@bf@*/
#define EIC00_ELVR0_LA5	(EIC00.unELVR0.stcField.u1LA5)  /*@bf@*/
#define EIC00_ELVR0_LB5	(EIC00.unELVR0.stcField.u1LB5)  /*@bf@*/
#define EIC00_ELVR0_LC5	(EIC00.unELVR0.stcField.u1LC5)  /*@bf@*/
#define EIC00_ELVR0_LA6	(EIC00.unELVR0.stcField.u1LA6)  /*@bf@*/
#define EIC00_ELVR0_LB6	(EIC00.unELVR0.stcField.u1LB6)  /*@bf@*/
#define EIC00_ELVR0_LC6	(EIC00.unELVR0.stcField.u1LC6)  /*@bf@*/
#define EIC00_ELVR0_LA7	(EIC00.unELVR0.stcField.u1LA7)  /*@bf@*/
#define EIC00_ELVR0_LB7	(EIC00.unELVR0.stcField.u1LB7)  /*@bf@*/
#define EIC00_ELVR0_LC7	(EIC00.unELVR0.stcField.u1LC7)  /*@bf@*/

#define EIC00_ELVR1	(EIC00.unELVR1.u32Register)  /*@rg@*/
#define EIC00_ELVR1_LA0	(EIC00.unELVR1.stcField.u1LA0)  /*@bf@*/
#define EIC00_ELVR1_LB0	(EIC00.unELVR1.stcField.u1LB0)  /*@bf@*/
#define EIC00_ELVR1_LC0	(EIC00.unELVR1.stcField.u1LC0)  /*@bf@*/
#define EIC00_ELVR1_LA1	(EIC00.unELVR1.stcField.u1LA1)  /*@bf@*/
#define EIC00_ELVR1_LB1	(EIC00.unELVR1.stcField.u1LB1)  /*@bf@*/
#define EIC00_ELVR1_LC1	(EIC00.unELVR1.stcField.u1LC1)  /*@bf@*/
#define EIC00_ELVR1_LA2	(EIC00.unELVR1.stcField.u1LA2)  /*@bf@*/
#define EIC00_ELVR1_LB2	(EIC00.unELVR1.stcField.u1LB2)  /*@bf@*/
#define EIC00_ELVR1_LC2	(EIC00.unELVR1.stcField.u1LC2)  /*@bf@*/
#define EIC00_ELVR1_LA3	(EIC00.unELVR1.stcField.u1LA3)  /*@bf@*/
#define EIC00_ELVR1_LB3	(EIC00.unELVR1.stcField.u1LB3)  /*@bf@*/
#define EIC00_ELVR1_LC3	(EIC00.unELVR1.stcField.u1LC3)  /*@bf@*/
#define EIC00_ELVR1_LA4	(EIC00.unELVR1.stcField.u1LA4)  /*@bf@*/
#define EIC00_ELVR1_LB4	(EIC00.unELVR1.stcField.u1LB4)  /*@bf@*/
#define EIC00_ELVR1_LC4	(EIC00.unELVR1.stcField.u1LC4)  /*@bf@*/
#define EIC00_ELVR1_LA5	(EIC00.unELVR1.stcField.u1LA5)  /*@bf@*/
#define EIC00_ELVR1_LB5	(EIC00.unELVR1.stcField.u1LB5)  /*@bf@*/
#define EIC00_ELVR1_LC5	(EIC00.unELVR1.stcField.u1LC5)  /*@bf@*/
#define EIC00_ELVR1_LA6	(EIC00.unELVR1.stcField.u1LA6)  /*@bf@*/
#define EIC00_ELVR1_LB6	(EIC00.unELVR1.stcField.u1LB6)  /*@bf@*/
#define EIC00_ELVR1_LC6	(EIC00.unELVR1.stcField.u1LC6)  /*@bf@*/
#define EIC00_ELVR1_LA7	(EIC00.unELVR1.stcField.u1LA7)  /*@bf@*/
#define EIC00_ELVR1_LB7	(EIC00.unELVR1.stcField.u1LB7)  /*@bf@*/
#define EIC00_ELVR1_LC7	(EIC00.unELVR1.stcField.u1LC7)  /*@bf@*/

#define EIC00_ELVR2	(EIC00.unELVR2.u32Register)  /*@rg@*/
#define EIC00_ELVR2_LA0	(EIC00.unELVR2.stcField.u1LA0)  /*@bf@*/
#define EIC00_ELVR2_LB0	(EIC00.unELVR2.stcField.u1LB0)  /*@bf@*/
#define EIC00_ELVR2_LC0	(EIC00.unELVR2.stcField.u1LC0)  /*@bf@*/
#define EIC00_ELVR2_LA1	(EIC00.unELVR2.stcField.u1LA1)  /*@bf@*/
#define EIC00_ELVR2_LB1	(EIC00.unELVR2.stcField.u1LB1)  /*@bf@*/
#define EIC00_ELVR2_LC1	(EIC00.unELVR2.stcField.u1LC1)  /*@bf@*/
#define EIC00_ELVR2_LA2	(EIC00.unELVR2.stcField.u1LA2)  /*@bf@*/
#define EIC00_ELVR2_LB2	(EIC00.unELVR2.stcField.u1LB2)  /*@bf@*/
#define EIC00_ELVR2_LC2	(EIC00.unELVR2.stcField.u1LC2)  /*@bf@*/
#define EIC00_ELVR2_LA3	(EIC00.unELVR2.stcField.u1LA3)  /*@bf@*/
#define EIC00_ELVR2_LB3	(EIC00.unELVR2.stcField.u1LB3)  /*@bf@*/
#define EIC00_ELVR2_LC3	(EIC00.unELVR2.stcField.u1LC3)  /*@bf@*/
#define EIC00_ELVR2_LA4	(EIC00.unELVR2.stcField.u1LA4)  /*@bf@*/
#define EIC00_ELVR2_LB4	(EIC00.unELVR2.stcField.u1LB4)  /*@bf@*/
#define EIC00_ELVR2_LC4	(EIC00.unELVR2.stcField.u1LC4)  /*@bf@*/
#define EIC00_ELVR2_LA5	(EIC00.unELVR2.stcField.u1LA5)  /*@bf@*/
#define EIC00_ELVR2_LB5	(EIC00.unELVR2.stcField.u1LB5)  /*@bf@*/
#define EIC00_ELVR2_LC5	(EIC00.unELVR2.stcField.u1LC5)  /*@bf@*/
#define EIC00_ELVR2_LA6	(EIC00.unELVR2.stcField.u1LA6)  /*@bf@*/
#define EIC00_ELVR2_LB6	(EIC00.unELVR2.stcField.u1LB6)  /*@bf@*/
#define EIC00_ELVR2_LC6	(EIC00.unELVR2.stcField.u1LC6)  /*@bf@*/
#define EIC00_ELVR2_LA7	(EIC00.unELVR2.stcField.u1LA7)  /*@bf@*/
#define EIC00_ELVR2_LB7	(EIC00.unELVR2.stcField.u1LB7)  /*@bf@*/
#define EIC00_ELVR2_LC7	(EIC00.unELVR2.stcField.u1LC7)  /*@bf@*/

#define EIC00_ELVR3	(EIC00.unELVR3.u32Register)  /*@rg@*/
#define EIC00_ELVR3_LA0	(EIC00.unELVR3.stcField.u1LA0)  /*@bf@*/
#define EIC00_ELVR3_LB0	(EIC00.unELVR3.stcField.u1LB0)  /*@bf@*/
#define EIC00_ELVR3_LC0	(EIC00.unELVR3.stcField.u1LC0)  /*@bf@*/
#define EIC00_ELVR3_LA1	(EIC00.unELVR3.stcField.u1LA1)  /*@bf@*/
#define EIC00_ELVR3_LB1	(EIC00.unELVR3.stcField.u1LB1)  /*@bf@*/
#define EIC00_ELVR3_LC1	(EIC00.unELVR3.stcField.u1LC1)  /*@bf@*/
#define EIC00_ELVR3_LA2	(EIC00.unELVR3.stcField.u1LA2)  /*@bf@*/
#define EIC00_ELVR3_LB2	(EIC00.unELVR3.stcField.u1LB2)  /*@bf@*/
#define EIC00_ELVR3_LC2	(EIC00.unELVR3.stcField.u1LC2)  /*@bf@*/
#define EIC00_ELVR3_LA3	(EIC00.unELVR3.stcField.u1LA3)  /*@bf@*/
#define EIC00_ELVR3_LB3	(EIC00.unELVR3.stcField.u1LB3)  /*@bf@*/
#define EIC00_ELVR3_LC3	(EIC00.unELVR3.stcField.u1LC3)  /*@bf@*/
#define EIC00_ELVR3_LA4	(EIC00.unELVR3.stcField.u1LA4)  /*@bf@*/
#define EIC00_ELVR3_LB4	(EIC00.unELVR3.stcField.u1LB4)  /*@bf@*/
#define EIC00_ELVR3_LC4	(EIC00.unELVR3.stcField.u1LC4)  /*@bf@*/
#define EIC00_ELVR3_LA5	(EIC00.unELVR3.stcField.u1LA5)  /*@bf@*/
#define EIC00_ELVR3_LB5	(EIC00.unELVR3.stcField.u1LB5)  /*@bf@*/
#define EIC00_ELVR3_LC5	(EIC00.unELVR3.stcField.u1LC5)  /*@bf@*/
#define EIC00_ELVR3_LA6	(EIC00.unELVR3.stcField.u1LA6)  /*@bf@*/
#define EIC00_ELVR3_LB6	(EIC00.unELVR3.stcField.u1LB6)  /*@bf@*/
#define EIC00_ELVR3_LC6	(EIC00.unELVR3.stcField.u1LC6)  /*@bf@*/
#define EIC00_ELVR3_LA7	(EIC00.unELVR3.stcField.u1LA7)  /*@bf@*/
#define EIC00_ELVR3_LB7	(EIC00.unELVR3.stcField.u1LB7)  /*@bf@*/
#define EIC00_ELVR3_LC7	(EIC00.unELVR3.stcField.u1LC7)  /*@bf@*/

typedef struct stc_eic00_elvrn_field{
    uint_io32_t		u1LA0:1;
    uint_io32_t		u1LB0:1;
    uint_io32_t		u1LC0:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA1:1;
    uint_io32_t		u1LB1:1;
    uint_io32_t		u1LC1:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA2:1;
    uint_io32_t		u1LB2:1;
    uint_io32_t		u1LC2:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA3:1;
    uint_io32_t		u1LB3:1;
    uint_io32_t		u1LC3:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA4:1;
    uint_io32_t		u1LB4:1;
    uint_io32_t		u1LC4:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA5:1;
    uint_io32_t		u1LB5:1;
    uint_io32_t		u1LC5:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA6:1;
    uint_io32_t		u1LB6:1;
    uint_io32_t		u1LC6:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA7:1;
    uint_io32_t		u1LB7:1;
    uint_io32_t		u1LC7:1;
    uint_io32_t		:1;
}stc_eic00_elvrn_field_t;

typedef union un_eic00_elvrn{
    uint_io32_t		u32Register;
    stc_eic00_elvrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_elvrn_t;

/* NMIR */
#define EIC00_NMIR	(EIC00.unNMIR.u32Register)  /*@rg@*/
#define EIC00_NMIR_NMIINT	(EIC00.unNMIR.stcField.u1NMIINT)  /*@bf@*/
#define EIC00_NMIR_NMICLR	(EIC00.unNMIR.stcField.u1NMICLR)  /*@bf@*/

typedef struct stc_eic00_nmir_field{
    uint_io32_t		u1NMIINT:1;
    uint_io32_t		:7;
    uint_io32_t		u1NMICLR:1;
    uint_io32_t		:23;
}stc_eic00_nmir_field_t;

typedef union un_eic00_nmir{
    uint_io32_t		u32Register;
    stc_eic00_nmir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nmir_t;

/* DRER */
#define EIC00_DRER	(EIC00.unDRER.u32Register)  /*@rg@*/
#define EIC00_DRER_DRE0	(EIC00.unDRER.stcField.u1DRE0)  /*@bf@*/
#define EIC00_DRER_DRE1	(EIC00.unDRER.stcField.u1DRE1)  /*@bf@*/
#define EIC00_DRER_DRE2	(EIC00.unDRER.stcField.u1DRE2)  /*@bf@*/
#define EIC00_DRER_DRE3	(EIC00.unDRER.stcField.u1DRE3)  /*@bf@*/
#define EIC00_DRER_DRE4	(EIC00.unDRER.stcField.u1DRE4)  /*@bf@*/
#define EIC00_DRER_DRE5	(EIC00.unDRER.stcField.u1DRE5)  /*@bf@*/
#define EIC00_DRER_DRE6	(EIC00.unDRER.stcField.u1DRE6)  /*@bf@*/
#define EIC00_DRER_DRE7	(EIC00.unDRER.stcField.u1DRE7)  /*@bf@*/
#define EIC00_DRER_DRE8	(EIC00.unDRER.stcField.u1DRE8)  /*@bf@*/
#define EIC00_DRER_DRE9	(EIC00.unDRER.stcField.u1DRE9)  /*@bf@*/
#define EIC00_DRER_DRE10	(EIC00.unDRER.stcField.u1DRE10)  /*@bf@*/
#define EIC00_DRER_DRE11	(EIC00.unDRER.stcField.u1DRE11)  /*@bf@*/
#define EIC00_DRER_DRE12	(EIC00.unDRER.stcField.u1DRE12)  /*@bf@*/
#define EIC00_DRER_DRE13	(EIC00.unDRER.stcField.u1DRE13)  /*@bf@*/
#define EIC00_DRER_DRE14	(EIC00.unDRER.stcField.u1DRE14)  /*@bf@*/
#define EIC00_DRER_DRE15	(EIC00.unDRER.stcField.u1DRE15)  /*@bf@*/
#define EIC00_DRER_DRE16	(EIC00.unDRER.stcField.u1DRE16)  /*@bf@*/
#define EIC00_DRER_DRE17	(EIC00.unDRER.stcField.u1DRE17)  /*@bf@*/
#define EIC00_DRER_DRE18	(EIC00.unDRER.stcField.u1DRE18)  /*@bf@*/
#define EIC00_DRER_DRE19	(EIC00.unDRER.stcField.u1DRE19)  /*@bf@*/
#define EIC00_DRER_DRE20	(EIC00.unDRER.stcField.u1DRE20)  /*@bf@*/
#define EIC00_DRER_DRE21	(EIC00.unDRER.stcField.u1DRE21)  /*@bf@*/
#define EIC00_DRER_DRE22	(EIC00.unDRER.stcField.u1DRE22)  /*@bf@*/
#define EIC00_DRER_DRE23	(EIC00.unDRER.stcField.u1DRE23)  /*@bf@*/
#define EIC00_DRER_DRE24	(EIC00.unDRER.stcField.u1DRE24)  /*@bf@*/
#define EIC00_DRER_DRE25	(EIC00.unDRER.stcField.u1DRE25)  /*@bf@*/
#define EIC00_DRER_DRE26	(EIC00.unDRER.stcField.u1DRE26)  /*@bf@*/
#define EIC00_DRER_DRE27	(EIC00.unDRER.stcField.u1DRE27)  /*@bf@*/
#define EIC00_DRER_DRE28	(EIC00.unDRER.stcField.u1DRE28)  /*@bf@*/
#define EIC00_DRER_DRE29	(EIC00.unDRER.stcField.u1DRE29)  /*@bf@*/
#define EIC00_DRER_DRE30	(EIC00.unDRER.stcField.u1DRE30)  /*@bf@*/
#define EIC00_DRER_DRE31	(EIC00.unDRER.stcField.u1DRE31)  /*@bf@*/

typedef struct stc_eic00_drer_field{
    uint_io32_t		u1DRE0:1;
    uint_io32_t		u1DRE1:1;
    uint_io32_t		u1DRE2:1;
    uint_io32_t		u1DRE3:1;
    uint_io32_t		u1DRE4:1;
    uint_io32_t		u1DRE5:1;
    uint_io32_t		u1DRE6:1;
    uint_io32_t		u1DRE7:1;
    uint_io32_t		u1DRE8:1;
    uint_io32_t		u1DRE9:1;
    uint_io32_t		u1DRE10:1;
    uint_io32_t		u1DRE11:1;
    uint_io32_t		u1DRE12:1;
    uint_io32_t		u1DRE13:1;
    uint_io32_t		u1DRE14:1;
    uint_io32_t		u1DRE15:1;
    uint_io32_t		u1DRE16:1;
    uint_io32_t		u1DRE17:1;
    uint_io32_t		u1DRE18:1;
    uint_io32_t		u1DRE19:1;
    uint_io32_t		u1DRE20:1;
    uint_io32_t		u1DRE21:1;
    uint_io32_t		u1DRE22:1;
    uint_io32_t		u1DRE23:1;
    uint_io32_t		u1DRE24:1;
    uint_io32_t		u1DRE25:1;
    uint_io32_t		u1DRE26:1;
    uint_io32_t		u1DRE27:1;
    uint_io32_t		u1DRE28:1;
    uint_io32_t		u1DRE29:1;
    uint_io32_t		u1DRE30:1;
    uint_io32_t		u1DRE31:1;
}stc_eic00_drer_field_t;

typedef union un_eic00_drer{
    uint_io32_t		u32Register;
    stc_eic00_drer_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_drer_t;

/* DRESR */
#define EIC00_DRESR	(EIC00.unDRESR.u32Register)  /*@rg@*/
#define EIC00_DRESR_DRES0	(EIC00.unDRESR.stcField.u1DRES0)  /*@bf@*/
#define EIC00_DRESR_DRES1	(EIC00.unDRESR.stcField.u1DRES1)  /*@bf@*/
#define EIC00_DRESR_DRES2	(EIC00.unDRESR.stcField.u1DRES2)  /*@bf@*/
#define EIC00_DRESR_DRES3	(EIC00.unDRESR.stcField.u1DRES3)  /*@bf@*/
#define EIC00_DRESR_DRES4	(EIC00.unDRESR.stcField.u1DRES4)  /*@bf@*/
#define EIC00_DRESR_DRES5	(EIC00.unDRESR.stcField.u1DRES5)  /*@bf@*/
#define EIC00_DRESR_DRES6	(EIC00.unDRESR.stcField.u1DRES6)  /*@bf@*/
#define EIC00_DRESR_DRES7	(EIC00.unDRESR.stcField.u1DRES7)  /*@bf@*/
#define EIC00_DRESR_DRES8	(EIC00.unDRESR.stcField.u1DRES8)  /*@bf@*/
#define EIC00_DRESR_DRES9	(EIC00.unDRESR.stcField.u1DRES9)  /*@bf@*/
#define EIC00_DRESR_DRES10	(EIC00.unDRESR.stcField.u1DRES10)  /*@bf@*/
#define EIC00_DRESR_DRES11	(EIC00.unDRESR.stcField.u1DRES11)  /*@bf@*/
#define EIC00_DRESR_DRES12	(EIC00.unDRESR.stcField.u1DRES12)  /*@bf@*/
#define EIC00_DRESR_DRES13	(EIC00.unDRESR.stcField.u1DRES13)  /*@bf@*/
#define EIC00_DRESR_DRES14	(EIC00.unDRESR.stcField.u1DRES14)  /*@bf@*/
#define EIC00_DRESR_DRES15	(EIC00.unDRESR.stcField.u1DRES15)  /*@bf@*/
#define EIC00_DRESR_DRES16	(EIC00.unDRESR.stcField.u1DRES16)  /*@bf@*/
#define EIC00_DRESR_DRES17	(EIC00.unDRESR.stcField.u1DRES17)  /*@bf@*/
#define EIC00_DRESR_DRES18	(EIC00.unDRESR.stcField.u1DRES18)  /*@bf@*/
#define EIC00_DRESR_DRES19	(EIC00.unDRESR.stcField.u1DRES19)  /*@bf@*/
#define EIC00_DRESR_DRES20	(EIC00.unDRESR.stcField.u1DRES20)  /*@bf@*/
#define EIC00_DRESR_DRES21	(EIC00.unDRESR.stcField.u1DRES21)  /*@bf@*/
#define EIC00_DRESR_DRES22	(EIC00.unDRESR.stcField.u1DRES22)  /*@bf@*/
#define EIC00_DRESR_DRES23	(EIC00.unDRESR.stcField.u1DRES23)  /*@bf@*/
#define EIC00_DRESR_DRES24	(EIC00.unDRESR.stcField.u1DRES24)  /*@bf@*/
#define EIC00_DRESR_DRES25	(EIC00.unDRESR.stcField.u1DRES25)  /*@bf@*/
#define EIC00_DRESR_DRES26	(EIC00.unDRESR.stcField.u1DRES26)  /*@bf@*/
#define EIC00_DRESR_DRES27	(EIC00.unDRESR.stcField.u1DRES27)  /*@bf@*/
#define EIC00_DRESR_DRES28	(EIC00.unDRESR.stcField.u1DRES28)  /*@bf@*/
#define EIC00_DRESR_DRES29	(EIC00.unDRESR.stcField.u1DRES29)  /*@bf@*/
#define EIC00_DRESR_DRES30	(EIC00.unDRESR.stcField.u1DRES30)  /*@bf@*/
#define EIC00_DRESR_DRES31	(EIC00.unDRESR.stcField.u1DRES31)  /*@bf@*/

typedef struct stc_eic00_dresr_field{
    uint_io32_t		u1DRES0:1;
    uint_io32_t		u1DRES1:1;
    uint_io32_t		u1DRES2:1;
    uint_io32_t		u1DRES3:1;
    uint_io32_t		u1DRES4:1;
    uint_io32_t		u1DRES5:1;
    uint_io32_t		u1DRES6:1;
    uint_io32_t		u1DRES7:1;
    uint_io32_t		u1DRES8:1;
    uint_io32_t		u1DRES9:1;
    uint_io32_t		u1DRES10:1;
    uint_io32_t		u1DRES11:1;
    uint_io32_t		u1DRES12:1;
    uint_io32_t		u1DRES13:1;
    uint_io32_t		u1DRES14:1;
    uint_io32_t		u1DRES15:1;
    uint_io32_t		u1DRES16:1;
    uint_io32_t		u1DRES17:1;
    uint_io32_t		u1DRES18:1;
    uint_io32_t		u1DRES19:1;
    uint_io32_t		u1DRES20:1;
    uint_io32_t		u1DRES21:1;
    uint_io32_t		u1DRES22:1;
    uint_io32_t		u1DRES23:1;
    uint_io32_t		u1DRES24:1;
    uint_io32_t		u1DRES25:1;
    uint_io32_t		u1DRES26:1;
    uint_io32_t		u1DRES27:1;
    uint_io32_t		u1DRES28:1;
    uint_io32_t		u1DRES29:1;
    uint_io32_t		u1DRES30:1;
    uint_io32_t		u1DRES31:1;
}stc_eic00_dresr_field_t;

typedef union un_eic00_dresr{
    uint_io32_t		u32Register;
    stc_eic00_dresr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_dresr_t;

/* DRECR */
#define EIC00_DRECR	(EIC00.unDRECR.u32Register)  /*@rg@*/
#define EIC00_DRECR_DREC0	(EIC00.unDRECR.stcField.u1DREC0)  /*@bf@*/
#define EIC00_DRECR_DREC1	(EIC00.unDRECR.stcField.u1DREC1)  /*@bf@*/
#define EIC00_DRECR_DREC2	(EIC00.unDRECR.stcField.u1DREC2)  /*@bf@*/
#define EIC00_DRECR_DREC3	(EIC00.unDRECR.stcField.u1DREC3)  /*@bf@*/
#define EIC00_DRECR_DREC4	(EIC00.unDRECR.stcField.u1DREC4)  /*@bf@*/
#define EIC00_DRECR_DREC5	(EIC00.unDRECR.stcField.u1DREC5)  /*@bf@*/
#define EIC00_DRECR_DREC6	(EIC00.unDRECR.stcField.u1DREC6)  /*@bf@*/
#define EIC00_DRECR_DREC7	(EIC00.unDRECR.stcField.u1DREC7)  /*@bf@*/
#define EIC00_DRECR_DREC8	(EIC00.unDRECR.stcField.u1DREC8)  /*@bf@*/
#define EIC00_DRECR_DREC9	(EIC00.unDRECR.stcField.u1DREC9)  /*@bf@*/
#define EIC00_DRECR_DREC10	(EIC00.unDRECR.stcField.u1DREC10)  /*@bf@*/
#define EIC00_DRECR_DREC11	(EIC00.unDRECR.stcField.u1DREC11)  /*@bf@*/
#define EIC00_DRECR_DREC12	(EIC00.unDRECR.stcField.u1DREC12)  /*@bf@*/
#define EIC00_DRECR_DREC13	(EIC00.unDRECR.stcField.u1DREC13)  /*@bf@*/
#define EIC00_DRECR_DREC14	(EIC00.unDRECR.stcField.u1DREC14)  /*@bf@*/
#define EIC00_DRECR_DREC15	(EIC00.unDRECR.stcField.u1DREC15)  /*@bf@*/
#define EIC00_DRECR_DREC16	(EIC00.unDRECR.stcField.u1DREC16)  /*@bf@*/
#define EIC00_DRECR_DREC17	(EIC00.unDRECR.stcField.u1DREC17)  /*@bf@*/
#define EIC00_DRECR_DREC18	(EIC00.unDRECR.stcField.u1DREC18)  /*@bf@*/
#define EIC00_DRECR_DREC19	(EIC00.unDRECR.stcField.u1DREC19)  /*@bf@*/
#define EIC00_DRECR_DREC20	(EIC00.unDRECR.stcField.u1DREC20)  /*@bf@*/
#define EIC00_DRECR_DREC21	(EIC00.unDRECR.stcField.u1DREC21)  /*@bf@*/
#define EIC00_DRECR_DREC22	(EIC00.unDRECR.stcField.u1DREC22)  /*@bf@*/
#define EIC00_DRECR_DREC23	(EIC00.unDRECR.stcField.u1DREC23)  /*@bf@*/
#define EIC00_DRECR_DREC24	(EIC00.unDRECR.stcField.u1DREC24)  /*@bf@*/
#define EIC00_DRECR_DREC25	(EIC00.unDRECR.stcField.u1DREC25)  /*@bf@*/
#define EIC00_DRECR_DREC26	(EIC00.unDRECR.stcField.u1DREC26)  /*@bf@*/
#define EIC00_DRECR_DREC27	(EIC00.unDRECR.stcField.u1DREC27)  /*@bf@*/
#define EIC00_DRECR_DREC28	(EIC00.unDRECR.stcField.u1DREC28)  /*@bf@*/
#define EIC00_DRECR_DREC29	(EIC00.unDRECR.stcField.u1DREC29)  /*@bf@*/
#define EIC00_DRECR_DREC30	(EIC00.unDRECR.stcField.u1DREC30)  /*@bf@*/
#define EIC00_DRECR_DREC31	(EIC00.unDRECR.stcField.u1DREC31)  /*@bf@*/

typedef struct stc_eic00_drecr_field{
    uint_io32_t		u1DREC0:1;
    uint_io32_t		u1DREC1:1;
    uint_io32_t		u1DREC2:1;
    uint_io32_t		u1DREC3:1;
    uint_io32_t		u1DREC4:1;
    uint_io32_t		u1DREC5:1;
    uint_io32_t		u1DREC6:1;
    uint_io32_t		u1DREC7:1;
    uint_io32_t		u1DREC8:1;
    uint_io32_t		u1DREC9:1;
    uint_io32_t		u1DREC10:1;
    uint_io32_t		u1DREC11:1;
    uint_io32_t		u1DREC12:1;
    uint_io32_t		u1DREC13:1;
    uint_io32_t		u1DREC14:1;
    uint_io32_t		u1DREC15:1;
    uint_io32_t		u1DREC16:1;
    uint_io32_t		u1DREC17:1;
    uint_io32_t		u1DREC18:1;
    uint_io32_t		u1DREC19:1;
    uint_io32_t		u1DREC20:1;
    uint_io32_t		u1DREC21:1;
    uint_io32_t		u1DREC22:1;
    uint_io32_t		u1DREC23:1;
    uint_io32_t		u1DREC24:1;
    uint_io32_t		u1DREC25:1;
    uint_io32_t		u1DREC26:1;
    uint_io32_t		u1DREC27:1;
    uint_io32_t		u1DREC28:1;
    uint_io32_t		u1DREC29:1;
    uint_io32_t		u1DREC30:1;
    uint_io32_t		u1DREC31:1;
}stc_eic00_drecr_field_t;

typedef union un_eic00_drecr{
    uint_io32_t		u32Register;
    stc_eic00_drecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_drecr_t;

/* DRFR */
#define EIC00_DRFR	(EIC00.unDRFR.u32Register)  /*@rg@*/
#define EIC00_DRFR_DRF0	(EIC00.unDRFR.stcField.u1DRF0)  /*@bf@*/
#define EIC00_DRFR_DRF1	(EIC00.unDRFR.stcField.u1DRF1)  /*@bf@*/
#define EIC00_DRFR_DRF2	(EIC00.unDRFR.stcField.u1DRF2)  /*@bf@*/
#define EIC00_DRFR_DRF3	(EIC00.unDRFR.stcField.u1DRF3)  /*@bf@*/
#define EIC00_DRFR_DRF4	(EIC00.unDRFR.stcField.u1DRF4)  /*@bf@*/
#define EIC00_DRFR_DRF5	(EIC00.unDRFR.stcField.u1DRF5)  /*@bf@*/
#define EIC00_DRFR_DRF6	(EIC00.unDRFR.stcField.u1DRF6)  /*@bf@*/
#define EIC00_DRFR_DRF7	(EIC00.unDRFR.stcField.u1DRF7)  /*@bf@*/
#define EIC00_DRFR_DRF8	(EIC00.unDRFR.stcField.u1DRF8)  /*@bf@*/
#define EIC00_DRFR_DRF9	(EIC00.unDRFR.stcField.u1DRF9)  /*@bf@*/
#define EIC00_DRFR_DRF10	(EIC00.unDRFR.stcField.u1DRF10)  /*@bf@*/
#define EIC00_DRFR_DRF11	(EIC00.unDRFR.stcField.u1DRF11)  /*@bf@*/
#define EIC00_DRFR_DRF12	(EIC00.unDRFR.stcField.u1DRF12)  /*@bf@*/
#define EIC00_DRFR_DRF13	(EIC00.unDRFR.stcField.u1DRF13)  /*@bf@*/
#define EIC00_DRFR_DRF14	(EIC00.unDRFR.stcField.u1DRF14)  /*@bf@*/
#define EIC00_DRFR_DRF15	(EIC00.unDRFR.stcField.u1DRF15)  /*@bf@*/
#define EIC00_DRFR_DRF16	(EIC00.unDRFR.stcField.u1DRF16)  /*@bf@*/
#define EIC00_DRFR_DRF17	(EIC00.unDRFR.stcField.u1DRF17)  /*@bf@*/
#define EIC00_DRFR_DRF18	(EIC00.unDRFR.stcField.u1DRF18)  /*@bf@*/
#define EIC00_DRFR_DRF19	(EIC00.unDRFR.stcField.u1DRF19)  /*@bf@*/
#define EIC00_DRFR_DRF20	(EIC00.unDRFR.stcField.u1DRF20)  /*@bf@*/
#define EIC00_DRFR_DRF21	(EIC00.unDRFR.stcField.u1DRF21)  /*@bf@*/
#define EIC00_DRFR_DRF22	(EIC00.unDRFR.stcField.u1DRF22)  /*@bf@*/
#define EIC00_DRFR_DRF23	(EIC00.unDRFR.stcField.u1DRF23)  /*@bf@*/
#define EIC00_DRFR_DRF24	(EIC00.unDRFR.stcField.u1DRF24)  /*@bf@*/
#define EIC00_DRFR_DRF25	(EIC00.unDRFR.stcField.u1DRF25)  /*@bf@*/
#define EIC00_DRFR_DRF26	(EIC00.unDRFR.stcField.u1DRF26)  /*@bf@*/
#define EIC00_DRFR_DRF27	(EIC00.unDRFR.stcField.u1DRF27)  /*@bf@*/
#define EIC00_DRFR_DRF28	(EIC00.unDRFR.stcField.u1DRF28)  /*@bf@*/
#define EIC00_DRFR_DRF29	(EIC00.unDRFR.stcField.u1DRF29)  /*@bf@*/
#define EIC00_DRFR_DRF30	(EIC00.unDRFR.stcField.u1DRF30)  /*@bf@*/
#define EIC00_DRFR_DRF31	(EIC00.unDRFR.stcField.u1DRF31)  /*@bf@*/

typedef struct stc_eic00_drfr_field{
    uint_io32_t		u1DRF0:1;
    uint_io32_t		u1DRF1:1;
    uint_io32_t		u1DRF2:1;
    uint_io32_t		u1DRF3:1;
    uint_io32_t		u1DRF4:1;
    uint_io32_t		u1DRF5:1;
    uint_io32_t		u1DRF6:1;
    uint_io32_t		u1DRF7:1;
    uint_io32_t		u1DRF8:1;
    uint_io32_t		u1DRF9:1;
    uint_io32_t		u1DRF10:1;
    uint_io32_t		u1DRF11:1;
    uint_io32_t		u1DRF12:1;
    uint_io32_t		u1DRF13:1;
    uint_io32_t		u1DRF14:1;
    uint_io32_t		u1DRF15:1;
    uint_io32_t		u1DRF16:1;
    uint_io32_t		u1DRF17:1;
    uint_io32_t		u1DRF18:1;
    uint_io32_t		u1DRF19:1;
    uint_io32_t		u1DRF20:1;
    uint_io32_t		u1DRF21:1;
    uint_io32_t		u1DRF22:1;
    uint_io32_t		u1DRF23:1;
    uint_io32_t		u1DRF24:1;
    uint_io32_t		u1DRF25:1;
    uint_io32_t		u1DRF26:1;
    uint_io32_t		u1DRF27:1;
    uint_io32_t		u1DRF28:1;
    uint_io32_t		u1DRF29:1;
    uint_io32_t		u1DRF30:1;
    uint_io32_t		u1DRF31:1;
}stc_eic00_drfr_field_t;

typedef union un_eic00_drfr{
    uint_io32_t		u32Register;
    stc_eic00_drfr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_drfr_t;


typedef struct stc_eic00{
    un_eic00_enir_t	unENIR;	/* 0x00000000 */
    un_eic00_enisr_t	unENISR;	/* 0x00000004 */
    un_eic00_enicr_t	unENICR;	/* 0x00000008 */
    un_eic00_eirr_t	unEIRR;	/* 0x0000000C */
    un_eic00_eircr_t	unEIRCR;	/* 0x00000010 */
    un_eic00_nfer_t	unNFER;	/* 0x00000014 */
    un_eic00_nfesr_t	unNFESR;	/* 0x00000018 */
    un_eic00_nfecr_t	unNFECR;	/* 0x0000001C */
    un_eic00_elvrn_t	unELVR0;	/* 0x00000020 */
    un_eic00_elvrn_t	unELVR1;	/* 0x00000024 */
    un_eic00_elvrn_t	unELVR2;	/* 0x00000028 */
    un_eic00_elvrn_t	unELVR3;	/* 0x0000002C */
    un_eic00_nmir_t	unNMIR;	/* 0x00000030 */
    un_eic00_drer_t	unDRER;	/* 0x00000034 */
    un_eic00_dresr_t	unDRESR;	/* 0x00000038 */
    un_eic00_drecr_t	unDRECR;	/* 0x0000003C */
    un_eic00_drfr_t	unDRFR;	/* 0x00000040 */
    uint_io8_t	au8Reserved0[131004];	/* 0x00000044 */
}stc_eic00_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_eic00_t	stcEIC00;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 131072(0x20000) bytes */


#endif /* __S6J3360_EIC_H */
