/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_INDPWM_H
#define __S6J3360_INDPWM_H

#include "s6j3360io_basetypes.h"

/* INDPWM base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define INDPWM	stcINDPWM
#else /* __IO_DEFINE */
#define INDPWM	(*((volatile stc_indpwm_t*)0xB0640000))
#endif /* __IO_DEFINE */

/* IPCSR */
#define INDPWM_IPCSR	(INDPWM.unIPCSR.u32Register)  /*@rg@*/
#define INDPWM_IPCSR_IPCSR	(INDPWM.unIPCSR.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_indpwm_ipcsr_field{
    uint_io32_t		u16IPCSR:16;
    uint_io32_t		:16;
}stc_indpwm_ipcsr_field_t;

typedef union un_indpwm_ipcsr{
    uint_io32_t		u32Register;
    stc_indpwm_ipcsr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_ipcsr_t;

/* IPDUT */
#define INDPWM_IPDUT	(INDPWM.unIPDUT.u32Register)  /*@rg@*/
#define INDPWM_IPDUT_IPDUT	(INDPWM.unIPDUT.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_indpwm_ipdut_field{
    uint_io32_t		u16IPDUT:16;
    uint_io32_t		:16;
}stc_indpwm_ipdut_field_t;

typedef union un_indpwm_ipdut{
    uint_io32_t		u32Register;
    stc_indpwm_ipdut_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_ipdut_t;

/* ITMCR */
#define INDPWM_ITMCR	(INDPWM.unITMCR.u32Register)  /*@rg@*/
#define INDPWM_ITMCR_OSEL	(INDPWM.unITMCR.stcField.u1OSEL)  /*@bf@*/
#define INDPWM_ITMCR_PMSK	(INDPWM.unITMCR.stcField.u1PMSK)  /*@bf@*/
#define INDPWM_ITMCR_CKS	(INDPWM.unITMCR.stcField.u3CKS)  /*@bf@*/
#define INDPWM_ITMCR_CKSEL	(INDPWM.unITMCR.stcField.u1CKSEL)  /*@bf@*/
#define INDPWM_ITMCR_CSST	(INDPWM.unITMCR.stcField.u2CSST)  /*@bf@*/

typedef struct stc_indpwm_itmcr_field{
    uint_io32_t		:3;
    uint_io32_t		u1OSEL:1;
    uint_io32_t		:6;
    uint_io32_t		u1PMSK:1;
    uint_io32_t		:1;
    uint_io32_t		u3CKS:3;
    uint_io32_t		:1;
    uint_io32_t		u1CKSEL:1;
    uint_io32_t		:7;
    uint_io32_t		u2CSST:2;
    uint_io32_t		:6;
}stc_indpwm_itmcr_field_t;

typedef union un_indpwm_itmcr{
    uint_io32_t		u32Register;
    stc_indpwm_itmcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_itmcr_t;

/* ICNTCR */
#define INDPWM_ICNTCR	(INDPWM.unICNTCR.u32Register)  /*@rg@*/
#define INDPWM_ICNTCR_STRG	(INDPWM.unICNTCR.stcField.u1STRG)  /*@bf@*/
#define INDPWM_ICNTCR_CTEN	(INDPWM.unICNTCR.stcField.u1CTEN)  /*@bf@*/
#define INDPWM_ICNTCR_DOP	(INDPWM.unICNTCR.stcField.u1DOP)  /*@bf@*/

typedef struct stc_indpwm_icntcr_field{
    uint_io32_t		u1STRG:1;
    uint_io32_t		u1CTEN:1;
    uint_io32_t		:5;
    uint_io32_t		u1DOP:1;
    uint_io32_t		:24;
}stc_indpwm_icntcr_field_t;

typedef union un_indpwm_icntcr{
    uint_io32_t		u32Register;
    stc_indpwm_icntcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_icntcr_t;

/* ISTC */
#define INDPWM_ISTC	(INDPWM.unISTC.u32Register)  /*@rg@*/
#define INDPWM_ISTC_UDIR	(INDPWM.unISTC.stcField.u1UDIR)  /*@bf@*/
#define INDPWM_ISTC_DTIR	(INDPWM.unISTC.stcField.u1DTIR)  /*@bf@*/
#define INDPWM_ISTC_UDIE	(INDPWM.unISTC.stcField.u1UDIE)  /*@bf@*/
#define INDPWM_ISTC_DTIE	(INDPWM.unISTC.stcField.u1DTIE)  /*@bf@*/

typedef struct stc_indpwm_istc_field{
    uint_io32_t		u1UDIR:1;
    uint_io32_t		u1DTIR:1;
    uint_io32_t		:2;
    uint_io32_t		u1UDIE:1;
    uint_io32_t		u1DTIE:1;
    uint_io32_t		:26;
}stc_indpwm_istc_field_t;

typedef union un_indpwm_istc{
    uint_io32_t		u32Register;
    stc_indpwm_istc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_istc_t;

/* ISTCC */
#define INDPWM_ISTCC	(INDPWM.unISTCC.u32Register)  /*@rg@*/
#define INDPWM_ISTCC_UDIRC	(INDPWM.unISTCC.stcField.u1UDIRC)  /*@bf@*/
#define INDPWM_ISTCC_DTIRC	(INDPWM.unISTCC.stcField.u1DTIRC)  /*@bf@*/
#define INDPWM_ISTCC_UDIEC	(INDPWM.unISTCC.stcField.u1UDIEC)  /*@bf@*/
#define INDPWM_ISTCC_DTIEC	(INDPWM.unISTCC.stcField.u1DTIEC)  /*@bf@*/

typedef struct stc_indpwm_istcc_field{
    uint_io32_t		u1UDIRC:1;
    uint_io32_t		u1DTIRC:1;
    uint_io32_t		:2;
    uint_io32_t		u1UDIEC:1;
    uint_io32_t		u1DTIEC:1;
    uint_io32_t		:26;
}stc_indpwm_istcc_field_t;

typedef union un_indpwm_istcc{
    uint_io32_t		u32Register;
    stc_indpwm_istcc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_istcc_t;

/* ISTCS */
#define INDPWM_ISTCS	(INDPWM.unISTCS.u32Register)  /*@rg@*/
#define INDPWM_ISTCS_UDIES	(INDPWM.unISTCS.stcField.u1UDIES)  /*@bf@*/
#define INDPWM_ISTCS_DTIES	(INDPWM.unISTCS.stcField.u1DTIES)  /*@bf@*/

typedef struct stc_indpwm_istcs_field{
    uint_io32_t		:4;
    uint_io32_t		u1UDIES:1;
    uint_io32_t		u1DTIES:1;
    uint_io32_t		:26;
}stc_indpwm_istcs_field_t;

typedef union un_indpwm_istcs{
    uint_io32_t		u32Register;
    stc_indpwm_istcs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_indpwm_istcs_t;


typedef struct stc_indpwm{
    un_indpwm_ipcsr_t	unIPCSR;	/* 0x00000000 */
    un_indpwm_ipdut_t	unIPDUT;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000008 */
    un_indpwm_itmcr_t	unITMCR;	/* 0x0000000C */
    un_indpwm_icntcr_t	unICNTCR;	/* 0x00000010 */
    un_indpwm_istc_t	unISTC;	/* 0x00000014 */
    un_indpwm_istcc_t	unISTCC;	/* 0x00000018 */
    un_indpwm_istcs_t	unISTCS;	/* 0x0000001C */
    uint_io8_t	au8Reserved1[4064];	/* 0x00000020 */
}stc_indpwm_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_indpwm_t	stcINDPWM;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 4096(0x1000) bytes */


#endif /* __S6J3360_INDPWM_H */
