/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_LCDE_H
#define __S6J3360_LCDE_H

#include "s6j3360io_basetypes.h"

/* LCDE base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define LCDE	stcLCDE
#else /* __IO_DEFINE */
#define LCDE	(*((volatile stc_lcde_t*)0xB0641000))
#endif /* __IO_DEFINE */

/* LCD_KEYCDR */
#define LCDE_LCD_KEYCDR	(LCDE.unLCD_KEYCDR.u32Register)  /*@rg@*/
#define LCDE_LCD_KEYCDR_ADR	(LCDE.unLCD_KEYCDR.stcField.u12ADR)  /*@bf@*/
#define LCDE_LCD_KEYCDR_SIZE	(LCDE.unLCD_KEYCDR.stcField.u2SIZE)  /*@bf@*/
#define LCDE_LCD_KEYCDR_KEY	(LCDE.unLCD_KEYCDR.stcField.u2KEY)  /*@bf@*/

typedef struct stc_lcde_lcd_keycdr_field{
    uint_io32_t		u12ADR:12;
    uint_io32_t		:16;
    uint_io32_t		u2SIZE:2;
    uint_io32_t		u2KEY:2;
}stc_lcde_lcd_keycdr_field_t;

typedef union un_lcde_lcd_keycdr{
    uint_io32_t		u32Register;
    stc_lcde_lcd_keycdr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcde_lcd_keycdr_t;

/* SEGER */
#define LCDE_SEGER	(LCDE.unSEGER.u32Register)  /*@rg@*/
#define LCDE_SEGER_SEGE24	(LCDE.unSEGER.stcField.u1SEGE24)  /*@bf@*/
#define LCDE_SEGER_SEGE25	(LCDE.unSEGER.stcField.u1SEGE25)  /*@bf@*/
#define LCDE_SEGER_SEGE26	(LCDE.unSEGER.stcField.u1SEGE26)  /*@bf@*/
#define LCDE_SEGER_SEGE27	(LCDE.unSEGER.stcField.u1SEGE27)  /*@bf@*/
#define LCDE_SEGER_SEGE28	(LCDE.unSEGER.stcField.u1SEGE28)  /*@bf@*/
#define LCDE_SEGER_SEGE29	(LCDE.unSEGER.stcField.u1SEGE29)  /*@bf@*/
#define LCDE_SEGER_SEGE30	(LCDE.unSEGER.stcField.u1SEGE30)  /*@bf@*/
#define LCDE_SEGER_SEGE31	(LCDE.unSEGER.stcField.u1SEGE31)  /*@bf@*/
#define LCDE_SEGER_SEGE16	(LCDE.unSEGER.stcField.u1SEGE16)  /*@bf@*/
#define LCDE_SEGER_SEGE17	(LCDE.unSEGER.stcField.u1SEGE17)  /*@bf@*/
#define LCDE_SEGER_SEGE18	(LCDE.unSEGER.stcField.u1SEGE18)  /*@bf@*/
#define LCDE_SEGER_SEGE19	(LCDE.unSEGER.stcField.u1SEGE19)  /*@bf@*/
#define LCDE_SEGER_SEGE20	(LCDE.unSEGER.stcField.u1SEGE20)  /*@bf@*/
#define LCDE_SEGER_SEGE21	(LCDE.unSEGER.stcField.u1SEGE21)  /*@bf@*/
#define LCDE_SEGER_SEGE22	(LCDE.unSEGER.stcField.u1SEGE22)  /*@bf@*/
#define LCDE_SEGER_SEGE23	(LCDE.unSEGER.stcField.u1SEGE23)  /*@bf@*/
#define LCDE_SEGER_SEGE8	(LCDE.unSEGER.stcField.u1SEGE8)  /*@bf@*/
#define LCDE_SEGER_SEGE9	(LCDE.unSEGER.stcField.u1SEGE9)  /*@bf@*/
#define LCDE_SEGER_SEGE10	(LCDE.unSEGER.stcField.u1SEGE10)  /*@bf@*/
#define LCDE_SEGER_SEGE11	(LCDE.unSEGER.stcField.u1SEGE11)  /*@bf@*/
#define LCDE_SEGER_SEGE12	(LCDE.unSEGER.stcField.u1SEGE12)  /*@bf@*/
#define LCDE_SEGER_SEGE13	(LCDE.unSEGER.stcField.u1SEGE13)  /*@bf@*/
#define LCDE_SEGER_SEGE14	(LCDE.unSEGER.stcField.u1SEGE14)  /*@bf@*/
#define LCDE_SEGER_SEGE15	(LCDE.unSEGER.stcField.u1SEGE15)  /*@bf@*/
#define LCDE_SEGER_SEGE0	(LCDE.unSEGER.stcField.u1SEGE0)  /*@bf@*/
#define LCDE_SEGER_SEGE1	(LCDE.unSEGER.stcField.u1SEGE1)  /*@bf@*/
#define LCDE_SEGER_SEGE2	(LCDE.unSEGER.stcField.u1SEGE2)  /*@bf@*/
#define LCDE_SEGER_SEGE3	(LCDE.unSEGER.stcField.u1SEGE3)  /*@bf@*/
#define LCDE_SEGER_SEGE4	(LCDE.unSEGER.stcField.u1SEGE4)  /*@bf@*/
#define LCDE_SEGER_SEGE5	(LCDE.unSEGER.stcField.u1SEGE5)  /*@bf@*/
#define LCDE_SEGER_SEGE6	(LCDE.unSEGER.stcField.u1SEGE6)  /*@bf@*/
#define LCDE_SEGER_SEGE7	(LCDE.unSEGER.stcField.u1SEGE7)  /*@bf@*/

typedef struct stc_lcde_seger_field{
    uint_io32_t		u1SEGE24:1;
    uint_io32_t		u1SEGE25:1;
    uint_io32_t		u1SEGE26:1;
    uint_io32_t		u1SEGE27:1;
    uint_io32_t		u1SEGE28:1;
    uint_io32_t		u1SEGE29:1;
    uint_io32_t		u1SEGE30:1;
    uint_io32_t		u1SEGE31:1;
    uint_io32_t		u1SEGE16:1;
    uint_io32_t		u1SEGE17:1;
    uint_io32_t		u1SEGE18:1;
    uint_io32_t		u1SEGE19:1;
    uint_io32_t		u1SEGE20:1;
    uint_io32_t		u1SEGE21:1;
    uint_io32_t		u1SEGE22:1;
    uint_io32_t		u1SEGE23:1;
    uint_io32_t		u1SEGE8:1;
    uint_io32_t		u1SEGE9:1;
    uint_io32_t		u1SEGE10:1;
    uint_io32_t		u1SEGE11:1;
    uint_io32_t		u1SEGE12:1;
    uint_io32_t		u1SEGE13:1;
    uint_io32_t		u1SEGE14:1;
    uint_io32_t		u1SEGE15:1;
    uint_io32_t		u1SEGE0:1;
    uint_io32_t		u1SEGE1:1;
    uint_io32_t		u1SEGE2:1;
    uint_io32_t		u1SEGE3:1;
    uint_io32_t		u1SEGE4:1;
    uint_io32_t		u1SEGE5:1;
    uint_io32_t		u1SEGE6:1;
    uint_io32_t		u1SEGE7:1;
}stc_lcde_seger_field_t;

typedef union un_lcde_seger{
    uint_io32_t		u32Register;
    stc_lcde_seger_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcde_seger_t;

/* COMVER */
#define LCDE_COMVER	(LCDE.unCOMVER.u32Register)  /*@rg@*/
#define LCDE_COMVER_COME0	(LCDE.unCOMVER.stcField.u1COME0)  /*@bf@*/
#define LCDE_COMVER_COME1	(LCDE.unCOMVER.stcField.u1COME1)  /*@bf@*/
#define LCDE_COMVER_COME2	(LCDE.unCOMVER.stcField.u1COME2)  /*@bf@*/
#define LCDE_COMVER_COME3	(LCDE.unCOMVER.stcField.u1COME3)  /*@bf@*/
#define LCDE_COMVER_VE0	(LCDE.unCOMVER.stcField.u1VE0)  /*@bf@*/
#define LCDE_COMVER_VE1	(LCDE.unCOMVER.stcField.u1VE1)  /*@bf@*/
#define LCDE_COMVER_VE2	(LCDE.unCOMVER.stcField.u1VE2)  /*@bf@*/
#define LCDE_COMVER_VE3	(LCDE.unCOMVER.stcField.u1VE3)  /*@bf@*/

typedef struct stc_lcde_comver_field{
    uint_io32_t		:24;
    uint_io32_t		u1COME0:1;
    uint_io32_t		u1COME1:1;
    uint_io32_t		u1COME2:1;
    uint_io32_t		u1COME3:1;
    uint_io32_t		u1VE0:1;
    uint_io32_t		u1VE1:1;
    uint_io32_t		u1VE2:1;
    uint_io32_t		u1VE3:1;
}stc_lcde_comver_field_t;

typedef union un_lcde_comver{
    uint_io32_t		u32Register;
    stc_lcde_comver_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcde_comver_t;


typedef struct stc_lcde{
    un_lcde_lcd_keycdr_t	unLCD_KEYCDR;	/* 0x00000000 */
    un_lcde_seger_t	unSEGER;	/* 0x00000004 */
    un_lcde_comver_t	unCOMVER;	/* 0x00000008 */
    uint_io8_t	au8Reserved0[4084];	/* 0x0000000C */
}stc_lcde_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_lcde_t	stcLCDE;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 4096(0x1000) bytes */


#endif /* __S6J3360_LCDE_H */
