/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_MFS_I2C_H
#define __S6J3360_MFS_I2C_H

#include "s6j3360io_basetypes.h"

/* CPG_MFS[00-11]_I2C base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CPG_MFS00_I2C	stcCPG_MFS_I2C[0]
#define CPG_MFS01_I2C	stcCPG_MFS_I2C[1]
#define CPG_MFS02_I2C	stcCPG_MFS_I2C[2]
#define CPG_MFS03_I2C	stcCPG_MFS_I2C[3]
#define CPG_MFS04_I2C	stcCPG_MFS_I2C[4]
#define CPG_MFS05_I2C	stcCPG_MFS_I2C[5]
#define CPG_MFS06_I2C	stcCPG_MFS_I2C[6]
#define CPG_MFS07_I2C	stcCPG_MFS_I2C[7]
#define CPG_MFS08_I2C	stcCPG_MFS_I2C[8]
#define CPG_MFS09_I2C	stcCPG_MFS_I2C[9]
#define CPG_MFS10_I2C	stcCPG_MFS_I2C[10]
#define CPG_MFS11_I2C	stcCPG_MFS_I2C[11]
#else /* __IO_DEFINE */
#define CPG_MFS00_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4800000))
#define CPG_MFS01_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4800400))
#define CPG_MFS02_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4800800))
#define CPG_MFS03_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4800C00))
#define CPG_MFS04_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4801000))
#define CPG_MFS05_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4801400))
#define CPG_MFS06_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4801800))
#define CPG_MFS07_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4801C00))
#define CPG_MFS08_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4880000))
#define CPG_MFS09_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4880400))
#define CPG_MFS10_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4880800))
#define CPG_MFS11_I2C	(*((volatile stc_cpg_mfsn_i2c_t*)0xB4880C00))
#endif /* __IO_DEFINE */

/* SMR */
#define CPG_MFS00_I2C_SMR	(CPG_MFS00_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_SMR_TIE	(CPG_MFS00_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS00_I2C_SMR_RIE	(CPG_MFS00_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS00_I2C_SMR_WUCR	(CPG_MFS00_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS00_I2C_SMR_MD	(CPG_MFS00_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS01_I2C_SMR	(CPG_MFS01_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_SMR_TIE	(CPG_MFS01_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS01_I2C_SMR_RIE	(CPG_MFS01_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS01_I2C_SMR_WUCR	(CPG_MFS01_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS01_I2C_SMR_MD	(CPG_MFS01_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS02_I2C_SMR	(CPG_MFS02_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_SMR_TIE	(CPG_MFS02_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS02_I2C_SMR_RIE	(CPG_MFS02_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS02_I2C_SMR_WUCR	(CPG_MFS02_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS02_I2C_SMR_MD	(CPG_MFS02_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS03_I2C_SMR	(CPG_MFS03_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_SMR_TIE	(CPG_MFS03_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS03_I2C_SMR_RIE	(CPG_MFS03_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS03_I2C_SMR_WUCR	(CPG_MFS03_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS03_I2C_SMR_MD	(CPG_MFS03_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS04_I2C_SMR	(CPG_MFS04_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_SMR_TIE	(CPG_MFS04_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS04_I2C_SMR_RIE	(CPG_MFS04_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS04_I2C_SMR_WUCR	(CPG_MFS04_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS04_I2C_SMR_MD	(CPG_MFS04_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS05_I2C_SMR	(CPG_MFS05_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_SMR_TIE	(CPG_MFS05_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS05_I2C_SMR_RIE	(CPG_MFS05_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS05_I2C_SMR_WUCR	(CPG_MFS05_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS05_I2C_SMR_MD	(CPG_MFS05_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS06_I2C_SMR	(CPG_MFS06_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_SMR_TIE	(CPG_MFS06_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS06_I2C_SMR_RIE	(CPG_MFS06_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS06_I2C_SMR_WUCR	(CPG_MFS06_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS06_I2C_SMR_MD	(CPG_MFS06_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS07_I2C_SMR	(CPG_MFS07_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_SMR_TIE	(CPG_MFS07_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS07_I2C_SMR_RIE	(CPG_MFS07_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS07_I2C_SMR_WUCR	(CPG_MFS07_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS07_I2C_SMR_MD	(CPG_MFS07_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS08_I2C_SMR	(CPG_MFS08_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_SMR_TIE	(CPG_MFS08_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS08_I2C_SMR_RIE	(CPG_MFS08_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS08_I2C_SMR_WUCR	(CPG_MFS08_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS08_I2C_SMR_MD	(CPG_MFS08_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS09_I2C_SMR	(CPG_MFS09_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_SMR_TIE	(CPG_MFS09_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS09_I2C_SMR_RIE	(CPG_MFS09_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS09_I2C_SMR_WUCR	(CPG_MFS09_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS09_I2C_SMR_MD	(CPG_MFS09_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS10_I2C_SMR	(CPG_MFS10_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_SMR_TIE	(CPG_MFS10_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS10_I2C_SMR_RIE	(CPG_MFS10_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS10_I2C_SMR_WUCR	(CPG_MFS10_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS10_I2C_SMR_MD	(CPG_MFS10_I2C.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS11_I2C_SMR	(CPG_MFS11_I2C.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_SMR_TIE	(CPG_MFS11_I2C.unSMR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS11_I2C_SMR_RIE	(CPG_MFS11_I2C.unSMR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS11_I2C_SMR_WUCR	(CPG_MFS11_I2C.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS11_I2C_SMR_MD	(CPG_MFS11_I2C.unSMR.stcField.u3MD)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_smr_field{
    uint_io8_t		:2;
    uint_io8_t		u1TIE:1;
    uint_io8_t		u1RIE:1;
    uint_io8_t		u1WUCR:1;
    uint_io8_t		u3MD:3;
}stc_cpg_mfsn_i2c_smr_field_t;

typedef union un_cpg_mfsn_i2c_smr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_smr_field_t		stcField;
}un_cpg_mfsn_i2c_smr_t;

/* IBCR */
#define CPG_MFS00_I2C_IBCR	(CPG_MFS00_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_IBCR_INT	(CPG_MFS00_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_BER	(CPG_MFS00_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_INTE	(CPG_MFS00_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_CNDE	(CPG_MFS00_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_WSEL	(CPG_MFS00_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_ACKE	(CPG_MFS00_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_ACT	(CPG_MFS00_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_MSS	(CPG_MFS00_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS00_I2C_IBCR_SCC	CPG_MFS00_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS01_I2C_IBCR	(CPG_MFS01_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_IBCR_INT	(CPG_MFS01_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_BER	(CPG_MFS01_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_INTE	(CPG_MFS01_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_CNDE	(CPG_MFS01_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_WSEL	(CPG_MFS01_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_ACKE	(CPG_MFS01_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_ACT	(CPG_MFS01_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_MSS	(CPG_MFS01_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS01_I2C_IBCR_SCC	CPG_MFS01_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS02_I2C_IBCR	(CPG_MFS02_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_IBCR_INT	(CPG_MFS02_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_BER	(CPG_MFS02_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_INTE	(CPG_MFS02_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_CNDE	(CPG_MFS02_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_WSEL	(CPG_MFS02_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_ACKE	(CPG_MFS02_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_ACT	(CPG_MFS02_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_MSS	(CPG_MFS02_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS02_I2C_IBCR_SCC	CPG_MFS02_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS03_I2C_IBCR	(CPG_MFS03_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_IBCR_INT	(CPG_MFS03_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_BER	(CPG_MFS03_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_INTE	(CPG_MFS03_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_CNDE	(CPG_MFS03_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_WSEL	(CPG_MFS03_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_ACKE	(CPG_MFS03_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_ACT	(CPG_MFS03_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_MSS	(CPG_MFS03_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS03_I2C_IBCR_SCC	CPG_MFS03_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS04_I2C_IBCR	(CPG_MFS04_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_IBCR_INT	(CPG_MFS04_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_BER	(CPG_MFS04_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_INTE	(CPG_MFS04_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_CNDE	(CPG_MFS04_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_WSEL	(CPG_MFS04_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_ACKE	(CPG_MFS04_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_ACT	(CPG_MFS04_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_MSS	(CPG_MFS04_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS04_I2C_IBCR_SCC	CPG_MFS04_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS05_I2C_IBCR	(CPG_MFS05_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_IBCR_INT	(CPG_MFS05_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_BER	(CPG_MFS05_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_INTE	(CPG_MFS05_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_CNDE	(CPG_MFS05_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_WSEL	(CPG_MFS05_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_ACKE	(CPG_MFS05_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_ACT	(CPG_MFS05_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_MSS	(CPG_MFS05_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS05_I2C_IBCR_SCC	CPG_MFS05_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS06_I2C_IBCR	(CPG_MFS06_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_IBCR_INT	(CPG_MFS06_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_BER	(CPG_MFS06_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_INTE	(CPG_MFS06_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_CNDE	(CPG_MFS06_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_WSEL	(CPG_MFS06_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_ACKE	(CPG_MFS06_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_ACT	(CPG_MFS06_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_MSS	(CPG_MFS06_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS06_I2C_IBCR_SCC	CPG_MFS06_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS07_I2C_IBCR	(CPG_MFS07_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_IBCR_INT	(CPG_MFS07_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_BER	(CPG_MFS07_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_INTE	(CPG_MFS07_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_CNDE	(CPG_MFS07_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_WSEL	(CPG_MFS07_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_ACKE	(CPG_MFS07_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_ACT	(CPG_MFS07_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_MSS	(CPG_MFS07_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS07_I2C_IBCR_SCC	CPG_MFS07_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS08_I2C_IBCR	(CPG_MFS08_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_IBCR_INT	(CPG_MFS08_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_BER	(CPG_MFS08_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_INTE	(CPG_MFS08_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_CNDE	(CPG_MFS08_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_WSEL	(CPG_MFS08_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_ACKE	(CPG_MFS08_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_ACT	(CPG_MFS08_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_MSS	(CPG_MFS08_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS08_I2C_IBCR_SCC	CPG_MFS08_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS09_I2C_IBCR	(CPG_MFS09_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_IBCR_INT	(CPG_MFS09_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_BER	(CPG_MFS09_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_INTE	(CPG_MFS09_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_CNDE	(CPG_MFS09_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_WSEL	(CPG_MFS09_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_ACKE	(CPG_MFS09_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_ACT	(CPG_MFS09_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_MSS	(CPG_MFS09_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS09_I2C_IBCR_SCC	CPG_MFS09_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS10_I2C_IBCR	(CPG_MFS10_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_IBCR_INT	(CPG_MFS10_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_BER	(CPG_MFS10_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_INTE	(CPG_MFS10_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_CNDE	(CPG_MFS10_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_WSEL	(CPG_MFS10_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_ACKE	(CPG_MFS10_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_ACT	(CPG_MFS10_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_MSS	(CPG_MFS10_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS10_I2C_IBCR_SCC	CPG_MFS10_I2C_IBCR_ACT  /*@bf2@*/

#define CPG_MFS11_I2C_IBCR	(CPG_MFS11_I2C.unIBCR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_IBCR_INT	(CPG_MFS11_I2C.unIBCR.stcField.u1INT)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_BER	(CPG_MFS11_I2C.unIBCR.stcField.u1BER)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_INTE	(CPG_MFS11_I2C.unIBCR.stcField.u1INTE)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_CNDE	(CPG_MFS11_I2C.unIBCR.stcField.u1CNDE)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_WSEL	(CPG_MFS11_I2C.unIBCR.stcField.u1WSEL)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_ACKE	(CPG_MFS11_I2C.unIBCR.stcField.u1ACKE)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_ACT	(CPG_MFS11_I2C.unIBCR.stcField.u1ACT)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_MSS	(CPG_MFS11_I2C.unIBCR.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS11_I2C_IBCR_SCC	CPG_MFS11_I2C_IBCR_ACT  /*@bf2@*/

typedef struct stc_cpg_mfsn_i2c_ibcr_field{
    uint_io8_t		u1INT:1;
    uint_io8_t		u1BER:1;
    uint_io8_t		u1INTE:1;
    uint_io8_t		u1CNDE:1;
    uint_io8_t		u1WSEL:1;
    uint_io8_t		u1ACKE:1;
    uint_io8_t		u1ACT:1;
    uint_io8_t		u1MSS:1;
}stc_cpg_mfsn_i2c_ibcr_field_t;

typedef union un_cpg_mfsn_i2c_ibcr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ibcr_field_t		stcField;
}un_cpg_mfsn_i2c_ibcr_t;

/* IBSR */
#define CPG_MFS00_I2C_IBSR	(CPG_MFS00_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_IBSR_BB	(CPG_MFS00_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_SPC	(CPG_MFS00_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_RSC	(CPG_MFS00_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_AL	(CPG_MFS00_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_TRX	(CPG_MFS00_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_RSA	(CPG_MFS00_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_RACK	(CPG_MFS00_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS00_I2C_IBSR_FBT	(CPG_MFS00_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS01_I2C_IBSR	(CPG_MFS01_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_IBSR_BB	(CPG_MFS01_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_SPC	(CPG_MFS01_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_RSC	(CPG_MFS01_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_AL	(CPG_MFS01_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_TRX	(CPG_MFS01_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_RSA	(CPG_MFS01_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_RACK	(CPG_MFS01_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS01_I2C_IBSR_FBT	(CPG_MFS01_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS02_I2C_IBSR	(CPG_MFS02_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_IBSR_BB	(CPG_MFS02_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_SPC	(CPG_MFS02_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_RSC	(CPG_MFS02_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_AL	(CPG_MFS02_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_TRX	(CPG_MFS02_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_RSA	(CPG_MFS02_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_RACK	(CPG_MFS02_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS02_I2C_IBSR_FBT	(CPG_MFS02_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS03_I2C_IBSR	(CPG_MFS03_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_IBSR_BB	(CPG_MFS03_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_SPC	(CPG_MFS03_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_RSC	(CPG_MFS03_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_AL	(CPG_MFS03_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_TRX	(CPG_MFS03_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_RSA	(CPG_MFS03_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_RACK	(CPG_MFS03_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS03_I2C_IBSR_FBT	(CPG_MFS03_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS04_I2C_IBSR	(CPG_MFS04_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_IBSR_BB	(CPG_MFS04_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_SPC	(CPG_MFS04_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_RSC	(CPG_MFS04_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_AL	(CPG_MFS04_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_TRX	(CPG_MFS04_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_RSA	(CPG_MFS04_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_RACK	(CPG_MFS04_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS04_I2C_IBSR_FBT	(CPG_MFS04_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS05_I2C_IBSR	(CPG_MFS05_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_IBSR_BB	(CPG_MFS05_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_SPC	(CPG_MFS05_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_RSC	(CPG_MFS05_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_AL	(CPG_MFS05_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_TRX	(CPG_MFS05_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_RSA	(CPG_MFS05_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_RACK	(CPG_MFS05_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS05_I2C_IBSR_FBT	(CPG_MFS05_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS06_I2C_IBSR	(CPG_MFS06_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_IBSR_BB	(CPG_MFS06_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_SPC	(CPG_MFS06_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_RSC	(CPG_MFS06_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_AL	(CPG_MFS06_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_TRX	(CPG_MFS06_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_RSA	(CPG_MFS06_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_RACK	(CPG_MFS06_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS06_I2C_IBSR_FBT	(CPG_MFS06_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS07_I2C_IBSR	(CPG_MFS07_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_IBSR_BB	(CPG_MFS07_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_SPC	(CPG_MFS07_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_RSC	(CPG_MFS07_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_AL	(CPG_MFS07_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_TRX	(CPG_MFS07_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_RSA	(CPG_MFS07_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_RACK	(CPG_MFS07_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS07_I2C_IBSR_FBT	(CPG_MFS07_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS08_I2C_IBSR	(CPG_MFS08_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_IBSR_BB	(CPG_MFS08_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_SPC	(CPG_MFS08_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_RSC	(CPG_MFS08_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_AL	(CPG_MFS08_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_TRX	(CPG_MFS08_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_RSA	(CPG_MFS08_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_RACK	(CPG_MFS08_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS08_I2C_IBSR_FBT	(CPG_MFS08_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS09_I2C_IBSR	(CPG_MFS09_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_IBSR_BB	(CPG_MFS09_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_SPC	(CPG_MFS09_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_RSC	(CPG_MFS09_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_AL	(CPG_MFS09_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_TRX	(CPG_MFS09_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_RSA	(CPG_MFS09_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_RACK	(CPG_MFS09_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS09_I2C_IBSR_FBT	(CPG_MFS09_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS10_I2C_IBSR	(CPG_MFS10_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_IBSR_BB	(CPG_MFS10_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_SPC	(CPG_MFS10_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_RSC	(CPG_MFS10_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_AL	(CPG_MFS10_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_TRX	(CPG_MFS10_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_RSA	(CPG_MFS10_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_RACK	(CPG_MFS10_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS10_I2C_IBSR_FBT	(CPG_MFS10_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

#define CPG_MFS11_I2C_IBSR	(CPG_MFS11_I2C.unIBSR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_IBSR_BB	(CPG_MFS11_I2C.unIBSR.stcField.u1BB)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_SPC	(CPG_MFS11_I2C.unIBSR.stcField.u1SPC)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_RSC	(CPG_MFS11_I2C.unIBSR.stcField.u1RSC)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_AL	(CPG_MFS11_I2C.unIBSR.stcField.u1AL)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_TRX	(CPG_MFS11_I2C.unIBSR.stcField.u1TRX)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_RSA	(CPG_MFS11_I2C.unIBSR.stcField.u1RSA)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_RACK	(CPG_MFS11_I2C.unIBSR.stcField.u1RACK)  /*@bf@*/
#define CPG_MFS11_I2C_IBSR_FBT	(CPG_MFS11_I2C.unIBSR.stcField.u1FBT)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ibsr_field{
    uint_io8_t		u1BB:1;
    uint_io8_t		u1SPC:1;
    uint_io8_t		u1RSC:1;
    uint_io8_t		u1AL:1;
    uint_io8_t		u1TRX:1;
    uint_io8_t		u1RSA:1;
    uint_io8_t		u1RACK:1;
    uint_io8_t		u1FBT:1;
}stc_cpg_mfsn_i2c_ibsr_field_t;

typedef union un_cpg_mfsn_i2c_ibsr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ibsr_field_t		stcField;
}un_cpg_mfsn_i2c_ibsr_t;

/* SSR */
#define CPG_MFS00_I2C_SSR	(CPG_MFS00_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_SSR_TBI	(CPG_MFS00_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_TDRE	(CPG_MFS00_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_RDRF	(CPG_MFS00_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_ORE	(CPG_MFS00_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_TBIE	(CPG_MFS00_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_DMA	(CPG_MFS00_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_TSET	(CPG_MFS00_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS00_I2C_SSR_REC	(CPG_MFS00_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS01_I2C_SSR	(CPG_MFS01_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_SSR_TBI	(CPG_MFS01_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_TDRE	(CPG_MFS01_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_RDRF	(CPG_MFS01_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_ORE	(CPG_MFS01_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_TBIE	(CPG_MFS01_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_DMA	(CPG_MFS01_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_TSET	(CPG_MFS01_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS01_I2C_SSR_REC	(CPG_MFS01_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS02_I2C_SSR	(CPG_MFS02_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_SSR_TBI	(CPG_MFS02_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_TDRE	(CPG_MFS02_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_RDRF	(CPG_MFS02_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_ORE	(CPG_MFS02_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_TBIE	(CPG_MFS02_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_DMA	(CPG_MFS02_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_TSET	(CPG_MFS02_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS02_I2C_SSR_REC	(CPG_MFS02_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS03_I2C_SSR	(CPG_MFS03_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_SSR_TBI	(CPG_MFS03_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_TDRE	(CPG_MFS03_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_RDRF	(CPG_MFS03_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_ORE	(CPG_MFS03_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_TBIE	(CPG_MFS03_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_DMA	(CPG_MFS03_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_TSET	(CPG_MFS03_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS03_I2C_SSR_REC	(CPG_MFS03_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS04_I2C_SSR	(CPG_MFS04_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_SSR_TBI	(CPG_MFS04_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_TDRE	(CPG_MFS04_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_RDRF	(CPG_MFS04_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_ORE	(CPG_MFS04_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_TBIE	(CPG_MFS04_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_DMA	(CPG_MFS04_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_TSET	(CPG_MFS04_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS04_I2C_SSR_REC	(CPG_MFS04_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS05_I2C_SSR	(CPG_MFS05_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_SSR_TBI	(CPG_MFS05_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_TDRE	(CPG_MFS05_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_RDRF	(CPG_MFS05_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_ORE	(CPG_MFS05_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_TBIE	(CPG_MFS05_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_DMA	(CPG_MFS05_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_TSET	(CPG_MFS05_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS05_I2C_SSR_REC	(CPG_MFS05_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS06_I2C_SSR	(CPG_MFS06_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_SSR_TBI	(CPG_MFS06_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_TDRE	(CPG_MFS06_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_RDRF	(CPG_MFS06_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_ORE	(CPG_MFS06_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_TBIE	(CPG_MFS06_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_DMA	(CPG_MFS06_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_TSET	(CPG_MFS06_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS06_I2C_SSR_REC	(CPG_MFS06_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS07_I2C_SSR	(CPG_MFS07_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_SSR_TBI	(CPG_MFS07_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_TDRE	(CPG_MFS07_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_RDRF	(CPG_MFS07_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_ORE	(CPG_MFS07_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_TBIE	(CPG_MFS07_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_DMA	(CPG_MFS07_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_TSET	(CPG_MFS07_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS07_I2C_SSR_REC	(CPG_MFS07_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS08_I2C_SSR	(CPG_MFS08_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_SSR_TBI	(CPG_MFS08_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_TDRE	(CPG_MFS08_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_RDRF	(CPG_MFS08_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_ORE	(CPG_MFS08_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_TBIE	(CPG_MFS08_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_DMA	(CPG_MFS08_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_TSET	(CPG_MFS08_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS08_I2C_SSR_REC	(CPG_MFS08_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS09_I2C_SSR	(CPG_MFS09_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_SSR_TBI	(CPG_MFS09_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_TDRE	(CPG_MFS09_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_RDRF	(CPG_MFS09_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_ORE	(CPG_MFS09_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_TBIE	(CPG_MFS09_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_DMA	(CPG_MFS09_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_TSET	(CPG_MFS09_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS09_I2C_SSR_REC	(CPG_MFS09_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS10_I2C_SSR	(CPG_MFS10_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_SSR_TBI	(CPG_MFS10_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_TDRE	(CPG_MFS10_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_RDRF	(CPG_MFS10_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_ORE	(CPG_MFS10_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_TBIE	(CPG_MFS10_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_DMA	(CPG_MFS10_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_TSET	(CPG_MFS10_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS10_I2C_SSR_REC	(CPG_MFS10_I2C.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS11_I2C_SSR	(CPG_MFS11_I2C.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_SSR_TBI	(CPG_MFS11_I2C.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_TDRE	(CPG_MFS11_I2C.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_RDRF	(CPG_MFS11_I2C.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_ORE	(CPG_MFS11_I2C.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_TBIE	(CPG_MFS11_I2C.unSSR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_DMA	(CPG_MFS11_I2C.unSSR.stcField.u1DMA)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_TSET	(CPG_MFS11_I2C.unSSR.stcField.u1TSET)  /*@bf@*/
#define CPG_MFS11_I2C_SSR_REC	(CPG_MFS11_I2C.unSSR.stcField.u1REC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ssr_field{
    uint_io8_t		u1TBI:1;
    uint_io8_t		u1TDRE:1;
    uint_io8_t		u1RDRF:1;
    uint_io8_t		u1ORE:1;
    uint_io8_t		u1TBIE:1;
    uint_io8_t		u1DMA:1;
    uint_io8_t		u1TSET:1;
    uint_io8_t		u1REC:1;
}stc_cpg_mfsn_i2c_ssr_field_t;

typedef union un_cpg_mfsn_i2c_ssr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ssr_field_t		stcField;
}un_cpg_mfsn_i2c_ssr_t;

/* RDR */
#define CPG_MFS00_I2C_RDR	(CPG_MFS00_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_TDR	(CPG_MFS00_I2C_RDR)  /*@rg2@*/
#define CPG_MFS00_I2C_RDR_D	CPG_MFS00_I2C_RDR  /*@bfrg@*/
#define CPG_MFS00_I2C_TDR_D	CPG_MFS00_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS01_I2C_RDR	(CPG_MFS01_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_TDR	(CPG_MFS01_I2C_RDR)  /*@rg2@*/
#define CPG_MFS01_I2C_RDR_D	CPG_MFS01_I2C_RDR  /*@bfrg@*/
#define CPG_MFS01_I2C_TDR_D	CPG_MFS01_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS02_I2C_RDR	(CPG_MFS02_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_TDR	(CPG_MFS02_I2C_RDR)  /*@rg2@*/
#define CPG_MFS02_I2C_RDR_D	CPG_MFS02_I2C_RDR  /*@bfrg@*/
#define CPG_MFS02_I2C_TDR_D	CPG_MFS02_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS03_I2C_RDR	(CPG_MFS03_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_TDR	(CPG_MFS03_I2C_RDR)  /*@rg2@*/
#define CPG_MFS03_I2C_RDR_D	CPG_MFS03_I2C_RDR  /*@bfrg@*/
#define CPG_MFS03_I2C_TDR_D	CPG_MFS03_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS04_I2C_RDR	(CPG_MFS04_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_TDR	(CPG_MFS04_I2C_RDR)  /*@rg2@*/
#define CPG_MFS04_I2C_RDR_D	CPG_MFS04_I2C_RDR  /*@bfrg@*/
#define CPG_MFS04_I2C_TDR_D	CPG_MFS04_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS05_I2C_RDR	(CPG_MFS05_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_TDR	(CPG_MFS05_I2C_RDR)  /*@rg2@*/
#define CPG_MFS05_I2C_RDR_D	CPG_MFS05_I2C_RDR  /*@bfrg@*/
#define CPG_MFS05_I2C_TDR_D	CPG_MFS05_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS06_I2C_RDR	(CPG_MFS06_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_TDR	(CPG_MFS06_I2C_RDR)  /*@rg2@*/
#define CPG_MFS06_I2C_RDR_D	CPG_MFS06_I2C_RDR  /*@bfrg@*/
#define CPG_MFS06_I2C_TDR_D	CPG_MFS06_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS07_I2C_RDR	(CPG_MFS07_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_TDR	(CPG_MFS07_I2C_RDR)  /*@rg2@*/
#define CPG_MFS07_I2C_RDR_D	CPG_MFS07_I2C_RDR  /*@bfrg@*/
#define CPG_MFS07_I2C_TDR_D	CPG_MFS07_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS08_I2C_RDR	(CPG_MFS08_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_TDR	(CPG_MFS08_I2C_RDR)  /*@rg2@*/
#define CPG_MFS08_I2C_RDR_D	CPG_MFS08_I2C_RDR  /*@bfrg@*/
#define CPG_MFS08_I2C_TDR_D	CPG_MFS08_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS09_I2C_RDR	(CPG_MFS09_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_TDR	(CPG_MFS09_I2C_RDR)  /*@rg2@*/
#define CPG_MFS09_I2C_RDR_D	CPG_MFS09_I2C_RDR  /*@bfrg@*/
#define CPG_MFS09_I2C_TDR_D	CPG_MFS09_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS10_I2C_RDR	(CPG_MFS10_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_TDR	(CPG_MFS10_I2C_RDR)  /*@rg2@*/
#define CPG_MFS10_I2C_RDR_D	CPG_MFS10_I2C_RDR  /*@bfrg@*/
#define CPG_MFS10_I2C_TDR_D	CPG_MFS10_I2C_RDR_D  /*@bf2@*/

#define CPG_MFS11_I2C_RDR	(CPG_MFS11_I2C.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_TDR	(CPG_MFS11_I2C_RDR)  /*@rg2@*/
#define CPG_MFS11_I2C_RDR_D	CPG_MFS11_I2C_RDR  /*@bfrg@*/
#define CPG_MFS11_I2C_TDR_D	CPG_MFS11_I2C_RDR_D  /*@bf2@*/

typedef union un_cpg_mfsn_i2c_rdr{
    uint_io8_t		u8Register;
}un_cpg_mfsn_i2c_rdr_t;

/* SACSR */
#define CPG_MFS00_I2C_SACSR	(CPG_MFS00_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_SACSR_TMRE	(CPG_MFS00_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS00_I2C_SACSR_TDIV	(CPG_MFS00_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS00_I2C_SACSR_TRGE	(CPG_MFS00_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS00_I2C_SACSR_TINTE	(CPG_MFS00_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS00_I2C_SACSR_TINT	(CPG_MFS00_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS00_I2C_SACSR_TRG	(CPG_MFS00_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS01_I2C_SACSR	(CPG_MFS01_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_SACSR_TMRE	(CPG_MFS01_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS01_I2C_SACSR_TDIV	(CPG_MFS01_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS01_I2C_SACSR_TRGE	(CPG_MFS01_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS01_I2C_SACSR_TINTE	(CPG_MFS01_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS01_I2C_SACSR_TINT	(CPG_MFS01_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS01_I2C_SACSR_TRG	(CPG_MFS01_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS02_I2C_SACSR	(CPG_MFS02_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_SACSR_TMRE	(CPG_MFS02_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS02_I2C_SACSR_TDIV	(CPG_MFS02_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS02_I2C_SACSR_TRGE	(CPG_MFS02_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS02_I2C_SACSR_TINTE	(CPG_MFS02_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS02_I2C_SACSR_TINT	(CPG_MFS02_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS02_I2C_SACSR_TRG	(CPG_MFS02_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS03_I2C_SACSR	(CPG_MFS03_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_SACSR_TMRE	(CPG_MFS03_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS03_I2C_SACSR_TDIV	(CPG_MFS03_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS03_I2C_SACSR_TRGE	(CPG_MFS03_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS03_I2C_SACSR_TINTE	(CPG_MFS03_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS03_I2C_SACSR_TINT	(CPG_MFS03_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS03_I2C_SACSR_TRG	(CPG_MFS03_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS04_I2C_SACSR	(CPG_MFS04_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_SACSR_TMRE	(CPG_MFS04_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS04_I2C_SACSR_TDIV	(CPG_MFS04_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS04_I2C_SACSR_TRGE	(CPG_MFS04_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS04_I2C_SACSR_TINTE	(CPG_MFS04_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS04_I2C_SACSR_TINT	(CPG_MFS04_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS04_I2C_SACSR_TRG	(CPG_MFS04_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS05_I2C_SACSR	(CPG_MFS05_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_SACSR_TMRE	(CPG_MFS05_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS05_I2C_SACSR_TDIV	(CPG_MFS05_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS05_I2C_SACSR_TRGE	(CPG_MFS05_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS05_I2C_SACSR_TINTE	(CPG_MFS05_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS05_I2C_SACSR_TINT	(CPG_MFS05_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS05_I2C_SACSR_TRG	(CPG_MFS05_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS06_I2C_SACSR	(CPG_MFS06_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_SACSR_TMRE	(CPG_MFS06_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS06_I2C_SACSR_TDIV	(CPG_MFS06_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS06_I2C_SACSR_TRGE	(CPG_MFS06_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS06_I2C_SACSR_TINTE	(CPG_MFS06_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS06_I2C_SACSR_TINT	(CPG_MFS06_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS06_I2C_SACSR_TRG	(CPG_MFS06_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS07_I2C_SACSR	(CPG_MFS07_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_SACSR_TMRE	(CPG_MFS07_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS07_I2C_SACSR_TDIV	(CPG_MFS07_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS07_I2C_SACSR_TRGE	(CPG_MFS07_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS07_I2C_SACSR_TINTE	(CPG_MFS07_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS07_I2C_SACSR_TINT	(CPG_MFS07_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS07_I2C_SACSR_TRG	(CPG_MFS07_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS08_I2C_SACSR	(CPG_MFS08_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_SACSR_TMRE	(CPG_MFS08_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS08_I2C_SACSR_TDIV	(CPG_MFS08_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS08_I2C_SACSR_TRGE	(CPG_MFS08_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS08_I2C_SACSR_TINTE	(CPG_MFS08_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS08_I2C_SACSR_TINT	(CPG_MFS08_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS08_I2C_SACSR_TRG	(CPG_MFS08_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS09_I2C_SACSR	(CPG_MFS09_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_SACSR_TMRE	(CPG_MFS09_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS09_I2C_SACSR_TDIV	(CPG_MFS09_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS09_I2C_SACSR_TRGE	(CPG_MFS09_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS09_I2C_SACSR_TINTE	(CPG_MFS09_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS09_I2C_SACSR_TINT	(CPG_MFS09_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS09_I2C_SACSR_TRG	(CPG_MFS09_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS10_I2C_SACSR	(CPG_MFS10_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_SACSR_TMRE	(CPG_MFS10_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS10_I2C_SACSR_TDIV	(CPG_MFS10_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS10_I2C_SACSR_TRGE	(CPG_MFS10_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS10_I2C_SACSR_TINTE	(CPG_MFS10_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS10_I2C_SACSR_TINT	(CPG_MFS10_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS10_I2C_SACSR_TRG	(CPG_MFS10_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

#define CPG_MFS11_I2C_SACSR	(CPG_MFS11_I2C.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_SACSR_TMRE	(CPG_MFS11_I2C.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS11_I2C_SACSR_TDIV	(CPG_MFS11_I2C.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS11_I2C_SACSR_TRGE	(CPG_MFS11_I2C.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS11_I2C_SACSR_TINTE	(CPG_MFS11_I2C.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS11_I2C_SACSR_TINT	(CPG_MFS11_I2C.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS11_I2C_SACSR_TRG	(CPG_MFS11_I2C.unSACSR.stcField.u2TRG)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_sacsr_field{
    uint_io16_t		u1TMRE:1;
    uint_io16_t		u4TDIV:4;
    uint_io16_t		u1TRGE:1;
    uint_io16_t		:1;
    uint_io16_t		u1TINTE:1;
    uint_io16_t		u1TINT:1;
    uint_io16_t		u2TRG:2;
    uint_io16_t		:5;
}stc_cpg_mfsn_i2c_sacsr_field_t;

typedef union un_cpg_mfsn_i2c_sacsr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_i2c_sacsr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_sacsr_t;

/* STMR */
#define CPG_MFS00_I2C_STMR	(CPG_MFS00_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_STMR_TM	CPG_MFS00_I2C_STMR  /*@bfrg@*/

#define CPG_MFS01_I2C_STMR	(CPG_MFS01_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_STMR_TM	CPG_MFS01_I2C_STMR  /*@bfrg@*/

#define CPG_MFS02_I2C_STMR	(CPG_MFS02_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_STMR_TM	CPG_MFS02_I2C_STMR  /*@bfrg@*/

#define CPG_MFS03_I2C_STMR	(CPG_MFS03_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_STMR_TM	CPG_MFS03_I2C_STMR  /*@bfrg@*/

#define CPG_MFS04_I2C_STMR	(CPG_MFS04_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_STMR_TM	CPG_MFS04_I2C_STMR  /*@bfrg@*/

#define CPG_MFS05_I2C_STMR	(CPG_MFS05_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_STMR_TM	CPG_MFS05_I2C_STMR  /*@bfrg@*/

#define CPG_MFS06_I2C_STMR	(CPG_MFS06_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_STMR_TM	CPG_MFS06_I2C_STMR  /*@bfrg@*/

#define CPG_MFS07_I2C_STMR	(CPG_MFS07_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_STMR_TM	CPG_MFS07_I2C_STMR  /*@bfrg@*/

#define CPG_MFS08_I2C_STMR	(CPG_MFS08_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_STMR_TM	CPG_MFS08_I2C_STMR  /*@bfrg@*/

#define CPG_MFS09_I2C_STMR	(CPG_MFS09_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_STMR_TM	CPG_MFS09_I2C_STMR  /*@bfrg@*/

#define CPG_MFS10_I2C_STMR	(CPG_MFS10_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_STMR_TM	CPG_MFS10_I2C_STMR  /*@bfrg@*/

#define CPG_MFS11_I2C_STMR	(CPG_MFS11_I2C.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_STMR_TM	CPG_MFS11_I2C_STMR  /*@bfrg@*/

typedef union un_cpg_mfsn_i2c_stmr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_stmr_t;

/* STMCR */
#define CPG_MFS00_I2C_STMCR	(CPG_MFS00_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_STMCR_TC	CPG_MFS00_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS01_I2C_STMCR	(CPG_MFS01_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_STMCR_TC	CPG_MFS01_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS02_I2C_STMCR	(CPG_MFS02_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_STMCR_TC	CPG_MFS02_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS03_I2C_STMCR	(CPG_MFS03_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_STMCR_TC	CPG_MFS03_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS04_I2C_STMCR	(CPG_MFS04_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_STMCR_TC	CPG_MFS04_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS05_I2C_STMCR	(CPG_MFS05_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_STMCR_TC	CPG_MFS05_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS06_I2C_STMCR	(CPG_MFS06_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_STMCR_TC	CPG_MFS06_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS07_I2C_STMCR	(CPG_MFS07_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_STMCR_TC	CPG_MFS07_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS08_I2C_STMCR	(CPG_MFS08_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_STMCR_TC	CPG_MFS08_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS09_I2C_STMCR	(CPG_MFS09_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_STMCR_TC	CPG_MFS09_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS10_I2C_STMCR	(CPG_MFS10_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_STMCR_TC	CPG_MFS10_I2C_STMCR  /*@bfrg@*/

#define CPG_MFS11_I2C_STMCR	(CPG_MFS11_I2C.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_STMCR_TC	CPG_MFS11_I2C_STMCR  /*@bfrg@*/

typedef union un_cpg_mfsn_i2c_stmcr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_stmcr_t;

/* NFCR */
#define CPG_MFS00_I2C_NFCR	(CPG_MFS00_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_NFCR_NFT	(CPG_MFS00_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS01_I2C_NFCR	(CPG_MFS01_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_NFCR_NFT	(CPG_MFS01_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS02_I2C_NFCR	(CPG_MFS02_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_NFCR_NFT	(CPG_MFS02_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS03_I2C_NFCR	(CPG_MFS03_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_NFCR_NFT	(CPG_MFS03_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS04_I2C_NFCR	(CPG_MFS04_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_NFCR_NFT	(CPG_MFS04_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS05_I2C_NFCR	(CPG_MFS05_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_NFCR_NFT	(CPG_MFS05_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS06_I2C_NFCR	(CPG_MFS06_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_NFCR_NFT	(CPG_MFS06_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS07_I2C_NFCR	(CPG_MFS07_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_NFCR_NFT	(CPG_MFS07_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS08_I2C_NFCR	(CPG_MFS08_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_NFCR_NFT	(CPG_MFS08_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS09_I2C_NFCR	(CPG_MFS09_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_NFCR_NFT	(CPG_MFS09_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS10_I2C_NFCR	(CPG_MFS10_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_NFCR_NFT	(CPG_MFS10_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

#define CPG_MFS11_I2C_NFCR	(CPG_MFS11_I2C.unNFCR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_NFCR_NFT	(CPG_MFS11_I2C.unNFCR.stcField.u5NFT)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_nfcr_field{
    uint_io8_t		u5NFT:5;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_nfcr_field_t;

typedef union un_cpg_mfsn_i2c_nfcr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_nfcr_field_t		stcField;
}un_cpg_mfsn_i2c_nfcr_t;

/* EIBCR */
#define CPG_MFS00_I2C_EIBCR	(CPG_MFS00_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_EIBCR_BEC	(CPG_MFS00_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS00_I2C_EIBCR_SOCE	(CPG_MFS00_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS00_I2C_EIBCR_SCLC	(CPG_MFS00_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS00_I2C_EIBCR_SDAC	(CPG_MFS00_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS00_I2C_EIBCR_SCLS	(CPG_MFS00_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS00_I2C_EIBCR_SDAS	(CPG_MFS00_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS01_I2C_EIBCR	(CPG_MFS01_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_EIBCR_BEC	(CPG_MFS01_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS01_I2C_EIBCR_SOCE	(CPG_MFS01_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS01_I2C_EIBCR_SCLC	(CPG_MFS01_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS01_I2C_EIBCR_SDAC	(CPG_MFS01_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS01_I2C_EIBCR_SCLS	(CPG_MFS01_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS01_I2C_EIBCR_SDAS	(CPG_MFS01_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS02_I2C_EIBCR	(CPG_MFS02_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_EIBCR_BEC	(CPG_MFS02_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS02_I2C_EIBCR_SOCE	(CPG_MFS02_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS02_I2C_EIBCR_SCLC	(CPG_MFS02_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS02_I2C_EIBCR_SDAC	(CPG_MFS02_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS02_I2C_EIBCR_SCLS	(CPG_MFS02_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS02_I2C_EIBCR_SDAS	(CPG_MFS02_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS03_I2C_EIBCR	(CPG_MFS03_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_EIBCR_BEC	(CPG_MFS03_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS03_I2C_EIBCR_SOCE	(CPG_MFS03_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS03_I2C_EIBCR_SCLC	(CPG_MFS03_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS03_I2C_EIBCR_SDAC	(CPG_MFS03_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS03_I2C_EIBCR_SCLS	(CPG_MFS03_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS03_I2C_EIBCR_SDAS	(CPG_MFS03_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS04_I2C_EIBCR	(CPG_MFS04_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_EIBCR_BEC	(CPG_MFS04_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS04_I2C_EIBCR_SOCE	(CPG_MFS04_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS04_I2C_EIBCR_SCLC	(CPG_MFS04_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS04_I2C_EIBCR_SDAC	(CPG_MFS04_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS04_I2C_EIBCR_SCLS	(CPG_MFS04_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS04_I2C_EIBCR_SDAS	(CPG_MFS04_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS05_I2C_EIBCR	(CPG_MFS05_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_EIBCR_BEC	(CPG_MFS05_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS05_I2C_EIBCR_SOCE	(CPG_MFS05_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS05_I2C_EIBCR_SCLC	(CPG_MFS05_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS05_I2C_EIBCR_SDAC	(CPG_MFS05_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS05_I2C_EIBCR_SCLS	(CPG_MFS05_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS05_I2C_EIBCR_SDAS	(CPG_MFS05_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS06_I2C_EIBCR	(CPG_MFS06_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_EIBCR_BEC	(CPG_MFS06_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS06_I2C_EIBCR_SOCE	(CPG_MFS06_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS06_I2C_EIBCR_SCLC	(CPG_MFS06_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS06_I2C_EIBCR_SDAC	(CPG_MFS06_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS06_I2C_EIBCR_SCLS	(CPG_MFS06_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS06_I2C_EIBCR_SDAS	(CPG_MFS06_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS07_I2C_EIBCR	(CPG_MFS07_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_EIBCR_BEC	(CPG_MFS07_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS07_I2C_EIBCR_SOCE	(CPG_MFS07_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS07_I2C_EIBCR_SCLC	(CPG_MFS07_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS07_I2C_EIBCR_SDAC	(CPG_MFS07_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS07_I2C_EIBCR_SCLS	(CPG_MFS07_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS07_I2C_EIBCR_SDAS	(CPG_MFS07_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS08_I2C_EIBCR	(CPG_MFS08_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_EIBCR_BEC	(CPG_MFS08_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS08_I2C_EIBCR_SOCE	(CPG_MFS08_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS08_I2C_EIBCR_SCLC	(CPG_MFS08_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS08_I2C_EIBCR_SDAC	(CPG_MFS08_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS08_I2C_EIBCR_SCLS	(CPG_MFS08_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS08_I2C_EIBCR_SDAS	(CPG_MFS08_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS09_I2C_EIBCR	(CPG_MFS09_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_EIBCR_BEC	(CPG_MFS09_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS09_I2C_EIBCR_SOCE	(CPG_MFS09_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS09_I2C_EIBCR_SCLC	(CPG_MFS09_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS09_I2C_EIBCR_SDAC	(CPG_MFS09_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS09_I2C_EIBCR_SCLS	(CPG_MFS09_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS09_I2C_EIBCR_SDAS	(CPG_MFS09_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS10_I2C_EIBCR	(CPG_MFS10_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_EIBCR_BEC	(CPG_MFS10_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS10_I2C_EIBCR_SOCE	(CPG_MFS10_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS10_I2C_EIBCR_SCLC	(CPG_MFS10_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS10_I2C_EIBCR_SDAC	(CPG_MFS10_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS10_I2C_EIBCR_SCLS	(CPG_MFS10_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS10_I2C_EIBCR_SDAS	(CPG_MFS10_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

#define CPG_MFS11_I2C_EIBCR	(CPG_MFS11_I2C.unEIBCR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_EIBCR_BEC	(CPG_MFS11_I2C.unEIBCR.stcField.u1BEC)  /*@bf@*/
#define CPG_MFS11_I2C_EIBCR_SOCE	(CPG_MFS11_I2C.unEIBCR.stcField.u1SOCE)  /*@bf@*/
#define CPG_MFS11_I2C_EIBCR_SCLC	(CPG_MFS11_I2C.unEIBCR.stcField.u1SCLC)  /*@bf@*/
#define CPG_MFS11_I2C_EIBCR_SDAC	(CPG_MFS11_I2C.unEIBCR.stcField.u1SDAC)  /*@bf@*/
#define CPG_MFS11_I2C_EIBCR_SCLS	(CPG_MFS11_I2C.unEIBCR.stcField.u1SCLS)  /*@bf@*/
#define CPG_MFS11_I2C_EIBCR_SDAS	(CPG_MFS11_I2C.unEIBCR.stcField.u1SDAS)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_eibcr_field{
    uint_io8_t		u1BEC:1;
    uint_io8_t		u1SOCE:1;
    uint_io8_t		u1SCLC:1;
    uint_io8_t		u1SDAC:1;
    uint_io8_t		u1SCLS:1;
    uint_io8_t		u1SDAS:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_i2c_eibcr_field_t;

typedef union un_cpg_mfsn_i2c_eibcr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_eibcr_field_t		stcField;
}un_cpg_mfsn_i2c_eibcr_t;

/* BGR */
#define CPG_MFS00_I2C_BGR	(CPG_MFS00_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_BGR_BGR	(CPG_MFS00_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS01_I2C_BGR	(CPG_MFS01_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_BGR_BGR	(CPG_MFS01_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS02_I2C_BGR	(CPG_MFS02_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_BGR_BGR	(CPG_MFS02_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS03_I2C_BGR	(CPG_MFS03_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_BGR_BGR	(CPG_MFS03_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS04_I2C_BGR	(CPG_MFS04_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_BGR_BGR	(CPG_MFS04_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS05_I2C_BGR	(CPG_MFS05_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_BGR_BGR	(CPG_MFS05_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS06_I2C_BGR	(CPG_MFS06_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_BGR_BGR	(CPG_MFS06_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS07_I2C_BGR	(CPG_MFS07_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_BGR_BGR	(CPG_MFS07_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS08_I2C_BGR	(CPG_MFS08_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_BGR_BGR	(CPG_MFS08_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS09_I2C_BGR	(CPG_MFS09_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_BGR_BGR	(CPG_MFS09_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS10_I2C_BGR	(CPG_MFS10_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_BGR_BGR	(CPG_MFS10_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS11_I2C_BGR	(CPG_MFS11_I2C.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_BGR_BGR	(CPG_MFS11_I2C.unBGR.stcField.u15BGR)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_bgr_field{
    uint_io16_t		u15BGR:15;
    uint_io16_t		:1;
}stc_cpg_mfsn_i2c_bgr_field_t;

typedef union un_cpg_mfsn_i2c_bgr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_i2c_bgr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_bgr_t;

/* ISBA */
#define CPG_MFS00_I2C_ISBA	(CPG_MFS00_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_ISBA_SA	(CPG_MFS00_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS00_I2C_ISBA_SAEN	(CPG_MFS00_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS01_I2C_ISBA	(CPG_MFS01_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_ISBA_SA	(CPG_MFS01_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS01_I2C_ISBA_SAEN	(CPG_MFS01_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS02_I2C_ISBA	(CPG_MFS02_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_ISBA_SA	(CPG_MFS02_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS02_I2C_ISBA_SAEN	(CPG_MFS02_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS03_I2C_ISBA	(CPG_MFS03_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_ISBA_SA	(CPG_MFS03_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS03_I2C_ISBA_SAEN	(CPG_MFS03_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS04_I2C_ISBA	(CPG_MFS04_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_ISBA_SA	(CPG_MFS04_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS04_I2C_ISBA_SAEN	(CPG_MFS04_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS05_I2C_ISBA	(CPG_MFS05_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_ISBA_SA	(CPG_MFS05_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS05_I2C_ISBA_SAEN	(CPG_MFS05_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS06_I2C_ISBA	(CPG_MFS06_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_ISBA_SA	(CPG_MFS06_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS06_I2C_ISBA_SAEN	(CPG_MFS06_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS07_I2C_ISBA	(CPG_MFS07_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_ISBA_SA	(CPG_MFS07_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS07_I2C_ISBA_SAEN	(CPG_MFS07_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS08_I2C_ISBA	(CPG_MFS08_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_ISBA_SA	(CPG_MFS08_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS08_I2C_ISBA_SAEN	(CPG_MFS08_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS09_I2C_ISBA	(CPG_MFS09_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_ISBA_SA	(CPG_MFS09_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS09_I2C_ISBA_SAEN	(CPG_MFS09_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS10_I2C_ISBA	(CPG_MFS10_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_ISBA_SA	(CPG_MFS10_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS10_I2C_ISBA_SAEN	(CPG_MFS10_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

#define CPG_MFS11_I2C_ISBA	(CPG_MFS11_I2C.unISBA.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_ISBA_SA	(CPG_MFS11_I2C.unISBA.stcField.u7SA)  /*@bf@*/
#define CPG_MFS11_I2C_ISBA_SAEN	(CPG_MFS11_I2C.unISBA.stcField.u1SAEN)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_isba_field{
    uint_io8_t		u7SA:7;
    uint_io8_t		u1SAEN:1;
}stc_cpg_mfsn_i2c_isba_field_t;

typedef union un_cpg_mfsn_i2c_isba{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_isba_field_t		stcField;
}un_cpg_mfsn_i2c_isba_t;

/* ISMK */
#define CPG_MFS00_I2C_ISMK	(CPG_MFS00_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_ISMK_SM	(CPG_MFS00_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS00_I2C_ISMK_EN	(CPG_MFS00_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS01_I2C_ISMK	(CPG_MFS01_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_ISMK_SM	(CPG_MFS01_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS01_I2C_ISMK_EN	(CPG_MFS01_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS02_I2C_ISMK	(CPG_MFS02_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_ISMK_SM	(CPG_MFS02_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS02_I2C_ISMK_EN	(CPG_MFS02_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS03_I2C_ISMK	(CPG_MFS03_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_ISMK_SM	(CPG_MFS03_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS03_I2C_ISMK_EN	(CPG_MFS03_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS04_I2C_ISMK	(CPG_MFS04_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_ISMK_SM	(CPG_MFS04_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS04_I2C_ISMK_EN	(CPG_MFS04_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS05_I2C_ISMK	(CPG_MFS05_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_ISMK_SM	(CPG_MFS05_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS05_I2C_ISMK_EN	(CPG_MFS05_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS06_I2C_ISMK	(CPG_MFS06_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_ISMK_SM	(CPG_MFS06_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS06_I2C_ISMK_EN	(CPG_MFS06_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS07_I2C_ISMK	(CPG_MFS07_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_ISMK_SM	(CPG_MFS07_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS07_I2C_ISMK_EN	(CPG_MFS07_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS08_I2C_ISMK	(CPG_MFS08_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_ISMK_SM	(CPG_MFS08_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS08_I2C_ISMK_EN	(CPG_MFS08_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS09_I2C_ISMK	(CPG_MFS09_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_ISMK_SM	(CPG_MFS09_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS09_I2C_ISMK_EN	(CPG_MFS09_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS10_I2C_ISMK	(CPG_MFS10_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_ISMK_SM	(CPG_MFS10_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS10_I2C_ISMK_EN	(CPG_MFS10_I2C.unISMK.stcField.u1EN)  /*@bf@*/

#define CPG_MFS11_I2C_ISMK	(CPG_MFS11_I2C.unISMK.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_ISMK_SM	(CPG_MFS11_I2C.unISMK.stcField.u7SM)  /*@bf@*/
#define CPG_MFS11_I2C_ISMK_EN	(CPG_MFS11_I2C.unISMK.stcField.u1EN)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ismk_field{
    uint_io8_t		u7SM:7;
    uint_io8_t		u1EN:1;
}stc_cpg_mfsn_i2c_ismk_field_t;

typedef union un_cpg_mfsn_i2c_ismk{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ismk_field_t		stcField;
}un_cpg_mfsn_i2c_ismk_t;

/* FCR0 */
#define CPG_MFS00_I2C_FCR0	(CPG_MFS00_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_FCR0_FE1	(CPG_MFS00_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0_FE2	(CPG_MFS00_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0_FCL1	(CPG_MFS00_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0_FCL2	(CPG_MFS00_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0_FSET	(CPG_MFS00_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0_FLD	(CPG_MFS00_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0_FLST	(CPG_MFS00_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS01_I2C_FCR0	(CPG_MFS01_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_FCR0_FE1	(CPG_MFS01_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0_FE2	(CPG_MFS01_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0_FCL1	(CPG_MFS01_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0_FCL2	(CPG_MFS01_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0_FSET	(CPG_MFS01_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0_FLD	(CPG_MFS01_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0_FLST	(CPG_MFS01_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS02_I2C_FCR0	(CPG_MFS02_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_FCR0_FE1	(CPG_MFS02_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0_FE2	(CPG_MFS02_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0_FCL1	(CPG_MFS02_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0_FCL2	(CPG_MFS02_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0_FSET	(CPG_MFS02_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0_FLD	(CPG_MFS02_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0_FLST	(CPG_MFS02_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS03_I2C_FCR0	(CPG_MFS03_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_FCR0_FE1	(CPG_MFS03_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0_FE2	(CPG_MFS03_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0_FCL1	(CPG_MFS03_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0_FCL2	(CPG_MFS03_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0_FSET	(CPG_MFS03_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0_FLD	(CPG_MFS03_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0_FLST	(CPG_MFS03_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS04_I2C_FCR0	(CPG_MFS04_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_FCR0_FE1	(CPG_MFS04_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0_FE2	(CPG_MFS04_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0_FCL1	(CPG_MFS04_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0_FCL2	(CPG_MFS04_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0_FSET	(CPG_MFS04_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0_FLD	(CPG_MFS04_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0_FLST	(CPG_MFS04_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS05_I2C_FCR0	(CPG_MFS05_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_FCR0_FE1	(CPG_MFS05_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0_FE2	(CPG_MFS05_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0_FCL1	(CPG_MFS05_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0_FCL2	(CPG_MFS05_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0_FSET	(CPG_MFS05_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0_FLD	(CPG_MFS05_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0_FLST	(CPG_MFS05_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS06_I2C_FCR0	(CPG_MFS06_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_FCR0_FE1	(CPG_MFS06_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0_FE2	(CPG_MFS06_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0_FCL1	(CPG_MFS06_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0_FCL2	(CPG_MFS06_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0_FSET	(CPG_MFS06_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0_FLD	(CPG_MFS06_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0_FLST	(CPG_MFS06_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS07_I2C_FCR0	(CPG_MFS07_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_FCR0_FE1	(CPG_MFS07_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0_FE2	(CPG_MFS07_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0_FCL1	(CPG_MFS07_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0_FCL2	(CPG_MFS07_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0_FSET	(CPG_MFS07_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0_FLD	(CPG_MFS07_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0_FLST	(CPG_MFS07_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS08_I2C_FCR0	(CPG_MFS08_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_FCR0_FE1	(CPG_MFS08_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0_FE2	(CPG_MFS08_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0_FCL1	(CPG_MFS08_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0_FCL2	(CPG_MFS08_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0_FSET	(CPG_MFS08_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0_FLD	(CPG_MFS08_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0_FLST	(CPG_MFS08_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS09_I2C_FCR0	(CPG_MFS09_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_FCR0_FE1	(CPG_MFS09_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0_FE2	(CPG_MFS09_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0_FCL1	(CPG_MFS09_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0_FCL2	(CPG_MFS09_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0_FSET	(CPG_MFS09_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0_FLD	(CPG_MFS09_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0_FLST	(CPG_MFS09_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS10_I2C_FCR0	(CPG_MFS10_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_FCR0_FE1	(CPG_MFS10_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0_FE2	(CPG_MFS10_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0_FCL1	(CPG_MFS10_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0_FCL2	(CPG_MFS10_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0_FSET	(CPG_MFS10_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0_FLD	(CPG_MFS10_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0_FLST	(CPG_MFS10_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS11_I2C_FCR0	(CPG_MFS11_I2C.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_FCR0_FE1	(CPG_MFS11_I2C.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0_FE2	(CPG_MFS11_I2C.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0_FCL1	(CPG_MFS11_I2C.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0_FCL2	(CPG_MFS11_I2C.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0_FSET	(CPG_MFS11_I2C.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0_FLD	(CPG_MFS11_I2C.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0_FLST	(CPG_MFS11_I2C.unFCR0.stcField.u1FLST)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_fcr0_field{
    uint_io8_t		u1FE1:1;
    uint_io8_t		u1FE2:1;
    uint_io8_t		u1FCL1:1;
    uint_io8_t		u1FCL2:1;
    uint_io8_t		u1FSET:1;
    uint_io8_t		u1FLD:1;
    uint_io8_t		u1FLST:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_i2c_fcr0_field_t;

typedef union un_cpg_mfsn_i2c_fcr0{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_fcr0_field_t		stcField;
}un_cpg_mfsn_i2c_fcr0_t;

/* FCR1 */
#define CPG_MFS00_I2C_FCR1	(CPG_MFS00_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_FCR1_FSEL	(CPG_MFS00_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1_FTIE	(CPG_MFS00_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1_FDRQ	(CPG_MFS00_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1_FRIIE	(CPG_MFS00_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1_FLSTE	(CPG_MFS00_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS01_I2C_FCR1	(CPG_MFS01_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_FCR1_FSEL	(CPG_MFS01_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1_FTIE	(CPG_MFS01_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1_FDRQ	(CPG_MFS01_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1_FRIIE	(CPG_MFS01_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1_FLSTE	(CPG_MFS01_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS02_I2C_FCR1	(CPG_MFS02_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_FCR1_FSEL	(CPG_MFS02_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1_FTIE	(CPG_MFS02_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1_FDRQ	(CPG_MFS02_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1_FRIIE	(CPG_MFS02_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1_FLSTE	(CPG_MFS02_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS03_I2C_FCR1	(CPG_MFS03_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_FCR1_FSEL	(CPG_MFS03_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1_FTIE	(CPG_MFS03_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1_FDRQ	(CPG_MFS03_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1_FRIIE	(CPG_MFS03_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1_FLSTE	(CPG_MFS03_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS04_I2C_FCR1	(CPG_MFS04_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_FCR1_FSEL	(CPG_MFS04_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1_FTIE	(CPG_MFS04_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1_FDRQ	(CPG_MFS04_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1_FRIIE	(CPG_MFS04_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1_FLSTE	(CPG_MFS04_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS05_I2C_FCR1	(CPG_MFS05_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_FCR1_FSEL	(CPG_MFS05_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1_FTIE	(CPG_MFS05_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1_FDRQ	(CPG_MFS05_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1_FRIIE	(CPG_MFS05_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1_FLSTE	(CPG_MFS05_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS06_I2C_FCR1	(CPG_MFS06_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_FCR1_FSEL	(CPG_MFS06_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1_FTIE	(CPG_MFS06_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1_FDRQ	(CPG_MFS06_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1_FRIIE	(CPG_MFS06_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1_FLSTE	(CPG_MFS06_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS07_I2C_FCR1	(CPG_MFS07_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_FCR1_FSEL	(CPG_MFS07_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1_FTIE	(CPG_MFS07_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1_FDRQ	(CPG_MFS07_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1_FRIIE	(CPG_MFS07_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1_FLSTE	(CPG_MFS07_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS08_I2C_FCR1	(CPG_MFS08_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_FCR1_FSEL	(CPG_MFS08_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1_FTIE	(CPG_MFS08_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1_FDRQ	(CPG_MFS08_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1_FRIIE	(CPG_MFS08_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1_FLSTE	(CPG_MFS08_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS09_I2C_FCR1	(CPG_MFS09_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_FCR1_FSEL	(CPG_MFS09_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1_FTIE	(CPG_MFS09_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1_FDRQ	(CPG_MFS09_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1_FRIIE	(CPG_MFS09_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1_FLSTE	(CPG_MFS09_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS10_I2C_FCR1	(CPG_MFS10_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_FCR1_FSEL	(CPG_MFS10_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1_FTIE	(CPG_MFS10_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1_FDRQ	(CPG_MFS10_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1_FRIIE	(CPG_MFS10_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1_FLSTE	(CPG_MFS10_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS11_I2C_FCR1	(CPG_MFS11_I2C.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_FCR1_FSEL	(CPG_MFS11_I2C.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1_FTIE	(CPG_MFS11_I2C.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1_FDRQ	(CPG_MFS11_I2C.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1_FRIIE	(CPG_MFS11_I2C.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1_FLSTE	(CPG_MFS11_I2C.unFCR1.stcField.u1FLSTE)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_fcr1_field{
    uint_io8_t		u1FSEL:1;
    uint_io8_t		u1FTIE:1;
    uint_io8_t		u1FDRQ:1;
    uint_io8_t		u1FRIIE:1;
    uint_io8_t		u1FLSTE:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_fcr1_field_t;

typedef union un_cpg_mfsn_i2c_fcr1{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_fcr1_field_t		stcField;
}un_cpg_mfsn_i2c_fcr1_t;

/* FBYTE */
#define CPG_MFS00_I2C_FBYTE	(CPG_MFS00_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_FBYTE_FBYTE1	(CPG_MFS00_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_I2C_FBYTE_FBYTE2	(CPG_MFS00_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_I2C_FBYTE	(CPG_MFS01_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_FBYTE_FBYTE1	(CPG_MFS01_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_I2C_FBYTE_FBYTE2	(CPG_MFS01_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_I2C_FBYTE	(CPG_MFS02_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_FBYTE_FBYTE1	(CPG_MFS02_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_I2C_FBYTE_FBYTE2	(CPG_MFS02_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_I2C_FBYTE	(CPG_MFS03_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_FBYTE_FBYTE1	(CPG_MFS03_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_I2C_FBYTE_FBYTE2	(CPG_MFS03_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_I2C_FBYTE	(CPG_MFS04_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_FBYTE_FBYTE1	(CPG_MFS04_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_I2C_FBYTE_FBYTE2	(CPG_MFS04_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_I2C_FBYTE	(CPG_MFS05_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_FBYTE_FBYTE1	(CPG_MFS05_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_I2C_FBYTE_FBYTE2	(CPG_MFS05_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_I2C_FBYTE	(CPG_MFS06_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_FBYTE_FBYTE1	(CPG_MFS06_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_I2C_FBYTE_FBYTE2	(CPG_MFS06_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_I2C_FBYTE	(CPG_MFS07_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_FBYTE_FBYTE1	(CPG_MFS07_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_I2C_FBYTE_FBYTE2	(CPG_MFS07_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_I2C_FBYTE	(CPG_MFS08_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_FBYTE_FBYTE1	(CPG_MFS08_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_I2C_FBYTE_FBYTE2	(CPG_MFS08_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_I2C_FBYTE	(CPG_MFS09_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_FBYTE_FBYTE1	(CPG_MFS09_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_I2C_FBYTE_FBYTE2	(CPG_MFS09_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_I2C_FBYTE	(CPG_MFS10_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_FBYTE_FBYTE1	(CPG_MFS10_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_I2C_FBYTE_FBYTE2	(CPG_MFS10_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_I2C_FBYTE	(CPG_MFS11_I2C.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_FBYTE_FBYTE1	(CPG_MFS11_I2C.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_I2C_FBYTE_FBYTE2	(CPG_MFS11_I2C.unFBYTE.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_i2c_fbyte_field{
    uint_io16_t		u8FBYTE1:8;
    uint_io16_t		u8FBYTE2:8;
}stc_cpg_mfsn_i2c_fbyte_field_t;

typedef union un_cpg_mfsn_i2c_fbyte{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_i2c_fbyte_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_fbyte_t;

/* FTICR */
#define CPG_MFS00_I2C_FTICR	(CPG_MFS00_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_FTICR_FTICR1	(CPG_MFS00_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_I2C_FTICR_FTICR2	(CPG_MFS00_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_I2C_FTICR	(CPG_MFS01_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_FTICR_FTICR1	(CPG_MFS01_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_I2C_FTICR_FTICR2	(CPG_MFS01_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_I2C_FTICR	(CPG_MFS02_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_FTICR_FTICR1	(CPG_MFS02_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_I2C_FTICR_FTICR2	(CPG_MFS02_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_I2C_FTICR	(CPG_MFS03_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_FTICR_FTICR1	(CPG_MFS03_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_I2C_FTICR_FTICR2	(CPG_MFS03_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_I2C_FTICR	(CPG_MFS04_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_FTICR_FTICR1	(CPG_MFS04_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_I2C_FTICR_FTICR2	(CPG_MFS04_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_I2C_FTICR	(CPG_MFS05_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_FTICR_FTICR1	(CPG_MFS05_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_I2C_FTICR_FTICR2	(CPG_MFS05_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_I2C_FTICR	(CPG_MFS06_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_FTICR_FTICR1	(CPG_MFS06_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_I2C_FTICR_FTICR2	(CPG_MFS06_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_I2C_FTICR	(CPG_MFS07_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_FTICR_FTICR1	(CPG_MFS07_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_I2C_FTICR_FTICR2	(CPG_MFS07_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_I2C_FTICR	(CPG_MFS08_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_FTICR_FTICR1	(CPG_MFS08_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_I2C_FTICR_FTICR2	(CPG_MFS08_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_I2C_FTICR	(CPG_MFS09_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_FTICR_FTICR1	(CPG_MFS09_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_I2C_FTICR_FTICR2	(CPG_MFS09_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_I2C_FTICR	(CPG_MFS10_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_FTICR_FTICR1	(CPG_MFS10_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_I2C_FTICR_FTICR2	(CPG_MFS10_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_I2C_FTICR	(CPG_MFS11_I2C.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_FTICR_FTICR1	(CPG_MFS11_I2C.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_I2C_FTICR_FTICR2	(CPG_MFS11_I2C.unFTICR.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_i2c_fticr_field{
    uint_io16_t		u8FTICR1:8;
    uint_io16_t		u8FTICR2:8;
}stc_cpg_mfsn_i2c_fticr_field_t;

typedef union un_cpg_mfsn_i2c_fticr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_i2c_fticr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_fticr_t;

/* ECR */
#define CPG_MFS00_I2C_ECR	(CPG_MFS00_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_ECR_TXBLKEN	(CPG_MFS00_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS00_I2C_ECR_RXBLKEN	(CPG_MFS00_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS00_I2C_ECR_TEIE	(CPG_MFS00_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS00_I2C_ECR_REIE	(CPG_MFS00_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS00_I2C_ECR_EISEL	(CPG_MFS00_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS01_I2C_ECR	(CPG_MFS01_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_ECR_TXBLKEN	(CPG_MFS01_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS01_I2C_ECR_RXBLKEN	(CPG_MFS01_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS01_I2C_ECR_TEIE	(CPG_MFS01_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS01_I2C_ECR_REIE	(CPG_MFS01_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS01_I2C_ECR_EISEL	(CPG_MFS01_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS02_I2C_ECR	(CPG_MFS02_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_ECR_TXBLKEN	(CPG_MFS02_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS02_I2C_ECR_RXBLKEN	(CPG_MFS02_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS02_I2C_ECR_TEIE	(CPG_MFS02_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS02_I2C_ECR_REIE	(CPG_MFS02_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS02_I2C_ECR_EISEL	(CPG_MFS02_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS03_I2C_ECR	(CPG_MFS03_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_ECR_TXBLKEN	(CPG_MFS03_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS03_I2C_ECR_RXBLKEN	(CPG_MFS03_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS03_I2C_ECR_TEIE	(CPG_MFS03_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS03_I2C_ECR_REIE	(CPG_MFS03_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS03_I2C_ECR_EISEL	(CPG_MFS03_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS04_I2C_ECR	(CPG_MFS04_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_ECR_TXBLKEN	(CPG_MFS04_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS04_I2C_ECR_RXBLKEN	(CPG_MFS04_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS04_I2C_ECR_TEIE	(CPG_MFS04_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS04_I2C_ECR_REIE	(CPG_MFS04_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS04_I2C_ECR_EISEL	(CPG_MFS04_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS05_I2C_ECR	(CPG_MFS05_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_ECR_TXBLKEN	(CPG_MFS05_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS05_I2C_ECR_RXBLKEN	(CPG_MFS05_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS05_I2C_ECR_TEIE	(CPG_MFS05_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS05_I2C_ECR_REIE	(CPG_MFS05_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS05_I2C_ECR_EISEL	(CPG_MFS05_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS06_I2C_ECR	(CPG_MFS06_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_ECR_TXBLKEN	(CPG_MFS06_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS06_I2C_ECR_RXBLKEN	(CPG_MFS06_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS06_I2C_ECR_TEIE	(CPG_MFS06_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS06_I2C_ECR_REIE	(CPG_MFS06_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS06_I2C_ECR_EISEL	(CPG_MFS06_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS07_I2C_ECR	(CPG_MFS07_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_ECR_TXBLKEN	(CPG_MFS07_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS07_I2C_ECR_RXBLKEN	(CPG_MFS07_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS07_I2C_ECR_TEIE	(CPG_MFS07_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS07_I2C_ECR_REIE	(CPG_MFS07_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS07_I2C_ECR_EISEL	(CPG_MFS07_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS08_I2C_ECR	(CPG_MFS08_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_ECR_TXBLKEN	(CPG_MFS08_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS08_I2C_ECR_RXBLKEN	(CPG_MFS08_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS08_I2C_ECR_TEIE	(CPG_MFS08_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS08_I2C_ECR_REIE	(CPG_MFS08_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS08_I2C_ECR_EISEL	(CPG_MFS08_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS09_I2C_ECR	(CPG_MFS09_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_ECR_TXBLKEN	(CPG_MFS09_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS09_I2C_ECR_RXBLKEN	(CPG_MFS09_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS09_I2C_ECR_TEIE	(CPG_MFS09_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS09_I2C_ECR_REIE	(CPG_MFS09_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS09_I2C_ECR_EISEL	(CPG_MFS09_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS10_I2C_ECR	(CPG_MFS10_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_ECR_TXBLKEN	(CPG_MFS10_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS10_I2C_ECR_RXBLKEN	(CPG_MFS10_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS10_I2C_ECR_TEIE	(CPG_MFS10_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS10_I2C_ECR_REIE	(CPG_MFS10_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS10_I2C_ECR_EISEL	(CPG_MFS10_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS11_I2C_ECR	(CPG_MFS11_I2C.unECR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_ECR_TXBLKEN	(CPG_MFS11_I2C.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS11_I2C_ECR_RXBLKEN	(CPG_MFS11_I2C.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS11_I2C_ECR_TEIE	(CPG_MFS11_I2C.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS11_I2C_ECR_REIE	(CPG_MFS11_I2C.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS11_I2C_ECR_EISEL	(CPG_MFS11_I2C.unECR.stcField.u1EISEL)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ecr_field{
    uint_io8_t		u1TXBLKEN:1;
    uint_io8_t		u1RXBLKEN:1;
    uint_io8_t		u1TEIE:1;
    uint_io8_t		u1REIE:1;
    uint_io8_t		u1EISEL:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_ecr_field_t;

typedef union un_cpg_mfsn_i2c_ecr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ecr_field_t		stcField;
}un_cpg_mfsn_i2c_ecr_t;

/* ESR */
#define CPG_MFS00_I2C_ESR	(CPG_MFS00_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_ESR_TBERR	(CPG_MFS00_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS00_I2C_ESR_RBERR	(CPG_MFS00_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS00_I2C_ESR_TXOVR	(CPG_MFS00_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS00_I2C_ESR_RXUDR	(CPG_MFS00_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS01_I2C_ESR	(CPG_MFS01_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_ESR_TBERR	(CPG_MFS01_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS01_I2C_ESR_RBERR	(CPG_MFS01_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS01_I2C_ESR_TXOVR	(CPG_MFS01_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS01_I2C_ESR_RXUDR	(CPG_MFS01_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS02_I2C_ESR	(CPG_MFS02_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_ESR_TBERR	(CPG_MFS02_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS02_I2C_ESR_RBERR	(CPG_MFS02_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS02_I2C_ESR_TXOVR	(CPG_MFS02_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS02_I2C_ESR_RXUDR	(CPG_MFS02_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS03_I2C_ESR	(CPG_MFS03_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_ESR_TBERR	(CPG_MFS03_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS03_I2C_ESR_RBERR	(CPG_MFS03_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS03_I2C_ESR_TXOVR	(CPG_MFS03_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS03_I2C_ESR_RXUDR	(CPG_MFS03_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS04_I2C_ESR	(CPG_MFS04_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_ESR_TBERR	(CPG_MFS04_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS04_I2C_ESR_RBERR	(CPG_MFS04_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS04_I2C_ESR_TXOVR	(CPG_MFS04_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS04_I2C_ESR_RXUDR	(CPG_MFS04_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS05_I2C_ESR	(CPG_MFS05_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_ESR_TBERR	(CPG_MFS05_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS05_I2C_ESR_RBERR	(CPG_MFS05_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS05_I2C_ESR_TXOVR	(CPG_MFS05_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS05_I2C_ESR_RXUDR	(CPG_MFS05_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS06_I2C_ESR	(CPG_MFS06_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_ESR_TBERR	(CPG_MFS06_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS06_I2C_ESR_RBERR	(CPG_MFS06_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS06_I2C_ESR_TXOVR	(CPG_MFS06_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS06_I2C_ESR_RXUDR	(CPG_MFS06_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS07_I2C_ESR	(CPG_MFS07_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_ESR_TBERR	(CPG_MFS07_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS07_I2C_ESR_RBERR	(CPG_MFS07_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS07_I2C_ESR_TXOVR	(CPG_MFS07_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS07_I2C_ESR_RXUDR	(CPG_MFS07_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS08_I2C_ESR	(CPG_MFS08_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_ESR_TBERR	(CPG_MFS08_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS08_I2C_ESR_RBERR	(CPG_MFS08_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS08_I2C_ESR_TXOVR	(CPG_MFS08_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS08_I2C_ESR_RXUDR	(CPG_MFS08_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS09_I2C_ESR	(CPG_MFS09_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_ESR_TBERR	(CPG_MFS09_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS09_I2C_ESR_RBERR	(CPG_MFS09_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS09_I2C_ESR_TXOVR	(CPG_MFS09_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS09_I2C_ESR_RXUDR	(CPG_MFS09_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS10_I2C_ESR	(CPG_MFS10_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_ESR_TBERR	(CPG_MFS10_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS10_I2C_ESR_RBERR	(CPG_MFS10_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS10_I2C_ESR_TXOVR	(CPG_MFS10_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS10_I2C_ESR_RXUDR	(CPG_MFS10_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS11_I2C_ESR	(CPG_MFS11_I2C.unESR.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_ESR_TBERR	(CPG_MFS11_I2C.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS11_I2C_ESR_RBERR	(CPG_MFS11_I2C.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS11_I2C_ESR_TXOVR	(CPG_MFS11_I2C.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS11_I2C_ESR_RXUDR	(CPG_MFS11_I2C.unESR.stcField.u1RXUDR)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_esr_field{
    uint_io8_t		u1TBERR:1;
    uint_io8_t		u1RBERR:1;
    uint_io8_t		u1TXOVR:1;
    uint_io8_t		u1RXUDR:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_i2c_esr_field_t;

typedef union un_cpg_mfsn_i2c_esr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_esr_field_t		stcField;
}un_cpg_mfsn_i2c_esr_t;

/* TBSIZE */
#define CPG_MFS00_I2C_TBSIZE	(CPG_MFS00_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_TBSIZE_TBSIZE	CPG_MFS00_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS01_I2C_TBSIZE	(CPG_MFS01_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_TBSIZE_TBSIZE	CPG_MFS01_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS02_I2C_TBSIZE	(CPG_MFS02_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_TBSIZE_TBSIZE	CPG_MFS02_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS03_I2C_TBSIZE	(CPG_MFS03_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_TBSIZE_TBSIZE	CPG_MFS03_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS04_I2C_TBSIZE	(CPG_MFS04_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_TBSIZE_TBSIZE	CPG_MFS04_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS05_I2C_TBSIZE	(CPG_MFS05_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_TBSIZE_TBSIZE	CPG_MFS05_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS06_I2C_TBSIZE	(CPG_MFS06_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_TBSIZE_TBSIZE	CPG_MFS06_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS07_I2C_TBSIZE	(CPG_MFS07_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_TBSIZE_TBSIZE	CPG_MFS07_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS08_I2C_TBSIZE	(CPG_MFS08_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_TBSIZE_TBSIZE	CPG_MFS08_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS09_I2C_TBSIZE	(CPG_MFS09_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_TBSIZE_TBSIZE	CPG_MFS09_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS10_I2C_TBSIZE	(CPG_MFS10_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_TBSIZE_TBSIZE	CPG_MFS10_I2C_TBSIZE  /*@bfrg@*/

#define CPG_MFS11_I2C_TBSIZE	(CPG_MFS11_I2C.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_TBSIZE_TBSIZE	CPG_MFS11_I2C_TBSIZE  /*@bfrg@*/

typedef union un_cpg_mfsn_i2c_tbsize{
    uint_io8_t		u8Register;
}un_cpg_mfsn_i2c_tbsize_t;

/* SMRC */
#define CPG_MFS00_I2C_SMRC	(CPG_MFS00_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_SMRC_TIEC	(CPG_MFS00_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS00_I2C_SMRC_RIEC	(CPG_MFS00_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS00_I2C_SMRC_WUCRC	(CPG_MFS00_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS01_I2C_SMRC	(CPG_MFS01_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_SMRC_TIEC	(CPG_MFS01_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS01_I2C_SMRC_RIEC	(CPG_MFS01_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS01_I2C_SMRC_WUCRC	(CPG_MFS01_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS02_I2C_SMRC	(CPG_MFS02_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_SMRC_TIEC	(CPG_MFS02_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS02_I2C_SMRC_RIEC	(CPG_MFS02_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS02_I2C_SMRC_WUCRC	(CPG_MFS02_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS03_I2C_SMRC	(CPG_MFS03_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_SMRC_TIEC	(CPG_MFS03_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS03_I2C_SMRC_RIEC	(CPG_MFS03_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS03_I2C_SMRC_WUCRC	(CPG_MFS03_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS04_I2C_SMRC	(CPG_MFS04_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_SMRC_TIEC	(CPG_MFS04_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS04_I2C_SMRC_RIEC	(CPG_MFS04_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS04_I2C_SMRC_WUCRC	(CPG_MFS04_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS05_I2C_SMRC	(CPG_MFS05_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_SMRC_TIEC	(CPG_MFS05_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS05_I2C_SMRC_RIEC	(CPG_MFS05_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS05_I2C_SMRC_WUCRC	(CPG_MFS05_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS06_I2C_SMRC	(CPG_MFS06_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_SMRC_TIEC	(CPG_MFS06_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS06_I2C_SMRC_RIEC	(CPG_MFS06_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS06_I2C_SMRC_WUCRC	(CPG_MFS06_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS07_I2C_SMRC	(CPG_MFS07_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_SMRC_TIEC	(CPG_MFS07_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS07_I2C_SMRC_RIEC	(CPG_MFS07_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS07_I2C_SMRC_WUCRC	(CPG_MFS07_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS08_I2C_SMRC	(CPG_MFS08_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_SMRC_TIEC	(CPG_MFS08_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS08_I2C_SMRC_RIEC	(CPG_MFS08_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS08_I2C_SMRC_WUCRC	(CPG_MFS08_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS09_I2C_SMRC	(CPG_MFS09_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_SMRC_TIEC	(CPG_MFS09_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS09_I2C_SMRC_RIEC	(CPG_MFS09_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS09_I2C_SMRC_WUCRC	(CPG_MFS09_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS10_I2C_SMRC	(CPG_MFS10_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_SMRC_TIEC	(CPG_MFS10_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS10_I2C_SMRC_RIEC	(CPG_MFS10_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS10_I2C_SMRC_WUCRC	(CPG_MFS10_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS11_I2C_SMRC	(CPG_MFS11_I2C.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_SMRC_TIEC	(CPG_MFS11_I2C.unSMRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS11_I2C_SMRC_RIEC	(CPG_MFS11_I2C.unSMRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS11_I2C_SMRC_WUCRC	(CPG_MFS11_I2C.unSMRC.stcField.u1WUCRC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_smrc_field{
    uint_io8_t		:2;
    uint_io8_t		u1TIEC:1;
    uint_io8_t		u1RIEC:1;
    uint_io8_t		u1WUCRC:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_smrc_field_t;

typedef union un_cpg_mfsn_i2c_smrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_smrc_field_t		stcField;
}un_cpg_mfsn_i2c_smrc_t;

/* IBCRC */
#define CPG_MFS00_I2C_IBCRC	(CPG_MFS00_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_IBCRC_INTC	(CPG_MFS00_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRC_INTEC	(CPG_MFS00_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRC_CNDEC	(CPG_MFS00_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRC_WSELC	(CPG_MFS00_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRC_ACKEC	(CPG_MFS00_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRC_MSSC	(CPG_MFS00_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS01_I2C_IBCRC	(CPG_MFS01_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_IBCRC_INTC	(CPG_MFS01_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRC_INTEC	(CPG_MFS01_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRC_CNDEC	(CPG_MFS01_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRC_WSELC	(CPG_MFS01_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRC_ACKEC	(CPG_MFS01_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRC_MSSC	(CPG_MFS01_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS02_I2C_IBCRC	(CPG_MFS02_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_IBCRC_INTC	(CPG_MFS02_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRC_INTEC	(CPG_MFS02_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRC_CNDEC	(CPG_MFS02_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRC_WSELC	(CPG_MFS02_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRC_ACKEC	(CPG_MFS02_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRC_MSSC	(CPG_MFS02_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS03_I2C_IBCRC	(CPG_MFS03_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_IBCRC_INTC	(CPG_MFS03_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRC_INTEC	(CPG_MFS03_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRC_CNDEC	(CPG_MFS03_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRC_WSELC	(CPG_MFS03_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRC_ACKEC	(CPG_MFS03_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRC_MSSC	(CPG_MFS03_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS04_I2C_IBCRC	(CPG_MFS04_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_IBCRC_INTC	(CPG_MFS04_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRC_INTEC	(CPG_MFS04_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRC_CNDEC	(CPG_MFS04_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRC_WSELC	(CPG_MFS04_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRC_ACKEC	(CPG_MFS04_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRC_MSSC	(CPG_MFS04_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS05_I2C_IBCRC	(CPG_MFS05_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_IBCRC_INTC	(CPG_MFS05_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRC_INTEC	(CPG_MFS05_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRC_CNDEC	(CPG_MFS05_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRC_WSELC	(CPG_MFS05_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRC_ACKEC	(CPG_MFS05_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRC_MSSC	(CPG_MFS05_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS06_I2C_IBCRC	(CPG_MFS06_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_IBCRC_INTC	(CPG_MFS06_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRC_INTEC	(CPG_MFS06_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRC_CNDEC	(CPG_MFS06_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRC_WSELC	(CPG_MFS06_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRC_ACKEC	(CPG_MFS06_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRC_MSSC	(CPG_MFS06_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS07_I2C_IBCRC	(CPG_MFS07_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_IBCRC_INTC	(CPG_MFS07_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRC_INTEC	(CPG_MFS07_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRC_CNDEC	(CPG_MFS07_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRC_WSELC	(CPG_MFS07_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRC_ACKEC	(CPG_MFS07_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRC_MSSC	(CPG_MFS07_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS08_I2C_IBCRC	(CPG_MFS08_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_IBCRC_INTC	(CPG_MFS08_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRC_INTEC	(CPG_MFS08_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRC_CNDEC	(CPG_MFS08_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRC_WSELC	(CPG_MFS08_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRC_ACKEC	(CPG_MFS08_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRC_MSSC	(CPG_MFS08_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS09_I2C_IBCRC	(CPG_MFS09_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_IBCRC_INTC	(CPG_MFS09_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRC_INTEC	(CPG_MFS09_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRC_CNDEC	(CPG_MFS09_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRC_WSELC	(CPG_MFS09_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRC_ACKEC	(CPG_MFS09_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRC_MSSC	(CPG_MFS09_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS10_I2C_IBCRC	(CPG_MFS10_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_IBCRC_INTC	(CPG_MFS10_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRC_INTEC	(CPG_MFS10_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRC_CNDEC	(CPG_MFS10_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRC_WSELC	(CPG_MFS10_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRC_ACKEC	(CPG_MFS10_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRC_MSSC	(CPG_MFS10_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

#define CPG_MFS11_I2C_IBCRC	(CPG_MFS11_I2C.unIBCRC.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_IBCRC_INTC	(CPG_MFS11_I2C.unIBCRC.stcField.u1INTC)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRC_INTEC	(CPG_MFS11_I2C.unIBCRC.stcField.u1INTEC)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRC_CNDEC	(CPG_MFS11_I2C.unIBCRC.stcField.u1CNDEC)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRC_WSELC	(CPG_MFS11_I2C.unIBCRC.stcField.u1WSELC)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRC_ACKEC	(CPG_MFS11_I2C.unIBCRC.stcField.u1ACKEC)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRC_MSSC	(CPG_MFS11_I2C.unIBCRC.stcField.u1MSSC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ibcrc_field{
    uint_io8_t		u1INTC:1;
    uint_io8_t		:1;
    uint_io8_t		u1INTEC:1;
    uint_io8_t		u1CNDEC:1;
    uint_io8_t		u1WSELC:1;
    uint_io8_t		u1ACKEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1MSSC:1;
}stc_cpg_mfsn_i2c_ibcrc_field_t;

typedef union un_cpg_mfsn_i2c_ibcrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ibcrc_field_t		stcField;
}un_cpg_mfsn_i2c_ibcrc_t;

/* IBSRC */
#define CPG_MFS00_I2C_IBSRC	(CPG_MFS00_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_IBSRC_SPCC	(CPG_MFS00_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS00_I2C_IBSRC_RSCC	(CPG_MFS00_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS01_I2C_IBSRC	(CPG_MFS01_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_IBSRC_SPCC	(CPG_MFS01_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS01_I2C_IBSRC_RSCC	(CPG_MFS01_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS02_I2C_IBSRC	(CPG_MFS02_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_IBSRC_SPCC	(CPG_MFS02_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS02_I2C_IBSRC_RSCC	(CPG_MFS02_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS03_I2C_IBSRC	(CPG_MFS03_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_IBSRC_SPCC	(CPG_MFS03_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS03_I2C_IBSRC_RSCC	(CPG_MFS03_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS04_I2C_IBSRC	(CPG_MFS04_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_IBSRC_SPCC	(CPG_MFS04_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS04_I2C_IBSRC_RSCC	(CPG_MFS04_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS05_I2C_IBSRC	(CPG_MFS05_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_IBSRC_SPCC	(CPG_MFS05_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS05_I2C_IBSRC_RSCC	(CPG_MFS05_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS06_I2C_IBSRC	(CPG_MFS06_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_IBSRC_SPCC	(CPG_MFS06_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS06_I2C_IBSRC_RSCC	(CPG_MFS06_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS07_I2C_IBSRC	(CPG_MFS07_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_IBSRC_SPCC	(CPG_MFS07_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS07_I2C_IBSRC_RSCC	(CPG_MFS07_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS08_I2C_IBSRC	(CPG_MFS08_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_IBSRC_SPCC	(CPG_MFS08_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS08_I2C_IBSRC_RSCC	(CPG_MFS08_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS09_I2C_IBSRC	(CPG_MFS09_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_IBSRC_SPCC	(CPG_MFS09_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS09_I2C_IBSRC_RSCC	(CPG_MFS09_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS10_I2C_IBSRC	(CPG_MFS10_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_IBSRC_SPCC	(CPG_MFS10_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS10_I2C_IBSRC_RSCC	(CPG_MFS10_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

#define CPG_MFS11_I2C_IBSRC	(CPG_MFS11_I2C.unIBSRC.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_IBSRC_SPCC	(CPG_MFS11_I2C.unIBSRC.stcField.u1SPCC)  /*@bf@*/
#define CPG_MFS11_I2C_IBSRC_RSCC	(CPG_MFS11_I2C.unIBSRC.stcField.u1RSCC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ibsrc_field{
    uint_io8_t		:1;
    uint_io8_t		u1SPCC:1;
    uint_io8_t		u1RSCC:1;
    uint_io8_t		:5;
}stc_cpg_mfsn_i2c_ibsrc_field_t;

typedef union un_cpg_mfsn_i2c_ibsrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ibsrc_field_t		stcField;
}un_cpg_mfsn_i2c_ibsrc_t;

/* SSRC */
#define CPG_MFS00_I2C_SSRC	(CPG_MFS00_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_SSRC_TBIEC	(CPG_MFS00_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS00_I2C_SSRC_DMAC	(CPG_MFS00_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS01_I2C_SSRC	(CPG_MFS01_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_SSRC_TBIEC	(CPG_MFS01_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS01_I2C_SSRC_DMAC	(CPG_MFS01_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS02_I2C_SSRC	(CPG_MFS02_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_SSRC_TBIEC	(CPG_MFS02_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS02_I2C_SSRC_DMAC	(CPG_MFS02_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS03_I2C_SSRC	(CPG_MFS03_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_SSRC_TBIEC	(CPG_MFS03_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS03_I2C_SSRC_DMAC	(CPG_MFS03_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS04_I2C_SSRC	(CPG_MFS04_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_SSRC_TBIEC	(CPG_MFS04_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS04_I2C_SSRC_DMAC	(CPG_MFS04_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS05_I2C_SSRC	(CPG_MFS05_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_SSRC_TBIEC	(CPG_MFS05_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS05_I2C_SSRC_DMAC	(CPG_MFS05_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS06_I2C_SSRC	(CPG_MFS06_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_SSRC_TBIEC	(CPG_MFS06_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS06_I2C_SSRC_DMAC	(CPG_MFS06_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS07_I2C_SSRC	(CPG_MFS07_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_SSRC_TBIEC	(CPG_MFS07_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS07_I2C_SSRC_DMAC	(CPG_MFS07_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS08_I2C_SSRC	(CPG_MFS08_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_SSRC_TBIEC	(CPG_MFS08_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS08_I2C_SSRC_DMAC	(CPG_MFS08_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS09_I2C_SSRC	(CPG_MFS09_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_SSRC_TBIEC	(CPG_MFS09_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS09_I2C_SSRC_DMAC	(CPG_MFS09_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS10_I2C_SSRC	(CPG_MFS10_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_SSRC_TBIEC	(CPG_MFS10_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS10_I2C_SSRC_DMAC	(CPG_MFS10_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

#define CPG_MFS11_I2C_SSRC	(CPG_MFS11_I2C.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_SSRC_TBIEC	(CPG_MFS11_I2C.unSSRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS11_I2C_SSRC_DMAC	(CPG_MFS11_I2C.unSSRC.stcField.u1DMAC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ssrc_field{
    uint_io8_t		:4;
    uint_io8_t		u1TBIEC:1;
    uint_io8_t		u1DMAC:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_i2c_ssrc_field_t;

typedef union un_cpg_mfsn_i2c_ssrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ssrc_field_t		stcField;
}un_cpg_mfsn_i2c_ssrc_t;

/* SACSRC */
#define CPG_MFS00_I2C_SACSRC	(CPG_MFS00_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_SACSRC_TMREC	(CPG_MFS00_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS00_I2C_SACSRC_TRGEC	(CPG_MFS00_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS00_I2C_SACSRC_TINTEC	(CPG_MFS00_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS00_I2C_SACSRC_TINTC	(CPG_MFS00_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS01_I2C_SACSRC	(CPG_MFS01_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_SACSRC_TMREC	(CPG_MFS01_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS01_I2C_SACSRC_TRGEC	(CPG_MFS01_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS01_I2C_SACSRC_TINTEC	(CPG_MFS01_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS01_I2C_SACSRC_TINTC	(CPG_MFS01_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS02_I2C_SACSRC	(CPG_MFS02_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_SACSRC_TMREC	(CPG_MFS02_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS02_I2C_SACSRC_TRGEC	(CPG_MFS02_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS02_I2C_SACSRC_TINTEC	(CPG_MFS02_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS02_I2C_SACSRC_TINTC	(CPG_MFS02_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS03_I2C_SACSRC	(CPG_MFS03_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_SACSRC_TMREC	(CPG_MFS03_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS03_I2C_SACSRC_TRGEC	(CPG_MFS03_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS03_I2C_SACSRC_TINTEC	(CPG_MFS03_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS03_I2C_SACSRC_TINTC	(CPG_MFS03_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS04_I2C_SACSRC	(CPG_MFS04_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_SACSRC_TMREC	(CPG_MFS04_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS04_I2C_SACSRC_TRGEC	(CPG_MFS04_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS04_I2C_SACSRC_TINTEC	(CPG_MFS04_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS04_I2C_SACSRC_TINTC	(CPG_MFS04_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS05_I2C_SACSRC	(CPG_MFS05_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_SACSRC_TMREC	(CPG_MFS05_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS05_I2C_SACSRC_TRGEC	(CPG_MFS05_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS05_I2C_SACSRC_TINTEC	(CPG_MFS05_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS05_I2C_SACSRC_TINTC	(CPG_MFS05_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS06_I2C_SACSRC	(CPG_MFS06_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_SACSRC_TMREC	(CPG_MFS06_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS06_I2C_SACSRC_TRGEC	(CPG_MFS06_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS06_I2C_SACSRC_TINTEC	(CPG_MFS06_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS06_I2C_SACSRC_TINTC	(CPG_MFS06_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS07_I2C_SACSRC	(CPG_MFS07_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_SACSRC_TMREC	(CPG_MFS07_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS07_I2C_SACSRC_TRGEC	(CPG_MFS07_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS07_I2C_SACSRC_TINTEC	(CPG_MFS07_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS07_I2C_SACSRC_TINTC	(CPG_MFS07_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS08_I2C_SACSRC	(CPG_MFS08_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_SACSRC_TMREC	(CPG_MFS08_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS08_I2C_SACSRC_TRGEC	(CPG_MFS08_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS08_I2C_SACSRC_TINTEC	(CPG_MFS08_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS08_I2C_SACSRC_TINTC	(CPG_MFS08_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS09_I2C_SACSRC	(CPG_MFS09_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_SACSRC_TMREC	(CPG_MFS09_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS09_I2C_SACSRC_TRGEC	(CPG_MFS09_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS09_I2C_SACSRC_TINTEC	(CPG_MFS09_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS09_I2C_SACSRC_TINTC	(CPG_MFS09_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS10_I2C_SACSRC	(CPG_MFS10_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_SACSRC_TMREC	(CPG_MFS10_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS10_I2C_SACSRC_TRGEC	(CPG_MFS10_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS10_I2C_SACSRC_TINTEC	(CPG_MFS10_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS10_I2C_SACSRC_TINTC	(CPG_MFS10_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

#define CPG_MFS11_I2C_SACSRC	(CPG_MFS11_I2C.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_SACSRC_TMREC	(CPG_MFS11_I2C.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS11_I2C_SACSRC_TRGEC	(CPG_MFS11_I2C.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS11_I2C_SACSRC_TINTEC	(CPG_MFS11_I2C.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS11_I2C_SACSRC_TINTC	(CPG_MFS11_I2C.unSACSRC.stcField.u1TINTC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_sacsrc_field{
    uint_io16_t		u1TMREC:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGEC:1;
    uint_io16_t		:1;
    uint_io16_t		u1TINTEC:1;
    uint_io16_t		u1TINTC:1;
    uint_io16_t		:7;
}stc_cpg_mfsn_i2c_sacsrc_field_t;

typedef union un_cpg_mfsn_i2c_sacsrc{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_i2c_sacsrc_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_sacsrc_t;

/* FCR0C */
#define CPG_MFS00_I2C_FCR0C	(CPG_MFS00_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_FCR0C_FE1C	(CPG_MFS00_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0C_FE2C	(CPG_MFS00_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS01_I2C_FCR0C	(CPG_MFS01_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_FCR0C_FE1C	(CPG_MFS01_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0C_FE2C	(CPG_MFS01_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS02_I2C_FCR0C	(CPG_MFS02_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_FCR0C_FE1C	(CPG_MFS02_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0C_FE2C	(CPG_MFS02_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS03_I2C_FCR0C	(CPG_MFS03_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_FCR0C_FE1C	(CPG_MFS03_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0C_FE2C	(CPG_MFS03_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS04_I2C_FCR0C	(CPG_MFS04_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_FCR0C_FE1C	(CPG_MFS04_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0C_FE2C	(CPG_MFS04_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS05_I2C_FCR0C	(CPG_MFS05_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_FCR0C_FE1C	(CPG_MFS05_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0C_FE2C	(CPG_MFS05_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS06_I2C_FCR0C	(CPG_MFS06_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_FCR0C_FE1C	(CPG_MFS06_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0C_FE2C	(CPG_MFS06_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS07_I2C_FCR0C	(CPG_MFS07_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_FCR0C_FE1C	(CPG_MFS07_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0C_FE2C	(CPG_MFS07_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS08_I2C_FCR0C	(CPG_MFS08_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_FCR0C_FE1C	(CPG_MFS08_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0C_FE2C	(CPG_MFS08_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS09_I2C_FCR0C	(CPG_MFS09_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_FCR0C_FE1C	(CPG_MFS09_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0C_FE2C	(CPG_MFS09_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS10_I2C_FCR0C	(CPG_MFS10_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_FCR0C_FE1C	(CPG_MFS10_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0C_FE2C	(CPG_MFS10_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS11_I2C_FCR0C	(CPG_MFS11_I2C.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_FCR0C_FE1C	(CPG_MFS11_I2C.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0C_FE2C	(CPG_MFS11_I2C.unFCR0C.stcField.u1FE2C)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_fcr0c_field{
    uint_io8_t		u1FE1C:1;
    uint_io8_t		u1FE2C:1;
    uint_io8_t		:6;
}stc_cpg_mfsn_i2c_fcr0c_field_t;

typedef union un_cpg_mfsn_i2c_fcr0c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_fcr0c_field_t		stcField;
}un_cpg_mfsn_i2c_fcr0c_t;

/* FCR1C */
#define CPG_MFS00_I2C_FCR1C	(CPG_MFS00_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_FCR1C_FSELC	(CPG_MFS00_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1C_FTIEC	(CPG_MFS00_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1C_FDRQC	(CPG_MFS00_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1C_FRIIEC	(CPG_MFS00_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1C_FLSTEC	(CPG_MFS00_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS01_I2C_FCR1C	(CPG_MFS01_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_FCR1C_FSELC	(CPG_MFS01_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1C_FTIEC	(CPG_MFS01_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1C_FDRQC	(CPG_MFS01_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1C_FRIIEC	(CPG_MFS01_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1C_FLSTEC	(CPG_MFS01_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS02_I2C_FCR1C	(CPG_MFS02_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_FCR1C_FSELC	(CPG_MFS02_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1C_FTIEC	(CPG_MFS02_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1C_FDRQC	(CPG_MFS02_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1C_FRIIEC	(CPG_MFS02_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1C_FLSTEC	(CPG_MFS02_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS03_I2C_FCR1C	(CPG_MFS03_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_FCR1C_FSELC	(CPG_MFS03_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1C_FTIEC	(CPG_MFS03_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1C_FDRQC	(CPG_MFS03_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1C_FRIIEC	(CPG_MFS03_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1C_FLSTEC	(CPG_MFS03_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS04_I2C_FCR1C	(CPG_MFS04_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_FCR1C_FSELC	(CPG_MFS04_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1C_FTIEC	(CPG_MFS04_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1C_FDRQC	(CPG_MFS04_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1C_FRIIEC	(CPG_MFS04_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1C_FLSTEC	(CPG_MFS04_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS05_I2C_FCR1C	(CPG_MFS05_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_FCR1C_FSELC	(CPG_MFS05_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1C_FTIEC	(CPG_MFS05_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1C_FDRQC	(CPG_MFS05_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1C_FRIIEC	(CPG_MFS05_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1C_FLSTEC	(CPG_MFS05_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS06_I2C_FCR1C	(CPG_MFS06_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_FCR1C_FSELC	(CPG_MFS06_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1C_FTIEC	(CPG_MFS06_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1C_FDRQC	(CPG_MFS06_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1C_FRIIEC	(CPG_MFS06_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1C_FLSTEC	(CPG_MFS06_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS07_I2C_FCR1C	(CPG_MFS07_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_FCR1C_FSELC	(CPG_MFS07_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1C_FTIEC	(CPG_MFS07_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1C_FDRQC	(CPG_MFS07_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1C_FRIIEC	(CPG_MFS07_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1C_FLSTEC	(CPG_MFS07_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS08_I2C_FCR1C	(CPG_MFS08_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_FCR1C_FSELC	(CPG_MFS08_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1C_FTIEC	(CPG_MFS08_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1C_FDRQC	(CPG_MFS08_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1C_FRIIEC	(CPG_MFS08_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1C_FLSTEC	(CPG_MFS08_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS09_I2C_FCR1C	(CPG_MFS09_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_FCR1C_FSELC	(CPG_MFS09_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1C_FTIEC	(CPG_MFS09_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1C_FDRQC	(CPG_MFS09_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1C_FRIIEC	(CPG_MFS09_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1C_FLSTEC	(CPG_MFS09_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS10_I2C_FCR1C	(CPG_MFS10_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_FCR1C_FSELC	(CPG_MFS10_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1C_FTIEC	(CPG_MFS10_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1C_FDRQC	(CPG_MFS10_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1C_FRIIEC	(CPG_MFS10_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1C_FLSTEC	(CPG_MFS10_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS11_I2C_FCR1C	(CPG_MFS11_I2C.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_FCR1C_FSELC	(CPG_MFS11_I2C.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1C_FTIEC	(CPG_MFS11_I2C.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1C_FDRQC	(CPG_MFS11_I2C.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1C_FRIIEC	(CPG_MFS11_I2C.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1C_FLSTEC	(CPG_MFS11_I2C.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_fcr1c_field{
    uint_io8_t		u1FSELC:1;
    uint_io8_t		u1FTIEC:1;
    uint_io8_t		u1FDRQC:1;
    uint_io8_t		u1FRIIEC:1;
    uint_io8_t		u1FLSTEC:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_fcr1c_field_t;

typedef union un_cpg_mfsn_i2c_fcr1c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_fcr1c_field_t		stcField;
}un_cpg_mfsn_i2c_fcr1c_t;

/* ESRC */
#define CPG_MFS00_I2C_ESRC	(CPG_MFS00_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_ESRC_TBERRC	(CPG_MFS00_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS00_I2C_ESRC_RBERRC	(CPG_MFS00_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS00_I2C_ESRC_TXOVRC	(CPG_MFS00_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS00_I2C_ESRC_RXUDRC	(CPG_MFS00_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS01_I2C_ESRC	(CPG_MFS01_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_ESRC_TBERRC	(CPG_MFS01_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS01_I2C_ESRC_RBERRC	(CPG_MFS01_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS01_I2C_ESRC_TXOVRC	(CPG_MFS01_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS01_I2C_ESRC_RXUDRC	(CPG_MFS01_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS02_I2C_ESRC	(CPG_MFS02_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_ESRC_TBERRC	(CPG_MFS02_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS02_I2C_ESRC_RBERRC	(CPG_MFS02_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS02_I2C_ESRC_TXOVRC	(CPG_MFS02_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS02_I2C_ESRC_RXUDRC	(CPG_MFS02_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS03_I2C_ESRC	(CPG_MFS03_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_ESRC_TBERRC	(CPG_MFS03_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS03_I2C_ESRC_RBERRC	(CPG_MFS03_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS03_I2C_ESRC_TXOVRC	(CPG_MFS03_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS03_I2C_ESRC_RXUDRC	(CPG_MFS03_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS04_I2C_ESRC	(CPG_MFS04_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_ESRC_TBERRC	(CPG_MFS04_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS04_I2C_ESRC_RBERRC	(CPG_MFS04_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS04_I2C_ESRC_TXOVRC	(CPG_MFS04_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS04_I2C_ESRC_RXUDRC	(CPG_MFS04_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS05_I2C_ESRC	(CPG_MFS05_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_ESRC_TBERRC	(CPG_MFS05_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS05_I2C_ESRC_RBERRC	(CPG_MFS05_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS05_I2C_ESRC_TXOVRC	(CPG_MFS05_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS05_I2C_ESRC_RXUDRC	(CPG_MFS05_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS06_I2C_ESRC	(CPG_MFS06_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_ESRC_TBERRC	(CPG_MFS06_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS06_I2C_ESRC_RBERRC	(CPG_MFS06_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS06_I2C_ESRC_TXOVRC	(CPG_MFS06_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS06_I2C_ESRC_RXUDRC	(CPG_MFS06_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS07_I2C_ESRC	(CPG_MFS07_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_ESRC_TBERRC	(CPG_MFS07_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS07_I2C_ESRC_RBERRC	(CPG_MFS07_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS07_I2C_ESRC_TXOVRC	(CPG_MFS07_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS07_I2C_ESRC_RXUDRC	(CPG_MFS07_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS08_I2C_ESRC	(CPG_MFS08_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_ESRC_TBERRC	(CPG_MFS08_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS08_I2C_ESRC_RBERRC	(CPG_MFS08_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS08_I2C_ESRC_TXOVRC	(CPG_MFS08_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS08_I2C_ESRC_RXUDRC	(CPG_MFS08_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS09_I2C_ESRC	(CPG_MFS09_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_ESRC_TBERRC	(CPG_MFS09_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS09_I2C_ESRC_RBERRC	(CPG_MFS09_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS09_I2C_ESRC_TXOVRC	(CPG_MFS09_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS09_I2C_ESRC_RXUDRC	(CPG_MFS09_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS10_I2C_ESRC	(CPG_MFS10_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_ESRC_TBERRC	(CPG_MFS10_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS10_I2C_ESRC_RBERRC	(CPG_MFS10_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS10_I2C_ESRC_TXOVRC	(CPG_MFS10_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS10_I2C_ESRC_RXUDRC	(CPG_MFS10_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS11_I2C_ESRC	(CPG_MFS11_I2C.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_ESRC_TBERRC	(CPG_MFS11_I2C.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS11_I2C_ESRC_RBERRC	(CPG_MFS11_I2C.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS11_I2C_ESRC_TXOVRC	(CPG_MFS11_I2C.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS11_I2C_ESRC_RXUDRC	(CPG_MFS11_I2C.unESRC.stcField.u1RXUDRC)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_esrc_field{
    uint_io8_t		u1TBERRC:1;
    uint_io8_t		u1RBERRC:1;
    uint_io8_t		u1TXOVRC:1;
    uint_io8_t		u1RXUDRC:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_i2c_esrc_field_t;

typedef union un_cpg_mfsn_i2c_esrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_esrc_field_t		stcField;
}un_cpg_mfsn_i2c_esrc_t;

/* SMRS */
#define CPG_MFS00_I2C_SMRS	(CPG_MFS00_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_SMRS_TIES	(CPG_MFS00_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS00_I2C_SMRS_RIES	(CPG_MFS00_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS00_I2C_SMRS_WUCRS	(CPG_MFS00_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS01_I2C_SMRS	(CPG_MFS01_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_SMRS_TIES	(CPG_MFS01_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS01_I2C_SMRS_RIES	(CPG_MFS01_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS01_I2C_SMRS_WUCRS	(CPG_MFS01_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS02_I2C_SMRS	(CPG_MFS02_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_SMRS_TIES	(CPG_MFS02_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS02_I2C_SMRS_RIES	(CPG_MFS02_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS02_I2C_SMRS_WUCRS	(CPG_MFS02_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS03_I2C_SMRS	(CPG_MFS03_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_SMRS_TIES	(CPG_MFS03_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS03_I2C_SMRS_RIES	(CPG_MFS03_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS03_I2C_SMRS_WUCRS	(CPG_MFS03_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS04_I2C_SMRS	(CPG_MFS04_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_SMRS_TIES	(CPG_MFS04_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS04_I2C_SMRS_RIES	(CPG_MFS04_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS04_I2C_SMRS_WUCRS	(CPG_MFS04_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS05_I2C_SMRS	(CPG_MFS05_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_SMRS_TIES	(CPG_MFS05_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS05_I2C_SMRS_RIES	(CPG_MFS05_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS05_I2C_SMRS_WUCRS	(CPG_MFS05_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS06_I2C_SMRS	(CPG_MFS06_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_SMRS_TIES	(CPG_MFS06_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS06_I2C_SMRS_RIES	(CPG_MFS06_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS06_I2C_SMRS_WUCRS	(CPG_MFS06_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS07_I2C_SMRS	(CPG_MFS07_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_SMRS_TIES	(CPG_MFS07_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS07_I2C_SMRS_RIES	(CPG_MFS07_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS07_I2C_SMRS_WUCRS	(CPG_MFS07_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS08_I2C_SMRS	(CPG_MFS08_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_SMRS_TIES	(CPG_MFS08_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS08_I2C_SMRS_RIES	(CPG_MFS08_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS08_I2C_SMRS_WUCRS	(CPG_MFS08_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS09_I2C_SMRS	(CPG_MFS09_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_SMRS_TIES	(CPG_MFS09_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS09_I2C_SMRS_RIES	(CPG_MFS09_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS09_I2C_SMRS_WUCRS	(CPG_MFS09_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS10_I2C_SMRS	(CPG_MFS10_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_SMRS_TIES	(CPG_MFS10_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS10_I2C_SMRS_RIES	(CPG_MFS10_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS10_I2C_SMRS_WUCRS	(CPG_MFS10_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS11_I2C_SMRS	(CPG_MFS11_I2C.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_SMRS_TIES	(CPG_MFS11_I2C.unSMRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS11_I2C_SMRS_RIES	(CPG_MFS11_I2C.unSMRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS11_I2C_SMRS_WUCRS	(CPG_MFS11_I2C.unSMRS.stcField.u1WUCRS)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_smrs_field{
    uint_io8_t		:2;
    uint_io8_t		u1TIES:1;
    uint_io8_t		u1RIES:1;
    uint_io8_t		u1WUCRS:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_smrs_field_t;

typedef union un_cpg_mfsn_i2c_smrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_smrs_field_t		stcField;
}un_cpg_mfsn_i2c_smrs_t;

/* IBCRS */
#define CPG_MFS00_I2C_IBCRS	(CPG_MFS00_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_IBCRS_INTS	(CPG_MFS00_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRS_INTES	(CPG_MFS00_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRS_CNDES	(CPG_MFS00_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRS_WSELS	(CPG_MFS00_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRS_ACKES	(CPG_MFS00_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRS_ACTS	(CPG_MFS00_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS00_I2C_IBCRS_MSSS	(CPG_MFS00_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS01_I2C_IBCRS	(CPG_MFS01_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_IBCRS_INTS	(CPG_MFS01_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRS_INTES	(CPG_MFS01_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRS_CNDES	(CPG_MFS01_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRS_WSELS	(CPG_MFS01_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRS_ACKES	(CPG_MFS01_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRS_ACTS	(CPG_MFS01_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS01_I2C_IBCRS_MSSS	(CPG_MFS01_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS02_I2C_IBCRS	(CPG_MFS02_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_IBCRS_INTS	(CPG_MFS02_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRS_INTES	(CPG_MFS02_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRS_CNDES	(CPG_MFS02_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRS_WSELS	(CPG_MFS02_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRS_ACKES	(CPG_MFS02_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRS_ACTS	(CPG_MFS02_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS02_I2C_IBCRS_MSSS	(CPG_MFS02_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS03_I2C_IBCRS	(CPG_MFS03_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_IBCRS_INTS	(CPG_MFS03_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRS_INTES	(CPG_MFS03_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRS_CNDES	(CPG_MFS03_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRS_WSELS	(CPG_MFS03_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRS_ACKES	(CPG_MFS03_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRS_ACTS	(CPG_MFS03_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS03_I2C_IBCRS_MSSS	(CPG_MFS03_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS04_I2C_IBCRS	(CPG_MFS04_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_IBCRS_INTS	(CPG_MFS04_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRS_INTES	(CPG_MFS04_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRS_CNDES	(CPG_MFS04_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRS_WSELS	(CPG_MFS04_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRS_ACKES	(CPG_MFS04_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRS_ACTS	(CPG_MFS04_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS04_I2C_IBCRS_MSSS	(CPG_MFS04_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS05_I2C_IBCRS	(CPG_MFS05_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_IBCRS_INTS	(CPG_MFS05_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRS_INTES	(CPG_MFS05_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRS_CNDES	(CPG_MFS05_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRS_WSELS	(CPG_MFS05_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRS_ACKES	(CPG_MFS05_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRS_ACTS	(CPG_MFS05_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS05_I2C_IBCRS_MSSS	(CPG_MFS05_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS06_I2C_IBCRS	(CPG_MFS06_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_IBCRS_INTS	(CPG_MFS06_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRS_INTES	(CPG_MFS06_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRS_CNDES	(CPG_MFS06_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRS_WSELS	(CPG_MFS06_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRS_ACKES	(CPG_MFS06_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRS_ACTS	(CPG_MFS06_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS06_I2C_IBCRS_MSSS	(CPG_MFS06_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS07_I2C_IBCRS	(CPG_MFS07_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_IBCRS_INTS	(CPG_MFS07_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRS_INTES	(CPG_MFS07_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRS_CNDES	(CPG_MFS07_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRS_WSELS	(CPG_MFS07_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRS_ACKES	(CPG_MFS07_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRS_ACTS	(CPG_MFS07_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS07_I2C_IBCRS_MSSS	(CPG_MFS07_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS08_I2C_IBCRS	(CPG_MFS08_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_IBCRS_INTS	(CPG_MFS08_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRS_INTES	(CPG_MFS08_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRS_CNDES	(CPG_MFS08_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRS_WSELS	(CPG_MFS08_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRS_ACKES	(CPG_MFS08_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRS_ACTS	(CPG_MFS08_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS08_I2C_IBCRS_MSSS	(CPG_MFS08_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS09_I2C_IBCRS	(CPG_MFS09_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_IBCRS_INTS	(CPG_MFS09_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRS_INTES	(CPG_MFS09_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRS_CNDES	(CPG_MFS09_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRS_WSELS	(CPG_MFS09_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRS_ACKES	(CPG_MFS09_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRS_ACTS	(CPG_MFS09_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS09_I2C_IBCRS_MSSS	(CPG_MFS09_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS10_I2C_IBCRS	(CPG_MFS10_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_IBCRS_INTS	(CPG_MFS10_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRS_INTES	(CPG_MFS10_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRS_CNDES	(CPG_MFS10_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRS_WSELS	(CPG_MFS10_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRS_ACKES	(CPG_MFS10_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRS_ACTS	(CPG_MFS10_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS10_I2C_IBCRS_MSSS	(CPG_MFS10_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

#define CPG_MFS11_I2C_IBCRS	(CPG_MFS11_I2C.unIBCRS.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_IBCRS_INTS	(CPG_MFS11_I2C.unIBCRS.stcField.u1INTS)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRS_INTES	(CPG_MFS11_I2C.unIBCRS.stcField.u1INTES)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRS_CNDES	(CPG_MFS11_I2C.unIBCRS.stcField.u1CNDES)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRS_WSELS	(CPG_MFS11_I2C.unIBCRS.stcField.u1WSELS)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRS_ACKES	(CPG_MFS11_I2C.unIBCRS.stcField.u1ACKES)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRS_ACTS	(CPG_MFS11_I2C.unIBCRS.stcField.u1ACTS)  /*@bf@*/
#define CPG_MFS11_I2C_IBCRS_MSSS	(CPG_MFS11_I2C.unIBCRS.stcField.u1MSSS)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ibcrs_field{
    uint_io8_t		u1INTS:1;
    uint_io8_t		:1;
    uint_io8_t		u1INTES:1;
    uint_io8_t		u1CNDES:1;
    uint_io8_t		u1WSELS:1;
    uint_io8_t		u1ACKES:1;
    uint_io8_t		u1ACTS:1;
    uint_io8_t		u1MSSS:1;
}stc_cpg_mfsn_i2c_ibcrs_field_t;

typedef union un_cpg_mfsn_i2c_ibcrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ibcrs_field_t		stcField;
}un_cpg_mfsn_i2c_ibcrs_t;

/* SSRS */
#define CPG_MFS00_I2C_SSRS	(CPG_MFS00_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_SSRS_TBIES	(CPG_MFS00_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS00_I2C_SSRS_DMAS	(CPG_MFS00_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS00_I2C_SSRS_TSETS	(CPG_MFS00_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS00_I2C_SSRS_RECS	(CPG_MFS00_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS01_I2C_SSRS	(CPG_MFS01_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_SSRS_TBIES	(CPG_MFS01_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS01_I2C_SSRS_DMAS	(CPG_MFS01_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS01_I2C_SSRS_TSETS	(CPG_MFS01_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS01_I2C_SSRS_RECS	(CPG_MFS01_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS02_I2C_SSRS	(CPG_MFS02_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_SSRS_TBIES	(CPG_MFS02_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS02_I2C_SSRS_DMAS	(CPG_MFS02_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS02_I2C_SSRS_TSETS	(CPG_MFS02_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS02_I2C_SSRS_RECS	(CPG_MFS02_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS03_I2C_SSRS	(CPG_MFS03_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_SSRS_TBIES	(CPG_MFS03_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS03_I2C_SSRS_DMAS	(CPG_MFS03_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS03_I2C_SSRS_TSETS	(CPG_MFS03_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS03_I2C_SSRS_RECS	(CPG_MFS03_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS04_I2C_SSRS	(CPG_MFS04_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_SSRS_TBIES	(CPG_MFS04_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS04_I2C_SSRS_DMAS	(CPG_MFS04_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS04_I2C_SSRS_TSETS	(CPG_MFS04_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS04_I2C_SSRS_RECS	(CPG_MFS04_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS05_I2C_SSRS	(CPG_MFS05_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_SSRS_TBIES	(CPG_MFS05_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS05_I2C_SSRS_DMAS	(CPG_MFS05_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS05_I2C_SSRS_TSETS	(CPG_MFS05_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS05_I2C_SSRS_RECS	(CPG_MFS05_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS06_I2C_SSRS	(CPG_MFS06_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_SSRS_TBIES	(CPG_MFS06_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS06_I2C_SSRS_DMAS	(CPG_MFS06_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS06_I2C_SSRS_TSETS	(CPG_MFS06_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS06_I2C_SSRS_RECS	(CPG_MFS06_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS07_I2C_SSRS	(CPG_MFS07_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_SSRS_TBIES	(CPG_MFS07_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS07_I2C_SSRS_DMAS	(CPG_MFS07_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS07_I2C_SSRS_TSETS	(CPG_MFS07_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS07_I2C_SSRS_RECS	(CPG_MFS07_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS08_I2C_SSRS	(CPG_MFS08_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_SSRS_TBIES	(CPG_MFS08_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS08_I2C_SSRS_DMAS	(CPG_MFS08_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS08_I2C_SSRS_TSETS	(CPG_MFS08_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS08_I2C_SSRS_RECS	(CPG_MFS08_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS09_I2C_SSRS	(CPG_MFS09_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_SSRS_TBIES	(CPG_MFS09_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS09_I2C_SSRS_DMAS	(CPG_MFS09_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS09_I2C_SSRS_TSETS	(CPG_MFS09_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS09_I2C_SSRS_RECS	(CPG_MFS09_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS10_I2C_SSRS	(CPG_MFS10_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_SSRS_TBIES	(CPG_MFS10_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS10_I2C_SSRS_DMAS	(CPG_MFS10_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS10_I2C_SSRS_TSETS	(CPG_MFS10_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS10_I2C_SSRS_RECS	(CPG_MFS10_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS11_I2C_SSRS	(CPG_MFS11_I2C.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_SSRS_TBIES	(CPG_MFS11_I2C.unSSRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS11_I2C_SSRS_DMAS	(CPG_MFS11_I2C.unSSRS.stcField.u1DMAS)  /*@bf@*/
#define CPG_MFS11_I2C_SSRS_TSETS	(CPG_MFS11_I2C.unSSRS.stcField.u1TSETS)  /*@bf@*/
#define CPG_MFS11_I2C_SSRS_RECS	(CPG_MFS11_I2C.unSSRS.stcField.u1RECS)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_ssrs_field{
    uint_io8_t		:4;
    uint_io8_t		u1TBIES:1;
    uint_io8_t		u1DMAS:1;
    uint_io8_t		u1TSETS:1;
    uint_io8_t		u1RECS:1;
}stc_cpg_mfsn_i2c_ssrs_field_t;

typedef union un_cpg_mfsn_i2c_ssrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_ssrs_field_t		stcField;
}un_cpg_mfsn_i2c_ssrs_t;

/* SACSRS */
#define CPG_MFS00_I2C_SACSRS	(CPG_MFS00_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS00_I2C_SACSRS_TMRES	(CPG_MFS00_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS00_I2C_SACSRS_TRGES	(CPG_MFS00_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS00_I2C_SACSRS_TINTES	(CPG_MFS00_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS01_I2C_SACSRS	(CPG_MFS01_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS01_I2C_SACSRS_TMRES	(CPG_MFS01_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS01_I2C_SACSRS_TRGES	(CPG_MFS01_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS01_I2C_SACSRS_TINTES	(CPG_MFS01_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS02_I2C_SACSRS	(CPG_MFS02_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS02_I2C_SACSRS_TMRES	(CPG_MFS02_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS02_I2C_SACSRS_TRGES	(CPG_MFS02_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS02_I2C_SACSRS_TINTES	(CPG_MFS02_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS03_I2C_SACSRS	(CPG_MFS03_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS03_I2C_SACSRS_TMRES	(CPG_MFS03_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS03_I2C_SACSRS_TRGES	(CPG_MFS03_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS03_I2C_SACSRS_TINTES	(CPG_MFS03_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS04_I2C_SACSRS	(CPG_MFS04_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS04_I2C_SACSRS_TMRES	(CPG_MFS04_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS04_I2C_SACSRS_TRGES	(CPG_MFS04_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS04_I2C_SACSRS_TINTES	(CPG_MFS04_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS05_I2C_SACSRS	(CPG_MFS05_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS05_I2C_SACSRS_TMRES	(CPG_MFS05_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS05_I2C_SACSRS_TRGES	(CPG_MFS05_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS05_I2C_SACSRS_TINTES	(CPG_MFS05_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS06_I2C_SACSRS	(CPG_MFS06_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS06_I2C_SACSRS_TMRES	(CPG_MFS06_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS06_I2C_SACSRS_TRGES	(CPG_MFS06_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS06_I2C_SACSRS_TINTES	(CPG_MFS06_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS07_I2C_SACSRS	(CPG_MFS07_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS07_I2C_SACSRS_TMRES	(CPG_MFS07_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS07_I2C_SACSRS_TRGES	(CPG_MFS07_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS07_I2C_SACSRS_TINTES	(CPG_MFS07_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS08_I2C_SACSRS	(CPG_MFS08_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS08_I2C_SACSRS_TMRES	(CPG_MFS08_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS08_I2C_SACSRS_TRGES	(CPG_MFS08_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS08_I2C_SACSRS_TINTES	(CPG_MFS08_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS09_I2C_SACSRS	(CPG_MFS09_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS09_I2C_SACSRS_TMRES	(CPG_MFS09_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS09_I2C_SACSRS_TRGES	(CPG_MFS09_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS09_I2C_SACSRS_TINTES	(CPG_MFS09_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS10_I2C_SACSRS	(CPG_MFS10_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS10_I2C_SACSRS_TMRES	(CPG_MFS10_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS10_I2C_SACSRS_TRGES	(CPG_MFS10_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS10_I2C_SACSRS_TINTES	(CPG_MFS10_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

#define CPG_MFS11_I2C_SACSRS	(CPG_MFS11_I2C.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS11_I2C_SACSRS_TMRES	(CPG_MFS11_I2C.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS11_I2C_SACSRS_TRGES	(CPG_MFS11_I2C.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS11_I2C_SACSRS_TINTES	(CPG_MFS11_I2C.unSACSRS.stcField.u1TINTES)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_sacsrs_field{
    uint_io16_t		u1TMRES:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGES:1;
    uint_io16_t		:1;
    uint_io16_t		u1TINTES:1;
    uint_io16_t		:8;
}stc_cpg_mfsn_i2c_sacsrs_field_t;

typedef union un_cpg_mfsn_i2c_sacsrs{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_i2c_sacsrs_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_i2c_sacsrs_t;

/* FCR0S */
#define CPG_MFS00_I2C_FCR0S	(CPG_MFS00_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_FCR0S_FE1S	(CPG_MFS00_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0S_FE2S	(CPG_MFS00_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0S_FCL1S	(CPG_MFS00_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0S_FCL2S	(CPG_MFS00_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0S_FSETS	(CPG_MFS00_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS00_I2C_FCR0S_FLDS	(CPG_MFS00_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS01_I2C_FCR0S	(CPG_MFS01_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_FCR0S_FE1S	(CPG_MFS01_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0S_FE2S	(CPG_MFS01_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0S_FCL1S	(CPG_MFS01_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0S_FCL2S	(CPG_MFS01_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0S_FSETS	(CPG_MFS01_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS01_I2C_FCR0S_FLDS	(CPG_MFS01_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS02_I2C_FCR0S	(CPG_MFS02_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_FCR0S_FE1S	(CPG_MFS02_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0S_FE2S	(CPG_MFS02_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0S_FCL1S	(CPG_MFS02_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0S_FCL2S	(CPG_MFS02_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0S_FSETS	(CPG_MFS02_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS02_I2C_FCR0S_FLDS	(CPG_MFS02_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS03_I2C_FCR0S	(CPG_MFS03_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_FCR0S_FE1S	(CPG_MFS03_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0S_FE2S	(CPG_MFS03_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0S_FCL1S	(CPG_MFS03_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0S_FCL2S	(CPG_MFS03_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0S_FSETS	(CPG_MFS03_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS03_I2C_FCR0S_FLDS	(CPG_MFS03_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS04_I2C_FCR0S	(CPG_MFS04_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_FCR0S_FE1S	(CPG_MFS04_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0S_FE2S	(CPG_MFS04_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0S_FCL1S	(CPG_MFS04_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0S_FCL2S	(CPG_MFS04_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0S_FSETS	(CPG_MFS04_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS04_I2C_FCR0S_FLDS	(CPG_MFS04_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS05_I2C_FCR0S	(CPG_MFS05_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_FCR0S_FE1S	(CPG_MFS05_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0S_FE2S	(CPG_MFS05_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0S_FCL1S	(CPG_MFS05_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0S_FCL2S	(CPG_MFS05_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0S_FSETS	(CPG_MFS05_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS05_I2C_FCR0S_FLDS	(CPG_MFS05_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS06_I2C_FCR0S	(CPG_MFS06_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_FCR0S_FE1S	(CPG_MFS06_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0S_FE2S	(CPG_MFS06_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0S_FCL1S	(CPG_MFS06_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0S_FCL2S	(CPG_MFS06_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0S_FSETS	(CPG_MFS06_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS06_I2C_FCR0S_FLDS	(CPG_MFS06_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS07_I2C_FCR0S	(CPG_MFS07_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_FCR0S_FE1S	(CPG_MFS07_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0S_FE2S	(CPG_MFS07_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0S_FCL1S	(CPG_MFS07_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0S_FCL2S	(CPG_MFS07_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0S_FSETS	(CPG_MFS07_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS07_I2C_FCR0S_FLDS	(CPG_MFS07_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS08_I2C_FCR0S	(CPG_MFS08_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_FCR0S_FE1S	(CPG_MFS08_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0S_FE2S	(CPG_MFS08_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0S_FCL1S	(CPG_MFS08_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0S_FCL2S	(CPG_MFS08_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0S_FSETS	(CPG_MFS08_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS08_I2C_FCR0S_FLDS	(CPG_MFS08_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS09_I2C_FCR0S	(CPG_MFS09_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_FCR0S_FE1S	(CPG_MFS09_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0S_FE2S	(CPG_MFS09_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0S_FCL1S	(CPG_MFS09_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0S_FCL2S	(CPG_MFS09_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0S_FSETS	(CPG_MFS09_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS09_I2C_FCR0S_FLDS	(CPG_MFS09_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS10_I2C_FCR0S	(CPG_MFS10_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_FCR0S_FE1S	(CPG_MFS10_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0S_FE2S	(CPG_MFS10_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0S_FCL1S	(CPG_MFS10_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0S_FCL2S	(CPG_MFS10_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0S_FSETS	(CPG_MFS10_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS10_I2C_FCR0S_FLDS	(CPG_MFS10_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS11_I2C_FCR0S	(CPG_MFS11_I2C.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_FCR0S_FE1S	(CPG_MFS11_I2C.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0S_FE2S	(CPG_MFS11_I2C.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0S_FCL1S	(CPG_MFS11_I2C.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0S_FCL2S	(CPG_MFS11_I2C.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0S_FSETS	(CPG_MFS11_I2C.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS11_I2C_FCR0S_FLDS	(CPG_MFS11_I2C.unFCR0S.stcField.u1FLDS)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_fcr0s_field{
    uint_io8_t		u1FE1S:1;
    uint_io8_t		u1FE2S:1;
    uint_io8_t		u1FCL1S:1;
    uint_io8_t		u1FCL2S:1;
    uint_io8_t		u1FSETS:1;
    uint_io8_t		u1FLDS:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_i2c_fcr0s_field_t;

typedef union un_cpg_mfsn_i2c_fcr0s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_fcr0s_field_t		stcField;
}un_cpg_mfsn_i2c_fcr0s_t;

/* FCR1S */
#define CPG_MFS00_I2C_FCR1S	(CPG_MFS00_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS00_I2C_FCR1S_FSELS	(CPG_MFS00_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1S_FTIES	(CPG_MFS00_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1S_FRIIES	(CPG_MFS00_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS00_I2C_FCR1S_FLSTES	(CPG_MFS00_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS01_I2C_FCR1S	(CPG_MFS01_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS01_I2C_FCR1S_FSELS	(CPG_MFS01_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1S_FTIES	(CPG_MFS01_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1S_FRIIES	(CPG_MFS01_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS01_I2C_FCR1S_FLSTES	(CPG_MFS01_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS02_I2C_FCR1S	(CPG_MFS02_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS02_I2C_FCR1S_FSELS	(CPG_MFS02_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1S_FTIES	(CPG_MFS02_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1S_FRIIES	(CPG_MFS02_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS02_I2C_FCR1S_FLSTES	(CPG_MFS02_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS03_I2C_FCR1S	(CPG_MFS03_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS03_I2C_FCR1S_FSELS	(CPG_MFS03_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1S_FTIES	(CPG_MFS03_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1S_FRIIES	(CPG_MFS03_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS03_I2C_FCR1S_FLSTES	(CPG_MFS03_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS04_I2C_FCR1S	(CPG_MFS04_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS04_I2C_FCR1S_FSELS	(CPG_MFS04_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1S_FTIES	(CPG_MFS04_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1S_FRIIES	(CPG_MFS04_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS04_I2C_FCR1S_FLSTES	(CPG_MFS04_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS05_I2C_FCR1S	(CPG_MFS05_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS05_I2C_FCR1S_FSELS	(CPG_MFS05_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1S_FTIES	(CPG_MFS05_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1S_FRIIES	(CPG_MFS05_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS05_I2C_FCR1S_FLSTES	(CPG_MFS05_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS06_I2C_FCR1S	(CPG_MFS06_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS06_I2C_FCR1S_FSELS	(CPG_MFS06_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1S_FTIES	(CPG_MFS06_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1S_FRIIES	(CPG_MFS06_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS06_I2C_FCR1S_FLSTES	(CPG_MFS06_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS07_I2C_FCR1S	(CPG_MFS07_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS07_I2C_FCR1S_FSELS	(CPG_MFS07_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1S_FTIES	(CPG_MFS07_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1S_FRIIES	(CPG_MFS07_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS07_I2C_FCR1S_FLSTES	(CPG_MFS07_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS08_I2C_FCR1S	(CPG_MFS08_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS08_I2C_FCR1S_FSELS	(CPG_MFS08_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1S_FTIES	(CPG_MFS08_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1S_FRIIES	(CPG_MFS08_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS08_I2C_FCR1S_FLSTES	(CPG_MFS08_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS09_I2C_FCR1S	(CPG_MFS09_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS09_I2C_FCR1S_FSELS	(CPG_MFS09_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1S_FTIES	(CPG_MFS09_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1S_FRIIES	(CPG_MFS09_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS09_I2C_FCR1S_FLSTES	(CPG_MFS09_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS10_I2C_FCR1S	(CPG_MFS10_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS10_I2C_FCR1S_FSELS	(CPG_MFS10_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1S_FTIES	(CPG_MFS10_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1S_FRIIES	(CPG_MFS10_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS10_I2C_FCR1S_FLSTES	(CPG_MFS10_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS11_I2C_FCR1S	(CPG_MFS11_I2C.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS11_I2C_FCR1S_FSELS	(CPG_MFS11_I2C.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1S_FTIES	(CPG_MFS11_I2C.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1S_FRIIES	(CPG_MFS11_I2C.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS11_I2C_FCR1S_FLSTES	(CPG_MFS11_I2C.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

typedef struct stc_cpg_mfsn_i2c_fcr1s_field{
    uint_io8_t		u1FSELS:1;
    uint_io8_t		u1FTIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1FRIIES:1;
    uint_io8_t		u1FLSTES:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_i2c_fcr1s_field_t;

typedef union un_cpg_mfsn_i2c_fcr1s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_i2c_fcr1s_field_t		stcField;
}un_cpg_mfsn_i2c_fcr1s_t;


typedef struct stc_cpg_mfsn_i2c{
    un_cpg_mfsn_i2c_smr_t	unSMR;	/* 0x00000000 */
    un_cpg_mfsn_i2c_ibcr_t	unIBCR;	/* 0x00000001 */
    un_cpg_mfsn_i2c_ibsr_t	unIBSR;	/* 0x00000002 */
    un_cpg_mfsn_i2c_ssr_t	unSSR;	/* 0x00000003 */
    un_cpg_mfsn_i2c_rdr_t	unRDR;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[3];	/* 0x00000005 */
    un_cpg_mfsn_i2c_sacsr_t	unSACSR;	/* 0x00000008 */
    un_cpg_mfsn_i2c_stmr_t	unSTMR;	/* 0x0000000A */
    un_cpg_mfsn_i2c_stmcr_t	unSTMCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved1[2];	/* 0x0000000E */
    un_cpg_mfsn_i2c_nfcr_t	unNFCR;	/* 0x00000010 */
    un_cpg_mfsn_i2c_eibcr_t	unEIBCR;	/* 0x00000011 */
    uint_io8_t	au8Reserved2[10];	/* 0x00000012 */
    un_cpg_mfsn_i2c_bgr_t	unBGR;	/* 0x0000001C */
    un_cpg_mfsn_i2c_isba_t	unISBA;	/* 0x0000001E */
    un_cpg_mfsn_i2c_ismk_t	unISMK;	/* 0x0000001F */
    un_cpg_mfsn_i2c_fcr0_t	unFCR0;	/* 0x00000020 */
    un_cpg_mfsn_i2c_fcr1_t	unFCR1;	/* 0x00000021 */
    un_cpg_mfsn_i2c_fbyte_t	unFBYTE;	/* 0x00000022 */
    un_cpg_mfsn_i2c_fticr_t	unFTICR;	/* 0x00000024 */
    un_cpg_mfsn_i2c_ecr_t	unECR;	/* 0x00000026 */
    un_cpg_mfsn_i2c_esr_t	unESR;	/* 0x00000027 */
    un_cpg_mfsn_i2c_tbsize_t	unTBSIZE;	/* 0x00000028 */
    uint_io8_t	au8Reserved3[3];	/* 0x00000029 */
    un_cpg_mfsn_i2c_smrc_t	unSMRC;	/* 0x0000002C */
    un_cpg_mfsn_i2c_ibcrc_t	unIBCRC;	/* 0x0000002D */
    un_cpg_mfsn_i2c_ibsrc_t	unIBSRC;	/* 0x0000002E */
    un_cpg_mfsn_i2c_ssrc_t	unSSRC;	/* 0x0000002F */
    un_cpg_mfsn_i2c_sacsrc_t	unSACSRC;	/* 0x00000030 */
    uint_io8_t	au8Reserved4[10];	/* 0x00000032 */
    un_cpg_mfsn_i2c_fcr0c_t	unFCR0C;	/* 0x0000003C */
    un_cpg_mfsn_i2c_fcr1c_t	unFCR1C;	/* 0x0000003D */
    uint_io8_t	au8Reserved5[5];	/* 0x0000003E */
    un_cpg_mfsn_i2c_esrc_t	unESRC;	/* 0x00000043 */
    un_cpg_mfsn_i2c_smrs_t	unSMRS;	/* 0x00000044 */
    un_cpg_mfsn_i2c_ibcrs_t	unIBCRS;	/* 0x00000045 */
    uint_io8_t	au8Reserved6[1];	/* 0x00000046 */
    un_cpg_mfsn_i2c_ssrs_t	unSSRS;	/* 0x00000047 */
    un_cpg_mfsn_i2c_sacsrs_t	unSACSRS;	/* 0x00000048 */
    uint_io8_t	au8Reserved7[10];	/* 0x0000004A */
    un_cpg_mfsn_i2c_fcr0s_t	unFCR0S;	/* 0x00000054 */
    un_cpg_mfsn_i2c_fcr1s_t	unFCR1S;	/* 0x00000055 */
    uint_io8_t	au8Reserved8[938];	/* 0x00000056 */
}stc_cpg_mfsn_i2c_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cpg_mfsn_i2c_t	stcCPG_MFS_I2C[12];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_MFS_I2C_H */
