/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_OCU_H
#define __S6J3360_OCU_H

#include "s6j3360io_basetypes.h"

/* OCU[00-02/08-10] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define OCU00	stcOCU[0]
#define OCU01	stcOCU[1]
#define OCU02	stcOCU[2]
#define OCU08	stcOCU[3]
#define OCU09	stcOCU[4]
#define OCU10	stcOCU[5]
#else /* __IO_DEFINE */
#define OCU00	(*((volatile stc_ocun_t*)0xB4830000))
#define OCU01	(*((volatile stc_ocun_t*)0xB4830400))
#define OCU02	(*((volatile stc_ocun_t*)0xB4830800))
#define OCU08	(*((volatile stc_ocun_t*)0xB48B0000))
#define OCU09	(*((volatile stc_ocun_t*)0xB48B0400))
#define OCU10	(*((volatile stc_ocun_t*)0xB48B0800))
#endif /* __IO_DEFINE */

/* OCCPB[0/1] */
#define OCU00_OCCPB0	(OCU00.unOCCPB0.u32Register)  /*@rg@*/
#define OCU00_OCCP0	(OCU00_OCCPB0)  /*@rg2@*/
#define OCU00_OCCPB0_OP	OCU00_OCCPB0  /*@bfrg@*/
#define OCU00_OCCP0_OP	OCU00_OCCPB0_OP  /*@bf2@*/

#define OCU00_OCCPB1	(OCU00.unOCCPB1.u32Register)  /*@rg@*/
#define OCU00_OCCP1	(OCU00_OCCPB1)  /*@rg2@*/
#define OCU00_OCCPB1_OP	OCU00_OCCPB1  /*@bfrg@*/
#define OCU00_OCCP1_OP	OCU00_OCCPB1_OP  /*@bf2@*/

#define OCU01_OCCPB0	(OCU01.unOCCPB0.u32Register)  /*@rg@*/
#define OCU01_OCCP0	(OCU01_OCCPB0)  /*@rg2@*/
#define OCU01_OCCPB0_OP	OCU01_OCCPB0  /*@bfrg@*/
#define OCU01_OCCP0_OP	OCU01_OCCPB0_OP  /*@bf2@*/

#define OCU01_OCCPB1	(OCU01.unOCCPB1.u32Register)  /*@rg@*/
#define OCU01_OCCP1	(OCU01_OCCPB1)  /*@rg2@*/
#define OCU01_OCCPB1_OP	OCU01_OCCPB1  /*@bfrg@*/
#define OCU01_OCCP1_OP	OCU01_OCCPB1_OP  /*@bf2@*/

#define OCU02_OCCPB0	(OCU02.unOCCPB0.u32Register)  /*@rg@*/
#define OCU02_OCCP0	(OCU02_OCCPB0)  /*@rg2@*/
#define OCU02_OCCPB0_OP	OCU02_OCCPB0  /*@bfrg@*/
#define OCU02_OCCP0_OP	OCU02_OCCPB0_OP  /*@bf2@*/

#define OCU02_OCCPB1	(OCU02.unOCCPB1.u32Register)  /*@rg@*/
#define OCU02_OCCP1	(OCU02_OCCPB1)  /*@rg2@*/
#define OCU02_OCCPB1_OP	OCU02_OCCPB1  /*@bfrg@*/
#define OCU02_OCCP1_OP	OCU02_OCCPB1_OP  /*@bf2@*/

#define OCU08_OCCPB0	(OCU08.unOCCPB0.u32Register)  /*@rg@*/
#define OCU08_OCCP0	(OCU08_OCCPB0)  /*@rg2@*/
#define OCU08_OCCPB0_OP	OCU08_OCCPB0  /*@bfrg@*/
#define OCU08_OCCP0_OP	OCU08_OCCPB0_OP  /*@bf2@*/

#define OCU08_OCCPB1	(OCU08.unOCCPB1.u32Register)  /*@rg@*/
#define OCU08_OCCP1	(OCU08_OCCPB1)  /*@rg2@*/
#define OCU08_OCCPB1_OP	OCU08_OCCPB1  /*@bfrg@*/
#define OCU08_OCCP1_OP	OCU08_OCCPB1_OP  /*@bf2@*/

#define OCU09_OCCPB0	(OCU09.unOCCPB0.u32Register)  /*@rg@*/
#define OCU09_OCCP0	(OCU09_OCCPB0)  /*@rg2@*/
#define OCU09_OCCPB0_OP	OCU09_OCCPB0  /*@bfrg@*/
#define OCU09_OCCP0_OP	OCU09_OCCPB0_OP  /*@bf2@*/

#define OCU09_OCCPB1	(OCU09.unOCCPB1.u32Register)  /*@rg@*/
#define OCU09_OCCP1	(OCU09_OCCPB1)  /*@rg2@*/
#define OCU09_OCCPB1_OP	OCU09_OCCPB1  /*@bfrg@*/
#define OCU09_OCCP1_OP	OCU09_OCCPB1_OP  /*@bf2@*/

#define OCU10_OCCPB0	(OCU10.unOCCPB0.u32Register)  /*@rg@*/
#define OCU10_OCCP0	(OCU10_OCCPB0)  /*@rg2@*/
#define OCU10_OCCPB0_OP	OCU10_OCCPB0  /*@bfrg@*/
#define OCU10_OCCP0_OP	OCU10_OCCPB0_OP  /*@bf2@*/

#define OCU10_OCCPB1	(OCU10.unOCCPB1.u32Register)  /*@rg@*/
#define OCU10_OCCP1	(OCU10_OCCPB1)  /*@rg2@*/
#define OCU10_OCCPB1_OP	OCU10_OCCPB1  /*@bfrg@*/
#define OCU10_OCCP1_OP	OCU10_OCCPB1_OP  /*@bf2@*/

typedef union un_ocun_occpbn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ocun_occpbn_t;

/* OCS */
#define OCU00_OCS	(OCU00.unOCS.u32Register)  /*@rg@*/
#define OCU00_OCS_CST0	(OCU00.unOCS.stcField.u1CST0)  /*@bf@*/
#define OCU00_OCS_CST1	(OCU00.unOCS.stcField.u1CST1)  /*@bf@*/
#define OCU00_OCS_BUF0	(OCU00.unOCS.stcField.u1BUF0)  /*@bf@*/
#define OCU00_OCS_BUF1	(OCU00.unOCS.stcField.u1BUF1)  /*@bf@*/
#define OCU00_OCS_IOE0	(OCU00.unOCS.stcField.u1IOE0)  /*@bf@*/
#define OCU00_OCS_IOE1	(OCU00.unOCS.stcField.u1IOE1)  /*@bf@*/
#define OCU00_OCS_IOP0	(OCU00.unOCS.stcField.u1IOP0)  /*@bf@*/
#define OCU00_OCS_IOP1	(OCU00.unOCS.stcField.u1IOP1)  /*@bf@*/
#define OCU00_OCS_OTD0	(OCU00.unOCS.stcField.u1OTD0)  /*@bf@*/
#define OCU00_OCS_OTD1	(OCU00.unOCS.stcField.u1OTD1)  /*@bf@*/
#define OCU00_OCS_CMOD	(OCU00.unOCS.stcField.u1CMOD)  /*@bf@*/
#define OCU00_OCS_BTS0	(OCU00.unOCS.stcField.u1BTS0)  /*@bf@*/
#define OCU00_OCS_BTS1	(OCU00.unOCS.stcField.u1BTS1)  /*@bf@*/

#define OCU01_OCS	(OCU01.unOCS.u32Register)  /*@rg@*/
#define OCU01_OCS_CST0	(OCU01.unOCS.stcField.u1CST0)  /*@bf@*/
#define OCU01_OCS_CST1	(OCU01.unOCS.stcField.u1CST1)  /*@bf@*/
#define OCU01_OCS_BUF0	(OCU01.unOCS.stcField.u1BUF0)  /*@bf@*/
#define OCU01_OCS_BUF1	(OCU01.unOCS.stcField.u1BUF1)  /*@bf@*/
#define OCU01_OCS_IOE0	(OCU01.unOCS.stcField.u1IOE0)  /*@bf@*/
#define OCU01_OCS_IOE1	(OCU01.unOCS.stcField.u1IOE1)  /*@bf@*/
#define OCU01_OCS_IOP0	(OCU01.unOCS.stcField.u1IOP0)  /*@bf@*/
#define OCU01_OCS_IOP1	(OCU01.unOCS.stcField.u1IOP1)  /*@bf@*/
#define OCU01_OCS_OTD0	(OCU01.unOCS.stcField.u1OTD0)  /*@bf@*/
#define OCU01_OCS_OTD1	(OCU01.unOCS.stcField.u1OTD1)  /*@bf@*/
#define OCU01_OCS_CMOD	(OCU01.unOCS.stcField.u1CMOD)  /*@bf@*/
#define OCU01_OCS_BTS0	(OCU01.unOCS.stcField.u1BTS0)  /*@bf@*/
#define OCU01_OCS_BTS1	(OCU01.unOCS.stcField.u1BTS1)  /*@bf@*/

#define OCU02_OCS	(OCU02.unOCS.u32Register)  /*@rg@*/
#define OCU02_OCS_CST0	(OCU02.unOCS.stcField.u1CST0)  /*@bf@*/
#define OCU02_OCS_CST1	(OCU02.unOCS.stcField.u1CST1)  /*@bf@*/
#define OCU02_OCS_BUF0	(OCU02.unOCS.stcField.u1BUF0)  /*@bf@*/
#define OCU02_OCS_BUF1	(OCU02.unOCS.stcField.u1BUF1)  /*@bf@*/
#define OCU02_OCS_IOE0	(OCU02.unOCS.stcField.u1IOE0)  /*@bf@*/
#define OCU02_OCS_IOE1	(OCU02.unOCS.stcField.u1IOE1)  /*@bf@*/
#define OCU02_OCS_IOP0	(OCU02.unOCS.stcField.u1IOP0)  /*@bf@*/
#define OCU02_OCS_IOP1	(OCU02.unOCS.stcField.u1IOP1)  /*@bf@*/
#define OCU02_OCS_OTD0	(OCU02.unOCS.stcField.u1OTD0)  /*@bf@*/
#define OCU02_OCS_OTD1	(OCU02.unOCS.stcField.u1OTD1)  /*@bf@*/
#define OCU02_OCS_CMOD	(OCU02.unOCS.stcField.u1CMOD)  /*@bf@*/
#define OCU02_OCS_BTS0	(OCU02.unOCS.stcField.u1BTS0)  /*@bf@*/
#define OCU02_OCS_BTS1	(OCU02.unOCS.stcField.u1BTS1)  /*@bf@*/

#define OCU08_OCS	(OCU08.unOCS.u32Register)  /*@rg@*/
#define OCU08_OCS_CST0	(OCU08.unOCS.stcField.u1CST0)  /*@bf@*/
#define OCU08_OCS_CST1	(OCU08.unOCS.stcField.u1CST1)  /*@bf@*/
#define OCU08_OCS_BUF0	(OCU08.unOCS.stcField.u1BUF0)  /*@bf@*/
#define OCU08_OCS_BUF1	(OCU08.unOCS.stcField.u1BUF1)  /*@bf@*/
#define OCU08_OCS_IOE0	(OCU08.unOCS.stcField.u1IOE0)  /*@bf@*/
#define OCU08_OCS_IOE1	(OCU08.unOCS.stcField.u1IOE1)  /*@bf@*/
#define OCU08_OCS_IOP0	(OCU08.unOCS.stcField.u1IOP0)  /*@bf@*/
#define OCU08_OCS_IOP1	(OCU08.unOCS.stcField.u1IOP1)  /*@bf@*/
#define OCU08_OCS_OTD0	(OCU08.unOCS.stcField.u1OTD0)  /*@bf@*/
#define OCU08_OCS_OTD1	(OCU08.unOCS.stcField.u1OTD1)  /*@bf@*/
#define OCU08_OCS_CMOD	(OCU08.unOCS.stcField.u1CMOD)  /*@bf@*/
#define OCU08_OCS_BTS0	(OCU08.unOCS.stcField.u1BTS0)  /*@bf@*/
#define OCU08_OCS_BTS1	(OCU08.unOCS.stcField.u1BTS1)  /*@bf@*/

#define OCU09_OCS	(OCU09.unOCS.u32Register)  /*@rg@*/
#define OCU09_OCS_CST0	(OCU09.unOCS.stcField.u1CST0)  /*@bf@*/
#define OCU09_OCS_CST1	(OCU09.unOCS.stcField.u1CST1)  /*@bf@*/
#define OCU09_OCS_BUF0	(OCU09.unOCS.stcField.u1BUF0)  /*@bf@*/
#define OCU09_OCS_BUF1	(OCU09.unOCS.stcField.u1BUF1)  /*@bf@*/
#define OCU09_OCS_IOE0	(OCU09.unOCS.stcField.u1IOE0)  /*@bf@*/
#define OCU09_OCS_IOE1	(OCU09.unOCS.stcField.u1IOE1)  /*@bf@*/
#define OCU09_OCS_IOP0	(OCU09.unOCS.stcField.u1IOP0)  /*@bf@*/
#define OCU09_OCS_IOP1	(OCU09.unOCS.stcField.u1IOP1)  /*@bf@*/
#define OCU09_OCS_OTD0	(OCU09.unOCS.stcField.u1OTD0)  /*@bf@*/
#define OCU09_OCS_OTD1	(OCU09.unOCS.stcField.u1OTD1)  /*@bf@*/
#define OCU09_OCS_CMOD	(OCU09.unOCS.stcField.u1CMOD)  /*@bf@*/
#define OCU09_OCS_BTS0	(OCU09.unOCS.stcField.u1BTS0)  /*@bf@*/
#define OCU09_OCS_BTS1	(OCU09.unOCS.stcField.u1BTS1)  /*@bf@*/

#define OCU10_OCS	(OCU10.unOCS.u32Register)  /*@rg@*/
#define OCU10_OCS_CST0	(OCU10.unOCS.stcField.u1CST0)  /*@bf@*/
#define OCU10_OCS_CST1	(OCU10.unOCS.stcField.u1CST1)  /*@bf@*/
#define OCU10_OCS_BUF0	(OCU10.unOCS.stcField.u1BUF0)  /*@bf@*/
#define OCU10_OCS_BUF1	(OCU10.unOCS.stcField.u1BUF1)  /*@bf@*/
#define OCU10_OCS_IOE0	(OCU10.unOCS.stcField.u1IOE0)  /*@bf@*/
#define OCU10_OCS_IOE1	(OCU10.unOCS.stcField.u1IOE1)  /*@bf@*/
#define OCU10_OCS_IOP0	(OCU10.unOCS.stcField.u1IOP0)  /*@bf@*/
#define OCU10_OCS_IOP1	(OCU10.unOCS.stcField.u1IOP1)  /*@bf@*/
#define OCU10_OCS_OTD0	(OCU10.unOCS.stcField.u1OTD0)  /*@bf@*/
#define OCU10_OCS_OTD1	(OCU10.unOCS.stcField.u1OTD1)  /*@bf@*/
#define OCU10_OCS_CMOD	(OCU10.unOCS.stcField.u1CMOD)  /*@bf@*/
#define OCU10_OCS_BTS0	(OCU10.unOCS.stcField.u1BTS0)  /*@bf@*/
#define OCU10_OCS_BTS1	(OCU10.unOCS.stcField.u1BTS1)  /*@bf@*/

typedef struct stc_ocun_ocs_field{
    uint_io32_t		u1CST0:1;
    uint_io32_t		u1CST1:1;
    uint_io32_t		u1BUF0:1;
    uint_io32_t		u1BUF1:1;
    uint_io32_t		u1IOE0:1;
    uint_io32_t		u1IOE1:1;
    uint_io32_t		u1IOP0:1;
    uint_io32_t		u1IOP1:1;
    uint_io32_t		u1OTD0:1;
    uint_io32_t		u1OTD1:1;
    uint_io32_t		:2;
    uint_io32_t		u1CMOD:1;
    uint_io32_t		u1BTS0:1;
    uint_io32_t		u1BTS1:1;
    uint_io32_t		:17;
}stc_ocun_ocs_field_t;

typedef union un_ocun_ocs{
    uint_io32_t		u32Register;
    stc_ocun_ocs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ocun_ocs_t;

/* OCSC */
#define OCU00_OCSC	(OCU00.unOCSC.u32Register)  /*@rg@*/
#define OCU00_OCSC_CST0C	(OCU00.unOCSC.stcField.u1CST0C)  /*@bf@*/
#define OCU00_OCSC_CST1C	(OCU00.unOCSC.stcField.u1CST1C)  /*@bf@*/
#define OCU00_OCSC_BUF0C	(OCU00.unOCSC.stcField.u1BUF0C)  /*@bf@*/
#define OCU00_OCSC_BUF1C	(OCU00.unOCSC.stcField.u1BUF1C)  /*@bf@*/
#define OCU00_OCSC_IOE0C	(OCU00.unOCSC.stcField.u1IOE0C)  /*@bf@*/
#define OCU00_OCSC_IOE1C	(OCU00.unOCSC.stcField.u1IOE1C)  /*@bf@*/
#define OCU00_OCSC_IOP0C	(OCU00.unOCSC.stcField.u1IOP0C)  /*@bf@*/
#define OCU00_OCSC_IOP1C	(OCU00.unOCSC.stcField.u1IOP1C)  /*@bf@*/
#define OCU00_OCSC_OTD0C	(OCU00.unOCSC.stcField.u1OTD0C)  /*@bf@*/
#define OCU00_OCSC_OTD1C	(OCU00.unOCSC.stcField.u1OTD1C)  /*@bf@*/
#define OCU00_OCSC_CMODC	(OCU00.unOCSC.stcField.u1CMODC)  /*@bf@*/
#define OCU00_OCSC_BTS0C	(OCU00.unOCSC.stcField.u1BTS0C)  /*@bf@*/
#define OCU00_OCSC_BTS1C	(OCU00.unOCSC.stcField.u1BTS1C)  /*@bf@*/

#define OCU01_OCSC	(OCU01.unOCSC.u32Register)  /*@rg@*/
#define OCU01_OCSC_CST0C	(OCU01.unOCSC.stcField.u1CST0C)  /*@bf@*/
#define OCU01_OCSC_CST1C	(OCU01.unOCSC.stcField.u1CST1C)  /*@bf@*/
#define OCU01_OCSC_BUF0C	(OCU01.unOCSC.stcField.u1BUF0C)  /*@bf@*/
#define OCU01_OCSC_BUF1C	(OCU01.unOCSC.stcField.u1BUF1C)  /*@bf@*/
#define OCU01_OCSC_IOE0C	(OCU01.unOCSC.stcField.u1IOE0C)  /*@bf@*/
#define OCU01_OCSC_IOE1C	(OCU01.unOCSC.stcField.u1IOE1C)  /*@bf@*/
#define OCU01_OCSC_IOP0C	(OCU01.unOCSC.stcField.u1IOP0C)  /*@bf@*/
#define OCU01_OCSC_IOP1C	(OCU01.unOCSC.stcField.u1IOP1C)  /*@bf@*/
#define OCU01_OCSC_OTD0C	(OCU01.unOCSC.stcField.u1OTD0C)  /*@bf@*/
#define OCU01_OCSC_OTD1C	(OCU01.unOCSC.stcField.u1OTD1C)  /*@bf@*/
#define OCU01_OCSC_CMODC	(OCU01.unOCSC.stcField.u1CMODC)  /*@bf@*/
#define OCU01_OCSC_BTS0C	(OCU01.unOCSC.stcField.u1BTS0C)  /*@bf@*/
#define OCU01_OCSC_BTS1C	(OCU01.unOCSC.stcField.u1BTS1C)  /*@bf@*/

#define OCU02_OCSC	(OCU02.unOCSC.u32Register)  /*@rg@*/
#define OCU02_OCSC_CST0C	(OCU02.unOCSC.stcField.u1CST0C)  /*@bf@*/
#define OCU02_OCSC_CST1C	(OCU02.unOCSC.stcField.u1CST1C)  /*@bf@*/
#define OCU02_OCSC_BUF0C	(OCU02.unOCSC.stcField.u1BUF0C)  /*@bf@*/
#define OCU02_OCSC_BUF1C	(OCU02.unOCSC.stcField.u1BUF1C)  /*@bf@*/
#define OCU02_OCSC_IOE0C	(OCU02.unOCSC.stcField.u1IOE0C)  /*@bf@*/
#define OCU02_OCSC_IOE1C	(OCU02.unOCSC.stcField.u1IOE1C)  /*@bf@*/
#define OCU02_OCSC_IOP0C	(OCU02.unOCSC.stcField.u1IOP0C)  /*@bf@*/
#define OCU02_OCSC_IOP1C	(OCU02.unOCSC.stcField.u1IOP1C)  /*@bf@*/
#define OCU02_OCSC_OTD0C	(OCU02.unOCSC.stcField.u1OTD0C)  /*@bf@*/
#define OCU02_OCSC_OTD1C	(OCU02.unOCSC.stcField.u1OTD1C)  /*@bf@*/
#define OCU02_OCSC_CMODC	(OCU02.unOCSC.stcField.u1CMODC)  /*@bf@*/
#define OCU02_OCSC_BTS0C	(OCU02.unOCSC.stcField.u1BTS0C)  /*@bf@*/
#define OCU02_OCSC_BTS1C	(OCU02.unOCSC.stcField.u1BTS1C)  /*@bf@*/

#define OCU08_OCSC	(OCU08.unOCSC.u32Register)  /*@rg@*/
#define OCU08_OCSC_CST0C	(OCU08.unOCSC.stcField.u1CST0C)  /*@bf@*/
#define OCU08_OCSC_CST1C	(OCU08.unOCSC.stcField.u1CST1C)  /*@bf@*/
#define OCU08_OCSC_BUF0C	(OCU08.unOCSC.stcField.u1BUF0C)  /*@bf@*/
#define OCU08_OCSC_BUF1C	(OCU08.unOCSC.stcField.u1BUF1C)  /*@bf@*/
#define OCU08_OCSC_IOE0C	(OCU08.unOCSC.stcField.u1IOE0C)  /*@bf@*/
#define OCU08_OCSC_IOE1C	(OCU08.unOCSC.stcField.u1IOE1C)  /*@bf@*/
#define OCU08_OCSC_IOP0C	(OCU08.unOCSC.stcField.u1IOP0C)  /*@bf@*/
#define OCU08_OCSC_IOP1C	(OCU08.unOCSC.stcField.u1IOP1C)  /*@bf@*/
#define OCU08_OCSC_OTD0C	(OCU08.unOCSC.stcField.u1OTD0C)  /*@bf@*/
#define OCU08_OCSC_OTD1C	(OCU08.unOCSC.stcField.u1OTD1C)  /*@bf@*/
#define OCU08_OCSC_CMODC	(OCU08.unOCSC.stcField.u1CMODC)  /*@bf@*/
#define OCU08_OCSC_BTS0C	(OCU08.unOCSC.stcField.u1BTS0C)  /*@bf@*/
#define OCU08_OCSC_BTS1C	(OCU08.unOCSC.stcField.u1BTS1C)  /*@bf@*/

#define OCU09_OCSC	(OCU09.unOCSC.u32Register)  /*@rg@*/
#define OCU09_OCSC_CST0C	(OCU09.unOCSC.stcField.u1CST0C)  /*@bf@*/
#define OCU09_OCSC_CST1C	(OCU09.unOCSC.stcField.u1CST1C)  /*@bf@*/
#define OCU09_OCSC_BUF0C	(OCU09.unOCSC.stcField.u1BUF0C)  /*@bf@*/
#define OCU09_OCSC_BUF1C	(OCU09.unOCSC.stcField.u1BUF1C)  /*@bf@*/
#define OCU09_OCSC_IOE0C	(OCU09.unOCSC.stcField.u1IOE0C)  /*@bf@*/
#define OCU09_OCSC_IOE1C	(OCU09.unOCSC.stcField.u1IOE1C)  /*@bf@*/
#define OCU09_OCSC_IOP0C	(OCU09.unOCSC.stcField.u1IOP0C)  /*@bf@*/
#define OCU09_OCSC_IOP1C	(OCU09.unOCSC.stcField.u1IOP1C)  /*@bf@*/
#define OCU09_OCSC_OTD0C	(OCU09.unOCSC.stcField.u1OTD0C)  /*@bf@*/
#define OCU09_OCSC_OTD1C	(OCU09.unOCSC.stcField.u1OTD1C)  /*@bf@*/
#define OCU09_OCSC_CMODC	(OCU09.unOCSC.stcField.u1CMODC)  /*@bf@*/
#define OCU09_OCSC_BTS0C	(OCU09.unOCSC.stcField.u1BTS0C)  /*@bf@*/
#define OCU09_OCSC_BTS1C	(OCU09.unOCSC.stcField.u1BTS1C)  /*@bf@*/

#define OCU10_OCSC	(OCU10.unOCSC.u32Register)  /*@rg@*/
#define OCU10_OCSC_CST0C	(OCU10.unOCSC.stcField.u1CST0C)  /*@bf@*/
#define OCU10_OCSC_CST1C	(OCU10.unOCSC.stcField.u1CST1C)  /*@bf@*/
#define OCU10_OCSC_BUF0C	(OCU10.unOCSC.stcField.u1BUF0C)  /*@bf@*/
#define OCU10_OCSC_BUF1C	(OCU10.unOCSC.stcField.u1BUF1C)  /*@bf@*/
#define OCU10_OCSC_IOE0C	(OCU10.unOCSC.stcField.u1IOE0C)  /*@bf@*/
#define OCU10_OCSC_IOE1C	(OCU10.unOCSC.stcField.u1IOE1C)  /*@bf@*/
#define OCU10_OCSC_IOP0C	(OCU10.unOCSC.stcField.u1IOP0C)  /*@bf@*/
#define OCU10_OCSC_IOP1C	(OCU10.unOCSC.stcField.u1IOP1C)  /*@bf@*/
#define OCU10_OCSC_OTD0C	(OCU10.unOCSC.stcField.u1OTD0C)  /*@bf@*/
#define OCU10_OCSC_OTD1C	(OCU10.unOCSC.stcField.u1OTD1C)  /*@bf@*/
#define OCU10_OCSC_CMODC	(OCU10.unOCSC.stcField.u1CMODC)  /*@bf@*/
#define OCU10_OCSC_BTS0C	(OCU10.unOCSC.stcField.u1BTS0C)  /*@bf@*/
#define OCU10_OCSC_BTS1C	(OCU10.unOCSC.stcField.u1BTS1C)  /*@bf@*/

typedef struct stc_ocun_ocsc_field{
    uint_io32_t		u1CST0C:1;
    uint_io32_t		u1CST1C:1;
    uint_io32_t		u1BUF0C:1;
    uint_io32_t		u1BUF1C:1;
    uint_io32_t		u1IOE0C:1;
    uint_io32_t		u1IOE1C:1;
    uint_io32_t		u1IOP0C:1;
    uint_io32_t		u1IOP1C:1;
    uint_io32_t		u1OTD0C:1;
    uint_io32_t		u1OTD1C:1;
    uint_io32_t		:2;
    uint_io32_t		u1CMODC:1;
    uint_io32_t		u1BTS0C:1;
    uint_io32_t		u1BTS1C:1;
    uint_io32_t		:17;
}stc_ocun_ocsc_field_t;

typedef union un_ocun_ocsc{
    uint_io32_t		u32Register;
    stc_ocun_ocsc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ocun_ocsc_t;

/* OCSS */
#define OCU00_OCSS	(OCU00.unOCSS.u32Register)  /*@rg@*/
#define OCU00_OCSS_CST0S	(OCU00.unOCSS.stcField.u1CST0S)  /*@bf@*/
#define OCU00_OCSS_CST1S	(OCU00.unOCSS.stcField.u1CST1S)  /*@bf@*/
#define OCU00_OCSS_BUF0S	(OCU00.unOCSS.stcField.u1BUF0S)  /*@bf@*/
#define OCU00_OCSS_BUF1S	(OCU00.unOCSS.stcField.u1BUF1S)  /*@bf@*/
#define OCU00_OCSS_IOE0S	(OCU00.unOCSS.stcField.u1IOE0S)  /*@bf@*/
#define OCU00_OCSS_IOE1S	(OCU00.unOCSS.stcField.u1IOE1S)  /*@bf@*/
#define OCU00_OCSS_OTD0S	(OCU00.unOCSS.stcField.u1OTD0S)  /*@bf@*/
#define OCU00_OCSS_OTD1S	(OCU00.unOCSS.stcField.u1OTD1S)  /*@bf@*/
#define OCU00_OCSS_CMODS	(OCU00.unOCSS.stcField.u1CMODS)  /*@bf@*/
#define OCU00_OCSS_BTS0S	(OCU00.unOCSS.stcField.u1BTS0S)  /*@bf@*/
#define OCU00_OCSS_BTS1S	(OCU00.unOCSS.stcField.u1BTS1S)  /*@bf@*/

#define OCU01_OCSS	(OCU01.unOCSS.u32Register)  /*@rg@*/
#define OCU01_OCSS_CST0S	(OCU01.unOCSS.stcField.u1CST0S)  /*@bf@*/
#define OCU01_OCSS_CST1S	(OCU01.unOCSS.stcField.u1CST1S)  /*@bf@*/
#define OCU01_OCSS_BUF0S	(OCU01.unOCSS.stcField.u1BUF0S)  /*@bf@*/
#define OCU01_OCSS_BUF1S	(OCU01.unOCSS.stcField.u1BUF1S)  /*@bf@*/
#define OCU01_OCSS_IOE0S	(OCU01.unOCSS.stcField.u1IOE0S)  /*@bf@*/
#define OCU01_OCSS_IOE1S	(OCU01.unOCSS.stcField.u1IOE1S)  /*@bf@*/
#define OCU01_OCSS_OTD0S	(OCU01.unOCSS.stcField.u1OTD0S)  /*@bf@*/
#define OCU01_OCSS_OTD1S	(OCU01.unOCSS.stcField.u1OTD1S)  /*@bf@*/
#define OCU01_OCSS_CMODS	(OCU01.unOCSS.stcField.u1CMODS)  /*@bf@*/
#define OCU01_OCSS_BTS0S	(OCU01.unOCSS.stcField.u1BTS0S)  /*@bf@*/
#define OCU01_OCSS_BTS1S	(OCU01.unOCSS.stcField.u1BTS1S)  /*@bf@*/

#define OCU02_OCSS	(OCU02.unOCSS.u32Register)  /*@rg@*/
#define OCU02_OCSS_CST0S	(OCU02.unOCSS.stcField.u1CST0S)  /*@bf@*/
#define OCU02_OCSS_CST1S	(OCU02.unOCSS.stcField.u1CST1S)  /*@bf@*/
#define OCU02_OCSS_BUF0S	(OCU02.unOCSS.stcField.u1BUF0S)  /*@bf@*/
#define OCU02_OCSS_BUF1S	(OCU02.unOCSS.stcField.u1BUF1S)  /*@bf@*/
#define OCU02_OCSS_IOE0S	(OCU02.unOCSS.stcField.u1IOE0S)  /*@bf@*/
#define OCU02_OCSS_IOE1S	(OCU02.unOCSS.stcField.u1IOE1S)  /*@bf@*/
#define OCU02_OCSS_OTD0S	(OCU02.unOCSS.stcField.u1OTD0S)  /*@bf@*/
#define OCU02_OCSS_OTD1S	(OCU02.unOCSS.stcField.u1OTD1S)  /*@bf@*/
#define OCU02_OCSS_CMODS	(OCU02.unOCSS.stcField.u1CMODS)  /*@bf@*/
#define OCU02_OCSS_BTS0S	(OCU02.unOCSS.stcField.u1BTS0S)  /*@bf@*/
#define OCU02_OCSS_BTS1S	(OCU02.unOCSS.stcField.u1BTS1S)  /*@bf@*/

#define OCU08_OCSS	(OCU08.unOCSS.u32Register)  /*@rg@*/
#define OCU08_OCSS_CST0S	(OCU08.unOCSS.stcField.u1CST0S)  /*@bf@*/
#define OCU08_OCSS_CST1S	(OCU08.unOCSS.stcField.u1CST1S)  /*@bf@*/
#define OCU08_OCSS_BUF0S	(OCU08.unOCSS.stcField.u1BUF0S)  /*@bf@*/
#define OCU08_OCSS_BUF1S	(OCU08.unOCSS.stcField.u1BUF1S)  /*@bf@*/
#define OCU08_OCSS_IOE0S	(OCU08.unOCSS.stcField.u1IOE0S)  /*@bf@*/
#define OCU08_OCSS_IOE1S	(OCU08.unOCSS.stcField.u1IOE1S)  /*@bf@*/
#define OCU08_OCSS_OTD0S	(OCU08.unOCSS.stcField.u1OTD0S)  /*@bf@*/
#define OCU08_OCSS_OTD1S	(OCU08.unOCSS.stcField.u1OTD1S)  /*@bf@*/
#define OCU08_OCSS_CMODS	(OCU08.unOCSS.stcField.u1CMODS)  /*@bf@*/
#define OCU08_OCSS_BTS0S	(OCU08.unOCSS.stcField.u1BTS0S)  /*@bf@*/
#define OCU08_OCSS_BTS1S	(OCU08.unOCSS.stcField.u1BTS1S)  /*@bf@*/

#define OCU09_OCSS	(OCU09.unOCSS.u32Register)  /*@rg@*/
#define OCU09_OCSS_CST0S	(OCU09.unOCSS.stcField.u1CST0S)  /*@bf@*/
#define OCU09_OCSS_CST1S	(OCU09.unOCSS.stcField.u1CST1S)  /*@bf@*/
#define OCU09_OCSS_BUF0S	(OCU09.unOCSS.stcField.u1BUF0S)  /*@bf@*/
#define OCU09_OCSS_BUF1S	(OCU09.unOCSS.stcField.u1BUF1S)  /*@bf@*/
#define OCU09_OCSS_IOE0S	(OCU09.unOCSS.stcField.u1IOE0S)  /*@bf@*/
#define OCU09_OCSS_IOE1S	(OCU09.unOCSS.stcField.u1IOE1S)  /*@bf@*/
#define OCU09_OCSS_OTD0S	(OCU09.unOCSS.stcField.u1OTD0S)  /*@bf@*/
#define OCU09_OCSS_OTD1S	(OCU09.unOCSS.stcField.u1OTD1S)  /*@bf@*/
#define OCU09_OCSS_CMODS	(OCU09.unOCSS.stcField.u1CMODS)  /*@bf@*/
#define OCU09_OCSS_BTS0S	(OCU09.unOCSS.stcField.u1BTS0S)  /*@bf@*/
#define OCU09_OCSS_BTS1S	(OCU09.unOCSS.stcField.u1BTS1S)  /*@bf@*/

#define OCU10_OCSS	(OCU10.unOCSS.u32Register)  /*@rg@*/
#define OCU10_OCSS_CST0S	(OCU10.unOCSS.stcField.u1CST0S)  /*@bf@*/
#define OCU10_OCSS_CST1S	(OCU10.unOCSS.stcField.u1CST1S)  /*@bf@*/
#define OCU10_OCSS_BUF0S	(OCU10.unOCSS.stcField.u1BUF0S)  /*@bf@*/
#define OCU10_OCSS_BUF1S	(OCU10.unOCSS.stcField.u1BUF1S)  /*@bf@*/
#define OCU10_OCSS_IOE0S	(OCU10.unOCSS.stcField.u1IOE0S)  /*@bf@*/
#define OCU10_OCSS_IOE1S	(OCU10.unOCSS.stcField.u1IOE1S)  /*@bf@*/
#define OCU10_OCSS_OTD0S	(OCU10.unOCSS.stcField.u1OTD0S)  /*@bf@*/
#define OCU10_OCSS_OTD1S	(OCU10.unOCSS.stcField.u1OTD1S)  /*@bf@*/
#define OCU10_OCSS_CMODS	(OCU10.unOCSS.stcField.u1CMODS)  /*@bf@*/
#define OCU10_OCSS_BTS0S	(OCU10.unOCSS.stcField.u1BTS0S)  /*@bf@*/
#define OCU10_OCSS_BTS1S	(OCU10.unOCSS.stcField.u1BTS1S)  /*@bf@*/

typedef struct stc_ocun_ocss_field{
    uint_io32_t		u1CST0S:1;
    uint_io32_t		u1CST1S:1;
    uint_io32_t		u1BUF0S:1;
    uint_io32_t		u1BUF1S:1;
    uint_io32_t		u1IOE0S:1;
    uint_io32_t		u1IOE1S:1;
    uint_io32_t		:2;
    uint_io32_t		u1OTD0S:1;
    uint_io32_t		u1OTD1S:1;
    uint_io32_t		:2;
    uint_io32_t		u1CMODS:1;
    uint_io32_t		u1BTS0S:1;
    uint_io32_t		u1BTS1S:1;
    uint_io32_t		:17;
}stc_ocun_ocss_field_t;

typedef union un_ocun_ocss{
    uint_io32_t		u32Register;
    stc_ocun_ocss_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ocun_ocss_t;


typedef struct stc_ocun{
    un_ocun_occpbn_t	unOCCPB0;	/* 0x00000000 */
    un_ocun_occpbn_t	unOCCPB1;	/* 0x00000004 */
    un_ocun_ocs_t	unOCS;	/* 0x00000008 */
    un_ocun_ocsc_t	unOCSC;	/* 0x0000000C */
    un_ocun_ocss_t	unOCSS;	/* 0x00000010 */
    uint_io8_t	au8Reserved0[1004];	/* 0x00000014 */
}stc_ocun_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_ocun_t	stcOCU[6];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_OCU_H */
