/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_PPU_H
#define __S6J3360_PPU_H

#include "s6j3360io_basetypes.h"

/* PPU0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define PPU0	stcPPU0
#else /* __IO_DEFINE */
#define PPU0	(*((volatile stc_ppu0_t*)0xB4750000))
#endif /* __IO_DEFINE */

/* CR */
#define PPU0_CR	(PPU0.unCR.u32Register)  /*@rg@*/
#define PPU0_CR_FPQCLR	(PPU0.unCR.stcField.u1FPQCLR)  /*@bf@*/
#define PPU0_CR_FPQSET	(PPU0.unCR.stcField.u1FPQSET)  /*@bf@*/
#define PPU0_CR_VCLR	(PPU0.unCR.stcField.u1VCLR)  /*@bf@*/
#define PPU0_CR_MODE	(PPU0.unCR.stcField.u1MODE)  /*@bf@*/

typedef struct stc_ppu0_cr_field{
    uint_io32_t		:8;
    uint_io32_t		u1FPQCLR:1;
    uint_io32_t		u1FPQSET:1;
    uint_io32_t		:13;
    uint_io32_t		u1VCLR:1;
    uint_io32_t		:5;
    uint_io32_t		u1MODE:1;
    uint_io32_t		:2;
}stc_ppu0_cr_field_t;

typedef union un_ppu0_cr{
    uint_io32_t		u32Register;
    stc_ppu0_cr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_cr_t;

/* SR */
#define PPU0_SR	(PPU0.unSR.u32Register)  /*@rg@*/
#define PPU0_SR_LST	(PPU0.unSR.stcField.u1LST)  /*@bf@*/
#define PPU0_SR_VL	(PPU0.unSR.stcField.u5VL)  /*@bf@*/
#define PPU0_SR_VW	(PPU0.unSR.stcField.u1VW)  /*@bf@*/
#define PPU0_SR_VP	(PPU0.unSR.stcField.u1VP)  /*@bf@*/
#define PPU0_SR_VD	(PPU0.unSR.stcField.u1VD)  /*@bf@*/

typedef struct stc_ppu0_sr_field{
    uint_io32_t		u1LST:1;
    uint_io32_t		:15;
    uint_io32_t		u5VL:5;
    uint_io32_t		u1VW:1;
    uint_io32_t		u1VP:1;
    uint_io32_t		u1VD:1;
    uint_io32_t		:8;
}stc_ppu0_sr_field_t;

typedef union un_ppu0_sr{
    uint_io32_t		u32Register;
    stc_ppu0_sr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_sr_t;

/* UNLOCK */
#define PPU0_UNLOCK	(PPU0.unUNLOCK.u32Register)  /*@rg@*/
#define PPU0_UNLOCK_UL	PPU0_UNLOCK  /*@bfrg@*/

typedef union un_ppu0_unlock{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_unlock_t;

/* WPQCLR */
#define PPU0_WPQCLR	(PPU0.unWPQCLR.u32Register)  /*@rg@*/
#define PPU0_WPQCLR_WPQCLR	(PPU0.unWPQCLR.stcField.u1WPQCLR)  /*@bf@*/

typedef struct stc_ppu0_wpqclr_field{
    uint_io32_t		u1WPQCLR:1;
    uint_io32_t		:31;
}stc_ppu0_wpqclr_field_t;

typedef union un_ppu0_wpqclr{
    uint_io32_t		u32Register;
    stc_ppu0_wpqclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_wpqclr_t;

/* WUQCLR */
#define PPU0_WUQCLR	(PPU0.unWUQCLR.u32Register)  /*@rg@*/
#define PPU0_WUQCLR_WUQCLR	(PPU0.unWUQCLR.stcField.u1WUQCLR)  /*@bf@*/

typedef struct stc_ppu0_wuqclr_field{
    uint_io32_t		u1WUQCLR:1;
    uint_io32_t		:31;
}stc_ppu0_wuqclr_field_t;

typedef union un_ppu0_wuqclr{
    uint_io32_t		u32Register;
    stc_ppu0_wuqclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_wuqclr_t;

/* RPQCLR */
#define PPU0_RPQCLR	(PPU0.unRPQCLR.u32Register)  /*@rg@*/
#define PPU0_RPQCLR_RPQCLR	(PPU0.unRPQCLR.stcField.u1RPQCLR)  /*@bf@*/

typedef struct stc_ppu0_rpqclr_field{
    uint_io32_t		u1RPQCLR:1;
    uint_io32_t		:31;
}stc_ppu0_rpqclr_field_t;

typedef union un_ppu0_rpqclr{
    uint_io32_t		u32Register;
    stc_ppu0_rpqclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_rpqclr_t;

/* RUQCLR */
#define PPU0_RUQCLR	(PPU0.unRUQCLR.u32Register)  /*@rg@*/
#define PPU0_RUQCLR_RUQCLR	(PPU0.unRUQCLR.stcField.u1RUQCLR)  /*@bf@*/

typedef struct stc_ppu0_ruqclr_field{
    uint_io32_t		u1RUQCLR:1;
    uint_io32_t		:31;
}stc_ppu0_ruqclr_field_t;

typedef union un_ppu0_ruqclr{
    uint_io32_t		u32Register;
    stc_ppu0_ruqclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_ruqclr_t;

/* PPR[0-29] */
#define PPU0_PPR0	(PPU0.unPPR0.u32Register)  /*@rg@*/
#define PPU0_PPR0_PPR0	(PPU0.unPPR0.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR0_PPR1	(PPU0.unPPR0.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR0_PPR2	(PPU0.unPPR0.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR0_PPR3	(PPU0.unPPR0.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR0_PPR4	(PPU0.unPPR0.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR0_PPR5	(PPU0.unPPR0.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR0_PPR6	(PPU0.unPPR0.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR0_PPR7	(PPU0.unPPR0.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR0_PPR8	(PPU0.unPPR0.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR0_PPR9	(PPU0.unPPR0.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR0_PPR10	(PPU0.unPPR0.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR0_PPR11	(PPU0.unPPR0.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR0_PPR12	(PPU0.unPPR0.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR0_PPR13	(PPU0.unPPR0.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR0_PPR14	(PPU0.unPPR0.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR0_PPR15	(PPU0.unPPR0.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR0_PPR16	(PPU0.unPPR0.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR0_PPR17	(PPU0.unPPR0.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR0_PPR18	(PPU0.unPPR0.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR0_PPR19	(PPU0.unPPR0.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR0_PPR20	(PPU0.unPPR0.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR0_PPR21	(PPU0.unPPR0.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR0_PPR22	(PPU0.unPPR0.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR0_PPR23	(PPU0.unPPR0.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR0_PPR24	(PPU0.unPPR0.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR0_PPR25	(PPU0.unPPR0.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR0_PPR26	(PPU0.unPPR0.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR0_PPR27	(PPU0.unPPR0.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR0_PPR28	(PPU0.unPPR0.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR0_PPR29	(PPU0.unPPR0.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR0_PPR30	(PPU0.unPPR0.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR0_PPR31	(PPU0.unPPR0.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR1	(PPU0.unPPR1.u32Register)  /*@rg@*/
#define PPU0_PPR1_PPR0	(PPU0.unPPR1.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR1_PPR1	(PPU0.unPPR1.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR1_PPR2	(PPU0.unPPR1.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR1_PPR3	(PPU0.unPPR1.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR1_PPR4	(PPU0.unPPR1.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR1_PPR5	(PPU0.unPPR1.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR1_PPR6	(PPU0.unPPR1.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR1_PPR7	(PPU0.unPPR1.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR1_PPR8	(PPU0.unPPR1.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR1_PPR9	(PPU0.unPPR1.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR1_PPR10	(PPU0.unPPR1.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR1_PPR11	(PPU0.unPPR1.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR1_PPR12	(PPU0.unPPR1.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR1_PPR13	(PPU0.unPPR1.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR1_PPR14	(PPU0.unPPR1.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR1_PPR15	(PPU0.unPPR1.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR1_PPR16	(PPU0.unPPR1.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR1_PPR17	(PPU0.unPPR1.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR1_PPR18	(PPU0.unPPR1.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR1_PPR19	(PPU0.unPPR1.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR1_PPR20	(PPU0.unPPR1.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR1_PPR21	(PPU0.unPPR1.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR1_PPR22	(PPU0.unPPR1.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR1_PPR23	(PPU0.unPPR1.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR1_PPR24	(PPU0.unPPR1.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR1_PPR25	(PPU0.unPPR1.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR1_PPR26	(PPU0.unPPR1.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR1_PPR27	(PPU0.unPPR1.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR1_PPR28	(PPU0.unPPR1.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR1_PPR29	(PPU0.unPPR1.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR1_PPR30	(PPU0.unPPR1.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR1_PPR31	(PPU0.unPPR1.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR2	(PPU0.unPPR2.u32Register)  /*@rg@*/
#define PPU0_PPR2_PPR0	(PPU0.unPPR2.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR2_PPR1	(PPU0.unPPR2.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR2_PPR2	(PPU0.unPPR2.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR2_PPR3	(PPU0.unPPR2.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR2_PPR4	(PPU0.unPPR2.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR2_PPR5	(PPU0.unPPR2.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR2_PPR6	(PPU0.unPPR2.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR2_PPR7	(PPU0.unPPR2.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR2_PPR8	(PPU0.unPPR2.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR2_PPR9	(PPU0.unPPR2.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR2_PPR10	(PPU0.unPPR2.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR2_PPR11	(PPU0.unPPR2.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR2_PPR12	(PPU0.unPPR2.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR2_PPR13	(PPU0.unPPR2.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR2_PPR14	(PPU0.unPPR2.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR2_PPR15	(PPU0.unPPR2.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR2_PPR16	(PPU0.unPPR2.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR2_PPR17	(PPU0.unPPR2.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR2_PPR18	(PPU0.unPPR2.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR2_PPR19	(PPU0.unPPR2.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR2_PPR20	(PPU0.unPPR2.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR2_PPR21	(PPU0.unPPR2.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR2_PPR22	(PPU0.unPPR2.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR2_PPR23	(PPU0.unPPR2.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR2_PPR24	(PPU0.unPPR2.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR2_PPR25	(PPU0.unPPR2.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR2_PPR26	(PPU0.unPPR2.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR2_PPR27	(PPU0.unPPR2.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR2_PPR28	(PPU0.unPPR2.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR2_PPR29	(PPU0.unPPR2.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR2_PPR30	(PPU0.unPPR2.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR2_PPR31	(PPU0.unPPR2.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR3	(PPU0.unPPR3.u32Register)  /*@rg@*/
#define PPU0_PPR3_PPR0	(PPU0.unPPR3.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR3_PPR1	(PPU0.unPPR3.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR3_PPR2	(PPU0.unPPR3.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR3_PPR3	(PPU0.unPPR3.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR3_PPR4	(PPU0.unPPR3.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR3_PPR5	(PPU0.unPPR3.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR3_PPR6	(PPU0.unPPR3.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR3_PPR7	(PPU0.unPPR3.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR3_PPR8	(PPU0.unPPR3.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR3_PPR9	(PPU0.unPPR3.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR3_PPR10	(PPU0.unPPR3.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR3_PPR11	(PPU0.unPPR3.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR3_PPR12	(PPU0.unPPR3.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR3_PPR13	(PPU0.unPPR3.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR3_PPR14	(PPU0.unPPR3.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR3_PPR15	(PPU0.unPPR3.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR3_PPR16	(PPU0.unPPR3.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR3_PPR17	(PPU0.unPPR3.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR3_PPR18	(PPU0.unPPR3.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR3_PPR19	(PPU0.unPPR3.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR3_PPR20	(PPU0.unPPR3.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR3_PPR21	(PPU0.unPPR3.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR3_PPR22	(PPU0.unPPR3.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR3_PPR23	(PPU0.unPPR3.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR3_PPR24	(PPU0.unPPR3.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR3_PPR25	(PPU0.unPPR3.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR3_PPR26	(PPU0.unPPR3.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR3_PPR27	(PPU0.unPPR3.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR3_PPR28	(PPU0.unPPR3.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR3_PPR29	(PPU0.unPPR3.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR3_PPR30	(PPU0.unPPR3.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR3_PPR31	(PPU0.unPPR3.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR4	(PPU0.unPPR4.u32Register)  /*@rg@*/
#define PPU0_PPR4_PPR0	(PPU0.unPPR4.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR4_PPR1	(PPU0.unPPR4.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR4_PPR2	(PPU0.unPPR4.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR4_PPR3	(PPU0.unPPR4.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR4_PPR4	(PPU0.unPPR4.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR4_PPR5	(PPU0.unPPR4.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR4_PPR6	(PPU0.unPPR4.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR4_PPR7	(PPU0.unPPR4.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR4_PPR8	(PPU0.unPPR4.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR4_PPR9	(PPU0.unPPR4.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR4_PPR10	(PPU0.unPPR4.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR4_PPR11	(PPU0.unPPR4.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR4_PPR12	(PPU0.unPPR4.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR4_PPR13	(PPU0.unPPR4.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR4_PPR14	(PPU0.unPPR4.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR4_PPR15	(PPU0.unPPR4.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR4_PPR16	(PPU0.unPPR4.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR4_PPR17	(PPU0.unPPR4.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR4_PPR18	(PPU0.unPPR4.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR4_PPR19	(PPU0.unPPR4.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR4_PPR20	(PPU0.unPPR4.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR4_PPR21	(PPU0.unPPR4.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR4_PPR22	(PPU0.unPPR4.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR4_PPR23	(PPU0.unPPR4.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR4_PPR24	(PPU0.unPPR4.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR4_PPR25	(PPU0.unPPR4.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR4_PPR26	(PPU0.unPPR4.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR4_PPR27	(PPU0.unPPR4.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR4_PPR28	(PPU0.unPPR4.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR4_PPR29	(PPU0.unPPR4.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR4_PPR30	(PPU0.unPPR4.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR4_PPR31	(PPU0.unPPR4.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR5	(PPU0.unPPR5.u32Register)  /*@rg@*/
#define PPU0_PPR5_PPR0	(PPU0.unPPR5.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR5_PPR1	(PPU0.unPPR5.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR5_PPR2	(PPU0.unPPR5.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR5_PPR3	(PPU0.unPPR5.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR5_PPR4	(PPU0.unPPR5.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR5_PPR5	(PPU0.unPPR5.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR5_PPR6	(PPU0.unPPR5.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR5_PPR7	(PPU0.unPPR5.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR5_PPR8	(PPU0.unPPR5.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR5_PPR9	(PPU0.unPPR5.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR5_PPR10	(PPU0.unPPR5.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR5_PPR11	(PPU0.unPPR5.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR5_PPR12	(PPU0.unPPR5.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR5_PPR13	(PPU0.unPPR5.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR5_PPR14	(PPU0.unPPR5.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR5_PPR15	(PPU0.unPPR5.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR5_PPR16	(PPU0.unPPR5.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR5_PPR17	(PPU0.unPPR5.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR5_PPR18	(PPU0.unPPR5.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR5_PPR19	(PPU0.unPPR5.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR5_PPR20	(PPU0.unPPR5.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR5_PPR21	(PPU0.unPPR5.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR5_PPR22	(PPU0.unPPR5.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR5_PPR23	(PPU0.unPPR5.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR5_PPR24	(PPU0.unPPR5.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR5_PPR25	(PPU0.unPPR5.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR5_PPR26	(PPU0.unPPR5.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR5_PPR27	(PPU0.unPPR5.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR5_PPR28	(PPU0.unPPR5.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR5_PPR29	(PPU0.unPPR5.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR5_PPR30	(PPU0.unPPR5.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR5_PPR31	(PPU0.unPPR5.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR6	(PPU0.unPPR6.u32Register)  /*@rg@*/
#define PPU0_PPR6_PPR0	(PPU0.unPPR6.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR6_PPR1	(PPU0.unPPR6.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR6_PPR2	(PPU0.unPPR6.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR6_PPR3	(PPU0.unPPR6.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR6_PPR4	(PPU0.unPPR6.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR6_PPR5	(PPU0.unPPR6.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR6_PPR6	(PPU0.unPPR6.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR6_PPR7	(PPU0.unPPR6.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR6_PPR8	(PPU0.unPPR6.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR6_PPR9	(PPU0.unPPR6.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR6_PPR10	(PPU0.unPPR6.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR6_PPR11	(PPU0.unPPR6.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR6_PPR12	(PPU0.unPPR6.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR6_PPR13	(PPU0.unPPR6.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR6_PPR14	(PPU0.unPPR6.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR6_PPR15	(PPU0.unPPR6.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR6_PPR16	(PPU0.unPPR6.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR6_PPR17	(PPU0.unPPR6.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR6_PPR18	(PPU0.unPPR6.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR6_PPR19	(PPU0.unPPR6.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR6_PPR20	(PPU0.unPPR6.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR6_PPR21	(PPU0.unPPR6.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR6_PPR22	(PPU0.unPPR6.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR6_PPR23	(PPU0.unPPR6.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR6_PPR24	(PPU0.unPPR6.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR6_PPR25	(PPU0.unPPR6.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR6_PPR26	(PPU0.unPPR6.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR6_PPR27	(PPU0.unPPR6.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR6_PPR28	(PPU0.unPPR6.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR6_PPR29	(PPU0.unPPR6.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR6_PPR30	(PPU0.unPPR6.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR6_PPR31	(PPU0.unPPR6.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR7	(PPU0.unPPR7.u32Register)  /*@rg@*/
#define PPU0_PPR7_PPR0	(PPU0.unPPR7.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR7_PPR1	(PPU0.unPPR7.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR7_PPR2	(PPU0.unPPR7.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR7_PPR3	(PPU0.unPPR7.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR7_PPR4	(PPU0.unPPR7.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR7_PPR5	(PPU0.unPPR7.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR7_PPR6	(PPU0.unPPR7.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR7_PPR7	(PPU0.unPPR7.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR7_PPR8	(PPU0.unPPR7.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR7_PPR9	(PPU0.unPPR7.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR7_PPR10	(PPU0.unPPR7.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR7_PPR11	(PPU0.unPPR7.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR7_PPR12	(PPU0.unPPR7.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR7_PPR13	(PPU0.unPPR7.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR7_PPR14	(PPU0.unPPR7.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR7_PPR15	(PPU0.unPPR7.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR7_PPR16	(PPU0.unPPR7.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR7_PPR17	(PPU0.unPPR7.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR7_PPR18	(PPU0.unPPR7.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR7_PPR19	(PPU0.unPPR7.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR7_PPR20	(PPU0.unPPR7.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR7_PPR21	(PPU0.unPPR7.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR7_PPR22	(PPU0.unPPR7.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR7_PPR23	(PPU0.unPPR7.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR7_PPR24	(PPU0.unPPR7.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR7_PPR25	(PPU0.unPPR7.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR7_PPR26	(PPU0.unPPR7.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR7_PPR27	(PPU0.unPPR7.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR7_PPR28	(PPU0.unPPR7.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR7_PPR29	(PPU0.unPPR7.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR7_PPR30	(PPU0.unPPR7.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR7_PPR31	(PPU0.unPPR7.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR8	(PPU0.unPPR8.u32Register)  /*@rg@*/
#define PPU0_PPR8_PPR0	(PPU0.unPPR8.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR8_PPR1	(PPU0.unPPR8.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR8_PPR2	(PPU0.unPPR8.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR8_PPR3	(PPU0.unPPR8.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR8_PPR4	(PPU0.unPPR8.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR8_PPR5	(PPU0.unPPR8.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR8_PPR6	(PPU0.unPPR8.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR8_PPR7	(PPU0.unPPR8.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR8_PPR8	(PPU0.unPPR8.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR8_PPR9	(PPU0.unPPR8.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR8_PPR10	(PPU0.unPPR8.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR8_PPR11	(PPU0.unPPR8.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR8_PPR12	(PPU0.unPPR8.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR8_PPR13	(PPU0.unPPR8.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR8_PPR14	(PPU0.unPPR8.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR8_PPR15	(PPU0.unPPR8.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR8_PPR16	(PPU0.unPPR8.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR8_PPR17	(PPU0.unPPR8.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR8_PPR18	(PPU0.unPPR8.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR8_PPR19	(PPU0.unPPR8.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR8_PPR20	(PPU0.unPPR8.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR8_PPR21	(PPU0.unPPR8.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR8_PPR22	(PPU0.unPPR8.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR8_PPR23	(PPU0.unPPR8.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR8_PPR24	(PPU0.unPPR8.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR8_PPR25	(PPU0.unPPR8.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR8_PPR26	(PPU0.unPPR8.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR8_PPR27	(PPU0.unPPR8.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR8_PPR28	(PPU0.unPPR8.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR8_PPR29	(PPU0.unPPR8.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR8_PPR30	(PPU0.unPPR8.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR8_PPR31	(PPU0.unPPR8.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR9	(PPU0.unPPR9.u32Register)  /*@rg@*/
#define PPU0_PPR9_PPR0	(PPU0.unPPR9.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR9_PPR1	(PPU0.unPPR9.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR9_PPR2	(PPU0.unPPR9.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR9_PPR3	(PPU0.unPPR9.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR9_PPR4	(PPU0.unPPR9.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR9_PPR5	(PPU0.unPPR9.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR9_PPR6	(PPU0.unPPR9.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR9_PPR7	(PPU0.unPPR9.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR9_PPR8	(PPU0.unPPR9.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR9_PPR9	(PPU0.unPPR9.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR9_PPR10	(PPU0.unPPR9.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR9_PPR11	(PPU0.unPPR9.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR9_PPR12	(PPU0.unPPR9.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR9_PPR13	(PPU0.unPPR9.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR9_PPR14	(PPU0.unPPR9.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR9_PPR15	(PPU0.unPPR9.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR9_PPR16	(PPU0.unPPR9.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR9_PPR17	(PPU0.unPPR9.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR9_PPR18	(PPU0.unPPR9.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR9_PPR19	(PPU0.unPPR9.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR9_PPR20	(PPU0.unPPR9.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR9_PPR21	(PPU0.unPPR9.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR9_PPR22	(PPU0.unPPR9.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR9_PPR23	(PPU0.unPPR9.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR9_PPR24	(PPU0.unPPR9.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR9_PPR25	(PPU0.unPPR9.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR9_PPR26	(PPU0.unPPR9.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR9_PPR27	(PPU0.unPPR9.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR9_PPR28	(PPU0.unPPR9.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR9_PPR29	(PPU0.unPPR9.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR9_PPR30	(PPU0.unPPR9.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR9_PPR31	(PPU0.unPPR9.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR10	(PPU0.unPPR10.u32Register)  /*@rg@*/
#define PPU0_PPR10_PPR0	(PPU0.unPPR10.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR10_PPR1	(PPU0.unPPR10.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR10_PPR2	(PPU0.unPPR10.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR10_PPR3	(PPU0.unPPR10.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR10_PPR4	(PPU0.unPPR10.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR10_PPR5	(PPU0.unPPR10.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR10_PPR6	(PPU0.unPPR10.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR10_PPR7	(PPU0.unPPR10.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR10_PPR8	(PPU0.unPPR10.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR10_PPR9	(PPU0.unPPR10.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR10_PPR10	(PPU0.unPPR10.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR10_PPR11	(PPU0.unPPR10.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR10_PPR12	(PPU0.unPPR10.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR10_PPR13	(PPU0.unPPR10.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR10_PPR14	(PPU0.unPPR10.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR10_PPR15	(PPU0.unPPR10.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR10_PPR16	(PPU0.unPPR10.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR10_PPR17	(PPU0.unPPR10.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR10_PPR18	(PPU0.unPPR10.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR10_PPR19	(PPU0.unPPR10.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR10_PPR20	(PPU0.unPPR10.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR10_PPR21	(PPU0.unPPR10.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR10_PPR22	(PPU0.unPPR10.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR10_PPR23	(PPU0.unPPR10.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR10_PPR24	(PPU0.unPPR10.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR10_PPR25	(PPU0.unPPR10.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR10_PPR26	(PPU0.unPPR10.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR10_PPR27	(PPU0.unPPR10.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR10_PPR28	(PPU0.unPPR10.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR10_PPR29	(PPU0.unPPR10.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR10_PPR30	(PPU0.unPPR10.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR10_PPR31	(PPU0.unPPR10.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR11	(PPU0.unPPR11.u32Register)  /*@rg@*/
#define PPU0_PPR11_PPR0	(PPU0.unPPR11.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR11_PPR1	(PPU0.unPPR11.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR11_PPR2	(PPU0.unPPR11.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR11_PPR3	(PPU0.unPPR11.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR11_PPR4	(PPU0.unPPR11.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR11_PPR5	(PPU0.unPPR11.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR11_PPR6	(PPU0.unPPR11.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR11_PPR7	(PPU0.unPPR11.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR11_PPR8	(PPU0.unPPR11.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR11_PPR9	(PPU0.unPPR11.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR11_PPR10	(PPU0.unPPR11.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR11_PPR11	(PPU0.unPPR11.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR11_PPR12	(PPU0.unPPR11.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR11_PPR13	(PPU0.unPPR11.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR11_PPR14	(PPU0.unPPR11.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR11_PPR15	(PPU0.unPPR11.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR11_PPR16	(PPU0.unPPR11.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR11_PPR17	(PPU0.unPPR11.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR11_PPR18	(PPU0.unPPR11.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR11_PPR19	(PPU0.unPPR11.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR11_PPR20	(PPU0.unPPR11.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR11_PPR21	(PPU0.unPPR11.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR11_PPR22	(PPU0.unPPR11.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR11_PPR23	(PPU0.unPPR11.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR11_PPR24	(PPU0.unPPR11.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR11_PPR25	(PPU0.unPPR11.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR11_PPR26	(PPU0.unPPR11.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR11_PPR27	(PPU0.unPPR11.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR11_PPR28	(PPU0.unPPR11.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR11_PPR29	(PPU0.unPPR11.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR11_PPR30	(PPU0.unPPR11.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR11_PPR31	(PPU0.unPPR11.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR12	(PPU0.unPPR12.u32Register)  /*@rg@*/
#define PPU0_PPR12_PPR0	(PPU0.unPPR12.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR12_PPR1	(PPU0.unPPR12.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR12_PPR2	(PPU0.unPPR12.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR12_PPR3	(PPU0.unPPR12.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR12_PPR4	(PPU0.unPPR12.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR12_PPR5	(PPU0.unPPR12.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR12_PPR6	(PPU0.unPPR12.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR12_PPR7	(PPU0.unPPR12.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR12_PPR8	(PPU0.unPPR12.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR12_PPR9	(PPU0.unPPR12.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR12_PPR10	(PPU0.unPPR12.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR12_PPR11	(PPU0.unPPR12.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR12_PPR12	(PPU0.unPPR12.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR12_PPR13	(PPU0.unPPR12.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR12_PPR14	(PPU0.unPPR12.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR12_PPR15	(PPU0.unPPR12.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR12_PPR16	(PPU0.unPPR12.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR12_PPR17	(PPU0.unPPR12.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR12_PPR18	(PPU0.unPPR12.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR12_PPR19	(PPU0.unPPR12.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR12_PPR20	(PPU0.unPPR12.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR12_PPR21	(PPU0.unPPR12.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR12_PPR22	(PPU0.unPPR12.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR12_PPR23	(PPU0.unPPR12.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR12_PPR24	(PPU0.unPPR12.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR12_PPR25	(PPU0.unPPR12.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR12_PPR26	(PPU0.unPPR12.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR12_PPR27	(PPU0.unPPR12.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR12_PPR28	(PPU0.unPPR12.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR12_PPR29	(PPU0.unPPR12.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR12_PPR30	(PPU0.unPPR12.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR12_PPR31	(PPU0.unPPR12.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR13	(PPU0.unPPR13.u32Register)  /*@rg@*/
#define PPU0_PPR13_PPR0	(PPU0.unPPR13.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR13_PPR1	(PPU0.unPPR13.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR13_PPR2	(PPU0.unPPR13.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR13_PPR3	(PPU0.unPPR13.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR13_PPR4	(PPU0.unPPR13.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR13_PPR5	(PPU0.unPPR13.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR13_PPR6	(PPU0.unPPR13.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR13_PPR7	(PPU0.unPPR13.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR13_PPR8	(PPU0.unPPR13.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR13_PPR9	(PPU0.unPPR13.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR13_PPR10	(PPU0.unPPR13.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR13_PPR11	(PPU0.unPPR13.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR13_PPR12	(PPU0.unPPR13.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR13_PPR13	(PPU0.unPPR13.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR13_PPR14	(PPU0.unPPR13.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR13_PPR15	(PPU0.unPPR13.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR13_PPR16	(PPU0.unPPR13.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR13_PPR17	(PPU0.unPPR13.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR13_PPR18	(PPU0.unPPR13.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR13_PPR19	(PPU0.unPPR13.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR13_PPR20	(PPU0.unPPR13.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR13_PPR21	(PPU0.unPPR13.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR13_PPR22	(PPU0.unPPR13.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR13_PPR23	(PPU0.unPPR13.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR13_PPR24	(PPU0.unPPR13.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR13_PPR25	(PPU0.unPPR13.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR13_PPR26	(PPU0.unPPR13.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR13_PPR27	(PPU0.unPPR13.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR13_PPR28	(PPU0.unPPR13.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR13_PPR29	(PPU0.unPPR13.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR13_PPR30	(PPU0.unPPR13.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR13_PPR31	(PPU0.unPPR13.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR14	(PPU0.unPPR14.u32Register)  /*@rg@*/
#define PPU0_PPR14_PPR0	(PPU0.unPPR14.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR14_PPR1	(PPU0.unPPR14.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR14_PPR2	(PPU0.unPPR14.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR14_PPR3	(PPU0.unPPR14.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR14_PPR4	(PPU0.unPPR14.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR14_PPR5	(PPU0.unPPR14.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR14_PPR6	(PPU0.unPPR14.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR14_PPR7	(PPU0.unPPR14.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR14_PPR8	(PPU0.unPPR14.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR14_PPR9	(PPU0.unPPR14.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR14_PPR10	(PPU0.unPPR14.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR14_PPR11	(PPU0.unPPR14.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR14_PPR12	(PPU0.unPPR14.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR14_PPR13	(PPU0.unPPR14.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR14_PPR14	(PPU0.unPPR14.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR14_PPR15	(PPU0.unPPR14.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR14_PPR16	(PPU0.unPPR14.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR14_PPR17	(PPU0.unPPR14.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR14_PPR18	(PPU0.unPPR14.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR14_PPR19	(PPU0.unPPR14.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR14_PPR20	(PPU0.unPPR14.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR14_PPR21	(PPU0.unPPR14.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR14_PPR22	(PPU0.unPPR14.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR14_PPR23	(PPU0.unPPR14.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR14_PPR24	(PPU0.unPPR14.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR14_PPR25	(PPU0.unPPR14.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR14_PPR26	(PPU0.unPPR14.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR14_PPR27	(PPU0.unPPR14.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR14_PPR28	(PPU0.unPPR14.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR14_PPR29	(PPU0.unPPR14.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR14_PPR30	(PPU0.unPPR14.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR14_PPR31	(PPU0.unPPR14.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR15	(PPU0.unPPR15.u32Register)  /*@rg@*/
#define PPU0_PPR15_PPR0	(PPU0.unPPR15.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR15_PPR1	(PPU0.unPPR15.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR15_PPR2	(PPU0.unPPR15.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR15_PPR3	(PPU0.unPPR15.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR15_PPR4	(PPU0.unPPR15.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR15_PPR5	(PPU0.unPPR15.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR15_PPR6	(PPU0.unPPR15.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR15_PPR7	(PPU0.unPPR15.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR15_PPR8	(PPU0.unPPR15.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR15_PPR9	(PPU0.unPPR15.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR15_PPR10	(PPU0.unPPR15.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR15_PPR11	(PPU0.unPPR15.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR15_PPR12	(PPU0.unPPR15.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR15_PPR13	(PPU0.unPPR15.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR15_PPR14	(PPU0.unPPR15.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR15_PPR15	(PPU0.unPPR15.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR15_PPR16	(PPU0.unPPR15.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR15_PPR17	(PPU0.unPPR15.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR15_PPR18	(PPU0.unPPR15.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR15_PPR19	(PPU0.unPPR15.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR15_PPR20	(PPU0.unPPR15.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR15_PPR21	(PPU0.unPPR15.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR15_PPR22	(PPU0.unPPR15.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR15_PPR23	(PPU0.unPPR15.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR15_PPR24	(PPU0.unPPR15.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR15_PPR25	(PPU0.unPPR15.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR15_PPR26	(PPU0.unPPR15.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR15_PPR27	(PPU0.unPPR15.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR15_PPR28	(PPU0.unPPR15.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR15_PPR29	(PPU0.unPPR15.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR15_PPR30	(PPU0.unPPR15.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR15_PPR31	(PPU0.unPPR15.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR16	(PPU0.unPPR16.u32Register)  /*@rg@*/
#define PPU0_PPR16_PPR0	(PPU0.unPPR16.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR16_PPR1	(PPU0.unPPR16.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR16_PPR2	(PPU0.unPPR16.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR16_PPR3	(PPU0.unPPR16.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR16_PPR4	(PPU0.unPPR16.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR16_PPR5	(PPU0.unPPR16.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR16_PPR6	(PPU0.unPPR16.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR16_PPR7	(PPU0.unPPR16.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR16_PPR8	(PPU0.unPPR16.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR16_PPR9	(PPU0.unPPR16.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR16_PPR10	(PPU0.unPPR16.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR16_PPR11	(PPU0.unPPR16.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR16_PPR12	(PPU0.unPPR16.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR16_PPR13	(PPU0.unPPR16.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR16_PPR14	(PPU0.unPPR16.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR16_PPR15	(PPU0.unPPR16.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR16_PPR16	(PPU0.unPPR16.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR16_PPR17	(PPU0.unPPR16.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR16_PPR18	(PPU0.unPPR16.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR16_PPR19	(PPU0.unPPR16.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR16_PPR20	(PPU0.unPPR16.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR16_PPR21	(PPU0.unPPR16.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR16_PPR22	(PPU0.unPPR16.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR16_PPR23	(PPU0.unPPR16.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR16_PPR24	(PPU0.unPPR16.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR16_PPR25	(PPU0.unPPR16.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR16_PPR26	(PPU0.unPPR16.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR16_PPR27	(PPU0.unPPR16.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR16_PPR28	(PPU0.unPPR16.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR16_PPR29	(PPU0.unPPR16.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR16_PPR30	(PPU0.unPPR16.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR16_PPR31	(PPU0.unPPR16.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR17	(PPU0.unPPR17.u32Register)  /*@rg@*/
#define PPU0_PPR17_PPR0	(PPU0.unPPR17.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR17_PPR1	(PPU0.unPPR17.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR17_PPR2	(PPU0.unPPR17.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR17_PPR3	(PPU0.unPPR17.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR17_PPR4	(PPU0.unPPR17.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR17_PPR5	(PPU0.unPPR17.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR17_PPR6	(PPU0.unPPR17.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR17_PPR7	(PPU0.unPPR17.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR17_PPR8	(PPU0.unPPR17.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR17_PPR9	(PPU0.unPPR17.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR17_PPR10	(PPU0.unPPR17.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR17_PPR11	(PPU0.unPPR17.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR17_PPR12	(PPU0.unPPR17.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR17_PPR13	(PPU0.unPPR17.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR17_PPR14	(PPU0.unPPR17.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR17_PPR15	(PPU0.unPPR17.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR17_PPR16	(PPU0.unPPR17.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR17_PPR17	(PPU0.unPPR17.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR17_PPR18	(PPU0.unPPR17.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR17_PPR19	(PPU0.unPPR17.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR17_PPR20	(PPU0.unPPR17.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR17_PPR21	(PPU0.unPPR17.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR17_PPR22	(PPU0.unPPR17.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR17_PPR23	(PPU0.unPPR17.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR17_PPR24	(PPU0.unPPR17.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR17_PPR25	(PPU0.unPPR17.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR17_PPR26	(PPU0.unPPR17.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR17_PPR27	(PPU0.unPPR17.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR17_PPR28	(PPU0.unPPR17.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR17_PPR29	(PPU0.unPPR17.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR17_PPR30	(PPU0.unPPR17.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR17_PPR31	(PPU0.unPPR17.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR18	(PPU0.unPPR18.u32Register)  /*@rg@*/
#define PPU0_PPR18_PPR0	(PPU0.unPPR18.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR18_PPR1	(PPU0.unPPR18.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR18_PPR2	(PPU0.unPPR18.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR18_PPR3	(PPU0.unPPR18.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR18_PPR4	(PPU0.unPPR18.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR18_PPR5	(PPU0.unPPR18.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR18_PPR6	(PPU0.unPPR18.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR18_PPR7	(PPU0.unPPR18.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR18_PPR8	(PPU0.unPPR18.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR18_PPR9	(PPU0.unPPR18.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR18_PPR10	(PPU0.unPPR18.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR18_PPR11	(PPU0.unPPR18.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR18_PPR12	(PPU0.unPPR18.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR18_PPR13	(PPU0.unPPR18.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR18_PPR14	(PPU0.unPPR18.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR18_PPR15	(PPU0.unPPR18.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR18_PPR16	(PPU0.unPPR18.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR18_PPR17	(PPU0.unPPR18.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR18_PPR18	(PPU0.unPPR18.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR18_PPR19	(PPU0.unPPR18.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR18_PPR20	(PPU0.unPPR18.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR18_PPR21	(PPU0.unPPR18.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR18_PPR22	(PPU0.unPPR18.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR18_PPR23	(PPU0.unPPR18.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR18_PPR24	(PPU0.unPPR18.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR18_PPR25	(PPU0.unPPR18.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR18_PPR26	(PPU0.unPPR18.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR18_PPR27	(PPU0.unPPR18.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR18_PPR28	(PPU0.unPPR18.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR18_PPR29	(PPU0.unPPR18.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR18_PPR30	(PPU0.unPPR18.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR18_PPR31	(PPU0.unPPR18.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR19	(PPU0.unPPR19.u32Register)  /*@rg@*/
#define PPU0_PPR19_PPR0	(PPU0.unPPR19.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR19_PPR1	(PPU0.unPPR19.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR19_PPR2	(PPU0.unPPR19.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR19_PPR3	(PPU0.unPPR19.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR19_PPR4	(PPU0.unPPR19.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR19_PPR5	(PPU0.unPPR19.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR19_PPR6	(PPU0.unPPR19.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR19_PPR7	(PPU0.unPPR19.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR19_PPR8	(PPU0.unPPR19.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR19_PPR9	(PPU0.unPPR19.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR19_PPR10	(PPU0.unPPR19.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR19_PPR11	(PPU0.unPPR19.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR19_PPR12	(PPU0.unPPR19.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR19_PPR13	(PPU0.unPPR19.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR19_PPR14	(PPU0.unPPR19.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR19_PPR15	(PPU0.unPPR19.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR19_PPR16	(PPU0.unPPR19.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR19_PPR17	(PPU0.unPPR19.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR19_PPR18	(PPU0.unPPR19.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR19_PPR19	(PPU0.unPPR19.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR19_PPR20	(PPU0.unPPR19.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR19_PPR21	(PPU0.unPPR19.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR19_PPR22	(PPU0.unPPR19.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR19_PPR23	(PPU0.unPPR19.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR19_PPR24	(PPU0.unPPR19.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR19_PPR25	(PPU0.unPPR19.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR19_PPR26	(PPU0.unPPR19.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR19_PPR27	(PPU0.unPPR19.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR19_PPR28	(PPU0.unPPR19.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR19_PPR29	(PPU0.unPPR19.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR19_PPR30	(PPU0.unPPR19.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR19_PPR31	(PPU0.unPPR19.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR20	(PPU0.unPPR20.u32Register)  /*@rg@*/
#define PPU0_PPR20_PPR0	(PPU0.unPPR20.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR20_PPR1	(PPU0.unPPR20.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR20_PPR2	(PPU0.unPPR20.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR20_PPR3	(PPU0.unPPR20.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR20_PPR4	(PPU0.unPPR20.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR20_PPR5	(PPU0.unPPR20.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR20_PPR6	(PPU0.unPPR20.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR20_PPR7	(PPU0.unPPR20.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR20_PPR8	(PPU0.unPPR20.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR20_PPR9	(PPU0.unPPR20.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR20_PPR10	(PPU0.unPPR20.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR20_PPR11	(PPU0.unPPR20.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR20_PPR12	(PPU0.unPPR20.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR20_PPR13	(PPU0.unPPR20.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR20_PPR14	(PPU0.unPPR20.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR20_PPR15	(PPU0.unPPR20.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR20_PPR16	(PPU0.unPPR20.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR20_PPR17	(PPU0.unPPR20.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR20_PPR18	(PPU0.unPPR20.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR20_PPR19	(PPU0.unPPR20.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR20_PPR20	(PPU0.unPPR20.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR20_PPR21	(PPU0.unPPR20.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR20_PPR22	(PPU0.unPPR20.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR20_PPR23	(PPU0.unPPR20.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR20_PPR24	(PPU0.unPPR20.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR20_PPR25	(PPU0.unPPR20.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR20_PPR26	(PPU0.unPPR20.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR20_PPR27	(PPU0.unPPR20.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR20_PPR28	(PPU0.unPPR20.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR20_PPR29	(PPU0.unPPR20.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR20_PPR30	(PPU0.unPPR20.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR20_PPR31	(PPU0.unPPR20.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR21	(PPU0.unPPR21.u32Register)  /*@rg@*/
#define PPU0_PPR21_PPR0	(PPU0.unPPR21.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR21_PPR1	(PPU0.unPPR21.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR21_PPR2	(PPU0.unPPR21.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR21_PPR3	(PPU0.unPPR21.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR21_PPR4	(PPU0.unPPR21.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR21_PPR5	(PPU0.unPPR21.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR21_PPR6	(PPU0.unPPR21.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR21_PPR7	(PPU0.unPPR21.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR21_PPR8	(PPU0.unPPR21.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR21_PPR9	(PPU0.unPPR21.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR21_PPR10	(PPU0.unPPR21.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR21_PPR11	(PPU0.unPPR21.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR21_PPR12	(PPU0.unPPR21.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR21_PPR13	(PPU0.unPPR21.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR21_PPR14	(PPU0.unPPR21.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR21_PPR15	(PPU0.unPPR21.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR21_PPR16	(PPU0.unPPR21.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR21_PPR17	(PPU0.unPPR21.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR21_PPR18	(PPU0.unPPR21.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR21_PPR19	(PPU0.unPPR21.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR21_PPR20	(PPU0.unPPR21.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR21_PPR21	(PPU0.unPPR21.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR21_PPR22	(PPU0.unPPR21.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR21_PPR23	(PPU0.unPPR21.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR21_PPR24	(PPU0.unPPR21.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR21_PPR25	(PPU0.unPPR21.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR21_PPR26	(PPU0.unPPR21.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR21_PPR27	(PPU0.unPPR21.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR21_PPR28	(PPU0.unPPR21.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR21_PPR29	(PPU0.unPPR21.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR21_PPR30	(PPU0.unPPR21.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR21_PPR31	(PPU0.unPPR21.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR22	(PPU0.unPPR22.u32Register)  /*@rg@*/
#define PPU0_PPR22_PPR0	(PPU0.unPPR22.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR22_PPR1	(PPU0.unPPR22.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR22_PPR2	(PPU0.unPPR22.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR22_PPR3	(PPU0.unPPR22.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR22_PPR4	(PPU0.unPPR22.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR22_PPR5	(PPU0.unPPR22.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR22_PPR6	(PPU0.unPPR22.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR22_PPR7	(PPU0.unPPR22.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR22_PPR8	(PPU0.unPPR22.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR22_PPR9	(PPU0.unPPR22.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR22_PPR10	(PPU0.unPPR22.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR22_PPR11	(PPU0.unPPR22.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR22_PPR12	(PPU0.unPPR22.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR22_PPR13	(PPU0.unPPR22.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR22_PPR14	(PPU0.unPPR22.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR22_PPR15	(PPU0.unPPR22.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR22_PPR16	(PPU0.unPPR22.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR22_PPR17	(PPU0.unPPR22.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR22_PPR18	(PPU0.unPPR22.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR22_PPR19	(PPU0.unPPR22.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR22_PPR20	(PPU0.unPPR22.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR22_PPR21	(PPU0.unPPR22.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR22_PPR22	(PPU0.unPPR22.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR22_PPR23	(PPU0.unPPR22.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR22_PPR24	(PPU0.unPPR22.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR22_PPR25	(PPU0.unPPR22.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR22_PPR26	(PPU0.unPPR22.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR22_PPR27	(PPU0.unPPR22.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR22_PPR28	(PPU0.unPPR22.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR22_PPR29	(PPU0.unPPR22.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR22_PPR30	(PPU0.unPPR22.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR22_PPR31	(PPU0.unPPR22.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR23	(PPU0.unPPR23.u32Register)  /*@rg@*/
#define PPU0_PPR23_PPR0	(PPU0.unPPR23.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR23_PPR1	(PPU0.unPPR23.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR23_PPR2	(PPU0.unPPR23.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR23_PPR3	(PPU0.unPPR23.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR23_PPR4	(PPU0.unPPR23.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR23_PPR5	(PPU0.unPPR23.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR23_PPR6	(PPU0.unPPR23.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR23_PPR7	(PPU0.unPPR23.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR23_PPR8	(PPU0.unPPR23.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR23_PPR9	(PPU0.unPPR23.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR23_PPR10	(PPU0.unPPR23.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR23_PPR11	(PPU0.unPPR23.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR23_PPR12	(PPU0.unPPR23.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR23_PPR13	(PPU0.unPPR23.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR23_PPR14	(PPU0.unPPR23.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR23_PPR15	(PPU0.unPPR23.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR23_PPR16	(PPU0.unPPR23.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR23_PPR17	(PPU0.unPPR23.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR23_PPR18	(PPU0.unPPR23.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR23_PPR19	(PPU0.unPPR23.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR23_PPR20	(PPU0.unPPR23.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR23_PPR21	(PPU0.unPPR23.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR23_PPR22	(PPU0.unPPR23.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR23_PPR23	(PPU0.unPPR23.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR23_PPR24	(PPU0.unPPR23.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR23_PPR25	(PPU0.unPPR23.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR23_PPR26	(PPU0.unPPR23.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR23_PPR27	(PPU0.unPPR23.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR23_PPR28	(PPU0.unPPR23.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR23_PPR29	(PPU0.unPPR23.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR23_PPR30	(PPU0.unPPR23.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR23_PPR31	(PPU0.unPPR23.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR24	(PPU0.unPPR24.u32Register)  /*@rg@*/
#define PPU0_PPR24_PPR0	(PPU0.unPPR24.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR24_PPR1	(PPU0.unPPR24.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR24_PPR2	(PPU0.unPPR24.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR24_PPR3	(PPU0.unPPR24.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR24_PPR4	(PPU0.unPPR24.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR24_PPR5	(PPU0.unPPR24.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR24_PPR6	(PPU0.unPPR24.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR24_PPR7	(PPU0.unPPR24.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR24_PPR8	(PPU0.unPPR24.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR24_PPR9	(PPU0.unPPR24.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR24_PPR10	(PPU0.unPPR24.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR24_PPR11	(PPU0.unPPR24.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR24_PPR12	(PPU0.unPPR24.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR24_PPR13	(PPU0.unPPR24.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR24_PPR14	(PPU0.unPPR24.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR24_PPR15	(PPU0.unPPR24.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR24_PPR16	(PPU0.unPPR24.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR24_PPR17	(PPU0.unPPR24.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR24_PPR18	(PPU0.unPPR24.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR24_PPR19	(PPU0.unPPR24.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR24_PPR20	(PPU0.unPPR24.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR24_PPR21	(PPU0.unPPR24.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR24_PPR22	(PPU0.unPPR24.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR24_PPR23	(PPU0.unPPR24.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR24_PPR24	(PPU0.unPPR24.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR24_PPR25	(PPU0.unPPR24.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR24_PPR26	(PPU0.unPPR24.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR24_PPR27	(PPU0.unPPR24.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR24_PPR28	(PPU0.unPPR24.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR24_PPR29	(PPU0.unPPR24.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR24_PPR30	(PPU0.unPPR24.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR24_PPR31	(PPU0.unPPR24.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR25	(PPU0.unPPR25.u32Register)  /*@rg@*/
#define PPU0_PPR25_PPR0	(PPU0.unPPR25.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR25_PPR1	(PPU0.unPPR25.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR25_PPR2	(PPU0.unPPR25.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR25_PPR3	(PPU0.unPPR25.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR25_PPR4	(PPU0.unPPR25.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR25_PPR5	(PPU0.unPPR25.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR25_PPR6	(PPU0.unPPR25.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR25_PPR7	(PPU0.unPPR25.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR25_PPR8	(PPU0.unPPR25.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR25_PPR9	(PPU0.unPPR25.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR25_PPR10	(PPU0.unPPR25.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR25_PPR11	(PPU0.unPPR25.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR25_PPR12	(PPU0.unPPR25.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR25_PPR13	(PPU0.unPPR25.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR25_PPR14	(PPU0.unPPR25.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR25_PPR15	(PPU0.unPPR25.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR25_PPR16	(PPU0.unPPR25.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR25_PPR17	(PPU0.unPPR25.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR25_PPR18	(PPU0.unPPR25.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR25_PPR19	(PPU0.unPPR25.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR25_PPR20	(PPU0.unPPR25.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR25_PPR21	(PPU0.unPPR25.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR25_PPR22	(PPU0.unPPR25.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR25_PPR23	(PPU0.unPPR25.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR25_PPR24	(PPU0.unPPR25.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR25_PPR25	(PPU0.unPPR25.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR25_PPR26	(PPU0.unPPR25.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR25_PPR27	(PPU0.unPPR25.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR25_PPR28	(PPU0.unPPR25.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR25_PPR29	(PPU0.unPPR25.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR25_PPR30	(PPU0.unPPR25.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR25_PPR31	(PPU0.unPPR25.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR26	(PPU0.unPPR26.u32Register)  /*@rg@*/
#define PPU0_PPR26_PPR0	(PPU0.unPPR26.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR26_PPR1	(PPU0.unPPR26.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR26_PPR2	(PPU0.unPPR26.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR26_PPR3	(PPU0.unPPR26.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR26_PPR4	(PPU0.unPPR26.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR26_PPR5	(PPU0.unPPR26.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR26_PPR6	(PPU0.unPPR26.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR26_PPR7	(PPU0.unPPR26.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR26_PPR8	(PPU0.unPPR26.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR26_PPR9	(PPU0.unPPR26.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR26_PPR10	(PPU0.unPPR26.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR26_PPR11	(PPU0.unPPR26.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR26_PPR12	(PPU0.unPPR26.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR26_PPR13	(PPU0.unPPR26.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR26_PPR14	(PPU0.unPPR26.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR26_PPR15	(PPU0.unPPR26.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR26_PPR16	(PPU0.unPPR26.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR26_PPR17	(PPU0.unPPR26.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR26_PPR18	(PPU0.unPPR26.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR26_PPR19	(PPU0.unPPR26.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR26_PPR20	(PPU0.unPPR26.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR26_PPR21	(PPU0.unPPR26.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR26_PPR22	(PPU0.unPPR26.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR26_PPR23	(PPU0.unPPR26.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR26_PPR24	(PPU0.unPPR26.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR26_PPR25	(PPU0.unPPR26.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR26_PPR26	(PPU0.unPPR26.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR26_PPR27	(PPU0.unPPR26.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR26_PPR28	(PPU0.unPPR26.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR26_PPR29	(PPU0.unPPR26.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR26_PPR30	(PPU0.unPPR26.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR26_PPR31	(PPU0.unPPR26.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR27	(PPU0.unPPR27.u32Register)  /*@rg@*/
#define PPU0_PPR27_PPR0	(PPU0.unPPR27.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR27_PPR1	(PPU0.unPPR27.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR27_PPR2	(PPU0.unPPR27.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR27_PPR3	(PPU0.unPPR27.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR27_PPR4	(PPU0.unPPR27.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR27_PPR5	(PPU0.unPPR27.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR27_PPR6	(PPU0.unPPR27.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR27_PPR7	(PPU0.unPPR27.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR27_PPR8	(PPU0.unPPR27.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR27_PPR9	(PPU0.unPPR27.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR27_PPR10	(PPU0.unPPR27.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR27_PPR11	(PPU0.unPPR27.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR27_PPR12	(PPU0.unPPR27.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR27_PPR13	(PPU0.unPPR27.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR27_PPR14	(PPU0.unPPR27.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR27_PPR15	(PPU0.unPPR27.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR27_PPR16	(PPU0.unPPR27.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR27_PPR17	(PPU0.unPPR27.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR27_PPR18	(PPU0.unPPR27.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR27_PPR19	(PPU0.unPPR27.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR27_PPR20	(PPU0.unPPR27.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR27_PPR21	(PPU0.unPPR27.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR27_PPR22	(PPU0.unPPR27.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR27_PPR23	(PPU0.unPPR27.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR27_PPR24	(PPU0.unPPR27.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR27_PPR25	(PPU0.unPPR27.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR27_PPR26	(PPU0.unPPR27.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR27_PPR27	(PPU0.unPPR27.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR27_PPR28	(PPU0.unPPR27.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR27_PPR29	(PPU0.unPPR27.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR27_PPR30	(PPU0.unPPR27.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR27_PPR31	(PPU0.unPPR27.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR28	(PPU0.unPPR28.u32Register)  /*@rg@*/
#define PPU0_PPR28_PPR0	(PPU0.unPPR28.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR28_PPR1	(PPU0.unPPR28.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR28_PPR2	(PPU0.unPPR28.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR28_PPR3	(PPU0.unPPR28.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR28_PPR4	(PPU0.unPPR28.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR28_PPR5	(PPU0.unPPR28.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR28_PPR6	(PPU0.unPPR28.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR28_PPR7	(PPU0.unPPR28.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR28_PPR8	(PPU0.unPPR28.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR28_PPR9	(PPU0.unPPR28.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR28_PPR10	(PPU0.unPPR28.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR28_PPR11	(PPU0.unPPR28.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR28_PPR12	(PPU0.unPPR28.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR28_PPR13	(PPU0.unPPR28.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR28_PPR14	(PPU0.unPPR28.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR28_PPR15	(PPU0.unPPR28.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR28_PPR16	(PPU0.unPPR28.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR28_PPR17	(PPU0.unPPR28.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR28_PPR18	(PPU0.unPPR28.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR28_PPR19	(PPU0.unPPR28.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR28_PPR20	(PPU0.unPPR28.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR28_PPR21	(PPU0.unPPR28.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR28_PPR22	(PPU0.unPPR28.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR28_PPR23	(PPU0.unPPR28.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR28_PPR24	(PPU0.unPPR28.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR28_PPR25	(PPU0.unPPR28.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR28_PPR26	(PPU0.unPPR28.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR28_PPR27	(PPU0.unPPR28.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR28_PPR28	(PPU0.unPPR28.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR28_PPR29	(PPU0.unPPR28.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR28_PPR30	(PPU0.unPPR28.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR28_PPR31	(PPU0.unPPR28.stcField.u1PPR31)  /*@bf@*/

#define PPU0_PPR29	(PPU0.unPPR29.u32Register)  /*@rg@*/
#define PPU0_PPR29_PPR0	(PPU0.unPPR29.stcField.u1PPR0)  /*@bf@*/
#define PPU0_PPR29_PPR1	(PPU0.unPPR29.stcField.u1PPR1)  /*@bf@*/
#define PPU0_PPR29_PPR2	(PPU0.unPPR29.stcField.u1PPR2)  /*@bf@*/
#define PPU0_PPR29_PPR3	(PPU0.unPPR29.stcField.u1PPR3)  /*@bf@*/
#define PPU0_PPR29_PPR4	(PPU0.unPPR29.stcField.u1PPR4)  /*@bf@*/
#define PPU0_PPR29_PPR5	(PPU0.unPPR29.stcField.u1PPR5)  /*@bf@*/
#define PPU0_PPR29_PPR6	(PPU0.unPPR29.stcField.u1PPR6)  /*@bf@*/
#define PPU0_PPR29_PPR7	(PPU0.unPPR29.stcField.u1PPR7)  /*@bf@*/
#define PPU0_PPR29_PPR8	(PPU0.unPPR29.stcField.u1PPR8)  /*@bf@*/
#define PPU0_PPR29_PPR9	(PPU0.unPPR29.stcField.u1PPR9)  /*@bf@*/
#define PPU0_PPR29_PPR10	(PPU0.unPPR29.stcField.u1PPR10)  /*@bf@*/
#define PPU0_PPR29_PPR11	(PPU0.unPPR29.stcField.u1PPR11)  /*@bf@*/
#define PPU0_PPR29_PPR12	(PPU0.unPPR29.stcField.u1PPR12)  /*@bf@*/
#define PPU0_PPR29_PPR13	(PPU0.unPPR29.stcField.u1PPR13)  /*@bf@*/
#define PPU0_PPR29_PPR14	(PPU0.unPPR29.stcField.u1PPR14)  /*@bf@*/
#define PPU0_PPR29_PPR15	(PPU0.unPPR29.stcField.u1PPR15)  /*@bf@*/
#define PPU0_PPR29_PPR16	(PPU0.unPPR29.stcField.u1PPR16)  /*@bf@*/
#define PPU0_PPR29_PPR17	(PPU0.unPPR29.stcField.u1PPR17)  /*@bf@*/
#define PPU0_PPR29_PPR18	(PPU0.unPPR29.stcField.u1PPR18)  /*@bf@*/
#define PPU0_PPR29_PPR19	(PPU0.unPPR29.stcField.u1PPR19)  /*@bf@*/
#define PPU0_PPR29_PPR20	(PPU0.unPPR29.stcField.u1PPR20)  /*@bf@*/
#define PPU0_PPR29_PPR21	(PPU0.unPPR29.stcField.u1PPR21)  /*@bf@*/
#define PPU0_PPR29_PPR22	(PPU0.unPPR29.stcField.u1PPR22)  /*@bf@*/
#define PPU0_PPR29_PPR23	(PPU0.unPPR29.stcField.u1PPR23)  /*@bf@*/
#define PPU0_PPR29_PPR24	(PPU0.unPPR29.stcField.u1PPR24)  /*@bf@*/
#define PPU0_PPR29_PPR25	(PPU0.unPPR29.stcField.u1PPR25)  /*@bf@*/
#define PPU0_PPR29_PPR26	(PPU0.unPPR29.stcField.u1PPR26)  /*@bf@*/
#define PPU0_PPR29_PPR27	(PPU0.unPPR29.stcField.u1PPR27)  /*@bf@*/
#define PPU0_PPR29_PPR28	(PPU0.unPPR29.stcField.u1PPR28)  /*@bf@*/
#define PPU0_PPR29_PPR29	(PPU0.unPPR29.stcField.u1PPR29)  /*@bf@*/
#define PPU0_PPR29_PPR30	(PPU0.unPPR29.stcField.u1PPR30)  /*@bf@*/
#define PPU0_PPR29_PPR31	(PPU0.unPPR29.stcField.u1PPR31)  /*@bf@*/

typedef struct stc_ppu0_pprn_field{
    uint_io32_t		u1PPR0:1;
    uint_io32_t		u1PPR1:1;
    uint_io32_t		u1PPR2:1;
    uint_io32_t		u1PPR3:1;
    uint_io32_t		u1PPR4:1;
    uint_io32_t		u1PPR5:1;
    uint_io32_t		u1PPR6:1;
    uint_io32_t		u1PPR7:1;
    uint_io32_t		u1PPR8:1;
    uint_io32_t		u1PPR9:1;
    uint_io32_t		u1PPR10:1;
    uint_io32_t		u1PPR11:1;
    uint_io32_t		u1PPR12:1;
    uint_io32_t		u1PPR13:1;
    uint_io32_t		u1PPR14:1;
    uint_io32_t		u1PPR15:1;
    uint_io32_t		u1PPR16:1;
    uint_io32_t		u1PPR17:1;
    uint_io32_t		u1PPR18:1;
    uint_io32_t		u1PPR19:1;
    uint_io32_t		u1PPR20:1;
    uint_io32_t		u1PPR21:1;
    uint_io32_t		u1PPR22:1;
    uint_io32_t		u1PPR23:1;
    uint_io32_t		u1PPR24:1;
    uint_io32_t		u1PPR25:1;
    uint_io32_t		u1PPR26:1;
    uint_io32_t		u1PPR27:1;
    uint_io32_t		u1PPR28:1;
    uint_io32_t		u1PPR29:1;
    uint_io32_t		u1PPR30:1;
    uint_io32_t		u1PPR31:1;
}stc_ppu0_pprn_field_t;

typedef union un_ppu0_pprn{
    uint_io32_t		u32Register;
    stc_ppu0_pprn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_pprn_t;

/* LOCK0 */
#define PPU0_LOCK0	(PPU0.unLOCK0.u32Register)  /*@rg@*/
#define PPU0_LOCK0_L	PPU0_LOCK0  /*@bfrg@*/

typedef union un_ppu0_lock0{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_lock0_t;

/* PUR[0-29] */
#define PPU0_PUR0	(PPU0.unPUR0.u32Register)  /*@rg@*/
#define PPU0_PUR0_PUR0	(PPU0.unPUR0.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR0_PUR1	(PPU0.unPUR0.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR0_PUR2	(PPU0.unPUR0.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR0_PUR3	(PPU0.unPUR0.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR0_PUR4	(PPU0.unPUR0.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR0_PUR5	(PPU0.unPUR0.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR0_PUR6	(PPU0.unPUR0.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR0_PUR7	(PPU0.unPUR0.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR0_PUR8	(PPU0.unPUR0.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR0_PUR9	(PPU0.unPUR0.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR0_PUR10	(PPU0.unPUR0.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR0_PUR11	(PPU0.unPUR0.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR0_PUR12	(PPU0.unPUR0.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR0_PUR13	(PPU0.unPUR0.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR0_PUR14	(PPU0.unPUR0.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR0_PUR15	(PPU0.unPUR0.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR0_PUR16	(PPU0.unPUR0.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR0_PUR17	(PPU0.unPUR0.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR0_PUR18	(PPU0.unPUR0.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR0_PUR19	(PPU0.unPUR0.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR0_PUR20	(PPU0.unPUR0.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR0_PUR21	(PPU0.unPUR0.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR0_PUR22	(PPU0.unPUR0.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR0_PUR23	(PPU0.unPUR0.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR0_PUR24	(PPU0.unPUR0.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR0_PUR25	(PPU0.unPUR0.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR0_PUR26	(PPU0.unPUR0.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR0_PUR27	(PPU0.unPUR0.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR0_PUR28	(PPU0.unPUR0.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR0_PUR29	(PPU0.unPUR0.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR0_PUR30	(PPU0.unPUR0.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR0_PUR31	(PPU0.unPUR0.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR1	(PPU0.unPUR1.u32Register)  /*@rg@*/
#define PPU0_PUR1_PUR0	(PPU0.unPUR1.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR1_PUR1	(PPU0.unPUR1.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR1_PUR2	(PPU0.unPUR1.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR1_PUR3	(PPU0.unPUR1.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR1_PUR4	(PPU0.unPUR1.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR1_PUR5	(PPU0.unPUR1.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR1_PUR6	(PPU0.unPUR1.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR1_PUR7	(PPU0.unPUR1.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR1_PUR8	(PPU0.unPUR1.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR1_PUR9	(PPU0.unPUR1.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR1_PUR10	(PPU0.unPUR1.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR1_PUR11	(PPU0.unPUR1.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR1_PUR12	(PPU0.unPUR1.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR1_PUR13	(PPU0.unPUR1.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR1_PUR14	(PPU0.unPUR1.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR1_PUR15	(PPU0.unPUR1.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR1_PUR16	(PPU0.unPUR1.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR1_PUR17	(PPU0.unPUR1.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR1_PUR18	(PPU0.unPUR1.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR1_PUR19	(PPU0.unPUR1.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR1_PUR20	(PPU0.unPUR1.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR1_PUR21	(PPU0.unPUR1.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR1_PUR22	(PPU0.unPUR1.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR1_PUR23	(PPU0.unPUR1.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR1_PUR24	(PPU0.unPUR1.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR1_PUR25	(PPU0.unPUR1.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR1_PUR26	(PPU0.unPUR1.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR1_PUR27	(PPU0.unPUR1.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR1_PUR28	(PPU0.unPUR1.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR1_PUR29	(PPU0.unPUR1.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR1_PUR30	(PPU0.unPUR1.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR1_PUR31	(PPU0.unPUR1.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR2	(PPU0.unPUR2.u32Register)  /*@rg@*/
#define PPU0_PUR2_PUR0	(PPU0.unPUR2.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR2_PUR1	(PPU0.unPUR2.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR2_PUR2	(PPU0.unPUR2.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR2_PUR3	(PPU0.unPUR2.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR2_PUR4	(PPU0.unPUR2.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR2_PUR5	(PPU0.unPUR2.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR2_PUR6	(PPU0.unPUR2.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR2_PUR7	(PPU0.unPUR2.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR2_PUR8	(PPU0.unPUR2.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR2_PUR9	(PPU0.unPUR2.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR2_PUR10	(PPU0.unPUR2.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR2_PUR11	(PPU0.unPUR2.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR2_PUR12	(PPU0.unPUR2.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR2_PUR13	(PPU0.unPUR2.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR2_PUR14	(PPU0.unPUR2.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR2_PUR15	(PPU0.unPUR2.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR2_PUR16	(PPU0.unPUR2.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR2_PUR17	(PPU0.unPUR2.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR2_PUR18	(PPU0.unPUR2.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR2_PUR19	(PPU0.unPUR2.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR2_PUR20	(PPU0.unPUR2.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR2_PUR21	(PPU0.unPUR2.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR2_PUR22	(PPU0.unPUR2.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR2_PUR23	(PPU0.unPUR2.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR2_PUR24	(PPU0.unPUR2.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR2_PUR25	(PPU0.unPUR2.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR2_PUR26	(PPU0.unPUR2.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR2_PUR27	(PPU0.unPUR2.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR2_PUR28	(PPU0.unPUR2.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR2_PUR29	(PPU0.unPUR2.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR2_PUR30	(PPU0.unPUR2.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR2_PUR31	(PPU0.unPUR2.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR3	(PPU0.unPUR3.u32Register)  /*@rg@*/
#define PPU0_PUR3_PUR0	(PPU0.unPUR3.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR3_PUR1	(PPU0.unPUR3.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR3_PUR2	(PPU0.unPUR3.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR3_PUR3	(PPU0.unPUR3.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR3_PUR4	(PPU0.unPUR3.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR3_PUR5	(PPU0.unPUR3.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR3_PUR6	(PPU0.unPUR3.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR3_PUR7	(PPU0.unPUR3.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR3_PUR8	(PPU0.unPUR3.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR3_PUR9	(PPU0.unPUR3.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR3_PUR10	(PPU0.unPUR3.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR3_PUR11	(PPU0.unPUR3.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR3_PUR12	(PPU0.unPUR3.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR3_PUR13	(PPU0.unPUR3.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR3_PUR14	(PPU0.unPUR3.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR3_PUR15	(PPU0.unPUR3.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR3_PUR16	(PPU0.unPUR3.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR3_PUR17	(PPU0.unPUR3.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR3_PUR18	(PPU0.unPUR3.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR3_PUR19	(PPU0.unPUR3.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR3_PUR20	(PPU0.unPUR3.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR3_PUR21	(PPU0.unPUR3.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR3_PUR22	(PPU0.unPUR3.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR3_PUR23	(PPU0.unPUR3.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR3_PUR24	(PPU0.unPUR3.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR3_PUR25	(PPU0.unPUR3.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR3_PUR26	(PPU0.unPUR3.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR3_PUR27	(PPU0.unPUR3.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR3_PUR28	(PPU0.unPUR3.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR3_PUR29	(PPU0.unPUR3.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR3_PUR30	(PPU0.unPUR3.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR3_PUR31	(PPU0.unPUR3.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR4	(PPU0.unPUR4.u32Register)  /*@rg@*/
#define PPU0_PUR4_PUR0	(PPU0.unPUR4.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR4_PUR1	(PPU0.unPUR4.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR4_PUR2	(PPU0.unPUR4.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR4_PUR3	(PPU0.unPUR4.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR4_PUR4	(PPU0.unPUR4.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR4_PUR5	(PPU0.unPUR4.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR4_PUR6	(PPU0.unPUR4.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR4_PUR7	(PPU0.unPUR4.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR4_PUR8	(PPU0.unPUR4.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR4_PUR9	(PPU0.unPUR4.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR4_PUR10	(PPU0.unPUR4.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR4_PUR11	(PPU0.unPUR4.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR4_PUR12	(PPU0.unPUR4.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR4_PUR13	(PPU0.unPUR4.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR4_PUR14	(PPU0.unPUR4.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR4_PUR15	(PPU0.unPUR4.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR4_PUR16	(PPU0.unPUR4.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR4_PUR17	(PPU0.unPUR4.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR4_PUR18	(PPU0.unPUR4.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR4_PUR19	(PPU0.unPUR4.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR4_PUR20	(PPU0.unPUR4.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR4_PUR21	(PPU0.unPUR4.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR4_PUR22	(PPU0.unPUR4.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR4_PUR23	(PPU0.unPUR4.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR4_PUR24	(PPU0.unPUR4.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR4_PUR25	(PPU0.unPUR4.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR4_PUR26	(PPU0.unPUR4.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR4_PUR27	(PPU0.unPUR4.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR4_PUR28	(PPU0.unPUR4.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR4_PUR29	(PPU0.unPUR4.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR4_PUR30	(PPU0.unPUR4.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR4_PUR31	(PPU0.unPUR4.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR5	(PPU0.unPUR5.u32Register)  /*@rg@*/
#define PPU0_PUR5_PUR0	(PPU0.unPUR5.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR5_PUR1	(PPU0.unPUR5.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR5_PUR2	(PPU0.unPUR5.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR5_PUR3	(PPU0.unPUR5.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR5_PUR4	(PPU0.unPUR5.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR5_PUR5	(PPU0.unPUR5.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR5_PUR6	(PPU0.unPUR5.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR5_PUR7	(PPU0.unPUR5.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR5_PUR8	(PPU0.unPUR5.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR5_PUR9	(PPU0.unPUR5.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR5_PUR10	(PPU0.unPUR5.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR5_PUR11	(PPU0.unPUR5.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR5_PUR12	(PPU0.unPUR5.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR5_PUR13	(PPU0.unPUR5.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR5_PUR14	(PPU0.unPUR5.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR5_PUR15	(PPU0.unPUR5.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR5_PUR16	(PPU0.unPUR5.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR5_PUR17	(PPU0.unPUR5.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR5_PUR18	(PPU0.unPUR5.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR5_PUR19	(PPU0.unPUR5.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR5_PUR20	(PPU0.unPUR5.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR5_PUR21	(PPU0.unPUR5.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR5_PUR22	(PPU0.unPUR5.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR5_PUR23	(PPU0.unPUR5.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR5_PUR24	(PPU0.unPUR5.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR5_PUR25	(PPU0.unPUR5.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR5_PUR26	(PPU0.unPUR5.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR5_PUR27	(PPU0.unPUR5.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR5_PUR28	(PPU0.unPUR5.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR5_PUR29	(PPU0.unPUR5.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR5_PUR30	(PPU0.unPUR5.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR5_PUR31	(PPU0.unPUR5.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR6	(PPU0.unPUR6.u32Register)  /*@rg@*/
#define PPU0_PUR6_PUR0	(PPU0.unPUR6.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR6_PUR1	(PPU0.unPUR6.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR6_PUR2	(PPU0.unPUR6.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR6_PUR3	(PPU0.unPUR6.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR6_PUR4	(PPU0.unPUR6.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR6_PUR5	(PPU0.unPUR6.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR6_PUR6	(PPU0.unPUR6.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR6_PUR7	(PPU0.unPUR6.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR6_PUR8	(PPU0.unPUR6.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR6_PUR9	(PPU0.unPUR6.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR6_PUR10	(PPU0.unPUR6.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR6_PUR11	(PPU0.unPUR6.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR6_PUR12	(PPU0.unPUR6.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR6_PUR13	(PPU0.unPUR6.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR6_PUR14	(PPU0.unPUR6.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR6_PUR15	(PPU0.unPUR6.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR6_PUR16	(PPU0.unPUR6.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR6_PUR17	(PPU0.unPUR6.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR6_PUR18	(PPU0.unPUR6.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR6_PUR19	(PPU0.unPUR6.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR6_PUR20	(PPU0.unPUR6.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR6_PUR21	(PPU0.unPUR6.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR6_PUR22	(PPU0.unPUR6.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR6_PUR23	(PPU0.unPUR6.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR6_PUR24	(PPU0.unPUR6.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR6_PUR25	(PPU0.unPUR6.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR6_PUR26	(PPU0.unPUR6.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR6_PUR27	(PPU0.unPUR6.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR6_PUR28	(PPU0.unPUR6.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR6_PUR29	(PPU0.unPUR6.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR6_PUR30	(PPU0.unPUR6.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR6_PUR31	(PPU0.unPUR6.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR7	(PPU0.unPUR7.u32Register)  /*@rg@*/
#define PPU0_PUR7_PUR0	(PPU0.unPUR7.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR7_PUR1	(PPU0.unPUR7.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR7_PUR2	(PPU0.unPUR7.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR7_PUR3	(PPU0.unPUR7.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR7_PUR4	(PPU0.unPUR7.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR7_PUR5	(PPU0.unPUR7.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR7_PUR6	(PPU0.unPUR7.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR7_PUR7	(PPU0.unPUR7.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR7_PUR8	(PPU0.unPUR7.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR7_PUR9	(PPU0.unPUR7.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR7_PUR10	(PPU0.unPUR7.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR7_PUR11	(PPU0.unPUR7.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR7_PUR12	(PPU0.unPUR7.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR7_PUR13	(PPU0.unPUR7.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR7_PUR14	(PPU0.unPUR7.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR7_PUR15	(PPU0.unPUR7.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR7_PUR16	(PPU0.unPUR7.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR7_PUR17	(PPU0.unPUR7.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR7_PUR18	(PPU0.unPUR7.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR7_PUR19	(PPU0.unPUR7.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR7_PUR20	(PPU0.unPUR7.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR7_PUR21	(PPU0.unPUR7.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR7_PUR22	(PPU0.unPUR7.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR7_PUR23	(PPU0.unPUR7.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR7_PUR24	(PPU0.unPUR7.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR7_PUR25	(PPU0.unPUR7.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR7_PUR26	(PPU0.unPUR7.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR7_PUR27	(PPU0.unPUR7.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR7_PUR28	(PPU0.unPUR7.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR7_PUR29	(PPU0.unPUR7.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR7_PUR30	(PPU0.unPUR7.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR7_PUR31	(PPU0.unPUR7.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR8	(PPU0.unPUR8.u32Register)  /*@rg@*/
#define PPU0_PUR8_PUR0	(PPU0.unPUR8.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR8_PUR1	(PPU0.unPUR8.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR8_PUR2	(PPU0.unPUR8.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR8_PUR3	(PPU0.unPUR8.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR8_PUR4	(PPU0.unPUR8.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR8_PUR5	(PPU0.unPUR8.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR8_PUR6	(PPU0.unPUR8.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR8_PUR7	(PPU0.unPUR8.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR8_PUR8	(PPU0.unPUR8.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR8_PUR9	(PPU0.unPUR8.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR8_PUR10	(PPU0.unPUR8.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR8_PUR11	(PPU0.unPUR8.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR8_PUR12	(PPU0.unPUR8.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR8_PUR13	(PPU0.unPUR8.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR8_PUR14	(PPU0.unPUR8.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR8_PUR15	(PPU0.unPUR8.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR8_PUR16	(PPU0.unPUR8.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR8_PUR17	(PPU0.unPUR8.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR8_PUR18	(PPU0.unPUR8.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR8_PUR19	(PPU0.unPUR8.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR8_PUR20	(PPU0.unPUR8.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR8_PUR21	(PPU0.unPUR8.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR8_PUR22	(PPU0.unPUR8.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR8_PUR23	(PPU0.unPUR8.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR8_PUR24	(PPU0.unPUR8.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR8_PUR25	(PPU0.unPUR8.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR8_PUR26	(PPU0.unPUR8.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR8_PUR27	(PPU0.unPUR8.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR8_PUR28	(PPU0.unPUR8.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR8_PUR29	(PPU0.unPUR8.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR8_PUR30	(PPU0.unPUR8.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR8_PUR31	(PPU0.unPUR8.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR9	(PPU0.unPUR9.u32Register)  /*@rg@*/
#define PPU0_PUR9_PUR0	(PPU0.unPUR9.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR9_PUR1	(PPU0.unPUR9.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR9_PUR2	(PPU0.unPUR9.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR9_PUR3	(PPU0.unPUR9.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR9_PUR4	(PPU0.unPUR9.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR9_PUR5	(PPU0.unPUR9.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR9_PUR6	(PPU0.unPUR9.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR9_PUR7	(PPU0.unPUR9.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR9_PUR8	(PPU0.unPUR9.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR9_PUR9	(PPU0.unPUR9.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR9_PUR10	(PPU0.unPUR9.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR9_PUR11	(PPU0.unPUR9.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR9_PUR12	(PPU0.unPUR9.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR9_PUR13	(PPU0.unPUR9.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR9_PUR14	(PPU0.unPUR9.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR9_PUR15	(PPU0.unPUR9.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR9_PUR16	(PPU0.unPUR9.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR9_PUR17	(PPU0.unPUR9.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR9_PUR18	(PPU0.unPUR9.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR9_PUR19	(PPU0.unPUR9.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR9_PUR20	(PPU0.unPUR9.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR9_PUR21	(PPU0.unPUR9.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR9_PUR22	(PPU0.unPUR9.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR9_PUR23	(PPU0.unPUR9.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR9_PUR24	(PPU0.unPUR9.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR9_PUR25	(PPU0.unPUR9.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR9_PUR26	(PPU0.unPUR9.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR9_PUR27	(PPU0.unPUR9.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR9_PUR28	(PPU0.unPUR9.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR9_PUR29	(PPU0.unPUR9.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR9_PUR30	(PPU0.unPUR9.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR9_PUR31	(PPU0.unPUR9.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR10	(PPU0.unPUR10.u32Register)  /*@rg@*/
#define PPU0_PUR10_PUR0	(PPU0.unPUR10.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR10_PUR1	(PPU0.unPUR10.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR10_PUR2	(PPU0.unPUR10.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR10_PUR3	(PPU0.unPUR10.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR10_PUR4	(PPU0.unPUR10.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR10_PUR5	(PPU0.unPUR10.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR10_PUR6	(PPU0.unPUR10.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR10_PUR7	(PPU0.unPUR10.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR10_PUR8	(PPU0.unPUR10.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR10_PUR9	(PPU0.unPUR10.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR10_PUR10	(PPU0.unPUR10.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR10_PUR11	(PPU0.unPUR10.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR10_PUR12	(PPU0.unPUR10.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR10_PUR13	(PPU0.unPUR10.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR10_PUR14	(PPU0.unPUR10.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR10_PUR15	(PPU0.unPUR10.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR10_PUR16	(PPU0.unPUR10.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR10_PUR17	(PPU0.unPUR10.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR10_PUR18	(PPU0.unPUR10.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR10_PUR19	(PPU0.unPUR10.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR10_PUR20	(PPU0.unPUR10.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR10_PUR21	(PPU0.unPUR10.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR10_PUR22	(PPU0.unPUR10.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR10_PUR23	(PPU0.unPUR10.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR10_PUR24	(PPU0.unPUR10.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR10_PUR25	(PPU0.unPUR10.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR10_PUR26	(PPU0.unPUR10.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR10_PUR27	(PPU0.unPUR10.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR10_PUR28	(PPU0.unPUR10.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR10_PUR29	(PPU0.unPUR10.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR10_PUR30	(PPU0.unPUR10.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR10_PUR31	(PPU0.unPUR10.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR11	(PPU0.unPUR11.u32Register)  /*@rg@*/
#define PPU0_PUR11_PUR0	(PPU0.unPUR11.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR11_PUR1	(PPU0.unPUR11.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR11_PUR2	(PPU0.unPUR11.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR11_PUR3	(PPU0.unPUR11.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR11_PUR4	(PPU0.unPUR11.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR11_PUR5	(PPU0.unPUR11.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR11_PUR6	(PPU0.unPUR11.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR11_PUR7	(PPU0.unPUR11.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR11_PUR8	(PPU0.unPUR11.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR11_PUR9	(PPU0.unPUR11.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR11_PUR10	(PPU0.unPUR11.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR11_PUR11	(PPU0.unPUR11.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR11_PUR12	(PPU0.unPUR11.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR11_PUR13	(PPU0.unPUR11.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR11_PUR14	(PPU0.unPUR11.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR11_PUR15	(PPU0.unPUR11.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR11_PUR16	(PPU0.unPUR11.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR11_PUR17	(PPU0.unPUR11.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR11_PUR18	(PPU0.unPUR11.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR11_PUR19	(PPU0.unPUR11.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR11_PUR20	(PPU0.unPUR11.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR11_PUR21	(PPU0.unPUR11.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR11_PUR22	(PPU0.unPUR11.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR11_PUR23	(PPU0.unPUR11.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR11_PUR24	(PPU0.unPUR11.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR11_PUR25	(PPU0.unPUR11.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR11_PUR26	(PPU0.unPUR11.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR11_PUR27	(PPU0.unPUR11.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR11_PUR28	(PPU0.unPUR11.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR11_PUR29	(PPU0.unPUR11.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR11_PUR30	(PPU0.unPUR11.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR11_PUR31	(PPU0.unPUR11.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR12	(PPU0.unPUR12.u32Register)  /*@rg@*/
#define PPU0_PUR12_PUR0	(PPU0.unPUR12.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR12_PUR1	(PPU0.unPUR12.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR12_PUR2	(PPU0.unPUR12.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR12_PUR3	(PPU0.unPUR12.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR12_PUR4	(PPU0.unPUR12.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR12_PUR5	(PPU0.unPUR12.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR12_PUR6	(PPU0.unPUR12.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR12_PUR7	(PPU0.unPUR12.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR12_PUR8	(PPU0.unPUR12.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR12_PUR9	(PPU0.unPUR12.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR12_PUR10	(PPU0.unPUR12.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR12_PUR11	(PPU0.unPUR12.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR12_PUR12	(PPU0.unPUR12.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR12_PUR13	(PPU0.unPUR12.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR12_PUR14	(PPU0.unPUR12.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR12_PUR15	(PPU0.unPUR12.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR12_PUR16	(PPU0.unPUR12.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR12_PUR17	(PPU0.unPUR12.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR12_PUR18	(PPU0.unPUR12.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR12_PUR19	(PPU0.unPUR12.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR12_PUR20	(PPU0.unPUR12.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR12_PUR21	(PPU0.unPUR12.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR12_PUR22	(PPU0.unPUR12.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR12_PUR23	(PPU0.unPUR12.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR12_PUR24	(PPU0.unPUR12.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR12_PUR25	(PPU0.unPUR12.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR12_PUR26	(PPU0.unPUR12.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR12_PUR27	(PPU0.unPUR12.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR12_PUR28	(PPU0.unPUR12.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR12_PUR29	(PPU0.unPUR12.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR12_PUR30	(PPU0.unPUR12.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR12_PUR31	(PPU0.unPUR12.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR13	(PPU0.unPUR13.u32Register)  /*@rg@*/
#define PPU0_PUR13_PUR0	(PPU0.unPUR13.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR13_PUR1	(PPU0.unPUR13.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR13_PUR2	(PPU0.unPUR13.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR13_PUR3	(PPU0.unPUR13.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR13_PUR4	(PPU0.unPUR13.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR13_PUR5	(PPU0.unPUR13.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR13_PUR6	(PPU0.unPUR13.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR13_PUR7	(PPU0.unPUR13.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR13_PUR8	(PPU0.unPUR13.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR13_PUR9	(PPU0.unPUR13.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR13_PUR10	(PPU0.unPUR13.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR13_PUR11	(PPU0.unPUR13.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR13_PUR12	(PPU0.unPUR13.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR13_PUR13	(PPU0.unPUR13.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR13_PUR14	(PPU0.unPUR13.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR13_PUR15	(PPU0.unPUR13.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR13_PUR16	(PPU0.unPUR13.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR13_PUR17	(PPU0.unPUR13.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR13_PUR18	(PPU0.unPUR13.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR13_PUR19	(PPU0.unPUR13.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR13_PUR20	(PPU0.unPUR13.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR13_PUR21	(PPU0.unPUR13.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR13_PUR22	(PPU0.unPUR13.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR13_PUR23	(PPU0.unPUR13.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR13_PUR24	(PPU0.unPUR13.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR13_PUR25	(PPU0.unPUR13.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR13_PUR26	(PPU0.unPUR13.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR13_PUR27	(PPU0.unPUR13.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR13_PUR28	(PPU0.unPUR13.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR13_PUR29	(PPU0.unPUR13.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR13_PUR30	(PPU0.unPUR13.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR13_PUR31	(PPU0.unPUR13.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR14	(PPU0.unPUR14.u32Register)  /*@rg@*/
#define PPU0_PUR14_PUR0	(PPU0.unPUR14.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR14_PUR1	(PPU0.unPUR14.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR14_PUR2	(PPU0.unPUR14.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR14_PUR3	(PPU0.unPUR14.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR14_PUR4	(PPU0.unPUR14.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR14_PUR5	(PPU0.unPUR14.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR14_PUR6	(PPU0.unPUR14.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR14_PUR7	(PPU0.unPUR14.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR14_PUR8	(PPU0.unPUR14.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR14_PUR9	(PPU0.unPUR14.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR14_PUR10	(PPU0.unPUR14.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR14_PUR11	(PPU0.unPUR14.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR14_PUR12	(PPU0.unPUR14.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR14_PUR13	(PPU0.unPUR14.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR14_PUR14	(PPU0.unPUR14.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR14_PUR15	(PPU0.unPUR14.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR14_PUR16	(PPU0.unPUR14.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR14_PUR17	(PPU0.unPUR14.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR14_PUR18	(PPU0.unPUR14.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR14_PUR19	(PPU0.unPUR14.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR14_PUR20	(PPU0.unPUR14.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR14_PUR21	(PPU0.unPUR14.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR14_PUR22	(PPU0.unPUR14.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR14_PUR23	(PPU0.unPUR14.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR14_PUR24	(PPU0.unPUR14.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR14_PUR25	(PPU0.unPUR14.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR14_PUR26	(PPU0.unPUR14.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR14_PUR27	(PPU0.unPUR14.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR14_PUR28	(PPU0.unPUR14.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR14_PUR29	(PPU0.unPUR14.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR14_PUR30	(PPU0.unPUR14.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR14_PUR31	(PPU0.unPUR14.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR15	(PPU0.unPUR15.u32Register)  /*@rg@*/
#define PPU0_PUR15_PUR0	(PPU0.unPUR15.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR15_PUR1	(PPU0.unPUR15.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR15_PUR2	(PPU0.unPUR15.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR15_PUR3	(PPU0.unPUR15.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR15_PUR4	(PPU0.unPUR15.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR15_PUR5	(PPU0.unPUR15.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR15_PUR6	(PPU0.unPUR15.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR15_PUR7	(PPU0.unPUR15.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR15_PUR8	(PPU0.unPUR15.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR15_PUR9	(PPU0.unPUR15.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR15_PUR10	(PPU0.unPUR15.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR15_PUR11	(PPU0.unPUR15.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR15_PUR12	(PPU0.unPUR15.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR15_PUR13	(PPU0.unPUR15.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR15_PUR14	(PPU0.unPUR15.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR15_PUR15	(PPU0.unPUR15.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR15_PUR16	(PPU0.unPUR15.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR15_PUR17	(PPU0.unPUR15.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR15_PUR18	(PPU0.unPUR15.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR15_PUR19	(PPU0.unPUR15.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR15_PUR20	(PPU0.unPUR15.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR15_PUR21	(PPU0.unPUR15.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR15_PUR22	(PPU0.unPUR15.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR15_PUR23	(PPU0.unPUR15.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR15_PUR24	(PPU0.unPUR15.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR15_PUR25	(PPU0.unPUR15.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR15_PUR26	(PPU0.unPUR15.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR15_PUR27	(PPU0.unPUR15.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR15_PUR28	(PPU0.unPUR15.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR15_PUR29	(PPU0.unPUR15.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR15_PUR30	(PPU0.unPUR15.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR15_PUR31	(PPU0.unPUR15.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR16	(PPU0.unPUR16.u32Register)  /*@rg@*/
#define PPU0_PUR16_PUR0	(PPU0.unPUR16.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR16_PUR1	(PPU0.unPUR16.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR16_PUR2	(PPU0.unPUR16.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR16_PUR3	(PPU0.unPUR16.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR16_PUR4	(PPU0.unPUR16.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR16_PUR5	(PPU0.unPUR16.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR16_PUR6	(PPU0.unPUR16.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR16_PUR7	(PPU0.unPUR16.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR16_PUR8	(PPU0.unPUR16.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR16_PUR9	(PPU0.unPUR16.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR16_PUR10	(PPU0.unPUR16.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR16_PUR11	(PPU0.unPUR16.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR16_PUR12	(PPU0.unPUR16.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR16_PUR13	(PPU0.unPUR16.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR16_PUR14	(PPU0.unPUR16.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR16_PUR15	(PPU0.unPUR16.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR16_PUR16	(PPU0.unPUR16.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR16_PUR17	(PPU0.unPUR16.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR16_PUR18	(PPU0.unPUR16.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR16_PUR19	(PPU0.unPUR16.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR16_PUR20	(PPU0.unPUR16.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR16_PUR21	(PPU0.unPUR16.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR16_PUR22	(PPU0.unPUR16.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR16_PUR23	(PPU0.unPUR16.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR16_PUR24	(PPU0.unPUR16.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR16_PUR25	(PPU0.unPUR16.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR16_PUR26	(PPU0.unPUR16.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR16_PUR27	(PPU0.unPUR16.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR16_PUR28	(PPU0.unPUR16.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR16_PUR29	(PPU0.unPUR16.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR16_PUR30	(PPU0.unPUR16.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR16_PUR31	(PPU0.unPUR16.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR17	(PPU0.unPUR17.u32Register)  /*@rg@*/
#define PPU0_PUR17_PUR0	(PPU0.unPUR17.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR17_PUR1	(PPU0.unPUR17.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR17_PUR2	(PPU0.unPUR17.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR17_PUR3	(PPU0.unPUR17.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR17_PUR4	(PPU0.unPUR17.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR17_PUR5	(PPU0.unPUR17.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR17_PUR6	(PPU0.unPUR17.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR17_PUR7	(PPU0.unPUR17.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR17_PUR8	(PPU0.unPUR17.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR17_PUR9	(PPU0.unPUR17.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR17_PUR10	(PPU0.unPUR17.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR17_PUR11	(PPU0.unPUR17.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR17_PUR12	(PPU0.unPUR17.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR17_PUR13	(PPU0.unPUR17.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR17_PUR14	(PPU0.unPUR17.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR17_PUR15	(PPU0.unPUR17.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR17_PUR16	(PPU0.unPUR17.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR17_PUR17	(PPU0.unPUR17.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR17_PUR18	(PPU0.unPUR17.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR17_PUR19	(PPU0.unPUR17.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR17_PUR20	(PPU0.unPUR17.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR17_PUR21	(PPU0.unPUR17.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR17_PUR22	(PPU0.unPUR17.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR17_PUR23	(PPU0.unPUR17.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR17_PUR24	(PPU0.unPUR17.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR17_PUR25	(PPU0.unPUR17.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR17_PUR26	(PPU0.unPUR17.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR17_PUR27	(PPU0.unPUR17.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR17_PUR28	(PPU0.unPUR17.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR17_PUR29	(PPU0.unPUR17.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR17_PUR30	(PPU0.unPUR17.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR17_PUR31	(PPU0.unPUR17.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR18	(PPU0.unPUR18.u32Register)  /*@rg@*/
#define PPU0_PUR18_PUR0	(PPU0.unPUR18.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR18_PUR1	(PPU0.unPUR18.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR18_PUR2	(PPU0.unPUR18.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR18_PUR3	(PPU0.unPUR18.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR18_PUR4	(PPU0.unPUR18.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR18_PUR5	(PPU0.unPUR18.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR18_PUR6	(PPU0.unPUR18.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR18_PUR7	(PPU0.unPUR18.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR18_PUR8	(PPU0.unPUR18.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR18_PUR9	(PPU0.unPUR18.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR18_PUR10	(PPU0.unPUR18.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR18_PUR11	(PPU0.unPUR18.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR18_PUR12	(PPU0.unPUR18.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR18_PUR13	(PPU0.unPUR18.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR18_PUR14	(PPU0.unPUR18.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR18_PUR15	(PPU0.unPUR18.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR18_PUR16	(PPU0.unPUR18.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR18_PUR17	(PPU0.unPUR18.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR18_PUR18	(PPU0.unPUR18.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR18_PUR19	(PPU0.unPUR18.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR18_PUR20	(PPU0.unPUR18.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR18_PUR21	(PPU0.unPUR18.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR18_PUR22	(PPU0.unPUR18.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR18_PUR23	(PPU0.unPUR18.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR18_PUR24	(PPU0.unPUR18.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR18_PUR25	(PPU0.unPUR18.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR18_PUR26	(PPU0.unPUR18.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR18_PUR27	(PPU0.unPUR18.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR18_PUR28	(PPU0.unPUR18.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR18_PUR29	(PPU0.unPUR18.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR18_PUR30	(PPU0.unPUR18.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR18_PUR31	(PPU0.unPUR18.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR19	(PPU0.unPUR19.u32Register)  /*@rg@*/
#define PPU0_PUR19_PUR0	(PPU0.unPUR19.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR19_PUR1	(PPU0.unPUR19.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR19_PUR2	(PPU0.unPUR19.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR19_PUR3	(PPU0.unPUR19.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR19_PUR4	(PPU0.unPUR19.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR19_PUR5	(PPU0.unPUR19.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR19_PUR6	(PPU0.unPUR19.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR19_PUR7	(PPU0.unPUR19.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR19_PUR8	(PPU0.unPUR19.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR19_PUR9	(PPU0.unPUR19.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR19_PUR10	(PPU0.unPUR19.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR19_PUR11	(PPU0.unPUR19.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR19_PUR12	(PPU0.unPUR19.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR19_PUR13	(PPU0.unPUR19.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR19_PUR14	(PPU0.unPUR19.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR19_PUR15	(PPU0.unPUR19.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR19_PUR16	(PPU0.unPUR19.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR19_PUR17	(PPU0.unPUR19.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR19_PUR18	(PPU0.unPUR19.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR19_PUR19	(PPU0.unPUR19.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR19_PUR20	(PPU0.unPUR19.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR19_PUR21	(PPU0.unPUR19.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR19_PUR22	(PPU0.unPUR19.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR19_PUR23	(PPU0.unPUR19.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR19_PUR24	(PPU0.unPUR19.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR19_PUR25	(PPU0.unPUR19.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR19_PUR26	(PPU0.unPUR19.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR19_PUR27	(PPU0.unPUR19.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR19_PUR28	(PPU0.unPUR19.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR19_PUR29	(PPU0.unPUR19.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR19_PUR30	(PPU0.unPUR19.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR19_PUR31	(PPU0.unPUR19.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR20	(PPU0.unPUR20.u32Register)  /*@rg@*/
#define PPU0_PUR20_PUR0	(PPU0.unPUR20.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR20_PUR1	(PPU0.unPUR20.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR20_PUR2	(PPU0.unPUR20.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR20_PUR3	(PPU0.unPUR20.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR20_PUR4	(PPU0.unPUR20.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR20_PUR5	(PPU0.unPUR20.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR20_PUR6	(PPU0.unPUR20.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR20_PUR7	(PPU0.unPUR20.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR20_PUR8	(PPU0.unPUR20.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR20_PUR9	(PPU0.unPUR20.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR20_PUR10	(PPU0.unPUR20.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR20_PUR11	(PPU0.unPUR20.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR20_PUR12	(PPU0.unPUR20.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR20_PUR13	(PPU0.unPUR20.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR20_PUR14	(PPU0.unPUR20.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR20_PUR15	(PPU0.unPUR20.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR20_PUR16	(PPU0.unPUR20.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR20_PUR17	(PPU0.unPUR20.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR20_PUR18	(PPU0.unPUR20.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR20_PUR19	(PPU0.unPUR20.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR20_PUR20	(PPU0.unPUR20.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR20_PUR21	(PPU0.unPUR20.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR20_PUR22	(PPU0.unPUR20.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR20_PUR23	(PPU0.unPUR20.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR20_PUR24	(PPU0.unPUR20.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR20_PUR25	(PPU0.unPUR20.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR20_PUR26	(PPU0.unPUR20.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR20_PUR27	(PPU0.unPUR20.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR20_PUR28	(PPU0.unPUR20.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR20_PUR29	(PPU0.unPUR20.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR20_PUR30	(PPU0.unPUR20.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR20_PUR31	(PPU0.unPUR20.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR21	(PPU0.unPUR21.u32Register)  /*@rg@*/
#define PPU0_PUR21_PUR0	(PPU0.unPUR21.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR21_PUR1	(PPU0.unPUR21.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR21_PUR2	(PPU0.unPUR21.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR21_PUR3	(PPU0.unPUR21.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR21_PUR4	(PPU0.unPUR21.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR21_PUR5	(PPU0.unPUR21.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR21_PUR6	(PPU0.unPUR21.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR21_PUR7	(PPU0.unPUR21.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR21_PUR8	(PPU0.unPUR21.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR21_PUR9	(PPU0.unPUR21.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR21_PUR10	(PPU0.unPUR21.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR21_PUR11	(PPU0.unPUR21.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR21_PUR12	(PPU0.unPUR21.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR21_PUR13	(PPU0.unPUR21.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR21_PUR14	(PPU0.unPUR21.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR21_PUR15	(PPU0.unPUR21.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR21_PUR16	(PPU0.unPUR21.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR21_PUR17	(PPU0.unPUR21.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR21_PUR18	(PPU0.unPUR21.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR21_PUR19	(PPU0.unPUR21.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR21_PUR20	(PPU0.unPUR21.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR21_PUR21	(PPU0.unPUR21.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR21_PUR22	(PPU0.unPUR21.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR21_PUR23	(PPU0.unPUR21.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR21_PUR24	(PPU0.unPUR21.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR21_PUR25	(PPU0.unPUR21.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR21_PUR26	(PPU0.unPUR21.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR21_PUR27	(PPU0.unPUR21.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR21_PUR28	(PPU0.unPUR21.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR21_PUR29	(PPU0.unPUR21.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR21_PUR30	(PPU0.unPUR21.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR21_PUR31	(PPU0.unPUR21.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR22	(PPU0.unPUR22.u32Register)  /*@rg@*/
#define PPU0_PUR22_PUR0	(PPU0.unPUR22.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR22_PUR1	(PPU0.unPUR22.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR22_PUR2	(PPU0.unPUR22.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR22_PUR3	(PPU0.unPUR22.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR22_PUR4	(PPU0.unPUR22.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR22_PUR5	(PPU0.unPUR22.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR22_PUR6	(PPU0.unPUR22.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR22_PUR7	(PPU0.unPUR22.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR22_PUR8	(PPU0.unPUR22.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR22_PUR9	(PPU0.unPUR22.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR22_PUR10	(PPU0.unPUR22.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR22_PUR11	(PPU0.unPUR22.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR22_PUR12	(PPU0.unPUR22.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR22_PUR13	(PPU0.unPUR22.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR22_PUR14	(PPU0.unPUR22.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR22_PUR15	(PPU0.unPUR22.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR22_PUR16	(PPU0.unPUR22.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR22_PUR17	(PPU0.unPUR22.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR22_PUR18	(PPU0.unPUR22.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR22_PUR19	(PPU0.unPUR22.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR22_PUR20	(PPU0.unPUR22.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR22_PUR21	(PPU0.unPUR22.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR22_PUR22	(PPU0.unPUR22.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR22_PUR23	(PPU0.unPUR22.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR22_PUR24	(PPU0.unPUR22.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR22_PUR25	(PPU0.unPUR22.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR22_PUR26	(PPU0.unPUR22.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR22_PUR27	(PPU0.unPUR22.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR22_PUR28	(PPU0.unPUR22.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR22_PUR29	(PPU0.unPUR22.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR22_PUR30	(PPU0.unPUR22.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR22_PUR31	(PPU0.unPUR22.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR23	(PPU0.unPUR23.u32Register)  /*@rg@*/
#define PPU0_PUR23_PUR0	(PPU0.unPUR23.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR23_PUR1	(PPU0.unPUR23.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR23_PUR2	(PPU0.unPUR23.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR23_PUR3	(PPU0.unPUR23.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR23_PUR4	(PPU0.unPUR23.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR23_PUR5	(PPU0.unPUR23.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR23_PUR6	(PPU0.unPUR23.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR23_PUR7	(PPU0.unPUR23.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR23_PUR8	(PPU0.unPUR23.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR23_PUR9	(PPU0.unPUR23.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR23_PUR10	(PPU0.unPUR23.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR23_PUR11	(PPU0.unPUR23.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR23_PUR12	(PPU0.unPUR23.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR23_PUR13	(PPU0.unPUR23.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR23_PUR14	(PPU0.unPUR23.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR23_PUR15	(PPU0.unPUR23.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR23_PUR16	(PPU0.unPUR23.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR23_PUR17	(PPU0.unPUR23.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR23_PUR18	(PPU0.unPUR23.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR23_PUR19	(PPU0.unPUR23.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR23_PUR20	(PPU0.unPUR23.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR23_PUR21	(PPU0.unPUR23.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR23_PUR22	(PPU0.unPUR23.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR23_PUR23	(PPU0.unPUR23.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR23_PUR24	(PPU0.unPUR23.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR23_PUR25	(PPU0.unPUR23.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR23_PUR26	(PPU0.unPUR23.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR23_PUR27	(PPU0.unPUR23.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR23_PUR28	(PPU0.unPUR23.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR23_PUR29	(PPU0.unPUR23.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR23_PUR30	(PPU0.unPUR23.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR23_PUR31	(PPU0.unPUR23.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR24	(PPU0.unPUR24.u32Register)  /*@rg@*/
#define PPU0_PUR24_PUR0	(PPU0.unPUR24.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR24_PUR1	(PPU0.unPUR24.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR24_PUR2	(PPU0.unPUR24.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR24_PUR3	(PPU0.unPUR24.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR24_PUR4	(PPU0.unPUR24.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR24_PUR5	(PPU0.unPUR24.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR24_PUR6	(PPU0.unPUR24.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR24_PUR7	(PPU0.unPUR24.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR24_PUR8	(PPU0.unPUR24.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR24_PUR9	(PPU0.unPUR24.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR24_PUR10	(PPU0.unPUR24.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR24_PUR11	(PPU0.unPUR24.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR24_PUR12	(PPU0.unPUR24.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR24_PUR13	(PPU0.unPUR24.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR24_PUR14	(PPU0.unPUR24.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR24_PUR15	(PPU0.unPUR24.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR24_PUR16	(PPU0.unPUR24.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR24_PUR17	(PPU0.unPUR24.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR24_PUR18	(PPU0.unPUR24.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR24_PUR19	(PPU0.unPUR24.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR24_PUR20	(PPU0.unPUR24.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR24_PUR21	(PPU0.unPUR24.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR24_PUR22	(PPU0.unPUR24.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR24_PUR23	(PPU0.unPUR24.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR24_PUR24	(PPU0.unPUR24.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR24_PUR25	(PPU0.unPUR24.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR24_PUR26	(PPU0.unPUR24.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR24_PUR27	(PPU0.unPUR24.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR24_PUR28	(PPU0.unPUR24.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR24_PUR29	(PPU0.unPUR24.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR24_PUR30	(PPU0.unPUR24.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR24_PUR31	(PPU0.unPUR24.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR25	(PPU0.unPUR25.u32Register)  /*@rg@*/
#define PPU0_PUR25_PUR0	(PPU0.unPUR25.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR25_PUR1	(PPU0.unPUR25.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR25_PUR2	(PPU0.unPUR25.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR25_PUR3	(PPU0.unPUR25.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR25_PUR4	(PPU0.unPUR25.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR25_PUR5	(PPU0.unPUR25.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR25_PUR6	(PPU0.unPUR25.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR25_PUR7	(PPU0.unPUR25.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR25_PUR8	(PPU0.unPUR25.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR25_PUR9	(PPU0.unPUR25.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR25_PUR10	(PPU0.unPUR25.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR25_PUR11	(PPU0.unPUR25.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR25_PUR12	(PPU0.unPUR25.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR25_PUR13	(PPU0.unPUR25.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR25_PUR14	(PPU0.unPUR25.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR25_PUR15	(PPU0.unPUR25.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR25_PUR16	(PPU0.unPUR25.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR25_PUR17	(PPU0.unPUR25.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR25_PUR18	(PPU0.unPUR25.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR25_PUR19	(PPU0.unPUR25.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR25_PUR20	(PPU0.unPUR25.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR25_PUR21	(PPU0.unPUR25.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR25_PUR22	(PPU0.unPUR25.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR25_PUR23	(PPU0.unPUR25.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR25_PUR24	(PPU0.unPUR25.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR25_PUR25	(PPU0.unPUR25.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR25_PUR26	(PPU0.unPUR25.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR25_PUR27	(PPU0.unPUR25.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR25_PUR28	(PPU0.unPUR25.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR25_PUR29	(PPU0.unPUR25.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR25_PUR30	(PPU0.unPUR25.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR25_PUR31	(PPU0.unPUR25.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR26	(PPU0.unPUR26.u32Register)  /*@rg@*/
#define PPU0_PUR26_PUR0	(PPU0.unPUR26.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR26_PUR1	(PPU0.unPUR26.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR26_PUR2	(PPU0.unPUR26.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR26_PUR3	(PPU0.unPUR26.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR26_PUR4	(PPU0.unPUR26.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR26_PUR5	(PPU0.unPUR26.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR26_PUR6	(PPU0.unPUR26.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR26_PUR7	(PPU0.unPUR26.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR26_PUR8	(PPU0.unPUR26.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR26_PUR9	(PPU0.unPUR26.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR26_PUR10	(PPU0.unPUR26.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR26_PUR11	(PPU0.unPUR26.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR26_PUR12	(PPU0.unPUR26.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR26_PUR13	(PPU0.unPUR26.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR26_PUR14	(PPU0.unPUR26.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR26_PUR15	(PPU0.unPUR26.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR26_PUR16	(PPU0.unPUR26.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR26_PUR17	(PPU0.unPUR26.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR26_PUR18	(PPU0.unPUR26.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR26_PUR19	(PPU0.unPUR26.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR26_PUR20	(PPU0.unPUR26.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR26_PUR21	(PPU0.unPUR26.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR26_PUR22	(PPU0.unPUR26.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR26_PUR23	(PPU0.unPUR26.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR26_PUR24	(PPU0.unPUR26.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR26_PUR25	(PPU0.unPUR26.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR26_PUR26	(PPU0.unPUR26.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR26_PUR27	(PPU0.unPUR26.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR26_PUR28	(PPU0.unPUR26.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR26_PUR29	(PPU0.unPUR26.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR26_PUR30	(PPU0.unPUR26.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR26_PUR31	(PPU0.unPUR26.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR27	(PPU0.unPUR27.u32Register)  /*@rg@*/
#define PPU0_PUR27_PUR0	(PPU0.unPUR27.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR27_PUR1	(PPU0.unPUR27.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR27_PUR2	(PPU0.unPUR27.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR27_PUR3	(PPU0.unPUR27.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR27_PUR4	(PPU0.unPUR27.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR27_PUR5	(PPU0.unPUR27.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR27_PUR6	(PPU0.unPUR27.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR27_PUR7	(PPU0.unPUR27.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR27_PUR8	(PPU0.unPUR27.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR27_PUR9	(PPU0.unPUR27.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR27_PUR10	(PPU0.unPUR27.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR27_PUR11	(PPU0.unPUR27.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR27_PUR12	(PPU0.unPUR27.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR27_PUR13	(PPU0.unPUR27.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR27_PUR14	(PPU0.unPUR27.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR27_PUR15	(PPU0.unPUR27.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR27_PUR16	(PPU0.unPUR27.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR27_PUR17	(PPU0.unPUR27.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR27_PUR18	(PPU0.unPUR27.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR27_PUR19	(PPU0.unPUR27.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR27_PUR20	(PPU0.unPUR27.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR27_PUR21	(PPU0.unPUR27.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR27_PUR22	(PPU0.unPUR27.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR27_PUR23	(PPU0.unPUR27.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR27_PUR24	(PPU0.unPUR27.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR27_PUR25	(PPU0.unPUR27.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR27_PUR26	(PPU0.unPUR27.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR27_PUR27	(PPU0.unPUR27.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR27_PUR28	(PPU0.unPUR27.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR27_PUR29	(PPU0.unPUR27.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR27_PUR30	(PPU0.unPUR27.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR27_PUR31	(PPU0.unPUR27.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR28	(PPU0.unPUR28.u32Register)  /*@rg@*/
#define PPU0_PUR28_PUR0	(PPU0.unPUR28.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR28_PUR1	(PPU0.unPUR28.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR28_PUR2	(PPU0.unPUR28.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR28_PUR3	(PPU0.unPUR28.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR28_PUR4	(PPU0.unPUR28.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR28_PUR5	(PPU0.unPUR28.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR28_PUR6	(PPU0.unPUR28.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR28_PUR7	(PPU0.unPUR28.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR28_PUR8	(PPU0.unPUR28.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR28_PUR9	(PPU0.unPUR28.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR28_PUR10	(PPU0.unPUR28.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR28_PUR11	(PPU0.unPUR28.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR28_PUR12	(PPU0.unPUR28.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR28_PUR13	(PPU0.unPUR28.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR28_PUR14	(PPU0.unPUR28.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR28_PUR15	(PPU0.unPUR28.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR28_PUR16	(PPU0.unPUR28.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR28_PUR17	(PPU0.unPUR28.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR28_PUR18	(PPU0.unPUR28.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR28_PUR19	(PPU0.unPUR28.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR28_PUR20	(PPU0.unPUR28.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR28_PUR21	(PPU0.unPUR28.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR28_PUR22	(PPU0.unPUR28.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR28_PUR23	(PPU0.unPUR28.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR28_PUR24	(PPU0.unPUR28.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR28_PUR25	(PPU0.unPUR28.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR28_PUR26	(PPU0.unPUR28.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR28_PUR27	(PPU0.unPUR28.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR28_PUR28	(PPU0.unPUR28.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR28_PUR29	(PPU0.unPUR28.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR28_PUR30	(PPU0.unPUR28.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR28_PUR31	(PPU0.unPUR28.stcField.u1PUR31)  /*@bf@*/

#define PPU0_PUR29	(PPU0.unPUR29.u32Register)  /*@rg@*/
#define PPU0_PUR29_PUR0	(PPU0.unPUR29.stcField.u1PUR0)  /*@bf@*/
#define PPU0_PUR29_PUR1	(PPU0.unPUR29.stcField.u1PUR1)  /*@bf@*/
#define PPU0_PUR29_PUR2	(PPU0.unPUR29.stcField.u1PUR2)  /*@bf@*/
#define PPU0_PUR29_PUR3	(PPU0.unPUR29.stcField.u1PUR3)  /*@bf@*/
#define PPU0_PUR29_PUR4	(PPU0.unPUR29.stcField.u1PUR4)  /*@bf@*/
#define PPU0_PUR29_PUR5	(PPU0.unPUR29.stcField.u1PUR5)  /*@bf@*/
#define PPU0_PUR29_PUR6	(PPU0.unPUR29.stcField.u1PUR6)  /*@bf@*/
#define PPU0_PUR29_PUR7	(PPU0.unPUR29.stcField.u1PUR7)  /*@bf@*/
#define PPU0_PUR29_PUR8	(PPU0.unPUR29.stcField.u1PUR8)  /*@bf@*/
#define PPU0_PUR29_PUR9	(PPU0.unPUR29.stcField.u1PUR9)  /*@bf@*/
#define PPU0_PUR29_PUR10	(PPU0.unPUR29.stcField.u1PUR10)  /*@bf@*/
#define PPU0_PUR29_PUR11	(PPU0.unPUR29.stcField.u1PUR11)  /*@bf@*/
#define PPU0_PUR29_PUR12	(PPU0.unPUR29.stcField.u1PUR12)  /*@bf@*/
#define PPU0_PUR29_PUR13	(PPU0.unPUR29.stcField.u1PUR13)  /*@bf@*/
#define PPU0_PUR29_PUR14	(PPU0.unPUR29.stcField.u1PUR14)  /*@bf@*/
#define PPU0_PUR29_PUR15	(PPU0.unPUR29.stcField.u1PUR15)  /*@bf@*/
#define PPU0_PUR29_PUR16	(PPU0.unPUR29.stcField.u1PUR16)  /*@bf@*/
#define PPU0_PUR29_PUR17	(PPU0.unPUR29.stcField.u1PUR17)  /*@bf@*/
#define PPU0_PUR29_PUR18	(PPU0.unPUR29.stcField.u1PUR18)  /*@bf@*/
#define PPU0_PUR29_PUR19	(PPU0.unPUR29.stcField.u1PUR19)  /*@bf@*/
#define PPU0_PUR29_PUR20	(PPU0.unPUR29.stcField.u1PUR20)  /*@bf@*/
#define PPU0_PUR29_PUR21	(PPU0.unPUR29.stcField.u1PUR21)  /*@bf@*/
#define PPU0_PUR29_PUR22	(PPU0.unPUR29.stcField.u1PUR22)  /*@bf@*/
#define PPU0_PUR29_PUR23	(PPU0.unPUR29.stcField.u1PUR23)  /*@bf@*/
#define PPU0_PUR29_PUR24	(PPU0.unPUR29.stcField.u1PUR24)  /*@bf@*/
#define PPU0_PUR29_PUR25	(PPU0.unPUR29.stcField.u1PUR25)  /*@bf@*/
#define PPU0_PUR29_PUR26	(PPU0.unPUR29.stcField.u1PUR26)  /*@bf@*/
#define PPU0_PUR29_PUR27	(PPU0.unPUR29.stcField.u1PUR27)  /*@bf@*/
#define PPU0_PUR29_PUR28	(PPU0.unPUR29.stcField.u1PUR28)  /*@bf@*/
#define PPU0_PUR29_PUR29	(PPU0.unPUR29.stcField.u1PUR29)  /*@bf@*/
#define PPU0_PUR29_PUR30	(PPU0.unPUR29.stcField.u1PUR30)  /*@bf@*/
#define PPU0_PUR29_PUR31	(PPU0.unPUR29.stcField.u1PUR31)  /*@bf@*/

typedef struct stc_ppu0_purn_field{
    uint_io32_t		u1PUR0:1;
    uint_io32_t		u1PUR1:1;
    uint_io32_t		u1PUR2:1;
    uint_io32_t		u1PUR3:1;
    uint_io32_t		u1PUR4:1;
    uint_io32_t		u1PUR5:1;
    uint_io32_t		u1PUR6:1;
    uint_io32_t		u1PUR7:1;
    uint_io32_t		u1PUR8:1;
    uint_io32_t		u1PUR9:1;
    uint_io32_t		u1PUR10:1;
    uint_io32_t		u1PUR11:1;
    uint_io32_t		u1PUR12:1;
    uint_io32_t		u1PUR13:1;
    uint_io32_t		u1PUR14:1;
    uint_io32_t		u1PUR15:1;
    uint_io32_t		u1PUR16:1;
    uint_io32_t		u1PUR17:1;
    uint_io32_t		u1PUR18:1;
    uint_io32_t		u1PUR19:1;
    uint_io32_t		u1PUR20:1;
    uint_io32_t		u1PUR21:1;
    uint_io32_t		u1PUR22:1;
    uint_io32_t		u1PUR23:1;
    uint_io32_t		u1PUR24:1;
    uint_io32_t		u1PUR25:1;
    uint_io32_t		u1PUR26:1;
    uint_io32_t		u1PUR27:1;
    uint_io32_t		u1PUR28:1;
    uint_io32_t		u1PUR29:1;
    uint_io32_t		u1PUR30:1;
    uint_io32_t		u1PUR31:1;
}stc_ppu0_purn_field_t;

typedef union un_ppu0_purn{
    uint_io32_t		u32Register;
    stc_ppu0_purn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_purn_t;

/* LOCK1 */
#define PPU0_LOCK1	(PPU0.unLOCK1.u32Register)  /*@rg@*/
#define PPU0_LOCK1_L	PPU0_LOCK1  /*@bfrg@*/

typedef union un_ppu0_lock1{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_lock1_t;

/* PPWA[0-29] */
#define PPU0_PPWA0	(PPU0.unPPWA0.u32Register)  /*@rg@*/
#define PPU0_PPWA0_PPWA0	(PPU0.unPPWA0.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA0_PPWA1	(PPU0.unPPWA0.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA0_PPWA2	(PPU0.unPPWA0.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA0_PPWA3	(PPU0.unPPWA0.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA0_PPWA4	(PPU0.unPPWA0.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA0_PPWA5	(PPU0.unPPWA0.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA0_PPWA6	(PPU0.unPPWA0.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA0_PPWA7	(PPU0.unPPWA0.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA0_PPWA8	(PPU0.unPPWA0.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA0_PPWA9	(PPU0.unPPWA0.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA0_PPWA10	(PPU0.unPPWA0.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA0_PPWA11	(PPU0.unPPWA0.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA0_PPWA12	(PPU0.unPPWA0.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA0_PPWA13	(PPU0.unPPWA0.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA0_PPWA14	(PPU0.unPPWA0.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA0_PPWA15	(PPU0.unPPWA0.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA0_PPWA16	(PPU0.unPPWA0.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA0_PPWA17	(PPU0.unPPWA0.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA0_PPWA18	(PPU0.unPPWA0.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA0_PPWA19	(PPU0.unPPWA0.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA0_PPWA20	(PPU0.unPPWA0.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA0_PPWA21	(PPU0.unPPWA0.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA0_PPWA22	(PPU0.unPPWA0.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA0_PPWA23	(PPU0.unPPWA0.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA0_PPWA24	(PPU0.unPPWA0.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA0_PPWA25	(PPU0.unPPWA0.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA0_PPWA26	(PPU0.unPPWA0.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA0_PPWA27	(PPU0.unPPWA0.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA0_PPWA28	(PPU0.unPPWA0.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA0_PPWA29	(PPU0.unPPWA0.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA0_PPWA30	(PPU0.unPPWA0.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA0_PPWA31	(PPU0.unPPWA0.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA1	(PPU0.unPPWA1.u32Register)  /*@rg@*/
#define PPU0_PPWA1_PPWA0	(PPU0.unPPWA1.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA1_PPWA1	(PPU0.unPPWA1.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA1_PPWA2	(PPU0.unPPWA1.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA1_PPWA3	(PPU0.unPPWA1.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA1_PPWA4	(PPU0.unPPWA1.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA1_PPWA5	(PPU0.unPPWA1.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA1_PPWA6	(PPU0.unPPWA1.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA1_PPWA7	(PPU0.unPPWA1.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA1_PPWA8	(PPU0.unPPWA1.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA1_PPWA9	(PPU0.unPPWA1.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA1_PPWA10	(PPU0.unPPWA1.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA1_PPWA11	(PPU0.unPPWA1.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA1_PPWA12	(PPU0.unPPWA1.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA1_PPWA13	(PPU0.unPPWA1.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA1_PPWA14	(PPU0.unPPWA1.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA1_PPWA15	(PPU0.unPPWA1.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA1_PPWA16	(PPU0.unPPWA1.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA1_PPWA17	(PPU0.unPPWA1.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA1_PPWA18	(PPU0.unPPWA1.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA1_PPWA19	(PPU0.unPPWA1.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA1_PPWA20	(PPU0.unPPWA1.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA1_PPWA21	(PPU0.unPPWA1.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA1_PPWA22	(PPU0.unPPWA1.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA1_PPWA23	(PPU0.unPPWA1.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA1_PPWA24	(PPU0.unPPWA1.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA1_PPWA25	(PPU0.unPPWA1.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA1_PPWA26	(PPU0.unPPWA1.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA1_PPWA27	(PPU0.unPPWA1.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA1_PPWA28	(PPU0.unPPWA1.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA1_PPWA29	(PPU0.unPPWA1.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA1_PPWA30	(PPU0.unPPWA1.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA1_PPWA31	(PPU0.unPPWA1.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA2	(PPU0.unPPWA2.u32Register)  /*@rg@*/
#define PPU0_PPWA2_PPWA0	(PPU0.unPPWA2.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA2_PPWA1	(PPU0.unPPWA2.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA2_PPWA2	(PPU0.unPPWA2.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA2_PPWA3	(PPU0.unPPWA2.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA2_PPWA4	(PPU0.unPPWA2.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA2_PPWA5	(PPU0.unPPWA2.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA2_PPWA6	(PPU0.unPPWA2.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA2_PPWA7	(PPU0.unPPWA2.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA2_PPWA8	(PPU0.unPPWA2.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA2_PPWA9	(PPU0.unPPWA2.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA2_PPWA10	(PPU0.unPPWA2.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA2_PPWA11	(PPU0.unPPWA2.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA2_PPWA12	(PPU0.unPPWA2.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA2_PPWA13	(PPU0.unPPWA2.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA2_PPWA14	(PPU0.unPPWA2.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA2_PPWA15	(PPU0.unPPWA2.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA2_PPWA16	(PPU0.unPPWA2.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA2_PPWA17	(PPU0.unPPWA2.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA2_PPWA18	(PPU0.unPPWA2.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA2_PPWA19	(PPU0.unPPWA2.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA2_PPWA20	(PPU0.unPPWA2.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA2_PPWA21	(PPU0.unPPWA2.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA2_PPWA22	(PPU0.unPPWA2.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA2_PPWA23	(PPU0.unPPWA2.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA2_PPWA24	(PPU0.unPPWA2.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA2_PPWA25	(PPU0.unPPWA2.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA2_PPWA26	(PPU0.unPPWA2.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA2_PPWA27	(PPU0.unPPWA2.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA2_PPWA28	(PPU0.unPPWA2.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA2_PPWA29	(PPU0.unPPWA2.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA2_PPWA30	(PPU0.unPPWA2.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA2_PPWA31	(PPU0.unPPWA2.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA3	(PPU0.unPPWA3.u32Register)  /*@rg@*/
#define PPU0_PPWA3_PPWA0	(PPU0.unPPWA3.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA3_PPWA1	(PPU0.unPPWA3.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA3_PPWA2	(PPU0.unPPWA3.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA3_PPWA3	(PPU0.unPPWA3.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA3_PPWA4	(PPU0.unPPWA3.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA3_PPWA5	(PPU0.unPPWA3.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA3_PPWA6	(PPU0.unPPWA3.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA3_PPWA7	(PPU0.unPPWA3.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA3_PPWA8	(PPU0.unPPWA3.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA3_PPWA9	(PPU0.unPPWA3.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA3_PPWA10	(PPU0.unPPWA3.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA3_PPWA11	(PPU0.unPPWA3.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA3_PPWA12	(PPU0.unPPWA3.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA3_PPWA13	(PPU0.unPPWA3.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA3_PPWA14	(PPU0.unPPWA3.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA3_PPWA15	(PPU0.unPPWA3.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA3_PPWA16	(PPU0.unPPWA3.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA3_PPWA17	(PPU0.unPPWA3.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA3_PPWA18	(PPU0.unPPWA3.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA3_PPWA19	(PPU0.unPPWA3.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA3_PPWA20	(PPU0.unPPWA3.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA3_PPWA21	(PPU0.unPPWA3.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA3_PPWA22	(PPU0.unPPWA3.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA3_PPWA23	(PPU0.unPPWA3.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA3_PPWA24	(PPU0.unPPWA3.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA3_PPWA25	(PPU0.unPPWA3.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA3_PPWA26	(PPU0.unPPWA3.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA3_PPWA27	(PPU0.unPPWA3.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA3_PPWA28	(PPU0.unPPWA3.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA3_PPWA29	(PPU0.unPPWA3.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA3_PPWA30	(PPU0.unPPWA3.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA3_PPWA31	(PPU0.unPPWA3.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA4	(PPU0.unPPWA4.u32Register)  /*@rg@*/
#define PPU0_PPWA4_PPWA0	(PPU0.unPPWA4.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA4_PPWA1	(PPU0.unPPWA4.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA4_PPWA2	(PPU0.unPPWA4.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA4_PPWA3	(PPU0.unPPWA4.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA4_PPWA4	(PPU0.unPPWA4.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA4_PPWA5	(PPU0.unPPWA4.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA4_PPWA6	(PPU0.unPPWA4.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA4_PPWA7	(PPU0.unPPWA4.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA4_PPWA8	(PPU0.unPPWA4.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA4_PPWA9	(PPU0.unPPWA4.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA4_PPWA10	(PPU0.unPPWA4.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA4_PPWA11	(PPU0.unPPWA4.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA4_PPWA12	(PPU0.unPPWA4.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA4_PPWA13	(PPU0.unPPWA4.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA4_PPWA14	(PPU0.unPPWA4.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA4_PPWA15	(PPU0.unPPWA4.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA4_PPWA16	(PPU0.unPPWA4.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA4_PPWA17	(PPU0.unPPWA4.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA4_PPWA18	(PPU0.unPPWA4.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA4_PPWA19	(PPU0.unPPWA4.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA4_PPWA20	(PPU0.unPPWA4.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA4_PPWA21	(PPU0.unPPWA4.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA4_PPWA22	(PPU0.unPPWA4.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA4_PPWA23	(PPU0.unPPWA4.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA4_PPWA24	(PPU0.unPPWA4.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA4_PPWA25	(PPU0.unPPWA4.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA4_PPWA26	(PPU0.unPPWA4.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA4_PPWA27	(PPU0.unPPWA4.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA4_PPWA28	(PPU0.unPPWA4.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA4_PPWA29	(PPU0.unPPWA4.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA4_PPWA30	(PPU0.unPPWA4.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA4_PPWA31	(PPU0.unPPWA4.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA5	(PPU0.unPPWA5.u32Register)  /*@rg@*/
#define PPU0_PPWA5_PPWA0	(PPU0.unPPWA5.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA5_PPWA1	(PPU0.unPPWA5.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA5_PPWA2	(PPU0.unPPWA5.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA5_PPWA3	(PPU0.unPPWA5.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA5_PPWA4	(PPU0.unPPWA5.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA5_PPWA5	(PPU0.unPPWA5.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA5_PPWA6	(PPU0.unPPWA5.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA5_PPWA7	(PPU0.unPPWA5.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA5_PPWA8	(PPU0.unPPWA5.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA5_PPWA9	(PPU0.unPPWA5.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA5_PPWA10	(PPU0.unPPWA5.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA5_PPWA11	(PPU0.unPPWA5.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA5_PPWA12	(PPU0.unPPWA5.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA5_PPWA13	(PPU0.unPPWA5.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA5_PPWA14	(PPU0.unPPWA5.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA5_PPWA15	(PPU0.unPPWA5.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA5_PPWA16	(PPU0.unPPWA5.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA5_PPWA17	(PPU0.unPPWA5.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA5_PPWA18	(PPU0.unPPWA5.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA5_PPWA19	(PPU0.unPPWA5.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA5_PPWA20	(PPU0.unPPWA5.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA5_PPWA21	(PPU0.unPPWA5.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA5_PPWA22	(PPU0.unPPWA5.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA5_PPWA23	(PPU0.unPPWA5.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA5_PPWA24	(PPU0.unPPWA5.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA5_PPWA25	(PPU0.unPPWA5.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA5_PPWA26	(PPU0.unPPWA5.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA5_PPWA27	(PPU0.unPPWA5.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA5_PPWA28	(PPU0.unPPWA5.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA5_PPWA29	(PPU0.unPPWA5.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA5_PPWA30	(PPU0.unPPWA5.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA5_PPWA31	(PPU0.unPPWA5.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA6	(PPU0.unPPWA6.u32Register)  /*@rg@*/
#define PPU0_PPWA6_PPWA0	(PPU0.unPPWA6.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA6_PPWA1	(PPU0.unPPWA6.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA6_PPWA2	(PPU0.unPPWA6.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA6_PPWA3	(PPU0.unPPWA6.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA6_PPWA4	(PPU0.unPPWA6.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA6_PPWA5	(PPU0.unPPWA6.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA6_PPWA6	(PPU0.unPPWA6.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA6_PPWA7	(PPU0.unPPWA6.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA6_PPWA8	(PPU0.unPPWA6.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA6_PPWA9	(PPU0.unPPWA6.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA6_PPWA10	(PPU0.unPPWA6.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA6_PPWA11	(PPU0.unPPWA6.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA6_PPWA12	(PPU0.unPPWA6.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA6_PPWA13	(PPU0.unPPWA6.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA6_PPWA14	(PPU0.unPPWA6.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA6_PPWA15	(PPU0.unPPWA6.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA6_PPWA16	(PPU0.unPPWA6.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA6_PPWA17	(PPU0.unPPWA6.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA6_PPWA18	(PPU0.unPPWA6.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA6_PPWA19	(PPU0.unPPWA6.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA6_PPWA20	(PPU0.unPPWA6.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA6_PPWA21	(PPU0.unPPWA6.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA6_PPWA22	(PPU0.unPPWA6.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA6_PPWA23	(PPU0.unPPWA6.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA6_PPWA24	(PPU0.unPPWA6.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA6_PPWA25	(PPU0.unPPWA6.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA6_PPWA26	(PPU0.unPPWA6.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA6_PPWA27	(PPU0.unPPWA6.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA6_PPWA28	(PPU0.unPPWA6.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA6_PPWA29	(PPU0.unPPWA6.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA6_PPWA30	(PPU0.unPPWA6.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA6_PPWA31	(PPU0.unPPWA6.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA7	(PPU0.unPPWA7.u32Register)  /*@rg@*/
#define PPU0_PPWA7_PPWA0	(PPU0.unPPWA7.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA7_PPWA1	(PPU0.unPPWA7.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA7_PPWA2	(PPU0.unPPWA7.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA7_PPWA3	(PPU0.unPPWA7.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA7_PPWA4	(PPU0.unPPWA7.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA7_PPWA5	(PPU0.unPPWA7.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA7_PPWA6	(PPU0.unPPWA7.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA7_PPWA7	(PPU0.unPPWA7.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA7_PPWA8	(PPU0.unPPWA7.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA7_PPWA9	(PPU0.unPPWA7.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA7_PPWA10	(PPU0.unPPWA7.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA7_PPWA11	(PPU0.unPPWA7.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA7_PPWA12	(PPU0.unPPWA7.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA7_PPWA13	(PPU0.unPPWA7.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA7_PPWA14	(PPU0.unPPWA7.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA7_PPWA15	(PPU0.unPPWA7.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA7_PPWA16	(PPU0.unPPWA7.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA7_PPWA17	(PPU0.unPPWA7.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA7_PPWA18	(PPU0.unPPWA7.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA7_PPWA19	(PPU0.unPPWA7.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA7_PPWA20	(PPU0.unPPWA7.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA7_PPWA21	(PPU0.unPPWA7.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA7_PPWA22	(PPU0.unPPWA7.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA7_PPWA23	(PPU0.unPPWA7.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA7_PPWA24	(PPU0.unPPWA7.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA7_PPWA25	(PPU0.unPPWA7.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA7_PPWA26	(PPU0.unPPWA7.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA7_PPWA27	(PPU0.unPPWA7.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA7_PPWA28	(PPU0.unPPWA7.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA7_PPWA29	(PPU0.unPPWA7.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA7_PPWA30	(PPU0.unPPWA7.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA7_PPWA31	(PPU0.unPPWA7.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA8	(PPU0.unPPWA8.u32Register)  /*@rg@*/
#define PPU0_PPWA8_PPWA0	(PPU0.unPPWA8.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA8_PPWA1	(PPU0.unPPWA8.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA8_PPWA2	(PPU0.unPPWA8.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA8_PPWA3	(PPU0.unPPWA8.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA8_PPWA4	(PPU0.unPPWA8.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA8_PPWA5	(PPU0.unPPWA8.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA8_PPWA6	(PPU0.unPPWA8.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA8_PPWA7	(PPU0.unPPWA8.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA8_PPWA8	(PPU0.unPPWA8.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA8_PPWA9	(PPU0.unPPWA8.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA8_PPWA10	(PPU0.unPPWA8.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA8_PPWA11	(PPU0.unPPWA8.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA8_PPWA12	(PPU0.unPPWA8.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA8_PPWA13	(PPU0.unPPWA8.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA8_PPWA14	(PPU0.unPPWA8.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA8_PPWA15	(PPU0.unPPWA8.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA8_PPWA16	(PPU0.unPPWA8.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA8_PPWA17	(PPU0.unPPWA8.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA8_PPWA18	(PPU0.unPPWA8.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA8_PPWA19	(PPU0.unPPWA8.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA8_PPWA20	(PPU0.unPPWA8.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA8_PPWA21	(PPU0.unPPWA8.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA8_PPWA22	(PPU0.unPPWA8.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA8_PPWA23	(PPU0.unPPWA8.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA8_PPWA24	(PPU0.unPPWA8.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA8_PPWA25	(PPU0.unPPWA8.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA8_PPWA26	(PPU0.unPPWA8.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA8_PPWA27	(PPU0.unPPWA8.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA8_PPWA28	(PPU0.unPPWA8.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA8_PPWA29	(PPU0.unPPWA8.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA8_PPWA30	(PPU0.unPPWA8.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA8_PPWA31	(PPU0.unPPWA8.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA9	(PPU0.unPPWA9.u32Register)  /*@rg@*/
#define PPU0_PPWA9_PPWA0	(PPU0.unPPWA9.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA9_PPWA1	(PPU0.unPPWA9.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA9_PPWA2	(PPU0.unPPWA9.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA9_PPWA3	(PPU0.unPPWA9.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA9_PPWA4	(PPU0.unPPWA9.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA9_PPWA5	(PPU0.unPPWA9.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA9_PPWA6	(PPU0.unPPWA9.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA9_PPWA7	(PPU0.unPPWA9.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA9_PPWA8	(PPU0.unPPWA9.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA9_PPWA9	(PPU0.unPPWA9.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA9_PPWA10	(PPU0.unPPWA9.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA9_PPWA11	(PPU0.unPPWA9.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA9_PPWA12	(PPU0.unPPWA9.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA9_PPWA13	(PPU0.unPPWA9.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA9_PPWA14	(PPU0.unPPWA9.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA9_PPWA15	(PPU0.unPPWA9.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA9_PPWA16	(PPU0.unPPWA9.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA9_PPWA17	(PPU0.unPPWA9.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA9_PPWA18	(PPU0.unPPWA9.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA9_PPWA19	(PPU0.unPPWA9.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA9_PPWA20	(PPU0.unPPWA9.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA9_PPWA21	(PPU0.unPPWA9.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA9_PPWA22	(PPU0.unPPWA9.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA9_PPWA23	(PPU0.unPPWA9.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA9_PPWA24	(PPU0.unPPWA9.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA9_PPWA25	(PPU0.unPPWA9.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA9_PPWA26	(PPU0.unPPWA9.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA9_PPWA27	(PPU0.unPPWA9.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA9_PPWA28	(PPU0.unPPWA9.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA9_PPWA29	(PPU0.unPPWA9.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA9_PPWA30	(PPU0.unPPWA9.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA9_PPWA31	(PPU0.unPPWA9.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA10	(PPU0.unPPWA10.u32Register)  /*@rg@*/
#define PPU0_PPWA10_PPWA0	(PPU0.unPPWA10.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA10_PPWA1	(PPU0.unPPWA10.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA10_PPWA2	(PPU0.unPPWA10.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA10_PPWA3	(PPU0.unPPWA10.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA10_PPWA4	(PPU0.unPPWA10.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA10_PPWA5	(PPU0.unPPWA10.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA10_PPWA6	(PPU0.unPPWA10.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA10_PPWA7	(PPU0.unPPWA10.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA10_PPWA8	(PPU0.unPPWA10.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA10_PPWA9	(PPU0.unPPWA10.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA10_PPWA10	(PPU0.unPPWA10.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA10_PPWA11	(PPU0.unPPWA10.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA10_PPWA12	(PPU0.unPPWA10.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA10_PPWA13	(PPU0.unPPWA10.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA10_PPWA14	(PPU0.unPPWA10.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA10_PPWA15	(PPU0.unPPWA10.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA10_PPWA16	(PPU0.unPPWA10.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA10_PPWA17	(PPU0.unPPWA10.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA10_PPWA18	(PPU0.unPPWA10.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA10_PPWA19	(PPU0.unPPWA10.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA10_PPWA20	(PPU0.unPPWA10.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA10_PPWA21	(PPU0.unPPWA10.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA10_PPWA22	(PPU0.unPPWA10.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA10_PPWA23	(PPU0.unPPWA10.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA10_PPWA24	(PPU0.unPPWA10.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA10_PPWA25	(PPU0.unPPWA10.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA10_PPWA26	(PPU0.unPPWA10.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA10_PPWA27	(PPU0.unPPWA10.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA10_PPWA28	(PPU0.unPPWA10.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA10_PPWA29	(PPU0.unPPWA10.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA10_PPWA30	(PPU0.unPPWA10.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA10_PPWA31	(PPU0.unPPWA10.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA11	(PPU0.unPPWA11.u32Register)  /*@rg@*/
#define PPU0_PPWA11_PPWA0	(PPU0.unPPWA11.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA11_PPWA1	(PPU0.unPPWA11.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA11_PPWA2	(PPU0.unPPWA11.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA11_PPWA3	(PPU0.unPPWA11.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA11_PPWA4	(PPU0.unPPWA11.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA11_PPWA5	(PPU0.unPPWA11.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA11_PPWA6	(PPU0.unPPWA11.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA11_PPWA7	(PPU0.unPPWA11.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA11_PPWA8	(PPU0.unPPWA11.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA11_PPWA9	(PPU0.unPPWA11.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA11_PPWA10	(PPU0.unPPWA11.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA11_PPWA11	(PPU0.unPPWA11.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA11_PPWA12	(PPU0.unPPWA11.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA11_PPWA13	(PPU0.unPPWA11.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA11_PPWA14	(PPU0.unPPWA11.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA11_PPWA15	(PPU0.unPPWA11.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA11_PPWA16	(PPU0.unPPWA11.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA11_PPWA17	(PPU0.unPPWA11.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA11_PPWA18	(PPU0.unPPWA11.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA11_PPWA19	(PPU0.unPPWA11.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA11_PPWA20	(PPU0.unPPWA11.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA11_PPWA21	(PPU0.unPPWA11.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA11_PPWA22	(PPU0.unPPWA11.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA11_PPWA23	(PPU0.unPPWA11.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA11_PPWA24	(PPU0.unPPWA11.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA11_PPWA25	(PPU0.unPPWA11.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA11_PPWA26	(PPU0.unPPWA11.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA11_PPWA27	(PPU0.unPPWA11.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA11_PPWA28	(PPU0.unPPWA11.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA11_PPWA29	(PPU0.unPPWA11.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA11_PPWA30	(PPU0.unPPWA11.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA11_PPWA31	(PPU0.unPPWA11.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA12	(PPU0.unPPWA12.u32Register)  /*@rg@*/
#define PPU0_PPWA12_PPWA0	(PPU0.unPPWA12.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA12_PPWA1	(PPU0.unPPWA12.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA12_PPWA2	(PPU0.unPPWA12.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA12_PPWA3	(PPU0.unPPWA12.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA12_PPWA4	(PPU0.unPPWA12.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA12_PPWA5	(PPU0.unPPWA12.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA12_PPWA6	(PPU0.unPPWA12.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA12_PPWA7	(PPU0.unPPWA12.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA12_PPWA8	(PPU0.unPPWA12.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA12_PPWA9	(PPU0.unPPWA12.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA12_PPWA10	(PPU0.unPPWA12.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA12_PPWA11	(PPU0.unPPWA12.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA12_PPWA12	(PPU0.unPPWA12.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA12_PPWA13	(PPU0.unPPWA12.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA12_PPWA14	(PPU0.unPPWA12.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA12_PPWA15	(PPU0.unPPWA12.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA12_PPWA16	(PPU0.unPPWA12.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA12_PPWA17	(PPU0.unPPWA12.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA12_PPWA18	(PPU0.unPPWA12.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA12_PPWA19	(PPU0.unPPWA12.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA12_PPWA20	(PPU0.unPPWA12.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA12_PPWA21	(PPU0.unPPWA12.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA12_PPWA22	(PPU0.unPPWA12.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA12_PPWA23	(PPU0.unPPWA12.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA12_PPWA24	(PPU0.unPPWA12.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA12_PPWA25	(PPU0.unPPWA12.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA12_PPWA26	(PPU0.unPPWA12.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA12_PPWA27	(PPU0.unPPWA12.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA12_PPWA28	(PPU0.unPPWA12.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA12_PPWA29	(PPU0.unPPWA12.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA12_PPWA30	(PPU0.unPPWA12.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA12_PPWA31	(PPU0.unPPWA12.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA13	(PPU0.unPPWA13.u32Register)  /*@rg@*/
#define PPU0_PPWA13_PPWA0	(PPU0.unPPWA13.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA13_PPWA1	(PPU0.unPPWA13.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA13_PPWA2	(PPU0.unPPWA13.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA13_PPWA3	(PPU0.unPPWA13.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA13_PPWA4	(PPU0.unPPWA13.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA13_PPWA5	(PPU0.unPPWA13.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA13_PPWA6	(PPU0.unPPWA13.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA13_PPWA7	(PPU0.unPPWA13.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA13_PPWA8	(PPU0.unPPWA13.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA13_PPWA9	(PPU0.unPPWA13.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA13_PPWA10	(PPU0.unPPWA13.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA13_PPWA11	(PPU0.unPPWA13.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA13_PPWA12	(PPU0.unPPWA13.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA13_PPWA13	(PPU0.unPPWA13.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA13_PPWA14	(PPU0.unPPWA13.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA13_PPWA15	(PPU0.unPPWA13.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA13_PPWA16	(PPU0.unPPWA13.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA13_PPWA17	(PPU0.unPPWA13.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA13_PPWA18	(PPU0.unPPWA13.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA13_PPWA19	(PPU0.unPPWA13.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA13_PPWA20	(PPU0.unPPWA13.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA13_PPWA21	(PPU0.unPPWA13.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA13_PPWA22	(PPU0.unPPWA13.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA13_PPWA23	(PPU0.unPPWA13.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA13_PPWA24	(PPU0.unPPWA13.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA13_PPWA25	(PPU0.unPPWA13.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA13_PPWA26	(PPU0.unPPWA13.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA13_PPWA27	(PPU0.unPPWA13.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA13_PPWA28	(PPU0.unPPWA13.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA13_PPWA29	(PPU0.unPPWA13.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA13_PPWA30	(PPU0.unPPWA13.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA13_PPWA31	(PPU0.unPPWA13.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA14	(PPU0.unPPWA14.u32Register)  /*@rg@*/
#define PPU0_PPWA14_PPWA0	(PPU0.unPPWA14.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA14_PPWA1	(PPU0.unPPWA14.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA14_PPWA2	(PPU0.unPPWA14.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA14_PPWA3	(PPU0.unPPWA14.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA14_PPWA4	(PPU0.unPPWA14.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA14_PPWA5	(PPU0.unPPWA14.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA14_PPWA6	(PPU0.unPPWA14.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA14_PPWA7	(PPU0.unPPWA14.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA14_PPWA8	(PPU0.unPPWA14.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA14_PPWA9	(PPU0.unPPWA14.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA14_PPWA10	(PPU0.unPPWA14.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA14_PPWA11	(PPU0.unPPWA14.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA14_PPWA12	(PPU0.unPPWA14.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA14_PPWA13	(PPU0.unPPWA14.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA14_PPWA14	(PPU0.unPPWA14.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA14_PPWA15	(PPU0.unPPWA14.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA14_PPWA16	(PPU0.unPPWA14.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA14_PPWA17	(PPU0.unPPWA14.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA14_PPWA18	(PPU0.unPPWA14.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA14_PPWA19	(PPU0.unPPWA14.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA14_PPWA20	(PPU0.unPPWA14.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA14_PPWA21	(PPU0.unPPWA14.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA14_PPWA22	(PPU0.unPPWA14.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA14_PPWA23	(PPU0.unPPWA14.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA14_PPWA24	(PPU0.unPPWA14.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA14_PPWA25	(PPU0.unPPWA14.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA14_PPWA26	(PPU0.unPPWA14.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA14_PPWA27	(PPU0.unPPWA14.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA14_PPWA28	(PPU0.unPPWA14.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA14_PPWA29	(PPU0.unPPWA14.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA14_PPWA30	(PPU0.unPPWA14.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA14_PPWA31	(PPU0.unPPWA14.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA15	(PPU0.unPPWA15.u32Register)  /*@rg@*/
#define PPU0_PPWA15_PPWA0	(PPU0.unPPWA15.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA15_PPWA1	(PPU0.unPPWA15.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA15_PPWA2	(PPU0.unPPWA15.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA15_PPWA3	(PPU0.unPPWA15.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA15_PPWA4	(PPU0.unPPWA15.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA15_PPWA5	(PPU0.unPPWA15.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA15_PPWA6	(PPU0.unPPWA15.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA15_PPWA7	(PPU0.unPPWA15.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA15_PPWA8	(PPU0.unPPWA15.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA15_PPWA9	(PPU0.unPPWA15.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA15_PPWA10	(PPU0.unPPWA15.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA15_PPWA11	(PPU0.unPPWA15.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA15_PPWA12	(PPU0.unPPWA15.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA15_PPWA13	(PPU0.unPPWA15.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA15_PPWA14	(PPU0.unPPWA15.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA15_PPWA15	(PPU0.unPPWA15.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA15_PPWA16	(PPU0.unPPWA15.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA15_PPWA17	(PPU0.unPPWA15.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA15_PPWA18	(PPU0.unPPWA15.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA15_PPWA19	(PPU0.unPPWA15.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA15_PPWA20	(PPU0.unPPWA15.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA15_PPWA21	(PPU0.unPPWA15.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA15_PPWA22	(PPU0.unPPWA15.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA15_PPWA23	(PPU0.unPPWA15.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA15_PPWA24	(PPU0.unPPWA15.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA15_PPWA25	(PPU0.unPPWA15.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA15_PPWA26	(PPU0.unPPWA15.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA15_PPWA27	(PPU0.unPPWA15.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA15_PPWA28	(PPU0.unPPWA15.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA15_PPWA29	(PPU0.unPPWA15.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA15_PPWA30	(PPU0.unPPWA15.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA15_PPWA31	(PPU0.unPPWA15.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA16	(PPU0.unPPWA16.u32Register)  /*@rg@*/
#define PPU0_PPWA16_PPWA0	(PPU0.unPPWA16.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA16_PPWA1	(PPU0.unPPWA16.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA16_PPWA2	(PPU0.unPPWA16.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA16_PPWA3	(PPU0.unPPWA16.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA16_PPWA4	(PPU0.unPPWA16.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA16_PPWA5	(PPU0.unPPWA16.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA16_PPWA6	(PPU0.unPPWA16.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA16_PPWA7	(PPU0.unPPWA16.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA16_PPWA8	(PPU0.unPPWA16.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA16_PPWA9	(PPU0.unPPWA16.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA16_PPWA10	(PPU0.unPPWA16.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA16_PPWA11	(PPU0.unPPWA16.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA16_PPWA12	(PPU0.unPPWA16.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA16_PPWA13	(PPU0.unPPWA16.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA16_PPWA14	(PPU0.unPPWA16.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA16_PPWA15	(PPU0.unPPWA16.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA16_PPWA16	(PPU0.unPPWA16.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA16_PPWA17	(PPU0.unPPWA16.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA16_PPWA18	(PPU0.unPPWA16.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA16_PPWA19	(PPU0.unPPWA16.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA16_PPWA20	(PPU0.unPPWA16.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA16_PPWA21	(PPU0.unPPWA16.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA16_PPWA22	(PPU0.unPPWA16.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA16_PPWA23	(PPU0.unPPWA16.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA16_PPWA24	(PPU0.unPPWA16.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA16_PPWA25	(PPU0.unPPWA16.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA16_PPWA26	(PPU0.unPPWA16.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA16_PPWA27	(PPU0.unPPWA16.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA16_PPWA28	(PPU0.unPPWA16.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA16_PPWA29	(PPU0.unPPWA16.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA16_PPWA30	(PPU0.unPPWA16.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA16_PPWA31	(PPU0.unPPWA16.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA17	(PPU0.unPPWA17.u32Register)  /*@rg@*/
#define PPU0_PPWA17_PPWA0	(PPU0.unPPWA17.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA17_PPWA1	(PPU0.unPPWA17.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA17_PPWA2	(PPU0.unPPWA17.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA17_PPWA3	(PPU0.unPPWA17.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA17_PPWA4	(PPU0.unPPWA17.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA17_PPWA5	(PPU0.unPPWA17.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA17_PPWA6	(PPU0.unPPWA17.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA17_PPWA7	(PPU0.unPPWA17.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA17_PPWA8	(PPU0.unPPWA17.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA17_PPWA9	(PPU0.unPPWA17.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA17_PPWA10	(PPU0.unPPWA17.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA17_PPWA11	(PPU0.unPPWA17.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA17_PPWA12	(PPU0.unPPWA17.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA17_PPWA13	(PPU0.unPPWA17.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA17_PPWA14	(PPU0.unPPWA17.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA17_PPWA15	(PPU0.unPPWA17.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA17_PPWA16	(PPU0.unPPWA17.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA17_PPWA17	(PPU0.unPPWA17.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA17_PPWA18	(PPU0.unPPWA17.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA17_PPWA19	(PPU0.unPPWA17.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA17_PPWA20	(PPU0.unPPWA17.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA17_PPWA21	(PPU0.unPPWA17.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA17_PPWA22	(PPU0.unPPWA17.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA17_PPWA23	(PPU0.unPPWA17.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA17_PPWA24	(PPU0.unPPWA17.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA17_PPWA25	(PPU0.unPPWA17.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA17_PPWA26	(PPU0.unPPWA17.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA17_PPWA27	(PPU0.unPPWA17.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA17_PPWA28	(PPU0.unPPWA17.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA17_PPWA29	(PPU0.unPPWA17.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA17_PPWA30	(PPU0.unPPWA17.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA17_PPWA31	(PPU0.unPPWA17.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA18	(PPU0.unPPWA18.u32Register)  /*@rg@*/
#define PPU0_PPWA18_PPWA0	(PPU0.unPPWA18.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA18_PPWA1	(PPU0.unPPWA18.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA18_PPWA2	(PPU0.unPPWA18.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA18_PPWA3	(PPU0.unPPWA18.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA18_PPWA4	(PPU0.unPPWA18.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA18_PPWA5	(PPU0.unPPWA18.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA18_PPWA6	(PPU0.unPPWA18.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA18_PPWA7	(PPU0.unPPWA18.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA18_PPWA8	(PPU0.unPPWA18.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA18_PPWA9	(PPU0.unPPWA18.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA18_PPWA10	(PPU0.unPPWA18.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA18_PPWA11	(PPU0.unPPWA18.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA18_PPWA12	(PPU0.unPPWA18.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA18_PPWA13	(PPU0.unPPWA18.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA18_PPWA14	(PPU0.unPPWA18.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA18_PPWA15	(PPU0.unPPWA18.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA18_PPWA16	(PPU0.unPPWA18.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA18_PPWA17	(PPU0.unPPWA18.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA18_PPWA18	(PPU0.unPPWA18.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA18_PPWA19	(PPU0.unPPWA18.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA18_PPWA20	(PPU0.unPPWA18.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA18_PPWA21	(PPU0.unPPWA18.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA18_PPWA22	(PPU0.unPPWA18.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA18_PPWA23	(PPU0.unPPWA18.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA18_PPWA24	(PPU0.unPPWA18.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA18_PPWA25	(PPU0.unPPWA18.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA18_PPWA26	(PPU0.unPPWA18.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA18_PPWA27	(PPU0.unPPWA18.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA18_PPWA28	(PPU0.unPPWA18.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA18_PPWA29	(PPU0.unPPWA18.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA18_PPWA30	(PPU0.unPPWA18.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA18_PPWA31	(PPU0.unPPWA18.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA19	(PPU0.unPPWA19.u32Register)  /*@rg@*/
#define PPU0_PPWA19_PPWA0	(PPU0.unPPWA19.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA19_PPWA1	(PPU0.unPPWA19.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA19_PPWA2	(PPU0.unPPWA19.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA19_PPWA3	(PPU0.unPPWA19.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA19_PPWA4	(PPU0.unPPWA19.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA19_PPWA5	(PPU0.unPPWA19.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA19_PPWA6	(PPU0.unPPWA19.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA19_PPWA7	(PPU0.unPPWA19.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA19_PPWA8	(PPU0.unPPWA19.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA19_PPWA9	(PPU0.unPPWA19.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA19_PPWA10	(PPU0.unPPWA19.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA19_PPWA11	(PPU0.unPPWA19.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA19_PPWA12	(PPU0.unPPWA19.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA19_PPWA13	(PPU0.unPPWA19.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA19_PPWA14	(PPU0.unPPWA19.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA19_PPWA15	(PPU0.unPPWA19.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA19_PPWA16	(PPU0.unPPWA19.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA19_PPWA17	(PPU0.unPPWA19.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA19_PPWA18	(PPU0.unPPWA19.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA19_PPWA19	(PPU0.unPPWA19.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA19_PPWA20	(PPU0.unPPWA19.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA19_PPWA21	(PPU0.unPPWA19.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA19_PPWA22	(PPU0.unPPWA19.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA19_PPWA23	(PPU0.unPPWA19.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA19_PPWA24	(PPU0.unPPWA19.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA19_PPWA25	(PPU0.unPPWA19.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA19_PPWA26	(PPU0.unPPWA19.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA19_PPWA27	(PPU0.unPPWA19.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA19_PPWA28	(PPU0.unPPWA19.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA19_PPWA29	(PPU0.unPPWA19.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA19_PPWA30	(PPU0.unPPWA19.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA19_PPWA31	(PPU0.unPPWA19.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA20	(PPU0.unPPWA20.u32Register)  /*@rg@*/
#define PPU0_PPWA20_PPWA0	(PPU0.unPPWA20.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA20_PPWA1	(PPU0.unPPWA20.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA20_PPWA2	(PPU0.unPPWA20.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA20_PPWA3	(PPU0.unPPWA20.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA20_PPWA4	(PPU0.unPPWA20.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA20_PPWA5	(PPU0.unPPWA20.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA20_PPWA6	(PPU0.unPPWA20.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA20_PPWA7	(PPU0.unPPWA20.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA20_PPWA8	(PPU0.unPPWA20.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA20_PPWA9	(PPU0.unPPWA20.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA20_PPWA10	(PPU0.unPPWA20.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA20_PPWA11	(PPU0.unPPWA20.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA20_PPWA12	(PPU0.unPPWA20.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA20_PPWA13	(PPU0.unPPWA20.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA20_PPWA14	(PPU0.unPPWA20.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA20_PPWA15	(PPU0.unPPWA20.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA20_PPWA16	(PPU0.unPPWA20.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA20_PPWA17	(PPU0.unPPWA20.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA20_PPWA18	(PPU0.unPPWA20.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA20_PPWA19	(PPU0.unPPWA20.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA20_PPWA20	(PPU0.unPPWA20.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA20_PPWA21	(PPU0.unPPWA20.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA20_PPWA22	(PPU0.unPPWA20.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA20_PPWA23	(PPU0.unPPWA20.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA20_PPWA24	(PPU0.unPPWA20.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA20_PPWA25	(PPU0.unPPWA20.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA20_PPWA26	(PPU0.unPPWA20.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA20_PPWA27	(PPU0.unPPWA20.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA20_PPWA28	(PPU0.unPPWA20.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA20_PPWA29	(PPU0.unPPWA20.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA20_PPWA30	(PPU0.unPPWA20.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA20_PPWA31	(PPU0.unPPWA20.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA21	(PPU0.unPPWA21.u32Register)  /*@rg@*/
#define PPU0_PPWA21_PPWA0	(PPU0.unPPWA21.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA21_PPWA1	(PPU0.unPPWA21.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA21_PPWA2	(PPU0.unPPWA21.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA21_PPWA3	(PPU0.unPPWA21.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA21_PPWA4	(PPU0.unPPWA21.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA21_PPWA5	(PPU0.unPPWA21.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA21_PPWA6	(PPU0.unPPWA21.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA21_PPWA7	(PPU0.unPPWA21.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA21_PPWA8	(PPU0.unPPWA21.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA21_PPWA9	(PPU0.unPPWA21.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA21_PPWA10	(PPU0.unPPWA21.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA21_PPWA11	(PPU0.unPPWA21.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA21_PPWA12	(PPU0.unPPWA21.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA21_PPWA13	(PPU0.unPPWA21.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA21_PPWA14	(PPU0.unPPWA21.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA21_PPWA15	(PPU0.unPPWA21.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA21_PPWA16	(PPU0.unPPWA21.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA21_PPWA17	(PPU0.unPPWA21.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA21_PPWA18	(PPU0.unPPWA21.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA21_PPWA19	(PPU0.unPPWA21.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA21_PPWA20	(PPU0.unPPWA21.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA21_PPWA21	(PPU0.unPPWA21.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA21_PPWA22	(PPU0.unPPWA21.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA21_PPWA23	(PPU0.unPPWA21.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA21_PPWA24	(PPU0.unPPWA21.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA21_PPWA25	(PPU0.unPPWA21.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA21_PPWA26	(PPU0.unPPWA21.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA21_PPWA27	(PPU0.unPPWA21.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA21_PPWA28	(PPU0.unPPWA21.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA21_PPWA29	(PPU0.unPPWA21.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA21_PPWA30	(PPU0.unPPWA21.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA21_PPWA31	(PPU0.unPPWA21.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA22	(PPU0.unPPWA22.u32Register)  /*@rg@*/
#define PPU0_PPWA22_PPWA0	(PPU0.unPPWA22.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA22_PPWA1	(PPU0.unPPWA22.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA22_PPWA2	(PPU0.unPPWA22.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA22_PPWA3	(PPU0.unPPWA22.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA22_PPWA4	(PPU0.unPPWA22.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA22_PPWA5	(PPU0.unPPWA22.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA22_PPWA6	(PPU0.unPPWA22.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA22_PPWA7	(PPU0.unPPWA22.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA22_PPWA8	(PPU0.unPPWA22.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA22_PPWA9	(PPU0.unPPWA22.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA22_PPWA10	(PPU0.unPPWA22.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA22_PPWA11	(PPU0.unPPWA22.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA22_PPWA12	(PPU0.unPPWA22.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA22_PPWA13	(PPU0.unPPWA22.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA22_PPWA14	(PPU0.unPPWA22.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA22_PPWA15	(PPU0.unPPWA22.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA22_PPWA16	(PPU0.unPPWA22.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA22_PPWA17	(PPU0.unPPWA22.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA22_PPWA18	(PPU0.unPPWA22.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA22_PPWA19	(PPU0.unPPWA22.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA22_PPWA20	(PPU0.unPPWA22.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA22_PPWA21	(PPU0.unPPWA22.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA22_PPWA22	(PPU0.unPPWA22.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA22_PPWA23	(PPU0.unPPWA22.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA22_PPWA24	(PPU0.unPPWA22.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA22_PPWA25	(PPU0.unPPWA22.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA22_PPWA26	(PPU0.unPPWA22.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA22_PPWA27	(PPU0.unPPWA22.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA22_PPWA28	(PPU0.unPPWA22.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA22_PPWA29	(PPU0.unPPWA22.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA22_PPWA30	(PPU0.unPPWA22.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA22_PPWA31	(PPU0.unPPWA22.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA23	(PPU0.unPPWA23.u32Register)  /*@rg@*/
#define PPU0_PPWA23_PPWA0	(PPU0.unPPWA23.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA23_PPWA1	(PPU0.unPPWA23.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA23_PPWA2	(PPU0.unPPWA23.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA23_PPWA3	(PPU0.unPPWA23.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA23_PPWA4	(PPU0.unPPWA23.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA23_PPWA5	(PPU0.unPPWA23.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA23_PPWA6	(PPU0.unPPWA23.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA23_PPWA7	(PPU0.unPPWA23.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA23_PPWA8	(PPU0.unPPWA23.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA23_PPWA9	(PPU0.unPPWA23.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA23_PPWA10	(PPU0.unPPWA23.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA23_PPWA11	(PPU0.unPPWA23.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA23_PPWA12	(PPU0.unPPWA23.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA23_PPWA13	(PPU0.unPPWA23.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA23_PPWA14	(PPU0.unPPWA23.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA23_PPWA15	(PPU0.unPPWA23.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA23_PPWA16	(PPU0.unPPWA23.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA23_PPWA17	(PPU0.unPPWA23.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA23_PPWA18	(PPU0.unPPWA23.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA23_PPWA19	(PPU0.unPPWA23.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA23_PPWA20	(PPU0.unPPWA23.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA23_PPWA21	(PPU0.unPPWA23.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA23_PPWA22	(PPU0.unPPWA23.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA23_PPWA23	(PPU0.unPPWA23.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA23_PPWA24	(PPU0.unPPWA23.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA23_PPWA25	(PPU0.unPPWA23.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA23_PPWA26	(PPU0.unPPWA23.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA23_PPWA27	(PPU0.unPPWA23.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA23_PPWA28	(PPU0.unPPWA23.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA23_PPWA29	(PPU0.unPPWA23.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA23_PPWA30	(PPU0.unPPWA23.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA23_PPWA31	(PPU0.unPPWA23.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA24	(PPU0.unPPWA24.u32Register)  /*@rg@*/
#define PPU0_PPWA24_PPWA0	(PPU0.unPPWA24.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA24_PPWA1	(PPU0.unPPWA24.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA24_PPWA2	(PPU0.unPPWA24.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA24_PPWA3	(PPU0.unPPWA24.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA24_PPWA4	(PPU0.unPPWA24.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA24_PPWA5	(PPU0.unPPWA24.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA24_PPWA6	(PPU0.unPPWA24.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA24_PPWA7	(PPU0.unPPWA24.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA24_PPWA8	(PPU0.unPPWA24.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA24_PPWA9	(PPU0.unPPWA24.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA24_PPWA10	(PPU0.unPPWA24.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA24_PPWA11	(PPU0.unPPWA24.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA24_PPWA12	(PPU0.unPPWA24.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA24_PPWA13	(PPU0.unPPWA24.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA24_PPWA14	(PPU0.unPPWA24.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA24_PPWA15	(PPU0.unPPWA24.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA24_PPWA16	(PPU0.unPPWA24.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA24_PPWA17	(PPU0.unPPWA24.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA24_PPWA18	(PPU0.unPPWA24.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA24_PPWA19	(PPU0.unPPWA24.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA24_PPWA20	(PPU0.unPPWA24.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA24_PPWA21	(PPU0.unPPWA24.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA24_PPWA22	(PPU0.unPPWA24.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA24_PPWA23	(PPU0.unPPWA24.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA24_PPWA24	(PPU0.unPPWA24.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA24_PPWA25	(PPU0.unPPWA24.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA24_PPWA26	(PPU0.unPPWA24.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA24_PPWA27	(PPU0.unPPWA24.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA24_PPWA28	(PPU0.unPPWA24.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA24_PPWA29	(PPU0.unPPWA24.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA24_PPWA30	(PPU0.unPPWA24.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA24_PPWA31	(PPU0.unPPWA24.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA25	(PPU0.unPPWA25.u32Register)  /*@rg@*/
#define PPU0_PPWA25_PPWA0	(PPU0.unPPWA25.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA25_PPWA1	(PPU0.unPPWA25.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA25_PPWA2	(PPU0.unPPWA25.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA25_PPWA3	(PPU0.unPPWA25.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA25_PPWA4	(PPU0.unPPWA25.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA25_PPWA5	(PPU0.unPPWA25.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA25_PPWA6	(PPU0.unPPWA25.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA25_PPWA7	(PPU0.unPPWA25.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA25_PPWA8	(PPU0.unPPWA25.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA25_PPWA9	(PPU0.unPPWA25.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA25_PPWA10	(PPU0.unPPWA25.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA25_PPWA11	(PPU0.unPPWA25.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA25_PPWA12	(PPU0.unPPWA25.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA25_PPWA13	(PPU0.unPPWA25.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA25_PPWA14	(PPU0.unPPWA25.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA25_PPWA15	(PPU0.unPPWA25.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA25_PPWA16	(PPU0.unPPWA25.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA25_PPWA17	(PPU0.unPPWA25.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA25_PPWA18	(PPU0.unPPWA25.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA25_PPWA19	(PPU0.unPPWA25.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA25_PPWA20	(PPU0.unPPWA25.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA25_PPWA21	(PPU0.unPPWA25.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA25_PPWA22	(PPU0.unPPWA25.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA25_PPWA23	(PPU0.unPPWA25.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA25_PPWA24	(PPU0.unPPWA25.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA25_PPWA25	(PPU0.unPPWA25.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA25_PPWA26	(PPU0.unPPWA25.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA25_PPWA27	(PPU0.unPPWA25.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA25_PPWA28	(PPU0.unPPWA25.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA25_PPWA29	(PPU0.unPPWA25.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA25_PPWA30	(PPU0.unPPWA25.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA25_PPWA31	(PPU0.unPPWA25.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA26	(PPU0.unPPWA26.u32Register)  /*@rg@*/
#define PPU0_PPWA26_PPWA0	(PPU0.unPPWA26.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA26_PPWA1	(PPU0.unPPWA26.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA26_PPWA2	(PPU0.unPPWA26.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA26_PPWA3	(PPU0.unPPWA26.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA26_PPWA4	(PPU0.unPPWA26.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA26_PPWA5	(PPU0.unPPWA26.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA26_PPWA6	(PPU0.unPPWA26.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA26_PPWA7	(PPU0.unPPWA26.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA26_PPWA8	(PPU0.unPPWA26.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA26_PPWA9	(PPU0.unPPWA26.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA26_PPWA10	(PPU0.unPPWA26.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA26_PPWA11	(PPU0.unPPWA26.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA26_PPWA12	(PPU0.unPPWA26.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA26_PPWA13	(PPU0.unPPWA26.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA26_PPWA14	(PPU0.unPPWA26.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA26_PPWA15	(PPU0.unPPWA26.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA26_PPWA16	(PPU0.unPPWA26.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA26_PPWA17	(PPU0.unPPWA26.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA26_PPWA18	(PPU0.unPPWA26.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA26_PPWA19	(PPU0.unPPWA26.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA26_PPWA20	(PPU0.unPPWA26.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA26_PPWA21	(PPU0.unPPWA26.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA26_PPWA22	(PPU0.unPPWA26.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA26_PPWA23	(PPU0.unPPWA26.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA26_PPWA24	(PPU0.unPPWA26.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA26_PPWA25	(PPU0.unPPWA26.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA26_PPWA26	(PPU0.unPPWA26.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA26_PPWA27	(PPU0.unPPWA26.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA26_PPWA28	(PPU0.unPPWA26.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA26_PPWA29	(PPU0.unPPWA26.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA26_PPWA30	(PPU0.unPPWA26.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA26_PPWA31	(PPU0.unPPWA26.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA27	(PPU0.unPPWA27.u32Register)  /*@rg@*/
#define PPU0_PPWA27_PPWA0	(PPU0.unPPWA27.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA27_PPWA1	(PPU0.unPPWA27.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA27_PPWA2	(PPU0.unPPWA27.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA27_PPWA3	(PPU0.unPPWA27.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA27_PPWA4	(PPU0.unPPWA27.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA27_PPWA5	(PPU0.unPPWA27.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA27_PPWA6	(PPU0.unPPWA27.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA27_PPWA7	(PPU0.unPPWA27.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA27_PPWA8	(PPU0.unPPWA27.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA27_PPWA9	(PPU0.unPPWA27.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA27_PPWA10	(PPU0.unPPWA27.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA27_PPWA11	(PPU0.unPPWA27.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA27_PPWA12	(PPU0.unPPWA27.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA27_PPWA13	(PPU0.unPPWA27.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA27_PPWA14	(PPU0.unPPWA27.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA27_PPWA15	(PPU0.unPPWA27.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA27_PPWA16	(PPU0.unPPWA27.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA27_PPWA17	(PPU0.unPPWA27.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA27_PPWA18	(PPU0.unPPWA27.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA27_PPWA19	(PPU0.unPPWA27.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA27_PPWA20	(PPU0.unPPWA27.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA27_PPWA21	(PPU0.unPPWA27.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA27_PPWA22	(PPU0.unPPWA27.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA27_PPWA23	(PPU0.unPPWA27.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA27_PPWA24	(PPU0.unPPWA27.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA27_PPWA25	(PPU0.unPPWA27.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA27_PPWA26	(PPU0.unPPWA27.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA27_PPWA27	(PPU0.unPPWA27.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA27_PPWA28	(PPU0.unPPWA27.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA27_PPWA29	(PPU0.unPPWA27.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA27_PPWA30	(PPU0.unPPWA27.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA27_PPWA31	(PPU0.unPPWA27.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA28	(PPU0.unPPWA28.u32Register)  /*@rg@*/
#define PPU0_PPWA28_PPWA0	(PPU0.unPPWA28.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA28_PPWA1	(PPU0.unPPWA28.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA28_PPWA2	(PPU0.unPPWA28.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA28_PPWA3	(PPU0.unPPWA28.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA28_PPWA4	(PPU0.unPPWA28.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA28_PPWA5	(PPU0.unPPWA28.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA28_PPWA6	(PPU0.unPPWA28.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA28_PPWA7	(PPU0.unPPWA28.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA28_PPWA8	(PPU0.unPPWA28.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA28_PPWA9	(PPU0.unPPWA28.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA28_PPWA10	(PPU0.unPPWA28.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA28_PPWA11	(PPU0.unPPWA28.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA28_PPWA12	(PPU0.unPPWA28.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA28_PPWA13	(PPU0.unPPWA28.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA28_PPWA14	(PPU0.unPPWA28.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA28_PPWA15	(PPU0.unPPWA28.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA28_PPWA16	(PPU0.unPPWA28.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA28_PPWA17	(PPU0.unPPWA28.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA28_PPWA18	(PPU0.unPPWA28.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA28_PPWA19	(PPU0.unPPWA28.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA28_PPWA20	(PPU0.unPPWA28.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA28_PPWA21	(PPU0.unPPWA28.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA28_PPWA22	(PPU0.unPPWA28.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA28_PPWA23	(PPU0.unPPWA28.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA28_PPWA24	(PPU0.unPPWA28.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA28_PPWA25	(PPU0.unPPWA28.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA28_PPWA26	(PPU0.unPPWA28.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA28_PPWA27	(PPU0.unPPWA28.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA28_PPWA28	(PPU0.unPPWA28.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA28_PPWA29	(PPU0.unPPWA28.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA28_PPWA30	(PPU0.unPPWA28.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA28_PPWA31	(PPU0.unPPWA28.stcField.u1PPWA31)  /*@bf@*/

#define PPU0_PPWA29	(PPU0.unPPWA29.u32Register)  /*@rg@*/
#define PPU0_PPWA29_PPWA0	(PPU0.unPPWA29.stcField.u1PPWA0)  /*@bf@*/
#define PPU0_PPWA29_PPWA1	(PPU0.unPPWA29.stcField.u1PPWA1)  /*@bf@*/
#define PPU0_PPWA29_PPWA2	(PPU0.unPPWA29.stcField.u1PPWA2)  /*@bf@*/
#define PPU0_PPWA29_PPWA3	(PPU0.unPPWA29.stcField.u1PPWA3)  /*@bf@*/
#define PPU0_PPWA29_PPWA4	(PPU0.unPPWA29.stcField.u1PPWA4)  /*@bf@*/
#define PPU0_PPWA29_PPWA5	(PPU0.unPPWA29.stcField.u1PPWA5)  /*@bf@*/
#define PPU0_PPWA29_PPWA6	(PPU0.unPPWA29.stcField.u1PPWA6)  /*@bf@*/
#define PPU0_PPWA29_PPWA7	(PPU0.unPPWA29.stcField.u1PPWA7)  /*@bf@*/
#define PPU0_PPWA29_PPWA8	(PPU0.unPPWA29.stcField.u1PPWA8)  /*@bf@*/
#define PPU0_PPWA29_PPWA9	(PPU0.unPPWA29.stcField.u1PPWA9)  /*@bf@*/
#define PPU0_PPWA29_PPWA10	(PPU0.unPPWA29.stcField.u1PPWA10)  /*@bf@*/
#define PPU0_PPWA29_PPWA11	(PPU0.unPPWA29.stcField.u1PPWA11)  /*@bf@*/
#define PPU0_PPWA29_PPWA12	(PPU0.unPPWA29.stcField.u1PPWA12)  /*@bf@*/
#define PPU0_PPWA29_PPWA13	(PPU0.unPPWA29.stcField.u1PPWA13)  /*@bf@*/
#define PPU0_PPWA29_PPWA14	(PPU0.unPPWA29.stcField.u1PPWA14)  /*@bf@*/
#define PPU0_PPWA29_PPWA15	(PPU0.unPPWA29.stcField.u1PPWA15)  /*@bf@*/
#define PPU0_PPWA29_PPWA16	(PPU0.unPPWA29.stcField.u1PPWA16)  /*@bf@*/
#define PPU0_PPWA29_PPWA17	(PPU0.unPPWA29.stcField.u1PPWA17)  /*@bf@*/
#define PPU0_PPWA29_PPWA18	(PPU0.unPPWA29.stcField.u1PPWA18)  /*@bf@*/
#define PPU0_PPWA29_PPWA19	(PPU0.unPPWA29.stcField.u1PPWA19)  /*@bf@*/
#define PPU0_PPWA29_PPWA20	(PPU0.unPPWA29.stcField.u1PPWA20)  /*@bf@*/
#define PPU0_PPWA29_PPWA21	(PPU0.unPPWA29.stcField.u1PPWA21)  /*@bf@*/
#define PPU0_PPWA29_PPWA22	(PPU0.unPPWA29.stcField.u1PPWA22)  /*@bf@*/
#define PPU0_PPWA29_PPWA23	(PPU0.unPPWA29.stcField.u1PPWA23)  /*@bf@*/
#define PPU0_PPWA29_PPWA24	(PPU0.unPPWA29.stcField.u1PPWA24)  /*@bf@*/
#define PPU0_PPWA29_PPWA25	(PPU0.unPPWA29.stcField.u1PPWA25)  /*@bf@*/
#define PPU0_PPWA29_PPWA26	(PPU0.unPPWA29.stcField.u1PPWA26)  /*@bf@*/
#define PPU0_PPWA29_PPWA27	(PPU0.unPPWA29.stcField.u1PPWA27)  /*@bf@*/
#define PPU0_PPWA29_PPWA28	(PPU0.unPPWA29.stcField.u1PPWA28)  /*@bf@*/
#define PPU0_PPWA29_PPWA29	(PPU0.unPPWA29.stcField.u1PPWA29)  /*@bf@*/
#define PPU0_PPWA29_PPWA30	(PPU0.unPPWA29.stcField.u1PPWA30)  /*@bf@*/
#define PPU0_PPWA29_PPWA31	(PPU0.unPPWA29.stcField.u1PPWA31)  /*@bf@*/

typedef struct stc_ppu0_ppwan_field{
    uint_io32_t		u1PPWA0:1;
    uint_io32_t		u1PPWA1:1;
    uint_io32_t		u1PPWA2:1;
    uint_io32_t		u1PPWA3:1;
    uint_io32_t		u1PPWA4:1;
    uint_io32_t		u1PPWA5:1;
    uint_io32_t		u1PPWA6:1;
    uint_io32_t		u1PPWA7:1;
    uint_io32_t		u1PPWA8:1;
    uint_io32_t		u1PPWA9:1;
    uint_io32_t		u1PPWA10:1;
    uint_io32_t		u1PPWA11:1;
    uint_io32_t		u1PPWA12:1;
    uint_io32_t		u1PPWA13:1;
    uint_io32_t		u1PPWA14:1;
    uint_io32_t		u1PPWA15:1;
    uint_io32_t		u1PPWA16:1;
    uint_io32_t		u1PPWA17:1;
    uint_io32_t		u1PPWA18:1;
    uint_io32_t		u1PPWA19:1;
    uint_io32_t		u1PPWA20:1;
    uint_io32_t		u1PPWA21:1;
    uint_io32_t		u1PPWA22:1;
    uint_io32_t		u1PPWA23:1;
    uint_io32_t		u1PPWA24:1;
    uint_io32_t		u1PPWA25:1;
    uint_io32_t		u1PPWA26:1;
    uint_io32_t		u1PPWA27:1;
    uint_io32_t		u1PPWA28:1;
    uint_io32_t		u1PPWA29:1;
    uint_io32_t		u1PPWA30:1;
    uint_io32_t		u1PPWA31:1;
}stc_ppu0_ppwan_field_t;

typedef union un_ppu0_ppwan{
    uint_io32_t		u32Register;
    stc_ppu0_ppwan_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_ppwan_t;

/* LOCK2 */
#define PPU0_LOCK2	(PPU0.unLOCK2.u32Register)  /*@rg@*/
#define PPU0_LOCK2_L	PPU0_LOCK2  /*@bfrg@*/

typedef union un_ppu0_lock2{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_lock2_t;

/* PUWA[0-29] */
#define PPU0_PUWA0	(PPU0.unPUWA0.u32Register)  /*@rg@*/
#define PPU0_PUWA0_PUWA0	(PPU0.unPUWA0.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA0_PUWA1	(PPU0.unPUWA0.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA0_PUWA2	(PPU0.unPUWA0.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA0_PUWA3	(PPU0.unPUWA0.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA0_PUWA4	(PPU0.unPUWA0.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA0_PUWA5	(PPU0.unPUWA0.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA0_PUWA6	(PPU0.unPUWA0.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA0_PUWA7	(PPU0.unPUWA0.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA0_PUWA8	(PPU0.unPUWA0.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA0_PUWA9	(PPU0.unPUWA0.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA0_PUWA10	(PPU0.unPUWA0.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA0_PUWA11	(PPU0.unPUWA0.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA0_PUWA12	(PPU0.unPUWA0.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA0_PUWA13	(PPU0.unPUWA0.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA0_PUWA14	(PPU0.unPUWA0.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA0_PUWA15	(PPU0.unPUWA0.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA0_PUWA16	(PPU0.unPUWA0.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA0_PUWA17	(PPU0.unPUWA0.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA0_PUWA18	(PPU0.unPUWA0.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA0_PUWA19	(PPU0.unPUWA0.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA0_PUWA20	(PPU0.unPUWA0.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA0_PUWA21	(PPU0.unPUWA0.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA0_PUWA22	(PPU0.unPUWA0.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA0_PUWA23	(PPU0.unPUWA0.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA0_PUWA24	(PPU0.unPUWA0.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA0_PUWA25	(PPU0.unPUWA0.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA0_PUWA26	(PPU0.unPUWA0.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA0_PUWA27	(PPU0.unPUWA0.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA0_PUWA28	(PPU0.unPUWA0.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA0_PUWA29	(PPU0.unPUWA0.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA0_PUWA30	(PPU0.unPUWA0.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA0_PUWA31	(PPU0.unPUWA0.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA1	(PPU0.unPUWA1.u32Register)  /*@rg@*/
#define PPU0_PUWA1_PUWA0	(PPU0.unPUWA1.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA1_PUWA1	(PPU0.unPUWA1.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA1_PUWA2	(PPU0.unPUWA1.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA1_PUWA3	(PPU0.unPUWA1.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA1_PUWA4	(PPU0.unPUWA1.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA1_PUWA5	(PPU0.unPUWA1.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA1_PUWA6	(PPU0.unPUWA1.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA1_PUWA7	(PPU0.unPUWA1.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA1_PUWA8	(PPU0.unPUWA1.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA1_PUWA9	(PPU0.unPUWA1.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA1_PUWA10	(PPU0.unPUWA1.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA1_PUWA11	(PPU0.unPUWA1.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA1_PUWA12	(PPU0.unPUWA1.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA1_PUWA13	(PPU0.unPUWA1.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA1_PUWA14	(PPU0.unPUWA1.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA1_PUWA15	(PPU0.unPUWA1.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA1_PUWA16	(PPU0.unPUWA1.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA1_PUWA17	(PPU0.unPUWA1.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA1_PUWA18	(PPU0.unPUWA1.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA1_PUWA19	(PPU0.unPUWA1.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA1_PUWA20	(PPU0.unPUWA1.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA1_PUWA21	(PPU0.unPUWA1.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA1_PUWA22	(PPU0.unPUWA1.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA1_PUWA23	(PPU0.unPUWA1.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA1_PUWA24	(PPU0.unPUWA1.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA1_PUWA25	(PPU0.unPUWA1.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA1_PUWA26	(PPU0.unPUWA1.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA1_PUWA27	(PPU0.unPUWA1.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA1_PUWA28	(PPU0.unPUWA1.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA1_PUWA29	(PPU0.unPUWA1.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA1_PUWA30	(PPU0.unPUWA1.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA1_PUWA31	(PPU0.unPUWA1.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA2	(PPU0.unPUWA2.u32Register)  /*@rg@*/
#define PPU0_PUWA2_PUWA0	(PPU0.unPUWA2.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA2_PUWA1	(PPU0.unPUWA2.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA2_PUWA2	(PPU0.unPUWA2.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA2_PUWA3	(PPU0.unPUWA2.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA2_PUWA4	(PPU0.unPUWA2.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA2_PUWA5	(PPU0.unPUWA2.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA2_PUWA6	(PPU0.unPUWA2.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA2_PUWA7	(PPU0.unPUWA2.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA2_PUWA8	(PPU0.unPUWA2.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA2_PUWA9	(PPU0.unPUWA2.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA2_PUWA10	(PPU0.unPUWA2.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA2_PUWA11	(PPU0.unPUWA2.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA2_PUWA12	(PPU0.unPUWA2.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA2_PUWA13	(PPU0.unPUWA2.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA2_PUWA14	(PPU0.unPUWA2.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA2_PUWA15	(PPU0.unPUWA2.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA2_PUWA16	(PPU0.unPUWA2.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA2_PUWA17	(PPU0.unPUWA2.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA2_PUWA18	(PPU0.unPUWA2.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA2_PUWA19	(PPU0.unPUWA2.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA2_PUWA20	(PPU0.unPUWA2.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA2_PUWA21	(PPU0.unPUWA2.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA2_PUWA22	(PPU0.unPUWA2.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA2_PUWA23	(PPU0.unPUWA2.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA2_PUWA24	(PPU0.unPUWA2.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA2_PUWA25	(PPU0.unPUWA2.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA2_PUWA26	(PPU0.unPUWA2.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA2_PUWA27	(PPU0.unPUWA2.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA2_PUWA28	(PPU0.unPUWA2.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA2_PUWA29	(PPU0.unPUWA2.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA2_PUWA30	(PPU0.unPUWA2.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA2_PUWA31	(PPU0.unPUWA2.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA3	(PPU0.unPUWA3.u32Register)  /*@rg@*/
#define PPU0_PUWA3_PUWA0	(PPU0.unPUWA3.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA3_PUWA1	(PPU0.unPUWA3.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA3_PUWA2	(PPU0.unPUWA3.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA3_PUWA3	(PPU0.unPUWA3.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA3_PUWA4	(PPU0.unPUWA3.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA3_PUWA5	(PPU0.unPUWA3.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA3_PUWA6	(PPU0.unPUWA3.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA3_PUWA7	(PPU0.unPUWA3.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA3_PUWA8	(PPU0.unPUWA3.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA3_PUWA9	(PPU0.unPUWA3.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA3_PUWA10	(PPU0.unPUWA3.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA3_PUWA11	(PPU0.unPUWA3.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA3_PUWA12	(PPU0.unPUWA3.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA3_PUWA13	(PPU0.unPUWA3.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA3_PUWA14	(PPU0.unPUWA3.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA3_PUWA15	(PPU0.unPUWA3.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA3_PUWA16	(PPU0.unPUWA3.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA3_PUWA17	(PPU0.unPUWA3.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA3_PUWA18	(PPU0.unPUWA3.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA3_PUWA19	(PPU0.unPUWA3.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA3_PUWA20	(PPU0.unPUWA3.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA3_PUWA21	(PPU0.unPUWA3.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA3_PUWA22	(PPU0.unPUWA3.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA3_PUWA23	(PPU0.unPUWA3.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA3_PUWA24	(PPU0.unPUWA3.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA3_PUWA25	(PPU0.unPUWA3.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA3_PUWA26	(PPU0.unPUWA3.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA3_PUWA27	(PPU0.unPUWA3.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA3_PUWA28	(PPU0.unPUWA3.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA3_PUWA29	(PPU0.unPUWA3.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA3_PUWA30	(PPU0.unPUWA3.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA3_PUWA31	(PPU0.unPUWA3.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA4	(PPU0.unPUWA4.u32Register)  /*@rg@*/
#define PPU0_PUWA4_PUWA0	(PPU0.unPUWA4.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA4_PUWA1	(PPU0.unPUWA4.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA4_PUWA2	(PPU0.unPUWA4.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA4_PUWA3	(PPU0.unPUWA4.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA4_PUWA4	(PPU0.unPUWA4.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA4_PUWA5	(PPU0.unPUWA4.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA4_PUWA6	(PPU0.unPUWA4.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA4_PUWA7	(PPU0.unPUWA4.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA4_PUWA8	(PPU0.unPUWA4.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA4_PUWA9	(PPU0.unPUWA4.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA4_PUWA10	(PPU0.unPUWA4.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA4_PUWA11	(PPU0.unPUWA4.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA4_PUWA12	(PPU0.unPUWA4.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA4_PUWA13	(PPU0.unPUWA4.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA4_PUWA14	(PPU0.unPUWA4.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA4_PUWA15	(PPU0.unPUWA4.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA4_PUWA16	(PPU0.unPUWA4.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA4_PUWA17	(PPU0.unPUWA4.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA4_PUWA18	(PPU0.unPUWA4.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA4_PUWA19	(PPU0.unPUWA4.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA4_PUWA20	(PPU0.unPUWA4.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA4_PUWA21	(PPU0.unPUWA4.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA4_PUWA22	(PPU0.unPUWA4.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA4_PUWA23	(PPU0.unPUWA4.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA4_PUWA24	(PPU0.unPUWA4.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA4_PUWA25	(PPU0.unPUWA4.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA4_PUWA26	(PPU0.unPUWA4.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA4_PUWA27	(PPU0.unPUWA4.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA4_PUWA28	(PPU0.unPUWA4.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA4_PUWA29	(PPU0.unPUWA4.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA4_PUWA30	(PPU0.unPUWA4.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA4_PUWA31	(PPU0.unPUWA4.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA5	(PPU0.unPUWA5.u32Register)  /*@rg@*/
#define PPU0_PUWA5_PUWA0	(PPU0.unPUWA5.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA5_PUWA1	(PPU0.unPUWA5.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA5_PUWA2	(PPU0.unPUWA5.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA5_PUWA3	(PPU0.unPUWA5.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA5_PUWA4	(PPU0.unPUWA5.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA5_PUWA5	(PPU0.unPUWA5.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA5_PUWA6	(PPU0.unPUWA5.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA5_PUWA7	(PPU0.unPUWA5.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA5_PUWA8	(PPU0.unPUWA5.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA5_PUWA9	(PPU0.unPUWA5.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA5_PUWA10	(PPU0.unPUWA5.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA5_PUWA11	(PPU0.unPUWA5.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA5_PUWA12	(PPU0.unPUWA5.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA5_PUWA13	(PPU0.unPUWA5.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA5_PUWA14	(PPU0.unPUWA5.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA5_PUWA15	(PPU0.unPUWA5.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA5_PUWA16	(PPU0.unPUWA5.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA5_PUWA17	(PPU0.unPUWA5.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA5_PUWA18	(PPU0.unPUWA5.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA5_PUWA19	(PPU0.unPUWA5.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA5_PUWA20	(PPU0.unPUWA5.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA5_PUWA21	(PPU0.unPUWA5.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA5_PUWA22	(PPU0.unPUWA5.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA5_PUWA23	(PPU0.unPUWA5.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA5_PUWA24	(PPU0.unPUWA5.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA5_PUWA25	(PPU0.unPUWA5.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA5_PUWA26	(PPU0.unPUWA5.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA5_PUWA27	(PPU0.unPUWA5.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA5_PUWA28	(PPU0.unPUWA5.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA5_PUWA29	(PPU0.unPUWA5.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA5_PUWA30	(PPU0.unPUWA5.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA5_PUWA31	(PPU0.unPUWA5.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA6	(PPU0.unPUWA6.u32Register)  /*@rg@*/
#define PPU0_PUWA6_PUWA0	(PPU0.unPUWA6.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA6_PUWA1	(PPU0.unPUWA6.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA6_PUWA2	(PPU0.unPUWA6.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA6_PUWA3	(PPU0.unPUWA6.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA6_PUWA4	(PPU0.unPUWA6.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA6_PUWA5	(PPU0.unPUWA6.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA6_PUWA6	(PPU0.unPUWA6.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA6_PUWA7	(PPU0.unPUWA6.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA6_PUWA8	(PPU0.unPUWA6.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA6_PUWA9	(PPU0.unPUWA6.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA6_PUWA10	(PPU0.unPUWA6.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA6_PUWA11	(PPU0.unPUWA6.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA6_PUWA12	(PPU0.unPUWA6.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA6_PUWA13	(PPU0.unPUWA6.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA6_PUWA14	(PPU0.unPUWA6.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA6_PUWA15	(PPU0.unPUWA6.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA6_PUWA16	(PPU0.unPUWA6.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA6_PUWA17	(PPU0.unPUWA6.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA6_PUWA18	(PPU0.unPUWA6.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA6_PUWA19	(PPU0.unPUWA6.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA6_PUWA20	(PPU0.unPUWA6.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA6_PUWA21	(PPU0.unPUWA6.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA6_PUWA22	(PPU0.unPUWA6.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA6_PUWA23	(PPU0.unPUWA6.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA6_PUWA24	(PPU0.unPUWA6.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA6_PUWA25	(PPU0.unPUWA6.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA6_PUWA26	(PPU0.unPUWA6.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA6_PUWA27	(PPU0.unPUWA6.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA6_PUWA28	(PPU0.unPUWA6.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA6_PUWA29	(PPU0.unPUWA6.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA6_PUWA30	(PPU0.unPUWA6.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA6_PUWA31	(PPU0.unPUWA6.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA7	(PPU0.unPUWA7.u32Register)  /*@rg@*/
#define PPU0_PUWA7_PUWA0	(PPU0.unPUWA7.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA7_PUWA1	(PPU0.unPUWA7.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA7_PUWA2	(PPU0.unPUWA7.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA7_PUWA3	(PPU0.unPUWA7.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA7_PUWA4	(PPU0.unPUWA7.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA7_PUWA5	(PPU0.unPUWA7.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA7_PUWA6	(PPU0.unPUWA7.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA7_PUWA7	(PPU0.unPUWA7.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA7_PUWA8	(PPU0.unPUWA7.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA7_PUWA9	(PPU0.unPUWA7.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA7_PUWA10	(PPU0.unPUWA7.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA7_PUWA11	(PPU0.unPUWA7.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA7_PUWA12	(PPU0.unPUWA7.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA7_PUWA13	(PPU0.unPUWA7.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA7_PUWA14	(PPU0.unPUWA7.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA7_PUWA15	(PPU0.unPUWA7.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA7_PUWA16	(PPU0.unPUWA7.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA7_PUWA17	(PPU0.unPUWA7.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA7_PUWA18	(PPU0.unPUWA7.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA7_PUWA19	(PPU0.unPUWA7.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA7_PUWA20	(PPU0.unPUWA7.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA7_PUWA21	(PPU0.unPUWA7.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA7_PUWA22	(PPU0.unPUWA7.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA7_PUWA23	(PPU0.unPUWA7.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA7_PUWA24	(PPU0.unPUWA7.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA7_PUWA25	(PPU0.unPUWA7.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA7_PUWA26	(PPU0.unPUWA7.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA7_PUWA27	(PPU0.unPUWA7.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA7_PUWA28	(PPU0.unPUWA7.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA7_PUWA29	(PPU0.unPUWA7.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA7_PUWA30	(PPU0.unPUWA7.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA7_PUWA31	(PPU0.unPUWA7.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA8	(PPU0.unPUWA8.u32Register)  /*@rg@*/
#define PPU0_PUWA8_PUWA0	(PPU0.unPUWA8.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA8_PUWA1	(PPU0.unPUWA8.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA8_PUWA2	(PPU0.unPUWA8.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA8_PUWA3	(PPU0.unPUWA8.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA8_PUWA4	(PPU0.unPUWA8.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA8_PUWA5	(PPU0.unPUWA8.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA8_PUWA6	(PPU0.unPUWA8.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA8_PUWA7	(PPU0.unPUWA8.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA8_PUWA8	(PPU0.unPUWA8.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA8_PUWA9	(PPU0.unPUWA8.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA8_PUWA10	(PPU0.unPUWA8.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA8_PUWA11	(PPU0.unPUWA8.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA8_PUWA12	(PPU0.unPUWA8.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA8_PUWA13	(PPU0.unPUWA8.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA8_PUWA14	(PPU0.unPUWA8.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA8_PUWA15	(PPU0.unPUWA8.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA8_PUWA16	(PPU0.unPUWA8.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA8_PUWA17	(PPU0.unPUWA8.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA8_PUWA18	(PPU0.unPUWA8.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA8_PUWA19	(PPU0.unPUWA8.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA8_PUWA20	(PPU0.unPUWA8.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA8_PUWA21	(PPU0.unPUWA8.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA8_PUWA22	(PPU0.unPUWA8.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA8_PUWA23	(PPU0.unPUWA8.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA8_PUWA24	(PPU0.unPUWA8.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA8_PUWA25	(PPU0.unPUWA8.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA8_PUWA26	(PPU0.unPUWA8.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA8_PUWA27	(PPU0.unPUWA8.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA8_PUWA28	(PPU0.unPUWA8.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA8_PUWA29	(PPU0.unPUWA8.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA8_PUWA30	(PPU0.unPUWA8.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA8_PUWA31	(PPU0.unPUWA8.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA9	(PPU0.unPUWA9.u32Register)  /*@rg@*/
#define PPU0_PUWA9_PUWA0	(PPU0.unPUWA9.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA9_PUWA1	(PPU0.unPUWA9.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA9_PUWA2	(PPU0.unPUWA9.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA9_PUWA3	(PPU0.unPUWA9.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA9_PUWA4	(PPU0.unPUWA9.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA9_PUWA5	(PPU0.unPUWA9.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA9_PUWA6	(PPU0.unPUWA9.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA9_PUWA7	(PPU0.unPUWA9.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA9_PUWA8	(PPU0.unPUWA9.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA9_PUWA9	(PPU0.unPUWA9.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA9_PUWA10	(PPU0.unPUWA9.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA9_PUWA11	(PPU0.unPUWA9.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA9_PUWA12	(PPU0.unPUWA9.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA9_PUWA13	(PPU0.unPUWA9.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA9_PUWA14	(PPU0.unPUWA9.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA9_PUWA15	(PPU0.unPUWA9.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA9_PUWA16	(PPU0.unPUWA9.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA9_PUWA17	(PPU0.unPUWA9.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA9_PUWA18	(PPU0.unPUWA9.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA9_PUWA19	(PPU0.unPUWA9.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA9_PUWA20	(PPU0.unPUWA9.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA9_PUWA21	(PPU0.unPUWA9.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA9_PUWA22	(PPU0.unPUWA9.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA9_PUWA23	(PPU0.unPUWA9.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA9_PUWA24	(PPU0.unPUWA9.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA9_PUWA25	(PPU0.unPUWA9.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA9_PUWA26	(PPU0.unPUWA9.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA9_PUWA27	(PPU0.unPUWA9.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA9_PUWA28	(PPU0.unPUWA9.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA9_PUWA29	(PPU0.unPUWA9.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA9_PUWA30	(PPU0.unPUWA9.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA9_PUWA31	(PPU0.unPUWA9.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA10	(PPU0.unPUWA10.u32Register)  /*@rg@*/
#define PPU0_PUWA10_PUWA0	(PPU0.unPUWA10.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA10_PUWA1	(PPU0.unPUWA10.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA10_PUWA2	(PPU0.unPUWA10.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA10_PUWA3	(PPU0.unPUWA10.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA10_PUWA4	(PPU0.unPUWA10.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA10_PUWA5	(PPU0.unPUWA10.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA10_PUWA6	(PPU0.unPUWA10.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA10_PUWA7	(PPU0.unPUWA10.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA10_PUWA8	(PPU0.unPUWA10.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA10_PUWA9	(PPU0.unPUWA10.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA10_PUWA10	(PPU0.unPUWA10.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA10_PUWA11	(PPU0.unPUWA10.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA10_PUWA12	(PPU0.unPUWA10.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA10_PUWA13	(PPU0.unPUWA10.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA10_PUWA14	(PPU0.unPUWA10.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA10_PUWA15	(PPU0.unPUWA10.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA10_PUWA16	(PPU0.unPUWA10.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA10_PUWA17	(PPU0.unPUWA10.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA10_PUWA18	(PPU0.unPUWA10.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA10_PUWA19	(PPU0.unPUWA10.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA10_PUWA20	(PPU0.unPUWA10.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA10_PUWA21	(PPU0.unPUWA10.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA10_PUWA22	(PPU0.unPUWA10.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA10_PUWA23	(PPU0.unPUWA10.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA10_PUWA24	(PPU0.unPUWA10.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA10_PUWA25	(PPU0.unPUWA10.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA10_PUWA26	(PPU0.unPUWA10.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA10_PUWA27	(PPU0.unPUWA10.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA10_PUWA28	(PPU0.unPUWA10.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA10_PUWA29	(PPU0.unPUWA10.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA10_PUWA30	(PPU0.unPUWA10.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA10_PUWA31	(PPU0.unPUWA10.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA11	(PPU0.unPUWA11.u32Register)  /*@rg@*/
#define PPU0_PUWA11_PUWA0	(PPU0.unPUWA11.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA11_PUWA1	(PPU0.unPUWA11.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA11_PUWA2	(PPU0.unPUWA11.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA11_PUWA3	(PPU0.unPUWA11.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA11_PUWA4	(PPU0.unPUWA11.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA11_PUWA5	(PPU0.unPUWA11.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA11_PUWA6	(PPU0.unPUWA11.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA11_PUWA7	(PPU0.unPUWA11.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA11_PUWA8	(PPU0.unPUWA11.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA11_PUWA9	(PPU0.unPUWA11.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA11_PUWA10	(PPU0.unPUWA11.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA11_PUWA11	(PPU0.unPUWA11.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA11_PUWA12	(PPU0.unPUWA11.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA11_PUWA13	(PPU0.unPUWA11.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA11_PUWA14	(PPU0.unPUWA11.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA11_PUWA15	(PPU0.unPUWA11.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA11_PUWA16	(PPU0.unPUWA11.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA11_PUWA17	(PPU0.unPUWA11.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA11_PUWA18	(PPU0.unPUWA11.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA11_PUWA19	(PPU0.unPUWA11.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA11_PUWA20	(PPU0.unPUWA11.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA11_PUWA21	(PPU0.unPUWA11.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA11_PUWA22	(PPU0.unPUWA11.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA11_PUWA23	(PPU0.unPUWA11.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA11_PUWA24	(PPU0.unPUWA11.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA11_PUWA25	(PPU0.unPUWA11.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA11_PUWA26	(PPU0.unPUWA11.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA11_PUWA27	(PPU0.unPUWA11.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA11_PUWA28	(PPU0.unPUWA11.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA11_PUWA29	(PPU0.unPUWA11.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA11_PUWA30	(PPU0.unPUWA11.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA11_PUWA31	(PPU0.unPUWA11.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA12	(PPU0.unPUWA12.u32Register)  /*@rg@*/
#define PPU0_PUWA12_PUWA0	(PPU0.unPUWA12.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA12_PUWA1	(PPU0.unPUWA12.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA12_PUWA2	(PPU0.unPUWA12.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA12_PUWA3	(PPU0.unPUWA12.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA12_PUWA4	(PPU0.unPUWA12.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA12_PUWA5	(PPU0.unPUWA12.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA12_PUWA6	(PPU0.unPUWA12.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA12_PUWA7	(PPU0.unPUWA12.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA12_PUWA8	(PPU0.unPUWA12.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA12_PUWA9	(PPU0.unPUWA12.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA12_PUWA10	(PPU0.unPUWA12.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA12_PUWA11	(PPU0.unPUWA12.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA12_PUWA12	(PPU0.unPUWA12.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA12_PUWA13	(PPU0.unPUWA12.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA12_PUWA14	(PPU0.unPUWA12.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA12_PUWA15	(PPU0.unPUWA12.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA12_PUWA16	(PPU0.unPUWA12.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA12_PUWA17	(PPU0.unPUWA12.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA12_PUWA18	(PPU0.unPUWA12.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA12_PUWA19	(PPU0.unPUWA12.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA12_PUWA20	(PPU0.unPUWA12.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA12_PUWA21	(PPU0.unPUWA12.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA12_PUWA22	(PPU0.unPUWA12.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA12_PUWA23	(PPU0.unPUWA12.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA12_PUWA24	(PPU0.unPUWA12.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA12_PUWA25	(PPU0.unPUWA12.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA12_PUWA26	(PPU0.unPUWA12.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA12_PUWA27	(PPU0.unPUWA12.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA12_PUWA28	(PPU0.unPUWA12.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA12_PUWA29	(PPU0.unPUWA12.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA12_PUWA30	(PPU0.unPUWA12.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA12_PUWA31	(PPU0.unPUWA12.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA13	(PPU0.unPUWA13.u32Register)  /*@rg@*/
#define PPU0_PUWA13_PUWA0	(PPU0.unPUWA13.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA13_PUWA1	(PPU0.unPUWA13.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA13_PUWA2	(PPU0.unPUWA13.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA13_PUWA3	(PPU0.unPUWA13.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA13_PUWA4	(PPU0.unPUWA13.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA13_PUWA5	(PPU0.unPUWA13.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA13_PUWA6	(PPU0.unPUWA13.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA13_PUWA7	(PPU0.unPUWA13.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA13_PUWA8	(PPU0.unPUWA13.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA13_PUWA9	(PPU0.unPUWA13.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA13_PUWA10	(PPU0.unPUWA13.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA13_PUWA11	(PPU0.unPUWA13.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA13_PUWA12	(PPU0.unPUWA13.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA13_PUWA13	(PPU0.unPUWA13.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA13_PUWA14	(PPU0.unPUWA13.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA13_PUWA15	(PPU0.unPUWA13.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA13_PUWA16	(PPU0.unPUWA13.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA13_PUWA17	(PPU0.unPUWA13.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA13_PUWA18	(PPU0.unPUWA13.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA13_PUWA19	(PPU0.unPUWA13.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA13_PUWA20	(PPU0.unPUWA13.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA13_PUWA21	(PPU0.unPUWA13.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA13_PUWA22	(PPU0.unPUWA13.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA13_PUWA23	(PPU0.unPUWA13.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA13_PUWA24	(PPU0.unPUWA13.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA13_PUWA25	(PPU0.unPUWA13.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA13_PUWA26	(PPU0.unPUWA13.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA13_PUWA27	(PPU0.unPUWA13.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA13_PUWA28	(PPU0.unPUWA13.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA13_PUWA29	(PPU0.unPUWA13.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA13_PUWA30	(PPU0.unPUWA13.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA13_PUWA31	(PPU0.unPUWA13.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA14	(PPU0.unPUWA14.u32Register)  /*@rg@*/
#define PPU0_PUWA14_PUWA0	(PPU0.unPUWA14.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA14_PUWA1	(PPU0.unPUWA14.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA14_PUWA2	(PPU0.unPUWA14.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA14_PUWA3	(PPU0.unPUWA14.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA14_PUWA4	(PPU0.unPUWA14.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA14_PUWA5	(PPU0.unPUWA14.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA14_PUWA6	(PPU0.unPUWA14.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA14_PUWA7	(PPU0.unPUWA14.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA14_PUWA8	(PPU0.unPUWA14.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA14_PUWA9	(PPU0.unPUWA14.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA14_PUWA10	(PPU0.unPUWA14.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA14_PUWA11	(PPU0.unPUWA14.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA14_PUWA12	(PPU0.unPUWA14.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA14_PUWA13	(PPU0.unPUWA14.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA14_PUWA14	(PPU0.unPUWA14.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA14_PUWA15	(PPU0.unPUWA14.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA14_PUWA16	(PPU0.unPUWA14.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA14_PUWA17	(PPU0.unPUWA14.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA14_PUWA18	(PPU0.unPUWA14.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA14_PUWA19	(PPU0.unPUWA14.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA14_PUWA20	(PPU0.unPUWA14.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA14_PUWA21	(PPU0.unPUWA14.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA14_PUWA22	(PPU0.unPUWA14.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA14_PUWA23	(PPU0.unPUWA14.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA14_PUWA24	(PPU0.unPUWA14.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA14_PUWA25	(PPU0.unPUWA14.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA14_PUWA26	(PPU0.unPUWA14.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA14_PUWA27	(PPU0.unPUWA14.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA14_PUWA28	(PPU0.unPUWA14.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA14_PUWA29	(PPU0.unPUWA14.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA14_PUWA30	(PPU0.unPUWA14.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA14_PUWA31	(PPU0.unPUWA14.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA15	(PPU0.unPUWA15.u32Register)  /*@rg@*/
#define PPU0_PUWA15_PUWA0	(PPU0.unPUWA15.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA15_PUWA1	(PPU0.unPUWA15.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA15_PUWA2	(PPU0.unPUWA15.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA15_PUWA3	(PPU0.unPUWA15.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA15_PUWA4	(PPU0.unPUWA15.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA15_PUWA5	(PPU0.unPUWA15.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA15_PUWA6	(PPU0.unPUWA15.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA15_PUWA7	(PPU0.unPUWA15.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA15_PUWA8	(PPU0.unPUWA15.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA15_PUWA9	(PPU0.unPUWA15.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA15_PUWA10	(PPU0.unPUWA15.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA15_PUWA11	(PPU0.unPUWA15.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA15_PUWA12	(PPU0.unPUWA15.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA15_PUWA13	(PPU0.unPUWA15.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA15_PUWA14	(PPU0.unPUWA15.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA15_PUWA15	(PPU0.unPUWA15.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA15_PUWA16	(PPU0.unPUWA15.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA15_PUWA17	(PPU0.unPUWA15.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA15_PUWA18	(PPU0.unPUWA15.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA15_PUWA19	(PPU0.unPUWA15.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA15_PUWA20	(PPU0.unPUWA15.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA15_PUWA21	(PPU0.unPUWA15.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA15_PUWA22	(PPU0.unPUWA15.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA15_PUWA23	(PPU0.unPUWA15.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA15_PUWA24	(PPU0.unPUWA15.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA15_PUWA25	(PPU0.unPUWA15.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA15_PUWA26	(PPU0.unPUWA15.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA15_PUWA27	(PPU0.unPUWA15.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA15_PUWA28	(PPU0.unPUWA15.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA15_PUWA29	(PPU0.unPUWA15.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA15_PUWA30	(PPU0.unPUWA15.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA15_PUWA31	(PPU0.unPUWA15.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA16	(PPU0.unPUWA16.u32Register)  /*@rg@*/
#define PPU0_PUWA16_PUWA0	(PPU0.unPUWA16.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA16_PUWA1	(PPU0.unPUWA16.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA16_PUWA2	(PPU0.unPUWA16.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA16_PUWA3	(PPU0.unPUWA16.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA16_PUWA4	(PPU0.unPUWA16.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA16_PUWA5	(PPU0.unPUWA16.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA16_PUWA6	(PPU0.unPUWA16.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA16_PUWA7	(PPU0.unPUWA16.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA16_PUWA8	(PPU0.unPUWA16.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA16_PUWA9	(PPU0.unPUWA16.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA16_PUWA10	(PPU0.unPUWA16.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA16_PUWA11	(PPU0.unPUWA16.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA16_PUWA12	(PPU0.unPUWA16.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA16_PUWA13	(PPU0.unPUWA16.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA16_PUWA14	(PPU0.unPUWA16.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA16_PUWA15	(PPU0.unPUWA16.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA16_PUWA16	(PPU0.unPUWA16.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA16_PUWA17	(PPU0.unPUWA16.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA16_PUWA18	(PPU0.unPUWA16.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA16_PUWA19	(PPU0.unPUWA16.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA16_PUWA20	(PPU0.unPUWA16.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA16_PUWA21	(PPU0.unPUWA16.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA16_PUWA22	(PPU0.unPUWA16.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA16_PUWA23	(PPU0.unPUWA16.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA16_PUWA24	(PPU0.unPUWA16.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA16_PUWA25	(PPU0.unPUWA16.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA16_PUWA26	(PPU0.unPUWA16.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA16_PUWA27	(PPU0.unPUWA16.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA16_PUWA28	(PPU0.unPUWA16.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA16_PUWA29	(PPU0.unPUWA16.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA16_PUWA30	(PPU0.unPUWA16.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA16_PUWA31	(PPU0.unPUWA16.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA17	(PPU0.unPUWA17.u32Register)  /*@rg@*/
#define PPU0_PUWA17_PUWA0	(PPU0.unPUWA17.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA17_PUWA1	(PPU0.unPUWA17.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA17_PUWA2	(PPU0.unPUWA17.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA17_PUWA3	(PPU0.unPUWA17.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA17_PUWA4	(PPU0.unPUWA17.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA17_PUWA5	(PPU0.unPUWA17.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA17_PUWA6	(PPU0.unPUWA17.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA17_PUWA7	(PPU0.unPUWA17.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA17_PUWA8	(PPU0.unPUWA17.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA17_PUWA9	(PPU0.unPUWA17.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA17_PUWA10	(PPU0.unPUWA17.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA17_PUWA11	(PPU0.unPUWA17.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA17_PUWA12	(PPU0.unPUWA17.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA17_PUWA13	(PPU0.unPUWA17.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA17_PUWA14	(PPU0.unPUWA17.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA17_PUWA15	(PPU0.unPUWA17.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA17_PUWA16	(PPU0.unPUWA17.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA17_PUWA17	(PPU0.unPUWA17.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA17_PUWA18	(PPU0.unPUWA17.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA17_PUWA19	(PPU0.unPUWA17.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA17_PUWA20	(PPU0.unPUWA17.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA17_PUWA21	(PPU0.unPUWA17.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA17_PUWA22	(PPU0.unPUWA17.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA17_PUWA23	(PPU0.unPUWA17.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA17_PUWA24	(PPU0.unPUWA17.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA17_PUWA25	(PPU0.unPUWA17.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA17_PUWA26	(PPU0.unPUWA17.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA17_PUWA27	(PPU0.unPUWA17.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA17_PUWA28	(PPU0.unPUWA17.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA17_PUWA29	(PPU0.unPUWA17.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA17_PUWA30	(PPU0.unPUWA17.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA17_PUWA31	(PPU0.unPUWA17.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA18	(PPU0.unPUWA18.u32Register)  /*@rg@*/
#define PPU0_PUWA18_PUWA0	(PPU0.unPUWA18.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA18_PUWA1	(PPU0.unPUWA18.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA18_PUWA2	(PPU0.unPUWA18.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA18_PUWA3	(PPU0.unPUWA18.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA18_PUWA4	(PPU0.unPUWA18.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA18_PUWA5	(PPU0.unPUWA18.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA18_PUWA6	(PPU0.unPUWA18.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA18_PUWA7	(PPU0.unPUWA18.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA18_PUWA8	(PPU0.unPUWA18.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA18_PUWA9	(PPU0.unPUWA18.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA18_PUWA10	(PPU0.unPUWA18.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA18_PUWA11	(PPU0.unPUWA18.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA18_PUWA12	(PPU0.unPUWA18.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA18_PUWA13	(PPU0.unPUWA18.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA18_PUWA14	(PPU0.unPUWA18.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA18_PUWA15	(PPU0.unPUWA18.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA18_PUWA16	(PPU0.unPUWA18.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA18_PUWA17	(PPU0.unPUWA18.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA18_PUWA18	(PPU0.unPUWA18.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA18_PUWA19	(PPU0.unPUWA18.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA18_PUWA20	(PPU0.unPUWA18.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA18_PUWA21	(PPU0.unPUWA18.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA18_PUWA22	(PPU0.unPUWA18.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA18_PUWA23	(PPU0.unPUWA18.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA18_PUWA24	(PPU0.unPUWA18.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA18_PUWA25	(PPU0.unPUWA18.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA18_PUWA26	(PPU0.unPUWA18.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA18_PUWA27	(PPU0.unPUWA18.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA18_PUWA28	(PPU0.unPUWA18.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA18_PUWA29	(PPU0.unPUWA18.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA18_PUWA30	(PPU0.unPUWA18.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA18_PUWA31	(PPU0.unPUWA18.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA19	(PPU0.unPUWA19.u32Register)  /*@rg@*/
#define PPU0_PUWA19_PUWA0	(PPU0.unPUWA19.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA19_PUWA1	(PPU0.unPUWA19.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA19_PUWA2	(PPU0.unPUWA19.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA19_PUWA3	(PPU0.unPUWA19.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA19_PUWA4	(PPU0.unPUWA19.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA19_PUWA5	(PPU0.unPUWA19.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA19_PUWA6	(PPU0.unPUWA19.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA19_PUWA7	(PPU0.unPUWA19.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA19_PUWA8	(PPU0.unPUWA19.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA19_PUWA9	(PPU0.unPUWA19.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA19_PUWA10	(PPU0.unPUWA19.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA19_PUWA11	(PPU0.unPUWA19.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA19_PUWA12	(PPU0.unPUWA19.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA19_PUWA13	(PPU0.unPUWA19.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA19_PUWA14	(PPU0.unPUWA19.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA19_PUWA15	(PPU0.unPUWA19.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA19_PUWA16	(PPU0.unPUWA19.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA19_PUWA17	(PPU0.unPUWA19.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA19_PUWA18	(PPU0.unPUWA19.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA19_PUWA19	(PPU0.unPUWA19.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA19_PUWA20	(PPU0.unPUWA19.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA19_PUWA21	(PPU0.unPUWA19.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA19_PUWA22	(PPU0.unPUWA19.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA19_PUWA23	(PPU0.unPUWA19.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA19_PUWA24	(PPU0.unPUWA19.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA19_PUWA25	(PPU0.unPUWA19.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA19_PUWA26	(PPU0.unPUWA19.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA19_PUWA27	(PPU0.unPUWA19.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA19_PUWA28	(PPU0.unPUWA19.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA19_PUWA29	(PPU0.unPUWA19.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA19_PUWA30	(PPU0.unPUWA19.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA19_PUWA31	(PPU0.unPUWA19.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA20	(PPU0.unPUWA20.u32Register)  /*@rg@*/
#define PPU0_PUWA20_PUWA0	(PPU0.unPUWA20.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA20_PUWA1	(PPU0.unPUWA20.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA20_PUWA2	(PPU0.unPUWA20.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA20_PUWA3	(PPU0.unPUWA20.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA20_PUWA4	(PPU0.unPUWA20.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA20_PUWA5	(PPU0.unPUWA20.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA20_PUWA6	(PPU0.unPUWA20.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA20_PUWA7	(PPU0.unPUWA20.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA20_PUWA8	(PPU0.unPUWA20.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA20_PUWA9	(PPU0.unPUWA20.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA20_PUWA10	(PPU0.unPUWA20.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA20_PUWA11	(PPU0.unPUWA20.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA20_PUWA12	(PPU0.unPUWA20.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA20_PUWA13	(PPU0.unPUWA20.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA20_PUWA14	(PPU0.unPUWA20.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA20_PUWA15	(PPU0.unPUWA20.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA20_PUWA16	(PPU0.unPUWA20.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA20_PUWA17	(PPU0.unPUWA20.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA20_PUWA18	(PPU0.unPUWA20.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA20_PUWA19	(PPU0.unPUWA20.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA20_PUWA20	(PPU0.unPUWA20.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA20_PUWA21	(PPU0.unPUWA20.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA20_PUWA22	(PPU0.unPUWA20.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA20_PUWA23	(PPU0.unPUWA20.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA20_PUWA24	(PPU0.unPUWA20.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA20_PUWA25	(PPU0.unPUWA20.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA20_PUWA26	(PPU0.unPUWA20.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA20_PUWA27	(PPU0.unPUWA20.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA20_PUWA28	(PPU0.unPUWA20.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA20_PUWA29	(PPU0.unPUWA20.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA20_PUWA30	(PPU0.unPUWA20.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA20_PUWA31	(PPU0.unPUWA20.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA21	(PPU0.unPUWA21.u32Register)  /*@rg@*/
#define PPU0_PUWA21_PUWA0	(PPU0.unPUWA21.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA21_PUWA1	(PPU0.unPUWA21.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA21_PUWA2	(PPU0.unPUWA21.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA21_PUWA3	(PPU0.unPUWA21.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA21_PUWA4	(PPU0.unPUWA21.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA21_PUWA5	(PPU0.unPUWA21.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA21_PUWA6	(PPU0.unPUWA21.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA21_PUWA7	(PPU0.unPUWA21.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA21_PUWA8	(PPU0.unPUWA21.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA21_PUWA9	(PPU0.unPUWA21.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA21_PUWA10	(PPU0.unPUWA21.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA21_PUWA11	(PPU0.unPUWA21.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA21_PUWA12	(PPU0.unPUWA21.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA21_PUWA13	(PPU0.unPUWA21.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA21_PUWA14	(PPU0.unPUWA21.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA21_PUWA15	(PPU0.unPUWA21.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA21_PUWA16	(PPU0.unPUWA21.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA21_PUWA17	(PPU0.unPUWA21.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA21_PUWA18	(PPU0.unPUWA21.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA21_PUWA19	(PPU0.unPUWA21.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA21_PUWA20	(PPU0.unPUWA21.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA21_PUWA21	(PPU0.unPUWA21.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA21_PUWA22	(PPU0.unPUWA21.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA21_PUWA23	(PPU0.unPUWA21.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA21_PUWA24	(PPU0.unPUWA21.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA21_PUWA25	(PPU0.unPUWA21.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA21_PUWA26	(PPU0.unPUWA21.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA21_PUWA27	(PPU0.unPUWA21.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA21_PUWA28	(PPU0.unPUWA21.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA21_PUWA29	(PPU0.unPUWA21.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA21_PUWA30	(PPU0.unPUWA21.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA21_PUWA31	(PPU0.unPUWA21.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA22	(PPU0.unPUWA22.u32Register)  /*@rg@*/
#define PPU0_PUWA22_PUWA0	(PPU0.unPUWA22.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA22_PUWA1	(PPU0.unPUWA22.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA22_PUWA2	(PPU0.unPUWA22.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA22_PUWA3	(PPU0.unPUWA22.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA22_PUWA4	(PPU0.unPUWA22.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA22_PUWA5	(PPU0.unPUWA22.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA22_PUWA6	(PPU0.unPUWA22.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA22_PUWA7	(PPU0.unPUWA22.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA22_PUWA8	(PPU0.unPUWA22.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA22_PUWA9	(PPU0.unPUWA22.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA22_PUWA10	(PPU0.unPUWA22.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA22_PUWA11	(PPU0.unPUWA22.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA22_PUWA12	(PPU0.unPUWA22.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA22_PUWA13	(PPU0.unPUWA22.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA22_PUWA14	(PPU0.unPUWA22.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA22_PUWA15	(PPU0.unPUWA22.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA22_PUWA16	(PPU0.unPUWA22.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA22_PUWA17	(PPU0.unPUWA22.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA22_PUWA18	(PPU0.unPUWA22.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA22_PUWA19	(PPU0.unPUWA22.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA22_PUWA20	(PPU0.unPUWA22.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA22_PUWA21	(PPU0.unPUWA22.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA22_PUWA22	(PPU0.unPUWA22.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA22_PUWA23	(PPU0.unPUWA22.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA22_PUWA24	(PPU0.unPUWA22.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA22_PUWA25	(PPU0.unPUWA22.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA22_PUWA26	(PPU0.unPUWA22.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA22_PUWA27	(PPU0.unPUWA22.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA22_PUWA28	(PPU0.unPUWA22.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA22_PUWA29	(PPU0.unPUWA22.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA22_PUWA30	(PPU0.unPUWA22.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA22_PUWA31	(PPU0.unPUWA22.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA23	(PPU0.unPUWA23.u32Register)  /*@rg@*/
#define PPU0_PUWA23_PUWA0	(PPU0.unPUWA23.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA23_PUWA1	(PPU0.unPUWA23.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA23_PUWA2	(PPU0.unPUWA23.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA23_PUWA3	(PPU0.unPUWA23.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA23_PUWA4	(PPU0.unPUWA23.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA23_PUWA5	(PPU0.unPUWA23.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA23_PUWA6	(PPU0.unPUWA23.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA23_PUWA7	(PPU0.unPUWA23.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA23_PUWA8	(PPU0.unPUWA23.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA23_PUWA9	(PPU0.unPUWA23.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA23_PUWA10	(PPU0.unPUWA23.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA23_PUWA11	(PPU0.unPUWA23.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA23_PUWA12	(PPU0.unPUWA23.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA23_PUWA13	(PPU0.unPUWA23.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA23_PUWA14	(PPU0.unPUWA23.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA23_PUWA15	(PPU0.unPUWA23.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA23_PUWA16	(PPU0.unPUWA23.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA23_PUWA17	(PPU0.unPUWA23.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA23_PUWA18	(PPU0.unPUWA23.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA23_PUWA19	(PPU0.unPUWA23.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA23_PUWA20	(PPU0.unPUWA23.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA23_PUWA21	(PPU0.unPUWA23.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA23_PUWA22	(PPU0.unPUWA23.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA23_PUWA23	(PPU0.unPUWA23.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA23_PUWA24	(PPU0.unPUWA23.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA23_PUWA25	(PPU0.unPUWA23.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA23_PUWA26	(PPU0.unPUWA23.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA23_PUWA27	(PPU0.unPUWA23.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA23_PUWA28	(PPU0.unPUWA23.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA23_PUWA29	(PPU0.unPUWA23.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA23_PUWA30	(PPU0.unPUWA23.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA23_PUWA31	(PPU0.unPUWA23.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA24	(PPU0.unPUWA24.u32Register)  /*@rg@*/
#define PPU0_PUWA24_PUWA0	(PPU0.unPUWA24.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA24_PUWA1	(PPU0.unPUWA24.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA24_PUWA2	(PPU0.unPUWA24.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA24_PUWA3	(PPU0.unPUWA24.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA24_PUWA4	(PPU0.unPUWA24.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA24_PUWA5	(PPU0.unPUWA24.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA24_PUWA6	(PPU0.unPUWA24.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA24_PUWA7	(PPU0.unPUWA24.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA24_PUWA8	(PPU0.unPUWA24.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA24_PUWA9	(PPU0.unPUWA24.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA24_PUWA10	(PPU0.unPUWA24.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA24_PUWA11	(PPU0.unPUWA24.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA24_PUWA12	(PPU0.unPUWA24.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA24_PUWA13	(PPU0.unPUWA24.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA24_PUWA14	(PPU0.unPUWA24.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA24_PUWA15	(PPU0.unPUWA24.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA24_PUWA16	(PPU0.unPUWA24.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA24_PUWA17	(PPU0.unPUWA24.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA24_PUWA18	(PPU0.unPUWA24.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA24_PUWA19	(PPU0.unPUWA24.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA24_PUWA20	(PPU0.unPUWA24.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA24_PUWA21	(PPU0.unPUWA24.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA24_PUWA22	(PPU0.unPUWA24.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA24_PUWA23	(PPU0.unPUWA24.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA24_PUWA24	(PPU0.unPUWA24.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA24_PUWA25	(PPU0.unPUWA24.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA24_PUWA26	(PPU0.unPUWA24.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA24_PUWA27	(PPU0.unPUWA24.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA24_PUWA28	(PPU0.unPUWA24.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA24_PUWA29	(PPU0.unPUWA24.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA24_PUWA30	(PPU0.unPUWA24.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA24_PUWA31	(PPU0.unPUWA24.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA25	(PPU0.unPUWA25.u32Register)  /*@rg@*/
#define PPU0_PUWA25_PUWA0	(PPU0.unPUWA25.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA25_PUWA1	(PPU0.unPUWA25.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA25_PUWA2	(PPU0.unPUWA25.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA25_PUWA3	(PPU0.unPUWA25.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA25_PUWA4	(PPU0.unPUWA25.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA25_PUWA5	(PPU0.unPUWA25.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA25_PUWA6	(PPU0.unPUWA25.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA25_PUWA7	(PPU0.unPUWA25.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA25_PUWA8	(PPU0.unPUWA25.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA25_PUWA9	(PPU0.unPUWA25.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA25_PUWA10	(PPU0.unPUWA25.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA25_PUWA11	(PPU0.unPUWA25.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA25_PUWA12	(PPU0.unPUWA25.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA25_PUWA13	(PPU0.unPUWA25.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA25_PUWA14	(PPU0.unPUWA25.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA25_PUWA15	(PPU0.unPUWA25.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA25_PUWA16	(PPU0.unPUWA25.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA25_PUWA17	(PPU0.unPUWA25.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA25_PUWA18	(PPU0.unPUWA25.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA25_PUWA19	(PPU0.unPUWA25.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA25_PUWA20	(PPU0.unPUWA25.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA25_PUWA21	(PPU0.unPUWA25.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA25_PUWA22	(PPU0.unPUWA25.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA25_PUWA23	(PPU0.unPUWA25.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA25_PUWA24	(PPU0.unPUWA25.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA25_PUWA25	(PPU0.unPUWA25.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA25_PUWA26	(PPU0.unPUWA25.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA25_PUWA27	(PPU0.unPUWA25.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA25_PUWA28	(PPU0.unPUWA25.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA25_PUWA29	(PPU0.unPUWA25.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA25_PUWA30	(PPU0.unPUWA25.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA25_PUWA31	(PPU0.unPUWA25.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA26	(PPU0.unPUWA26.u32Register)  /*@rg@*/
#define PPU0_PUWA26_PUWA0	(PPU0.unPUWA26.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA26_PUWA1	(PPU0.unPUWA26.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA26_PUWA2	(PPU0.unPUWA26.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA26_PUWA3	(PPU0.unPUWA26.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA26_PUWA4	(PPU0.unPUWA26.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA26_PUWA5	(PPU0.unPUWA26.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA26_PUWA6	(PPU0.unPUWA26.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA26_PUWA7	(PPU0.unPUWA26.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA26_PUWA8	(PPU0.unPUWA26.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA26_PUWA9	(PPU0.unPUWA26.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA26_PUWA10	(PPU0.unPUWA26.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA26_PUWA11	(PPU0.unPUWA26.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA26_PUWA12	(PPU0.unPUWA26.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA26_PUWA13	(PPU0.unPUWA26.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA26_PUWA14	(PPU0.unPUWA26.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA26_PUWA15	(PPU0.unPUWA26.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA26_PUWA16	(PPU0.unPUWA26.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA26_PUWA17	(PPU0.unPUWA26.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA26_PUWA18	(PPU0.unPUWA26.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA26_PUWA19	(PPU0.unPUWA26.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA26_PUWA20	(PPU0.unPUWA26.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA26_PUWA21	(PPU0.unPUWA26.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA26_PUWA22	(PPU0.unPUWA26.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA26_PUWA23	(PPU0.unPUWA26.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA26_PUWA24	(PPU0.unPUWA26.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA26_PUWA25	(PPU0.unPUWA26.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA26_PUWA26	(PPU0.unPUWA26.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA26_PUWA27	(PPU0.unPUWA26.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA26_PUWA28	(PPU0.unPUWA26.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA26_PUWA29	(PPU0.unPUWA26.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA26_PUWA30	(PPU0.unPUWA26.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA26_PUWA31	(PPU0.unPUWA26.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA27	(PPU0.unPUWA27.u32Register)  /*@rg@*/
#define PPU0_PUWA27_PUWA0	(PPU0.unPUWA27.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA27_PUWA1	(PPU0.unPUWA27.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA27_PUWA2	(PPU0.unPUWA27.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA27_PUWA3	(PPU0.unPUWA27.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA27_PUWA4	(PPU0.unPUWA27.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA27_PUWA5	(PPU0.unPUWA27.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA27_PUWA6	(PPU0.unPUWA27.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA27_PUWA7	(PPU0.unPUWA27.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA27_PUWA8	(PPU0.unPUWA27.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA27_PUWA9	(PPU0.unPUWA27.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA27_PUWA10	(PPU0.unPUWA27.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA27_PUWA11	(PPU0.unPUWA27.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA27_PUWA12	(PPU0.unPUWA27.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA27_PUWA13	(PPU0.unPUWA27.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA27_PUWA14	(PPU0.unPUWA27.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA27_PUWA15	(PPU0.unPUWA27.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA27_PUWA16	(PPU0.unPUWA27.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA27_PUWA17	(PPU0.unPUWA27.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA27_PUWA18	(PPU0.unPUWA27.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA27_PUWA19	(PPU0.unPUWA27.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA27_PUWA20	(PPU0.unPUWA27.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA27_PUWA21	(PPU0.unPUWA27.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA27_PUWA22	(PPU0.unPUWA27.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA27_PUWA23	(PPU0.unPUWA27.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA27_PUWA24	(PPU0.unPUWA27.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA27_PUWA25	(PPU0.unPUWA27.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA27_PUWA26	(PPU0.unPUWA27.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA27_PUWA27	(PPU0.unPUWA27.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA27_PUWA28	(PPU0.unPUWA27.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA27_PUWA29	(PPU0.unPUWA27.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA27_PUWA30	(PPU0.unPUWA27.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA27_PUWA31	(PPU0.unPUWA27.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA28	(PPU0.unPUWA28.u32Register)  /*@rg@*/
#define PPU0_PUWA28_PUWA0	(PPU0.unPUWA28.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA28_PUWA1	(PPU0.unPUWA28.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA28_PUWA2	(PPU0.unPUWA28.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA28_PUWA3	(PPU0.unPUWA28.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA28_PUWA4	(PPU0.unPUWA28.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA28_PUWA5	(PPU0.unPUWA28.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA28_PUWA6	(PPU0.unPUWA28.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA28_PUWA7	(PPU0.unPUWA28.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA28_PUWA8	(PPU0.unPUWA28.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA28_PUWA9	(PPU0.unPUWA28.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA28_PUWA10	(PPU0.unPUWA28.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA28_PUWA11	(PPU0.unPUWA28.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA28_PUWA12	(PPU0.unPUWA28.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA28_PUWA13	(PPU0.unPUWA28.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA28_PUWA14	(PPU0.unPUWA28.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA28_PUWA15	(PPU0.unPUWA28.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA28_PUWA16	(PPU0.unPUWA28.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA28_PUWA17	(PPU0.unPUWA28.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA28_PUWA18	(PPU0.unPUWA28.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA28_PUWA19	(PPU0.unPUWA28.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA28_PUWA20	(PPU0.unPUWA28.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA28_PUWA21	(PPU0.unPUWA28.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA28_PUWA22	(PPU0.unPUWA28.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA28_PUWA23	(PPU0.unPUWA28.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA28_PUWA24	(PPU0.unPUWA28.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA28_PUWA25	(PPU0.unPUWA28.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA28_PUWA26	(PPU0.unPUWA28.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA28_PUWA27	(PPU0.unPUWA28.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA28_PUWA28	(PPU0.unPUWA28.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA28_PUWA29	(PPU0.unPUWA28.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA28_PUWA30	(PPU0.unPUWA28.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA28_PUWA31	(PPU0.unPUWA28.stcField.u1PUWA31)  /*@bf@*/

#define PPU0_PUWA29	(PPU0.unPUWA29.u32Register)  /*@rg@*/
#define PPU0_PUWA29_PUWA0	(PPU0.unPUWA29.stcField.u1PUWA0)  /*@bf@*/
#define PPU0_PUWA29_PUWA1	(PPU0.unPUWA29.stcField.u1PUWA1)  /*@bf@*/
#define PPU0_PUWA29_PUWA2	(PPU0.unPUWA29.stcField.u1PUWA2)  /*@bf@*/
#define PPU0_PUWA29_PUWA3	(PPU0.unPUWA29.stcField.u1PUWA3)  /*@bf@*/
#define PPU0_PUWA29_PUWA4	(PPU0.unPUWA29.stcField.u1PUWA4)  /*@bf@*/
#define PPU0_PUWA29_PUWA5	(PPU0.unPUWA29.stcField.u1PUWA5)  /*@bf@*/
#define PPU0_PUWA29_PUWA6	(PPU0.unPUWA29.stcField.u1PUWA6)  /*@bf@*/
#define PPU0_PUWA29_PUWA7	(PPU0.unPUWA29.stcField.u1PUWA7)  /*@bf@*/
#define PPU0_PUWA29_PUWA8	(PPU0.unPUWA29.stcField.u1PUWA8)  /*@bf@*/
#define PPU0_PUWA29_PUWA9	(PPU0.unPUWA29.stcField.u1PUWA9)  /*@bf@*/
#define PPU0_PUWA29_PUWA10	(PPU0.unPUWA29.stcField.u1PUWA10)  /*@bf@*/
#define PPU0_PUWA29_PUWA11	(PPU0.unPUWA29.stcField.u1PUWA11)  /*@bf@*/
#define PPU0_PUWA29_PUWA12	(PPU0.unPUWA29.stcField.u1PUWA12)  /*@bf@*/
#define PPU0_PUWA29_PUWA13	(PPU0.unPUWA29.stcField.u1PUWA13)  /*@bf@*/
#define PPU0_PUWA29_PUWA14	(PPU0.unPUWA29.stcField.u1PUWA14)  /*@bf@*/
#define PPU0_PUWA29_PUWA15	(PPU0.unPUWA29.stcField.u1PUWA15)  /*@bf@*/
#define PPU0_PUWA29_PUWA16	(PPU0.unPUWA29.stcField.u1PUWA16)  /*@bf@*/
#define PPU0_PUWA29_PUWA17	(PPU0.unPUWA29.stcField.u1PUWA17)  /*@bf@*/
#define PPU0_PUWA29_PUWA18	(PPU0.unPUWA29.stcField.u1PUWA18)  /*@bf@*/
#define PPU0_PUWA29_PUWA19	(PPU0.unPUWA29.stcField.u1PUWA19)  /*@bf@*/
#define PPU0_PUWA29_PUWA20	(PPU0.unPUWA29.stcField.u1PUWA20)  /*@bf@*/
#define PPU0_PUWA29_PUWA21	(PPU0.unPUWA29.stcField.u1PUWA21)  /*@bf@*/
#define PPU0_PUWA29_PUWA22	(PPU0.unPUWA29.stcField.u1PUWA22)  /*@bf@*/
#define PPU0_PUWA29_PUWA23	(PPU0.unPUWA29.stcField.u1PUWA23)  /*@bf@*/
#define PPU0_PUWA29_PUWA24	(PPU0.unPUWA29.stcField.u1PUWA24)  /*@bf@*/
#define PPU0_PUWA29_PUWA25	(PPU0.unPUWA29.stcField.u1PUWA25)  /*@bf@*/
#define PPU0_PUWA29_PUWA26	(PPU0.unPUWA29.stcField.u1PUWA26)  /*@bf@*/
#define PPU0_PUWA29_PUWA27	(PPU0.unPUWA29.stcField.u1PUWA27)  /*@bf@*/
#define PPU0_PUWA29_PUWA28	(PPU0.unPUWA29.stcField.u1PUWA28)  /*@bf@*/
#define PPU0_PUWA29_PUWA29	(PPU0.unPUWA29.stcField.u1PUWA29)  /*@bf@*/
#define PPU0_PUWA29_PUWA30	(PPU0.unPUWA29.stcField.u1PUWA30)  /*@bf@*/
#define PPU0_PUWA29_PUWA31	(PPU0.unPUWA29.stcField.u1PUWA31)  /*@bf@*/

typedef struct stc_ppu0_puwan_field{
    uint_io32_t		u1PUWA0:1;
    uint_io32_t		u1PUWA1:1;
    uint_io32_t		u1PUWA2:1;
    uint_io32_t		u1PUWA3:1;
    uint_io32_t		u1PUWA4:1;
    uint_io32_t		u1PUWA5:1;
    uint_io32_t		u1PUWA6:1;
    uint_io32_t		u1PUWA7:1;
    uint_io32_t		u1PUWA8:1;
    uint_io32_t		u1PUWA9:1;
    uint_io32_t		u1PUWA10:1;
    uint_io32_t		u1PUWA11:1;
    uint_io32_t		u1PUWA12:1;
    uint_io32_t		u1PUWA13:1;
    uint_io32_t		u1PUWA14:1;
    uint_io32_t		u1PUWA15:1;
    uint_io32_t		u1PUWA16:1;
    uint_io32_t		u1PUWA17:1;
    uint_io32_t		u1PUWA18:1;
    uint_io32_t		u1PUWA19:1;
    uint_io32_t		u1PUWA20:1;
    uint_io32_t		u1PUWA21:1;
    uint_io32_t		u1PUWA22:1;
    uint_io32_t		u1PUWA23:1;
    uint_io32_t		u1PUWA24:1;
    uint_io32_t		u1PUWA25:1;
    uint_io32_t		u1PUWA26:1;
    uint_io32_t		u1PUWA27:1;
    uint_io32_t		u1PUWA28:1;
    uint_io32_t		u1PUWA29:1;
    uint_io32_t		u1PUWA30:1;
    uint_io32_t		u1PUWA31:1;
}stc_ppu0_puwan_field_t;

typedef union un_ppu0_puwan{
    uint_io32_t		u32Register;
    stc_ppu0_puwan_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_puwan_t;

/* LOCK3 */
#define PPU0_LOCK3	(PPU0.unLOCK3.u32Register)  /*@rg@*/
#define PPU0_LOCK3_L	PPU0_LOCK3  /*@bfrg@*/

typedef union un_ppu0_lock3{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_lock3_t;

/* PFEN[0-29] */
#define PPU0_PFEN0	(PPU0.unPFEN0.u32Register)  /*@rg@*/
#define PPU0_PFEN0_PFEN0	(PPU0.unPFEN0.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN0_PFEN1	(PPU0.unPFEN0.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN0_PFEN2	(PPU0.unPFEN0.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN0_PFEN3	(PPU0.unPFEN0.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN0_PFEN4	(PPU0.unPFEN0.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN0_PFEN5	(PPU0.unPFEN0.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN0_PFEN6	(PPU0.unPFEN0.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN0_PFEN7	(PPU0.unPFEN0.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN0_PFEN8	(PPU0.unPFEN0.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN0_PFEN9	(PPU0.unPFEN0.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN0_PFEN10	(PPU0.unPFEN0.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN0_PFEN11	(PPU0.unPFEN0.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN0_PFEN12	(PPU0.unPFEN0.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN0_PFEN13	(PPU0.unPFEN0.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN0_PFEN14	(PPU0.unPFEN0.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN0_PFEN15	(PPU0.unPFEN0.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN0_PFEN16	(PPU0.unPFEN0.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN0_PFEN17	(PPU0.unPFEN0.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN0_PFEN18	(PPU0.unPFEN0.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN0_PFEN19	(PPU0.unPFEN0.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN0_PFEN20	(PPU0.unPFEN0.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN0_PFEN21	(PPU0.unPFEN0.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN0_PFEN22	(PPU0.unPFEN0.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN0_PFEN23	(PPU0.unPFEN0.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN0_PFEN24	(PPU0.unPFEN0.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN0_PFEN25	(PPU0.unPFEN0.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN0_PFEN26	(PPU0.unPFEN0.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN0_PFEN27	(PPU0.unPFEN0.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN0_PFEN28	(PPU0.unPFEN0.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN0_PFEN29	(PPU0.unPFEN0.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN0_PFEN30	(PPU0.unPFEN0.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN0_PFEN31	(PPU0.unPFEN0.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN1	(PPU0.unPFEN1.u32Register)  /*@rg@*/
#define PPU0_PFEN1_PFEN0	(PPU0.unPFEN1.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN1_PFEN1	(PPU0.unPFEN1.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN1_PFEN2	(PPU0.unPFEN1.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN1_PFEN3	(PPU0.unPFEN1.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN1_PFEN4	(PPU0.unPFEN1.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN1_PFEN5	(PPU0.unPFEN1.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN1_PFEN6	(PPU0.unPFEN1.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN1_PFEN7	(PPU0.unPFEN1.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN1_PFEN8	(PPU0.unPFEN1.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN1_PFEN9	(PPU0.unPFEN1.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN1_PFEN10	(PPU0.unPFEN1.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN1_PFEN11	(PPU0.unPFEN1.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN1_PFEN12	(PPU0.unPFEN1.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN1_PFEN13	(PPU0.unPFEN1.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN1_PFEN14	(PPU0.unPFEN1.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN1_PFEN15	(PPU0.unPFEN1.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN1_PFEN16	(PPU0.unPFEN1.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN1_PFEN17	(PPU0.unPFEN1.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN1_PFEN18	(PPU0.unPFEN1.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN1_PFEN19	(PPU0.unPFEN1.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN1_PFEN20	(PPU0.unPFEN1.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN1_PFEN21	(PPU0.unPFEN1.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN1_PFEN22	(PPU0.unPFEN1.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN1_PFEN23	(PPU0.unPFEN1.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN1_PFEN24	(PPU0.unPFEN1.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN1_PFEN25	(PPU0.unPFEN1.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN1_PFEN26	(PPU0.unPFEN1.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN1_PFEN27	(PPU0.unPFEN1.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN1_PFEN28	(PPU0.unPFEN1.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN1_PFEN29	(PPU0.unPFEN1.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN1_PFEN30	(PPU0.unPFEN1.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN1_PFEN31	(PPU0.unPFEN1.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN2	(PPU0.unPFEN2.u32Register)  /*@rg@*/
#define PPU0_PFEN2_PFEN0	(PPU0.unPFEN2.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN2_PFEN1	(PPU0.unPFEN2.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN2_PFEN2	(PPU0.unPFEN2.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN2_PFEN3	(PPU0.unPFEN2.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN2_PFEN4	(PPU0.unPFEN2.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN2_PFEN5	(PPU0.unPFEN2.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN2_PFEN6	(PPU0.unPFEN2.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN2_PFEN7	(PPU0.unPFEN2.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN2_PFEN8	(PPU0.unPFEN2.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN2_PFEN9	(PPU0.unPFEN2.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN2_PFEN10	(PPU0.unPFEN2.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN2_PFEN11	(PPU0.unPFEN2.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN2_PFEN12	(PPU0.unPFEN2.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN2_PFEN13	(PPU0.unPFEN2.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN2_PFEN14	(PPU0.unPFEN2.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN2_PFEN15	(PPU0.unPFEN2.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN2_PFEN16	(PPU0.unPFEN2.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN2_PFEN17	(PPU0.unPFEN2.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN2_PFEN18	(PPU0.unPFEN2.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN2_PFEN19	(PPU0.unPFEN2.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN2_PFEN20	(PPU0.unPFEN2.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN2_PFEN21	(PPU0.unPFEN2.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN2_PFEN22	(PPU0.unPFEN2.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN2_PFEN23	(PPU0.unPFEN2.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN2_PFEN24	(PPU0.unPFEN2.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN2_PFEN25	(PPU0.unPFEN2.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN2_PFEN26	(PPU0.unPFEN2.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN2_PFEN27	(PPU0.unPFEN2.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN2_PFEN28	(PPU0.unPFEN2.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN2_PFEN29	(PPU0.unPFEN2.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN2_PFEN30	(PPU0.unPFEN2.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN2_PFEN31	(PPU0.unPFEN2.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN3	(PPU0.unPFEN3.u32Register)  /*@rg@*/
#define PPU0_PFEN3_PFEN0	(PPU0.unPFEN3.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN3_PFEN1	(PPU0.unPFEN3.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN3_PFEN2	(PPU0.unPFEN3.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN3_PFEN3	(PPU0.unPFEN3.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN3_PFEN4	(PPU0.unPFEN3.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN3_PFEN5	(PPU0.unPFEN3.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN3_PFEN6	(PPU0.unPFEN3.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN3_PFEN7	(PPU0.unPFEN3.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN3_PFEN8	(PPU0.unPFEN3.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN3_PFEN9	(PPU0.unPFEN3.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN3_PFEN10	(PPU0.unPFEN3.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN3_PFEN11	(PPU0.unPFEN3.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN3_PFEN12	(PPU0.unPFEN3.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN3_PFEN13	(PPU0.unPFEN3.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN3_PFEN14	(PPU0.unPFEN3.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN3_PFEN15	(PPU0.unPFEN3.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN3_PFEN16	(PPU0.unPFEN3.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN3_PFEN17	(PPU0.unPFEN3.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN3_PFEN18	(PPU0.unPFEN3.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN3_PFEN19	(PPU0.unPFEN3.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN3_PFEN20	(PPU0.unPFEN3.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN3_PFEN21	(PPU0.unPFEN3.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN3_PFEN22	(PPU0.unPFEN3.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN3_PFEN23	(PPU0.unPFEN3.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN3_PFEN24	(PPU0.unPFEN3.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN3_PFEN25	(PPU0.unPFEN3.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN3_PFEN26	(PPU0.unPFEN3.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN3_PFEN27	(PPU0.unPFEN3.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN3_PFEN28	(PPU0.unPFEN3.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN3_PFEN29	(PPU0.unPFEN3.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN3_PFEN30	(PPU0.unPFEN3.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN3_PFEN31	(PPU0.unPFEN3.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN4	(PPU0.unPFEN4.u32Register)  /*@rg@*/
#define PPU0_PFEN4_PFEN0	(PPU0.unPFEN4.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN4_PFEN1	(PPU0.unPFEN4.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN4_PFEN2	(PPU0.unPFEN4.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN4_PFEN3	(PPU0.unPFEN4.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN4_PFEN4	(PPU0.unPFEN4.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN4_PFEN5	(PPU0.unPFEN4.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN4_PFEN6	(PPU0.unPFEN4.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN4_PFEN7	(PPU0.unPFEN4.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN4_PFEN8	(PPU0.unPFEN4.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN4_PFEN9	(PPU0.unPFEN4.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN4_PFEN10	(PPU0.unPFEN4.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN4_PFEN11	(PPU0.unPFEN4.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN4_PFEN12	(PPU0.unPFEN4.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN4_PFEN13	(PPU0.unPFEN4.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN4_PFEN14	(PPU0.unPFEN4.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN4_PFEN15	(PPU0.unPFEN4.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN4_PFEN16	(PPU0.unPFEN4.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN4_PFEN17	(PPU0.unPFEN4.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN4_PFEN18	(PPU0.unPFEN4.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN4_PFEN19	(PPU0.unPFEN4.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN4_PFEN20	(PPU0.unPFEN4.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN4_PFEN21	(PPU0.unPFEN4.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN4_PFEN22	(PPU0.unPFEN4.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN4_PFEN23	(PPU0.unPFEN4.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN4_PFEN24	(PPU0.unPFEN4.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN4_PFEN25	(PPU0.unPFEN4.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN4_PFEN26	(PPU0.unPFEN4.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN4_PFEN27	(PPU0.unPFEN4.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN4_PFEN28	(PPU0.unPFEN4.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN4_PFEN29	(PPU0.unPFEN4.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN4_PFEN30	(PPU0.unPFEN4.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN4_PFEN31	(PPU0.unPFEN4.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN5	(PPU0.unPFEN5.u32Register)  /*@rg@*/
#define PPU0_PFEN5_PFEN0	(PPU0.unPFEN5.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN5_PFEN1	(PPU0.unPFEN5.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN5_PFEN2	(PPU0.unPFEN5.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN5_PFEN3	(PPU0.unPFEN5.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN5_PFEN4	(PPU0.unPFEN5.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN5_PFEN5	(PPU0.unPFEN5.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN5_PFEN6	(PPU0.unPFEN5.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN5_PFEN7	(PPU0.unPFEN5.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN5_PFEN8	(PPU0.unPFEN5.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN5_PFEN9	(PPU0.unPFEN5.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN5_PFEN10	(PPU0.unPFEN5.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN5_PFEN11	(PPU0.unPFEN5.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN5_PFEN12	(PPU0.unPFEN5.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN5_PFEN13	(PPU0.unPFEN5.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN5_PFEN14	(PPU0.unPFEN5.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN5_PFEN15	(PPU0.unPFEN5.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN5_PFEN16	(PPU0.unPFEN5.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN5_PFEN17	(PPU0.unPFEN5.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN5_PFEN18	(PPU0.unPFEN5.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN5_PFEN19	(PPU0.unPFEN5.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN5_PFEN20	(PPU0.unPFEN5.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN5_PFEN21	(PPU0.unPFEN5.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN5_PFEN22	(PPU0.unPFEN5.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN5_PFEN23	(PPU0.unPFEN5.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN5_PFEN24	(PPU0.unPFEN5.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN5_PFEN25	(PPU0.unPFEN5.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN5_PFEN26	(PPU0.unPFEN5.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN5_PFEN27	(PPU0.unPFEN5.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN5_PFEN28	(PPU0.unPFEN5.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN5_PFEN29	(PPU0.unPFEN5.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN5_PFEN30	(PPU0.unPFEN5.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN5_PFEN31	(PPU0.unPFEN5.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN6	(PPU0.unPFEN6.u32Register)  /*@rg@*/
#define PPU0_PFEN6_PFEN0	(PPU0.unPFEN6.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN6_PFEN1	(PPU0.unPFEN6.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN6_PFEN2	(PPU0.unPFEN6.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN6_PFEN3	(PPU0.unPFEN6.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN6_PFEN4	(PPU0.unPFEN6.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN6_PFEN5	(PPU0.unPFEN6.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN6_PFEN6	(PPU0.unPFEN6.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN6_PFEN7	(PPU0.unPFEN6.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN6_PFEN8	(PPU0.unPFEN6.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN6_PFEN9	(PPU0.unPFEN6.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN6_PFEN10	(PPU0.unPFEN6.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN6_PFEN11	(PPU0.unPFEN6.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN6_PFEN12	(PPU0.unPFEN6.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN6_PFEN13	(PPU0.unPFEN6.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN6_PFEN14	(PPU0.unPFEN6.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN6_PFEN15	(PPU0.unPFEN6.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN6_PFEN16	(PPU0.unPFEN6.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN6_PFEN17	(PPU0.unPFEN6.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN6_PFEN18	(PPU0.unPFEN6.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN6_PFEN19	(PPU0.unPFEN6.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN6_PFEN20	(PPU0.unPFEN6.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN6_PFEN21	(PPU0.unPFEN6.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN6_PFEN22	(PPU0.unPFEN6.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN6_PFEN23	(PPU0.unPFEN6.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN6_PFEN24	(PPU0.unPFEN6.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN6_PFEN25	(PPU0.unPFEN6.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN6_PFEN26	(PPU0.unPFEN6.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN6_PFEN27	(PPU0.unPFEN6.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN6_PFEN28	(PPU0.unPFEN6.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN6_PFEN29	(PPU0.unPFEN6.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN6_PFEN30	(PPU0.unPFEN6.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN6_PFEN31	(PPU0.unPFEN6.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN7	(PPU0.unPFEN7.u32Register)  /*@rg@*/
#define PPU0_PFEN7_PFEN0	(PPU0.unPFEN7.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN7_PFEN1	(PPU0.unPFEN7.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN7_PFEN2	(PPU0.unPFEN7.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN7_PFEN3	(PPU0.unPFEN7.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN7_PFEN4	(PPU0.unPFEN7.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN7_PFEN5	(PPU0.unPFEN7.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN7_PFEN6	(PPU0.unPFEN7.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN7_PFEN7	(PPU0.unPFEN7.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN7_PFEN8	(PPU0.unPFEN7.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN7_PFEN9	(PPU0.unPFEN7.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN7_PFEN10	(PPU0.unPFEN7.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN7_PFEN11	(PPU0.unPFEN7.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN7_PFEN12	(PPU0.unPFEN7.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN7_PFEN13	(PPU0.unPFEN7.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN7_PFEN14	(PPU0.unPFEN7.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN7_PFEN15	(PPU0.unPFEN7.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN7_PFEN16	(PPU0.unPFEN7.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN7_PFEN17	(PPU0.unPFEN7.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN7_PFEN18	(PPU0.unPFEN7.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN7_PFEN19	(PPU0.unPFEN7.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN7_PFEN20	(PPU0.unPFEN7.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN7_PFEN21	(PPU0.unPFEN7.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN7_PFEN22	(PPU0.unPFEN7.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN7_PFEN23	(PPU0.unPFEN7.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN7_PFEN24	(PPU0.unPFEN7.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN7_PFEN25	(PPU0.unPFEN7.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN7_PFEN26	(PPU0.unPFEN7.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN7_PFEN27	(PPU0.unPFEN7.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN7_PFEN28	(PPU0.unPFEN7.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN7_PFEN29	(PPU0.unPFEN7.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN7_PFEN30	(PPU0.unPFEN7.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN7_PFEN31	(PPU0.unPFEN7.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN8	(PPU0.unPFEN8.u32Register)  /*@rg@*/
#define PPU0_PFEN8_PFEN0	(PPU0.unPFEN8.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN8_PFEN1	(PPU0.unPFEN8.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN8_PFEN2	(PPU0.unPFEN8.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN8_PFEN3	(PPU0.unPFEN8.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN8_PFEN4	(PPU0.unPFEN8.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN8_PFEN5	(PPU0.unPFEN8.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN8_PFEN6	(PPU0.unPFEN8.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN8_PFEN7	(PPU0.unPFEN8.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN8_PFEN8	(PPU0.unPFEN8.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN8_PFEN9	(PPU0.unPFEN8.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN8_PFEN10	(PPU0.unPFEN8.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN8_PFEN11	(PPU0.unPFEN8.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN8_PFEN12	(PPU0.unPFEN8.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN8_PFEN13	(PPU0.unPFEN8.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN8_PFEN14	(PPU0.unPFEN8.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN8_PFEN15	(PPU0.unPFEN8.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN8_PFEN16	(PPU0.unPFEN8.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN8_PFEN17	(PPU0.unPFEN8.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN8_PFEN18	(PPU0.unPFEN8.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN8_PFEN19	(PPU0.unPFEN8.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN8_PFEN20	(PPU0.unPFEN8.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN8_PFEN21	(PPU0.unPFEN8.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN8_PFEN22	(PPU0.unPFEN8.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN8_PFEN23	(PPU0.unPFEN8.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN8_PFEN24	(PPU0.unPFEN8.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN8_PFEN25	(PPU0.unPFEN8.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN8_PFEN26	(PPU0.unPFEN8.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN8_PFEN27	(PPU0.unPFEN8.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN8_PFEN28	(PPU0.unPFEN8.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN8_PFEN29	(PPU0.unPFEN8.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN8_PFEN30	(PPU0.unPFEN8.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN8_PFEN31	(PPU0.unPFEN8.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN9	(PPU0.unPFEN9.u32Register)  /*@rg@*/
#define PPU0_PFEN9_PFEN0	(PPU0.unPFEN9.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN9_PFEN1	(PPU0.unPFEN9.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN9_PFEN2	(PPU0.unPFEN9.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN9_PFEN3	(PPU0.unPFEN9.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN9_PFEN4	(PPU0.unPFEN9.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN9_PFEN5	(PPU0.unPFEN9.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN9_PFEN6	(PPU0.unPFEN9.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN9_PFEN7	(PPU0.unPFEN9.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN9_PFEN8	(PPU0.unPFEN9.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN9_PFEN9	(PPU0.unPFEN9.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN9_PFEN10	(PPU0.unPFEN9.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN9_PFEN11	(PPU0.unPFEN9.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN9_PFEN12	(PPU0.unPFEN9.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN9_PFEN13	(PPU0.unPFEN9.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN9_PFEN14	(PPU0.unPFEN9.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN9_PFEN15	(PPU0.unPFEN9.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN9_PFEN16	(PPU0.unPFEN9.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN9_PFEN17	(PPU0.unPFEN9.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN9_PFEN18	(PPU0.unPFEN9.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN9_PFEN19	(PPU0.unPFEN9.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN9_PFEN20	(PPU0.unPFEN9.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN9_PFEN21	(PPU0.unPFEN9.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN9_PFEN22	(PPU0.unPFEN9.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN9_PFEN23	(PPU0.unPFEN9.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN9_PFEN24	(PPU0.unPFEN9.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN9_PFEN25	(PPU0.unPFEN9.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN9_PFEN26	(PPU0.unPFEN9.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN9_PFEN27	(PPU0.unPFEN9.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN9_PFEN28	(PPU0.unPFEN9.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN9_PFEN29	(PPU0.unPFEN9.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN9_PFEN30	(PPU0.unPFEN9.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN9_PFEN31	(PPU0.unPFEN9.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN10	(PPU0.unPFEN10.u32Register)  /*@rg@*/
#define PPU0_PFEN10_PFEN0	(PPU0.unPFEN10.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN10_PFEN1	(PPU0.unPFEN10.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN10_PFEN2	(PPU0.unPFEN10.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN10_PFEN3	(PPU0.unPFEN10.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN10_PFEN4	(PPU0.unPFEN10.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN10_PFEN5	(PPU0.unPFEN10.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN10_PFEN6	(PPU0.unPFEN10.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN10_PFEN7	(PPU0.unPFEN10.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN10_PFEN8	(PPU0.unPFEN10.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN10_PFEN9	(PPU0.unPFEN10.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN10_PFEN10	(PPU0.unPFEN10.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN10_PFEN11	(PPU0.unPFEN10.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN10_PFEN12	(PPU0.unPFEN10.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN10_PFEN13	(PPU0.unPFEN10.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN10_PFEN14	(PPU0.unPFEN10.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN10_PFEN15	(PPU0.unPFEN10.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN10_PFEN16	(PPU0.unPFEN10.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN10_PFEN17	(PPU0.unPFEN10.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN10_PFEN18	(PPU0.unPFEN10.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN10_PFEN19	(PPU0.unPFEN10.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN10_PFEN20	(PPU0.unPFEN10.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN10_PFEN21	(PPU0.unPFEN10.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN10_PFEN22	(PPU0.unPFEN10.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN10_PFEN23	(PPU0.unPFEN10.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN10_PFEN24	(PPU0.unPFEN10.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN10_PFEN25	(PPU0.unPFEN10.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN10_PFEN26	(PPU0.unPFEN10.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN10_PFEN27	(PPU0.unPFEN10.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN10_PFEN28	(PPU0.unPFEN10.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN10_PFEN29	(PPU0.unPFEN10.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN10_PFEN30	(PPU0.unPFEN10.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN10_PFEN31	(PPU0.unPFEN10.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN11	(PPU0.unPFEN11.u32Register)  /*@rg@*/
#define PPU0_PFEN11_PFEN0	(PPU0.unPFEN11.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN11_PFEN1	(PPU0.unPFEN11.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN11_PFEN2	(PPU0.unPFEN11.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN11_PFEN3	(PPU0.unPFEN11.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN11_PFEN4	(PPU0.unPFEN11.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN11_PFEN5	(PPU0.unPFEN11.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN11_PFEN6	(PPU0.unPFEN11.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN11_PFEN7	(PPU0.unPFEN11.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN11_PFEN8	(PPU0.unPFEN11.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN11_PFEN9	(PPU0.unPFEN11.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN11_PFEN10	(PPU0.unPFEN11.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN11_PFEN11	(PPU0.unPFEN11.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN11_PFEN12	(PPU0.unPFEN11.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN11_PFEN13	(PPU0.unPFEN11.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN11_PFEN14	(PPU0.unPFEN11.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN11_PFEN15	(PPU0.unPFEN11.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN11_PFEN16	(PPU0.unPFEN11.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN11_PFEN17	(PPU0.unPFEN11.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN11_PFEN18	(PPU0.unPFEN11.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN11_PFEN19	(PPU0.unPFEN11.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN11_PFEN20	(PPU0.unPFEN11.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN11_PFEN21	(PPU0.unPFEN11.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN11_PFEN22	(PPU0.unPFEN11.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN11_PFEN23	(PPU0.unPFEN11.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN11_PFEN24	(PPU0.unPFEN11.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN11_PFEN25	(PPU0.unPFEN11.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN11_PFEN26	(PPU0.unPFEN11.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN11_PFEN27	(PPU0.unPFEN11.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN11_PFEN28	(PPU0.unPFEN11.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN11_PFEN29	(PPU0.unPFEN11.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN11_PFEN30	(PPU0.unPFEN11.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN11_PFEN31	(PPU0.unPFEN11.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN12	(PPU0.unPFEN12.u32Register)  /*@rg@*/
#define PPU0_PFEN12_PFEN0	(PPU0.unPFEN12.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN12_PFEN1	(PPU0.unPFEN12.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN12_PFEN2	(PPU0.unPFEN12.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN12_PFEN3	(PPU0.unPFEN12.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN12_PFEN4	(PPU0.unPFEN12.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN12_PFEN5	(PPU0.unPFEN12.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN12_PFEN6	(PPU0.unPFEN12.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN12_PFEN7	(PPU0.unPFEN12.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN12_PFEN8	(PPU0.unPFEN12.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN12_PFEN9	(PPU0.unPFEN12.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN12_PFEN10	(PPU0.unPFEN12.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN12_PFEN11	(PPU0.unPFEN12.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN12_PFEN12	(PPU0.unPFEN12.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN12_PFEN13	(PPU0.unPFEN12.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN12_PFEN14	(PPU0.unPFEN12.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN12_PFEN15	(PPU0.unPFEN12.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN12_PFEN16	(PPU0.unPFEN12.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN12_PFEN17	(PPU0.unPFEN12.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN12_PFEN18	(PPU0.unPFEN12.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN12_PFEN19	(PPU0.unPFEN12.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN12_PFEN20	(PPU0.unPFEN12.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN12_PFEN21	(PPU0.unPFEN12.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN12_PFEN22	(PPU0.unPFEN12.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN12_PFEN23	(PPU0.unPFEN12.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN12_PFEN24	(PPU0.unPFEN12.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN12_PFEN25	(PPU0.unPFEN12.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN12_PFEN26	(PPU0.unPFEN12.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN12_PFEN27	(PPU0.unPFEN12.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN12_PFEN28	(PPU0.unPFEN12.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN12_PFEN29	(PPU0.unPFEN12.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN12_PFEN30	(PPU0.unPFEN12.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN12_PFEN31	(PPU0.unPFEN12.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN13	(PPU0.unPFEN13.u32Register)  /*@rg@*/
#define PPU0_PFEN13_PFEN0	(PPU0.unPFEN13.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN13_PFEN1	(PPU0.unPFEN13.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN13_PFEN2	(PPU0.unPFEN13.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN13_PFEN3	(PPU0.unPFEN13.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN13_PFEN4	(PPU0.unPFEN13.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN13_PFEN5	(PPU0.unPFEN13.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN13_PFEN6	(PPU0.unPFEN13.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN13_PFEN7	(PPU0.unPFEN13.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN13_PFEN8	(PPU0.unPFEN13.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN13_PFEN9	(PPU0.unPFEN13.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN13_PFEN10	(PPU0.unPFEN13.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN13_PFEN11	(PPU0.unPFEN13.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN13_PFEN12	(PPU0.unPFEN13.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN13_PFEN13	(PPU0.unPFEN13.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN13_PFEN14	(PPU0.unPFEN13.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN13_PFEN15	(PPU0.unPFEN13.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN13_PFEN16	(PPU0.unPFEN13.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN13_PFEN17	(PPU0.unPFEN13.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN13_PFEN18	(PPU0.unPFEN13.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN13_PFEN19	(PPU0.unPFEN13.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN13_PFEN20	(PPU0.unPFEN13.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN13_PFEN21	(PPU0.unPFEN13.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN13_PFEN22	(PPU0.unPFEN13.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN13_PFEN23	(PPU0.unPFEN13.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN13_PFEN24	(PPU0.unPFEN13.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN13_PFEN25	(PPU0.unPFEN13.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN13_PFEN26	(PPU0.unPFEN13.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN13_PFEN27	(PPU0.unPFEN13.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN13_PFEN28	(PPU0.unPFEN13.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN13_PFEN29	(PPU0.unPFEN13.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN13_PFEN30	(PPU0.unPFEN13.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN13_PFEN31	(PPU0.unPFEN13.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN14	(PPU0.unPFEN14.u32Register)  /*@rg@*/
#define PPU0_PFEN14_PFEN0	(PPU0.unPFEN14.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN14_PFEN1	(PPU0.unPFEN14.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN14_PFEN2	(PPU0.unPFEN14.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN14_PFEN3	(PPU0.unPFEN14.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN14_PFEN4	(PPU0.unPFEN14.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN14_PFEN5	(PPU0.unPFEN14.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN14_PFEN6	(PPU0.unPFEN14.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN14_PFEN7	(PPU0.unPFEN14.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN14_PFEN8	(PPU0.unPFEN14.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN14_PFEN9	(PPU0.unPFEN14.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN14_PFEN10	(PPU0.unPFEN14.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN14_PFEN11	(PPU0.unPFEN14.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN14_PFEN12	(PPU0.unPFEN14.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN14_PFEN13	(PPU0.unPFEN14.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN14_PFEN14	(PPU0.unPFEN14.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN14_PFEN15	(PPU0.unPFEN14.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN14_PFEN16	(PPU0.unPFEN14.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN14_PFEN17	(PPU0.unPFEN14.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN14_PFEN18	(PPU0.unPFEN14.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN14_PFEN19	(PPU0.unPFEN14.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN14_PFEN20	(PPU0.unPFEN14.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN14_PFEN21	(PPU0.unPFEN14.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN14_PFEN22	(PPU0.unPFEN14.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN14_PFEN23	(PPU0.unPFEN14.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN14_PFEN24	(PPU0.unPFEN14.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN14_PFEN25	(PPU0.unPFEN14.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN14_PFEN26	(PPU0.unPFEN14.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN14_PFEN27	(PPU0.unPFEN14.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN14_PFEN28	(PPU0.unPFEN14.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN14_PFEN29	(PPU0.unPFEN14.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN14_PFEN30	(PPU0.unPFEN14.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN14_PFEN31	(PPU0.unPFEN14.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN15	(PPU0.unPFEN15.u32Register)  /*@rg@*/
#define PPU0_PFEN15_PFEN0	(PPU0.unPFEN15.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN15_PFEN1	(PPU0.unPFEN15.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN15_PFEN2	(PPU0.unPFEN15.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN15_PFEN3	(PPU0.unPFEN15.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN15_PFEN4	(PPU0.unPFEN15.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN15_PFEN5	(PPU0.unPFEN15.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN15_PFEN6	(PPU0.unPFEN15.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN15_PFEN7	(PPU0.unPFEN15.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN15_PFEN8	(PPU0.unPFEN15.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN15_PFEN9	(PPU0.unPFEN15.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN15_PFEN10	(PPU0.unPFEN15.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN15_PFEN11	(PPU0.unPFEN15.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN15_PFEN12	(PPU0.unPFEN15.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN15_PFEN13	(PPU0.unPFEN15.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN15_PFEN14	(PPU0.unPFEN15.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN15_PFEN15	(PPU0.unPFEN15.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN15_PFEN16	(PPU0.unPFEN15.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN15_PFEN17	(PPU0.unPFEN15.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN15_PFEN18	(PPU0.unPFEN15.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN15_PFEN19	(PPU0.unPFEN15.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN15_PFEN20	(PPU0.unPFEN15.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN15_PFEN21	(PPU0.unPFEN15.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN15_PFEN22	(PPU0.unPFEN15.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN15_PFEN23	(PPU0.unPFEN15.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN15_PFEN24	(PPU0.unPFEN15.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN15_PFEN25	(PPU0.unPFEN15.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN15_PFEN26	(PPU0.unPFEN15.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN15_PFEN27	(PPU0.unPFEN15.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN15_PFEN28	(PPU0.unPFEN15.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN15_PFEN29	(PPU0.unPFEN15.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN15_PFEN30	(PPU0.unPFEN15.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN15_PFEN31	(PPU0.unPFEN15.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN16	(PPU0.unPFEN16.u32Register)  /*@rg@*/
#define PPU0_PFEN16_PFEN0	(PPU0.unPFEN16.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN16_PFEN1	(PPU0.unPFEN16.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN16_PFEN2	(PPU0.unPFEN16.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN16_PFEN3	(PPU0.unPFEN16.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN16_PFEN4	(PPU0.unPFEN16.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN16_PFEN5	(PPU0.unPFEN16.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN16_PFEN6	(PPU0.unPFEN16.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN16_PFEN7	(PPU0.unPFEN16.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN16_PFEN8	(PPU0.unPFEN16.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN16_PFEN9	(PPU0.unPFEN16.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN16_PFEN10	(PPU0.unPFEN16.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN16_PFEN11	(PPU0.unPFEN16.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN16_PFEN12	(PPU0.unPFEN16.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN16_PFEN13	(PPU0.unPFEN16.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN16_PFEN14	(PPU0.unPFEN16.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN16_PFEN15	(PPU0.unPFEN16.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN16_PFEN16	(PPU0.unPFEN16.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN16_PFEN17	(PPU0.unPFEN16.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN16_PFEN18	(PPU0.unPFEN16.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN16_PFEN19	(PPU0.unPFEN16.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN16_PFEN20	(PPU0.unPFEN16.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN16_PFEN21	(PPU0.unPFEN16.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN16_PFEN22	(PPU0.unPFEN16.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN16_PFEN23	(PPU0.unPFEN16.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN16_PFEN24	(PPU0.unPFEN16.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN16_PFEN25	(PPU0.unPFEN16.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN16_PFEN26	(PPU0.unPFEN16.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN16_PFEN27	(PPU0.unPFEN16.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN16_PFEN28	(PPU0.unPFEN16.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN16_PFEN29	(PPU0.unPFEN16.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN16_PFEN30	(PPU0.unPFEN16.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN16_PFEN31	(PPU0.unPFEN16.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN17	(PPU0.unPFEN17.u32Register)  /*@rg@*/
#define PPU0_PFEN17_PFEN0	(PPU0.unPFEN17.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN17_PFEN1	(PPU0.unPFEN17.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN17_PFEN2	(PPU0.unPFEN17.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN17_PFEN3	(PPU0.unPFEN17.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN17_PFEN4	(PPU0.unPFEN17.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN17_PFEN5	(PPU0.unPFEN17.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN17_PFEN6	(PPU0.unPFEN17.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN17_PFEN7	(PPU0.unPFEN17.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN17_PFEN8	(PPU0.unPFEN17.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN17_PFEN9	(PPU0.unPFEN17.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN17_PFEN10	(PPU0.unPFEN17.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN17_PFEN11	(PPU0.unPFEN17.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN17_PFEN12	(PPU0.unPFEN17.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN17_PFEN13	(PPU0.unPFEN17.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN17_PFEN14	(PPU0.unPFEN17.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN17_PFEN15	(PPU0.unPFEN17.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN17_PFEN16	(PPU0.unPFEN17.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN17_PFEN17	(PPU0.unPFEN17.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN17_PFEN18	(PPU0.unPFEN17.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN17_PFEN19	(PPU0.unPFEN17.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN17_PFEN20	(PPU0.unPFEN17.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN17_PFEN21	(PPU0.unPFEN17.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN17_PFEN22	(PPU0.unPFEN17.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN17_PFEN23	(PPU0.unPFEN17.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN17_PFEN24	(PPU0.unPFEN17.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN17_PFEN25	(PPU0.unPFEN17.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN17_PFEN26	(PPU0.unPFEN17.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN17_PFEN27	(PPU0.unPFEN17.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN17_PFEN28	(PPU0.unPFEN17.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN17_PFEN29	(PPU0.unPFEN17.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN17_PFEN30	(PPU0.unPFEN17.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN17_PFEN31	(PPU0.unPFEN17.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN18	(PPU0.unPFEN18.u32Register)  /*@rg@*/
#define PPU0_PFEN18_PFEN0	(PPU0.unPFEN18.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN18_PFEN1	(PPU0.unPFEN18.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN18_PFEN2	(PPU0.unPFEN18.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN18_PFEN3	(PPU0.unPFEN18.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN18_PFEN4	(PPU0.unPFEN18.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN18_PFEN5	(PPU0.unPFEN18.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN18_PFEN6	(PPU0.unPFEN18.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN18_PFEN7	(PPU0.unPFEN18.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN18_PFEN8	(PPU0.unPFEN18.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN18_PFEN9	(PPU0.unPFEN18.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN18_PFEN10	(PPU0.unPFEN18.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN18_PFEN11	(PPU0.unPFEN18.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN18_PFEN12	(PPU0.unPFEN18.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN18_PFEN13	(PPU0.unPFEN18.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN18_PFEN14	(PPU0.unPFEN18.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN18_PFEN15	(PPU0.unPFEN18.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN18_PFEN16	(PPU0.unPFEN18.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN18_PFEN17	(PPU0.unPFEN18.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN18_PFEN18	(PPU0.unPFEN18.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN18_PFEN19	(PPU0.unPFEN18.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN18_PFEN20	(PPU0.unPFEN18.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN18_PFEN21	(PPU0.unPFEN18.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN18_PFEN22	(PPU0.unPFEN18.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN18_PFEN23	(PPU0.unPFEN18.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN18_PFEN24	(PPU0.unPFEN18.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN18_PFEN25	(PPU0.unPFEN18.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN18_PFEN26	(PPU0.unPFEN18.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN18_PFEN27	(PPU0.unPFEN18.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN18_PFEN28	(PPU0.unPFEN18.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN18_PFEN29	(PPU0.unPFEN18.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN18_PFEN30	(PPU0.unPFEN18.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN18_PFEN31	(PPU0.unPFEN18.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN19	(PPU0.unPFEN19.u32Register)  /*@rg@*/
#define PPU0_PFEN19_PFEN0	(PPU0.unPFEN19.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN19_PFEN1	(PPU0.unPFEN19.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN19_PFEN2	(PPU0.unPFEN19.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN19_PFEN3	(PPU0.unPFEN19.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN19_PFEN4	(PPU0.unPFEN19.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN19_PFEN5	(PPU0.unPFEN19.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN19_PFEN6	(PPU0.unPFEN19.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN19_PFEN7	(PPU0.unPFEN19.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN19_PFEN8	(PPU0.unPFEN19.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN19_PFEN9	(PPU0.unPFEN19.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN19_PFEN10	(PPU0.unPFEN19.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN19_PFEN11	(PPU0.unPFEN19.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN19_PFEN12	(PPU0.unPFEN19.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN19_PFEN13	(PPU0.unPFEN19.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN19_PFEN14	(PPU0.unPFEN19.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN19_PFEN15	(PPU0.unPFEN19.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN19_PFEN16	(PPU0.unPFEN19.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN19_PFEN17	(PPU0.unPFEN19.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN19_PFEN18	(PPU0.unPFEN19.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN19_PFEN19	(PPU0.unPFEN19.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN19_PFEN20	(PPU0.unPFEN19.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN19_PFEN21	(PPU0.unPFEN19.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN19_PFEN22	(PPU0.unPFEN19.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN19_PFEN23	(PPU0.unPFEN19.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN19_PFEN24	(PPU0.unPFEN19.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN19_PFEN25	(PPU0.unPFEN19.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN19_PFEN26	(PPU0.unPFEN19.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN19_PFEN27	(PPU0.unPFEN19.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN19_PFEN28	(PPU0.unPFEN19.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN19_PFEN29	(PPU0.unPFEN19.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN19_PFEN30	(PPU0.unPFEN19.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN19_PFEN31	(PPU0.unPFEN19.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN20	(PPU0.unPFEN20.u32Register)  /*@rg@*/
#define PPU0_PFEN20_PFEN0	(PPU0.unPFEN20.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN20_PFEN1	(PPU0.unPFEN20.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN20_PFEN2	(PPU0.unPFEN20.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN20_PFEN3	(PPU0.unPFEN20.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN20_PFEN4	(PPU0.unPFEN20.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN20_PFEN5	(PPU0.unPFEN20.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN20_PFEN6	(PPU0.unPFEN20.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN20_PFEN7	(PPU0.unPFEN20.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN20_PFEN8	(PPU0.unPFEN20.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN20_PFEN9	(PPU0.unPFEN20.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN20_PFEN10	(PPU0.unPFEN20.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN20_PFEN11	(PPU0.unPFEN20.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN20_PFEN12	(PPU0.unPFEN20.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN20_PFEN13	(PPU0.unPFEN20.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN20_PFEN14	(PPU0.unPFEN20.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN20_PFEN15	(PPU0.unPFEN20.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN20_PFEN16	(PPU0.unPFEN20.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN20_PFEN17	(PPU0.unPFEN20.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN20_PFEN18	(PPU0.unPFEN20.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN20_PFEN19	(PPU0.unPFEN20.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN20_PFEN20	(PPU0.unPFEN20.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN20_PFEN21	(PPU0.unPFEN20.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN20_PFEN22	(PPU0.unPFEN20.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN20_PFEN23	(PPU0.unPFEN20.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN20_PFEN24	(PPU0.unPFEN20.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN20_PFEN25	(PPU0.unPFEN20.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN20_PFEN26	(PPU0.unPFEN20.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN20_PFEN27	(PPU0.unPFEN20.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN20_PFEN28	(PPU0.unPFEN20.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN20_PFEN29	(PPU0.unPFEN20.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN20_PFEN30	(PPU0.unPFEN20.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN20_PFEN31	(PPU0.unPFEN20.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN21	(PPU0.unPFEN21.u32Register)  /*@rg@*/
#define PPU0_PFEN21_PFEN0	(PPU0.unPFEN21.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN21_PFEN1	(PPU0.unPFEN21.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN21_PFEN2	(PPU0.unPFEN21.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN21_PFEN3	(PPU0.unPFEN21.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN21_PFEN4	(PPU0.unPFEN21.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN21_PFEN5	(PPU0.unPFEN21.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN21_PFEN6	(PPU0.unPFEN21.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN21_PFEN7	(PPU0.unPFEN21.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN21_PFEN8	(PPU0.unPFEN21.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN21_PFEN9	(PPU0.unPFEN21.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN21_PFEN10	(PPU0.unPFEN21.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN21_PFEN11	(PPU0.unPFEN21.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN21_PFEN12	(PPU0.unPFEN21.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN21_PFEN13	(PPU0.unPFEN21.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN21_PFEN14	(PPU0.unPFEN21.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN21_PFEN15	(PPU0.unPFEN21.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN21_PFEN16	(PPU0.unPFEN21.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN21_PFEN17	(PPU0.unPFEN21.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN21_PFEN18	(PPU0.unPFEN21.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN21_PFEN19	(PPU0.unPFEN21.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN21_PFEN20	(PPU0.unPFEN21.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN21_PFEN21	(PPU0.unPFEN21.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN21_PFEN22	(PPU0.unPFEN21.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN21_PFEN23	(PPU0.unPFEN21.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN21_PFEN24	(PPU0.unPFEN21.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN21_PFEN25	(PPU0.unPFEN21.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN21_PFEN26	(PPU0.unPFEN21.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN21_PFEN27	(PPU0.unPFEN21.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN21_PFEN28	(PPU0.unPFEN21.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN21_PFEN29	(PPU0.unPFEN21.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN21_PFEN30	(PPU0.unPFEN21.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN21_PFEN31	(PPU0.unPFEN21.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN22	(PPU0.unPFEN22.u32Register)  /*@rg@*/
#define PPU0_PFEN22_PFEN0	(PPU0.unPFEN22.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN22_PFEN1	(PPU0.unPFEN22.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN22_PFEN2	(PPU0.unPFEN22.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN22_PFEN3	(PPU0.unPFEN22.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN22_PFEN4	(PPU0.unPFEN22.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN22_PFEN5	(PPU0.unPFEN22.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN22_PFEN6	(PPU0.unPFEN22.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN22_PFEN7	(PPU0.unPFEN22.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN22_PFEN8	(PPU0.unPFEN22.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN22_PFEN9	(PPU0.unPFEN22.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN22_PFEN10	(PPU0.unPFEN22.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN22_PFEN11	(PPU0.unPFEN22.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN22_PFEN12	(PPU0.unPFEN22.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN22_PFEN13	(PPU0.unPFEN22.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN22_PFEN14	(PPU0.unPFEN22.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN22_PFEN15	(PPU0.unPFEN22.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN22_PFEN16	(PPU0.unPFEN22.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN22_PFEN17	(PPU0.unPFEN22.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN22_PFEN18	(PPU0.unPFEN22.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN22_PFEN19	(PPU0.unPFEN22.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN22_PFEN20	(PPU0.unPFEN22.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN22_PFEN21	(PPU0.unPFEN22.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN22_PFEN22	(PPU0.unPFEN22.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN22_PFEN23	(PPU0.unPFEN22.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN22_PFEN24	(PPU0.unPFEN22.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN22_PFEN25	(PPU0.unPFEN22.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN22_PFEN26	(PPU0.unPFEN22.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN22_PFEN27	(PPU0.unPFEN22.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN22_PFEN28	(PPU0.unPFEN22.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN22_PFEN29	(PPU0.unPFEN22.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN22_PFEN30	(PPU0.unPFEN22.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN22_PFEN31	(PPU0.unPFEN22.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN23	(PPU0.unPFEN23.u32Register)  /*@rg@*/
#define PPU0_PFEN23_PFEN0	(PPU0.unPFEN23.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN23_PFEN1	(PPU0.unPFEN23.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN23_PFEN2	(PPU0.unPFEN23.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN23_PFEN3	(PPU0.unPFEN23.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN23_PFEN4	(PPU0.unPFEN23.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN23_PFEN5	(PPU0.unPFEN23.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN23_PFEN6	(PPU0.unPFEN23.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN23_PFEN7	(PPU0.unPFEN23.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN23_PFEN8	(PPU0.unPFEN23.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN23_PFEN9	(PPU0.unPFEN23.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN23_PFEN10	(PPU0.unPFEN23.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN23_PFEN11	(PPU0.unPFEN23.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN23_PFEN12	(PPU0.unPFEN23.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN23_PFEN13	(PPU0.unPFEN23.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN23_PFEN14	(PPU0.unPFEN23.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN23_PFEN15	(PPU0.unPFEN23.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN23_PFEN16	(PPU0.unPFEN23.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN23_PFEN17	(PPU0.unPFEN23.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN23_PFEN18	(PPU0.unPFEN23.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN23_PFEN19	(PPU0.unPFEN23.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN23_PFEN20	(PPU0.unPFEN23.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN23_PFEN21	(PPU0.unPFEN23.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN23_PFEN22	(PPU0.unPFEN23.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN23_PFEN23	(PPU0.unPFEN23.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN23_PFEN24	(PPU0.unPFEN23.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN23_PFEN25	(PPU0.unPFEN23.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN23_PFEN26	(PPU0.unPFEN23.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN23_PFEN27	(PPU0.unPFEN23.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN23_PFEN28	(PPU0.unPFEN23.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN23_PFEN29	(PPU0.unPFEN23.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN23_PFEN30	(PPU0.unPFEN23.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN23_PFEN31	(PPU0.unPFEN23.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN24	(PPU0.unPFEN24.u32Register)  /*@rg@*/
#define PPU0_PFEN24_PFEN0	(PPU0.unPFEN24.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN24_PFEN1	(PPU0.unPFEN24.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN24_PFEN2	(PPU0.unPFEN24.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN24_PFEN3	(PPU0.unPFEN24.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN24_PFEN4	(PPU0.unPFEN24.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN24_PFEN5	(PPU0.unPFEN24.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN24_PFEN6	(PPU0.unPFEN24.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN24_PFEN7	(PPU0.unPFEN24.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN24_PFEN8	(PPU0.unPFEN24.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN24_PFEN9	(PPU0.unPFEN24.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN24_PFEN10	(PPU0.unPFEN24.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN24_PFEN11	(PPU0.unPFEN24.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN24_PFEN12	(PPU0.unPFEN24.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN24_PFEN13	(PPU0.unPFEN24.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN24_PFEN14	(PPU0.unPFEN24.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN24_PFEN15	(PPU0.unPFEN24.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN24_PFEN16	(PPU0.unPFEN24.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN24_PFEN17	(PPU0.unPFEN24.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN24_PFEN18	(PPU0.unPFEN24.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN24_PFEN19	(PPU0.unPFEN24.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN24_PFEN20	(PPU0.unPFEN24.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN24_PFEN21	(PPU0.unPFEN24.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN24_PFEN22	(PPU0.unPFEN24.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN24_PFEN23	(PPU0.unPFEN24.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN24_PFEN24	(PPU0.unPFEN24.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN24_PFEN25	(PPU0.unPFEN24.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN24_PFEN26	(PPU0.unPFEN24.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN24_PFEN27	(PPU0.unPFEN24.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN24_PFEN28	(PPU0.unPFEN24.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN24_PFEN29	(PPU0.unPFEN24.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN24_PFEN30	(PPU0.unPFEN24.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN24_PFEN31	(PPU0.unPFEN24.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN25	(PPU0.unPFEN25.u32Register)  /*@rg@*/
#define PPU0_PFEN25_PFEN0	(PPU0.unPFEN25.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN25_PFEN1	(PPU0.unPFEN25.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN25_PFEN2	(PPU0.unPFEN25.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN25_PFEN3	(PPU0.unPFEN25.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN25_PFEN4	(PPU0.unPFEN25.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN25_PFEN5	(PPU0.unPFEN25.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN25_PFEN6	(PPU0.unPFEN25.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN25_PFEN7	(PPU0.unPFEN25.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN25_PFEN8	(PPU0.unPFEN25.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN25_PFEN9	(PPU0.unPFEN25.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN25_PFEN10	(PPU0.unPFEN25.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN25_PFEN11	(PPU0.unPFEN25.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN25_PFEN12	(PPU0.unPFEN25.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN25_PFEN13	(PPU0.unPFEN25.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN25_PFEN14	(PPU0.unPFEN25.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN25_PFEN15	(PPU0.unPFEN25.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN25_PFEN16	(PPU0.unPFEN25.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN25_PFEN17	(PPU0.unPFEN25.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN25_PFEN18	(PPU0.unPFEN25.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN25_PFEN19	(PPU0.unPFEN25.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN25_PFEN20	(PPU0.unPFEN25.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN25_PFEN21	(PPU0.unPFEN25.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN25_PFEN22	(PPU0.unPFEN25.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN25_PFEN23	(PPU0.unPFEN25.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN25_PFEN24	(PPU0.unPFEN25.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN25_PFEN25	(PPU0.unPFEN25.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN25_PFEN26	(PPU0.unPFEN25.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN25_PFEN27	(PPU0.unPFEN25.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN25_PFEN28	(PPU0.unPFEN25.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN25_PFEN29	(PPU0.unPFEN25.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN25_PFEN30	(PPU0.unPFEN25.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN25_PFEN31	(PPU0.unPFEN25.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN26	(PPU0.unPFEN26.u32Register)  /*@rg@*/
#define PPU0_PFEN26_PFEN0	(PPU0.unPFEN26.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN26_PFEN1	(PPU0.unPFEN26.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN26_PFEN2	(PPU0.unPFEN26.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN26_PFEN3	(PPU0.unPFEN26.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN26_PFEN4	(PPU0.unPFEN26.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN26_PFEN5	(PPU0.unPFEN26.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN26_PFEN6	(PPU0.unPFEN26.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN26_PFEN7	(PPU0.unPFEN26.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN26_PFEN8	(PPU0.unPFEN26.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN26_PFEN9	(PPU0.unPFEN26.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN26_PFEN10	(PPU0.unPFEN26.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN26_PFEN11	(PPU0.unPFEN26.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN26_PFEN12	(PPU0.unPFEN26.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN26_PFEN13	(PPU0.unPFEN26.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN26_PFEN14	(PPU0.unPFEN26.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN26_PFEN15	(PPU0.unPFEN26.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN26_PFEN16	(PPU0.unPFEN26.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN26_PFEN17	(PPU0.unPFEN26.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN26_PFEN18	(PPU0.unPFEN26.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN26_PFEN19	(PPU0.unPFEN26.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN26_PFEN20	(PPU0.unPFEN26.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN26_PFEN21	(PPU0.unPFEN26.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN26_PFEN22	(PPU0.unPFEN26.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN26_PFEN23	(PPU0.unPFEN26.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN26_PFEN24	(PPU0.unPFEN26.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN26_PFEN25	(PPU0.unPFEN26.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN26_PFEN26	(PPU0.unPFEN26.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN26_PFEN27	(PPU0.unPFEN26.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN26_PFEN28	(PPU0.unPFEN26.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN26_PFEN29	(PPU0.unPFEN26.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN26_PFEN30	(PPU0.unPFEN26.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN26_PFEN31	(PPU0.unPFEN26.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN27	(PPU0.unPFEN27.u32Register)  /*@rg@*/
#define PPU0_PFEN27_PFEN0	(PPU0.unPFEN27.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN27_PFEN1	(PPU0.unPFEN27.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN27_PFEN2	(PPU0.unPFEN27.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN27_PFEN3	(PPU0.unPFEN27.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN27_PFEN4	(PPU0.unPFEN27.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN27_PFEN5	(PPU0.unPFEN27.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN27_PFEN6	(PPU0.unPFEN27.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN27_PFEN7	(PPU0.unPFEN27.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN27_PFEN8	(PPU0.unPFEN27.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN27_PFEN9	(PPU0.unPFEN27.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN27_PFEN10	(PPU0.unPFEN27.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN27_PFEN11	(PPU0.unPFEN27.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN27_PFEN12	(PPU0.unPFEN27.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN27_PFEN13	(PPU0.unPFEN27.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN27_PFEN14	(PPU0.unPFEN27.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN27_PFEN15	(PPU0.unPFEN27.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN27_PFEN16	(PPU0.unPFEN27.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN27_PFEN17	(PPU0.unPFEN27.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN27_PFEN18	(PPU0.unPFEN27.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN27_PFEN19	(PPU0.unPFEN27.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN27_PFEN20	(PPU0.unPFEN27.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN27_PFEN21	(PPU0.unPFEN27.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN27_PFEN22	(PPU0.unPFEN27.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN27_PFEN23	(PPU0.unPFEN27.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN27_PFEN24	(PPU0.unPFEN27.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN27_PFEN25	(PPU0.unPFEN27.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN27_PFEN26	(PPU0.unPFEN27.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN27_PFEN27	(PPU0.unPFEN27.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN27_PFEN28	(PPU0.unPFEN27.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN27_PFEN29	(PPU0.unPFEN27.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN27_PFEN30	(PPU0.unPFEN27.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN27_PFEN31	(PPU0.unPFEN27.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN28	(PPU0.unPFEN28.u32Register)  /*@rg@*/
#define PPU0_PFEN28_PFEN0	(PPU0.unPFEN28.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN28_PFEN1	(PPU0.unPFEN28.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN28_PFEN2	(PPU0.unPFEN28.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN28_PFEN3	(PPU0.unPFEN28.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN28_PFEN4	(PPU0.unPFEN28.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN28_PFEN5	(PPU0.unPFEN28.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN28_PFEN6	(PPU0.unPFEN28.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN28_PFEN7	(PPU0.unPFEN28.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN28_PFEN8	(PPU0.unPFEN28.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN28_PFEN9	(PPU0.unPFEN28.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN28_PFEN10	(PPU0.unPFEN28.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN28_PFEN11	(PPU0.unPFEN28.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN28_PFEN12	(PPU0.unPFEN28.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN28_PFEN13	(PPU0.unPFEN28.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN28_PFEN14	(PPU0.unPFEN28.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN28_PFEN15	(PPU0.unPFEN28.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN28_PFEN16	(PPU0.unPFEN28.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN28_PFEN17	(PPU0.unPFEN28.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN28_PFEN18	(PPU0.unPFEN28.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN28_PFEN19	(PPU0.unPFEN28.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN28_PFEN20	(PPU0.unPFEN28.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN28_PFEN21	(PPU0.unPFEN28.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN28_PFEN22	(PPU0.unPFEN28.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN28_PFEN23	(PPU0.unPFEN28.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN28_PFEN24	(PPU0.unPFEN28.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN28_PFEN25	(PPU0.unPFEN28.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN28_PFEN26	(PPU0.unPFEN28.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN28_PFEN27	(PPU0.unPFEN28.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN28_PFEN28	(PPU0.unPFEN28.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN28_PFEN29	(PPU0.unPFEN28.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN28_PFEN30	(PPU0.unPFEN28.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN28_PFEN31	(PPU0.unPFEN28.stcField.u1PFEN31)  /*@bf@*/

#define PPU0_PFEN29	(PPU0.unPFEN29.u32Register)  /*@rg@*/
#define PPU0_PFEN29_PFEN0	(PPU0.unPFEN29.stcField.u1PFEN0)  /*@bf@*/
#define PPU0_PFEN29_PFEN1	(PPU0.unPFEN29.stcField.u1PFEN1)  /*@bf@*/
#define PPU0_PFEN29_PFEN2	(PPU0.unPFEN29.stcField.u1PFEN2)  /*@bf@*/
#define PPU0_PFEN29_PFEN3	(PPU0.unPFEN29.stcField.u1PFEN3)  /*@bf@*/
#define PPU0_PFEN29_PFEN4	(PPU0.unPFEN29.stcField.u1PFEN4)  /*@bf@*/
#define PPU0_PFEN29_PFEN5	(PPU0.unPFEN29.stcField.u1PFEN5)  /*@bf@*/
#define PPU0_PFEN29_PFEN6	(PPU0.unPFEN29.stcField.u1PFEN6)  /*@bf@*/
#define PPU0_PFEN29_PFEN7	(PPU0.unPFEN29.stcField.u1PFEN7)  /*@bf@*/
#define PPU0_PFEN29_PFEN8	(PPU0.unPFEN29.stcField.u1PFEN8)  /*@bf@*/
#define PPU0_PFEN29_PFEN9	(PPU0.unPFEN29.stcField.u1PFEN9)  /*@bf@*/
#define PPU0_PFEN29_PFEN10	(PPU0.unPFEN29.stcField.u1PFEN10)  /*@bf@*/
#define PPU0_PFEN29_PFEN11	(PPU0.unPFEN29.stcField.u1PFEN11)  /*@bf@*/
#define PPU0_PFEN29_PFEN12	(PPU0.unPFEN29.stcField.u1PFEN12)  /*@bf@*/
#define PPU0_PFEN29_PFEN13	(PPU0.unPFEN29.stcField.u1PFEN13)  /*@bf@*/
#define PPU0_PFEN29_PFEN14	(PPU0.unPFEN29.stcField.u1PFEN14)  /*@bf@*/
#define PPU0_PFEN29_PFEN15	(PPU0.unPFEN29.stcField.u1PFEN15)  /*@bf@*/
#define PPU0_PFEN29_PFEN16	(PPU0.unPFEN29.stcField.u1PFEN16)  /*@bf@*/
#define PPU0_PFEN29_PFEN17	(PPU0.unPFEN29.stcField.u1PFEN17)  /*@bf@*/
#define PPU0_PFEN29_PFEN18	(PPU0.unPFEN29.stcField.u1PFEN18)  /*@bf@*/
#define PPU0_PFEN29_PFEN19	(PPU0.unPFEN29.stcField.u1PFEN19)  /*@bf@*/
#define PPU0_PFEN29_PFEN20	(PPU0.unPFEN29.stcField.u1PFEN20)  /*@bf@*/
#define PPU0_PFEN29_PFEN21	(PPU0.unPFEN29.stcField.u1PFEN21)  /*@bf@*/
#define PPU0_PFEN29_PFEN22	(PPU0.unPFEN29.stcField.u1PFEN22)  /*@bf@*/
#define PPU0_PFEN29_PFEN23	(PPU0.unPFEN29.stcField.u1PFEN23)  /*@bf@*/
#define PPU0_PFEN29_PFEN24	(PPU0.unPFEN29.stcField.u1PFEN24)  /*@bf@*/
#define PPU0_PFEN29_PFEN25	(PPU0.unPFEN29.stcField.u1PFEN25)  /*@bf@*/
#define PPU0_PFEN29_PFEN26	(PPU0.unPFEN29.stcField.u1PFEN26)  /*@bf@*/
#define PPU0_PFEN29_PFEN27	(PPU0.unPFEN29.stcField.u1PFEN27)  /*@bf@*/
#define PPU0_PFEN29_PFEN28	(PPU0.unPFEN29.stcField.u1PFEN28)  /*@bf@*/
#define PPU0_PFEN29_PFEN29	(PPU0.unPFEN29.stcField.u1PFEN29)  /*@bf@*/
#define PPU0_PFEN29_PFEN30	(PPU0.unPFEN29.stcField.u1PFEN30)  /*@bf@*/
#define PPU0_PFEN29_PFEN31	(PPU0.unPFEN29.stcField.u1PFEN31)  /*@bf@*/

typedef struct stc_ppu0_pfenn_field{
    uint_io32_t		u1PFEN0:1;
    uint_io32_t		u1PFEN1:1;
    uint_io32_t		u1PFEN2:1;
    uint_io32_t		u1PFEN3:1;
    uint_io32_t		u1PFEN4:1;
    uint_io32_t		u1PFEN5:1;
    uint_io32_t		u1PFEN6:1;
    uint_io32_t		u1PFEN7:1;
    uint_io32_t		u1PFEN8:1;
    uint_io32_t		u1PFEN9:1;
    uint_io32_t		u1PFEN10:1;
    uint_io32_t		u1PFEN11:1;
    uint_io32_t		u1PFEN12:1;
    uint_io32_t		u1PFEN13:1;
    uint_io32_t		u1PFEN14:1;
    uint_io32_t		u1PFEN15:1;
    uint_io32_t		u1PFEN16:1;
    uint_io32_t		u1PFEN17:1;
    uint_io32_t		u1PFEN18:1;
    uint_io32_t		u1PFEN19:1;
    uint_io32_t		u1PFEN20:1;
    uint_io32_t		u1PFEN21:1;
    uint_io32_t		u1PFEN22:1;
    uint_io32_t		u1PFEN23:1;
    uint_io32_t		u1PFEN24:1;
    uint_io32_t		u1PFEN25:1;
    uint_io32_t		u1PFEN26:1;
    uint_io32_t		u1PFEN27:1;
    uint_io32_t		u1PFEN28:1;
    uint_io32_t		u1PFEN29:1;
    uint_io32_t		u1PFEN30:1;
    uint_io32_t		u1PFEN31:1;
}stc_ppu0_pfenn_field_t;

typedef union un_ppu0_pfenn{
    uint_io32_t		u32Register;
    stc_ppu0_pfenn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_pfenn_t;

/* LOCK4 */
#define PPU0_LOCK4	(PPU0.unLOCK4.u32Register)  /*@rg@*/
#define PPU0_LOCK4_L	PPU0_LOCK4  /*@bfrg@*/

typedef union un_ppu0_lock4{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppu0_lock4_t;


typedef struct stc_ppu0{
    un_ppu0_cr_t	unCR;	/* 0x00000000 */
    un_ppu0_sr_t	unSR;	/* 0x00000004 */
    un_ppu0_unlock_t	unUNLOCK;	/* 0x00000008 */
    un_ppu0_wpqclr_t	unWPQCLR;	/* 0x0000000C */
    un_ppu0_wuqclr_t	unWUQCLR;	/* 0x00000010 */
    un_ppu0_rpqclr_t	unRPQCLR;	/* 0x00000014 */
    un_ppu0_ruqclr_t	unRUQCLR;	/* 0x00000018 */
    uint_io8_t	au8Reserved0[100];	/* 0x0000001C */
    un_ppu0_pprn_t	unPPR0;	/* 0x00000080 */
    un_ppu0_pprn_t	unPPR1;	/* 0x00000084 */
    un_ppu0_pprn_t	unPPR2;	/* 0x00000088 */
    un_ppu0_pprn_t	unPPR3;	/* 0x0000008C */
    un_ppu0_pprn_t	unPPR4;	/* 0x00000090 */
    un_ppu0_pprn_t	unPPR5;	/* 0x00000094 */
    un_ppu0_pprn_t	unPPR6;	/* 0x00000098 */
    un_ppu0_pprn_t	unPPR7;	/* 0x0000009C */
    un_ppu0_pprn_t	unPPR8;	/* 0x000000A0 */
    un_ppu0_pprn_t	unPPR9;	/* 0x000000A4 */
    un_ppu0_pprn_t	unPPR10;	/* 0x000000A8 */
    un_ppu0_pprn_t	unPPR11;	/* 0x000000AC */
    un_ppu0_pprn_t	unPPR12;	/* 0x000000B0 */
    un_ppu0_pprn_t	unPPR13;	/* 0x000000B4 */
    un_ppu0_pprn_t	unPPR14;	/* 0x000000B8 */
    un_ppu0_pprn_t	unPPR15;	/* 0x000000BC */
    un_ppu0_pprn_t	unPPR16;	/* 0x000000C0 */
    un_ppu0_pprn_t	unPPR17;	/* 0x000000C4 */
    un_ppu0_pprn_t	unPPR18;	/* 0x000000C8 */
    un_ppu0_pprn_t	unPPR19;	/* 0x000000CC */
    un_ppu0_pprn_t	unPPR20;	/* 0x000000D0 */
    un_ppu0_pprn_t	unPPR21;	/* 0x000000D4 */
    un_ppu0_pprn_t	unPPR22;	/* 0x000000D8 */
    un_ppu0_pprn_t	unPPR23;	/* 0x000000DC */
    un_ppu0_pprn_t	unPPR24;	/* 0x000000E0 */
    un_ppu0_pprn_t	unPPR25;	/* 0x000000E4 */
    un_ppu0_pprn_t	unPPR26;	/* 0x000000E8 */
    un_ppu0_pprn_t	unPPR27;	/* 0x000000EC */
    un_ppu0_pprn_t	unPPR28;	/* 0x000000F0 */
    un_ppu0_pprn_t	unPPR29;	/* 0x000000F4 */
    un_ppu0_lock0_t	unLOCK0;	/* 0x000000F8 */
    uint_io8_t	au8Reserved1[4];	/* 0x000000FC */
    un_ppu0_purn_t	unPUR0;	/* 0x00000100 */
    un_ppu0_purn_t	unPUR1;	/* 0x00000104 */
    un_ppu0_purn_t	unPUR2;	/* 0x00000108 */
    un_ppu0_purn_t	unPUR3;	/* 0x0000010C */
    un_ppu0_purn_t	unPUR4;	/* 0x00000110 */
    un_ppu0_purn_t	unPUR5;	/* 0x00000114 */
    un_ppu0_purn_t	unPUR6;	/* 0x00000118 */
    un_ppu0_purn_t	unPUR7;	/* 0x0000011C */
    un_ppu0_purn_t	unPUR8;	/* 0x00000120 */
    un_ppu0_purn_t	unPUR9;	/* 0x00000124 */
    un_ppu0_purn_t	unPUR10;	/* 0x00000128 */
    un_ppu0_purn_t	unPUR11;	/* 0x0000012C */
    un_ppu0_purn_t	unPUR12;	/* 0x00000130 */
    un_ppu0_purn_t	unPUR13;	/* 0x00000134 */
    un_ppu0_purn_t	unPUR14;	/* 0x00000138 */
    un_ppu0_purn_t	unPUR15;	/* 0x0000013C */
    un_ppu0_purn_t	unPUR16;	/* 0x00000140 */
    un_ppu0_purn_t	unPUR17;	/* 0x00000144 */
    un_ppu0_purn_t	unPUR18;	/* 0x00000148 */
    un_ppu0_purn_t	unPUR19;	/* 0x0000014C */
    un_ppu0_purn_t	unPUR20;	/* 0x00000150 */
    un_ppu0_purn_t	unPUR21;	/* 0x00000154 */
    un_ppu0_purn_t	unPUR22;	/* 0x00000158 */
    un_ppu0_purn_t	unPUR23;	/* 0x0000015C */
    un_ppu0_purn_t	unPUR24;	/* 0x00000160 */
    un_ppu0_purn_t	unPUR25;	/* 0x00000164 */
    un_ppu0_purn_t	unPUR26;	/* 0x00000168 */
    un_ppu0_purn_t	unPUR27;	/* 0x0000016C */
    un_ppu0_purn_t	unPUR28;	/* 0x00000170 */
    un_ppu0_purn_t	unPUR29;	/* 0x00000174 */
    un_ppu0_lock1_t	unLOCK1;	/* 0x00000178 */
    uint_io8_t	au8Reserved2[4];	/* 0x0000017C */
    un_ppu0_ppwan_t	unPPWA0;	/* 0x00000180 */
    un_ppu0_ppwan_t	unPPWA1;	/* 0x00000184 */
    un_ppu0_ppwan_t	unPPWA2;	/* 0x00000188 */
    un_ppu0_ppwan_t	unPPWA3;	/* 0x0000018C */
    un_ppu0_ppwan_t	unPPWA4;	/* 0x00000190 */
    un_ppu0_ppwan_t	unPPWA5;	/* 0x00000194 */
    un_ppu0_ppwan_t	unPPWA6;	/* 0x00000198 */
    un_ppu0_ppwan_t	unPPWA7;	/* 0x0000019C */
    un_ppu0_ppwan_t	unPPWA8;	/* 0x000001A0 */
    un_ppu0_ppwan_t	unPPWA9;	/* 0x000001A4 */
    un_ppu0_ppwan_t	unPPWA10;	/* 0x000001A8 */
    un_ppu0_ppwan_t	unPPWA11;	/* 0x000001AC */
    un_ppu0_ppwan_t	unPPWA12;	/* 0x000001B0 */
    un_ppu0_ppwan_t	unPPWA13;	/* 0x000001B4 */
    un_ppu0_ppwan_t	unPPWA14;	/* 0x000001B8 */
    un_ppu0_ppwan_t	unPPWA15;	/* 0x000001BC */
    un_ppu0_ppwan_t	unPPWA16;	/* 0x000001C0 */
    un_ppu0_ppwan_t	unPPWA17;	/* 0x000001C4 */
    un_ppu0_ppwan_t	unPPWA18;	/* 0x000001C8 */
    un_ppu0_ppwan_t	unPPWA19;	/* 0x000001CC */
    un_ppu0_ppwan_t	unPPWA20;	/* 0x000001D0 */
    un_ppu0_ppwan_t	unPPWA21;	/* 0x000001D4 */
    un_ppu0_ppwan_t	unPPWA22;	/* 0x000001D8 */
    un_ppu0_ppwan_t	unPPWA23;	/* 0x000001DC */
    un_ppu0_ppwan_t	unPPWA24;	/* 0x000001E0 */
    un_ppu0_ppwan_t	unPPWA25;	/* 0x000001E4 */
    un_ppu0_ppwan_t	unPPWA26;	/* 0x000001E8 */
    un_ppu0_ppwan_t	unPPWA27;	/* 0x000001EC */
    un_ppu0_ppwan_t	unPPWA28;	/* 0x000001F0 */
    un_ppu0_ppwan_t	unPPWA29;	/* 0x000001F4 */
    un_ppu0_lock2_t	unLOCK2;	/* 0x000001F8 */
    uint_io8_t	au8Reserved3[4];	/* 0x000001FC */
    un_ppu0_puwan_t	unPUWA0;	/* 0x00000200 */
    un_ppu0_puwan_t	unPUWA1;	/* 0x00000204 */
    un_ppu0_puwan_t	unPUWA2;	/* 0x00000208 */
    un_ppu0_puwan_t	unPUWA3;	/* 0x0000020C */
    un_ppu0_puwan_t	unPUWA4;	/* 0x00000210 */
    un_ppu0_puwan_t	unPUWA5;	/* 0x00000214 */
    un_ppu0_puwan_t	unPUWA6;	/* 0x00000218 */
    un_ppu0_puwan_t	unPUWA7;	/* 0x0000021C */
    un_ppu0_puwan_t	unPUWA8;	/* 0x00000220 */
    un_ppu0_puwan_t	unPUWA9;	/* 0x00000224 */
    un_ppu0_puwan_t	unPUWA10;	/* 0x00000228 */
    un_ppu0_puwan_t	unPUWA11;	/* 0x0000022C */
    un_ppu0_puwan_t	unPUWA12;	/* 0x00000230 */
    un_ppu0_puwan_t	unPUWA13;	/* 0x00000234 */
    un_ppu0_puwan_t	unPUWA14;	/* 0x00000238 */
    un_ppu0_puwan_t	unPUWA15;	/* 0x0000023C */
    un_ppu0_puwan_t	unPUWA16;	/* 0x00000240 */
    un_ppu0_puwan_t	unPUWA17;	/* 0x00000244 */
    un_ppu0_puwan_t	unPUWA18;	/* 0x00000248 */
    un_ppu0_puwan_t	unPUWA19;	/* 0x0000024C */
    un_ppu0_puwan_t	unPUWA20;	/* 0x00000250 */
    un_ppu0_puwan_t	unPUWA21;	/* 0x00000254 */
    un_ppu0_puwan_t	unPUWA22;	/* 0x00000258 */
    un_ppu0_puwan_t	unPUWA23;	/* 0x0000025C */
    un_ppu0_puwan_t	unPUWA24;	/* 0x00000260 */
    un_ppu0_puwan_t	unPUWA25;	/* 0x00000264 */
    un_ppu0_puwan_t	unPUWA26;	/* 0x00000268 */
    un_ppu0_puwan_t	unPUWA27;	/* 0x0000026C */
    un_ppu0_puwan_t	unPUWA28;	/* 0x00000270 */
    un_ppu0_puwan_t	unPUWA29;	/* 0x00000274 */
    un_ppu0_lock3_t	unLOCK3;	/* 0x00000278 */
    uint_io8_t	au8Reserved4[4];	/* 0x0000027C */
    un_ppu0_pfenn_t	unPFEN0;	/* 0x00000280 */
    un_ppu0_pfenn_t	unPFEN1;	/* 0x00000284 */
    un_ppu0_pfenn_t	unPFEN2;	/* 0x00000288 */
    un_ppu0_pfenn_t	unPFEN3;	/* 0x0000028C */
    un_ppu0_pfenn_t	unPFEN4;	/* 0x00000290 */
    un_ppu0_pfenn_t	unPFEN5;	/* 0x00000294 */
    un_ppu0_pfenn_t	unPFEN6;	/* 0x00000298 */
    un_ppu0_pfenn_t	unPFEN7;	/* 0x0000029C */
    un_ppu0_pfenn_t	unPFEN8;	/* 0x000002A0 */
    un_ppu0_pfenn_t	unPFEN9;	/* 0x000002A4 */
    un_ppu0_pfenn_t	unPFEN10;	/* 0x000002A8 */
    un_ppu0_pfenn_t	unPFEN11;	/* 0x000002AC */
    un_ppu0_pfenn_t	unPFEN12;	/* 0x000002B0 */
    un_ppu0_pfenn_t	unPFEN13;	/* 0x000002B4 */
    un_ppu0_pfenn_t	unPFEN14;	/* 0x000002B8 */
    un_ppu0_pfenn_t	unPFEN15;	/* 0x000002BC */
    un_ppu0_pfenn_t	unPFEN16;	/* 0x000002C0 */
    un_ppu0_pfenn_t	unPFEN17;	/* 0x000002C4 */
    un_ppu0_pfenn_t	unPFEN18;	/* 0x000002C8 */
    un_ppu0_pfenn_t	unPFEN19;	/* 0x000002CC */
    un_ppu0_pfenn_t	unPFEN20;	/* 0x000002D0 */
    un_ppu0_pfenn_t	unPFEN21;	/* 0x000002D4 */
    un_ppu0_pfenn_t	unPFEN22;	/* 0x000002D8 */
    un_ppu0_pfenn_t	unPFEN23;	/* 0x000002DC */
    un_ppu0_pfenn_t	unPFEN24;	/* 0x000002E0 */
    un_ppu0_pfenn_t	unPFEN25;	/* 0x000002E4 */
    un_ppu0_pfenn_t	unPFEN26;	/* 0x000002E8 */
    un_ppu0_pfenn_t	unPFEN27;	/* 0x000002EC */
    un_ppu0_pfenn_t	unPFEN28;	/* 0x000002F0 */
    un_ppu0_pfenn_t	unPFEN29;	/* 0x000002F4 */
    un_ppu0_lock4_t	unLOCK4;	/* 0x000002F8 */
    uint_io8_t	au8Reserved5[32004];	/* 0x000002FC */
}stc_ppu0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_ppu0_t	stcPPU0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_PPU_H */
