#ifndef _DTC_H_
#define _DTC_H_

#include "base_types.h"

#define TDTC_2ms         1
#define TDTC_4ms         2
#define TDTC_6ms         3
#define TDTC_10ms        5
#define TDTC_20ms        10
#define TDTC_30ms        TDTC_2ms * 15
#define TDTC_40ms        TDTC_2ms * 20
#define TDTC_50ms        TDTC_2ms * 25
#define TDTC_54ms        TDTC_2ms * 27
#define TDTC_65ms        TDTC_2ms * 32
#define TDTC_96ms        47
#define TDTC_98ms        48
#define TDTC_100ms       49
#define TDTC_200ms       TDTC_100ms * 2
#define TDTC_300ms       TDTC_100ms * 3
#define TDTC_340ms       TDTC_2ms * 170
#define TDTC_344ms       TDTC_2ms * 172
#define TDTC_365ms       TDTC_300ms + T1_65ms
#define TDTC_400ms       TDTC_100ms * 4
#define TDTC_430ms       TDTC_300ms + T1_65ms + T1_65ms
#define TDTC_495ms       TDTC_300ms + T1_65ms + T1_65ms + T1_65ms
#define TDTC_500ms       TDTC_100ms * 5
#define TDTC_520ms       TDTC_2ms * 260
#define TDTC_600ms       TDTC_100ms * 6
#define TDTC_750ms       TDTC_2ms * 375
#define TDTC_754ms       TDTC_2ms * 377
#define TDTC_1000ms      500
#define TDTC_1s          490
#define TDTC_2s          980
#define TDTC_2_1s        TDTC_100ms * 20
#define TDTC_1_004s      TDTC_2ms * 502
#define TDTC_2_5s        TDTC_100ms * 25
#define TDTC_3s          TDTC_100ms * 30
#define TDTC_5s          TDTC_1s * 5
#define TDTC_20s         TDTC_5s * 4


#pragma pack(1)
typedef struct
{
    uint16_t   CanKeepTime;
    uint8_t    CanDataTime;
    uint8_t    CanDataCn;
    uint8_t    BusOffTime;
    uint8_t    BusOffCn;
} _CanClock;

typedef struct
{
    uint8_t SessionType;
    uint8_t AccessLock;
    uint8_t AccessCount;
    uint8_t key[4];
    uint8_t SubFunction;
    uint8_t w27_Sequence;
    uint8_t A5_Sequence;
    uint8_t DTCSettingType;
    uint8_t tDiagStart;
    uint8_t tDiagKL30ONStart;
    //uint8_t N_STmin;
    uint8_t N_REV_MAX_BS;
    uint8_t CommType;
    uint8_t CommCtl;
    uint8_t DTCByStatusMask;
} _DiagnoCtl;

typedef union
{
    struct
    {
        uint8_t TestFailed :1;
        uint8_t TestFailedThisOprCyc :1;
        uint8_t PendingDTC :1;
        uint8_t ConfirmedDTC :1;
        uint8_t TestNotCompLastClr :1;
        uint8_t TestFailedLastClr :1;
        uint8_t TestNotCompThisCyc :1;
        uint8_t WarnIndicatorReq :1;
    } Bits;
    uint8_t Flag;
} _StatusOfDTC;

typedef struct
{
    uint32_t DtcNum;
    uint8_t DtcIndex;
    uint8_t Exist;
    uint8_t DtcBlock;
    uint8_t DtcAddr;
} _DTC_MAP_INFO;

typedef union
{
    struct
    {
        uint8_t DtcNumL;
        uint8_t DtcNumM;
        uint8_t DtcNumH;
        uint8_t Reserved0;
    } Bytes;
    uint32_t Num;
} _NumOfDTC;

typedef struct
{
    uint8_t DTCHighByte;
    uint8_t DTCMiddleByte;
    uint8_t DTCLowByte;
    uint8_t statusOfDTC;
} _DTC_StatusRecord;

typedef struct
{
    _NumOfDTC DtcNum;
    uint8_t Addr;
    uint8_t bFlag;
    _StatusOfDTC  Status;
    uint8_t FaultOccurCount;
    uint8_t FaultPendCount;
    uint8_t DTCAgingCount;
    uint8_t DTCAgedCount;
    uint8_t ErrorTimes;
    uint8_t DTCAgingCntStar;
    uint8_t FaultPendingCntStar;
    uint8_t PassTimes;
    uint8_t bCheckSun;
} _DTC;

typedef struct
{
    uint8_t    EE_WriteDtcSel;
    uint8_t    DtcStep;
} _SaveDtcInfo;

typedef struct 
{          
    uint32_t       DtcNum;
    uint8_t        DTCExtDataRecordNum;  
}_19_6ReqRecord;
                                     
typedef struct 
{          
    uint32_t       NumAndStatus;
    uint8_t        dlc;
    uint8_t        Data[8]; 
}_19_6RetRecord;

enum {
    EOLNotProgrammed,
    SCCPresentError,
    SCCMissingError,
    EPBPresentError,
    EPBMissingError,
    MDPSPresentError,
    MDPSMissingError,
    ESCPresentError,
    ESCMissingError,
    TPMSPresentError,
    TPMSMissingError,
    LKA_LDWPresentError,
    LKA_LDWMissingError,
    AIRBIGPresentError,
    AIRBIGMissingError,
    TCUPresentError,
    TCUMissingError,
    MMCanBusOff,
    MMCanSingleLineError,
    DtcListTotal,
};
#pragma pack()

#define DtcSetOn 1 
#define DtcSetOff 2

#define NoneOpDTC_EE 0
#define ClearDTC_EE 2	
#define StoreDTC_EE 1
extern _DTC_StatusRecord DtcAndStatus[DtcListTotal];
extern _DTC DiagDtc[DtcListTotal];
extern const _DTC_MAP_INFO dtc_map_info[DtcListTotal];
extern _SaveDtcInfo SaveDtcInfo;
extern uint8_t MMCanBusOffCnts;
extern uint8_t MMCanSingleLineErrorCnts;

extern uint8_t ReadDtcFromEepromN;
extern uint8_t ReadDtcFromEepromMaxN;

extern void CheckDtcCondition(void);
extern void CheckBusoffDTC(void);
extern void App_DtcInfoInit(_DTC *DTC,uint32_t DtcNum);
extern void App_Load_DTC(void);
extern void App_CheckDtc_Store(const _DTC_MAP_INFO *mapInfo,_DTC *dtc);
extern uint8_t App_CheckDtcStatus(uint8_t i, uint8_t mask, _DTC *Dtc);
extern void App_DTC_EEpromInit(void);
extern uint16_t App_DTCCount_handle(uint8_t mask);
extern void App_DtcBit_handle(_DTC DTC[],uint8_t SignalLed, uint8_t pos);
extern void App_StoreDTC_handle(void);
extern void Diag_DTC_Check_main(void);
extern uint8_t App_Load_DTCAndStatus_Mask(uint8_t mask, uint8_t MaskValid);
extern void App_19_6Load(_19_6RetRecord *D19_6RetR, _DTC* DTC, _19_6ReqRecord* D19_6Req);
extern void App_DTC_InitPara(void);
extern void ReadDtcFromEeprom(void);

#endif
