#ifndef __APP_TFT_H__
#define __APP_TFT_H__

#define DEFAULT_BRIGHTNESS 0
#define SAME_TIME_DISPLAY_NUM 5
#define CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT 400
#define EACH_SURFACE_CONTAIN_PIC_NUM 180
#define CENTER_DISPLAY_PARA_STATIC 0
#define CENTER_DISPLAY_PARA_DYNC 1

#define DEFAULT_ALPHA            0

#define OFFSET_ADDRESS           0x80000000
#define Base_address      0x04000000

//_0____________________240
//|                      |
//|         W1           |
//|______________________|
//|                      |
//|                      |
//|                      |
//|                      |
//|         w2           |
//|                      |
//|                      |
//|                      |
//|                      |
//|______________________|
//|         w3           |
//|______________________|
//320
//xxhh add

#if (PRO_CONFIG_EOL_APPLY)
#define W1_START_Y      0
#define W1_STOP_Y       62

#define W2_START_Y      62
#define W2_STOP_Y       320

#define W3_START_Y      62
#define W3_STOP_Y       320
#else
#define W1_START_Y      0
#define W1_STOP_Y       102

#define W2_START_Y      103
#define W2_STOP_Y       292

#define W3_START_Y      294
#define W3_STOP_Y       320
#endif
#define MIN_START_X     0
#define MAX_STOP_X      240
#define MIN_START_Y     0
#define MAX_STOP_Y      320

#define STAGE_AutoCheck            1  //�Զ����?            ��Ӧ����:�Լ�
#define STAGE_Led_Telltale_Check   2  //�Ʊ��̼��?          ��Ӧ����:����
#define STAGE_WaterAndFuel         3  //ˮ�ͼ��?            ��Ӧ����:ȼ�͡�ˮ��+ �� ȼ�͡�ˮ��-
#define STAGE_Other                4  //����                ��Ӧ����:����


#define STAGE_ClearODO             5  //����              ��Ӧ����:END
#define STAGE_SetEOL               6  //����EOL             ��Ӧ����:����


#define STAGE_TFTCheck             7  //TFT���?             ��Ӧ����:TFT+��TFT-
#define STAGE_LCDCheck             8  //LCD���?             ��Ӧ����:A �� B

#define STAGE_Speed                9  //����Ƶ��ռ�ձȼ��?  ��Ӧ����:����+�ͳ���-
#define STAGE_OilDown              10

extern const uint8_t GearValue[5];


//#define  G_Stage  g_Stage
extern uint8_t  g_Stage,g_OldStage;
typedef struct
{
  uint16_t   Value;
  uint16_t   buf[50];
  uint32_t   sum;
  uint32_t   Time;
  uint8_t    Flag;
  uint8_t    enable;
  uint8_t    statu;
  uint32_t   count;
  uint8_t    Finsh;
  uint32_t   Time_one;
   uint8_t   Flag_one;
}_StaticCurrent;

typedef struct
{
  int32_t    Time;
  uint8_t    enable;
}_KeyStruct;

typedef struct
{
  uint16_t   Value;
  uint32_t   Time;
  uint8_t    Flag;
  uint8_t    enable;
}_BuzzerCurrent;
extern _BuzzerCurrent   CheckCurrent;
extern _BuzzerCurrent   BuzzerAlarm;
extern _StaticCurrent   StaticCurrent;
extern _StaticCurrent   ButtomCurrent;
extern _StaticCurrent   LCDCurrent;
extern _StaticCurrent   LedCurrent;
extern _StaticCurrent   SpeedCurrent;
extern _StaticCurrent   Iol_TempCurrent;
extern _StaticCurrent   TFTCurrent;
extern _StaticCurrent   ElseCurrent;
extern _StaticCurrent   EndCurrent;
extern _StaticCurrent   TftCurrent;
extern _StaticCurrent   TripKeyCurrent;
extern _StaticCurrent   PressKeyStruct;


extern _StaticCurrent   SpeedOutPutNum;
extern _StaticCurrent   VolOutPutNum;
extern _StaticCurrent   HandBreakOutPutNum;
extern _StaticCurrent   DriverSeatBeltOutPutNum;
extern _StaticCurrent   DriverLow_BrakeOutPutNum;
extern uint16_t StaticCurrentNum;

extern _KeyStruct       KeyStruct;
extern _StaticCurrent   Back_lightCurrent;
extern _StaticCurrent   LuminosityCurrent;

extern _StaticCurrent   OKKeyCurrent;
extern _StaticCurrent   UPKeyCurrent;
extern _StaticCurrent   DOWNKeyCurrent;
extern _StaticCurrent   AirBagLampFail;
extern _StaticCurrent   MessageCounterNum;
extern _StaticCurrent   LONGOKKeyCurrent;


extern _StaticCurrent   HJ_OtherKeyCurrent;//OtherKey
//xxhh add end


#define UP_BOTTOM_Y              65
#define DOWN_TOP_Y               257
#define DOWN_BOTTOM_Y            319

#define UP_TOP_Y                 0
#define MID_TOP_Y                82 //66+16
#define MID_BOTTOM_Y             240//256-16
#define USM_HELP_TOP_Y           88 //66+16
#define USM_HELP_BOTTOM_Y        234//256-16
#define MID_USM_TOP_Y            116
#define MID_SERVICE_BOTTOM_Y     207
#define LEFT_X_START             0
#define RIGHT_X_END              239
#define MID_X_RIGHT              222
#define MINI_TOP_Y               65
#define MINI_BOTTOM_Y            135

#define SET_DRAW_INFO(x, y, pic, radius, alpha) (g_DrawInfo.x_point = x, g_DrawInfo.y_point = y, g_DrawInfo.VRAM = VRAM_BUF[ g_DrawInfo.VramSelectBuf ], g_DrawInfo.IMG = (uint8_t*)(pic), g_DrawInfo.Radius = radius, g_DrawInfo.Alpha = alpha)

#define SET_DISPLAY_STATIC_ITEM(n, pic, x, y, type) (DisplayItem.StaticPara.DisplayPic[n] = pic, DisplayItem.StaticPara.DisplayPicOffsetX[n] = x, DisplayItem.StaticPara.DisplayPicOffsetY[n] = y, DisplayItem.StaticPara.BrushType[n] = type)
#define SET_DISPLAY_STATIC_ITEM_WINDOW(n, left, right, top, bottom) (DisplayItem.StaticPara.DisplayWindow[n].WinLeftX = left, DisplayItem.StaticPara.DisplayWindow[n].WinRightX = right, DisplayItem.StaticPara.DisplayWindow[n].WinTopY = top, DisplayItem.StaticPara.DisplayWindow[n].WinBottomY = bottom)

#define SET_DISPLAY_DYNC_ITEM(n, pic, x, y, type)   (DisplayItem.DyncPara.DisplayPic[n] = pic,  DisplayItem.DyncPara.DisplayPicOffsetX[n] = x, DisplayItem.DyncPara.DisplayPicOffsetY[n] = y, DisplayItem.DyncPara.BrushType[n] = type)
#define SET_DISPLAY_DYNC_ITEM_P(n, pic, x, y, type) (DisplayItem->DyncPara.DisplayPic[n] = pic, DisplayItem->DyncPara.DisplayPicOffsetX[n] = x, DisplayItem->DyncPara.DisplayPicOffsetY[n] = y, DisplayItem->DyncPara.BrushType[n] = type)
#define SET_DISPLAY_DYNC_ITEM_WINDOW(n, left, right, top, bottom) (DisplayItem.DyncPara.DisplayWindow[n].WinLeftX = left, DisplayItem.DyncPara.DisplayWindow[n].WinRightX = right, DisplayItem.DyncPara.DisplayWindow[n].WinTopY = top, DisplayItem.DyncPara.DisplayWindow[n].WinBottomY = bottom)

#define SELECT_AREA 1
#define UNSELECT_AREA 0


#define DRAW_ICON                           0
#define DRAW_MIM_ALPHA_ICON                 1
#define DRAW_MIM_ALPHA_ICON_WINDOW          2
#define DRAW_CONST_MAX_ALPHA                3
#define DRAW_MAX_ALPHA_CHANNEL_ICON_WINDOW  4
#define DRAW_ALPHA_CHANNEL_ICON_WINDOW      5
#define DRAW_EDGE_MIN_ALPHA_ICON            6
#define DRAW_CENTER_SPREAD_ICON_WINDOW      7
#define DRAW_MIN_ALPHA_LUMIN_ICON           8
//#define DRAW_CONST_MAX_ALPHA                9
#define DRAW_LUMIN_ICOM_WINDOW              10
#define DRAW_MIN_ALPHA_LUMIN_ICON_WINDOW    11

typedef struct {
    int16_t WinLeftX;
    int16_t WinRightX;
    int16_t WinTopY;
    int16_t WinBottomY;
}DISP_WINDOW;

typedef struct {
    uint32_t pic;
    int16_t x;
    int16_t y;
    uint8_t Radius;
    uint8_t Alpha;
    DISP_WINDOW Window;
}DISPLAY_CENTER_PIC_PARA;
typedef struct {
    uint32_t DisplayPic[EACH_SURFACE_CONTAIN_PIC_NUM];
    int16_t DisplayPicOffsetX[EACH_SURFACE_CONTAIN_PIC_NUM];
    int16_t DisplayPicOffsetY[EACH_SURFACE_CONTAIN_PIC_NUM];
    DISP_WINDOW DisplayWindow[EACH_SURFACE_CONTAIN_PIC_NUM];
    uint8_t BrushType[EACH_SURFACE_CONTAIN_PIC_NUM];
}CENTER_AREA_DISPLAY_PARA;

#define SWITCH_EFFECT_NONE              0
#define SWITCH_EFFECT_IN_ALPHA          0x01
#define SWITCH_EFFECT_OUT_ALPHA         0x02
#define SWITCH_EFFECT_IN_OFFSET         0x04
#define SWITCH_EFFECT_OUT_OFFSET        0x08
#define SWITCH_EFFECT_RADIUS_OFFSET     0x10
#define SWITCH_EFFECT_ALPHA_OFFSET      (SWITCH_EFFECT_IN_ALPHA | SWITCH_EFFECT_OUT_ALPHA | SWITCH_EFFECT_IN_OFFSET | SWITCH_EFFECT_OUT_OFFSET)

enum {
    SWITCH_EFFECT_OFFSET_FADE_IN_RIGHT_TO_LEFT,
    SWITCH_EFFECT_OFFSET_FADE_IN_LEFT_TO_RIGHT,
    SWITCH_EFFECT_OFFSET_FADE_IN_UP_TO_DOWN,
    SWITCH_EFFECT_OFFSET_FADE_IN_DOWN_TO_UP,
};

enum {
    CENTER_AREA_DISPLAY_TYPE_NORMAL,
    CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK,
    CENTER_AREA_DISPLAY_TYPE_ASSIST_DAW,
    CENTER_AREA_DISPLAY_TYPE_USM,
    CENTER_AREA_DISPLAY_TYPE_EVENT,
};

#define TOP_GROUP_MENU_DISABLE          0
#define TOP_GROUP_MENU_ENABLE           1
#define TOP_GROUP_MENU_EVENTSAVE        2

typedef struct {
    uint16_t AliveDisplaytime;
    uint8_t DisplayType;
    uint8_t CurDisplayFlag;
    //uint8_t FadeInOutOffsetEffect;
    uint8_t FadeInOffsetEffect;
    uint8_t FadeOutOffsetEffect;
    //uint8_t FadeInOutAlphaEffect;
    uint8_t FadeInAlphaEffect;
    uint8_t FadeOutAlphaEffect;
    uint8_t FadeInRadiusEffect;
    int16_t FadeInXStep;
    int16_t FadeInYStep;
    int16_t FadeOutXStep;
    int16_t FadeOutYStep;
    CENTER_AREA_DISPLAY_PARA StaticPara;
    CENTER_AREA_DISPLAY_PARA DyncPara;
}CENTER_AREA_DISPLAY_ITEM;
extern CENTER_AREA_DISPLAY_ITEM CenterAreaDisplayList[SAME_TIME_DISPLAY_NUM];
extern uint8_t Flag_EventNeedSaveIsPlayed;
extern uint16_t PageIndicatorRemainTime;
extern uint16_t PressOkClrRemainTime;
extern uint16_t DispayDTE;
extern uint32_t TFT_BilnkTimerDelta;
extern uint32_t EventDoorCnts;
extern uint8_t EventDoor600msOn400msOffLevel;
extern uint8_t EventDoor600msOn400msOffEN;
extern uint32_t EventPasCnts;
extern uint8_t EventPas600msOn400msOffLevel;
extern uint8_t EventPas600msOn400msOffEN;
extern uint32_t EventServiceCnts;
extern uint8_t EventService600msOn400msOffLevel;
extern uint8_t EventService600msOn400msOffEN;
extern uint32_t LKACnts;
extern uint8_t LKA400msLevel;
extern uint8_t LKA400msEN;
extern uint32_t EventAnimationCnts;
extern uint8_t EventAnimationEn;
extern uint8_t EventAnimationLevel;
extern uint8_t Flag_EventFadeOutStart;
extern uint8_t EventWelcomeAnimationEn;
extern uint8_t EventWelcomeAnimationCnts;
extern uint8_t EventWelcomeAnimationLevel;
extern uint32_t GearPopupTimer1msCnts_Old;
extern uint16_t ADASUsmRemainTimer;

extern const uint32_t Num12List[];
extern const uint32_t Num19List[];
extern const uint32_t Num20List[];
extern const uint32_t Num24List[];
extern const uint32_t Number25List[];
extern const uint32_t Number25GrayList[];
extern const uint32_t Number36List[];
extern const uint32_t Num47List[];


extern uint8_t CHECK_CluPartNum1[][10];


extern int32_t CartoonLinearCalculate(int32_t InputRange, int32_t OutputRange, int32_t Input);
extern int32_t CartoonLogCalculate(int32_t InputRange, int32_t OutputRange, int32_t Input);
extern int32_t CartoonExpCalculate(int32_t InputRange, int32_t OutputRange, int32_t Input);
extern void DisplayNum(const uint32_t *NumList, int32_t Num, uint8_t StartPos, uint8_t Interval, int16_t x, int16_t y, uint8_t DisplayType, CENTER_AREA_DISPLAY_ITEM *DisplayItem);
extern uint8_t CheckAlreadyDisplayed(uint8_t DisplayType);
extern void SetCenterAreaSwitchEffect(uint8_t EffectValid, uint8_t OffsetEffect);
extern void UpdataCenterDisp(uint8_t n);
extern void GUI_DrawDispFunc(uint8_t func_num, uint16_t LeftX, uint16_t RightX, uint16_t WinTopY, uint16_t WinBottomY);
extern void SetCenterAreaDisplayList(CENTER_AREA_DISPLAY_ITEM *item, uint16_t DefaultStartTime);
extern uint8_t CheckCenterAreaSwitchEffect(void);

extern void UpdateCenterInfo(uint8_t uiErrType);
extern void UpdateCenterTripC(void);   
extern void UpdateClusterCheck(void); 
extern void UpdateConnectCluster(void);
extern void UpdateGetClusterPartNum(void);
extern void UpdateClusterError(void);    
extern void OneTransverterSixteen(uint8_t *buf);
extern void  NumberDisplay(uint16_t  data,uint8_t  n,uint8_t  point,uint16_t  x,uint16_t  x1,uint16_t  y,uint16_t  y1);
extern uint8_t App_CalDataLen(uint32_t data);
extern void UpdateSetQRcodeErr(void);
extern void UpdateSetQRcode(void);
extern void UpdateConfigingClu(void);
extern void UpdateConfigComplete(void);
extern void UpdateConfigErr(void);
extern void UpdatePleaseScan(void);
extern void UpdateConfigFail(void);
extern uint8_t Test_array[1000];

extern uint8_t CluPartNum[16];
extern uint8_t GearValid;
extern uint16_t DisPlayCurMotorSpds;
extern uint16_t DisPlayCurSpeeds;
extern uint16_t DisPlayCurPowers;
extern uint16_t DisPlayCurElectricitys;

extern uint8_t HJ_SWStateFlag;
extern uint8_t HJ_HWStateFlag;
extern uint8_t NUM1Flag;
extern uint8_t NUM2Flag;
extern uint8_t NUM3Flag;
extern uint8_t NUM4Flag;
extern uint8_t NUM5Flag;
extern uint8_t NUM6Flag;
extern uint8_t NUM7Flag;
extern uint8_t NUM8Flag;
extern uint8_t HJ_HJYBStateFlag;
extern uint8_t HJ_DAYFlag;
extern uint16_t FuelResTest;
extern uint8_t corenum[100];
extern uint8_t corenum1[100];
extern uint8_t corenum2[100];
enum 
{
    HJ_UDSStateSuc = 1,
    HJ_UDSStateFail
};
enum
{
   HW_UDSStateSuc = 1,
   HW_UDSStateFail
};
enum
{
   HJYB_UDSStateSuc = 1,
   HJYB_UDSStateFail
};
enum
{
   DAY_UDSStateSuc = 1,
   DAY_UDSStateFail
};
enum
{
   NUM1_UDSStateSuc = 1,
   NUM1_UDSStateFail
};

enum
{
   NUM2_UDSStateSuc = 1,
   NUM2_UDSStateFail
};

enum
{
   NUM3_UDSStateSuc = 1,
   NUM3_UDSStateFail
};

enum
{
   NUM4_UDSStateSuc = 1,
   NUM4_UDSStateFail
};

enum
{
   NUM5_UDSStateSuc = 1,
   NUM5_UDSStateFail
};

enum
{
   NUM6_UDSStateSuc = 1,
   NUM6_UDSStateFail
};

enum
{
   NUM7_UDSStateSuc = 1,
   NUM7_UDSStateFail
};
#endif