#ifndef R485_COMMUNICATION_MATRIX_H__
#define R485_COMMUNICATION_MATRIX_H__
#include "TYW_stdint.h"
#include "api_RS485.h"
#include "Barcode_Scanner.h"
#include "Check_Ctrl.h"
#include "Task.h"

#define RS485_RX_ID0XD0_DATA_LEN 27
#define RS485_RX_ID0XB1_DATA_LEN 86
#define RS485_RX_ID0XD1_DATA_LEN 139
#define RS485_RX_ID0XB2_DATA_LEN 76
#define RS485_RX_ID0XD2_DATA_LEN 36
#define RS485_RX_ID0XB3_DATA_LEN 89
#define RS485_RX_ID0XD3_DATA_LEN 26
#define RS485_RX_ID0XB6_DATA_LEN 86
#define RS485_RX_ID0XD6_DATA_LEN 111
#define RS485_RX_ID0XA4_DATA_LEN 1
#define RS485_RX_ID0XC4_DATA_LEN 4

#define RS485_RX_ID0XB4_DATA_LEN 75
#define RS485_RX_ID0XD4_DATA_LEN 14
typedef union
{
    uint8_t Msg[64];
    struct
    {
        /* Byte 0*/
        uint8_t  HardwareVer : 8;         /* 硬件版本号 */

        /* Byte 1 */
        uint8_t  ProducerIdNumber1 : 8;         /* 产商识别码 */

        /* Byte 2 */
        uint8_t  FixedValue : 8;         /* 固定值“-” */

        /* Byte 3 */
        uint8_t  ProductIdNumber1 : 8;         /* 产品识别码 */

        /* Byte 4 */
        uint8_t  MainSoftwareVer : 8;         /* 主软件版本号 */

        /* Byte 5 */
        uint8_t  SecondarySoftwareVer : 8;         /* 次软件版本号 */

        /* Byte 6 */
        uint8_t  ProductModel1 : 8;         /* 产品型号 */

        /* Byte 7 */
        uint8_t  CommunicationID : 8;         /* 通信识别码 */

        /* Byte 8 */
        uint8_t  BOOTSoftwareUnderlyingVer : 8;         /* BOOT软件底层版本 */

        /* Byte 9 */
        uint8_t  BOOTUpgradingProtocolVer : 8;         /* BOOT升级协议版本 */

        /* Byte 10 */
        uint8_t  SecCommunicationProtocolVer : 8;         /* 次通信协议版本 */

        /* Byte 11 */
        uint8_t  MainCommunicationProtocolVer : 8;         /* 主通信协议版本 */

        /* Byte 12 */
        uint8_t  IOTBuiltInSecVer : 8;         /* IOT内置模块次版本 */

        /* Byte 13 */
        uint8_t  IOTBuiltInMainVer : 8;         /* IOT内置模块主版本 */

        /* Byte 14 */
        uint8_t  BackupZoneSecSoftwareVer : 8;         /* 备份区次软件版本号 */

        /* Byte 15 */
        uint8_t  BackupZoneMainSoftwareVer : 8;         /* 备份区主软件版本号 */

        /* Byte 16 */
        uint8_t  ProductIdNumber2 : 8;         /* 产品识别码 */

        /* Byte 17 */
        uint8_t  ProducerIdNumber2 : 8;         /* 产商识别码 */

        /* Byte 18 */
        uint8_t  CustomerIdNumber : 8;         /* 客户识别码 */

        /* Byte 19 */
        uint8_t  ProductionMonth : 8;         /* 生产月份 */

        /* Byte 20 */
        uint8_t  ProductionYear_10Digits : 8;         /* 生产年份（十位） */

        /* Byte 21 */
        uint8_t  ProductionYear_SingleDigits : 8;         /* 生产年份（个位） */

        /* Byte 22  23 */
        uint8_t  OTAPartEncoding_L : 8;         /* OTA零部件编码 */
        uint8_t  OTAPartEncoding_H : 8;         /* OTA零部件编码 */

        /* Byte 24*/
        uint8_t  FlowCode5th : 8;         /* 流水码第5位 */

        /* Byte 25 */
        uint8_t  FlowCode4th : 8;         /* 流水码第4位 */

        /* Byte 26 */
        uint8_t  FlowCode3rd : 8;         /* 流水码第3位 */

        /* Byte 27 */
        uint8_t  FlowCode2nd : 8;         /* 流水码第2位 */

        /* Byte 28 */
        uint8_t  FlowCode1st : 8;         /* 流水码第1位 */

        /* Byte 29 */
        uint8_t  FlowCode0th : 8;         /* 流水码第0位 */

        /* Byte 30 */
        uint8_t : 8;         /* 预留 */

        /* Byte 31 */
        uint8_t : 3;         /* 预留 */
        uint8_t  BootRecordSignal : 5;         /* Boot记录信号 */

        /* Byte 32 */
        uint8_t  IOTMinimumOperatingVol : 8;         /* IOT最低工作电压 */

        /* Byte 33 */
        uint8_t  IOTHighestOperatingVoltage : 8;         /* IOT最高工作电压 */

        /* Byte 34 35 */
        uint8_t  IOTRatedOperatingCurrent_L : 8;         /* IOT额定工作电流 */
        uint8_t IOTRatedOperatingCurrent_H : 8;

        /* Byte 36 */
        uint8_t   IOTQuiescentOperatingCurrent : 8;         /* IOT静态工作电流 */

        /* Byte 37 */
        uint8_t  IOTMobileNetworkHighestMode : 3;         /* IOT移动网络最高模式 */
        uint8_t : 5;         /* 预留 */

        /* Byte 38 39*/
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */

        /* Byte 40 */
        uint8_t  IMEI_14th : 8;         /* IMEI第14位 */

        /* Byte 41 */
        uint8_t  IMEI_13_12th : 8;         /* IMEI第13、12位 */

        /* Byte 42 */
        uint8_t  IMEI_11_10th : 8;         /* IMEI第11、10位 */

        /* Byte 43 */
        uint8_t  IMEI_9_8th : 8;         /* IMEI第9、8位 */

        /* Byte 44 */
        uint8_t  IMEI_7_6th : 8;         /* IMEI第7、6位 */

        /* Byte 45 */
        uint8_t  IMEI_5_4th : 8;         /* IMEI第5、4位 */

        /* Byte 46 */
        uint8_t  IMEI_3_2th : 8;         /* IMEI第3、2位 */

        /* Byte 47 */
        uint8_t  IMEI_1_0th : 8;         /* IMEI第1、0位 */

        /* Byte 48 */
        uint8_t  ICCID_19_18th : 8;         /* ICCID第19、18位 */

        /* Byte 49 */
        uint8_t  ICCID_17_16th : 8;         /* ICCID第17、16位 */

        /* Byte 50 */
        uint8_t  ICCID_15_14th : 8;         /* ICCID第15、14位 */

        /* Byte 51 */
        uint8_t  ICCID_13_12th : 8;         /* ICCID第13、12位 */

        /* Byte 52 */
        uint8_t  ICCID_11_10th : 8;         /* ICCID第11、10位 */

        /* Byte 53 */
        uint8_t  ICCID_9_8th : 8;         /* ICCID第9、8位 */

        /* Byte 54 */
        uint8_t  ICCID_7_6th : 8;         /* ICCID第7、6位 */

        /* Byte 55 */
        uint8_t  ICCID_5_4th : 8;         /* ICCID第5、4位 */

        /* Byte 56 */
        uint8_t  ICCID_3_2th : 8;         /* ICCID第3、2位 */

        /* Byte 57 */
        uint8_t  ICCID_1_10th : 8;         /* ICCID第1、0位 */

        /* Byte 58 59 60 61 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */

        /* Byte 62 */
        uint8_t  VoiceprintWakeUpSignal : 2;         /* 仪表声纹唤醒信号 */
        uint8_t  AlarmStatus : 4;         /* 报警器报警状态 */
        uint8_t : 2;         /* 预留 */

        /* Byte 63 */
        uint8_t  BatteryType : 4;         /* 电池类型 */
        uint8_t  WholePowerMode : 4;         /* 整车电源模式 */

    }Sig;


}_ID0X40h_Data;


typedef union
{
    uint8_t Msg[64];
    struct
    {
        /* Byte 0*/
        uint8_t  HardwareVer : 8;         /* 硬件版本号 */

        /* Byte 1 */
        uint8_t  ProducerIdNumber3 : 8;         /* 产商识别码 */

        /* Byte 2 */
        uint8_t  FixedValue : 8;         /* 固定值“-” */

        /* Byte 3 */
        uint8_t  ProductIdNumber3 : 8;         /* 产品识别码 */

        /* Byte 4 */
        uint8_t  MCUSecSoftwareVer : 8;         /* 次MCU软件版本号 */

        /* Byte 5 */
        uint8_t  MCUMainSoftwareVer : 8;         /* 主MCU软件版本号 */

        /* Byte 6 */
        uint8_t  ProductModel2 : 8;         /* 产品型号 */

        /* Byte 7 */
        uint8_t  CommunicationID : 8;         /* 通信识别码 */

        /* Byte 8 */
        uint8_t  BOOTSoftwareUnderlyingVer : 8;         /* BOOT软件底层版本 */

        /* Byte 9 */
        uint8_t  BOOTUpgradingProtocolVer : 8;         /* BOOT升级协议版本 */

        /* Byte 10 */
        uint8_t  SecCommunicationProtocolVer : 8;         /* 次通信协议版本 */

        /* Byte 11 */
        uint8_t  MainCommunicationProtocolVer : 8;         /* 主通信协议版本 */

        /* Byte 12 */
        uint8_t  CPUSecSoftWareVer : 8;         /* 系统次软件版本号（CPU） */

        /* Byte 13 */
        uint8_t  CPUMainSoftWareVer : 8;         /* 系统主软件版本号（CPU） */

        /* Byte 14 */
        uint8_t  ProductModel3 : 8;         /* 产品型号 */

        /* Byte 15 */
        uint8_t  CommunicationIdfiers : 8;         /* 通信识别码 */

        /* Byte 16 */
        uint8_t  ProductIdNumber4 : 8;         /* 产品识别码 */

        /* Byte 17 */
        uint8_t  ProducerIdNumber4 : 8;         /* 产商识别码 */

        /* Byte 18 */
        uint8_t  CustomerIdNumber : 8;         /* 客户识别码 */

        /* Byte 19 */
        uint8_t  ProductionMonth : 8;         /* 生产月份 */

        /* Byte 20 */
        uint8_t  ProductionYear_10Digits : 8;         /* 生产年份（十位） */

        /* Byte 21 */
        uint8_t  ProductionYear_SingleDigits : 8;         /* 生产年份（个位） */

        /* Byte 22 23*/
        uint16_t : 16;         /* 预留 */

        /* Byte 24*/
        uint8_t  FlowCode5th : 8;         /* 流水码第5位 */

        /* Byte 25 */
        uint8_t  FlowCode4th : 8;         /* 流水码第4位 */

        /* Byte 26 */
        uint8_t  FlowCode3rd : 8;         /* 流水码第3位 */

        /* Byte 27 */
        uint8_t  FlowCode2nd : 8;         /* 流水码第2位 */

        /* Byte 28 */
        uint8_t  FlowCode1st : 8;         /* 流水码第1位 */

        /* Byte 29 */
        uint8_t  FlowCode0th : 8;         /* 流水码第0位 */

        /* Byte 30 */
        uint8_t  VendorCodeDigit_5th : 8;         /* 供应商代码第5位 */

        /* Byte 31 */
        uint8_t  VendorCodeDigit_4th : 8;         /* 供应商代码第4位 */

        /* Byte 32 */
        uint8_t  VendorCodeDigit_3rd : 8;         /* 供应商代码第3位 */

        /* Byte 33 */
        uint8_t  VendorCodeDigit_2nd : 8;         /* 供应商代码第2位 */

        /* Byte 34 */
        uint8_t  VendorCodeDigit_1st : 8;         /* 供应商代码第1位 */

        /* Byte 35 */
        uint8_t  GaugeType : 3;         /* 仪表类型 */
        uint8_t : 5;         /* 预留 */


        /* Byte 36 */
        uint8_t  BackupZoneSecSoftwareVer : 8;         /* 备份区次软件版本号 */

        /* Byte 37 */
        uint8_t  BackupZoneMainSoftwareVer : 8;         /* 备份区主软件版本号 */

        /* Byte 38 */
        uint8_t  OTAPartEncodingL : 8;         /* OTA零部件编码 */

        /* Byte 39 */
        uint8_t  OTAPartEncodingH : 8;         /* OTA零部件编码 */

        /* Byte 40 */
        uint8_t : 8;         /* 预留 */

        /* Byte 41 */
        uint8_t : 8;         /* 预留 */

        /* Byte 42 */
        uint8_t : 8;         /* 预留 */

        /* Byte 43 */
        uint8_t : 8;         /* 预留 */

        /* Byte 44 */
        uint8_t : 8;         /* 预留 */

        /* Byte 45 */
        uint8_t : 8;         /* 预留 */

        /* Byte 46 */
        uint8_t : 8;         /* 预留 */

        /* Byte 47 */
        uint8_t : 8;         /* 预留 */

        /* Byte 48 */
        uint8_t : 8;         /* 预留 */

        /* Byte 49 */
        uint8_t : 8;         /* 预留 */

        /* Byte 50 */
        uint8_t : 8;         /* 预留 */

        /* Byte 51 */
        uint8_t : 8;         /* 预留 */

        /* Byte 52 */
        uint8_t : 8;         /* 预留 */

        /* Byte 53 */
        uint8_t : 8;         /* 预留 */

        /* Byte 54 */
        uint8_t : 8;         /* 预留 */

        /* Byte 55 */
        uint8_t : 8;         /* 预留 */

        /* Byte 56 */
        uint8_t : 8;         /* 预留 */

        /* Byte 57 */
        uint8_t : 8;         /* 预留 */

        /* Byte 58 */
        uint8_t : 8;         /* 预留 */

        /* Byte 59 */
        uint8_t : 8;         /* 预留 */

        /* Byte 60 */
        uint8_t : 8;         /* 预留 */

        /* Byte 61 */
        uint8_t : 8;         /* 预留 */

        /* Byte 62 */
        uint8_t : 8;         /* 预留 */

        /* Byte 63 */
        uint8_t : 3;         /* 预留 */
        uint8_t  BootRecordSignal : 5;         /* boot记录信号 */
    }Sig;


}_ID0X48h_Data;


typedef union
{
    uint8_t Msg[64];
    struct
    {
        /* Byte 0*/
        uint8_t  VehicleStatus : 3;         /* 整车状态 */
        uint8_t  ElectricalAutoLoopOvervoltage : 1;         /* 电自主回路电压过压 */
        uint8_t  VehicleHighPressureState : 2;         /* 整车高压状态 */
        uint8_t  VehicleLowPressureState : 2;         /* 整车低压状态 */

        /* Byte 1 */
        uint8_t  VehicleACCState : 2;         /* 整车ACC1状态 */
        uint8_t  MechanicalKeyStatus : 2;         /* 机械钥匙状态 */
        uint8_t  LeftLightStatus : 2;         /* 左转向灯状态 */
        uint8_t  RightLightStatus : 2;         /* 右转向灯状态 */

        /* Byte 2 */
        uint8_t  BreakSwitchSignal : 2;         /* 刹车开关信号 */
        uint8_t  VehicleACC2State : 2;         /* 整车ACC2状态 */
        uint8_t  OTAModeCommands : 2;         /* OTA模式指令 */
        uint8_t  OTAUpGradeCommands : 2;         /* OTA升级指令 */

        /* Byte 3 */
        uint8_t  BrakeValue : 8;         /* 刹把值 */

        /* Byte 4 */
        uint8_t  HandleValue : 8;         /* 转把值 */

        /* Byte 5 */
        uint8_t  AlarmStatus : 4;         /* 报警器报警状态 */
        uint8_t  SensorAlarmStatus_IOTBuiltIn : 4;         /* 传感器报警状态（IOT内置） */

        /* Byte 6 */
        uint8_t  UpgradeResultFeedbackStatus : 2;         /* 仪表升级结果反馈指令接收状态 */
        uint8_t  VehiclePowerMode : 4;         /* 整车电源模式 */
        uint8_t  SupportSwitchSignalFeedback : 2;         /* 边撑开关信号反馈 */

        /* Byte 7 */
        uint8_t  OTARollbackInstructions : 4;         /* OTA回滚指令 */
        uint8_t  NavigationGuideDirections : 4;         /* 导航引导方向 */

        /* Byte 8 */
        uint8_t  BatteryWorkingState : 4;         /* 电池工作状态 */
        uint8_t  SubbatteryAccessState : 2;         /* 副电池接入状态 */
        uint8_t  VoiceprintWakeupSignal : 2;         /* 仪表声纹唤醒信号 */

        /* Byte 9 */
        uint8_t  ChargeState : 3;         /* 充电状态 */
        uint8_t  EleHeadlightFunctionSettings : 2;         /* 电子大灯功能设置 */
        uint8_t  ElectronicCushionLockStatus : 3;         /* 电子坐垫锁状态 */

        /* Byte 10 */
        uint8_t  VoltagePercentage : 8;         /* 母线电压百分比 */

        /* Byte 11 */
        uint8_t  CurrentPercemtage : 8;         /* 母线电流百分比 */

        /* Byte 12 13*/
        uint16_t  TotalBatteryVoltage : 16;         /* 总电池电压 */

        /* Byte 14 */
        uint16_t  TotalBatteryCurrent : 16;         /* 总电池电流 */

        /* Byte 16 */
        uint8_t  TotalBatterySOC : 8;         /* 主电池电量百分比SOC */

        /* Byte 17 */
        uint8_t  GuidesRemindDistances : 8;         /* 导航引导提醒距离 */

        /* Byte 18 */
        uint8_t  KnobLockStatus : 2;         /* 旋钮锁锁舌状态 */
        uint8_t  KnobLockResetStatus : 2;         /* 旋钮锁锁舌复位状态 */
        uint8_t  ElectronicCushionStatus : 2;         /* 电子坐垫状态 */
        uint8_t  AutoBacklightFunctionSetting : 2;         /* 自动背光功能设置 */

        /* Byte 19 */
        uint8_t  DIYBacklightSetting : 8;         /* 自定义背光亮度设置 */

        /* Byte 20 */
        uint8_t  DumpReminderFunctionSetting : 2;         /* 倾倒提醒功能设置指令 */
        uint8_t  CallMessageReminderSettingCommands : 2;         /* 来电、信息提醒设置指令 */
        uint8_t  VehicleShutdownEnablesSignal : 2;         /* 车辆关机倒计时使能信号 */
        uint8_t  RecuperationStatusFeedback : 2;         /* 能量回收功能状态反馈（滑行） */

        /* Byte 21 */
        uint8_t  SubbatterySOC : 8;         /* 副电池电量百分比SOC */

        /* Byte 22 23*/
        uint16_t  MainBatteryTotalVoltage : 16;         /* 主电池总电压 */

        /* Byte 24 */
        uint8_t  Place1 : 7;                           /* 占位 */
        // uint8_t  FaultCorrecting:1;                    /* 故障修复模式 */
        uint8_t  Place2 : 1;                           /* 占位 */

        /* Byte 25*/
        uint8_t  Place3 : 8;                          /* 占位 */

        /* Byte 26 */
        uint8_t  BusOvervoltageProtection : 2;         /* MCU告警状态：母线过压保护 */
        uint8_t  BusUndervoltageProtection : 2;         /* MCU告警状态：母线欠压保护 */
        uint8_t  BusOvercurrentProtection : 2;         /* MCU告警状态：母线过流保护 */
        uint8_t  BrakeLeverFault : 2;         /* MCU故障状态：刹把故障（线性刹把） */

        /* Byte 27 */
        uint8_t  PhaseLossFault : 2;         /* MCU故障状态：缺相故障 */
        uint8_t  MCUOverTempProtection : 2;         /* MCU告警状态：MCU过温保护 */
        uint8_t  MotorOvertempProtection : 2;         /* MCU告警状态：电机过温保护 */
        uint8_t  RotorLocked : 2;         /* MCU告警状态：堵转保护 */

        /* Byte 28 */
        uint8_t  BMS_0CommunicationStatus : 2;         /* 与BMS_0通讯状态 */
        uint8_t  MCUCommunicationStatus : 2;         /* 与MCU通讯状态 */
        uint8_t  ALMCommunicationStatus : 2;         /* 与ALM通讯状态 */
        uint8_t  ICMCommunicationStatus : 2;         /* 与ICM通讯状态 */

        /* Byte 29 */
        uint8_t  UUpBridgeArmMosFault : 2;         /* MCU故障状态：MOS故障（U相上桥臂MOS故障） */
        uint8_t  UDownBridgeArmMosFault : 2;         /* MCU故障状态：MOS故障（U相下桥臂MOS故障） */
        uint8_t  VUpBridgeArmMosFault : 2;         /* MCU故障状态：MOS故障（V相上桥臂MOS故障） */
        uint8_t  VDownBridgeArmMosFault : 2;         /* MCU故障状态：MOS故障（V相下桥臂MOS故障） */

        /* Byte 30 */
        uint8_t WUpBridgeArmMosFault : 2;         /* MCU故障状态：MOS故障（W相上桥臂MOS故障） */
        uint8_t WDownBridgeArmMosFault : 2;         /* MCU故障状态：MOS故障（W相下桥臂MOS故障） */
        uint8_t MCUFaultStateU_PhaseHallFault : 2;         /* MCU故障状态：霍尔故障（U相霍尔故障） */
        uint8_t MCUFaultStateV_PhaseHallFault : 2;         /* MCU故障状态：霍尔故障（V相霍尔故障） */

        /* Byte 31 */
        uint8_t MCUFaultStateW_PhaseHallFault : 2;         /* MCU故障状态：霍尔故障（W相霍尔故障） */
        uint8_t MCUFaultStatus_HandlebarFault : 2;         /* MCU故障状态：转把故障 */
        uint8_t MainNodeComponentType : 2;         /* 主节点元器件类型 */
        uint8_t  MetricImperialSetting : 2;         /* 公英制设置 */

        /* Byte 32 */
        uint8_t  HeadlampIndicator : 1;         /* 前照灯指示灯 */
        uint8_t  HighBeamIndicator : 1;         /* 远光灯指示灯 */
        uint8_t  PositionLightIndicator : 1;         /* 位置灯指示灯 */
        uint8_t  AutomaticHeadlightIndicator : 1;         /* 自动大灯指示灯 */
        uint8_t  LeftTurnSignal : 1;         /* 左转向灯 */
        uint8_t  RightTurnSignal : 1;         /* 右转向灯 */
        uint8_t  GaugeThemeSettings : 2;         /* 仪表主题设置 */

        /* Byte 33 */
        uint8_t  GSMStatusIndication : 1;         /* GSM状态指示 */
        uint8_t  GPSStatusIndication : 1;         /* GPS状态指示 */
        uint8_t  BLEStatusIndication : 1;         /* BLE状态指示 */
        uint8_t  CallIndication : 1;         /* 来电提醒指示 */
        uint8_t  MessageIndcation : 1;         /* 短信提醒指示 */
        uint8_t  DisplayModeSwitching : 3;         /* 仪表显示模式界面切换 */

        /* Byte 34 */
        uint8_t  BacklightLevelSetting : 3;         /* 背光亮度等级设置 */
        uint8_t  SmartKeyStatusIndication : 1;         /* SmartKey状态指示 */
        uint8_t  WrenchSymbolIndicatior : 1;         /* 扳手符号-故障指示灯 */
        uint8_t  TriangleSymbolIndicatior : 1;         /* 三角符号-警告指示灯 */
        uint8_t  EngineSymbolIndicatior : 1;         /* 引擎符号-MCU故障指示灯 */
        uint8_t  MotorSymbolIndicatior : 1;         /* 电机符号-电机故障指示灯 */

        /* Byte 35 */
        uint8_t  SpeedGear : 3;         /* 车速档位 */
        uint8_t  CruiseMode : 1;         /* 巡航模式 */
        uint8_t  CartMode : 1;         /* 推车模式 */
        uint8_t  ReverseMode : 1;         /* 倒车模式 */
        uint8_t  SlopePattern : 1;         /* 坡行模式 */
        uint8_t  Low_speedCruiseMode : 1;         /* 低速巡航模式 */


        /* Byte 36 37*/
        uint16_t  BCMRemainingMileage : 16;         /* 剩余里程当前值（BCM计数） */

        /* Byte 38 */
        uint8_t  ExternalKeyInputs : 3;         /* 外部按键输入 */
        uint8_t  HandlebarFaultIndicator : 1;         /* 转把符号-转把故障指示灯 */
        uint8_t  ParkingGear : 2;         /* 驻车档位 */
        uint8_t  CushionSensorStatus : 2;         /* 坐垫传感器状态 */

        /* Byte 39 */
        uint8_t  IOTRealTime_Year : 8;         /* IOT实时时间-年 */

        /* Byte 40 */
        uint8_t  IOTRealTime_Month : 8;         /* IOT实时时间-月 */

        /* Byte 41 */
        uint8_t  IOTRealTime_Day : 8;         /* IOT实时时间-日 */

        /* Byte 42 */
        uint8_t  IOTRealTime_Hour : 8;         /* IOT实时时间-时 */

        /* Byte 43 */
        uint8_t  IOTRealTime_Minute : 8;         /* IOT实时时间-分 */

        /* Byte 44 */
        uint8_t  IOTRealTime_Second : 8;         /* IOT实时时间-秒 */

        /* Byte 45 */
        uint8_t  DisableSpeedLimitModeFeedback : 2;         /* 解除限速模式反馈 */
        uint8_t  BatteryVoltageLevel : 4;         /* 电池电压等级 */
        uint8_t  TRIPMileageReset : 2;         /* TRIP里程清零 */

        /* Byte 46 47 */
        uint16_t  ICMCalculatesVehicleSpeed : 16;       /* 车速霍尔值：200ms内Hall计数值（ICM计算车速） */

        /* Byte 48 49 */
        uint16_t  BCMCalculatedSpeed : 16;         /* 车速当前值（BCM计算车速）注：本信号与“车速霍尔值”复用 */
        /* Byte 50 51*/
        uint16_t  BCMTripValue : 16;         /* TRIP当前值（BCM计数） */
        /* Byte 52 53 54 55 */
        uint32_t HallTripValue : 32;     /* 里程小计霍尔值：ACC开启后Hall累计计数值*/

        /* Byte  56 57 58 59*/
        uint32_t  ODOValue : 32;         /* ODO当前值（BCM计算ODO）注：本信号与“里程小计霍尔值”复用 */

        /* Byte 60 */
        uint8_t  ODOMileageReset : 2;         /* ODO里程清零 */
        uint8_t  TempUnitSettingCommand : 2;         /* 温度单位设置指令 */
        uint8_t  RemainingMileageDisplaySettings : 2;         /* 剩余里程显示设置 */
        uint8_t  TPower : 2;         /* T动力 */

        /* Byte 61 */
        uint8_t  VehicleOperationStatusFeedback : 3;         /* 整车操作状态反馈 */
        uint8_t  RampParkedState : 2;         /* 坡道驻停状态 */
        uint8_t  SlopeDescentFunctionStatus : 2;         /* 陡坡缓降功能状态 */
        uint8_t  TCSActivation : 1;         /* TCS激活 */

        /* Byte 62 */
        uint8_t  ElecTapLockStatus : 2;         /* 电子龙头锁状态 */
        uint8_t  ElecFaucetLockDeadboltFailure : 2;         /* 电子龙头锁锁舌故障 */
        uint8_t  ElecFaucetLockMotorFailure : 2;         /* 电子龙头锁电机故障 */
        uint8_t  TCSFunctionalStatus : 2;         /* TCS功能状态 */

        /* Byte 63 */
        uint8_t  BatteryHandshakeFeedback : 2;         /* 电池互认握手反馈 */
        uint8_t  Week : 3;         /* 星期 */
        uint8_t  CatapultMode : 2;         /* 弹射模式 */
        uint8_t  SteepHillDescentEnable : 1;         /* 陡坡缓降激活 */
    }Sig;


}_ID0X41h_Data;


typedef union
{
    uint8_t Msg[64];
    struct
    {
        /* Byte 0*/
        uint8_t  PhotosensitiveElementOutput : 3;         /* 光敏元件输出 */
        uint8_t  KeyOutput : 3;         /* 按键输出 */
        uint8_t  OTACommandStatusFeedback : 2;         /* OTA模式指令执行状态反馈 */

        /* Byte 1 */
        uint8_t  BacklightLevelStatusFeedback : 3;         /* 背光亮度等级状态反馈 */
        uint8_t  GaugeTopicStatusFeedback : 2;         /* 仪表主题状态反馈 */
        uint8_t  EleCushionSwitchCommand : 2;         /* 电动坐垫开关指令（语音控制） */
        uint8_t  TripResetSoftSwitch : 1;         /* 小计里程清零指令—软开关 */

        /* Byte 2 */
        uint8_t  OTAUpdateResult : 2;         /* OTA升级结果反馈 */
        uint8_t  UnlockCommand : 2;         /* 解锁指令（声纹） */
        uint8_t  LeftTurnSignalCommand : 2;         /* 左转向灯指令（语音控制） */
        uint8_t  RightTurnSignalCommand : 2;         /* 右转向灯指令（语音控制） */

        /* Byte 3 */
        uint8_t  WarningCommand : 2;         /* 危险报警灯指令（语音控制） */
        uint8_t  HighBeamCommand : 2;         /* 远光灯指令（语音控制） */
        uint8_t  SeatCommand : 1;         /* 坐桶锁指令（语音控制） */
        uint8_t  ABSstatus : 1;         /* ABS激活状态 */
        uint8_t  OTARollbackCommand : 2;         /* OTA回滚指令执行结果 */

        /* Byte 4 */
        uint8_t  CallMessageReminderFeedback : 2;         /* 来电/信息提醒功能状态反馈 */
        uint8_t  DumpReminderStatusFeedback : 2;         /* 倾倒提醒功能状态反馈 */
        uint8_t  DumpCategory : 2;         /* 倾倒类别 */
        uint8_t  AutoBacklightFeedback : 2;         /* 自动背光功能状态反馈 */

        /* Byte 5 */
        uint8_t  ActualBacklightFeedback : 8;         /* 实际背光亮度状态反馈 */

        /* Byte 6 */
        uint8_t  ABSSelfcheckStatus : 2;         /* ABS自检状态 */
        uint8_t  ABSdefault : 1;         /* ABS故障 */
        uint8_t  ABSOLStatus : 1;         /* ABS在线状态 */
        uint8_t : 4;         /* 预留 */

        /* Byte 7 */
        uint8_t  MetricImperialStatus : 2;         /* 公英制状态 */
        uint8_t  ODOResetstatus : 3;         /* 总计里程清零结果状态反馈 */
        uint8_t : 3;         /* 预留 */

        /* Byte 8 9 */
        uint16_t  VehicleSpeedFadeback : 16;         /* 车速当前值反馈（ICM计算） */

        /* Byte 10 11 */
        uint16_t  TripCurrentValueFeedback : 16;         /* TRIP当前值反馈（ICM计算） */

        /* Byte 12  13 14 15*/
        uint32_t  ODOCurrentValueFeedback : 32;         /* ODO当前值反馈（ICM计算） */

        /* Byte 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31*/
        uint64_t : 64;         /* 预留 */
        uint64_t : 64;         /* 预留 */

        /* Byte 32 */
        uint8_t  Faultybacklight : 2;         /* 背光灯故障 */
        uint8_t  EEPROMdefault : 2;         /* EEPROM故障 */
        uint8_t  SunlightSensordefault : 2;         /* 阳光传感器故障 */
        uint8_t  LeftTurnDefault : 2;         /* 左转向灯故障 */

        /* Byte 33 */
        uint8_t  RightTurnDefault : 2;         /* 右转向灯故障 */
        uint8_t  Autoheadlightstatus : 2;         /* 自动大灯功能状态反馈 */
        uint8_t  KnobLockStatus : 2;         /* 旋钮锁舌状态 */
        uint8_t  KnobLockResetStatus : 2;         /* 旋钮锁舌复位状态 */

        /* Byte 34 */
        uint8_t  UpButtonStatus : 1;         /* 上按键状态 */
        uint8_t  DownButtonStatus : 1;         /* 下按键状态 */
        uint8_t  TempUnitStatus : 2;         /* 温度单位状态反馈 */
        uint8_t  RemainingMileagefeedback : 2;     /* 剩余里程显示状态反馈 */
        uint8_t : 2;         /* 预留 */

        /* Byte 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49*/
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        /*50-51*/
        uint16_t   Trip : 16;         /* 预留 */
        /*52-55*/
        uint32_t   ODO : 32;         /* 预留 */
        /*56-59*/
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        /*60-63*/
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */



    }Sig;


}_ID0X49h_Data;


typedef union
{
    uint8_t Msg[64];
    struct
    {
        /* Byte 0*/
        uint8_t  VINCodeLength : 8;         /* Vin号长度 */

        /* Byte 1 */
        uint8_t  VINCode_1st : 8;         /* Vin号1位 */

        /* Byte 2 */
        uint8_t  VINCode_2nd : 8;         /* Vin号2位 */

        /* Byte 3 */
        uint8_t  VINCode_3rd : 8;         /* Vin号3位 */

        /* Byte 4 */
        uint8_t  VINCode_4th : 8;         /* Vin号4位 */

        /* Byte 5 */
        uint8_t  VINCode_5th : 8;         /* Vin号5位 */

        /* Byte 6 */
        uint8_t  VINCode_6th : 8;         /* Vin号6位 */

        /* Byte 7 */
        uint8_t  VINCode_7th : 8;         /* Vin号7位 */

        /* Byte 8 */
        uint8_t  VINCode_8th : 8;         /* Vin号8位 */

        /* Byte 9 */
        uint8_t  VINCode_9th : 8;         /* Vin号9位 */

        /* Byte 10 */
        uint8_t  VINCode_10th : 8;         /* Vin号10位 */

        /* Byte 11 */
        uint8_t  VINCode_11th : 8;         /* Vin号11位 */

        /* Byte 12 */
        uint8_t  VINCode_12th : 8;         /* Vin号12 */

        /* Byte 13 */
        uint8_t  VINCode_13th : 8;         /* Vin号13 */

        /* Byte 14 */
        uint8_t  VINCode_14th : 8;         /* Vin号14 */

        /* Byte 15 */
        uint8_t  VINCode_15th : 8;         /* Vin号15 */

        /* Byte 16 */
        uint8_t  VINCode_16th : 8;         /* Vin号16 */

        /* Byte 17 */
        uint8_t  VINCode_17th : 8;         /* Vin号17 */

        /* Byte 18 */
        uint8_t   SteerPrioritySwitch : 2;         /*  转向优先开关设置指令 */
        uint8_t : 6;         /* 预留  */

        /* Byte 19 */
        uint8_t   WarningWeather : 8;         /*  预警天气类型 */

        /* Byte 20 */
        uint8_t   CurrentWeatherType : 8;         /*  当前天气类型 */

        /* Byte 21 */
        uint8_t   CurrentWeatherTemp : 8;         /*  当前天气温度 */

        /* Byte 22   */
        uint8_t  WevereWeatherType : 8;         /*  恶劣天气类型 */

        /* Byte 23*/
        uint8_t   WeatherWarningLevel : 3;         /*  天气预警等级 */
        uint8_t  WeverWeatherTime : 5;         /*  恶劣天气发生时间 */

        /* Byte 24 */
        uint8_t  PasswordUnlockCommand : 2;         /*  仪表密码解锁唤醒指令 */
        uint8_t  PasswordAuthResult : 2;         /*  密码认证结果 */
        uint8_t  PasswordCanbeEnter : 3;         /*  密码可输入剩余次数 */
        uint8_t  FailoverMode : 1;         /*   故障修复模式 */

        /* Byte 25 - 26*/
        uint8_t  TimeRemainingChargeL : 8;         /*  总电池电量剩余充满时间L     与通信协议出入 */
        uint8_t  TimeRemainingChargeH : 8;         /*  总电池电量剩余充满时间H     与通信协议出入 */

        /* Byte 27*/
        uint8_t  FaultCorrecting : 2;         /*  故障修复模式 */
        uint8_t  SupportFunction : 2;         /*  边撑功能设置反馈 */
        uint8_t  SeatFunction : 2;         /*  座垫感应功能设置反馈 */
        uint8_t : 2;         /*  预留 */

        /* Byte 28-63*/
        uint8_t : 8;         /* 28预留 */
        /* Byte 29*/
        uint8_t   TotalBatteryCurrent : 8;         /* 母线电流 */
        /* Byte 30-35*/

        uint8_t   BLE_MAC01 : 8;         /* BLEMAC地址 */
        uint8_t   BLE_MAC02 : 8;         /* BLEMAC地址 */
        uint8_t   BLE_MAC03 : 8;         /* BLEMAC地址 */
        uint8_t   BLE_MAC04 : 8;         /* BLEMAC地址 */
        uint8_t   BLE_MAC05 : 8;         /* BLEMAC地址 */
        uint8_t   BLE_MAC06 : 8;         /* BLEMAC地址 */

        /* Byte 36*/
        uint8_t : 5;         /* 36预留 */
        uint8_t   SuperTPower : 2;         /* 超级T动力状态 */
        uint8_t : 1;         /* 36预留 */

        uint8_t : 8;         /* 37预留 */

        uint8_t nenglainhuishou :4;         /* 38预留 */
        uint8_t   Shoppingmode : 2;  /*导购模式*/
        uint8_t : 2;          /* 38预留 */





    uint8_t:8;         /* 39预留 */
        uint8_t : 8;         /* 40预留 */
        uint8_t : 8;         /* 41预留 */
        uint8_t : 8;         /* 42预留 */
        uint8_t : 8;         /* 43预留 */
        uint8_t : 8;         /* 44预留 */
        uint8_t : 8;         /* 45预留 */
        uint8_t : 8;         /* 46预留 */
        uint8_t : 8;         /* 47预留 */
        uint8_t : 8;         /* 48预留 */
        uint8_t : 8;         /* 49预留 */
        uint8_t EggAnimation : 8;         /* 50预留 */
        uint8_t : 8;         /* 51预留 */
        uint8_t : 8;         /* 52预留 */
        uint8_t : 8;         /* 53预留 */
        uint8_t : 8;         /* 54预留 */
        uint8_t : 8;         /* 55预留 */
        uint8_t : 8;         /* 56预留 */
        uint8_t : 8;         /* 57预留 */
        uint8_t : 8;         /* 58预留 */
        uint8_t : 8;         /* 59预留 */
        /* Byte 60*/
        uint8_t : 6;         /* 60预留 */
        uint8_t   TPower : 2;         /* T动力模式 */
        uint8_t : 8;         /* 61预留 */
        uint8_t : 8;         /* 62预留 */
        uint8_t : 8;         /* 63预留 */


    }Sig;


}_ID0X42h_Data;


typedef union
{
    uint8_t Msg[64];
    struct
    {
        /* Byte 0*/
        uint8_t   ReceiveVINFeedback : 2;                /*  接收VIN状态反馈 */
        uint8_t   SteeringPrioritySwitchFeedback : 2;    /*  转向优先开关设置反馈 */
        uint8_t   SeatCushionInduction : 2;               /*  座垫感应功能设置指令 */
        uint8_t   SeatPressure : 2;                      /*  座垫开机功能设置指令 */

        /* Byte 1 2*/
        uint16_t  UserPasswordL : 8;         /*  用户输入密码值L */
        uint16_t  UserPasswordH : 8;         /*  用户输入密码值H */

        /* Byte 3 */
        uint8_t : 8;         /* 3预留 */
        /* Byte 4 */
        uint8_t   NavigationType : 2;         /* 简易导航仪表类型 */
        uint8_t : 6;         /* 4预留 */
        /* Byte 5-63 */
        uint8_t : 8;         /* 5预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */
        uint8_t : 8;         /* 预留 */


    }Sig;


}_ID0X4Ah_Data;


typedef union
{
    uint8_t Msg[64];
    struct
    {
        uint8_t : 8;         /* 0预留 */

        uint8_t   MaterialCode15 : 8;         /* 1物料编码第15位（改定代码） */
        uint8_t   MaterialCode14 : 8;         /* 2物料编码第14位（变更代码） */
        uint8_t   MaterialCode13 : 8;         /* 3物料编码第13位（种别代码） */
        uint8_t   MaterialCode12 : 8;         /* 4物料编码第12位（变更代码） */
        uint8_t   MaterialCode11 : 8;         /* 5物料编码第11位 */
        uint8_t   MaterialCode10 : 8;         /* 6物料编码第10位（开发代码） */
        uint8_t   MaterialCode09 : 8;         /* 7物料编码第9位（开发代码） */
        uint8_t   MaterialCode08 : 8;         /* 8物料编码第8位（开发代码） */
        uint8_t   MaterialCode07 : 8;         /* 9物料编码第7位（开发代码） */
        uint8_t   MaterialCode06 : 8;         /* 10物料编码第6位 */
        uint8_t   MaterialCode05 : 8;         /* 11物料编码第5位（主码） */
        uint8_t   MaterialCode04 : 8;         /* 12物料编码第4位（主码） */
        uint8_t   MaterialCode03 : 8;         /* 13物料编码第3位（主码） */
        uint8_t   MaterialCode02 : 8;         /* 14物料编码第2位（主码） */
        uint8_t   MaterialCode01 : 8;         /* 15物料编码第1位（主码） */
        /* Byte 16-24 */
        uint8_t : 8;         /* 16预留 */
        uint8_t : 8;         /* 17预留 */
        uint8_t : 8;         /* 18预留 */
        uint8_t : 8;         /* 19预留 */
        uint8_t : 8;         /* 20预留 */
        uint8_t : 8;         /* 21预留 */
        uint8_t : 8;         /* 22预留 */
        uint8_t : 8;         /* 23预留 */
        uint8_t : 8;         /* 24预留 */
        /* Byte 25-29 */
        uint8_t   SupplierCode05 : 8;         /* 25供应商编码第5位 */
        uint8_t   SupplierCode04 : 8;         /* 26供应商编码第4位 */
        uint8_t   SupplierCode03 : 8;         /* 27供应商编码第3位 */
        uint8_t   SupplierCode02 : 8;         /* 28供应商编码第2位 */
        uint8_t   SupplierCode01 : 8;         /* 29供应商编码第1位 */
        /* Byte 30-32 */
        uint8_t : 8;         /* 30预留 */
        uint8_t : 8;         /* 31预留 */
        uint8_t : 8;         /* 32预留 */
        /* Byte 33-47 */
        uint8_t BatchNumber08    : 8;         /* 33批次号第8位 */
        uint8_t BatchNumber07    : 8;         /* 34批次号第7位 */
        uint8_t BatchNumber06    : 8;         /* 35批次号第6位 */
        uint8_t BatchNumber05    : 8;         /* 36批次号第5位 */
        uint8_t BatchNumber04    : 8;         /* 37批次号第4位 */
        uint8_t BatchNumber03    : 8;         /* 38批次号第3位 */
        uint8_t BatchNumber02    : 8;         /* 39批次号第2位 */
        uint8_t BatchNumber01    : 8;         /* 40批次号第1位 */
        uint8_t SerialNumer06    : 8;         /* 41流水号第6位 */
        uint8_t SerialNumer05    : 8;         /* 42流水号第5位 */
        uint8_t SerialNumer04    : 8;         /* 43流水号第4位 */
        uint8_t SerialNumer03    : 8;         /* 44流水号第3位 */
        uint8_t SerialNumer02    : 8;         /* 45流水号第2位 */
        uint8_t SerialNumer01    : 8;         /* 46流水号第1位 */
        uint8_t : 8;         /* 47预留 */
        /* Byte 48-49 */
        uint8_t : 8;         /* 48预留 */
        uint8_t : 8;         /* 49预留 */
        /* Byte 50-51 */
        uint8_t  ESP321 :8;         /* 50预留 */
        uint8_t  ESP322: 8;         /* 51预留 */
        /* Byte 52-53 */
        uint8_t : 8;         /* 52预留 */
        uint8_t : 8;         /* 53预留 */
        /* Byte 54-55 */
        uint8_t   G0311 :8;         /* 54预留 */
        uint8_t   G0312 :8;         /* 55预留 */
        /* Byte 56-57 */
        uint8_t : 8;         /* 56预留 */
        uint8_t : 8;         /* 57预留 */
        /* Byte 58-59 */
        uint8_t : 8;         /* 58预留 */
        uint8_t : 8;         /* 59预留 */
        /* Byte 60-61 */
        uint8_t : 8;         /* 60预留 */
        uint8_t : 8;         /* 61预留 */
        /* Byte 62-63 */
        uint8_t : 8;         /* 62预留 */
        uint8_t : 8;         /* 63预留 */


    }Sig;


}_ID0X4Dh_Data;

typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XB4_DATA_LEN];

    struct
    {
        uint8_t Hardware_Version            : 8; //硬件版本号
        uint8_t Manufacturer_Identifier     : 8; //产商识别码
        uint8_t Fixed_Value                 : 8; //固定值"-"
        uint8_t Product_Identifier          : 8; //产品识别码
        uint8_t Software_Version2           : 8; //次软件版本号
        uint8_t Software_Version1           : 8; //主软件版本号
        uint8_t Product_Model               : 8; //产品型号
        uint8_t Communication_Identifier    : 8; //通信识别码

        uint8_t Boot_Version                : 8; //BOOT底层软件版本
        uint8_t BootUpdate_Version          : 8; //BOOT升级协议版本
        uint8_t Communication_rotocol2      : 8; //次通信协议版本
        uint8_t Communication_rotocol1      : 8; //主通信协议版本
        uint8_t BackSoftware_Version2       : 8; //备份区次软件版本号
        uint8_t BackSoftware_Version1       : 8; //备份区主软件版本号
        uint8_t OTA_component_Coding_L      : 8; //OTA零部件编码_L
        uint8_t OTA_component_Coding_H      : 8; //OTA零部件编码_H

        uint8_t BOOT_Record_Signal          : 4; //BOOT记录信号
        uint8_t                             : 4;
        uint8_t                             : 8; //物料编码专用预留位_L
        uint8_t                             : 8; //物料编码专用预留位_H
        uint8_t MaterialCode15              : 8; //物料编码第15位(改定代码)
        uint8_t MaterialCode14              : 8; //物料编码第14位(变更代码)
        uint8_t MaterialCode13              : 8; //物料编码第13位(种别代码)
        uint8_t MaterialCode12              : 8; //物料编码第12位(种别代码)
        uint8_t MaterialCode11              : 8; //物料编码第11位 "-"
        uint8_t MaterialCode10              : 8; //物料编码第10位(开发代码)
        uint8_t MaterialCode09              : 8; //物料编码第9位(开发代码)
        uint8_t MaterialCode08              : 8; //物料编码第8位(开发代码)
        uint8_t MaterialCode07              : 8; //物料编码第7位(开发代码)
        uint8_t MaterialCode06              : 8; //物料编码第6位 "-"
        uint8_t MaterialCode05              : 8; //物料编码第5位(主代码)
        uint8_t MaterialCode04              : 8; //物料编码第4位(主代码)
        uint8_t MaterialCode03              : 8; //物料编码第3位(主代码)
        uint8_t MaterialCode02              : 8; //物料编码第2位(主代码)
        uint8_t MaterialCode01              : 8; //物料编码第1位(主代码)

        uint8_t                             : 8; //供应商编码专用预留位
        uint8_t                             : 8; //供应商编码专用预留位

        uint8_t SupplierCode05              : 8; //供应商编码第5位
        uint8_t SupplierCode04              : 8; //供应商编码第4位
        uint8_t SupplierCode03              : 8; //供应商编码第3位
        uint8_t SupplierCode02              : 8; //供应商编码第2位
        uint8_t SupplierCode01              : 8; //供应商编码第1位

        uint8_t                             : 8; //批次号专用预留位
        uint8_t                             : 8; //批次号专用预留位

        uint8_t BatchNumber08               : 8; //批次号第8位
        uint8_t BatchNumber07               : 8; //批次号第7位
        uint8_t BatchNumber06               : 8; //批次号第6位
        uint8_t BatchNumber05               : 8; //批次号第5位
        uint8_t BatchNumber04               : 8; //批次号第4位
        uint8_t BatchNumber03               : 8; //批次号第3位
        uint8_t BatchNumber02               : 8; //批次号第2位
        uint8_t BatchNumber01               : 8; //批次号第1位

        uint8_t SerialNumer06               : 8; //流水号第6位
        uint8_t SerialNumer05               : 8; //流水号第5位
        uint8_t SerialNumer04               : 8; //流水号第4位
        uint8_t SerialNumer03               : 8; //流水号第3位
        uint8_t SerialNumer02               : 8; //流水号第2位
        uint8_t SerialNumer01               : 8; //流水号第1位

        uint8_t                             : 8;
        uint8_t                             : 8;

        uint8_t                             : 8; //标定固件次版本信息
        uint8_t                             : 8; //标定固件主版本信息
        uint8_t ESP32_APP_SV                : 8; //系统固件次版本信息
        uint8_t ESP32_APP_PV                : 8; //系统固件主版本信息
        uint8_t                             : 8; //应用固件次版本信息
        uint8_t                             : 8; //应用固件主版本信息
        uint8_t G031_APP_SV                 : 8; //从单片机固件次版本信息
        uint8_t G031_APP_PV                 : 8; //从单片机固件主版本信息
        uint8_t                             : 8; //GPS固件次版本信息
        uint8_t                             : 8; //GPS固件主版本信息
        uint8_t Picture_SV                  : 8; //图片次版本信息
        uint8_t Picture_PV                  : 8; //图片主版本信息
        uint8_t Animation_SV                : 8; //开机动画次版本信息
        uint8_t Animation_PV                : 8; //开机动画主版本信息
        uint8_t Font_SV                     : 8; //字体库次版本信息
        uint8_t Font_PV                     : 8; //字体库主版本信息

    }Sig;
} _ID0XB4h_Data;

typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XD4_DATA_LEN];

    struct
    {
        uint16_t BCMCalculatedSpeed : 16; // 车速当前值_L

        uint16_t BCMTripValue : 16; // TRIP当前值

        uint32_t ODOValue : 32; // ODO当前值

        uint8_t NavigationType : 2;       // 导航仪表类型
        uint8_t MetricImperialStatus : 2; // 公英制状态
        uint8_t : 2;                      // 前位置灯状态
        uint8_t AbnormalSpeed: 2;         // 整车速度异常状态

        uint8_t Faultybacklight : 2;       // 背光灯故障
        uint8_t EEPROMdefault : 2;         // EEPROM故障
        uint8_t SunlightSensordefault : 2; // 阳光传感器故障
        uint8_t LeftTurnDefault : 2;       // 左转向灯故障

        uint8_t RightTurnDefault : 2;         // 右转向灯故障
        uint8_t GaugeTopicStatusFeedback : 2; // 仪表主题状态反馈
        uint8_t RemainingMileagefeedback : 2; // 剩余里程显示功能设置反馈
        uint8_t Autoheadlightstatus : 2;      // 自动大灯功能设置反馈

        uint8_t : 2;             // 车速挡位（预留暂时不用）
        uint8_t ABSOLStatus : 1; // ABS在线状态
        uint8_t : 5;

        uint8_t UserPasswordL : 8; // 用户输入密码值_L
        uint8_t UserPasswordH : 8; // 用户输入密码值_H

    }Sig;
} _ID0XD4h_Data;


//接收

typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XA4_DATA_LEN];

    struct
    {
        uint8_t   Invalid_characters : 8;
    }Sig;
} _ID0XA4h_Data;
typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XD0_DATA_LEN];

    struct
    {
        /*Byte0 - Byte7*/
        uint8_t IOT_RealTime_Year           : 8; //IOT实时时间 - 年
        uint8_t IOT_RealTime_Month          : 8; //IOT实时时间
        uint8_t IOT_RealTime_Day            : 8; //IOT实时时间
        uint8_t IOT_RealTime_Hour           : 8; //IOT实时时间
        uint8_t IOT_RealTime_Minute         : 8; //IOT实时时间
        uint8_t IOT_RealTime_Second         : 8; //IOT实时时间
        uint8_t IOT_RealTime_Week           : 3; //IOT实时时间 - 周
        uint8_t                             : 2;
        uint8_t GPS_State                   : 1; //GPS状态指示
        uint8_t GSM_State                   : 1; //GSM状态指示
        uint8_t                             : 1;
        uint8_t                             : 8;

        /*Byte8 - Byte15*/
        uint8_t                             : 8;
        uint8_t RemoteControlInstruction    : 4; //远程控制指令
        uint8_t                             : 4;
        uint8_t UpdateInformation           : 8; //固件升级数量信息
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;

        /*Byte16 - Byte23*/
        uint8_t                             : 8;
        uint8_t EstimateRemainingMileage_L  : 8; //预估剩余里程当前值 - 低字节
        uint8_t EstimateRemainingMileage_H  : 8; //预估剩余里程当前值 - 高字节
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t ComponentType_RS485         : 2; //主节点元器件类型 - RS485
        uint8_t ComponentType_K             : 2; //主节点元器件类型 - K线
        uint8_t EggAnimation                : 2;  /*开机动画彩蛋状态*/
        uint8_t                             : 2;
        uint8_t WarningWeatherType          : 8; //预警天气类型
        uint8_t CurrentWeatherType          : 8; //当前天气类型

        /*Byte24 - Byte26*/
        uint8_t CurrentWeatherTemp          : 8; //当前天气温度
        uint8_t SevereWeatherType           : 8; //恶劣天气类型
        uint8_t WarningWeatherLevel         : 3; //天气预警等级
        uint8_t SevereWeatherTime           : 5; //恶劣天气发生时间

    }Sig;
} _ID0XD0h_Data;


typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XB1_DATA_LEN];

    struct
    {
        /*Byte0 - Byte63*/
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        /*Byte64 - Byte85*/
        uint8_t                             : 4;
        uint8_t BatType                     : 4; //电池类型
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;




    }Sig;
} _ID0XB1h_Data;


typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XD1_DATA_LEN];

    struct
    {
        /*Byte0 - Byte7*/
        uint8_t BatteryWorkingStatus        : 4; //电池工作状态
        uint8_t BatteryChargingStage        : 4; //电池充电阶段
        uint8_t MainBatteryVoltage_L        : 8; //主电池电压_L
        uint8_t MainBatteryVoltage_H        : 8; //主电池电压_H
        uint8_t MainBatteryCurrent_L        : 8; //主电池电流_L
        uint8_t MainBatteryCurrent_H        : 8; //主电池电流_H
        uint8_t MainBatteryQuantity         : 8; //主电池电量
        uint8_t                             : 8;
        uint8_t                             : 8;

        /*Byte8 - Byte39*/
        uint8_t  BatteryHealthStatus        : 8; //主电池健康状态
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint8_t                             : 2; /*36*/
        uint8_t ThermalRunawayAlarm         : 2; // 热失控报警
        uint8_t BatteryCharging             : 2; //电池充电互认结果
        uint8_t BatteryDischarge            : 2; //电池放电互认结果
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;

        /*Byte40 - Byte91*/
        uint32_t                            : 32;
        uint8_t                             : 2; /*Byte44*/
        uint8_t BatteryFailureAlarm         : 2; //电池故障报警
        uint8_t BMSNumber                   : 4; //BMS数
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        /*Byte92 - 138*/
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8; /*Byte110*/
        uint8_t TotalBatteryVoltage_L       : 8; //总电池电压_L
        uint8_t TotalBatteryVoltage_H       : 8; //总电池电压_H
        uint8_t TotalBatteryCurrent_L       : 8; //总电池电流_L
        uint8_t TotalBatteryCurrent_H       : 8; //总电池电流_H
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint8_t TotalBatteryRCT             : 8; //总电池电量剩余充满时间
        uint8_t BatteryChargingStatus       : 3; //电池充电状态
        uint8_t                             : 5;
        uint8_t                             : 8;
        uint8_t RealChargingPower_L         : 8; //实时充电公率_L
        uint8_t RealChargingPower_H         : 8; //实时充电公率_H
        uint8_t SinglePowerConsumption_L    : 8; //单次耗电量_L
        uint8_t SinglePowerConsumption_H    : 8; //单次耗电量_H

    }Sig;
} _ID0XD1h_Data;


typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XB2_DATA_LEN];

    struct
    {
        /*Byte0 - Byte55*/
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        /*Byte56 - */
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8; /*58*/
        uint8_t MaximumAllowableVoltage_L   : 8; //最大允许工作电压_L
        uint8_t MaximumAllowableVoltage_H   : 8; //最大允许工作电压_H
        uint8_t                             : 8; //最大输入功率_L
        uint8_t                             : 8; //最大输入功率_H
        uint8_t                             : 8; //最大输出功率_L
        uint8_t                             : 8; //最大输出功率_H
        uint8_t                             : 8; //最大输出转速_L
        uint8_t                             : 8; //最大输出转速_H
        uint8_t                             : 8; //最大输出转矩_L
        uint8_t                             : 8; //最大输出转矩_H Byte70
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 4; //轮胎胎径反馈 74
        uint8_t                             : 4; //轮胎胎径反馈 74
        uint8_t Wheeldiameter               : 4; //轮胎胎径反馈 74
        uint8_t                             : 4;
        uint8_t                             : 3;
        uint8_t VehicleType                 : 2; //车辆类型
        uint8_t                             : 3;
    }Sig;
} _ID0XB2h_Data;


typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XD2_DATA_LEN];

    struct
    {
        uint8_t BusbarVoltage : 8; // 母线电压
        uint8_t BusbarCurrent : 8; // 母线电流
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t MotorTemperature : 8;            // 电机温度
        //uint16_t ICMCalculatesVehicleSpeed : 16; // 车速霍尔值 9 10
        uint8_t ICMCalculatesVehicleSpeed_L : 8;
        uint8_t ICMCalculatesVehicleSpeed_H : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        // uint32_t BCMTripValue : 32;              // 里程小计霍尔值
        uint8_t : 8;
        uint8_t : 8;
        uint8_t FaultCorrecting : 2;      // 故障修复模式
        uint8_t AbnormalBrakeHandle : 2;  // 开机状态刹把信号异常
        uint8_t AbnormalTurnHandle : 2;   // 开机状态转把信号异常
        uint8_t UUpBridgeArmMosFault : 2; // MCU故障状态：MOS故障（U相上桥臂MOS故障）17

        uint8_t MCUFaultStateU_PhaseHallFault : 2; // MCU故障状态：霍尔故障（U相霍尔故障）18
        uint8_t MCUFaultStatus_HandlebarFault : 2; // MCU故障状态：转把故障
        uint8_t PhaseLossFault : 2;                // MCU故障状态：缺相故障
        uint8_t : 2;                               // MCU故障状态：MCU温度传感器故障

        uint8_t : 2;                           // MCU故障状态：电机温度传感器故障 19
        uint8_t BusOvervoltageProtection : 2;  // MCU告警状态：母线过压保护
        uint8_t BusUndervoltageProtection : 2; // MCU告警状态：母线欠压保护
        uint8_t BusOvercurrentProtection : 2;  // MCU告警状态：母线过流保护

        uint8_t LineShortProtection : 2;            // MCU告警状态：相线短路保护 20
        uint8_t MCUOverTempProtection : 2;          // MCU告警状态：MCU过温保护
        uint8_t MotorOvertempProtection : 2;        // MCU告警状态：电机过温保护
        uint8_t RotorLocked : 2;                    // MCU告警状态：堵转保护
        uint8_t TotalBatterySOC : 8;                // 电池电量百分比(SOC) 21
        uint8_t VehicleOperationStatusFeedback : 4; // 整车操作状态反馈22
        uint8_t : 4;                                // 解/进P方式
        uint8_t HandleValue : 8;                    // 转把值23
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 2; // 26
        uint8_t SpeedGear : 3; // 车速挡位
        uint8_t : 3;

        uint8_t TCSUserDefined: 2; /*27*/
        uint8_t : 3;
        uint8_t : 3;
        uint8_t RecuperationStatusFeedback: 2; //28
        uint8_t RecuperationFeedbackDefined: 2;
        uint8_t : 2; // 自适应推行功能设置反馈
        uint8_t : 2; // 自适应推行模式反馈

        uint8_t : 4;
        uint8_t : 2; // 推行模式反馈
        uint8_t : 2;

        uint8_t : 2;                     /*30*/
        uint8_t ReverseModeFeedback : 2; // 倒车模式反馈
        uint8_t : 2;
        uint8_t BrakeSwitchFeedback : 2; // 刹车开关信号反馈

        uint8_t : 2;               /*31*/
        uint8_t : 2;               // 弹射模式反馈
        uint8_t TCSDefined : 2;    // TCS功能设置反馈
        uint8_t TCSActivation : 2; // TCS激活状态

        uint8_t SpeedLimitModeFeedback : 2;      // 限速模式反馈
        uint8_t CruiseModeFeedback : 2;          // 巡航模式反馈
        uint8_t ClaudicationPatternFeedback : 2; // 跛行模式反馈
        uint8_t ParkinFeedback : 2;              // 驻车(P挡)反馈

        uint8_t TPowerFeedback : 2; // T动力模式反馈
        uint8_t : 2;
        uint8_t SuperTPower : 2; // 超级T动力状态
        uint8_t : 2;

        uint8_t : 2;
        uint8_t RampParkedState : 2; // 坡道驻停状态
        uint8_t SlopeDescentFunctionStatus: 2;  //陡坡缓降功能设置反馈
        uint8_t SteepHillDescentEnable : 2; // 陡坡缓降激活

        uint8_t : 2; // 车辆激活设置反馈
        uint8_t : 6;

    }Sig;
} _ID0XD2h_Data;


typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XB3_DATA_LEN];

    struct
    {
        /*Byte0 - Byte63*/
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;
        uint32_t                             : 32;

        /*Byte 64*/
        uint8_t                             : 8;
        uint8_t BT_MAC1                     : 8; //蓝牙MAC地址
        uint8_t BT_MAC2                     : 8;
        uint8_t BT_MAC3                     : 8;
        uint8_t BT_MAC4                     : 8;
        uint8_t BT_MAC5                     : 8;
        uint8_t BT_MAC6                     : 8;
        uint8_t VIN_LEN                     : 8; //VIN号长度
        uint8_t VIN17                       : 8;
        uint8_t VIN16                       : 8;
        uint8_t VIN15                       : 8;
        uint8_t VIN14                       : 8;
        uint8_t VIN13                       : 8;
        uint8_t VIN12                       : 8;
        uint8_t VIN11                       : 8;
        uint8_t VIN10                       : 8;
        uint8_t VIN9                        : 8;
        uint8_t VIN8                        : 8;
        uint8_t VIN7                        : 8;
        uint8_t VIN6                        : 8;
        uint8_t VIN5                        : 8;
        uint8_t VIN4                        : 8;
        uint8_t VIN3                        : 8;
        uint8_t VIN2                        : 8;
        uint8_t VIN1                        : 8;
    }Sig;
} _ID0XB3h_Data;

typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XD3_DATA_LEN];

    struct
    {
        uint8_t VehicleStatus : 3; // 整车状态
        uint8_t : 5;               // 整车开关机状态

        uint8_t : 2; // 整车ACC状态
        uint8_t : 2;
        uint8_t : 2; // BLE连接状态
        uint8_t : 2; // BLE靠近解锁功能状态

        uint8_t AlarmStatus: 4;                  // 报警器状态
        uint8_t LeftLightStatus : 2;  // 左转向灯状态
        uint8_t RightLightStatus : 2; // 右转向灯状态

        uint8_t : 2;
        uint8_t BatteryDischarge: 2;   /*电池放电互认结果*/
        uint8_t : 2;
        uint8_t MetricImperialSetting : 2; // 公英制设置
        uint8_t ElectronicCushionStatus: 3; //电子座桶锁状态
        uint8_t : 5;

        uint8_t BMS_0CommunicationStatus : 2; // 与BMS_0通讯状态
        uint8_t MCUCommunicationStatus : 2;   // 与MCU通讯状态
        uint8_t IOTCommunicationStatus : 2;   // 与IOT通讯状态
        uint8_t : 2;

        uint8_t : 2; // 电子龙头锁故障
        uint8_t : 2; // 电子龙头锁锁舌故障
        uint8_t : 2; // 电子龙头锁电机故障
        uint8_t : 2; // 电子坐桶锁故障

        uint8_t : 2; // ACC输出MOS故障
        uint8_t : 2;
        uint8_t : 2; // 加热故障状态
        uint8_t : 2; // 加热功能受限原因

        uint8_t : 2; // 手把加热功能设置反馈
        uint8_t : 2; // 手把加热等级设置反馈
        uint8_t : 2; // 座垫加热功能设置反馈
        uint8_t : 2; // 座垫加热等级设置反馈

        uint8_t : 2; // 座垫感应开关状态反馈
        uint8_t : 2;
        uint8_t DumpCategory : 2;       // 倾倒类别
        uint8_t SupportSwitchState : 2; // 边撑开关状态

        uint8_t : 5;
        uint8_t SpeedGear : 3; // 车速挡位

        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;

        uint8_t VehicleShutdownEnablesSignal : 2; // 车辆关机倒计时使能信号
        uint8_t : 6;

        uint8_t AutoheadLightSetting : 2;       // 自动大灯功能设置指令
        uint8_t ODOResetSetting : 2;            // 总计里程清零指令(BLE)
        uint8_t RemainingMileageDisSetting : 2; // 剩余里程显示功能设置
        uint8_t ParkingSetting : 2;             // 驻车（P档）指令

        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;
        uint8_t : 8;

        uint8_t PasswordUnlockCommand : 2; // 仪表密码解锁唤醒指令
        uint8_t PasswordAuthResult : 2;    // 密码认证结果
        uint8_t PasswordCanbeEnter : 3;    // 密码可输入剩余次数
        uint8_t BlueToothPair : 1;         // 经典蓝牙配对指令

    }Sig;
} _ID0XD3h_Data;

typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XB6_DATA_LEN];

    struct
    {
        /*Byte0 - Byte63*/
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        /*Byte64 - Byte85*/
        uint8_t                             : 4;
        uint8_t BatType                     : 4; //电池类型
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;

    }Sig;
} _ID0XB6h_Data;

typedef union __attribute__((packed))
{
    uint8_t Msg[RS485_RX_ID0XD6_DATA_LEN];

    struct
    {
        uint8_t                             : 2; //副电池在线状态
        uint8_t                             : 6;

        uint8_t                             : 8; //副电池电压_L
        uint8_t                             : 8; //副电池电压_H
        uint8_t                             : 8; //副电池电流_L
        uint8_t                             : 8; //副电池电流_H
        uint8_t SubbatterySOC               : 8; //副电池电池电量百分比(SOC)

        uint8_t                             : 8;
        uint8_t                             : 8;

        uint8_t                             : 8; //副电池健康状态百分比（SOC）
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint8_t                             : 8;
        uint32_t                            : 32;

        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;

        uint32_t                            : 32;
        uint8_t                             : 2;
        uint8_t                             : 2; //高温报警(热失控)
        uint8_t                             : 2;
        uint8_t                             : 2;

        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint32_t                            : 32;
        uint16_t                            : 16;
    }Sig;
} _ID0XD6h_Data;

typedef struct
    {
        uint8_t ble1;
        uint8_t turnleft1;
        uint8_t turnright1;
        uint8_t ABSlight1;
        uint8_t lowlight1;
        uint8_t highlight1;
        uint8_t weizhilight1;
        uint32_t power1;
    }LineSta;
extern LineSta       LineGetSta;
extern _ID0X40h_Data R485_ID40h;
extern _ID0X48h_Data R485_ID48h;
extern _ID0X41h_Data R485_ID41h;
extern _ID0X49h_Data R485_ID49h;
extern _ID0X42h_Data R485_ID42h;
extern _ID0X4Ah_Data R485_ID4Ah;
extern _ID0X4Dh_Data R485_ID4Dh;
extern _ID0XD0h_Data R485_IDD0h;
extern _ID0XB1h_Data R485_IDB1h;
extern _ID0XD1h_Data R485_IDD1h;
extern _ID0XB2h_Data R485_IDB2h;
extern _ID0XD2h_Data R485_IDD2h;
extern _ID0XB3h_Data R485_IDB3h;
extern _ID0XD3h_Data R485_IDD3h;
extern _ID0XB6h_Data R485_IDB6h;
extern _ID0XD6h_Data R485_IDD6h;

extern _ID0XB4h_Data R485_IDB4h;
extern _ID0XD4h_Data R485_IDD4h;
extern _ID0XA4h_Data R485_IDA4h;
extern uint8_t zhenduansendStep;

extern uint32_t R485_Send_0x40(void);

extern uint32_t R485_Send_0x41(void);

extern uint32_t R485_Send_0x42(void);

extern uint32_t R485_Send_0x47(void);

extern uint32_t R485_Send_Line_0x47(uint8_t n);

extern uint32_t R485_Send_clear(void);

extern uint32_t R485_Sendcheck_0x47(void);

extern uint32_t R485_Send_0x80(void);
extern uint32_t R485_Send_0x45(void);

extern uint32_t R485_Send_ble0x42(void);

extern uint32_t R485_Send_0xD0(void);
extern uint32_t R485_Send_0xD1(void);
extern uint32_t R485_Send_0xD2(void);
extern uint32_t R485_Send_0xD3(void);
extern uint32_t R485_Send_0xA4(void);
extern uint32_t R485_Send_0xB3(void);
// extern uint32_t R485_Send_0x80(void);
extern uint32_t R485_Send_0x04(void);
extern uint8_t barcode_Msg[64];
extern uint8_t barcode_Msg1[64];
extern uint8_t name1;
extern uint8_t name2;
extern uint8_t R485_0x80_msg[64];

extern uint8_t mimayanzhengjieguo;
#endif
