#ifndef _APP_BLE_USER_H_
#define _APP_BLE_USER_H_

#include <stdlib.h>

extern uint8_t ble_uerid[33];
typedef enum
{
    Ble_Idle = 0, 
    Ble_Conn,
    Ble_Pair,
    Ble_Authr,
}Ble_Sts_Enum;

typedef enum
{
    BleRec_Idle = 0, 
    BleRec_Start,

    BleRec_Suc,
}Ble_Rec_Sts;



typedef struct
{
    uint8_t Ble_Sts;
    uint8_t Request_Navi;
    uint8_t Navi_Updat;
    uint8_t Navi_T;
    uint8_t UseridUpdate;
}Ble_User_Control_Struct;


typedef struct
{
    uint8_t Navi_Sts;
    uint8_t Navi_Turn;
    uint8_t Navi_Dte[4];
}Ble_Navi_Info_Struct;



typedef union 
{
    struct 
    {
        uint8_t FrameHeader;
        uint8_t Cmd;
        uint8_t Lenth;
        uint8_t Param[252];
    }Msg;
    uint8_t Data[255];
}app_Ble_User_Data_Union;

typedef struct 
{
    uint32_t RecLen;
    uint32_t TotalLen;
    uint8_t Sts;
}app_Ble_Rec_Data_Ctrl_Struct;


extern app_Ble_Rec_Data_Ctrl_Struct RecCtrl;
extern Ble_User_Control_Struct Ble_User;
extern Ble_Navi_Info_Struct Ble_Navi_Data;

void Get_Ble_Raw_Data(uint8_t *data, uint32_t len);



#define EC_BTP_VERSION                      "1.0.5"

#define EC_BTP_OK                           0
#define EC_BTP_ERR_FAIL                     -1


/** @brief    手机向车机汇报客户端信息
 *   @reqCmd   EC_BTP_P2C_CLIENT_INFO
 *   @rlyCmd   N/A
 *   @reqData  
 *    {
 *        phoneType:  0                                     ///< 数据类型为int, 0是Android，1是IOS。
 *        phoneID："zzz",                                   ///< 数据类型为string, 手机ID，可以为IMME或者设备唯一编号，住授权过的手车机端会记机ID。
 *    }
 *   @rlyData  N/A
 */
#define EC_BTP_P2C_CLIENT_INFO                  0x30


/** @brief    车机应答clientinfo
 *   @reqCmd   EC_BTP_C2P_CLIENT_INFO_RLY
 *   @rlyCmd   N/A
 *   @reqData   字段          字节数          内容
 *              key           32BYTE         格式：字符串。由卡比特项目经理提供
 *              uuid          32BYTE         格式：字符串。代表每一块仪表的唯一标识，每个仪表都不同。
 *              pwd           32BYTE         格式：字符串。默认为空，如需要，在卡比特指导下填写。
 *              flavor        4BYTE          格式：uint32_t。由卡比特项目经理提供。
 */
#define EC_BTP_C2P_CLIENT_INFO_RLY              0x58


/** @brief    授权结果
 *   @reqCmd   EC_BTP_P2C_CHECK_AUTH_RESULT
 *   @rlyCmd   N/A
 *   @reqData  字段          字节数          内容
 *          license          1BYTE         校验结果。0:校验成功；其他值校验失败
 *          msg              64BYTE        如果license不合法，此字段附带错误类型
 *   @rlyData  N/A
 */
#define EC_BTP_P2C_CHECK_AUTH_RESULT            0x60


/**
 * @brief HUD导航图标类型
 * 
 */
#define NaviIconType_NONE                           0        ///< 导航段转向图标类型 无定义，自定义转向图标数组，请忽略这个元素，从左转图标开始
#define NaviIconType_DEFAULT                        1        ///< 导航段转向图标类型 自车图标，自定义转向图标数组，请忽略这个元素，从左转图标开始
#define NaviIconType_LEFT                           2        ///< 导航段转向图标类型 左转图标
#define NaviIconType_RIGHT                          3        ///< 导航段转向图标类型 右转图标
#define NaviIconType_LEFT_FRONT                     4        ///< 导航段转向图标类型 左前方图标
#define NaviIconType_RIGHT_FRONT                    5        ///< 导航段转向图标类型 右前方图标
#define NaviIconType_LEFT_BACK                      6        ///< 导航段转向图标类型 左后方图
#define NaviIconType_RIGHT_BACK                     7        ///< 导航段转向图标类型 右后方图标
#define NaviIconType_LEFT_TURN_AROUND               8        ///< 导航段转向图标类型 左转掉头图标
#define NaviIconType_STRAIGHT                       9        ///< 导航段转向图标类型 直行图标
#define NaviIconType_ARRIVED_WAYPOINT               10       ///< 导航段转向图标类型 到达途经点图标
#define NaviIconType_ENTER_ROUNDABOUT               11       ///< 导航段转向图标类型 进入环岛图标
#define NaviIconType_OUT_ROUNDABOUT                 12       ///< 导航段转向图标类型 驶出环岛图标
#define NaviIconType_ARRIVED_SERVICE_AREA           13       ///< 导航段转向图标类型 到达服务区图标
#define NaviIconType_ARRIVED_TOLLGATE               14       ///< 导航段转向图标类型 到达收费站图标
#define NaviIconType_ARRIVED_DESTINATION            15       ///< 导航段转向图标类型 到达目的地图标
#define NaviIconType_ARRIVED_TUNNEL                 16       ///< 导航段转向图标类型 到达隧道图标
#define NaviIconType_CROSSWALK                      17       ///< 导航段转向图标类型：通过人行横道图标
#define NaviIconType_OVERPASS                       18       ///< 导航段转向图标类型：通过过街天桥图标
#define NaviIconType_UNDERPASS                      19       ///< 导航段转向图标类型：通过地下通道图标
#define NaviIconType_SQUARE                         20       ///< 导航段转向图标类型：通过广场图标
#define NaviIconType_PARK                           21       ///< 导航段转向图标类型：通过公园图标
#define NaviIconType_STAIRCASE                      22       ///< 导航段转向图标类型：通过扶梯图标
#define NaviIconType_LIFT                           23       ///< 导航段转向图标类型：通过直梯图标
#define NaviIconType_CABLEWAY                       24       ///< 导航段转向图标类型：通过索道图标
#define NaviIconType_SKY_CHANNEL                    25       ///< 导航段转向图标类型：通过空中通道图标
#define NaviIconType_CHANNEL                        26       ///< 导航段转向图标类型：通过通道、建筑物穿越通道图标
#define NaviIconType_WALK_ROAD                      27       ///< 导航段转向图标类型：通过行人道路图标
#define NaviIconType_CRUISE_ROUTE                   28       ///< 导航段转向图标类型：通过游船路线图标
#define NaviIconType_SIGHTSEEING_BUSLINE            29       ///< 导航段转向图标类型：通过观光车路线图标
#define NaviIconType_SLIDEWAY                       30       ///< 导航段转向图标类型：通过滑道图标
#define NaviIconType_LADDER                         31       ///< 导航段转向图标类型：通过阶梯图标
#define NaviIconType_MERGE_LEFT                     51       ///< 导航段转向图标类型：靠左行驶
#define NaviIconType_MERGE_RIGHT                    52       ///< 导航段转向图标类型：靠右行驶
#define NaviIconType_SLOW                           53       ///< 导航段转向图标类型：减速慢行
#define NaviIconType_ENTRY_RING_LEFT                54       ///< 标准小环岛 绕环岛左转，右侧通行地区的逆时针环岛
#define NaviIconType_ENTRY_RING_RIGHT               55       ///< 标准小环岛 绕环岛右转，右侧通行地区的逆时针环岛
#define NaviIconType_ENTRY_RING_CONTINUE            56       ///< 标准小环岛 绕环岛直行，右侧通行地区的逆时针环岛
#define NaviIconType_ENTRY_RING_UTURN               57       ///< 标准小环岛 绕环岛调头，右侧通行地区的逆时针环岛
#define NaviIconType_ENTRY_LEFT_RING                58       ///< 进入环岛图标，左侧通行地区的顺时针环岛
#define NaviIconType_LEAVE_LEFT_RING                59       ///< 驶出环岛图标，左侧通行地区的顺时针环岛
#define NaviIconType_UTURN_RIGHT                    60       ///< 右转掉头图标，左侧通行地区的掉头
#define NaviIconType_SPECIAL_CONTINUE               61       ///< 顺行图标(和直行有区别，顺行图标带有虚线)
#define NaviIconType_ENTRY_LEFT_RING_LEFT           62       ///< 标准小环岛 绕环岛左转，左侧通行地区的顺时针环岛
#define NaviIconType_ENTRY_LEFT_RING_RIGHT          63       ///< 标准小环岛 绕环岛右转，左侧通行地区的顺时针环岛
#define NaviIconType_ENTRY_LEFT_RING_CONTINUE       64       ///< 标准小环岛 绕环岛直行，左侧通行地区的顺时针环岛
#define NaviIconType_ENTRY_LEFT_RING_UTURN          65       ///< 标准小环岛 绕环岛调头，左侧通行地区的顺时针环岛
#define NaviIconType_SLOPE                          66       ///< 通过斜坡图标
#define NaviIconType_BRIDGE                         67       ///< 通过桥图标
#define NaviIconType_FERRYBOAT                      68       ///< 通过渡轮图标
#define NaviIconType_SUBWAY                         69       ///< 通过地铁图标
#define NaviIconType_ENTER_BUILDING                 70       ///< 进入建筑物图标
#define NaviIconType_LEAVE_BUILDING                 71       ///< 离开建筑物图标
#define NaviIconType_BY_ELEVATOR                    72       ///< 电梯换层图标
#define NaviIconType_BY_STAIR                       73       ///< 楼梯换层图标
#define NaviIconType_ESCALATOR                      74       ///< 扶梯换层图标
#define NaviIconType_LOW_TRAFFIC_CROSS              75       ///< 非导航段通过红绿灯路口图标
#define NaviIconType_LOW_CROSS                      76       ///< 非导航段通过普通路口图标
#define NaviIconType_ROTARY_SHARP_LEFT              77       ///< 环岛左后转，右侧通行地区的逆时针环岛
#define NaviIconType_ROTARY_SHARP_RIGHT             78       ///< 环岛后右转，右侧通行地区的逆时针环岛
#define NaviIconType_ROTARY_SLIGHT_LEFT             79       ///< 环岛左前转，右侧通行地区的逆时针环岛
#define NaviIconType_ROTARY_SLIGHT_RIGHT            80       ///< 环岛右前转，右侧通行地区的逆时针环岛

/**
 * @brief HUD导航功能枚举
 */
#define EC_BTP_HUD_FUNCITON_SUPPORT_LOAD 0x01                ///< 路口放大图
#define EC_BTP_HUD_FUNCITON_SUPPORT_LINE 0x02                ///< 车道引导图


/** @brief    
 *   @reqCmd   EC_BTP_C2P_HUD
 *   @reqData  字段          字节数          内容
 *             enable        1BYTE          0:关闭HUD数据，1:开启HUD数据，一次生命周期内只需要发送一次命令。
 *             maxNaviIcon   2BYTE          车机端支持的导航图标最大值
 *             funciton      2BYTE          车机端支持的功能，参考 EC_BTP_HUD_FUNCITON_SUPPORT*
 *   @rlyData  EC_BTP_P2C_HUD
 */
#define EC_BTP_C2P_HUD                          0x14


#define EC_BTP_NAVI_STATUS_STOPED               0x35          ///< 未导航或导航结束
#define EC_BTP_NAVI_STATUS_RUNNING              0x33          ///< 正在导航

/** @brief    
 *   @reqCmd   EC_BTP_P2C_HUD
 *   @reqData  字段                  字节数      内容
 *             导航状态              1BYTE       参见:EC_BTP_NAVI_STATUS_*
 *             导航转向编码          1BYTE       参见:NaviIconType_*
 *             转向距离              4BYTE       距离转向的距离（单位：米）
 *             转向⽬的地字节数       1BYTE      转向⽬的地UTF-8所占字节数
 *             转向⽬的地            60BYTE     最多60个字节（UTF-8编码）
 *             当前时速              4BYTE      ⻋速（单位：1千米/⼩时）
 *             导航剩余⾥程          4BYTE       剩余⾥程（单位：米）
 *             预计到达时间          19BYTE      预计到达时间（格式为：dd.MM.yyyy HH:mm:ss）
 *             剩余时间              2BYTE       离终点预估剩余时间(单位：分钟)
 */ 
#define EC_BTP_P2C_HUD                          0x14



void Ble_Rec_Msg_Analysis_Process(void );

void Ble_Connect_Event_Pro(void );
void Ble_DisConnect_Event_Pro(void );
void Ble_User_Init(void );
void Ble_Msg_RequestNavi_RLY(void );
void Ble_MsgRec_Navi_Timeout(void );

#endif