/*
 * SPDX-FileCopyrightText: 2021-2023 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Unlicense OR CC0-1.0
 */

/****************************************************************************
*
* This demo showcases creating a GATT database using a predefined attribute table.
* It acts as a GATT server and can send adv data, be connected by client.
* Run the gatt_client demo, the client demo will automatically connect to the gatt_server_service_table demo.
* Client demo will enable GATT server's notify after connection. The two devices will then exchange
* data.
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/event_groups.h"
#include "esp_system.h"
#include "esp_log.h"
#include "nvs_flash.h"
#include "esp_bt.h"

#include "esp_gap_ble_api.h"
#include "esp_gatts_api.h"
#include "esp_bt_main.h"
#include "gatts_table_creat_demo.h"
#include "esp_gatt_common_api.h"

#include "esp_mac.h"

#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "esp_log.h"
#include "driver/uart.h"
#include "string.h"
#include "driver/gpio.h"
#include "Protocol_CRC16.h"
#include "Protocol_Lib.h"
#include "Protocol_User.h"
#include "app_Ble_User.h"
#include "MCU_Core_Protocol.h"

typedef   unsigned char   uint8_t;

unsigned int flag_u;

static const int RX_BUF_SIZE = 1024;

#define TXD_PIN (GPIO_NUM_18)
#define RXD_PIN (GPIO_NUM_38)

typedef struct
{
    uint16_t Rxlen;
    uint8_t Rxbuff[255];
} _TY_UART_Ctrl;

_TY_UART_Ctrl TY_UARTRX;

void init_Uart(void) {
    const uart_config_t uart_config = {
        .baud_rate = 115200,
        .data_bits = UART_DATA_8_BITS,
        .parity = UART_PARITY_DISABLE,
        .stop_bits = UART_STOP_BITS_1,
        .flow_ctrl = UART_HW_FLOWCTRL_DISABLE,
        .source_clk = UART_SCLK_DEFAULT,
    };
    // We won't use a buffer for sending data.
    uart_driver_install(UART_NUM_1, RX_BUF_SIZE * 2, 200, 0, NULL, 0);
    uart_param_config(UART_NUM_1, &uart_config);
    // printf("GPIO38\n");
    uart_set_pin(UART_NUM_1, TXD_PIN, RXD_PIN, UART_PIN_NO_CHANGE, UART_PIN_NO_CHANGE);
}

int bsp_Uart_Send_Data(uint8_t * data , unsigned int len)
{
    uint32_t aaa = 0;

    if(data[4] == 0x01 && data[5] == 0x33)
    {
        //printf("data[5] = %x ", data[5]);
        //printf("data[6] = %x ", data[6]);
        //printf("data[7] = %x ", data[7]);
        //printf("data[8] = %x ", data[8]);
        //printf("data[9] = %x ", data[9]);
        //printf("data[10] = %x ", data[10]);
        //printf("\n");
//
        //printf("navi sts data[5] = %x  ", data[5]);
        //printf("navi turn data[6] = %d  ", data[6]);

        aaa = data[10];
        aaa <<= 8;
        aaa |= data[9];
        aaa <<= 8;
        aaa |= data[8];
        aaa <<= 8;
        aaa |= data[7];

        //printf("navi dest = %ld  \n", aaa);
//
        //printf("\n");
        //printf("\n");


    }

    int txBytes = uart_write_bytes(UART_NUM_1, data, len);
    uart_wait_tx_idle_polling(UART_NUM_1);
    return txBytes;
}



static void Uart_Rx_Task(void *arg)
{
    uint8_t* data = (uint8_t*) malloc(RX_BUF_SIZE+1);
    while (1)
    {
        const int rxBytes = uart_read_bytes(UART_NUM_1, data, RX_BUF_SIZE, 20);
        if (rxBytes < 1000 && rxBytes > 0u)
        {
            for (uint16_t i = 0; i < rxBytes; i++)
            {
                UART_Put(data[i]);

                // printf("0x%2x, ", data[i]);
            }
            // printf("\n");
        }
    }
    free(data);
}

void bsp_Uart_Init(void )
{
    init_Uart();
    Protocol_KL30_Wakeup_Init();
    // printf("uart init!!\n");
    xTaskCreatePinnedToCore(Uart_Rx_Task, "bsp_Uart", 4096, NULL, 4, NULL, 1);
}

void simple_ota_service(void)
{
    // if(Wifi_OTA_Request == 1)
    // {
    //     Wifi_OTA_Request = 2;
    //     simple_ota_main();
    //     vTaskDelay(portMAX_DELAY);
    // }
}

/*
 * SPDX-FileCopyrightText: 2021-2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Unlicense OR CC0-1.0
 */



/****************************************************************************
*
* This demo showcases BLE GATT client. It can scan BLE devices and connect to one device.
* Run the gatt_server demo, the client demo will automatically connect to the gatt_server demo.
* Client demo will enable gatt_server's notify after connection. The two devices will then exchange
* data.
*
****************************************************************************/

#include <stdint.h>
#include <string.h>
#include <stdbool.h>
#include <stdio.h>
#include "nvs.h"
#include "nvs_flash.h"

#include "esp_bt.h"
#include "esp_gap_ble_api.h"
#include "esp_gattc_api.h"
#include "esp_gatt_defs.h"
#include "esp_bt_main.h"
#include "esp_gatt_common_api.h"
#include "esp_log.h"
#include "freertos/FreeRTOS.h"

#define GATTC_TAG "GATTC_DEMO"

static const uint8_t ServiceUUID[16] = { 0xF2, 0xC3, 0xF0, 0xAE, 0xA9,
                                        0xFA, 0x15, 0x8C, 0x9D, 0x49, 0xAE,
                                        0x73, 0xD2, 0x0B, 0x81, 0xE7 };
static const uint8_t CharWriteUUID[16] = { 0x9F, 0x9F, 0x00, 0xC1, 0x58,
                                        0xBD, 0x32, 0xB6, 0x9E, 0x4C, 0x21,
                                        0x9C, 0x21, 0xE8, 0xF8, 0xBE };
static const uint8_t CharNotifyUUID[16] = {0x9F, 0x9F, 0x00, 0xC1, 0x58,
                                            0xBD, 0x32, 0xB6, 0x9E, 0x4C,
                                             0x21, 0x9C, 0x20, 0xE8, 0xF8, 0xBE};
// #define REMOTE_SERVICE_UUID        0x00FF
// #define REMOTE_NOTIFY_CHAR_UUID    0xFF01
#define REMOTE_SERVICE_UUID        0x00FF
#define REMOTE_NOTIFY_CHAR_UUID    0xFF01
#define PROFILE_NUM      1
#define PROFILE_A_APP_ID 0
#define INVALID_HANDLE   0
unsigned char write_char_data[] = {
    0x59, 0x44, 0x3D, 0x3E, 0x01, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x27, 0x10, 0x22,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0x02, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x09, 0x03, 0xE9, 0xBB, 0x91, 0xE9, 0xBE, 0x99, 0xE6, 0xB1, 0x9F, 0xE7, 0x9C, 0x81,
    0xE5, 0xA4, 0xA9, 0xE6, 0x9C, 0x89, 0xE4, 0xB8, 0xBA, 0xE7, 0xA0, 0x94, 0xE7, 0xA9, 0xB6, 0xE9,
    0x99, 0xA2, 0x9B, 0x4B, 0x4A
};

char remote_device_name[] = {0x0A,0x8A,0x0A,0x0A,0x00,0x00};
// static char remote_device_name[] = "YD0A0A0000";
static bool connect    = false;
static bool get_server = false;
static esp_gattc_char_elem_t *char_elem_result   = NULL;
static esp_gattc_descr_elem_t *descr_elem_result = NULL;

/* Declare static functions */
static void esp_gap_cb(esp_gap_ble_cb_event_t event, esp_ble_gap_cb_param_t *param);
static void esp_gattc_cb(esp_gattc_cb_event_t event, esp_gatt_if_t gattc_if, esp_ble_gattc_cb_param_t *param);
static void gattc_profile_event_handler(esp_gattc_cb_event_t event, esp_gatt_if_t gattc_if, esp_ble_gattc_cb_param_t *param);


static esp_bt_uuid_t remote_filter_service_uuid = {
    .len = ESP_UUID_LEN_128,
    // .uuid = {.uuid16 = REMOTE_SERVICE_UUID,},
};

static esp_bt_uuid_t remote_filter_char_uuid = {
    .len = ESP_UUID_LEN_128,
    // .uuid = {.uuid16 = REMOTE_NOTIFY_CHAR_UUID,},
};

static esp_bt_uuid_t notify_descr_uuid = {
    .len = ESP_UUID_LEN_128,
    // .uuid = {.uuid16 = ESP_GATT_UUID_CHAR_CLIENT_CONFIG,},
};

static esp_ble_scan_params_t ble_scan_params = {
    .scan_type              = BLE_SCAN_TYPE_ACTIVE,
    .own_addr_type          = BLE_ADDR_TYPE_PUBLIC,
    .scan_filter_policy     = BLE_SCAN_FILTER_ALLOW_ALL,
    .scan_interval          = 0x50,
    .scan_window            = 0x30,
    .scan_duplicate         = BLE_SCAN_DUPLICATE_DISABLE
};

struct gattc_profile_inst {
    esp_gattc_cb_t gattc_cb;
    uint16_t gattc_if;
    uint16_t app_id;
    uint16_t conn_id;
    uint16_t service_start_handle;
    uint16_t service_end_handle;
    uint16_t char_handle;
    esp_bd_addr_t remote_bda;
};

/* One gatt-based profile one app_id and one gattc_if, this array will store the gattc_if returned by ESP_GATTS_REG_EVT */
static struct gattc_profile_inst gl_profile_tab[PROFILE_NUM] = {
    [PROFILE_A_APP_ID] = {
        .gattc_cb = gattc_profile_event_handler,
        .gattc_if = ESP_GATT_IF_NONE,       /* Not get the gatt_if, so initial is ESP_GATT_IF_NONE */
    },
};
esp_gatt_if_t blesend = 0;
static void gattc_profile_event_handler(esp_gattc_cb_event_t event, esp_gatt_if_t gattc_if, esp_ble_gattc_cb_param_t *param)
{
    esp_ble_gattc_cb_param_t *p_data = (esp_ble_gattc_cb_param_t *)param;
    memcpy(remote_filter_service_uuid.uuid.uuid128,ServiceUUID,16);
    memcpy(remote_filter_char_uuid.uuid.uuid128,CharWriteUUID,16);
    memcpy(notify_descr_uuid.uuid.uuid128,CharNotifyUUID,16);
    switch (event) {
    case ESP_GATTC_REG_EVT://扫描
        ESP_LOGI(GATTC_TAG, "GATT client register, status %d, app_id %d, gattc_if %d", param->reg.status, param->reg.app_id, gattc_if);
        esp_err_t scan_ret = esp_ble_gap_set_scan_params(&ble_scan_params);
        if (scan_ret){
            ESP_LOGE(GATTC_TAG, "set scan params error, error code = %x", scan_ret);
        }
        break;
    case ESP_GATTC_CONNECT_EVT:{
        // printf("join connect ~~~~\n");
        ESP_LOGI(GATTC_TAG, "Connected, conn_id %d, remote "ESP_BD_ADDR_STR"", p_data->connect.conn_id,
                 ESP_BD_ADDR_HEX(p_data->connect.remote_bda));
        gl_profile_tab[PROFILE_A_APP_ID].conn_id = p_data->connect.conn_id;
        memcpy(gl_profile_tab[PROFILE_A_APP_ID].remote_bda, p_data->connect.remote_bda, sizeof(esp_bd_addr_t));
        esp_err_t mtu_ret = esp_ble_gattc_send_mtu_req (gattc_if, p_data->connect.conn_id);
        if (mtu_ret){
            ESP_LOGE(GATTC_TAG, "Config MTU error, error code = %x", mtu_ret);
        }
        break;
    }
    case ESP_GATTC_OPEN_EVT:
        if (param->open.status != ESP_GATT_OK){
            ESP_LOGE(GATTC_TAG, "Open failed, status %d", p_data->open.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Open successfully, MTU %u", p_data->open.mtu);
        break;
    case ESP_GATTC_DIS_SRVC_CMPL_EVT:
        if (param->dis_srvc_cmpl.status != ESP_GATT_OK){
            ESP_LOGE(GATTC_TAG, "Service discover failed, status %d", param->dis_srvc_cmpl.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Service discover complete, conn_id %d", param->dis_srvc_cmpl.conn_id);
        // esp_ble_gattc_search_service(gattc_if, param->dis_srvc_cmpl.conn_id, &remote_filter_service_uuid);
        esp_ble_gattc_search_service(gattc_if, param->dis_srvc_cmpl.conn_id, NULL);
        break;
    case ESP_GATTC_CFG_MTU_EVT:
        ESP_LOGI(GATTC_TAG, "MTU exchange, status %d, MTU %d", param->cfg_mtu.status, param->cfg_mtu.mtu);
        break;
    case ESP_GATTC_SEARCH_RES_EVT: {
        ESP_LOGI(GATTC_TAG, "Service search result, conn_id = %x, is primary service %d", p_data->search_res.conn_id, p_data->search_res.is_primary);
        ESP_LOGI(GATTC_TAG, "start handle %d, end handle %d, current handle value %d", p_data->search_res.start_handle, p_data->search_res.end_handle, p_data->search_res.srvc_id.inst_id);
        // if (p_data->search_res.srvc_id.uuid.len == ESP_UUID_LEN_16 && p_data->search_res.srvc_id.uuid.uuid.uuid16 == REMOTE_SERVICE_UUID) {
        ESP_LOGI(GATTC_TAG, "UUID16len: %x", p_data->search_res.srvc_id.uuid.len);

        // ESP_LOGI(GATTC_TAG, "UUID16len: %x", p_data->search_res.srvc_id.uuid.len);
        ESP_LOGI(GATTC_TAG, "remote_filter_service_uuid.uuid.uuid128: %x", remote_filter_service_uuid.uuid.uuid128[0]);
        if (p_data->search_res.srvc_id.uuid.len == ESP_UUID_LEN_128 && (memcmp(p_data->search_res.srvc_id.uuid.uuid.uuid128,remote_filter_service_uuid.uuid.uuid128,16) == 0)) {
            // if(p_data->search_res.srvc_id.uuid.len == ESP_UUID_LEN_128) {
            ESP_LOGI(GATTC_TAG, "Service found");
            get_server = true;
            gl_profile_tab[PROFILE_A_APP_ID].service_start_handle = p_data->search_res.start_handle;
            gl_profile_tab[PROFILE_A_APP_ID].service_end_handle = p_data->search_res.end_handle;
            ESP_LOGI(GATTC_TAG, "UUID16: %x", p_data->search_res.srvc_id.uuid.uuid.uuid16);
        }
        // ESP_LOGI(GATTC_TAG, "UUID16len: %x", p_data->search_res.srvc_id.uuid.len);
        // ESP_LOGI(GATTC_TAG, "start_handl: %x", p_data->search_res.start_handle);
        // ESP_LOGI(GATTC_TAG, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        // ESP_LOG_BUFFER_HEX(GATTC_TAG, remote_filter_service_uuid.uuid.uuid128, sizeof(remote_filter_service_uuid.uuid.uuid128));
        // ESP_LOGI(GATTC_TAG, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        // ESP_LOG_BUFFER_HEX(GATTC_TAG, p_data->search_res.srvc_id.uuid.uuid.uuid128, p_data->search_res.srvc_id.uuid.len);
        // ESP_LOGI(GATTC_TAG, "start_handl: %d", gl_profile_tab[PROFILE_A_APP_ID].service_start_handle);
        // ESP_LOGI(GATTC_TAG, "end_handle: %x", gl_profile_tab[PROFILE_A_APP_ID].service_start_handle);
        break;
    }
    case ESP_GATTC_SEARCH_CMPL_EVT:
        if (p_data->search_cmpl.status != ESP_GATT_OK){
            ESP_LOGE(GATTC_TAG, "Service search failed, status %x", p_data->search_cmpl.status);
            break;
        }
        if(p_data->search_cmpl.searched_service_source == ESP_GATT_SERVICE_FROM_REMOTE_DEVICE) {
            ESP_LOGI(GATTC_TAG, "Get service information from remote device");
        } else if (p_data->search_cmpl.searched_service_source == ESP_GATT_SERVICE_FROM_NVS_FLASH) {
            ESP_LOGI(GATTC_TAG, "Get service information from flash");
        } else {
            ESP_LOGI(GATTC_TAG, "Unknown service source");
        }
        ESP_LOGI(GATTC_TAG, "Service search complete");
        if (get_server){
        // if (1){
            // printf("get server\n");
            uint16_t count = 0;
            esp_gatt_status_t status = esp_ble_gattc_get_attr_count( gattc_if,
                                                                     p_data->search_cmpl.conn_id,
                                                                     ESP_GATT_DB_CHARACTERISTIC,
                                                                     gl_profile_tab[PROFILE_A_APP_ID].service_start_handle,
                                                                     gl_profile_tab[PROFILE_A_APP_ID].service_end_handle,
                                                                     INVALID_HANDLE,
                                                                     &count);
            if (status != ESP_GATT_OK){
                ESP_LOGE(GATTC_TAG, "esp_ble_gattc_get_attr_count error");
                break;
            }

            if (count > 0){
                char_elem_result = (esp_gattc_char_elem_t *)malloc(sizeof(esp_gattc_char_elem_t) * count);
                if (!char_elem_result){
                    ESP_LOGE(GATTC_TAG, "gattc no mem");
                    break;
                }else{
                    status = esp_ble_gattc_get_char_by_uuid( gattc_if,
                                                             p_data->search_cmpl.conn_id,
                                                             gl_profile_tab[PROFILE_A_APP_ID].service_start_handle,
                                                             gl_profile_tab[PROFILE_A_APP_ID].service_end_handle,
                                                             remote_filter_char_uuid,
                                                             char_elem_result,
                                                             &count);
                    ESP_LOGI(GATTC_TAG, "esp_ble_gattc_get_char_by_uuid~~~~~~~~~~~~~~~~~~~~~\n");
                    ESP_LOGI(GATTC_TAG, "gattc_if: %x\n", gattc_if);
                    ESP_LOGI(GATTC_TAG, "p_data->search_cmpl.conn_id: %x\n", p_data->search_cmpl.conn_id);
                    ESP_LOGI(GATTC_TAG, "start_handle: %x\n", gl_profile_tab[PROFILE_A_APP_ID].service_start_handle);
                    ESP_LOGI(GATTC_TAG, "end_handle: %x\n", gl_profile_tab[PROFILE_A_APP_ID].service_end_handle);
                    if (status != ESP_GATT_OK){
                        ESP_LOGE(GATTC_TAG, "esp_ble_gattc_get_char_by_uuid error");
                        free(char_elem_result);
                        char_elem_result = NULL;
                        break;
                    }

                    /*  Every service have only one char in our 'ESP_GATTS_DEMO' demo, so we used first 'char_elem_result' */
                    printf("ESP_GATT_CHAR_PROP_BIT_WRITE:%x\n",ESP_GATT_CHAR_PROP_BIT_WRITE);
                    if (count > 0 && (char_elem_result[0].properties & ESP_GATT_CHAR_PROP_BIT_WRITE)){
                        printf("char_elem_result[0].char_handle:%x\n",char_elem_result[0].char_handle);
                        gl_profile_tab[PROFILE_A_APP_ID].char_handle = char_elem_result[0].char_handle;
                        esp_ble_gattc_register_for_notify (gattc_if, gl_profile_tab[PROFILE_A_APP_ID].remote_bda, char_elem_result[0].char_handle);
                    }
                }
                /* free char_elem_result */
                free(char_elem_result);
            }else{
                ESP_LOGE(GATTC_TAG, "no char found");
            }
        }
         break;
    case ESP_GATTC_REG_FOR_NOTIFY_EVT: {
        if (p_data->reg_for_notify.status != ESP_GATT_OK){
            ESP_LOGE(GATTC_TAG, "Notification register failed, status %d", p_data->reg_for_notify.status);
        }else{
            ESP_LOGI(GATTC_TAG, "Notification register successfully");
            uint16_t count = 0;
            uint16_t notify_en = 1;
            printf("gl_profile_tab[PROFILE_A_APP_ID].char_handle:%x\n",gl_profile_tab[PROFILE_A_APP_ID].char_handle);
            esp_gatt_status_t ret_status = esp_ble_gattc_get_attr_count( gattc_if,
                                                                         gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                                                                         ESP_GATT_DB_ALL,
                                                                         gl_profile_tab[PROFILE_A_APP_ID].service_start_handle,
                                                                         gl_profile_tab[PROFILE_A_APP_ID].service_end_handle,
                                                                         gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                                                                         &count);
            if (ret_status != ESP_GATT_OK){
                ESP_LOGE(GATTC_TAG, "esp_ble_gattc_get_attr_count error");
                break;
            }
             ESP_LOGE(GATTC_TAG, "count %x", count);
            // count = 1;
            if (count > 0){
                //  xTaskCreatePinnedToCore(Sys_Run_Tasks, "Sys_Run_Tasks", 4096, NULL, 3, NULL, 1);
                blesend = gattc_if;
                        // esp_ble_gattc_write_char( gattc_if,
                        //           gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                        //           gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                        //           sizeof(write_char_data),
                        //           write_char_data,
                        //           ESP_GATT_WRITE_TYPE_RSP,
                        //           ESP_GATT_AUTH_REQ_NONE);
                        //                                   esp_ble_gattc_write_char( gattc_if,
                        //           gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                        //           gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                        //           sizeof(write_char_data),
                        //           write_char_data,
                        //           ESP_GATT_WRITE_TYPE_RSP,
                        //           ESP_GATT_AUTH_REQ_NONE);
                        //                                   esp_ble_gattc_write_char( gattc_if,
                        //           gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                        //           gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                        //           sizeof(write_char_data),
                        //           write_char_data,
                        //           ESP_GATT_WRITE_TYPE_RSP,
                        //           ESP_GATT_AUTH_REQ_NONE);
                        //                                   esp_ble_gattc_write_char( gattc_if,
                        //           gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                        //           gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                        //           sizeof(write_char_data),
                        //           write_char_data,
                        //           ESP_GATT_WRITE_TYPE_RSP,
                        //           ESP_GATT_AUTH_REQ_NONE);
                // descr_elem_result = malloc(sizeof(esp_gattc_descr_elem_t) * count);
                // if (!descr_elem_result){
                //     ESP_LOGE(GATTC_TAG, "malloc error, gattc no mem");
                //     break;
                // }else{
                //     ret_status = esp_ble_gattc_get_descr_by_char_handle( gattc_if,
                //                                                          gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                //                                                          p_data->reg_for_notify.handle,
                //                                                          notify_descr_uuid,
                //                                                          descr_elem_result,
                //                                                          &count);
                //     ESP_LOGI(GATTC_TAG, "esp_ble_gattc_get_descr_by_char_handle~~~~~~~~~~~~~~~~~~~~~\n");
                //     ESP_LOGI(GATTC_TAG, "gattc_if: %x\n", gattc_if);
                //     ESP_LOGI(GATTC_TAG, "p_data->search_cmpl.conn_id: %x\n", gl_profile_tab[PROFILE_A_APP_ID].conn_id);
                //     ESP_LOGI(GATTC_TAG, "p_data->reg_for_notify.handle: %x\n", p_data->reg_for_notify.handle);
                //     ESP_LOG_BUFFER_HEX(GATTC_TAG, notify_descr_uuid.uuid.uuid128, sizeof(notify_descr_uuid.uuid.uuid128));
                //     ESP_LOGI(GATTC_TAG, "e~~~~~~~~~~~~~~~~~~~~~\n");
                //     ESP_LOG_BUFFER_HEX(GATTC_TAG, descr_elem_result, sizeof(descr_elem_result));
                //     if (ret_status != ESP_GATT_OK){
                //         ESP_LOGE(GATTC_TAG, "esp_ble_gattc_get_descr_by_char_handle error");
                //         free(descr_elem_result);
                //         descr_elem_result = NULL;
                //         break;
                //     }

                //     /* Every char has only one descriptor in our 'ESP_GATTS_DEMO' demo, so we used first 'descr_elem_result' */
                //     if (count > 0 && descr_elem_result[0].uuid.len == ESP_UUID_LEN_128 && descr_elem_result[0].uuid.uuid.uuid16 == ESP_GATT_UUID_CHAR_CLIENT_CONFIG){
                //         ret_status = esp_ble_gattc_write_char_descr( gattc_if,
                //                                                      gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                //                                                      descr_elem_result[0].handle,
                //                                                      sizeof(notify_en),
                //                                                      (uint8_t *)&notify_en,
                //                                                      ESP_GATT_WRITE_TYPE_RSP,
                //                                                      ESP_GATT_AUTH_REQ_NONE);
                //     }

                //     if (ret_status != ESP_GATT_OK){
                //         ESP_LOGE(GATTC_TAG, "esp_ble_gattc_write_char_descr error");
                //     }

                //     /* free descr_elem_result */
                //     free(descr_elem_result);
                // }
            }
            else{
                ESP_LOGE(GATTC_TAG, "decsr not found");
            }

        }
        break;
    }
    case ESP_GATTC_NOTIFY_EVT:
        if (p_data->notify.is_notify){
            ESP_LOGI(GATTC_TAG, "Notification received");
        }else{
            ESP_LOGI(GATTC_TAG, "Indication received");
        }
        ESP_LOG_BUFFER_HEX("NOTIFY_EVT", p_data->notify.value, p_data->notify.value_len);
        break;
    case ESP_GATTC_WRITE_DESCR_EVT:
        if (p_data->write.status != ESP_GATT_OK){
            ESP_LOGE(GATTC_TAG, "Descriptor write failed, status %x", p_data->write.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Descriptor write successfully");
        // uint8_t write_char_data[] = "59443D3ECC05FFFFFFFFFF03E8271022FFFFFFFFFF170203FFFFFFFFFFFFFFFFFFFF0103E9BB91E9BE99E6B19FE79C81E5A4A9E69C89E4B8BAE7A094E7A9B6E999A2634B4A";
        // uint8_t write_char_data[]
        // for (int i = 0; i < sizeof(write_char_data); ++i)
        // {
        //     write_char_data[i] = i % 256;
        // }
        printf("send~~~~\n");
        esp_ble_gattc_write_char( gattc_if,
                                  gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                                  gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                                  sizeof(write_char_data),
                                  write_char_data,
                                  ESP_GATT_WRITE_TYPE_RSP,
                                  ESP_GATT_AUTH_REQ_NONE);
        break;
    case ESP_GATTC_SRVC_CHG_EVT: {
        esp_bd_addr_t bda;
        memcpy(bda, p_data->srvc_chg.remote_bda, sizeof(esp_bd_addr_t));
        ESP_LOGI(GATTC_TAG, "Service change from "ESP_BD_ADDR_STR"", ESP_BD_ADDR_HEX(bda));
        break;
    }
    case ESP_GATTC_WRITE_CHAR_EVT:
        if (p_data->write.status != ESP_GATT_OK){
            ESP_LOGE(GATTC_TAG, "Characteristic write failed, status %x)", p_data->write.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Characteristic write successfully");
        break;
    case ESP_GATTC_DISCONNECT_EVT:
        connect = false;
        get_server = false;
        printf("disconnect\n");
        ESP_LOGI(GATTC_TAG, "Disconnected, remote "ESP_BD_ADDR_STR", reason 0x%02x",
                 ESP_BD_ADDR_HEX(p_data->disconnect.remote_bda), p_data->disconnect.reason);
        break;
    default:
        break;
    }
}

static void esp_gap_cb(esp_gap_ble_cb_event_t event, esp_ble_gap_cb_param_t *param)
{
    uint8_t *adv_name = NULL;
    uint8_t adv_name_len = 0;
    switch (event) {
    //开始扫描
    case ESP_GAP_BLE_SCAN_PARAM_SET_COMPLETE_EVT: {
        //the unit of the duration is second
        uint32_t duration = 30;
        esp_ble_gap_start_scanning(duration);
        break;
    }
    case ESP_GAP_BLE_SCAN_START_COMPLETE_EVT:
        //scan start complete event to indicate scan start successfully or failed
        if (param->scan_start_cmpl.status != ESP_BT_STATUS_SUCCESS) {
            ESP_LOGE(GATTC_TAG, "Scanning start failed, status %x", param->scan_start_cmpl.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Scanning start successfully");

        break;
        //获取扫描结果
    case ESP_GAP_BLE_SCAN_RESULT_EVT: {
        esp_ble_gap_cb_param_t *scan_result = (esp_ble_gap_cb_param_t *)param;
        switch (scan_result->scan_rst.search_evt) {
        case ESP_GAP_SEARCH_INQ_RES_EVT:
            adv_name = esp_ble_resolve_adv_data(scan_result->scan_rst.ble_adv,
                                                ESP_BLE_AD_TYPE_NAME_CMPL, &adv_name_len);
            // ESP_LOGI(GATTC_TAG, "Scan result, device "ESP_BD_ADDR_STR", name len %u", ESP_BD_ADDR_HEX(scan_result->scan_rst.bda), adv_name_len);
            ESP_LOG_BUFFER_CHAR(GATTC_TAG, adv_name, adv_name_len);

            ESP_LOG_BUFFER_HEX("SCAN_name", remote_device_name, 6);
            ESP_LOG_BUFFER_HEX("SCAN_bda", scan_result->scan_rst.bda, 6);
#if CONFIG_EXAMPLE_DUMP_ADV_DATA_AND_SCAN_RESP
            if (scan_result->scan_rst.adv_data_len > 0) {
                ESP_LOGI(GATTC_TAG, "adv data:");
                ESP_LOG_BUFFER_HEX(GATTC_TAG, &scan_result->scan_rst.ble_adv[0], scan_result->scan_rst.adv_data_len);
            }
            if (scan_result->scan_rst.scan_rsp_len > 0) {
                ESP_LOGI(GATTC_TAG, "scan resp:");
                ESP_LOG_BUFFER_HEX(GATTC_TAG, &scan_result->scan_rst.ble_adv[scan_result->scan_rst.adv_data_len], scan_result->scan_rst.scan_rsp_len);
            }
#endif

            if (adv_name != NULL) {
                if ( strncmp((char *)scan_result->scan_rst.bda, remote_device_name, 6) == 0) {
                    // Note: If there are multiple devices with the same device name, the device may connect to an unintended one.
                    // It is recommended to change the default device name to ensure it is unique.

                    ESP_LOGI(GATTC_TAG, "Device found %s", remote_device_name);
                    if (connect == false) {
                        connect = true;
                        printf("compare true~~!!\n");
                        ESP_LOGI(GATTC_TAG, "Connect to the remote device");
                        esp_ble_gap_stop_scanning();
                        int flag = 0;
                        flag = esp_ble_gattc_open(gl_profile_tab[PROFILE_A_APP_ID].gattc_if, scan_result->scan_rst.bda, scan_result->scan_rst.ble_addr_type, true);
                        printf("flag = %d\n",flag);
                    }
                }
            }
            break;
        case ESP_GAP_SEARCH_INQ_CMPL_EVT:
            break;
        default:
            break;
        }
        break;
    }

    case ESP_GAP_BLE_SCAN_STOP_COMPLETE_EVT:
        if (param->scan_stop_cmpl.status != ESP_BT_STATUS_SUCCESS){
            ESP_LOGE(GATTC_TAG, "Scanning stop failed, status %x", param->scan_stop_cmpl.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Scanning stop successfully");
        break;

    case ESP_GAP_BLE_ADV_STOP_COMPLETE_EVT:
        if (param->adv_stop_cmpl.status != ESP_BT_STATUS_SUCCESS){
            ESP_LOGE(GATTC_TAG, "Advertising stop failed, status %x", param->adv_stop_cmpl.status);
            break;
        }
        ESP_LOGI(GATTC_TAG, "Advertising stop successfully");
        break;
    case ESP_GAP_BLE_UPDATE_CONN_PARAMS_EVT:
         ESP_LOGI(GATTC_TAG, "Connection params update, status %d, conn_int %d, latency %d, timeout %d",
                  param->update_conn_params.status,
                  param->update_conn_params.conn_int,
                  param->update_conn_params.latency,
                  param->update_conn_params.timeout);
        break;
    case ESP_GAP_BLE_SET_PKT_LENGTH_COMPLETE_EVT:
        ESP_LOGI(GATTC_TAG, "Packet length update, status %d, rx %d, tx %d",
                  param->pkt_data_length_cmpl.status,
                  param->pkt_data_length_cmpl.params.rx_len,
                  param->pkt_data_length_cmpl.params.tx_len);
        break;
    default:
        break;
    }
}

static void esp_gattc_cb(esp_gattc_cb_event_t event, esp_gatt_if_t gattc_if, esp_ble_gattc_cb_param_t *param)
{
    /* If event is register event, store the gattc_if for each profile */
    if (event == ESP_GATTC_REG_EVT) {
        if (param->reg.status == ESP_GATT_OK) {
            gl_profile_tab[param->reg.app_id].gattc_if = gattc_if;
        } else {
            ESP_LOGI(GATTC_TAG, "reg app failed, app_id %04x, status %d",
                    param->reg.app_id,
                    param->reg.status);
            return;
        }
    }

    /* If the gattc_if equal to profile A, call profile A cb handler,
     * so here call each profile's callback */
    do {
        int idx;
        for (idx = 0; idx < PROFILE_NUM; idx++) {
            if (gattc_if == ESP_GATT_IF_NONE || /* ESP_GATT_IF_NONE, not specify a certain gatt_if, need to call every profile cb function */
                    gattc_if == gl_profile_tab[idx].gattc_if) {
                if (gl_profile_tab[idx].gattc_cb) {
                    gl_profile_tab[idx].gattc_cb(event, gattc_if, param);
                }
            }
        }
    } while (0);
}
// void Get_Mac_Init(void )
// {
//     uint8_t ble_mac[10] = {0};
//     char temp[10] = {0};
//     char temp1[20] = {0};
//     esp_read_mac(ble_mac, ESP_MAC_BT);


//     //sprintf(temp, "%02X%02X", ble_mac[4], ble_mac[5]);

//     raw_adv_data[sizeof(raw_adv_data) - 4] = temp[0];
//     raw_adv_data[sizeof(raw_adv_data) - 3] = temp[1];
//     raw_adv_data[sizeof(raw_adv_data) - 2] = temp[2];
//     raw_adv_data[sizeof(raw_adv_data) - 1] = temp[3];

//     // ESP_LOGW(GATTS_TABLE_TAG, "BLE_MAC IS %s : ",
//     //                 &raw_adv_data[11]);
//     // ESP_LOGW(GATTS_TABLE_TAG, "BLE_MAC IS %s : ",
//     //                 temp);

//     //printf("My MAC:\n");
//     esp_log_buffer_hex(GATTS_TABLE_TAG, ble_mac, 6);

//     BT_Device_Name[sizeof(BT_Device_Name) - 5] = temp[0];
//     BT_Device_Name[sizeof(BT_Device_Name) - 4] = temp[1];
//     BT_Device_Name[sizeof(BT_Device_Name) - 3] = temp[2];
//     BT_Device_Name[sizeof(BT_Device_Name) - 2] = temp[3];

//     raw_adv_data[11] = ble_mac[0];
//     raw_adv_data[12] = ble_mac[1];
//     raw_adv_data[13] = ble_mac[2];
//     raw_adv_data[14] = ble_mac[3];
//     raw_adv_data[15] = ble_mac[4];
//     raw_adv_data[16] = ble_mac[5];

//     //sprintf(temp1, "%02X%02X%02X%02X%02X%02X", ble_mac[0], ble_mac[1], ble_mac[2], ble_mac[3], ble_mac[4], ble_mac[5]);


//     for(int i=0; i<12; i++)
//     {
//         char_value[i] = temp1[i];
//     }
// }
uint8_t bledisconnectflag = 0;
void ble_send(void)
{

    // if(bledisconnectflag == 1)
    // {
    //     // esp_ble_gattc_close(blesend,gl_profile_tab[PROFILE_A_APP_ID].conn_id);
    // }
    // else
    // {
        if(blesend != 0)
        {
            esp_ble_gattc_write_char( blesend,
                gl_profile_tab[PROFILE_A_APP_ID].conn_id,
                gl_profile_tab[PROFILE_A_APP_ID].char_handle,
                sizeof(write_char_data),
                write_char_data,
                ESP_GATT_WRITE_TYPE_RSP,
                ESP_GATT_AUTH_REQ_NONE);
        }
    // }


}
void bsp_Ble_Init(void)
{
    // Initialize NVS.
    esp_err_t ret = nvs_flash_init();
    if (ret == ESP_ERR_NVS_NO_FREE_PAGES || ret == ESP_ERR_NVS_NEW_VERSION_FOUND) {
        ESP_ERROR_CHECK(nvs_flash_erase());
        ret = nvs_flash_init();
    }
    ESP_ERROR_CHECK( ret );

    #if CONFIG_EXAMPLE_CI_PIPELINE_ID
    memcpy(remote_device_name, esp_bluedroid_get_example_name(), sizeof(remote_device_name));
    #endif

    // ESP_ERROR_CHECK(esp_bt_controller_mem_release(ESP_BT_MODE_CLASSIC_BT));

    // esp_bt_controller_config_t bt_cfg = BT_CONTROLLER_INIT_CONFIG_DEFAULT();
    // ret = esp_bt_controller_init(&bt_cfg);
    // if (ret) {
    //     ESP_LOGE(GATTC_TAG, "%s initialize controller failed: %s", __func__, esp_err_to_name(ret));
    //     return;
    // }

    // ret = esp_bt_controller_enable(ESP_BT_MODE_BLE);
    // if (ret) {
    //     ESP_LOGE(GATTC_TAG, "%s enable controller failed: %s", __func__, esp_err_to_name(ret));
    //     return;
    // }

    // ret = esp_bluedroid_init();
    // if (ret) {
    //     ESP_LOGE(GATTC_TAG, "%s init bluetooth failed: %s", __func__, esp_err_to_name(ret));
    //     return;
    // }

    // ret = esp_bluedroid_enable();
    // if (ret) {
    //     ESP_LOGE(GATTC_TAG, "%s enable bluetooth failed: %s", __func__, esp_err_to_name(ret));
    //     return;
    // }

    //register the  callback function to the gap module
    ret = esp_ble_gap_register_callback(esp_gap_cb);
    if (ret){
        ESP_LOGE(GATTC_TAG, "%s gap register failed, error code = %x", __func__, ret);
        return;
    }

    //register the callback function to the gattc module
    ret = esp_ble_gattc_register_callback(esp_gattc_cb);
    if(ret){
        ESP_LOGE(GATTC_TAG, "%s gattc register failed, error code = %x", __func__, ret);
        return;
    }

    ret = esp_ble_gattc_app_register(PROFILE_A_APP_ID);
    if (ret){
        ESP_LOGE(GATTC_TAG, "%s gattc app register failed, error code = %x", __func__, ret);
    }
    esp_err_t local_mtu_ret = esp_ble_gatt_set_local_mtu(500);
    if (local_mtu_ret){
        ESP_LOGE(GATTC_TAG, "set local  MTU failed, error code = %x", local_mtu_ret);
    }

}
