#ifndef _GTTP_SERVER_H_
#define _GTTP_SERVER_H_

#include "esp_event.h"
#include "esp_http_server.h"

#define HTTP_SERVER_STOP 0
#define HTTP_SERVER_INIT 1
#define HTTP_SERVER_START 2
#define HTTP_SERVER_DEINIT 3

#define MAX_OTA_BUFF 4096u

extern char buf[MAX_OTA_BUFF];
extern httpd_handle_t http_server;

/**
 * 根据某种状态自动开关webserver的监听处理,
 * 任意STA连接AP，自动开启webserver.
 */
void connect_handler(void *arg);

/**
 * 根据某种状态自动开关webserver的监听处理,
 * 没有任何STA连接AP，自动关闭webserver,
 */
void disconnect_handler(void *arg);

/**
 * 开启HTTP服务器
 * @return httpd_handle_t 结构体
 */
httpd_handle_t http_service(void);

#endif
