#ifndef _SOFTAP_H_
#define _SOFTAP_H_

#include "esp_wifi.h"
#include "http_server.h"

#define SOFTAP_STOP 0
#define SOFTAP_INIT 1
#define SOFTAP_START 2
#define SOFTAP_DEINIT 3

#define STA_CONNECTED_NEVER 0
#define STA_CONNECTED_ONCE 1

#define ESP_WIFI_SSID "ESP32S3_AP_"
#define ESP_WIFI_PASSWD "12345677"

extern wifi_sta_list_t softap_sta_list;
extern unsigned char softap_sta_connect;

/**
 * 开启 WiFi 服务
 */
void softap_service_start(void);

/**
 * 关闭 WiFi 服务
 */
void softap_service_stop(void);

#endif
