#ifndef _WIFI_SERVICE_H_
#define _WIFI_SERVICE_H_

#include "softap.h"

#define WIFI_SERVICE_STOP 0
#define WIFI_SERVICE_INIT 1
#define WIFI_SERVICE_START 2
#define WIFI_SERVICE_DEINIT 3

typedef struct
{
    unsigned char status;
    unsigned char softap_status;      // 暂时用不上 2024.05.08
    unsigned char http_server_status; // 暂时用不上 2024.05.08
    unsigned char ota_partition;      // 暂时用不上 2024.05.08
} wifi_service_t;

extern wifi_service_t wifi_service_info;

/**
 * 初始化 WiFi 服务状态
 */
void wifi_service_init(void);

/**
 * WiFi 服务计时器
 */
void wifi_service_timer(void);

/**
 * WiFi 服务自动关闭计时器的重置函数
 */
void wifi_service_stop_timer_clear(void);

/**
 * WiFi 服务启停控制
 */
void wifi_service(void);

#endif
