#include "Data_VehicleSpeed.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "Common_Interface.h"

uint16_t Vehicle_ACT_Speed;
uint16_t Vehicle_DISP_Speed;
uint8_t  VehicleSpeedValid;

void Speed_Value_Reset(void)
{
    Vehicle_ACT_Speed  = 0u;
    Vehicle_DISP_Speed = 0u;
    VehicleSpeedValid  = 0u;
}

void Speed_KL30_Init(void)
{
    Speed_Value_Reset();
}

void Speed_KL15_ON_Init(void)
{
    Speed_Value_Reset();
}

void Speed_Processing_Service(void) //20mS
{
    uint8_t  IgnSts = Common_Get_IG_Sts();
    uint32_t OnTime = Common_GetIgnOnTime(); 

    if (IgnSts == 1u)
    {
        uint32_t u32Result = Get_ID_18F101D0_Sig_VCU_VhclSpd();
            
        if ((u32Result > 0xFF00) || (CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_LOST))
        {
            VehicleSpeedValid = 0;
            u32Result         = 0;
        }
        else
        {
            VehicleSpeedValid = 1;
        }
        
        u32Result *= 10UL;
        u32Result /= 256UL;
        
        Vehicle_ACT_Speed = (uint16_t)u32Result;
        
        //u32Result = u32Result * 105ul / 100ul;

        if (Vehicle_ACT_Speed <= 9)
        {
            Vehicle_DISP_Speed = 0u;
        }
        else
        {
            if (u32Result > 1990)
            {
                u32Result = 1990;
            }
            
            Vehicle_DISP_Speed = (uint16_t)u32Result;
        }
    }
    else 
    {
        Speed_Value_Reset();
    }
}

uint16_t Speed_Get_ActualValue(void)
{
    return Vehicle_ACT_Speed;
}

uint16_t Speed_Get_Display_Value(void)
{
    return Vehicle_DISP_Speed;
}

uint8_t Speed_Get_Valid(void)
{
    return VehicleSpeedValid;
}
