#ifndef AIRPRESSURE_H
#define AIRPRESSURE_H

#include "TYW_stdint.h"

typedef struct
{
    uint16_t Value;
    uint8_t  Valid;
    uint8_t  LostT;
    uint16_t Buff[8];
    uint8_t  Numb;
} _AirPressure_Struct;

extern _AirPressure_Struct AirPressure_F;
extern _AirPressure_Struct AirPressure_R;

void AirPressure_RESET(void);
void AirPressure_KL30_Init(void);
void AirPressure_KL15_ON_Init(void);
void AirPressure_Processing(uint8_t u8ADCCh, _AirPressure_Struct *AirPressure);
void AirPressure_Processing_Service(void);

uint16_t AirPressure_Get_Value(uint8_t Pos);
uint8_t  AirPressure_Get_Valid(uint8_t Pos);

#endif
