/**********************************************************************************************************
 * Copyright(C) 2017, HeiLongJiang TYW Co.,Ltd.
 *
 * @Filename:     	Popup_Lib.c
 *
 * @Description:  	前台显示链表
 *
 * @Functions List:
 *
 *
 * @History:       	Version: 		    V0.0.1
				    Date:      	  	    2018-05-02 09:46
                    Author: 		    myliu
                    Modification:       creat
 **********************************************************************************************************/
#ifndef _POPUP_LIB_H
#define _POPUP_LIB_H

/**********************************************************************************************************
 * Include
*/

/**********************************************************************************************************
 * Constants and defines
 */
/*
Platform_32Bit
Platform_16Bit
*/
#ifdef Platform_16Bit
    #define Popuplib_uint8_t  unsigned char
    #define Popuplib_uint16_t unsigned int
    #define Popuplib_uint32_t unsigned long
#else
    #define Popuplib_uint8_t  unsigned char
    #define Popuplib_uint16_t unsigned short
    #define Popuplib_uint32_t unsigned int
    #define Popuplib_uint64_t unsigned long long
#endif

#ifndef POPUPLIB_NULL
  #define POPUPLIB_NULL       0u
#endif /* NULL */

#define POPUP_LIB_OK          0u
#define POPUP_LIB_CBK_ERR     1u
#define POPUP_LIB_MEM_ERR     2u

typedef void (*PopupLib_IRQ_Enable)(void);
typedef void (*PopupLib_IRQ_Disable)(void);

typedef struct
{
    Popuplib_uint8_t data[8];
}CommMemBuf_t;

struct PopupList
{
    Popuplib_uint16_t  PopupID;
    Popuplib_uint8_t   Status;
    struct PopupList  *next;
};

typedef struct
{
    Popuplib_uint8_t        Type;
    Popuplib_uint8_t        Priority;
    Popuplib_uint8_t        SubPriority;
    Popuplib_uint8_t        IGNStatus;
    Popuplib_uint8_t        Class;
    const Popuplib_uint8_t  *pMbrList;
    Popuplib_uint8_t        MbrCnt;
    Popuplib_uint8_t        Message;
    Popuplib_uint8_t        DispMode;
    Popuplib_uint8_t        Snd;
    Popuplib_uint8_t        SndMode;
} Popup_Attribute_t;

typedef struct
{
    const Popup_Attribute_t *pPopupAttributeTable;
    CommMemBuf_t            *CommMemBuf;
    Popuplib_uint16_t        MaxCommMenSize;
    PopupLib_IRQ_Enable      IRQ_Enable;
    PopupLib_IRQ_Disable     IRQ_Disable;
} PopupList_Opt_t;

/**********************************************************************************************************
 * Local variables
 */

/**********************************************************************************************************
 * Local functions
 */

/**********************************************************************************************************
 * Global variables
 */

/**********************************************************************************************************
 * Global functions
 */
/**********************************************************************************************************
 *@Function: 			PopupList_Init
 *@Description: 	    链表初始化
 *@Calls: 				MY_MemInit/CommMemMalloc
 *@Updated: 			V0.0.1
 *@Input: 				none
 *@Return: 				PopupList_Opt_t *pPopupListOpt -- 回调
 *@Note:   				none
 **********************************************************************************************************/
Popuplib_uint8_t PopupList_Init ( PopupList_Opt_t  *pPopupListOpt);

/**********************************************************************************************************
 *@Function: 			PopupList_Malloc
 *@Description: 	链表内存申请
 *@Calls: 				CommMemMalloc
 *@Updated: 			V0.0.1
 *@Input: 				none
 *@Return: 				struct PopupList *head -- 内存指针
 *@Note:   				none
 **********************************************************************************************************/
struct PopupList *PopupList_Malloc ( void );

/**********************************************************************************************************
 *@Function: 			PopupList_Select
 *@Description: 	读取链表
 *@Calls: 				STM32_Lib_3.30
 *@Updated: 			V0.0.1
 *@Input: 				none
 *@Return: 				struct PopupList *head -- 头链表
 *@Note:   				none
 **********************************************************************************************************/
struct PopupList *PopupList_Select ( struct PopupList *head, Popuplib_uint16_t *pPopupID );

/**********************************************************************************************************
 *@Function: 			PopupList_Insert
 *@Description: 	链表插入操作
 *@Calls: 				STM32_Lib_3.30
 *@Updated: 			V0.0.1
 *@Input: 				struct PopupList *head -- 头链表
 *              	struct PopupList *newList -- 需插入链表
 *@Return: 				struct PopupList *head -- 头链表
 *@Note:   				none
 **********************************************************************************************************/
struct PopupList *PopupList_Insert ( struct PopupList *head, struct PopupList *newList );

/**********************************************************************************************************
 *@Function: 			PopupList_Delete
 *@Description: 	删除固定编号的消息
 *@Calls: 				STM32_Lib_3.30
 *@Updated: 			V0.0.1
 *@Input: 				uint8_t num -- 消息编号
 *@Return: 				struct PopupList *RecvMsgPollHead -- 消息池头
 *@Note:   				none
 **********************************************************************************************************/
struct PopupList *PopupList_Delete ( struct PopupList *head, Popuplib_uint16_t PopupID );

/**********************************************************************************************************
 *@Function: 			PopupList_Destroy
 *@Description:		消息池销毁操作
 *@Calls: 				STM32_Lib_3.30
 *@Updated: 			V0.0.1
 *@Input:					none
 *@Return: 				struct PopupList *head -- 消息池头
 *@Note:   				none
 **********************************************************************************************************/
struct PopupList *PopupList_Destroy ( struct PopupList *head );

/**********************************************************************************************************
 **********************************************************************************************************/
#endif