
#ifndef _SOUND_LIST_H_
#define _SOUND_LIST_H_
#include "TYW_stdint.h"
#include "Sound_Source.h"

#define SND_TOTAL_NUMBER SND_INDEX_MAX

/******************************************************************************
声音报警列表
******************************************************************************/
typedef enum SoundName
{
    SND_VCU_SYS1 = 0x00,
    SND_VCU_SYS2,
    SND_VCU_SYS3,

    SND_VCU_EPS1,
    SND_VCU_EPS2,
    SND_VCU_EPS3,
    
    SND_VCU_ACM1,
    SND_VCU_ACM2,
    SND_VCU_ACM3,

    SND_VCU_DCDC1,
    SND_VCU_DCDC2,
    SND_VCU_DCDC3,

    SND_VCU_PDU1,
    SND_VCU_PDU2,
    SND_VCU_PDU3,

    SND_VCU_MCU1,
    SND_VCU_MCU2,
    SND_VCU_MCU3,

    SND_BMS_BMS1,
    SND_BMS_BMS2,
    SND_BMS_BMS3,
    
    SND_Maintenance,
    SND_OvrECUSpd,
    SND_OvrSpd,
    SND_Door,
    SND_Seatbelt,
    SND_ParkingOn,
    SND_ParkingOff,
    
    SND_TICK,                /*转向*/
    SND_TOCK,                /*转向*/ 

    SND_Stop,

    SND_LeaveSeat,

    SND_INDEX_MAX,

} SoundName_en_t;

/******************************************************************************
伪声音列表
******************************************************************************/
#define SND_NONE            0xFF
/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    SND_SRC_Index_en_t Src; //音源
    uint8_t Type;           //类型
} SoundAttributeStruct;

#define SND_TYPE_NORMAL 0x00  //普通声音类型
#define SND_TYPE_MULTI  0x01  //可多次触发的声音ADAR
#define SND_TYPE_RADAR  0x02  //雷达声音类型
/******************************************************************************
声音属性列表
******************************************************************************/
static const SoundAttributeStruct SoundList[SND_INDEX_MAX] =
{
    /*=================================================================
             声音名称         |        音源         |        模式
    -----------------------------------------------------------------*/
    { /*00 SND_VCU_SYS1,    */ SND_SRC_VCU_SYS1,    SND_TYPE_NORMAL, },
    { /*01 SND_VCU_SYS2,    */ SND_SRC_VCU_SYS2,    SND_TYPE_NORMAL, },
    { /*02 SND_VCU_SYS3,    */ SND_SRC_VCU_SYS3,    SND_TYPE_NORMAL, },
    
    { /*03 SND_VCU_EPS1,    */ SND_SRC_VCU_EPS1,    SND_TYPE_NORMAL, },
    { /*04 SND_VCU_EPS2,    */ SND_SRC_VCU_EPS2,    SND_TYPE_NORMAL, },
    { /*05 SND_VCU_EPS3,    */ SND_SRC_VCU_EPS3,    SND_TYPE_NORMAL, },

    { /*06 SND_VCU_ACM1,    */ SND_SRC_VCU_ACM1,    SND_TYPE_NORMAL, },
    { /*07 SND_VCU_ACM2,    */ SND_SRC_VCU_ACM2,    SND_TYPE_NORMAL, },
    { /*08 SND_VCU_ACM3,    */ SND_SRC_VCU_ACM3,    SND_TYPE_NORMAL, },

    { /*09 SND_VCU_DCDC1,   */ SND_SRC_VCU_DCDC1,   SND_TYPE_NORMAL, },
    { /*10 SND_VCU_DCDC2,   */ SND_SRC_VCU_DCDC2,   SND_TYPE_NORMAL, },
    { /*11 SND_VCU_DCDC3,   */ SND_SRC_VCU_DCDC3,   SND_TYPE_NORMAL, },

    { /*12 SND_VCU_PDU1,    */ SND_SRC_VCU_PDU1,    SND_TYPE_NORMAL, },
    { /*13 SND_VCU_PDU2,    */ SND_SRC_VCU_PDU2,    SND_TYPE_NORMAL, },
    { /*14 SND_VCU_PDU3,    */ SND_SRC_VCU_PDU3,    SND_TYPE_NORMAL, },

    { /*15 SND_VCU_MCU,     */ SND_SRC_VCU_MCU1,    SND_TYPE_NORMAL, },
    { /*16 SND_VCU_MCU,     */ SND_SRC_VCU_MCU2,    SND_TYPE_NORMAL, },
    { /*17 SND_VCU_MCU,     */ SND_SRC_VCU_MCU3,    SND_TYPE_NORMAL, },

    { /*18 SND_BMS_BMS,     */ SND_SRC_BMS_BMS1,    SND_TYPE_NORMAL, },
    { /*19 SND_BMS_BMS,     */ SND_SRC_BMS_BMS2,    SND_TYPE_NORMAL, },
    { /*20 SND_BMS_BMS,     */ SND_SRC_BMS_BMS3,    SND_TYPE_NORMAL, },

    { /*21 SND_Maintenance, */ SND_SRC_Maintenance, SND_TYPE_NORMAL, },
    { /*22 SND_OvrECUSpd,   */ SND_SRC_OvrECUSpd,   SND_TYPE_MULTI,  },
    { /*23 SND_OvrSpd,      */ SND_SRC_OvrSpd,      SND_TYPE_NORMAL, },
    { /*24 SND_Door,        */ SND_SRC_Door,        SND_TYPE_NORMAL, },
    { /*25 SND_Seatbelt,    */ SND_SRC_Seatbelt,    SND_TYPE_NORMAL, },
    { /*26 SND_ParkingOn,   */ SND_SRC_ParkingOn,   SND_TYPE_NORMAL, },
    { /*27 SND_ParkingOff,  */ SND_SRC_ParkingOff,  SND_TYPE_NORMAL, },
    { /*28 SND_TICK,        */ SND_SRC_TICK,        SND_TYPE_NORMAL, },
    { /*29 SND_TOCK,        */ SND_SRC_TOCK,        SND_TYPE_NORMAL, },
    { /*30 SND_Stop,        */ SND_SRC_Stop,        SND_TYPE_RADAR,  },
    { /*31 SND_LeaveSeat,   */ SND_SRC_LeaveSeat,   SND_TYPE_RADAR,  },
    /*===============================================================*/
};

#endif