
#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "TYW_stdint.h"
#include "PCM_Sound_Tracks.h"

/******************************************************************************
音源名称列表

注意：音源名称所指代的序号应与该声音位于声音属性表中的序号一一对应
******************************************************************************/
typedef enum
{
    SND_SRC_VCU_SYS1 = 0x00, 
    SND_SRC_VCU_SYS2, 
    SND_SRC_VCU_SYS3, 

    SND_SRC_VCU_EPS1, 
    SND_SRC_VCU_EPS2, 
    SND_SRC_VCU_EPS3, 

    SND_SRC_VCU_ACM1,
    SND_SRC_VCU_ACM2,
    SND_SRC_VCU_ACM3,

    SND_SRC_VCU_DCDC1,
    SND_SRC_VCU_DCDC2,
    SND_SRC_VCU_DCDC3,

    SND_SRC_VCU_PDU1, 
    SND_SRC_VCU_PDU2, 
    SND_SRC_VCU_PDU3, 

    SND_SRC_VCU_MCU1,
    SND_SRC_VCU_MCU2,
    SND_SRC_VCU_MCU3,

    SND_SRC_BMS_BMS1,
    SND_SRC_BMS_BMS2,
    SND_SRC_BMS_BMS3,

    SND_SRC_Maintenance,
    SND_SRC_OvrECUSpd,
    SND_SRC_OvrSpd,
    SND_SRC_Door,
    SND_SRC_Seatbelt,
    SND_SRC_ParkingOn,
    SND_SRC_ParkingOff,
    
    SND_SRC_TICK,
    SND_SRC_TOCK,
    
    SND_SRC_Stop,

    SND_SRC_LeaveSeat,

    SND_SRC_INDEX_MAX,
} SND_SRC_Index_en_t;

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define   SND_SRC_NONE                      0xFF    //没有声音
#define   SND_SRC_CURRENT                   0xFE    //当前播放的声音

/******************************************************************************
音源循环次数
******************************************************************************/
#define   SND_CYCLE_NONSTOP                 0xFF    //不停播放

/******************************************************************************
音源播放模式
******************************************************************************/
#define   SND_MODE_SINGLE                   0x00    //使用ISD_Play_Vp方法播放
#define   SND_MODE_LOOP                     0x01    //使用ISD_Play_Vp_Loop方法播放

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    PCM_Track_Index_en_t  Index;
    uint8_t   Priority;
    uint8_t   Cycle;
    uint8_t   Mode;
    uint16_t  Period;
} SndAttributeStruct;

/******************************************************************************
音源属性表
******************************************************************************/
static const SndAttributeStruct SndAttributeTable[SND_SRC_INDEX_MAX] =
{
    /*================================================================================================
                音源名称             |           音源序号        |优先级 |循环次数|    播放模式    | 周期(ms)
    ------------------------------------------------------------------------------------------------*/
    {/*00 SND_SRC_VCU_SYS1    音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,  1000U,},
    {/*01 SND_SRC_VCU_SYS2    音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,  1000U,},
    {/*02 SND_SRC_VCU_SYS3    音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,  1000U,},

    {/*03 SND_SRC_VCU_EPS1    音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,  1000U,},
    {/*04 SND_SRC_VCU_EPS2    音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,  1000U,},
    {/*05 SND_SRC_VCU_EPS3    音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,  1000U,},

    {/*06 SND_SRC_VCU_ACM1    音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,   400U,},
    {/*07 SND_SRC_VCU_ACM2    音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,   400U,},
    {/*08 SND_SRC_VCU_ACM3    音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,   400U,},
     
    {/*09 SND_SRC_VCU_DCDC1   音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,  1000U,},
    {/*10 SND_SRC_VCU_DCDC2   音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,  1000U,},
    {/*11 SND_SRC_VCU_DCDC3   音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,  1000U,},

    {/*12 SND_SRC_VCU_PDU1    音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,   400U,},
    {/*13 SND_SRC_VCU_PDU2    音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,   400U,},
    {/*14 SND_SRC_VCU_PDU3    音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,   400U,},

    {/*15 SND_SRC_VCU_MCU1    音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,  1000U,},
    {/*16 SND_SRC_VCU_MCU2    音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,  1000U,},
    {/*17 SND_SRC_VCU_MCU3    音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,  1000U,},
    
    {/*18 SND_SRC_BMS_BMS1    音效6*/ PCM_Track_Index_Warrning,    3,      1,   SND_MODE_SINGLE,  1000U,},
    {/*19 SND_SRC_BMS_BMS2    音效0*/ PCM_Track_Index_Warrning,    2,      1,   SND_MODE_SINGLE,  1000U,},
    {/*20 SND_SRC_BMS_BMS3    音效2*/ PCM_Track_Index_Warrning,    1,      1,   SND_MODE_SINGLE,  1000U,},
    
    {/*21 SND_SRC_Maintenance 音效1*/ PCM_Track_Index_Warrning,    4,      1,   SND_MODE_SINGLE,  1000U,},
    {/*22 SND_SRC_OvrECUSpd   音效1*/ PCM_Track_Index_Warrning,    4,      1,   SND_MODE_SINGLE,  1000U,},
    {/*23 SND_SRC_OvrSpd      音效1*/ PCM_Track_Index_Warrning,    4,      2,   SND_MODE_SINGLE,  1000U,},
    {/*24 SND_SRC_Door        音效1*/ PCM_Track_Index_Warrning,    4,      1,   SND_MODE_SINGLE,  1000U,},
    {/*25 SND_SRC_Seatbelt    音效1*/ PCM_Track_Index_Warrning,    4,      1,   SND_MODE_SINGLE,  1000U,},
    {/*26 SND_SRC_ParkingOn   音效1*/ PCM_Track_Index_Warrning,    4,     30,   SND_MODE_SINGLE,  1000U,}, //20231013按20230928变更由播放1次改为30次
    {/*27 SND_SRC_ParkingOff  音效1*/ PCM_Track_Index_Warrning,    4,      1,   SND_MODE_SINGLE,  1000U,},
    
    {/*28 SND_SRC_TICK        音效7*/ PCM_Track_Index_TICK,        5,      1,   SND_MODE_SINGLE,     50,},
    {/*29 SND_SRC_TOCK        音效8*/ PCM_Track_Index_TOCK,        6,      1,   SND_MODE_SINGLE,     50,},

    {/*30 SND_SRC_Stop        音效0*/ PCM_Track_Index_Crash,       0,      1,   SND_MODE_SINGLE,   150U,},
    {/*31 SND_SRC_LeaveSeat   音效1*/ PCM_Track_Index_Warrning,    4,      1,   SND_MODE_SINGLE,  1000U,},
    /*==============================================================================================*/
};

#define   SND_TOTAL_NUM               SND_SRC_INDEX_MAX

#endif
