#include "stdlib.h"
#include "r_typedefs.h"
#include "init.h"
#include "Sys_Scheduler.h"
#include "Sys_Tick.h"

typedef struct
{
    uint8_t     ID2ms;
    uint8_t     ID5ms;
    uint8_t     ID10ms;
    uint8_t     ID20ms;
    uint8_t     ID50ms;
    uint8_t     ID100ms;
} Sys_Task_Group_st_t;

typedef struct
{
    uint16_t              msRocBak;
    Sys_Task_Group_st_t   TaskGroup;
} Sys_Scheduling_st_t;

Sys_Scheduling_st_t   SysScheduling;

static void Sys_Exact_50us_Task_Handler(void);
static void Sys_Exact_100ms_Task_Handler(void);


void Sys_Init(void)
{
    SysScheduling.msRocBak            =  0U;

    SysScheduling.TaskGroup.ID2ms     =  0U;
    SysScheduling.TaskGroup.ID10ms    =  0U;
    SysScheduling.TaskGroup.ID20ms    =  0U;
    SysScheduling.TaskGroup.ID50ms    =  0U;
    SysScheduling.TaskGroup.ID100ms   =  0U;

    Sys_Tick_Timer_Call_Back_Reg(SYS_TICK_50us_CB, Sys_Exact_50us_Task_Handler);
    Sys_Tick_Timer_Call_Back_Reg(SYS_TICK_1ms_CB, NULL);
    Sys_Tick_Timer_Call_Back_Reg(SYS_TICK_100ms_CB, Sys_Exact_100ms_Task_Handler);

    Sys_Startup_Init();
}

void Sys_Scheduling_Service(void)
{
    uint16_t u16msROC;

    Sys_Run_Mode_Pseudo_Real_Time_Tasks();

    u16msROC = SYS_ROLLING_COUNTER_1ms;
    if (u16msROC - SysScheduling.msRocBak >= 1U)
    {
        SysScheduling.msRocBak = u16msROC;

        SysScheduling.TaskGroup.ID2ms++;
        if (SysScheduling.TaskGroup.ID2ms >= 2u)
        {
            SysScheduling.TaskGroup.ID2ms = 0u;
            Sys_Run_Mode_2ms_Tasks();
        }
        SysScheduling.TaskGroup.ID5ms++;
        if (SysScheduling.TaskGroup.ID5ms >= 5u)
        {
            SysScheduling.TaskGroup.ID5ms = 0u;
            Sys_Run_Mode_5ms_Tasks();
        }
        SysScheduling.TaskGroup.ID10ms++;
        if (SysScheduling.TaskGroup.ID10ms >= 10u)
        {
            SysScheduling.TaskGroup.ID10ms = 0u;
            Sys_Run_Mode_10ms_Tasks();
        }
        SysScheduling.TaskGroup.ID20ms++;
        if (SysScheduling.TaskGroup.ID20ms >= 20u)
        {
            SysScheduling.TaskGroup.ID20ms = 0u;
            Sys_Run_Mode_20ms_Tasks();
        }
        SysScheduling.TaskGroup.ID50ms++;
        if (SysScheduling.TaskGroup.ID50ms >= 50u)
        {
            SysScheduling.TaskGroup.ID50ms = 0u;
            Sys_Run_Mode_50ms_Tasks();
        }
        SysScheduling.TaskGroup.ID100ms++;
        if (SysScheduling.TaskGroup.ID100ms >= 100u)
        {
            SysScheduling.TaskGroup.ID100ms = 0u;
            Sys_Run_Mode_100ms_Tasks();
        }
    }
}

static void Sys_Exact_50us_Task_Handler(void)
{
    Sys_Exact_50us_Tasks();
}

static void Sys_Exact_100ms_Task_Handler(void)
{
    Sys_Exact_100ms_Tasks();
}
