#include "Data_Gear.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"
#include "Telltales_user.h"
#include "Telltales.h"
#include "Common_Interface.h"

#pragma ghs section bss=".myNonInitArea" //buckupRAM区
uint8_t Gear_Sig_Value;
#pragma ghs section bss=default

/******************************************************************************
  Function��Data_Gear_KL30_Init
  Description���÷������״�KL30ʱ����һ��
  Input:
  Output:
 ******************************************************************************/
void Data_Gear_KL30_Init(void)
{
    Gear_Sig_Value = 0xFFu;
}
/******************************************************************************
  Function��Data_Gear_KL15_Init
  Description���÷������״�KL15ʱ����һ��
  Input:
  Output:
 ******************************************************************************/
void Data_Gear_KL15_Init(void)
{
    Gear_Sig_Value = 0xFFu;
}
/******************************************************************************
  Function��Data_Service_Gear_Processing
  Description��������������ݴ����ڴ˺����н��д���
  Input:
  Output:
 ******************************************************************************/
void Data_Service_Gear_Processing(void)
{
    uint8_t u8Result = 0xFFu;
    uint8_t u8Mode   = 0xFFu;
        
    if (CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_RECEIVE)
    {
        u8Result = Get_ID_18F101D0_Sig_VCU_GearSts();
    }
    
    if (CAN_MSG_Status(ID_VCU_SV_Msg_Count) == CAN_SIG_RECEIVE)
    {
        u8Mode = Get_ID_18F10BD0_Sig_VCU_DrivMode();
    }
    
    if ((CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_LOST)/*|| (CAN_MSG_Status(ID_VCU_SV_Msg_Count) == CAN_SIG_LOST)*/)
    {
        //if (Gear_Sig_Value != 8u)
        {
            Gear_Sig_Value = 10u;
        }
    }
    else if (CAN_MSG_Status(ID_VCU_SV_Msg_Count) != CAN_SIG_LOST)
    {
        Gear_Sig_Value = u8Result;

        if (u8Mode < 2u)
        {
            if (u8Result >= 2u)
            {
                Gear_Sig_Value = 9u; //D挡
            }
        }
        else if (u8Mode <= 5u)
        {
            ;
        }
        else
        {
            if (Gear_Sig_Value >= 2u)
            {
                Gear_Sig_Value = 10u;
            }
        }
    }
    else
    {
        Gear_Sig_Value = u8Result;
    }

    if (CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_RECEIVE)
    {
        if (u8Result < 2u)
        {
            Gear_Sig_Value = u8Result;
        }
    }
    
    if (Common_Get_IG_Sts() && (Common_GetIgnOnTime() < 4000u))
    {
        //Gear_Sig_Value = 0u;
        //return;
    } 
    
    if (LED_Get_Status(em_LED_Parking) && (Gear_Sig_Value == 0u) &&\
        (CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_RECEIVE)/* &&\
        (CAN_MSG_Status(ID_VCU_SV_Msg_Count) == CAN_SIG_RECEIVE)*/)
    {
        Gear_Sig_Value = 8u;
    }
}
/******************************************************************************
  Function��Get_Gear_Mode_Type
  Description��Get Gear  N/R/D1/D2/D3/D4/D5/D6
  Input:
  Output: N/R/D1/D2/D3/D4/D5/D6
 ******************************************************************************/
uint8_t Gear_Get_Value(void)
{
    return Gear_Sig_Value;
}
