#include "GaugesInterface.h"

/**@struct _GaugesInfoInit
*this is _GaugesInfoInit
*/
#include "Common_Interface.h"

/*水温配置参数*/
static const uint16_t   GaugesDataTempInit[5][3][25] =
{
    /*水温*/
    {   {38 , 40, 61, 71, 76,  81,  86, 101, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {38,  58, 68, 73, 78,  83,  98, 113, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        { 0 ,  1,  2,  3,  4,   5,   6,   7,   8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },

    {   {38 , 40, 61, 71, 76,  81,  86, 101, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {38,  58, 68, 73, 78,  83,  98, 108, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        { 0 ,  1,  2,  3,  4,   5,   6,   7,   8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },

    {   {38 , 40, 61, 71, 76,  81,  86, 101, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {38,  58, 68, 73, 78,  83,  98, 105, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        { 0 ,  1,  2,  3,  4,   5,   6,   7,   8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },

    {   {38 , 40, 61, 71, 76,  81,  86,  96, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {38,  58, 68, 73, 78,  83,  93, 101, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        { 0 ,  1,  2,  3,  4,   5,   6,   7,   8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },

    {   {38 , 40, 61, 71, 76,  81,  86,  96, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {38,  58, 68, 73, 78,  83,  93, 100, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        { 0 ,  1,  2,  3,  4,   5,   6,   7,   8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
};

static const uint16_t  GaugesDataInInit[GaugesTotal][3][25]  =
{
    /*车速*/
    {   {0, 200, 400, 600, 800, 1000, 1200, 1400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 200, 400, 600, 800, 1000, 1200, 1400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 309, 618, 927, 1236, 1545, 1854, 2163, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*转速*/
    {   {0u, 500, 1000, 1500, 2000, 2500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0u, 500, 1000, 1500, 2000, 2500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0u, 360, 720,  1440, 1800, 2160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*水温*/
    {   {38 , 40, 61, 71, 76,  81,  86, 101, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {38,  58, 68, 73, 78,  83,  98, 112, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0 ,  1,  2,  3,  4,   5,   6,  7,   8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*燃油*/
    {   {0, 100, 200, 300, 400, 500, 600, 700, 800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 100, 200, 300, 400, 500, 600, 700, 800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 1,   2,   3,   4,   5,   6,   7,   8,    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*气压1*/
    {   {0, 50, 213, 268, 322, 377, 431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 50, 213, 268, 322, 377, 431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0,   60,  80, 100, 120, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*气压2*/
    {   {0, 50, 213, 268, 322, 377, 431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 50, 213, 268, 322, 377, 431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0,   60,  80, 100, 120, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
};

/*指示类型*/                                              /*表头1        表头2        表头3        表头4*/    /*表头5-气压1*//*表头6-气压2*/
static const uint8_t  GaugesIndicatType[GaugesTotal] = {StepperMotor, StepperMotor, LEDTempType, FreeMoveType, LCDGasType, LCDGasType}; /*初始化表头显示类型，例如水温，气压*/
/*每个表头包含的参数个数*/                        /*表头1 表头2 表头3 表头4*/

static const uint8_t  GaugesParaNum[GaugesTotal] = {8,  6,   9,   9,    7,    7};

/*每个表头IGON后开始走动时间*/                          /*表头1 表头2 表头3 表头4 表头5  表头6*/
static const uint16_t  GaugesStarMoveTime[GaugesTotal] = {0,  0,   0,   0,   3000,   3000,};/*0是上电就开始走动，其他参数是ms*/
/*每个表头IGON后是否自检*/                          /*表头1 表头2 表头3 表头4 表头5  表头6*/
static const uint16_t  GaugesTest[GaugesTotal] = {1,  1,   1,   1,   0,   0,};/*1是自检，0不自检*/
uint16_t  RealDataIn[GaugesTotal];
_GaugesInfoInit GaugesInfo_Init_Table[GaugesTotal];
/**@brief User Gauge K30 Init function
* @author TYW
* @param[in] GaugeNum  Gauge Postion
* @param[in] GParam  Gauge Struct
* @since 1.0.0.0
*/
void UserGaugeK30Init(void)
{
    #if 0
    uint8_t i = 0u;
    uint8_t j = 0u;
    for(i = 0u; i < GaugesTotal; i++)
    {
        GaugesInfo_Init_Table[i] .SectorNum  = GaugesParaNum[i];
        GaugesInfo_Init_Table[i] .GaugesType = GaugesIndicatType[i];
        GaugesInfo_Init_Table[i] .GaugesDataIn =  &RealDataIn[i];
        GaugesInfo_Init_Table[i] .GaugesStartTime = GaugesStarMoveTime[i];
        GaugesInfo_Init_Table[i] .GaugesTestFlag = GaugesTest[i];
        if (i == TempGauges)
        {
            switch (Common_Get_Engine_Type())
            {
            case    Type_WP9H       :
            case    Type_WP10_5H    :
            case    Type_WP11S      :
            case    Type_WP10H      :
                if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[0][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[0][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[0][2][j];
                    }
                }
                break;
            case    Type_ISM    :
            case    Type_ISZ    :
                if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[2][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[2][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[2][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                    }
                }
                break;
            case    Type_WP8    :
                if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[3][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[3][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[3][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                    }
                }
                break;
            case     Type_WP12    :
                for (j = 0u; j < GaugesParaNum[i]; j++)
                {
                    GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                }
                break;
            case     Type_WP13    :
                if (
                    (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE) ||
                    (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
                )
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[3][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[3][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[3][2][j];
                    }
                }
                break;
            case    Type_WP7    :
                if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G6_VALUE)
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[3][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[3][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[3][2][j];
                    }
                }
                break;
            case    Type_L9       :
            case    Type_ISD6_7      /*D6.7 不知道对不对*/ :
            case    Type_M15       :
                for (j = 0u; j < GaugesParaNum[i]; j++)
                {
                    GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[2][0][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[2][1][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[2][2][j];
                }
                break;
            case    Type_Z14     /*不知道与哪个对应*/   :
                if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[4][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[4][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[4][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[2][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[2][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[2][2][j];
                    }
                }
                break;
            case    Type_X12       :
                for (j = 0u; j < GaugesParaNum[i]; j++)
                {
                    GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[3][0][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[3][1][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[3][2][j];
                }
                break;
            case    Type_X13       :
                for (j = 0u; j < GaugesParaNum[i]; j++)
                {
                    GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[4][0][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[4][1][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[4][2][j];
                }
                break;
            //case    Type_    /*玉柴G5*/   :
            //    if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
            //    {
            //        for (j = 0u; j < GaugesParaNum[i]; j++)
            //        {
            //            GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[4][0][j];
            //            GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[4][1][j];
            //            GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[4][2][j];
            //        }
            //    }
            //    else    /*故意填的放错默认值*/
            //    {
            //        for (j = 0u; j < GaugesParaNum[i]; j++)
            //        {
            //            GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[0][0][j];
            //            GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[0][1][j];
            //            GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[0][2][j];
            //        }
            //    }
            //    break;
            case    Type_WP15LNG      :
            case    Type_WP15CNG      :
            case    Type_WP13LNG      :
            case    Type_WP13CNG      :
            case    Type_WP12LNG      :
            case    Type_WP12CNG      :
            case    Type_WP10LNG      :
            case    Type_WP10CNG      :
            case    Type_WP6_7LNG     :
            case    Type_WP6_7CNG     :
            case    Type_WP5LNG       :
            case    Type_WP5CNG       :
            case    Type_WP4_6LNG     :
            case    Type_WP4_6CNG     :
            case    Type_KMSTRQ       :
            case    Type_HPDI         :
            case    Type_WP10HLNG     :
            case    Type_WP10HCNG     :
            case    Type_WP11SLNG     :
            case    Type_WP11SCNG     :
            case    Type_YCK11        :
            case    Type_6K13N        :
                if (Common_Get_EngineG5G6_Type() ==  ENGINE_TYPE_G5_VALUE)
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[1][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[1][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[1][2][j];
                    }
                }
                else
                {
                    for (j = 0u; j < GaugesParaNum[i]; j++)
                    {
                        GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[4][0][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[4][1][j];
                        GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[4][2][j];
                    }
                }
                break;
            default :
                for (j = 0u; j < GaugesParaNum[i]; j++)
                {
                    GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataTempInit[0][0][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataTempInit[0][1][j];
                    GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataTempInit[0][2][j];
                }
                break;
            }
        }
        else
        {
            for (j = 0u; j < GaugesParaNum[i]; j++)
            {
                GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataInInit[i][0][j];
                GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataInInit[i][1][j];
                GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataInInit[i][2][j];
            }
        }

    }
    GaugesK15Init_OFF();
    #endif
}

/**@brief User Gauge K15 Init function
* @author TYW
* @param[in] GaugeNum  Gauge Postion
* @param[in] GParam  Gauge Struct
* @since 1.0.0.0
*/
void UserGaugeK15Init(void)
{
    uint8_t i = 0u;
    uint8_t j = 0u;
    for(i = 0u; i < GaugesTotal; i++)
    {
        GaugesInfo_Init_Table[i] .SectorNum  = GaugesParaNum[i];
        GaugesInfo_Init_Table[i] .GaugesType = GaugesIndicatType[i];
        GaugesInfo_Init_Table[i] .GaugesDataIn =  &RealDataIn[i];
        GaugesInfo_Init_Table[i] .GaugesStartTime = GaugesStarMoveTime[i];
        GaugesInfo_Init_Table[i] .GaugesTestFlag = GaugesTest[i];

        for(j = 0u; j < GaugesParaNum[i]; j++)
        {
            GaugesInfo_Init_Table[i] .ReferenceDataInUp[j] =   GaugesDataInInit[i][0][j];
            GaugesInfo_Init_Table[i] .ReferenceDataInDown[j] = GaugesDataInInit[i][1][j];
            GaugesInfo_Init_Table[i] .ReferenceDataInOut[j] =  GaugesDataInInit[i][2][j];

        }
    }
    GaugesK15Init_ON();
}
/**@brief Gauge Schedule function
* @author TYW
* @param[in] GaugeNum  Gauge Postion
* @param[in] GParam  Gauge Struct
* @since 1.0.0.0
*/
void UserGaugeSchedule(void)
{
    uint8_t i = 0u;

    for(i = 0u; i < GaugesTotal; i++)
    {
        GaugeSchedule(i, &GaugesInfo_Init_Table[i]);

    }
}

/**@brief Set Gauges Paragram function
* @author TYW
* @param[in] GaugesID  Gauge Name
* @param[in] GaugesVal  Gauges Val
* @since 1.0.0.0
*/
void SetGaugesPara(uint8_t GaugesID,uint16_t GaugesVal)
{
    RealDataIn[GaugesID] = GaugesVal;
}

/**@brief Get Gauges Max Out Val function
* @author TYW
* @param[in] GaugesID  Gauge Name
* @since 1.0.0.0
*/
uint16_t GetGaugesMaxOutVal(uint8_t GaugesID)
{

    return GaugesInfo_Init_Table[GaugesID] .ReferenceDataInOut[GaugesParaNum[GaugesID] - 1u] ;
}

/**@brief Set Gauges Up Val function
* @author TYW
* @param[in] GaugesID  Gauge Name
* @param[in] GaugesVal  Gauges Val
* @since 1.0.0.0
*/
void SetGaugesUpVal(uint8_t GaugesID,uint16_t GaugesUpVal[])
{
    uint8_t i;
    
    for (i = 0u; i < GaugesParaNum[GaugesID]; i++)
    {
        GaugesInfo_Init_Table[GaugesID] .ReferenceDataInUp[i] = GaugesUpVal[i];
    }
  
}

/**@brief Set Gauges Dwom Val function
* @author TYW
* @param[in] GaugesID  Gauge Name
* @param[in] GaugesVal  Gauges Val
* @since 1.0.0.0
*/
void SetGaugesDownVal(uint8_t GaugesID,uint16_t GaugesDownVal[])
{
    uint8_t i;
    
    for (i = 0u; i < GaugesParaNum[GaugesID]; i++)
    {
        GaugesInfo_Init_Table[GaugesID] .ReferenceDataInDown[i] = GaugesDownVal[i];
    }
}

/**@brief Set Gauges Out Val function
* @author TYW
* @param[in] GaugesID  Gauge Name
* @param[in] GaugesVal  Gauges Val
* @since 1.0.0.0
*/
void SetGaugesOutVal(uint8_t GaugesID,uint16_t GaugesOutVal[])
{
    uint8_t i;
    
    for (i = 0u; i < GaugesParaNum[GaugesID]; i++)
    {
        GaugesInfo_Init_Table[GaugesID] .ReferenceDataInOut[i] =  GaugesOutVal[i];
    }
}
