#include "Seg_Ref.h"
#include "devassert.h"
#include "BU98R10.h"

static uint8_t SEG_BU98_Array[BU98_CHIP_MAX][BU98R10_SEG_MAX];

void SEG_BUFF_Init(void)
{
    BU98_CHIP_NUM_t chip_num;
    BU98_SEG_NUM_t seg_num;

    for (chip_num = BU98_CHIP0; chip_num < BU98_CHIP_MAX; chip_num++)
    {
        for (seg_num = SEG_REDEFINE_0; seg_num < BU98R10_SEG_MAX; seg_num++)
        {
            SEG_BU98_Array[chip_num][seg_num] = 0u;
        }
    }
}

void SEG_BUFF_Set(BU98_CHIP_NUM_t chip_num, BU98_SEG_NUM_t seg_num, uint8_t value)
{
    DevAssert(chip_num < BU98_CHIP_MAX);
    DevAssert(seg_num < BU98R10_SEG_MAX);

#if defined(COLOR_SEG)
    DevAssert(value <= 7u);
#elif defined(MONO_SEG)
    DevAssert(value <= 1u);
#else
    DevAssert(value <= 1u);
#endif

    if ((chip_num < BU98_CHIP_MAX) && (seg_num < BU98R10_SEG_MAX) && (value <= 7u))
    {
        SEG_BU98_Array[chip_num][seg_num] = value;
    }
}

void Seg_Buffer_Commit(void)
{
    uint8_t i = 0u;

    for (i = 0u; i < 90u; i++)
    {
        BU98R10Chip0DDRAM.Byte[i] = SEG_BU98_Array[0][i * 2] + SEG_BU98_Array[0][i * 2 + 1] * 16;
        BU98R10Chip1DDRAM.Byte[i] = SEG_BU98_Array[1][i * 2] + SEG_BU98_Array[1][i * 2 + 1] * 16;
    }
}
