#include "Speed_PPK_Out.h"
#include "RTE_PWM_OUT.h"
#include "Common_Interface.h"

#define Speed_Clock 64453u  /*PWM时钟512分频之后*/

uint16_t Speed_PPK_Calc(uint16_t V_Speed, uint16_t m_PPK)
{
    uint32_t Frequency;
    Frequency = (uint32_t)V_Speed / 10u;
    Frequency = (uint32_t)(Frequency * m_PPK);
    Frequency = Frequency / 3600u;
    return (uint16_t)Frequency;
}

void Speed_PPK_Processing(void)
{
    uint16_t Frequency;
    uint16_t m_Clock;
    uint16_t m_Duty;
    if (Common_Get_IG_Sts() == 1u)
    {
        if (Common_Get_Act_V_Speed_Valid() == 1u)
        {
            Frequency = Speed_PPK_Calc(Common_Get_Act_V_Speed(), S51EV_NM);
        }
        else
        {
            Frequency = 0u;
        }
    }
    else
    {
        Frequency = 0u;
    }
    if (Frequency == 0u)
    {
        Frequency = 0u;
    }
    else if (Frequency >= 1u)
    {
        Frequency = Frequency;
    }
    else
    {
        Frequency = 1u;
    }
    if (Frequency != 0u)
    {
        m_Clock =  Frequency;
        m_Duty = 500u;
    }
    else
    {
        m_Clock = 1u;
        m_Duty = 0u;
    }


    RTE_PWM_Set_Speed_Out(m_Clock, m_Duty);
}
