#include "Data_ReversingImage.h"
#include "CAN_Communication_Matrix.h"
#include "loc_graphics.h"
#include "Common_Interface.h"
#include "GUI.h"
#include "Key.h"
#include "CVBS.h"
#include "Data_Gear.h"

unsigned char ReversingImage_Enable_Flag = 0u;
e_CVBS_Ctrl_Step ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Default;
e_ReversingImageCMD InputReversingImageCMD = em_ReversingImageCMD_NoAct;
unsigned char ReversingImage_InitComplete = 0u;

//static void ReversingImage_Clear_Sprite(void);

void ReversingImage_KL30_Init(void)
{
    ReversingImage_Enable_Flag = 0u;
    ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Closed;//em_CVBS_Ctrl_Step_Default;
    InputReversingImageCMD = em_ReversingImageCMD_NoAct;
    ReversingImage_InitComplete = 0u;
}

void ReversingImage_KL15_Init(void)
{
    ReversingImage_Enable_Flag = 0u;
    
    if (ReversingImage_CVBS_Ctrl_Step != em_CVBS_Ctrl_Step_Closed)
    {
        ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Default;
        ReversingImage_InitComplete = 0u;
    }
    
    InputReversingImageCMD = em_ReversingImageCMD_NoAct;
}

void ReversingImage_KL15_OFF_Init(void)
{
    ReversingImage_Enable_Flag = 0u;
    
    if (ReversingImage_CVBS_Ctrl_Step != em_CVBS_Ctrl_Step_Closed)
    {
        ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Default;
        ReversingImage_InitComplete = 0u;
    }
    
    InputReversingImageCMD = em_ReversingImageCMD_NoAct;
}

extern uint32_t u32TimeR;

void ReversingImage_Main(void)
{
    e_CVBS_Ctrl_Step tmpStep = ReversingImage_Get_CVBS_Status();
    
    if ((Common_Get_IG_Sts() && (Common_GetIgnOnTime() < 3500))/* || (VdoFmtTyp_Get() == 0)*//* || MenuSetSts_Get()*/)
    {
        //if (VdoFmtTyp_Get() == 0)
        {
            //ReversingImage_Enable_Flag = 0u;
            return;
        }
        
        //if (Common_Get_IG_Sts() && (Common_GetIgnOnTime() < 3500))
        {
            //GUI_DisplUpdTimRst(); 
            //ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Closed;
        }
        //return;
    }
    else
    {
        if (tmpStep == em_CVBS_Ctrl_Step_RefreshBottom)
        {
            ReversingImage_Cmd(em_ReversingImageCMD_BottomRefreshCompletion);
        }
    }

    if (u32TimeR < 2000ul)
    {
        return;
    }

    unsigned char GearSignal = Gear_Get_Value();//Get_ID_18F101D0_Sig_VCU_GearSts();
    
    COMMON_PowerStatus_t PwrSts = Common_Get_IG_Sts();

    if ((GearSignal == 0x01u) && VdoFmtTyp_Get() && (MenuSetSts_Get() == 0u) /*&& (PwrSts == COMMON_POWER_ON)*/)
    {
        ReversingImage_Enable_Flag = 1u;
    }
    else
    {
        ReversingImage_Enable_Flag = 0u;
    }

    switch (ReversingImage_CVBS_Ctrl_Step)
    {
        case em_CVBS_Ctrl_Step_Default:
        {
            ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Closing;
        }
        
        break;

        case em_CVBS_Ctrl_Step_Closed:
        {
            if (ReversingImage_Enable_Flag == 1u)
            {
                ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Opening;
            }
            
            ReversingImage_InitComplete = 1u;
        }
        
        break;

        case em_CVBS_Ctrl_Step_Opened:
        {
            if (ReversingImage_Enable_Flag == 0u)
            {
                ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Closing;
            }
        }
        
        break;
        
        case em_CVBS_Ctrl_Step_Closing:
        {
            if (InputReversingImageCMD == em_ReversingImageCMD_CloseCompletion)
            {
                ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_RefreshBottom;
            }
        }
        
        break;

        case em_CVBS_Ctrl_Step_RefreshBottom:
        {
            if (InputReversingImageCMD == em_ReversingImageCMD_BottomRefreshCompletion)
            {
                ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Closed;
            }
            else if (PwrSts == COMMON_POWER_OFF)
            {
                ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Closed;
            }
        }
        
        break;

        case em_CVBS_Ctrl_Step_Opening:
        {
            if (InputReversingImageCMD == em_ReversingImageCMD_OpenCompletion)
            {
                ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Opened;
            }
        }
        
        break;

        default:
        {
            ReversingImage_CVBS_Ctrl_Step = em_CVBS_Ctrl_Step_Default;
        }
    }

    InputReversingImageCMD = em_ReversingImageCMD_NoAct;
}

void ReversingImage_Cmd(e_ReversingImageCMD cmd)
{
    if (InputReversingImageCMD == em_ReversingImageCMD_NoAct)
    {
        InputReversingImageCMD = cmd;
    }
}

e_CVBS_Ctrl_Step ReversingImage_Get_CVBS_Status(void)
{
    return ReversingImage_CVBS_Ctrl_Step;
}

unsigned char ReversingImage_GetInitCompleteFlag(void)
{
    return ReversingImage_InitComplete;
}

/****************************************************************************
* ��ͼ����д���
****************************************************************************/
void ReversingImage_Clear_Sprite(void)
{
    loc_Del_Sprite(Left_Sprite, Park_Sprite);
}

uint8_t CVBS_Status = 0u;

uint8_t ReversingImage_Enable_Flag_Get(void)
{
    uint8_t tmp;

     tmp = ReversingImage_Get_CVBS_Status();
    
    if ((tmp == em_CVBS_Ctrl_Step_Opened) || (tmp == em_CVBS_Ctrl_Step_Opening))
    {
        CVBS_Status = 1u;
    }

    if (tmp == em_CVBS_Ctrl_Step_Closed)
    {
        CVBS_Status = 0u;
    }

    return CVBS_Status;
}