#ifndef CAN_APP_H
#define CAN_APP_H

#include "TYW_stdint.h"
#include "string.h"
#include "RTE_CAN.h"
#include "CAN_Lib.h"

/******************************************************************************
Bus-off状态
******************************************************************************/
#define   RSCAN0_BUS_STABLE                 0x00U
#define   RSCAN0_BUS_OFF_LV1                0x01U
#define   RSCAN0_BUS_OFF_LV2                0x02U
#define   RSCAN0_BUS_LIMP                   0x03U
/******************************************************************************
Bus-off设置
******************************************************************************/
#define   RSCAN0_BUS_OFF_AUTO_RECOVERY      0U               /* Bus-off自动恢复使能 */

#define   RSCAN0_BUS_OFF_LV1_RECOVERY_TIME  100U             /* Bus-off恢复时间,单位ms */
#define   RSCAN0_BUS_OFF_LV2_RECOVERY_TIME  1000U            /* Bus-off恢复时间,单位ms */

#define   RSCAN0_BUS_LIMP_MODE_ENABLE       0U               /* 跛行模式使能     */
#define   RSCAN0_BUS_LIMP_MODE_THRESHOLD    11U              /* 进入跛行模式门限 */

typedef struct
{
    uint8_t  Status;
    uint8_t  Timer;
    uint8_t  Cnt;
    uint8_t  ReportDTCCnt;
} RSCAN0BusoffMonitorStruct;

void COM_CAN_Init(void);
void COM_RX_Process(void);
void COM_TX_Process(void);
void COM_NM_Process(void);
void COM_NM_ACT(void);
uint8_t COM_CAN_BUS(void);
void CanRx_Buf_Clear(void);

void Can_Abort_All(void);
void CAN_QuickTimer_Init(void);
//void Can_Write_Fun(CAN_APP_TX_Status_t u8TxEnable);
void Can_BusOff_Fun(void);

//uint8_t Can_Msg_Tx_Overwrite(uint32_t u32TxMsgIdx, uint16_t u16TxMSgDIMcounter, uint32_t u32TxMsgCycle);

uint8_t CrcCheckSum(uint8_t data[], uint8_t len);
/*MSG*/
void Can_Set_Buff_18F40117(uint8_t CopyData []);
void Can_Set_Buff_18F40217(uint8_t CopyData []);
void Can_Set_Buff_18FFDC17(uint8_t CopyData []);
void Can_Set_Buff_18FFE017(uint8_t CopyData []);
void Can_Set_Buff_0CFE6CEE(uint8_t CopyData []);
//void Can_Buffer_Init(void);

uint8_t getBUS_OFF_Status(void);
uint8_t getBUS_OFF_FLAG(void);
void Can_BusOffRecover(void);

#endif
