#include "CAN_APP.h"
#include "Telltales_user.h"
#include "Telltales.h"
#include "AirPressure.h"
#include "Services_Mileage.h"
#include "System_Monitor.h"
#include "Analog_Signals.h"
#include "Rscan.h"
#include "CAN_Lib.h"
#include "CAN_Communication_Matrix.h"
#include "RTE_CAN_NM.h"
#include "Telltales_user.h"
#include "Telltales.h"
#include "Common_Interface.h"

static RSCAN0BusoffMonitorStruct RSCAN0Busoff;
uint8_t BUS_OFF_FLAG;
uint8_t BusOffEvent;

#pragma alignvar(8)          //对齐
static uint32_t pTXBuff[CAN_TX_MSG_Block * ID_SEND_TOTAL];
#pragma alignvar(8)
static uint32_t pRXBuff[CAN_RX_MSG_Block * ID_TOTAL_MAX];

void COM_CAN_Init(void)
{
    /*CAN APP BUFFER INIT*/
    Can_TX_BuffInit((uint8_t *)pTXBuff, st_CANSendAttr, ID_SEND_TOTAL, Can_Write);
    Can_RX_BuffInit((uint8_t *)pRXBuff, CAN_MSG_CONST_ARRAY, ID_TOTAL_MAX);
    CAN_RX_SetEnable(0u);
    CAN_TX_SetEnable(CAN_APP_TX_ENABLE);
    /*NM INIT & BSP INIT*/
    RTE_CAN_NM_Init();
}

void COM_RX_Process(void)
{
    CanMSg_XMS_Analysis(5U);
}

void COM_TX_Process(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        Can_Write_Fun(50UL);
    }
    else
    {
        ;
    }
}

void COM_NM_Process(void)
{
    RTE_CAN_NM_Process();
}

/*
request nm
release nm

high voltage
low voltage
2ms
*/

void COM_NM_ACT(void)
{
    if ( SYS_OPR_STAT_RUN_NM )
    {
        if (SYS_OPR_STAT_IGN_ON_NM)
        {
            RTE_CAN_NM_Request(1u);
        }
        else
        {
            RTE_CAN_NM_Release(1u);
        }
    }
    else
    {
        ;
    }
}

uint8_t COM_CAN_BUS(void)
{
    uint8_t Ret = 0u;
    Ret = RTE_CAN_GetBusStatus();
    return Ret;
}

/*
网络管理-0
诊断-1
应用ID-2...
*/

/******Higher******/
void Can_Set_Buff_18F40117(uint8_t CopyData [])
{
    uint8_t  temp = 0;
    uint16_t airp = BatVltFlt_Get_Value();
    
    airp /= 200; 
    //Byte0,低压蓄电池电压,系数0.2,0-36有效值
    CopyData[0] = airp; //28V
    //Byte1
    //.6:左转向灯,硬线信号,高有效
    if (LED_Get_TurnLeft_Status())
    {
        temp |= 0x40;
    }
    //.5:右转向灯,硬线信号,高有效
    if (LED_Get_TurnRight_Status())
    {
        temp |= 0x20;
    }
    //.4:START信号?
    if ((Get_ID_18F101D0_Sig_VCU_VhclSts() == 0u) && (CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_RECEIVE))
    {
        temp |= 0x08;
    }
    //.3:ON信号
    if (Get_ID_18F101D0_Sig_VCU_VhclSts() == 1u)
    {
        temp |= 0x10;
    }
    //.2:后舱门?.1:前门,左右车门?.0:中门?,
    if (LED_Get_Status(em_LED_Door))
    {
        temp |= 0x02;
    }
    CopyData[1] = temp;
    //Byte2
    temp = 0;
    //.3:STOP状态?
    if (LED_Get_Status(em_LED_Stop))
    {
        temp |= 0x08;
    }
    //.2:手刹状态,硬线信号,低有效
    if (LED_Get_Status(em_LED_Parking))
    {
        temp |= 0x04;
    }
    //.1:前气压报警
    if (LED_AirPressure_Judgement(0)) //*10bar,Vout=(2.721*0.55MPa+0.5)/5*Vin
    {
        temp |= 0x02;
    }
    //.0:后气压报警
    if (LED_AirPressure_Judgement(1)) //*10bar,Vout=(2.721*0.55MPa+0.5)/5*Vin
    {
        temp |= 0x01;
    }
    CopyData[2] = temp;
    //Byte3 前制动储气筒气压,系数5,单位kPa
    if (AirPressure_Get_Valid(0))
    {
        airp = AirPressure_Get_Value(0); //0.01MPa
        airp *= 10u;         //1kPa
        if (airp > 1000u)
        {
            temp = 0xFEu;
        }
        else
        {
            temp = (uint8_t)(airp / 5);
        }
    }
    else
    {
        temp = 0xFFu;
    }

    CopyData[3] = temp;
    
    //Byte4 后制动储气筒气压,系数5,单位kPa
    if (AirPressure_Get_Valid(1))
    {
        airp = AirPressure_Get_Value(1); //0.01MPa
        airp *= 10u;         //1kPa       
        if (airp > 1000u)
        {
            temp = 0xFEu;
        }
        else
        {
            temp = (uint8_t)(airp / 5);
        }
    }
    else
    {
        temp = 0xFFu;
    }
    
    CopyData[4] = temp;
    
    CopyData[5] = 0u;
    CopyData[6] = 0u;
    CopyData[7] = 0u;
}

void Can_Set_Buff_18F40217(uint8_t CopyData [])
{
    uint32_t temp32 = Data_ODO_Read();
    //Byte0~Byte3 车辆总里程,系数0.125，单位km
    temp32 = temp32 * 8 / 10;
    CopyData[0] = (uint8_t)temp32;
    CopyData[1] = (uint8_t)(temp32 >> 8);
    CopyData[2] = (uint8_t)(temp32 >> 16);
    CopyData[3] = (uint8_t)(temp32 >> 24);
    
    CopyData[4] = 0u;
    CopyData[5] = 0u;
    CopyData[6] = 0u;
    
    //Byte7 仪表版本,系数0.1
    CopyData[7] = 10; //1.0 
}

void Can_Set_Buff_18FFDC17(uint8_t CopyData [])
{
    CopyData[0] = 0u;
    CopyData[1] = 0u;
    if ((Common_GetIgnOnTime() < 3500ul) && (Common_Get_IG_Sts() == 1u))
    {
        CopyData[1] |= 0xCu;
    }
    else
    {
        if (LED_HiBeam_Judgement()) //(LED_Get_Status(em_LED_HiBeam))
        {
            CopyData[1] |= 4u;
        }
    }
    CopyData[2] = 0u;
    CopyData[3] = 0u;
    CopyData[4] = 0u;
    CopyData[5] = 0u;
    CopyData[6] = 0u;
    CopyData[7] = 0u;
}

void Can_Set_Buff_18FFE017(uint8_t CopyData [])
{
    CopyData[0] = 0u;
    CopyData[1] = 0u;
    CopyData[2] = 0u;
    CopyData[3] = 0u;
    CopyData[4] = 0u;
    CopyData[5] = 0u;
    CopyData[6] = 0u;
    if ((Common_GetIgnOnTime() < 3500ul) && (Common_Get_IG_Sts() == 1u))
    {
        CopyData[6] |= 0x3u;
    }
    else
    {
        if (LED_SeatBelt_Judgement() == 0u) //(LED_Get_Status(em_LED_SeatBelt) == 0u)
        {
            CopyData[6] |= 1u;
        }
    }
    CopyData[7] = 0u;
}

void Can_Set_Buff_0CFE6CEE(uint8_t CopyData [])
{
    CopyData[0] = 0u;
    CopyData[1] = 0u;
    CopyData[2] = 0u;
    CopyData[3] = 0u;
    CopyData[4] = 0u;
    CopyData[5] = 0u;
    uint32_t u32Result = Get_ID_18F101D0_Sig_VCU_VhclSpd();
            
    if ((u32Result > 0xFAFF) || (CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_LOST))
    {
        CopyData[6] = 0xFFu;
        CopyData[7] = 0xFFu;
    }
    else
    {
        CopyData[6] = (uint8_t)(u32Result);
        CopyData[7] = (uint8_t)(u32Result >> 8u); 
    }
}

uint8_t CrcCheckSum(uint8_t data[], uint8_t len)
{
    uint8_t crc = 0xffu;
    uint8_t CRC_POLY = 0x2fu;
    uint8_t crcxor = 0xffu;
    uint8_t bit_index = 0u;
    uint8_t byte_index = 0u;
    uint8_t temp = 0u;

    for (byte_index = 0u; byte_index < len; ++byte_index )
    {
        crc ^= data[byte_index];
        for (bit_index = 0u; bit_index < 8u; ++bit_index)
        {
            if ((crc & 0x80u) != 0u)
            {
                temp = crc << 1u;
                crc = temp ^ CRC_POLY;
            }
            else
            {
                crc = (crc << 1u);
            }
        }
    }
    crc = crc ^ crcxor;
    return crc;
}

void CAN_QuickTimer_Init ( void )
{
    uint8_t i = 0u;
    for ( i = 0u; i < ID_SEND_TOTAL; i++)
    {
        //CanMsg[i].u32Timer = st_CANSendAttr[i].u32MsgCycleOffset;
        //CanMsg[i].u32MsgCycle = st_CANSendAttr[i].u32MsgCycle;
        //CanMsg[i].u32SendCnt = st_CANSendAttr[i].u32InitSendCnt;
    }
}

void Can_BusOff_Fun(void)
{
    if (Get_CH0_BusOffStatus() != 0u)
    { 
        CANFD_SetTX_Abort();
        BusOffEvent = 1U;
        CAN_QuickTimer_Init();
        if(RSCAN0Busoff.ReportDTCCnt < 100u)
        {
            RSCAN0Busoff.ReportDTCCnt++;
        }
        else
        {
            BUS_OFF_FLAG = 1U;
        }
        
        if (RSCAN0Busoff.Status == RSCAN0_BUS_STABLE)
        {
            RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV1;
        }

        if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV1)
        {
            RSCAN0Busoff.Timer++;
            
            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV1_RECOVERY_TIME / 10U)
            {
                RSCAN0Busoff.Timer = 0U;

                RSCAN0Busoff.Cnt++;
                if (RSCAN0Busoff.Cnt >= 10U)
                {
                    
                    RSCAN0Busoff.Cnt = 0U;

                    RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV2;
                }
                CAN_BUSOFF_Recover();
            }
        }
        else if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV2)
        {
            RSCAN0Busoff.Timer++;

            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV2_RECOVERY_TIME / 10U)
            {
                RSCAN0Busoff.Timer = 0U;
                CAN_BUSOFF_Recover();

            }
        }
        else
        {

        }
    }
    else                                          /* 总线正常,没有Bus-off发生/**/
    {
        
    }
}

void Can_BusOffRecover(void)
{
    BusOffEvent = 0u;
    RSCAN0Busoff.Cnt = 0u;
    RSCAN0Busoff.ReportDTCCnt = 0u;
    RSCAN0Busoff.Status = 0u;
    RSCAN0Busoff.Timer = 0u;
}

/**
  *获取busoff状态
  *@return busoff状态 0正常,1异常
  */
uint8_t getBUS_OFF_Status(void)
{
    return BusOffEvent;
}

/**
  *获取busoff标志
  *@return busoff状态 0正常,1异常
  */
uint8_t getBUS_OFF_FLAG(void)
{
    uint8_t FLAG = BUS_OFF_FLAG;
    if (!getBUS_OFF_Status())
    {
        BUS_OFF_FLAG = 0u;
    }
    return FLAG;
}

void CanRx_Buf_Clear(void)
{
    memset(pRXBuff, 0u, sizeof(pRXBuff));
    Can_RX_BuffInit((uint8_t *)pRXBuff, CAN_MSG_CONST_ARRAY, ID_TOTAL_MAX);
    CAN_RX_SetEnable(0u);
}
