#ifndef CAN_COMMUNICATION_MATRIX_H_
#define CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

typedef enum
{
    ID_VCU_VCUSts1_Msg_Count,
    ID_VCU_VCUSts2_Msg_Count,
    ID_VCU_VCUSts3_Msg_Count,
    ID_VCU_MutiOneSts_Msg_Count,
    ID_VCU_PDUSts_Msg_Count,
    ID_VCU_MCUSts1_Msg_Count,
    ID_VCU_MCUSts2_Msg_Count,
    ID_BMS_BMSSts_Msg_Count,
    ID_BMS_CllBtySts_Msg_Count,
    ID_BMS_BtyIslRst_Msg_Count,
    ID_BMS_BtyLmtVal_Msg_Count,
    ID_BMS_BMSFltSts_Msg_Count,
    ID_BMS_MinBtyTpt_Msg_Count,
    ID_BMS_MaxBtyTpt_Msg_Count,
    ID_BMS_MinBtyVtg_Msg_Count,
    ID_BMS_MaxBtyVtg_Msg_Count,
    ID_BMS_Bty_Msg_Count,
    ID_VCU_RMON_1_Msg_Count,
    ID_VCU_RMON_2_Msg_Count,
    ID_VCU_RMON_3_Msg_Count,
    ID_BMS_RMON_1_Msg_Count,
    ID_BMS_RMON_2_Msg_Count,
    ID_BMS_RMON_3_Msg_Count,
    ID_VCU_VINCode_2_Msg_Count,
    ID_BCM_INFO_1_Msg_Count,
    ID_DM1_Msg_Count,
    
    ID_BMS_RMON_M0_Msg_Count,
    ID_BMS_RMON_M1_Msg_Count,
    ID_BMS_RMON_M2_Msg_Count,
    ID_BMS_RMON_M3_Msg_Count,
    ID_BMS_RMON_M4_Msg_Count,
    ID_BMS_RMON_M5_Msg_Count,

    ID_BMS_RMON_N00_Msg_Count,
    ID_BMS_RMON_N01_Msg_Count,
    ID_BMS_RMON_N02_Msg_Count,
    ID_BMS_RMON_N03_Msg_Count,
    ID_BMS_RMON_N04_Msg_Count,
    ID_BMS_RMON_N05_Msg_Count,
    ID_BMS_RMON_N06_Msg_Count,
    ID_BMS_RMON_N07_Msg_Count,
    ID_BMS_RMON_N08_Msg_Count,
    ID_BMS_RMON_N09_Msg_Count,
    ID_BMS_RMON_N10_Msg_Count,
    ID_BMS_RMON_N11_Msg_Count,
    ID_BMS_RMON_N12_Msg_Count,
    ID_BMS_RMON_N13_Msg_Count,
    ID_BMS_RMON_N14_Msg_Count,
    ID_BMS_RMON_N15_Msg_Count,
    ID_BMS_RMON_N16_Msg_Count,
    ID_BMS_RMON_N17_Msg_Count,
    ID_BMS_RMON_N18_Msg_Count,
    ID_BMS_RMON_N19_Msg_Count,
    ID_BMS_RMON_N20_Msg_Count,
    ID_BMS_RMON_N21_Msg_Count,
    ID_BMS_RMON_N22_Msg_Count,
    ID_BMS_RMON_N23_Msg_Count,
    ID_BMS_RMON_N24_Msg_Count,
    ID_BMS_RMON_N25_Msg_Count,
    ID_BMS_RMON_N26_Msg_Count,
    ID_BMS_RMON_N27_Msg_Count,
    ID_BMS_RMON_N28_Msg_Count,
    ID_BMS_RMON_N29_Msg_Count,
    ID_BMS_RMON_N30_Msg_Count,
    ID_BMS_RMON_N31_Msg_Count,
    ID_BMS_RMON_N32_Msg_Count,
    ID_BMS_RMON_N33_Msg_Count,
    ID_BMS_RMON_N34_Msg_Count,
    ID_BMS_RMON_N35_Msg_Count,
    ID_BMS_RMON_N36_Msg_Count,
    ID_BMS_RMON_N37_Msg_Count,
    ID_BMS_RMON_N38_Msg_Count,
    ID_BMS_RMON_N39_Msg_Count,
    ID_BMS_RMON_N40_Msg_Count,
    ID_BMS_RMON_N41_Msg_Count,
    ID_BMS_RMON_N42_Msg_Count,
    ID_BMS_RMON_N43_Msg_Count,
    ID_BMS_RMON_N44_Msg_Count,
    ID_BMS_RMON_N45_Msg_Count,
    ID_BMS_RMON_N46_Msg_Count,
    ID_BMS_RMON_N47_Msg_Count,
    ID_BMS_RMON_N48_Msg_Count,
    ID_BMS_RMON_N49_Msg_Count,

    ID_DCM1_Msg_Count,

    ID_MMI_ACSW_Msg_Count,

    ID_ABS_EBC1_Msg_Count,

    ID_EPB_Sts_Msg_Count,

    ID_VCU_SV_Msg_Count,

    ID_TOTAL_MAX,
} CAN_MSG_ID_t;

typedef enum
{
    ID_SEND_ICM_1,
    ID_SEND_ICM_2,
    ID_SEND_ICM_3,
    ID_SEND_ICM_4,
    ID_SEND_ICM_5,

    ID_SEND_TOTAL,
} CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX];
extern const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL];

#define  ID_VCU_VCUSts1_Msg    0x18F101D0ul
#define  ID_VCU_VCUSts2_Msg    0x18F103D0ul
#define  ID_VCU_VCUSts3_Msg    0x18F104D0ul
#define  ID_VCU_MutiOneSts_Msg 0x18F105D0ul
#define  ID_VCU_PDUSts_Msg     0x18F106D0ul
#define  ID_VCU_MCUSts1_Msg    0x18F501F0ul
#define  ID_VCU_MCUSts2_Msg    0x18F502F0ul
#define  ID_BMS_BMSSts_Msg     0x18F13DF3ul
#define  ID_BMS_CllBtySts_Msg  0x18F13EF3ul
#define  ID_BMS_BtyIslRst_Msg  0x18F13FF3ul
#define  ID_BMS_BtyLmtVal_Msg  0x18F140F3ul
#define  ID_BMS_BMSFltSts_Msg  0x18F141F3ul
#define  ID_BMS_MinBtyTpt_Msg  0x18F142F3ul
#define  ID_BMS_MaxBtyTpt_Msg  0x18F143F3ul
#define  ID_BMS_MinBtyVtg_Msg  0x18F144F3ul
#define  ID_BMS_MaxBtyVtg_Msg  0x18F146F3ul
#define  ID_BMS_Bty_Msg        0x18F148F3ul
#define  ID_VCU_RMON_1_Msg     0x18F107D0ul
#define  ID_VCU_RMON_2_Msg     0x18F108D0ul
#define  ID_VCU_RMON_3_Msg     0x18F109D0ul
#define  ID_BMS_RMON_1_Msg     0x18F149F3ul
#define  ID_BMS_RMON_2_Msg     0x18F14AF3ul
#define  ID_BMS_RMON_3_Msg     0x18F14BF3ul
#define  ID_VCU_VINCode_2_Msg  0x18F10AD0ul

#define  ID_BCM_INFO_1_Msg     0x18FFDA21ul
#define  ID_DM1_Msg            0x18FECA0Bul

#define  ID_BMS_RMON_M0_Msg    0x18F120F3ul
#define  ID_BMS_RMON_M1_Msg    0x18F121F3ul
#define  ID_BMS_RMON_M2_Msg    0x18F122F3ul
#define  ID_BMS_RMON_M3_Msg    0x18F123F3ul
#define  ID_BMS_RMON_M4_Msg    0x18F124F3ul
#define  ID_BMS_RMON_M5_Msg    0x18F125F3ul

#define  ID_BMS_RMON_N00_Msg    0x18F14CF3ul
#define  ID_BMS_RMON_N01_Msg    0x18F14DF3ul
#define  ID_BMS_RMON_N02_Msg    0x18F14EF3ul
#define  ID_BMS_RMON_N03_Msg    0x18F14FF3ul
#define  ID_BMS_RMON_N04_Msg    0x18F150F3ul
#define  ID_BMS_RMON_N05_Msg    0x18F151F3ul
#define  ID_BMS_RMON_N06_Msg    0x18F152F3ul
#define  ID_BMS_RMON_N07_Msg    0x18F153F3ul
#define  ID_BMS_RMON_N08_Msg    0x18F154F3ul
#define  ID_BMS_RMON_N09_Msg    0x18F155F3ul
#define  ID_BMS_RMON_N10_Msg    0x18F156F3ul
#define  ID_BMS_RMON_N11_Msg    0x18F157F3ul
#define  ID_BMS_RMON_N12_Msg    0x18F158F3ul
#define  ID_BMS_RMON_N13_Msg    0x18F159F3ul
#define  ID_BMS_RMON_N14_Msg    0x18F15AF3ul
#define  ID_BMS_RMON_N15_Msg    0x18F15BF3ul
#define  ID_BMS_RMON_N16_Msg    0x18F15CF3ul
#define  ID_BMS_RMON_N17_Msg    0x18F15DF3ul
#define  ID_BMS_RMON_N18_Msg    0x18F15EF3ul
#define  ID_BMS_RMON_N19_Msg    0x18F15FF3ul
#define  ID_BMS_RMON_N20_Msg    0x18F160F3ul
#define  ID_BMS_RMON_N21_Msg    0x18F161F3ul
#define  ID_BMS_RMON_N22_Msg    0x18F162F3ul
#define  ID_BMS_RMON_N23_Msg    0x18F163F3ul
#define  ID_BMS_RMON_N24_Msg    0x18F164F3ul
#define  ID_BMS_RMON_N25_Msg    0x18F165F3ul
#define  ID_BMS_RMON_N26_Msg    0x18F166F3ul
#define  ID_BMS_RMON_N27_Msg    0x18F167F3ul
#define  ID_BMS_RMON_N28_Msg    0x18F168F3ul
#define  ID_BMS_RMON_N29_Msg    0x18F169F3ul
#define  ID_BMS_RMON_N30_Msg    0x18F16AF3ul
#define  ID_BMS_RMON_N31_Msg    0x18F16BF3ul
#define  ID_BMS_RMON_N32_Msg    0x18F16CF3ul
#define  ID_BMS_RMON_N33_Msg    0x18F16DF3ul
#define  ID_BMS_RMON_N34_Msg    0x18F16EF3ul
#define  ID_BMS_RMON_N35_Msg    0x18F16FF3ul
#define  ID_BMS_RMON_N36_Msg    0x18F170F3ul
#define  ID_BMS_RMON_N37_Msg    0x18F171F3ul
#define  ID_BMS_RMON_N38_Msg    0x18F172F3ul
#define  ID_BMS_RMON_N39_Msg    0x18F173F3ul
#define  ID_BMS_RMON_N40_Msg    0x18F174F3ul
#define  ID_BMS_RMON_N41_Msg    0x18F175F3ul
#define  ID_BMS_RMON_N42_Msg    0x18F176F3ul
#define  ID_BMS_RMON_N43_Msg    0x18F177F3ul
#define  ID_BMS_RMON_N44_Msg    0x18F178F3ul
#define  ID_BMS_RMON_N45_Msg    0x18F179F3ul
#define  ID_BMS_RMON_N46_Msg    0x18F17AF3ul
#define  ID_BMS_RMON_N47_Msg    0x18F17BF3ul
#define  ID_BMS_RMON_N48_Msg    0x18F17CF3ul
#define  ID_BMS_RMON_N49_Msg    0x18F17DF3ul

#define  ID_DCM1_Msg            0x18FDA5ECul

#define  ID_MMI_ACSW_Msg        0x18FF9B3Aul

#define  ID_ABS_EBC1_Msg        0x18F0010Bul

#define  ID_EPB_Sts_Msg         0x18FF6060ul

#define  ID_VCU_SV_Msg          0x18F10BD0ul
/*****************************************************************************/
//VCU_VCUSts1
extern uint8_t  Get_ID_18F101D0_Sig_VCU_VhclSts(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_SysIntlck(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_SlftstSts(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_BMSRlyCtl(void);
extern uint16_t Get_ID_18F101D0_Sig_VCU_VhclSpd(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_EngyRec(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_PwrLmtLmp(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_GearSts(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_CrhItyWrn(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_LDW(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_CrsConSts(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_DrvrSts(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_GrMntnRmnd(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_CANErr(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_GearbxErr(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_SysErrMd(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_SysDTC(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_MaxFltLv(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_SysTtlFlt(void);
extern uint8_t  Get_ID_18F101D0_Sig_VCU_HrtBt(void);
//VCU_VCUSts2
extern uint8_t  Get_ID_18F103D0_Sig_VCU_SwrVrsNbr(void);
extern uint16_t Get_ID_18F103D0_Sig_VCU_EndMlg(void);
extern uint8_t  Get_ID_18F103D0_Sig_VCU_ActPdlDgr(void);
extern uint8_t  Get_ID_18F103D0_Sig_VCU_BrkPdlDgr(void);
extern uint8_t  Get_ID_18F103D0_Sig_VCU_NAthrtyVhl(void);
extern uint16_t Get_ID_18F103D0_Sig_VCU_VcmPmpPrsvl(void);
extern uint8_t  Get_ID_18F103D0_Sig_VCU_EPMode(void);
//VCU_VCUSts3
extern uint8_t  Get_ID_18F104D0_Sig_VCU_LFBrkWrAlrm(void);
extern uint8_t  Get_ID_18F104D0_Sig_VCU_RFBrkWrAlrm(void);
extern uint8_t  Get_ID_18F104D0_Sig_VCU_LBBrkWrAlrm(void);
extern uint8_t  Get_ID_18F104D0_Sig_VCU_RBBrkWrAlrm(void);
//VCU_MutiOneSts
extern uint8_t  Get_ID_18F105D0_Sig_VCU_DCDCSts(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_ACMSts(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_EPSSts(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_ACSts(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_PTCSts(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_EPSMaxFltLv(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_EPSTtlFlt(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_EPSDTC(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_ACMMaxFltLv(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_ACMTtlFlt(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_ACMDTC(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_DCDCMaxFltLv(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_DCDCTtlFlt(void);
extern uint8_t  Get_ID_18F105D0_Sig_VCU_DCDCDTC(void);
//VCU_PDUSts
extern uint8_t  Get_ID_18F106D0_Sig_VCU_AuxPrChgRlySts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_AuxRlySts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_MtrPrChgRlySts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_MtrRlySts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_PTCRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_DeFrstRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_AuxPrChgRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_AuxRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_MtrPrChgRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_MtrRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_ACRlyFltSts(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_PDUMaxFltLv(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_PDUTtlFlt(void);
extern uint8_t  Get_ID_18F106D0_Sig_VCU_PDUDTC(void);
//VCU_MCUSts1
extern uint8_t  Get_ID_18F501F0_Sig_VCU_DrvMtrTpt(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_DrvMCUTpt(void);
extern uint16_t Get_ID_18F501F0_Sig_VCU_MCUIptVtg(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUMaxFltLv(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUTtlFlt(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUDrvSts(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUSlftstStas(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUFltSts(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUCANWrn(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_DrvMtrTptWrn(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUTptWrn(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MtrOvCrtWrn(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUUnVtgWrn(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUOvVtgWrn(void);
extern uint8_t  Get_ID_18F501F0_Sig_VCU_MCUDTC(void);
//VCU_MCUSts2
extern uint16_t Get_ID_18F502F0_Sig_VCU_DrvMtrSpd(void);
extern uint16_t Get_ID_18F502F0_Sig_VCU_DrvMtrTrq(void);
extern uint16_t Get_ID_18F502F0_Sig_VCU_DrvMtrPwr(void);
extern uint16_t Get_ID_18F502F0_Sig_VCU_DrvSysMaxPwr(void);
//BMS_BMSSts
extern uint16_t Get_ID_18F13DF3_Sig_BMS_BtyPckVtg(void);
extern uint16_t Get_ID_18F13DF3_Sig_BMS_BtyPckCrt(void);
extern uint16_t Get_ID_18F13DF3_Sig_BMS_BtySOC(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_BMSSts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_BMSCutofReq(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_BMSFltLv(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_ChgPrchgRlySts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_PrchgRlySts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_BtyHtRlySts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_ChgNgtvRlySts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_ChgPstvRlySts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_BtyNgtvRlySts(void);
extern uint8_t  Get_ID_18F13DF3_Sig_BMS_BtyPstyRlySts(void);
//BMS_CllBtySts
extern uint16_t Get_ID_18F13EF3_Sig_BMS_BtyMaxCllVtg(void);
extern uint16_t Get_ID_18F13EF3_Sig_BMS_BtyMinCllVtg(void);
extern uint8_t  Get_ID_18F13EF3_Sig_BMS_BtyMaxCllTpt(void);
extern uint8_t  Get_ID_18F13EF3_Sig_BMS_BtyMinCllTpt(void);
extern uint16_t Get_ID_18F13EF3_Sig_BMS_BtyTptDffr(void);
//BMS_BtyIslRst
extern uint8_t  Get_ID_18F13FF3_Sig_BMS_MaxTptPrbNbr(void);
extern uint8_t  Get_ID_18F13FF3_Sig_BMS_MinTptPrbNbr(void);
extern uint16_t Get_ID_18F13FF3_Sig_BMS_PstvIslRst(void);
extern uint16_t Get_ID_18F13FF3_Sig_BMS_NgtvIslRst(void);
//BMS_BtyLmtVal
extern uint16_t Get_ID_18F140F3_Sig_BMS_MaxChgCrt(void);
extern uint16_t Get_ID_18F140F3_Sig_BMS_MaxDchgCrt(void);
extern uint8_t  Get_ID_18F140F3_Sig_BMS_MaxLmtTpt(void);
extern uint8_t  Get_ID_18F140F3_Sig_BMS_MinLmtTpt(void);
extern uint8_t  Get_ID_18F140F3_Sig_BMS_MinLmtSOC(void);
//BMS_BMSFltSts
extern uint8_t  Get_ID_18F141F3_Sig_BMS_BMSDTC(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_BMSMaxFltLv(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_BMSTtlFlt(void);
extern uint16_t Get_ID_18F141F3_Sig_BMS_BMSSwrVrsNbr(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_ChgWrCntSts(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_ChgRemnderH(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_ChgRemnderM(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_CANPtcVer(void);
extern uint8_t  Get_ID_18F141F3_Sig_BMS_BMSHrtBt(void);
//BMS_MinBtyTpt
extern uint8_t  Get_ID_18F142F3_Sig_BMS_BtyMinTpt(void);
extern uint8_t  Get_ID_18F142F3_Sig_BMS_MinTptStmNbr(void);
extern uint8_t  Get_ID_18F142F3_Sig_BMS_MinTptPrbNbr(void);
//BMS_MaxBtyTpt
extern uint8_t  Get_ID_18F143F3_Sig_BMS_BtyMaxTpt(void);
extern uint8_t  Get_ID_18F143F3_Sig_BMS_MaxTptStmNbr(void);
extern uint8_t  Get_ID_18F143F3_Sig_BMS_MaxTptPrbNbr(void);
//BMS_MinBtyVtg
extern uint16_t Get_ID_18F144F3_Sig_BMS_MinCllVtg(void);
extern uint8_t  Get_ID_18F144F3_Sig_BMS_MinVtgCllNbr(void);
extern uint8_t  Get_ID_18F144F3_Sig_BMS_MinVtgCllStmNbr(void);
//BMS_MaxBtyVtg
extern uint16_t Get_ID_18F146F3_Sig_BMS_MaxCllVtg(void);
extern uint8_t  Get_ID_18F146F3_Sig_BMS_MaxVtgCllNbr(void);
extern uint8_t  Get_ID_18F146F3_Sig_BMS_MaxVtgCllStmNbr(void);
//BMS_Bty
extern uint16_t Get_ID_18F148F3_Sig_BMS_BtyRtdCpty(void);
extern uint16_t Get_ID_18F148F3_Sig_BMS_BtyRtdVtg(void);
extern uint8_t  Get_ID_18F148F3_Sig_BMS_PD_Y(void);
extern uint8_t  Get_ID_18F148F3_Sig_BMS_PD_M(void);
extern uint8_t  Get_ID_18F148F3_Sig_BMS_PD_D(void);
//VCU_RMON_1
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_VhlSts(void);
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_DrvMd(void);
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_DCDCSts(void);
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_DrvFrc(void);
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_BrkFrc(void);
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_GrSts(void);
extern uint8_t  Get_ID_18F107D0_Sig_VCU_T_TtlDrvMtr(void);
//VCU_RMON_2
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_VhlMaxFltLv(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_7(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_6(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_5(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_4(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_3(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_2(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_1(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg1_0(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_7(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_6(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_5(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_4(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_3(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_2(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_1(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg2_0(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg3_2(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg3_1(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_GnrlAlrmFlg3_0(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_T_DrvMtrTtlFlt(void);
extern uint8_t  Get_ID_18F108D0_Sig_VCU_DrvMteDTC(void);
//VCU_RMON_3
extern uint8_t  Get_ID_18F109D0_Sig_VCU_T_DrvMtrN(void);
extern uint8_t  Get_ID_18F109D0_Sig_VCU_T_DrvMtrSts(void);
extern uint16_t Get_ID_18F109D0_Sig_VCU_T_DrvMtrSpd(void);
extern uint16_t Get_ID_18F109D0_Sig_VCU_T_DrvMtrTrq(void);
extern uint16_t Get_ID_18F109D0_Sig_VCU_T_DrvMtrIptVtg(void);
//BMS_RMON_1
extern uint32_t Get_ID_18F149F3_Sig_BMS_TtlChgEng(void);
extern uint16_t Get_ID_18F149F3_Sig_BMS_SglChgEng(void);
extern uint8_t  Get_ID_18F149F3_Sig_BMS_ChrgSts(void);
extern uint8_t  Get_ID_18F149F3_Sig_BMS_BtyTtlFlt(void);
//BMS_RMON_2
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_7(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_6(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_5(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_4(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_3(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_2(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_1(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_0(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg2_3(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg2_2(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg2_1(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyFltFlg2_0(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_TtlBtySst(void);
extern uint16_t Get_ID_18F14AF3_Sig_BMS_CllBtyTtl(void);
extern uint16_t Get_ID_18F14AF3_Sig_BMS_BtyTptTtl(void);
extern uint8_t  Get_ID_18F14AF3_Sig_BMS_BtyTyp(void);
//BMS_RMON_3
extern uint8_t  Get_ID_18F14BF3_Sig_BMS_BtyStmNbr(void);
extern uint16_t Get_ID_18F14BF3_Sig_BMS_BtySstVtg(void);
extern uint16_t Get_ID_18F14BF3_Sig_BMS_BtySstCrt(void);
extern uint16_t Get_ID_18F14BF3_Sig_BMS_SstCllBtyTtl(void);
extern uint8_t  Get_ID_18F14BF3_Sig_BMS_SstBtyTptTtl(void);
//VCU_VINCode_2
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_DataPcktNbr(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V1(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V2(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V3(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V4(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V5(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V6(void);
extern uint8_t  Get_ID_18F10AD0_Sig_VIN_CodeNo_7V7(void);
//BCM_Info_1
extern uint8_t  Get_ID_18FFDA21_Sig_TurnLeftLight(void);
extern uint8_t  Get_ID_18FFDA21_Sig_TurnRightLight(void);
extern uint8_t  Get_ID_18FFDA21_Sig_FrontFogLightSwitch(void);
extern uint8_t  Get_ID_18FFDA21_Sig_RearFogLightSwitch(void);
extern uint8_t  Get_ID_18FFDA21_Sig_LowbeamLightStatus(void);
extern uint8_t  Get_ID_18FFDA21_Sig_BackLightStatus(void);
extern uint8_t  Get_ID_18FFDA21_Sig_DayLightStatus(void);
extern uint8_t  Get_ID_18FFDA21_Sig_SidelightStatus(void);
extern uint8_t  Get_ID_18FFDA21_Sig_HighBeamSwitch(void);
extern uint8_t  Get_ID_18FFDA21_Sig_SidelightNotTurnoffWarn(void);
extern uint8_t  Get_ID_18FFDA21_Sig_KeySwitchStatus(void);
//ID_DM1_Msg
extern uint32_t Get_ID_18FECA0B_Sig_SPN(void);
extern uint8_t  Get_ID_18FECA0B_Sig_FMI(void);
//BMS_RMON_M0~M5
uint8_t Get_ID_BMS_RMON_M_Sig_Tpt(canlib_uint16_t MsgIdx, canlib_uint8_t BuffIdx);
//BMS_RMON_N0~N49
uint16_t Get_ID_BMS_RMON_N_Sig_Vtg(canlib_uint16_t MsgIdx, canlib_uint8_t BuffIdx);
//DCM1
extern uint8_t  Get_ID_18FDA5EC_Sig_DoorOpen_Driver(void);
extern uint8_t  Get_ID_18FDA5EC_Sig_DoorOpen_Passenger(void);
//MMI_ACSW
extern uint8_t  Get_ID_18FF983A_Sig_MMI_AC_ForceCleanFrostSW(void);
//ABS_EBC1
extern uint8_t  Get_ID_18F0010B_Sig_ABS_YellowAlarmSts(void);
//EPB
extern uint8_t  Get_ID_18FF6060_Sig_EPB_ParkLampState(void);
//VCU_SV
extern uint8_t  Get_ID_18F10BD0_Sig_VCU_DrivMode(void);
/*---------------------------------------------------------------------------*/
extern uint8_t  Co_Can_ConvertSubID(uint32_t MsgID);
#endif
