/**
********************************************************************************************************
* @file    loc_graphics.h
* @author  HZS
* @version V1.0.0
* @date    2020.12.24
* @brief   c header file
********************************************************************************************************/

#ifndef GUI_H_
#define GUI_H_

#include "TYW_stdint.h"
#include "GUI_Interface.h"
#include "Watchdog.h"

#define Oil_Brake    0
#define Air_Brake    1
#define Brake_Type   Oil_Brake

/*显示模式*/
typedef enum
{
    DIS_MODE_OFF,
    DIS_MODE_ON,
} EumDisMode;

/*数据有效状态枚举*/
typedef enum
{
    DATA_Invaild,   /*无效*/
    DATA_Vaild,     /*有效*/
} EumDataIsVaild;

/*主题枚举*/
typedef enum
{
    THEME_1,    /*主题1*/
    THEME_2,    /*主题2*/
    THEME_3,    /*主题3*/
    THEME_NONE, /*无主题*/
} EumTheme;

/*负值显示*/
typedef enum
{
    DATA_NEG_DISABLE,   /*负号禁用*/
    DATA_NEG_ENABLE,    /*负号使能*/
} EumDataNegEn;

/*档位枚举*/
typedef enum
{
    GEAR_NONE,
    GEAR_P,
    GEAR_R,
    GEAR_N,
    GEAR_D,
} EumGear;

/*导航显示*/
typedef enum
{
    NAVI_INFO_DISABLE,   /*无导航信息*/
    NAVI_INFO_ENABLE,    /*显示导航信息*/
} EumNaviInfoEn;

/*导航方向类型*/
typedef enum
{
    NAVI_DIR_TYPE_NONE,     /*无*/
    NAVI_DIR_TYPE_GRAPHIC,  /*图形*/
    NAVI_DIR_TYPE_ROUND,    /*环岛*/
} EumNaviDirType;

/*导航结构*/
typedef struct
{
    uint16_t meter;             /*上方距离*/
    EumDataIsVaild meterVaild;  /*距离有效位*/

    uint16_t posInfo;       /*当前位置图片*/
    uint16_t destination;   /*目标位置图片*/

    EumNaviDirType dirType; /*方向类型*/
    uint16_t directImg;     /*方向图片*/

    uint16_t remDistan;            /*剩余距离*/
    EumDataIsVaild remDistanVaild; /*剩余公里有效位*/

    uint8_t remHour;             /*剩余时间-小时*/
    uint8_t remMinute;           /*剩余时间-分钟*/
    EumDataIsVaild remTimeVaild; /*剩余时间有效位*/

    uint8_t planHour;             /*预计到达小时*/
    uint8_t planMinute;           /*预计到达分钟*/
    EumDataIsVaild planTimeVaild; /*预计时间有效位*/
} StuNavi;

/*音乐源枚举*/
typedef enum
{
    MUSIC_SRC_NONE,         /*无*/
    MUSIC_SRC_IPOD,         /*ipod*/
    MUSIC_SRC_USB,          /*USB*/
    MUSIC_SRC_LOCAL,        /*本地存储*/
    MUSIC_SRC_BLUETOOTH,    /*蓝牙音乐*/
    MUSIC_SRC_ONLINE,       /*在线音乐*/
} EumMusicSrc;

/*视频源枚举*/
typedef enum
{
    VIDEO_SRC_NONE,         /*无*/
    VIDEO_SRC_IPOD,         /*ipod*/
    VIDEO_SRC_USB,          /*USB*/
    VIDEO_SRC_LOCAL,        /*本地存储*/
    VIDEO_SRC_BLUETOOTH,    /*蓝牙视频*/
    VIDEO_SRC_ONLINE,       /*在线视频*/
} EumVideoSrc;

/*多媒体类型枚举*/
typedef enum
{
    MEDIA_TYPE_NONE,     /*无*/
    MEDIA_TYPE_PHONE,    /*电话*/
    MEDIA_TYPE_RADIO,    /*电台*/
    MEDIA_TYPE_VIDEO,    /*视频*/
    MEDIA_TYPE_MUSIC,    /*音乐*/
} EumMediaType;

/*电话状态枚举*/
typedef enum
{
    PHONE_STS_NONE,             /*无*/
    PHONE_STS_CALLING,          /*呼叫中*/
    PHONE_STS_INCOMING_CALL,    /*来电*/
    PHONE_STS_CALL_ENDED,       /*通话结束*/
    PHONE_STS_IN_LINE,          /*通话中*/
} EumPhoneSts;

/*电话结构*/
typedef struct
{
    EumPhoneSts phoneSts;   /*电话状态*/
    uint8_t hour;           /*通话小时*/
    uint8_t minute;         /*通话分钟*/
    uint8_t second;         /*通话秒数*/
} StuPhone;

/*电台类型枚举*/
typedef enum
{
    RADIO_TYPE_NONE,        /*无*/
    RADIO_TYPE_AM,          /*AM*/
    RADIO_TYPE_FM,          /*FM*/
    RADIO_TYPE_ONLINE,      /*在线电台*/
} EumRadioType;

/*AM结构*/
typedef struct
{
    uint16_t freBand;   /*频段*/
} StuRadioAM;

/*FM电台搜索结果枚举*/
typedef enum
{
    FM_SEARCH_STS_NONE,     /*未搜索到*/
    FM_SEARCH_STS_PROCESS,  /*搜索中*/
    FM_SEARCH_STS_FINISH    /*搜索完成*/
} EumFMSearchSts;
/*FM结构*/
typedef struct
{
    uint16_t freBand;           /*频段*/
    EumFMSearchSts searchSts;   /*搜索状态*/
} StuRadioFM;

/*在线电台结构*/
typedef struct
{
    uint16_t headtitle;  /*大标题*/
    uint16_t subtitle;   /*小标题*/
} StuRadioOnline;

/*电台结构*/
typedef struct
{
    EumRadioType type;          /*类型*/
    StuRadioAM radioAM;         /*AM*/
    StuRadioFM radioFM;         /*FM*/
    StuRadioOnline radioOnline; /*在线电台*/
} StuRadio;

/*视频结构*/
typedef struct
{
    EumVideoSrc videoSrc;   /*视频源*/
    uint16_t videoName;     /*视频名称*/
} StuVideo;

/*音乐结构*/
typedef struct
{
    EumMusicSrc musicSrc;   /*音乐源*/
    uint16_t musicName;     /*歌曲名*/
    uint16_t singer;        /*歌手*/
} StuMusic;

/**********************
    多媒体
    |——电话
    |——电台
    |   |——AM
    |   |——FM
    |   |——在线电台
    |——视频
    |——音乐
***********************/
/*多媒体结构*/
typedef struct
{
    StuPhone phone; /*电话*/
    StuRadio radio; /*电台*/
    StuVideo video; /*视频*/
    StuMusic music; /*音乐*/
} StuMedia;

/*导航条*/
typedef enum
{
    TITLE_BAR_TIRE,         /*胎压*/
    TITLE_BAR_MUSIC,        /*音乐*/
    TITLE_BAR_HOME,         /*主页*/
    TITLE_BAR_NAVI,         /*导航*/
    TITLE_BAR_ENERGY_FLOW,  /*能量流*/
} EumTitleBar;

typedef struct
{
    float SetSpeed;
    float ActualSpeed;
    float err;
    float err_next;
    float err_last;
    float kp, ki, kd;
} _pid;

/********************************************函数声明********************************************/
void Bottom_Display_Service0(void);
void Bottom_Display_Service(void);

void GUI_Left(void);
void GUI_Middle(void);
void GUI_Right(void);
void GUI_Top1(void);
//void GUI_Top2(void);
//void GUI_AirP1(void);
void GUI_Clock(void);
void GUI_Top4(void);
void GUI_Top5(void);
//void GUI_AirP2(void);
void GUI_Top6(void);
void GUI_Top7(void);
void GUI_Bottm1(void);
void GUI_Bottm2(void);
void GUI_Bottm2P(void);
void GUI_Bottm3(void);
void GUI_Bottm4(void);
void GUI_Bottm5(void);
void GUI_Bottm6(void);
void GUI_Bottm7(void);
void GUI_Bottm8(void);
void GUI_Bottm9(void);
void GUI_Bottm10(void);
void GUI_Bottm11(void);
void GUI_Stop(void);
void GUI_Park(void);
void GUI_Charge(void);

void PID_Parameters_Init(void);
float PID_Realize(float spd, _pid *speed);
uint16_t Speed_Get_CurDisp(void);
void GUI_DisplUpdTimRst(void);

/******************************************************************************
* IGN OFF 清图层
*******************************************************************************/
extern unsigned char GUI_IGNIN_InitSprite_Flag;

void GUI_IGNOFF_ClearSprite_KL30Init(void);
void GUI_IGNOFF_ClearSprite_Enable(void);
void GUI_IGNOFF_DelSprite(void);
void GUI_IGNOFF_ClearSprite(void);

unsigned char GUI_IGNOFF_ClearSpriteFinish(void);
unsigned char GUI_IGNOFF_ClearingSprite(void);

#endif
