/**********************************************************************************************************
* @file    loc_graphics.h
* @author  HZS
* @version V1.0.0
* @date    2020.12.24
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_H_
#define LOC_GRAPHICS_H_

#include "r_typedefs.h"        /* Renesas basic types, e.g. uint32_t */ 

/******************************
WINDOW  SET
******************************/

/******************************
WINDOW  SET
******************************/
#define LOC_NORMAL_W 1280
#define LOC_NORMAL_H 480
#define LOC_NORMAL_PITCH 1280

#define LOC_JPEG_W 1280
#define LOC_JPEG_H 480
#define LOC_JPEGL_PITCH 1280

#define GUI_BLENDMODE_CUSTOM   0
#define GUI_BLENDMODE_SRC_OVER 2

typedef struct
{
    uint32_t MemBase;
    uint32_t WrapBits;
    uint32_t WrapBase;
    uint32_t WrapSize;
    uint32_t Alignment;
} r_cdi_Wrap_t;

typedef enum
{
    Left_Sprite,  
    Middle_Sprite,  
    Right_Sprite, 
    Top1_Sprite,
    //Top2_Sprite,
    //AirP1_Sprite,
    Clock_Sprite,
    Top4_Sprite,
    Top5_Sprite,
    //AirP2_Sprite,
    Top6_Sprite,
    Top7_Sprite,
    Bottm1_Sprite,
    Bottm2_Sprite,
    Bottm2P_Sprite,
    Bottm3_Sprite,
    Bottm4_Sprite,
    Bottm5_Sprite,
    Bottm6_Sprite,
    Bottm7_Sprite,
    //Bottm8_Sprite,
    Bottm9_Sprite,
    Bottm10_Sprite,
    Bottm11_Sprite,
    Stop_Sprite,
    Park_Sprite,
    //Battery_Sprite,
    Charge_Sprite,
    
    Max_Sprite,
} SpriteName_t;

typedef enum
{
    TARGET_FLASH = 0u,
    TARGET_LRAM,
    TARGET_SDRAM,
    TARGET_VRAM,
    TARGET_VRAM_RGB888,
    TARGET_VRAM_ARGB6666,
    TARGET_VRAM_RGB666,
} SpriteTarge_t;

typedef struct
{
    uint16_t     u16ImageID;
    uint16_t     u16PosX;
    uint16_t     u16PosY;
    uint8_t      u8BlendEn;
    uint8_t      u8RotateEn;
    float        i32Angle;
    float        fModulus;
    uint8_t      u8Dir;
    uint8_t      u8AlphaEn;
    int32_t      i32Alpha;
    uint8_t      u8ScaleEn;
    float        fFactor;
    uint8_t      u8UnicodeEn;
    uint32_t     u32UnicodeColor;    
    uint8_t      UnicodeLen;
    uint16_t     *pUnicode;
} LogicLayerAttr_t;

typedef struct
{
    uint16_t     u16JPEGWinWidth;
    uint16_t     u16JPEGWinHeight;
    uint16_t     u16JPEGWinPitch;
    uint16_t     u16LocWinWidth;
    uint16_t     u16LocWinHeight;
    uint16_t     u16LocWinPitch;   
    uint8_t      u8ScreenRefrsh;   //单位Unit = 10ms
    uint8_t      u8NumOfMainScreenSprite;
    uint8_t      u8NumofAllSprite;
    uint16_t     u16NumofImage;
} r_screen_attr_t;

/**********************************************APP**********************************************/
void loc_App(void *pSpriteHandler, void *pScreenAttr);
r_Error_t loc_RenderTexture_Normal(SpriteName_t SpriteID, LogicLayerAttr_t locParam);
r_Error_t loc_Unicode_Normal(SpriteName_t  SpriteID, LogicLayerAttr_t locParam, uint16_t Unicode[], uint8_t Length);
void loc_Disable_Window_App(void);
void loc_Enable_Window_App(void);
void loc_Display_Service(void);   //要求10ms任务调用
void loc_power_off(void);
void loc_memset_LogicLayerAttr(LogicLayerAttr_t *locParam);
void loc_Del_Sprite(SpriteName_t DelStartID, SpriteName_t DelEndID);
void loc_free_mem(uint8_t startID, uint8_t endID);
void loc_enable_mem(uint8_t startID, uint8_t endID);

#endif
