#include "AC_TEMP.h"
#include "CAN_Signal_Rx.h"
/*** 室外温度 ***/
uint16_t AC_Temp_VALUE;
uint8_t AC_Temp_Signed;

/*该服务函数首次KL30是调用一次*/

void Data_AC_Temp_KL30_Init(void)
{
    AC_Temp_VALUE = 0u;
    AC_Temp_Signed = 0u;
}
/*该服务函数KL15是调用一次*/
void Data_AC_Temp_KL15_Init(void)
{
    AC_Temp_VALUE = 0u;
    AC_Temp_Signed = 0u;
}

/******************************************************************************
函数名：Data_Ambient_Temperature_Processing
调用时周期:100ms
功  能: 室外温度数据处理
参  数: 无
返回值：无
******************************************************************************/
void Data_Ambient_Temperature_Processing(void)
{
    uint8_t u8Temp = 0u;
    u8Temp = Get_ID_3D2_Sig_ACCM_ExternalTemp();
    u8Temp = u8Temp >> 1;
    if (u8Temp >= 40)
    {
        u8Temp = u8Temp - 40u;
        AC_Temp_Signed = 0u;
    }
    else
    {
        AC_Temp_Signed = 1u;
        u8Temp = 40u - u8Temp;
    }
    AC_Temp_VALUE = u8Temp;
}
/******************************************************************************
函数名：Get_Ambient_Temperature
功  能: 获得室外温度
******************************************************************************/
uint8_t Get_Ambient_Temperature(void)
{
    return AC_Temp_VALUE;
}
/******************************************************************************
函数名：Get_Ambient_Temperature_DispMode
功  能: 获得室外温度显示模式
******************************************************************************/
uint8_t Get_Ambient_Temperature_DispMode(void)
{
    uint8_t DataAmbientTempDispMode = 0u;
    DataAmbientTempDispMode = AC_Temp_Signed;
    return (uint8_t)DataAmbientTempDispMode;
}

/******************************************************************************
函数名：Get_Ambient_Temperature_DispSign
功  能: 获得室外温度正负温度符号
******************************************************************************/
uint8_t Get_Ambient_Temperature_DispSign(void)
{
    uint8_t DataAmbientTempDispSign = 0u;
    return (uint8_t)DataAmbientTempDispSign;
}
