#include "Data_BtyMinCllVtg.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint16_t BtyMinCllVtg_Value;
uint8_t  BtyMinCllVtg_Valid;

void BtyMinCllVtg_Reset(void)
{
    BtyMinCllVtg_Value  = 0;
    BtyMinCllVtg_Valid  = 0;
}

void BtyMinCllVtg_KL30_Init(void)
{
    BtyMinCllVtg_Reset();
}

void BtyMinCllVtg_KL15_ON_Init(void)
{
    BtyMinCllVtg_Reset();
}

void BtyMinCllVtg_Processing_Service(void)
{
    uint16_t u16Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        BtyMinCllVtg_Reset();
        return;
    }

    u16Result  = Get_ID_18F13EF3_Sig_BMS_BtyMinCllVtg();
    
    if ((u16Result >= 0xFFFE) || (CAN_MSG_Status(ID_BMS_CllBtySts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        BtyMinCllVtg_Valid = 0;
        u16Result          = 0;
    }
    else
    {
        BtyMinCllVtg_Valid = 1;
    }
    
    if (u16Result <= 10000)  //0.001V 
    {
        BtyMinCllVtg_Value = u16Result;
    }
    else
    {
        //超过有效范围保持原值
    }
}

uint16_t BtyMinCllVtg_Get_Value(void)
{
    return BtyMinCllVtg_Value;
}

uint8_t BtyMinCllVtg_Get_Valid(void)
{
    return BtyMinCllVtg_Valid;
}
