#include "Data_DrvMCUTpt.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint8_t DrvMCUTpt_Value;
uint8_t DrvMCUTpt_Sign;
uint8_t DrvMCUTpt_Valid;

void DrvMCUTpt_Reset(void)
{
    DrvMCUTpt_Value = 0;
    DrvMCUTpt_Sign  = 0;
    DrvMCUTpt_Valid = 0;
}

void DrvMCUTpt_KL30_Init(void)
{
    DrvMCUTpt_Reset();
}

void DrvMCUTpt_KL15_ON_Init(void)
{
    DrvMCUTpt_Reset();
}

void DrvMCUTpt_Processing_Service(void)
{
    uint8_t u8Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        DrvMCUTpt_Reset();
        return;
    }

    u8Result  = Get_ID_18F501F0_Sig_VCU_DrvMCUTpt();
    
    if ((u8Result >= 0xFE) || (CAN_MSG_Status(ID_VCU_MCUSts1_Msg_Count) != CAN_SIG_RECEIVE))
    {
        DrvMCUTpt_Valid = 0;
        u8Result        = 0;
    }
    else
    {
        DrvMCUTpt_Valid = 1;
    }

    if (u8Result >= 40) 
    {
        DrvMCUTpt_Sign  = 0;
        u8Result       -= 40;
    }
    else
    {
        DrvMCUTpt_Sign = 1;
        u8Result       = 40 - u8Result;
    }

    DrvMCUTpt_Value = u8Result;
}

uint8_t DrvMCUTpt_Get_Value(void)
{
    return DrvMCUTpt_Value;
}

uint8_t DrvMCUTpt_Get_Sign(void)
{
    return DrvMCUTpt_Sign;
}

uint8_t DrvMCUTpt_Get_Valid(void)
{
    return DrvMCUTpt_Valid;
}
